// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input to an AddInstanceGroups call.
type AddInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// Instance groups to add.
	//
	// InstanceGroups is a required field
	InstanceGroups []InstanceGroupConfig `type:"list" required:"true"`

	// Job flow in which to add the instance groups.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddInstanceGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddInstanceGroupsInput"}

	if s.InstanceGroups == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceGroups"))
	}

	if s.JobFlowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobFlowId"))
	}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Output from an AddInstanceGroups call.
type AddInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// Instance group IDs of the newly created instance groups.
	InstanceGroupIds []string `type:"list"`

	// The job flow ID in which the instance groups are added.
	JobFlowId *string `type:"string"`
}

// String returns the string representation
func (s AddInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opAddInstanceGroups = "AddInstanceGroups"

// AddInstanceGroupsRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Adds one or more instance groups to a running cluster.
//
//    // Example sending a request using AddInstanceGroupsRequest.
//    req := client.AddInstanceGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceGroups
func (c *Client) AddInstanceGroupsRequest(input *AddInstanceGroupsInput) AddInstanceGroupsRequest {
	op := &aws.Operation{
		Name:       opAddInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddInstanceGroupsInput{}
	}

	req := c.newRequest(op, input, &AddInstanceGroupsOutput{})
	return AddInstanceGroupsRequest{Request: req, Input: input, Copy: c.AddInstanceGroupsRequest}
}

// AddInstanceGroupsRequest is the request type for the
// AddInstanceGroups API operation.
type AddInstanceGroupsRequest struct {
	*aws.Request
	Input *AddInstanceGroupsInput
	Copy  func(*AddInstanceGroupsInput) AddInstanceGroupsRequest
}

// Send marshals and sends the AddInstanceGroups API request.
func (r AddInstanceGroupsRequest) Send(ctx context.Context) (*AddInstanceGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddInstanceGroupsResponse{
		AddInstanceGroupsOutput: r.Request.Data.(*AddInstanceGroupsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddInstanceGroupsResponse is the response type for the
// AddInstanceGroups API operation.
type AddInstanceGroupsResponse struct {
	*AddInstanceGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddInstanceGroups request.
func (r *AddInstanceGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
