// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mobileanalytics

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// A container for the data needed for a PutEvent operation
type PutEventsInput struct {
	_ struct{} `type:"structure"`

	// The client context including the client ID, app title, app version and package
	// name.
	//
	// ClientContext is a required field
	ClientContext *string `location:"header" locationName:"x-amz-Client-Context" type:"string" required:"true"`

	// The encoding used for the client context.
	ClientContextEncoding *string `location:"header" locationName:"x-amz-Client-Context-Encoding" type:"string"`

	// An array of Event JSON objects
	//
	// Events is a required field
	Events []Event `locationName:"events" type:"list" required:"true"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEventsInput"}

	if s.ClientContext == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientContext"))
	}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}
	if s.Events != nil {
		for i, v := range s.Events {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Events", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutEventsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "events", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ClientContext != nil {
		v := *s.ClientContext

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Client-Context", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientContextEncoding != nil {
		v := *s.ClientContextEncoding

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-Client-Context-Encoding", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutEventsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutEventsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutEvents = "PutEvents"

// PutEventsRequest returns a request value for making API operation for
// Amazon Mobile Analytics.
//
// The PutEvents operation records one or more events. You can have up to 1,500
// unique custom events per app, any combination of up to 40 attributes and
// metrics per custom event, and any number of attribute or metric values.
//
//    // Example sending a request using PutEventsRequest.
//    req := client.PutEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) PutEventsRequest(input *PutEventsInput) PutEventsRequest {
	op := &aws.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/2014-06-05/events",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	req := c.newRequest(op, input, &PutEventsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutEventsRequest{Request: req, Input: input, Copy: c.PutEventsRequest}
}

// PutEventsRequest is the request type for the
// PutEvents API operation.
type PutEventsRequest struct {
	*aws.Request
	Input *PutEventsInput
	Copy  func(*PutEventsInput) PutEventsRequest
}

// Send marshals and sends the PutEvents API request.
func (r PutEventsRequest) Send(ctx context.Context) (*PutEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEventsResponse{
		PutEventsOutput: r.Request.Data.(*PutEventsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEventsResponse is the response type for the
// PutEvents API operation.
type PutEventsResponse struct {
	*PutEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEvents request.
func (r *PutEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
