// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type AssignVolumeInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// The volume ID.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssignVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignVolumeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssignVolumeInput"}

	if s.VolumeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssignVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssignVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssignVolume = "AssignVolume"

// AssignVolumeRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Assigns one of the stack's registered Amazon EBS volumes to a specified instance.
// The volume must first be registered with the stack by calling RegisterVolume.
// After you register the volume, you must call UpdateVolume to specify a mount
// point before calling AssignVolume. For more information, see Resource Management
// (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using AssignVolumeRequest.
//    req := client.AssignVolumeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignVolume
func (c *Client) AssignVolumeRequest(input *AssignVolumeInput) AssignVolumeRequest {
	op := &aws.Operation{
		Name:       opAssignVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignVolumeInput{}
	}

	req := c.newRequest(op, input, &AssignVolumeOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AssignVolumeRequest{Request: req, Input: input, Copy: c.AssignVolumeRequest}
}

// AssignVolumeRequest is the request type for the
// AssignVolume API operation.
type AssignVolumeRequest struct {
	*aws.Request
	Input *AssignVolumeInput
	Copy  func(*AssignVolumeInput) AssignVolumeRequest
}

// Send marshals and sends the AssignVolume API request.
func (r AssignVolumeRequest) Send(ctx context.Context) (*AssignVolumeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssignVolumeResponse{
		AssignVolumeOutput: r.Request.Data.(*AssignVolumeOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssignVolumeResponse is the response type for the
// AssignVolume API operation.
type AssignVolumeResponse struct {
	*AssignVolumeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssignVolume request.
func (r *AssignVolumeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
