// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeSolutionVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution version.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSolutionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSolutionVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSolutionVersionInput"}

	if s.SolutionVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSolutionVersionOutput struct {
	_ struct{} `type:"structure"`

	// The solution version.
	SolutionVersion *SolutionVersion `locationName:"solutionVersion" type:"structure"`
}

// String returns the string representation
func (s DescribeSolutionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSolutionVersion = "DescribeSolutionVersion"

// DescribeSolutionVersionRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Describes a specific version of a solution. For more information on solutions,
// see CreateSolution.
//
//    // Example sending a request using DescribeSolutionVersionRequest.
//    req := client.DescribeSolutionVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion
func (c *Client) DescribeSolutionVersionRequest(input *DescribeSolutionVersionInput) DescribeSolutionVersionRequest {
	op := &aws.Operation{
		Name:       opDescribeSolutionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSolutionVersionInput{}
	}

	req := c.newRequest(op, input, &DescribeSolutionVersionOutput{})
	return DescribeSolutionVersionRequest{Request: req, Input: input, Copy: c.DescribeSolutionVersionRequest}
}

// DescribeSolutionVersionRequest is the request type for the
// DescribeSolutionVersion API operation.
type DescribeSolutionVersionRequest struct {
	*aws.Request
	Input *DescribeSolutionVersionInput
	Copy  func(*DescribeSolutionVersionInput) DescribeSolutionVersionRequest
}

// Send marshals and sends the DescribeSolutionVersion API request.
func (r DescribeSolutionVersionRequest) Send(ctx context.Context) (*DescribeSolutionVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSolutionVersionResponse{
		DescribeSolutionVersionOutput: r.Request.Data.(*DescribeSolutionVersionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSolutionVersionResponse is the response type for the
// DescribeSolutionVersion API operation.
type DescribeSolutionVersionResponse struct {
	*DescribeSolutionVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSolutionVersion request.
func (r *DescribeSolutionVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
