// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreatePushTemplateInput struct {
	_ struct{} `type:"structure" payload:"PushNotificationTemplateRequest"`

	// Specifies the content and settings for a message template that can be used
	// in messages that are sent through a push notification channel.
	//
	// PushNotificationTemplateRequest is a required field
	PushNotificationTemplateRequest *PushNotificationTemplateRequest `type:"structure" required:"true"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePushTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePushTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePushTemplateInput"}

	if s.PushNotificationTemplateRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("PushNotificationTemplateRequest"))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePushTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PushNotificationTemplateRequest != nil {
		v := s.PushNotificationTemplateRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "PushNotificationTemplateRequest", v, metadata)
	}
	return nil
}

type CreatePushTemplateOutput struct {
	_ struct{} `type:"structure" payload:"CreateTemplateMessageBody"`

	// Provides information about a request to create a message template.
	//
	// CreateTemplateMessageBody is a required field
	CreateTemplateMessageBody *CreateTemplateMessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePushTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePushTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreateTemplateMessageBody != nil {
		v := s.CreateTemplateMessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CreateTemplateMessageBody", v, metadata)
	}
	return nil
}

const opCreatePushTemplate = "CreatePushTemplate"

// CreatePushTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Creates a message template that you can use in messages that are sent through
// a push notification channel.
//
//    // Example sending a request using CreatePushTemplateRequest.
//    req := client.CreatePushTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate
func (c *Client) CreatePushTemplateRequest(input *CreatePushTemplateInput) CreatePushTemplateRequest {
	op := &aws.Operation{
		Name:       opCreatePushTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/templates/{template-name}/push",
	}

	if input == nil {
		input = &CreatePushTemplateInput{}
	}

	req := c.newRequest(op, input, &CreatePushTemplateOutput{})
	return CreatePushTemplateRequest{Request: req, Input: input, Copy: c.CreatePushTemplateRequest}
}

// CreatePushTemplateRequest is the request type for the
// CreatePushTemplate API operation.
type CreatePushTemplateRequest struct {
	*aws.Request
	Input *CreatePushTemplateInput
	Copy  func(*CreatePushTemplateInput) CreatePushTemplateRequest
}

// Send marshals and sends the CreatePushTemplate API request.
func (r CreatePushTemplateRequest) Send(ctx context.Context) (*CreatePushTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePushTemplateResponse{
		CreatePushTemplateOutput: r.Request.Data.(*CreatePushTemplateOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePushTemplateResponse is the response type for the
// CreatePushTemplate API operation.
type CreatePushTemplateResponse struct {
	*CreatePushTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePushTemplate request.
func (r *CreatePushTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
