// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetApplicationDateRangeKpiInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	EndTime *time.Time `location:"querystring" locationName:"end-time" type:"timestamp" timestampFormat:"iso8601"`

	// KpiName is a required field
	KpiName *string `location:"uri" locationName:"kpi-name" type:"string" required:"true"`

	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	StartTime *time.Time `location:"querystring" locationName:"start-time" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetApplicationDateRangeKpiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationDateRangeKpiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetApplicationDateRangeKpiInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.KpiName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KpiName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApplicationDateRangeKpiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KpiName != nil {
		v := *s.KpiName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "kpi-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "end-time",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "page-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "start-time",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	return nil
}

type GetApplicationDateRangeKpiOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationDateRangeKpiResponse"`

	// Provides the results of a query that retrieved the data for a standard metric
	// that applies to an application, and provides information about that query.
	//
	// ApplicationDateRangeKpiResponse is a required field
	ApplicationDateRangeKpiResponse *ApplicationDateRangeKpiResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationDateRangeKpiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApplicationDateRangeKpiOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationDateRangeKpiResponse != nil {
		v := s.ApplicationDateRangeKpiResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ApplicationDateRangeKpiResponse", v, metadata)
	}
	return nil
}

const opGetApplicationDateRangeKpi = "GetApplicationDateRangeKpi"

// GetApplicationDateRangeKpiRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves (queries) pre-aggregated data for a standard metric that applies
// to an application.
//
//    // Example sending a request using GetApplicationDateRangeKpiRequest.
//    req := client.GetApplicationDateRangeKpiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi
func (c *Client) GetApplicationDateRangeKpiRequest(input *GetApplicationDateRangeKpiInput) GetApplicationDateRangeKpiRequest {
	op := &aws.Operation{
		Name:       opGetApplicationDateRangeKpi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/kpis/daterange/{kpi-name}",
	}

	if input == nil {
		input = &GetApplicationDateRangeKpiInput{}
	}

	req := c.newRequest(op, input, &GetApplicationDateRangeKpiOutput{})
	return GetApplicationDateRangeKpiRequest{Request: req, Input: input, Copy: c.GetApplicationDateRangeKpiRequest}
}

// GetApplicationDateRangeKpiRequest is the request type for the
// GetApplicationDateRangeKpi API operation.
type GetApplicationDateRangeKpiRequest struct {
	*aws.Request
	Input *GetApplicationDateRangeKpiInput
	Copy  func(*GetApplicationDateRangeKpiInput) GetApplicationDateRangeKpiRequest
}

// Send marshals and sends the GetApplicationDateRangeKpi API request.
func (r GetApplicationDateRangeKpiRequest) Send(ctx context.Context) (*GetApplicationDateRangeKpiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetApplicationDateRangeKpiResponse{
		GetApplicationDateRangeKpiOutput: r.Request.Data.(*GetApplicationDateRangeKpiOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetApplicationDateRangeKpiResponse is the response type for the
// GetApplicationDateRangeKpi API operation.
type GetApplicationDateRangeKpiResponse struct {
	*GetApplicationDateRangeKpiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetApplicationDateRangeKpi request.
func (r *GetApplicationDateRangeKpiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
