// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeClusterDbRevisionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a cluster whose ClusterDbRevisions you are requesting.
	// This parameter is case sensitive. All clusters defined for an account are
	// returned by default.
	ClusterIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point for returning a set
	// of response records. When the results of a DescribeClusterDbRevisions request
	// exceed the value specified in MaxRecords, Amazon Redshift returns a value
	// in the marker field of the response. You can retrieve the next set of response
	// records by providing the returned marker value in the marker parameter and
	// retrying the request.
	//
	// Constraints: You can specify either the ClusterIdentifier parameter, or the
	// marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in the marker field of the response. You can retrieve the next
	// set of response records by providing the returned marker value in the marker
	// parameter and retrying the request.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeClusterDbRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeClusterDbRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of revisions.
	ClusterDbRevisions []ClusterDbRevision `locationNameList:"ClusterDbRevision" type:"list"`

	// A string representing the starting point for the next set of revisions. If
	// a value is returned in a response, you can retrieve the next set of revisions
	// by providing the value in the marker parameter and retrying the command.
	// If the marker field is empty, all revisions have already been returned.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterDbRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClusterDbRevisions = "DescribeClusterDbRevisions"

// DescribeClusterDbRevisionsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Returns an array of ClusterDbRevision objects.
//
//    // Example sending a request using DescribeClusterDbRevisionsRequest.
//    req := client.DescribeClusterDbRevisionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions
func (c *Client) DescribeClusterDbRevisionsRequest(input *DescribeClusterDbRevisionsInput) DescribeClusterDbRevisionsRequest {
	op := &aws.Operation{
		Name:       opDescribeClusterDbRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterDbRevisionsInput{}
	}

	req := c.newRequest(op, input, &DescribeClusterDbRevisionsOutput{})
	return DescribeClusterDbRevisionsRequest{Request: req, Input: input, Copy: c.DescribeClusterDbRevisionsRequest}
}

// DescribeClusterDbRevisionsRequest is the request type for the
// DescribeClusterDbRevisions API operation.
type DescribeClusterDbRevisionsRequest struct {
	*aws.Request
	Input *DescribeClusterDbRevisionsInput
	Copy  func(*DescribeClusterDbRevisionsInput) DescribeClusterDbRevisionsRequest
}

// Send marshals and sends the DescribeClusterDbRevisions API request.
func (r DescribeClusterDbRevisionsRequest) Send(ctx context.Context) (*DescribeClusterDbRevisionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClusterDbRevisionsResponse{
		DescribeClusterDbRevisionsOutput: r.Request.Data.(*DescribeClusterDbRevisionsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeClusterDbRevisionsResponse is the response type for the
// DescribeClusterDbRevisions API operation.
type DescribeClusterDbRevisionsResponse struct {
	*DescribeClusterDbRevisionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClusterDbRevisions request.
func (r *DescribeClusterDbRevisionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
