// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type DeleteBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the inventory configuration to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInventoryConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketInventoryConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketInventoryConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketInventoryConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteBucketInventoryConfiguration = "DeleteBucketInventoryConfiguration"

// DeleteBucketInventoryConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes an inventory configuration (identified by the inventory ID) from
// the bucket.
//
// To use this operation, you must have permissions to perform the s3:PutInventoryConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// For information about the Amazon S3 inventory feature, see Amazon S3 Inventory
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html).
//
// Operations related to DeleteBucketInventoryConfiguration include:
//
//    * GetBucketInventoryConfiguration
//
//    * PutBucketInventoryConfiguration
//
//    * ListBucketInventoryConfigurations
//
//    // Example sending a request using DeleteBucketInventoryConfigurationRequest.
//    req := client.DeleteBucketInventoryConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfiguration
func (c *Client) DeleteBucketInventoryConfigurationRequest(input *DeleteBucketInventoryConfigurationInput) DeleteBucketInventoryConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketInventoryConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &DeleteBucketInventoryConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteBucketInventoryConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteBucketInventoryConfigurationRequest{Request: req, Input: input, Copy: c.DeleteBucketInventoryConfigurationRequest}
}

// DeleteBucketInventoryConfigurationRequest is the request type for the
// DeleteBucketInventoryConfiguration API operation.
type DeleteBucketInventoryConfigurationRequest struct {
	*aws.Request
	Input *DeleteBucketInventoryConfigurationInput
	Copy  func(*DeleteBucketInventoryConfigurationInput) DeleteBucketInventoryConfigurationRequest
}

// Send marshals and sends the DeleteBucketInventoryConfiguration API request.
func (r DeleteBucketInventoryConfigurationRequest) Send(ctx context.Context) (*DeleteBucketInventoryConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBucketInventoryConfigurationResponse{
		DeleteBucketInventoryConfigurationOutput: r.Request.Data.(*DeleteBucketInventoryConfigurationOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBucketInventoryConfigurationResponse is the response type for the
// DeleteBucketInventoryConfiguration API operation.
type DeleteBucketInventoryConfigurationResponse struct {
	*DeleteBucketInventoryConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBucketInventoryConfiguration request.
func (r *DeleteBucketInventoryConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
