// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateHumanTaskUiInput struct {
	_ struct{} `type:"structure"`

	// The name of the user interface you are creating.
	//
	// HumanTaskUiName is a required field
	HumanTaskUiName *string `min:"1" type:"string" required:"true"`

	// An array of key-value pairs that contain metadata to help you categorize
	// and organize a human review workflow user interface. Each tag consists of
	// a key and a value, both of which you define.
	Tags []Tag `type:"list"`

	// The Liquid template for the worker user interface.
	//
	// UiTemplate is a required field
	UiTemplate *UiTemplate `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateHumanTaskUiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHumanTaskUiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateHumanTaskUiInput"}

	if s.HumanTaskUiName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanTaskUiName"))
	}
	if s.HumanTaskUiName != nil && len(*s.HumanTaskUiName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HumanTaskUiName", 1))
	}

	if s.UiTemplate == nil {
		invalidParams.Add(aws.NewErrParamRequired("UiTemplate"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.UiTemplate != nil {
		if err := s.UiTemplate.Validate(); err != nil {
			invalidParams.AddNested("UiTemplate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateHumanTaskUiOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the human review workflow user interface
	// you create.
	//
	// HumanTaskUiArn is a required field
	HumanTaskUiArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHumanTaskUiOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateHumanTaskUi = "CreateHumanTaskUi"

// CreateHumanTaskUiRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Defines the settings you will use for the human review workflow user interface.
// Reviewers will see a three-panel interface with an instruction area, the
// item to review, and an input area.
//
//    // Example sending a request using CreateHumanTaskUiRequest.
//    req := client.CreateHumanTaskUiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi
func (c *Client) CreateHumanTaskUiRequest(input *CreateHumanTaskUiInput) CreateHumanTaskUiRequest {
	op := &aws.Operation{
		Name:       opCreateHumanTaskUi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHumanTaskUiInput{}
	}

	req := c.newRequest(op, input, &CreateHumanTaskUiOutput{})
	return CreateHumanTaskUiRequest{Request: req, Input: input, Copy: c.CreateHumanTaskUiRequest}
}

// CreateHumanTaskUiRequest is the request type for the
// CreateHumanTaskUi API operation.
type CreateHumanTaskUiRequest struct {
	*aws.Request
	Input *CreateHumanTaskUiInput
	Copy  func(*CreateHumanTaskUiInput) CreateHumanTaskUiRequest
}

// Send marshals and sends the CreateHumanTaskUi API request.
func (r CreateHumanTaskUiRequest) Send(ctx context.Context) (*CreateHumanTaskUiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateHumanTaskUiResponse{
		CreateHumanTaskUiOutput: r.Request.Data.(*CreateHumanTaskUiOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateHumanTaskUiResponse is the response type for the
// CreateHumanTaskUi API operation.
type CreateHumanTaskUiResponse struct {
	*CreateHumanTaskUiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateHumanTaskUi request.
func (r *CreateHumanTaskUiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
