// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/ads/googleads/v3/services/offline_user_data_job_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for
// [OfflineUserDataJobService.CreateOfflineUserDataJobRequest][]
type CreateOfflineUserDataJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer for which to create an offline user data job.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The offline user data job to be created.
	Job *resources.OfflineUserDataJob `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *CreateOfflineUserDataJobRequest) Reset() {
	*x = CreateOfflineUserDataJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOfflineUserDataJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOfflineUserDataJobRequest) ProtoMessage() {}

func (x *CreateOfflineUserDataJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOfflineUserDataJobRequest.ProtoReflect.Descriptor instead.
func (*CreateOfflineUserDataJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateOfflineUserDataJobRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *CreateOfflineUserDataJobRequest) GetJob() *resources.OfflineUserDataJob {
	if x != nil {
		return x.Job
	}
	return nil
}

// Response message for
// [OfflineUserDataJobService.CreateOfflineUserDataJobResponse][]
type CreateOfflineUserDataJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the OfflineUserDataJob.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *CreateOfflineUserDataJobResponse) Reset() {
	*x = CreateOfflineUserDataJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOfflineUserDataJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOfflineUserDataJobResponse) ProtoMessage() {}

func (x *CreateOfflineUserDataJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOfflineUserDataJobResponse.ProtoReflect.Descriptor instead.
func (*CreateOfflineUserDataJobResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateOfflineUserDataJobResponse) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [OfflineUserDataJobService.GetOfflineUserDataJob][google.ads.googleads.v3.services.OfflineUserDataJobService.GetOfflineUserDataJob]
type GetOfflineUserDataJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the OfflineUserDataJob to get.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *GetOfflineUserDataJobRequest) Reset() {
	*x = GetOfflineUserDataJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOfflineUserDataJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOfflineUserDataJobRequest) ProtoMessage() {}

func (x *GetOfflineUserDataJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOfflineUserDataJobRequest.ProtoReflect.Descriptor instead.
func (*GetOfflineUserDataJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetOfflineUserDataJobRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for [OfflineUserDataJobService.RunOfflineUserDataJob][google.ads.googleads.v3.services.OfflineUserDataJobService.RunOfflineUserDataJob]
type RunOfflineUserDataJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the OfflineUserDataJob to run.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *RunOfflineUserDataJobRequest) Reset() {
	*x = RunOfflineUserDataJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunOfflineUserDataJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunOfflineUserDataJobRequest) ProtoMessage() {}

func (x *RunOfflineUserDataJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunOfflineUserDataJobRequest.ProtoReflect.Descriptor instead.
func (*RunOfflineUserDataJobRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP(), []int{3}
}

func (x *RunOfflineUserDataJobRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Request message for
// [OfflineUserDataJobService.AddOfflineUserDataJobOperations][google.ads.googleads.v3.services.OfflineUserDataJobService.AddOfflineUserDataJobOperations]
type AddOfflineUserDataJobOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the OfflineUserDataJob.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// True to enable partial failure for the offline user data job.
	EnablePartialFailure *wrappers.BoolValue `protobuf:"bytes,2,opt,name=enable_partial_failure,json=enablePartialFailure,proto3" json:"enable_partial_failure,omitempty"`
	// Required. The list of operations to be done.
	Operations []*OfflineUserDataJobOperation `protobuf:"bytes,3,rep,name=operations,proto3" json:"operations,omitempty"`
}

func (x *AddOfflineUserDataJobOperationsRequest) Reset() {
	*x = AddOfflineUserDataJobOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddOfflineUserDataJobOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddOfflineUserDataJobOperationsRequest) ProtoMessage() {}

func (x *AddOfflineUserDataJobOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddOfflineUserDataJobOperationsRequest.ProtoReflect.Descriptor instead.
func (*AddOfflineUserDataJobOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP(), []int{4}
}

func (x *AddOfflineUserDataJobOperationsRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *AddOfflineUserDataJobOperationsRequest) GetEnablePartialFailure() *wrappers.BoolValue {
	if x != nil {
		return x.EnablePartialFailure
	}
	return nil
}

func (x *AddOfflineUserDataJobOperationsRequest) GetOperations() []*OfflineUserDataJobOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

// Operation to be made for the AddOfflineUserDataJobOperationsRequest.
type OfflineUserDataJobOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation to be made for the AddOfflineUserDataJobOperationsRequest.
	//
	// Types that are assignable to Operation:
	//	*OfflineUserDataJobOperation_Create
	//	*OfflineUserDataJobOperation_Remove
	//	*OfflineUserDataJobOperation_RemoveAll
	Operation isOfflineUserDataJobOperation_Operation `protobuf_oneof:"operation"`
}

func (x *OfflineUserDataJobOperation) Reset() {
	*x = OfflineUserDataJobOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OfflineUserDataJobOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OfflineUserDataJobOperation) ProtoMessage() {}

func (x *OfflineUserDataJobOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OfflineUserDataJobOperation.ProtoReflect.Descriptor instead.
func (*OfflineUserDataJobOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP(), []int{5}
}

func (m *OfflineUserDataJobOperation) GetOperation() isOfflineUserDataJobOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *OfflineUserDataJobOperation) GetCreate() *common.UserData {
	if x, ok := x.GetOperation().(*OfflineUserDataJobOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (x *OfflineUserDataJobOperation) GetRemove() *common.UserData {
	if x, ok := x.GetOperation().(*OfflineUserDataJobOperation_Remove); ok {
		return x.Remove
	}
	return nil
}

func (x *OfflineUserDataJobOperation) GetRemoveAll() bool {
	if x, ok := x.GetOperation().(*OfflineUserDataJobOperation_RemoveAll); ok {
		return x.RemoveAll
	}
	return false
}

type isOfflineUserDataJobOperation_Operation interface {
	isOfflineUserDataJobOperation_Operation()
}

type OfflineUserDataJobOperation_Create struct {
	// Add the provided data to the transaction. Data cannot be retrieved after
	// being uploaded.
	Create *common.UserData `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type OfflineUserDataJobOperation_Remove struct {
	// Remove the provided data from the transaction. Data cannot be retrieved
	// after being uploaded.
	Remove *common.UserData `protobuf:"bytes,2,opt,name=remove,proto3,oneof"`
}

type OfflineUserDataJobOperation_RemoveAll struct {
	// Remove all previously provided data. This is only supported for Customer
	// Match.
	RemoveAll bool `protobuf:"varint,3,opt,name=remove_all,json=removeAll,proto3,oneof"`
}

func (*OfflineUserDataJobOperation_Create) isOfflineUserDataJobOperation_Operation() {}

func (*OfflineUserDataJobOperation_Remove) isOfflineUserDataJobOperation_Operation() {}

func (*OfflineUserDataJobOperation_RemoveAll) isOfflineUserDataJobOperation_Operation() {}

// Response message for
// [OfflineUserDataJobService.AddOfflineUserDataJobOperations][google.ads.googleads.v3.services.OfflineUserDataJobService.AddOfflineUserDataJobOperations]
type AddOfflineUserDataJobOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,1,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
}

func (x *AddOfflineUserDataJobOperationsResponse) Reset() {
	*x = AddOfflineUserDataJobOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddOfflineUserDataJobOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddOfflineUserDataJobOperationsResponse) ProtoMessage() {}

func (x *AddOfflineUserDataJobOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddOfflineUserDataJobOperationsResponse.ProtoReflect.Descriptor instead.
func (*AddOfflineUserDataJobOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP(), []int{6}
}

func (x *AddOfflineUserDataJobOperationsResponse) GetPartialFailureError() *status.Status {
	if x != nil {
		return x.PartialFailureError
	}
	return nil
}

var File_google_ads_googleads_v3_services_offline_user_data_job_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x95, 0x01, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x6c, 0x69,
	0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x4c, 0x0a, 0x03, 0x6a, 0x6f,
	0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4f, 0x66, 0x66, 0x6c,
	0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x47, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74,
	0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x78, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x58, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x6c, 0x69,
	0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x78, 0x0a, 0x1c, 0x52,
	0x75, 0x6e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74,
	0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x26, 0x41, 0x64, 0x64, 0x4f, 0x66, 0x66,
	0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x58, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x16, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x62, 0x0a, 0x0a,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xd3, 0x01, 0x0a, 0x1b, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x42, 0x0a, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x06, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00,
	0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x6c, 0x6c, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0x0a, 0x27, 0x41, 0x64, 0x64, 0x4f, 0x66, 0x66,
	0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x46, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x32, 0xb8, 0x08, 0x0a, 0x19, 0x4f, 0x66,
	0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf8, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74,
	0x61, 0x4a, 0x6f, 0x62, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x66,
	0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x3d,
	0x2a, 0x7d, 0x2f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61,
	0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6a,
	0x6f, 0x62, 0x12, 0xdd, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x47, 0x65, 0x74, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61,
	0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x4a, 0x6f, 0x62, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x66, 0x66, 0x6c,
	0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xa1, 0x02, 0x0a, 0x1f, 0x41, 0x64, 0x64, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x4f, 0x66, 0x66,
	0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x69, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x48, 0x22, 0x43, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x18, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xfe, 0x01, 0x0a, 0x15, 0x52, 0x75, 0x6e, 0x4f, 0x66,
	0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x52, 0x75, 0x6e, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x85, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x39, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x75, 0x6e, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x85, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x33, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x1e, 0x4f,
	0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x4a, 0x6f,
	0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x33, 0x5c, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a,
	0x56, 0x33, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescData = file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDesc
)

func file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDescData
}

var file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_goTypes = []interface{}{
	(*CreateOfflineUserDataJobRequest)(nil),         // 0: google.ads.googleads.v3.services.CreateOfflineUserDataJobRequest
	(*CreateOfflineUserDataJobResponse)(nil),        // 1: google.ads.googleads.v3.services.CreateOfflineUserDataJobResponse
	(*GetOfflineUserDataJobRequest)(nil),            // 2: google.ads.googleads.v3.services.GetOfflineUserDataJobRequest
	(*RunOfflineUserDataJobRequest)(nil),            // 3: google.ads.googleads.v3.services.RunOfflineUserDataJobRequest
	(*AddOfflineUserDataJobOperationsRequest)(nil),  // 4: google.ads.googleads.v3.services.AddOfflineUserDataJobOperationsRequest
	(*OfflineUserDataJobOperation)(nil),             // 5: google.ads.googleads.v3.services.OfflineUserDataJobOperation
	(*AddOfflineUserDataJobOperationsResponse)(nil), // 6: google.ads.googleads.v3.services.AddOfflineUserDataJobOperationsResponse
	(*resources.OfflineUserDataJob)(nil),            // 7: google.ads.googleads.v3.resources.OfflineUserDataJob
	(*wrappers.BoolValue)(nil),                      // 8: google.protobuf.BoolValue
	(*common.UserData)(nil),                         // 9: google.ads.googleads.v3.common.UserData
	(*status.Status)(nil),                           // 10: google.rpc.Status
	(*longrunning.Operation)(nil),                   // 11: google.longrunning.Operation
}
var file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_depIdxs = []int32{
	7,  // 0: google.ads.googleads.v3.services.CreateOfflineUserDataJobRequest.job:type_name -> google.ads.googleads.v3.resources.OfflineUserDataJob
	8,  // 1: google.ads.googleads.v3.services.AddOfflineUserDataJobOperationsRequest.enable_partial_failure:type_name -> google.protobuf.BoolValue
	5,  // 2: google.ads.googleads.v3.services.AddOfflineUserDataJobOperationsRequest.operations:type_name -> google.ads.googleads.v3.services.OfflineUserDataJobOperation
	9,  // 3: google.ads.googleads.v3.services.OfflineUserDataJobOperation.create:type_name -> google.ads.googleads.v3.common.UserData
	9,  // 4: google.ads.googleads.v3.services.OfflineUserDataJobOperation.remove:type_name -> google.ads.googleads.v3.common.UserData
	10, // 5: google.ads.googleads.v3.services.AddOfflineUserDataJobOperationsResponse.partial_failure_error:type_name -> google.rpc.Status
	0,  // 6: google.ads.googleads.v3.services.OfflineUserDataJobService.CreateOfflineUserDataJob:input_type -> google.ads.googleads.v3.services.CreateOfflineUserDataJobRequest
	2,  // 7: google.ads.googleads.v3.services.OfflineUserDataJobService.GetOfflineUserDataJob:input_type -> google.ads.googleads.v3.services.GetOfflineUserDataJobRequest
	4,  // 8: google.ads.googleads.v3.services.OfflineUserDataJobService.AddOfflineUserDataJobOperations:input_type -> google.ads.googleads.v3.services.AddOfflineUserDataJobOperationsRequest
	3,  // 9: google.ads.googleads.v3.services.OfflineUserDataJobService.RunOfflineUserDataJob:input_type -> google.ads.googleads.v3.services.RunOfflineUserDataJobRequest
	1,  // 10: google.ads.googleads.v3.services.OfflineUserDataJobService.CreateOfflineUserDataJob:output_type -> google.ads.googleads.v3.services.CreateOfflineUserDataJobResponse
	7,  // 11: google.ads.googleads.v3.services.OfflineUserDataJobService.GetOfflineUserDataJob:output_type -> google.ads.googleads.v3.resources.OfflineUserDataJob
	6,  // 12: google.ads.googleads.v3.services.OfflineUserDataJobService.AddOfflineUserDataJobOperations:output_type -> google.ads.googleads.v3.services.AddOfflineUserDataJobOperationsResponse
	11, // 13: google.ads.googleads.v3.services.OfflineUserDataJobService.RunOfflineUserDataJob:output_type -> google.longrunning.Operation
	10, // [10:14] is the sub-list for method output_type
	6,  // [6:10] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_init() }
func file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_init() {
	if File_google_ads_googleads_v3_services_offline_user_data_job_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateOfflineUserDataJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateOfflineUserDataJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOfflineUserDataJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunOfflineUserDataJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddOfflineUserDataJobOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OfflineUserDataJobOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddOfflineUserDataJobOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*OfflineUserDataJobOperation_Create)(nil),
		(*OfflineUserDataJobOperation_Remove)(nil),
		(*OfflineUserDataJobOperation_RemoveAll)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v3_services_offline_user_data_job_service_proto = out.File
	file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_rawDesc = nil
	file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_goTypes = nil
	file_google_ads_googleads_v3_services_offline_user_data_job_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// OfflineUserDataJobServiceClient is the client API for OfflineUserDataJobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OfflineUserDataJobServiceClient interface {
	// Creates an offline user data job.
	CreateOfflineUserDataJob(ctx context.Context, in *CreateOfflineUserDataJobRequest, opts ...grpc.CallOption) (*CreateOfflineUserDataJobResponse, error)
	// Returns the offline user data job.
	GetOfflineUserDataJob(ctx context.Context, in *GetOfflineUserDataJobRequest, opts ...grpc.CallOption) (*resources.OfflineUserDataJob, error)
	// Adds operations to the offline user data job.
	AddOfflineUserDataJobOperations(ctx context.Context, in *AddOfflineUserDataJobOperationsRequest, opts ...grpc.CallOption) (*AddOfflineUserDataJobOperationsResponse, error)
	// Runs the offline user data job.
	//
	// When finished, the long running operation will contain the processing
	// result or failure information, if any.
	RunOfflineUserDataJob(ctx context.Context, in *RunOfflineUserDataJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type offlineUserDataJobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOfflineUserDataJobServiceClient(cc grpc.ClientConnInterface) OfflineUserDataJobServiceClient {
	return &offlineUserDataJobServiceClient{cc}
}

func (c *offlineUserDataJobServiceClient) CreateOfflineUserDataJob(ctx context.Context, in *CreateOfflineUserDataJobRequest, opts ...grpc.CallOption) (*CreateOfflineUserDataJobResponse, error) {
	out := new(CreateOfflineUserDataJobResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.OfflineUserDataJobService/CreateOfflineUserDataJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *offlineUserDataJobServiceClient) GetOfflineUserDataJob(ctx context.Context, in *GetOfflineUserDataJobRequest, opts ...grpc.CallOption) (*resources.OfflineUserDataJob, error) {
	out := new(resources.OfflineUserDataJob)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.OfflineUserDataJobService/GetOfflineUserDataJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *offlineUserDataJobServiceClient) AddOfflineUserDataJobOperations(ctx context.Context, in *AddOfflineUserDataJobOperationsRequest, opts ...grpc.CallOption) (*AddOfflineUserDataJobOperationsResponse, error) {
	out := new(AddOfflineUserDataJobOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.OfflineUserDataJobService/AddOfflineUserDataJobOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *offlineUserDataJobServiceClient) RunOfflineUserDataJob(ctx context.Context, in *RunOfflineUserDataJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.OfflineUserDataJobService/RunOfflineUserDataJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OfflineUserDataJobServiceServer is the server API for OfflineUserDataJobService service.
type OfflineUserDataJobServiceServer interface {
	// Creates an offline user data job.
	CreateOfflineUserDataJob(context.Context, *CreateOfflineUserDataJobRequest) (*CreateOfflineUserDataJobResponse, error)
	// Returns the offline user data job.
	GetOfflineUserDataJob(context.Context, *GetOfflineUserDataJobRequest) (*resources.OfflineUserDataJob, error)
	// Adds operations to the offline user data job.
	AddOfflineUserDataJobOperations(context.Context, *AddOfflineUserDataJobOperationsRequest) (*AddOfflineUserDataJobOperationsResponse, error)
	// Runs the offline user data job.
	//
	// When finished, the long running operation will contain the processing
	// result or failure information, if any.
	RunOfflineUserDataJob(context.Context, *RunOfflineUserDataJobRequest) (*longrunning.Operation, error)
}

// UnimplementedOfflineUserDataJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedOfflineUserDataJobServiceServer struct {
}

func (*UnimplementedOfflineUserDataJobServiceServer) CreateOfflineUserDataJob(context.Context, *CreateOfflineUserDataJobRequest) (*CreateOfflineUserDataJobResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateOfflineUserDataJob not implemented")
}
func (*UnimplementedOfflineUserDataJobServiceServer) GetOfflineUserDataJob(context.Context, *GetOfflineUserDataJobRequest) (*resources.OfflineUserDataJob, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetOfflineUserDataJob not implemented")
}
func (*UnimplementedOfflineUserDataJobServiceServer) AddOfflineUserDataJobOperations(context.Context, *AddOfflineUserDataJobOperationsRequest) (*AddOfflineUserDataJobOperationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddOfflineUserDataJobOperations not implemented")
}
func (*UnimplementedOfflineUserDataJobServiceServer) RunOfflineUserDataJob(context.Context, *RunOfflineUserDataJobRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RunOfflineUserDataJob not implemented")
}

func RegisterOfflineUserDataJobServiceServer(s *grpc.Server, srv OfflineUserDataJobServiceServer) {
	s.RegisterService(&_OfflineUserDataJobService_serviceDesc, srv)
}

func _OfflineUserDataJobService_CreateOfflineUserDataJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOfflineUserDataJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OfflineUserDataJobServiceServer).CreateOfflineUserDataJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.OfflineUserDataJobService/CreateOfflineUserDataJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OfflineUserDataJobServiceServer).CreateOfflineUserDataJob(ctx, req.(*CreateOfflineUserDataJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OfflineUserDataJobService_GetOfflineUserDataJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOfflineUserDataJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OfflineUserDataJobServiceServer).GetOfflineUserDataJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.OfflineUserDataJobService/GetOfflineUserDataJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OfflineUserDataJobServiceServer).GetOfflineUserDataJob(ctx, req.(*GetOfflineUserDataJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OfflineUserDataJobService_AddOfflineUserDataJobOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddOfflineUserDataJobOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OfflineUserDataJobServiceServer).AddOfflineUserDataJobOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.OfflineUserDataJobService/AddOfflineUserDataJobOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OfflineUserDataJobServiceServer).AddOfflineUserDataJobOperations(ctx, req.(*AddOfflineUserDataJobOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OfflineUserDataJobService_RunOfflineUserDataJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunOfflineUserDataJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OfflineUserDataJobServiceServer).RunOfflineUserDataJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.OfflineUserDataJobService/RunOfflineUserDataJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OfflineUserDataJobServiceServer).RunOfflineUserDataJob(ctx, req.(*RunOfflineUserDataJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OfflineUserDataJobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.OfflineUserDataJobService",
	HandlerType: (*OfflineUserDataJobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateOfflineUserDataJob",
			Handler:    _OfflineUserDataJobService_CreateOfflineUserDataJob_Handler,
		},
		{
			MethodName: "GetOfflineUserDataJob",
			Handler:    _OfflineUserDataJobService_GetOfflineUserDataJob_Handler,
		},
		{
			MethodName: "AddOfflineUserDataJobOperations",
			Handler:    _OfflineUserDataJobService_AddOfflineUserDataJobOperations_Handler,
		},
		{
			MethodName: "RunOfflineUserDataJob",
			Handler:    _OfflineUserDataJobService_RunOfflineUserDataJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/offline_user_data_job_service.proto",
}
