// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/api/console/v1"
	scheme "github.com/openshift/client-go/console/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ConsoleYAMLSamplesGetter has a method to return a ConsoleYAMLSampleInterface.
// A group's client should implement this interface.
type ConsoleYAMLSamplesGetter interface {
	ConsoleYAMLSamples() ConsoleYAMLSampleInterface
}

// ConsoleYAMLSampleInterface has methods to work with ConsoleYAMLSample resources.
type ConsoleYAMLSampleInterface interface {
	Create(ctx context.Context, consoleYAMLSample *v1.ConsoleYAMLSample, opts metav1.CreateOptions) (*v1.ConsoleYAMLSample, error)
	Update(ctx context.Context, consoleYAMLSample *v1.ConsoleYAMLSample, opts metav1.UpdateOptions) (*v1.ConsoleYAMLSample, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ConsoleYAMLSample, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ConsoleYAMLSampleList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ConsoleYAMLSample, err error)
	ConsoleYAMLSampleExpansion
}

// consoleYAMLSamples implements ConsoleYAMLSampleInterface
type consoleYAMLSamples struct {
	client rest.Interface
}

// newConsoleYAMLSamples returns a ConsoleYAMLSamples
func newConsoleYAMLSamples(c *ConsoleV1Client) *consoleYAMLSamples {
	return &consoleYAMLSamples{
		client: c.RESTClient(),
	}
}

// Get takes name of the consoleYAMLSample, and returns the corresponding consoleYAMLSample object, and an error if there is any.
func (c *consoleYAMLSamples) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Get().
		Resource("consoleyamlsamples").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ConsoleYAMLSamples that match those selectors.
func (c *consoleYAMLSamples) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ConsoleYAMLSampleList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ConsoleYAMLSampleList{}
	err = c.client.Get().
		Resource("consoleyamlsamples").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested consoleYAMLSamples.
func (c *consoleYAMLSamples) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("consoleyamlsamples").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a consoleYAMLSample and creates it.  Returns the server's representation of the consoleYAMLSample, and an error, if there is any.
func (c *consoleYAMLSamples) Create(ctx context.Context, consoleYAMLSample *v1.ConsoleYAMLSample, opts metav1.CreateOptions) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Post().
		Resource("consoleyamlsamples").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(consoleYAMLSample).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a consoleYAMLSample and updates it. Returns the server's representation of the consoleYAMLSample, and an error, if there is any.
func (c *consoleYAMLSamples) Update(ctx context.Context, consoleYAMLSample *v1.ConsoleYAMLSample, opts metav1.UpdateOptions) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Put().
		Resource("consoleyamlsamples").
		Name(consoleYAMLSample.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(consoleYAMLSample).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the consoleYAMLSample and deletes it. Returns an error if one occurs.
func (c *consoleYAMLSamples) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("consoleyamlsamples").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *consoleYAMLSamples) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("consoleyamlsamples").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched consoleYAMLSample.
func (c *consoleYAMLSamples) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Patch(pt).
		Resource("consoleyamlsamples").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
