/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import com.google.common.collect.Interner;
import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.RootBuildCacheControllerRef;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.GZipBuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.TarBuildCacheEntryPacker;
import org.gradle.caching.internal.services.BuildCacheControllerFactory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.network.HostnameLookup;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;

public class BuildCacheServices {
    private static final String GRADLE_VERSION_KEY = "gradleVersion";

    BuildCacheEntryPacker createResultPacker(Deleter deleter, FileSystem fileSystem, StreamHasher fileHasher, StringInterner stringInterner) {
        return new GZipBuildCacheEntryPacker((BuildCacheEntryPacker)new TarBuildCacheEntryPacker(deleter, fileSystem, fileHasher, (Interner)stringInterner));
    }

    OriginMetadataFactory createOriginMetadataFactory(BuildInvocationScopeId buildInvocationScopeId, GradleInternal gradleInternal, HostnameLookup hostnameLookup) {
        File rootDir = gradleInternal.getRootProject().getRootDir();
        return new OriginMetadataFactory(rootDir, SystemProperties.getInstance().getUserName(), OperatingSystem.current().getName(), buildInvocationScopeId.getId().asString(), properties -> properties.setProperty(GRADLE_VERSION_KEY, GradleVersion.current().getVersion()), () -> ((HostnameLookup)hostnameLookup).getHostname());
    }

    BuildCacheCommandFactory createBuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, VirtualFileSystem virtualFileSystem, StringInterner stringInterner) {
        return new BuildCacheCommandFactory(packer, originMetadataFactory, virtualFileSystem, (Interner)stringInterner);
    }

    BuildCacheController createBuildCacheController(ServiceRegistry serviceRegistry, BuildCacheConfigurationInternal buildCacheConfiguration, BuildOperationExecutor buildOperationExecutor, InstantiatorFactory instantiatorFactory, GradleInternal gradle, RootBuildCacheControllerRef rootControllerRef) {
        if (this.isRoot(gradle) || this.isGradleBuildTaskRoot(rootControllerRef)) {
            return this.doCreateBuildCacheController(serviceRegistry, buildCacheConfiguration, buildOperationExecutor, instantiatorFactory, gradle);
        }
        return rootControllerRef.getForNonRootBuild();
    }

    private boolean isGradleBuildTaskRoot(RootBuildCacheControllerRef rootControllerRef) {
        return !rootControllerRef.isSet();
    }

    private boolean isRoot(GradleInternal gradle) {
        return gradle.getParent() == null;
    }

    private BuildCacheController doCreateBuildCacheController(ServiceRegistry serviceRegistry, BuildCacheConfigurationInternal buildCacheConfiguration, BuildOperationExecutor buildOperationExecutor, InstantiatorFactory instantiatorFactory, GradleInternal gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        Path buildIdentityPath = gradle.getIdentityPath();
        File gradleUserHomeDir = gradle.getGradleUserHomeDir();
        BuildCacheControllerFactory.BuildCacheMode buildCacheMode = startParameter.isBuildCacheEnabled() ? BuildCacheControllerFactory.BuildCacheMode.ENABLED : BuildCacheControllerFactory.BuildCacheMode.DISABLED;
        BuildCacheControllerFactory.RemoteAccessMode remoteAccessMode = startParameter.isOffline() ? BuildCacheControllerFactory.RemoteAccessMode.OFFLINE : BuildCacheControllerFactory.RemoteAccessMode.ONLINE;
        boolean logStackTraces = startParameter.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
        boolean emitDebugLogging = startParameter.isBuildCacheDebugLogging();
        return BuildCacheControllerFactory.create(buildOperationExecutor, buildIdentityPath, gradleUserHomeDir, buildCacheConfiguration, buildCacheMode, remoteAccessMode, logStackTraces, emitDebugLogging, (Instantiator)instantiatorFactory.inject((ServiceLookup)serviceRegistry));
    }
}

