/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.process.internal.util.LongCommandLineDetectionUtil;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class JavaExecHandleBuilder
extends AbstractExecHandleBuilder
implements JavaExecSpec {
    private static final Logger LOGGER = Logging.getLogger(JavaExecHandleBuilder.class);
    private final FileCollectionFactory fileCollectionFactory;
    private String mainClass;
    private final List<Object> applicationArgs = new ArrayList<Object>();
    private ConfigurableFileCollection classpath;
    private final JavaForkOptions javaOptions;
    private final List<CommandLineArgumentProvider> argumentProviders = new ArrayList<CommandLineArgumentProvider>();

    public JavaExecHandleBuilder(FileResolver fileResolver, FileCollectionFactory fileCollectionFactory, Executor executor, BuildCancellationToken buildCancellationToken, JavaForkOptions javaOptions) {
        super((PathToFileResolver)fileResolver, executor, buildCancellationToken);
        this.fileCollectionFactory = fileCollectionFactory;
        this.javaOptions = javaOptions;
        this.executable(javaOptions.getExecutable());
    }

    public List<String> getAllJvmArgs() {
        return this.getAllJvmArgs((FileCollection)this.classpath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getAllJvmArgs(FileCollection realClasspath) {
        ArrayList<String> allArgs = new ArrayList<String>(this.javaOptions.getAllJvmArgs());
        if (this.mainClass == null) {
            if (realClasspath == null || realClasspath.getFiles().size() != 1) throw new IllegalStateException("No main class specified and classpath is not an executable jar.");
            allArgs.add("-jar");
            allArgs.add(realClasspath.getSingleFile().getAbsolutePath());
            return allArgs;
        } else {
            if (realClasspath != null && !realClasspath.isEmpty()) {
                allArgs.add("-cp");
                allArgs.add(CollectionUtils.join((String)File.pathSeparator, (Iterable)realClasspath));
            }
            allArgs.add(this.mainClass);
        }
        return allArgs;
    }

    public void setAllJvmArgs(List<String> arguments) {
        throw new UnsupportedOperationException();
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        throw new UnsupportedOperationException();
    }

    public List<String> getJvmArgs() {
        return this.javaOptions.getJvmArgs();
    }

    public void setJvmArgs(List<String> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    public JavaExecHandleBuilder jvmArgs(Iterable<?> arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    public JavaExecHandleBuilder jvmArgs(Object ... arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    public Map<String, Object> getSystemProperties() {
        return this.javaOptions.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.javaOptions.setSystemProperties(properties);
    }

    public JavaExecHandleBuilder systemProperties(Map<String, ?> properties) {
        this.javaOptions.systemProperties(properties);
        return this;
    }

    public JavaExecHandleBuilder systemProperty(String name, Object value) {
        this.javaOptions.systemProperty(name, value);
        return this;
    }

    public FileCollection getBootstrapClasspath() {
        return this.javaOptions.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaOptions.setBootstrapClasspath(classpath);
    }

    public JavaForkOptions bootstrapClasspath(Object ... classpath) {
        this.javaOptions.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.javaOptions.getMinHeapSize();
    }

    public void setMinHeapSize(String heapSize) {
        this.javaOptions.setMinHeapSize(heapSize);
    }

    public String getDefaultCharacterEncoding() {
        return this.javaOptions.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.javaOptions.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public String getMaxHeapSize() {
        return this.javaOptions.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.javaOptions.setMaxHeapSize(heapSize);
    }

    public boolean getEnableAssertions() {
        return this.javaOptions.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.javaOptions.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.javaOptions.getDebug();
    }

    public void setDebug(boolean enabled) {
        this.javaOptions.setDebug(enabled);
    }

    public JavaDebugOptions getDebugOptions() {
        return this.javaOptions.getDebugOptions();
    }

    public void debugOptions(Action<JavaDebugOptions> action) {
        this.javaOptions.debugOptions(action);
    }

    public String getMain() {
        return this.mainClass;
    }

    public JavaExecHandleBuilder setMain(String mainClassName) {
        this.mainClass = mainClassName;
        return this;
    }

    @Nonnull
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object applicationArg : this.applicationArgs) {
            args.add(applicationArg.toString());
        }
        return args;
    }

    public JavaExecHandleBuilder setArgs(List<String> applicationArgs) {
        this.applicationArgs.clear();
        this.args(applicationArgs);
        return this;
    }

    public JavaExecHandleBuilder setArgs(Iterable<?> applicationArgs) {
        this.applicationArgs.clear();
        this.args(applicationArgs);
        return this;
    }

    public JavaExecHandleBuilder args(Object ... args) {
        this.args(Arrays.asList(args));
        return this;
    }

    public JavaExecSpec args(Iterable<?> args) {
        GUtil.addToCollection(this.applicationArgs, (boolean)true, (Iterable[])new Iterable[]{args});
        return this;
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.argumentProviders;
    }

    public JavaExecHandleBuilder setClasspath(FileCollection classpath) {
        ConfigurableFileCollection newClasspath = this.fileCollectionFactory.configurableFiles("classpath");
        newClasspath.setFrom((Iterable)classpath);
        this.classpath = newClasspath;
        return this;
    }

    public JavaExecHandleBuilder classpath(Object ... paths) {
        this.doGetClasspath().from(paths);
        return this;
    }

    public FileCollection getClasspath() {
        return this.doGetClasspath();
    }

    private ConfigurableFileCollection doGetClasspath() {
        if (this.classpath == null) {
            this.classpath = this.fileCollectionFactory.configurableFiles("classpath");
        }
        return this.classpath;
    }

    @Override
    public List<String> getAllArguments() {
        return this.getAllArguments((FileCollection)this.classpath);
    }

    private List<String> getAllArguments(FileCollection realClasspath) {
        ArrayList<String> arguments = new ArrayList<String>(this.getAllJvmArgs(realClasspath));
        arguments.addAll(this.getArgs());
        for (CommandLineArgumentProvider argumentProvider : this.argumentProviders) {
            Iterables.addAll(arguments, (Iterable)argumentProvider.asArguments());
        }
        return arguments;
    }

    @Override
    protected List<String> getEffectiveArguments() {
        List<String> arguments = this.getAllArguments();
        if (LongCommandLineDetectionUtil.hasCommandLineExceedMaxLength(this.getExecutable(), arguments)) {
            try {
                File pathingJarFile = this.writePathingJarFile((FileCollection)this.classpath);
                ConfigurableFileCollection shortenedClasspath = this.fileCollectionFactory.configurableFiles();
                shortenedClasspath.from(new Object[]{pathingJarFile});
                List<String> shortenedArguments = this.getAllArguments((FileCollection)shortenedClasspath);
                LOGGER.info("Shortening Java classpath {} with {}", (Object)this.classpath.getFiles(), (Object)pathingJarFile);
                return shortenedArguments;
            }
            catch (IOException e) {
                LOGGER.info("Pathing JAR could not be created, Gradle cannot shorten the command line.", (Throwable)e);
            }
        }
        return arguments;
    }

    private File writePathingJarFile(FileCollection classPath) throws IOException {
        File pathingJarFile = File.createTempFile("gradle-javaexec-classpath", ".jar");
        try (FileOutputStream fileOutputStream = new FileOutputStream(pathingJarFile);
             JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, JavaExecHandleBuilder.toManifest(classPath));){
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/"));
        }
        return pathingJarFile;
    }

    private static Manifest toManifest(FileCollection classPath) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("Class-Path", classPath.getFiles().stream().map(File::toURI).map(URI::toString).collect(Collectors.joining(" ")));
        return manifest;
    }

    public JavaForkOptions copyTo(JavaForkOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        super.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.javaOptions.getJvmArgumentProviders();
    }
}

