/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.GoogleClosureCompiler;
import org.gradle.play.internal.javascript.JavaScriptCompileSpec;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.routes.RoutesCompileSpec;
import org.gradle.play.internal.routes.RoutesCompiler;
import org.gradle.play.internal.routes.RoutesCompilerAdapterFactory;
import org.gradle.play.internal.routes.VersionedRoutesCompilerAdapter;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.run.PlayApplicationRunnerFactory;
import org.gradle.play.internal.spec.PlayCompileSpec;
import org.gradle.play.internal.toolchain.DaemonPlayCompiler;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.internal.twirl.TwirlCompileSpec;
import org.gradle.play.internal.twirl.TwirlCompiler;
import org.gradle.play.internal.twirl.TwirlCompilerAdapterFactory;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;

class DefaultPlayToolProvider
implements PlayToolProvider {
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final File daemonWorkingDir;
    private final PlayPlatform targetPlatform;
    private WorkerProcessFactory workerProcessBuilderFactory;
    private final Set<File> twirlClasspath;
    private final Set<File> routesClasspath;
    private final Set<File> javaScriptClasspath;
    private final FileCollectionFingerprinter fingerprinter;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public DefaultPlayToolProvider(JavaForkOptionsFactory forkOptionsFactory, File daemonWorkingDir, WorkerDaemonFactory workerDaemonFactory, WorkerProcessFactory workerProcessBuilderFactory, PlayPlatform targetPlatform, Set<File> twirlClasspath, Set<File> routesClasspath, Set<File> javaScriptClasspath, FileCollectionFingerprinter fingerprinter, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.forkOptionsFactory = forkOptionsFactory;
        this.daemonWorkingDir = daemonWorkingDir;
        this.workerDaemonFactory = workerDaemonFactory;
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
        this.targetPlatform = targetPlatform;
        this.twirlClasspath = twirlClasspath;
        this.routesClasspath = routesClasspath;
        this.javaScriptClasspath = javaScriptClasspath;
        this.fingerprinter = fingerprinter;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
        PlayMajorVersion.forPlatform(targetPlatform);
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        if (TwirlCompileSpec.class.isAssignableFrom(spec)) {
            VersionedTwirlCompilerAdapter adapter = TwirlCompilerAdapterFactory.createAdapter(this.targetPlatform);
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler(this.daemonWorkingDir, TwirlCompiler.class, new Object[]{adapter}, this.workerDaemonFactory, this.twirlClasspath, this.forkOptionsFactory, this.classPathRegistry, this.classLoaderRegistry, this.actionExecutionSpecFactory));
        }
        if (RoutesCompileSpec.class.isAssignableFrom(spec)) {
            VersionedRoutesCompilerAdapter adapter = RoutesCompilerAdapterFactory.createAdapter(this.targetPlatform);
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler(this.daemonWorkingDir, RoutesCompiler.class, new Object[]{adapter}, this.workerDaemonFactory, this.routesClasspath, this.forkOptionsFactory, this.classPathRegistry, this.classLoaderRegistry, this.actionExecutionSpecFactory));
        }
        if (JavaScriptCompileSpec.class.isAssignableFrom(spec)) {
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler(this.daemonWorkingDir, GoogleClosureCompiler.class, new Object[0], this.workerDaemonFactory, this.javaScriptClasspath, this.forkOptionsFactory, this.classPathRegistry, this.classLoaderRegistry, this.actionExecutionSpecFactory));
        }
        throw new IllegalArgumentException(String.format("Cannot create Compiler for unsupported CompileSpec type '%s'", spec.getSimpleName()));
    }

    public <T> T get(Class<T> toolType) {
        if (PlayApplicationRunner.class.isAssignableFrom(toolType)) {
            return toolType.cast(PlayApplicationRunnerFactory.create(this.targetPlatform, this.workerProcessBuilderFactory, this.fingerprinter));
        }
        throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
    }

    private <T extends CompileSpec> Compiler<T> cast(Compiler<? extends PlayCompileSpec> raw) {
        Compiler<? extends PlayCompileSpec> converted = raw;
        return converted;
    }

    public boolean isAvailable() {
        return true;
    }

    public void explain(DiagnosticsVisitor visitor) {
    }
}

