/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrMemberAccessExpressionBase;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassConstructorCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "ir.backend.common"})
public final class InnerClassConstructorCallsLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody) {
        Intrinsics.checkParameterIsNotNull((Object)irBody, (String)"irBody");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ InnerClassConstructorCallsLowering this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructorSymbol callee = expression2.getSymbol();
                IrClass parent2 = IrUtilsKt.getParentAsClass((IrDeclaration)callee.getOwner());
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), (IrConstructorSymbol)newCallee.getSymbol(), expression2.getOrigin());
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom(newCall, expression2);
                newCall.putValueArgument(0, dispatchReceiver);
                int n = 1;
                int n2 = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n <= n2) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n2) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructor classConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                if (!IrUtilsKt.getParentAsClass(classConstructor).isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter(classConstructor);
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)newCallee.getSymbol(), newCallee.getDescriptor(), expression2.getTypeArgumentsCount());
                int n = 0;
                boolean bl = false;
                IrDelegatingConstructorCallImpl $this$apply = irDelegatingConstructorCallImpl;
                boolean bl2 = false;
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom($this$apply, expression2);
                IrDelegatingConstructorCallImpl newCall = irDelegatingConstructorCallImpl;
                newCall.putValueArgument(0, dispatchReceiver);
                int n2 = 1;
                n = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n2 <= n) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                int t;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrFunctionSymbol irFunctionSymbol = expression2.getSymbol();
                if (!(irFunctionSymbol instanceof IrConstructorSymbol)) {
                    irFunctionSymbol = null;
                }
                IrConstructorSymbol irConstructorSymbol = (IrConstructorSymbol)irFunctionSymbol;
                if (irConstructorSymbol == null) {
                    return expression2;
                }
                IrConstructorSymbol callee = irConstructorSymbol;
                IrDeclarationParent irDeclarationParent = ((IrConstructor)callee.getOwner()).getParent();
                if (!(irDeclarationParent instanceof IrClass)) {
                    irDeclarationParent = null;
                }
                IrClass irClass = (IrClass)irDeclarationParent;
                if (irClass == null) {
                    return expression2;
                }
                IrClass parent2 = irClass;
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                IrFunctionReference irFunctionReference = expression2;
                boolean bl = false;
                boolean bl2 = false;
                IrFunctionReference $this$run = irFunctionReference;
                boolean bl3 = false;
                IrFunctionReferenceImpl newReference = new IrFunctionReferenceImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), newCallee.getSymbol(), newCallee.getDescriptor(), $this$run.getTypeArgumentsCount(), $this$run.getOrigin());
                irFunctionReference = newReference;
                bl = false;
                bl2 = false;
                IrFunctionReference it = irFunctionReference;
                boolean bl4 = false;
                ((IrMemberAccessExpressionBase)((Object)it)).setDispatchReceiver(expression2.getDispatchReceiver());
                ((IrMemberAccessExpressionBase)((Object)it)).setExtensionReceiver(expression2.getExtensionReceiver());
                int n = 0;
                int n2 = expression2.getTypeArgumentsCount();
                while (n < n2) {
                    ((IrMemberAccessExpressionBase)((Object)it)).putTypeArgument(t, expression2.getTypeArgument(t));
                    ++t;
                }
                t = 0;
                n2 = expression2.getValueArgumentsCount();
                while (t < n2) {
                    void v;
                    ((IrCallWithIndexedArgumentsBase)((Object)it)).putValueArgument((int)v, expression2.getValueArgument((int)v));
                    ++v;
                }
                return newReference;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public InnerClassConstructorCallsLowering(@NotNull BackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

