/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.math;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(@Nullable String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be > 0");
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a + ", " + b + ")");
        }
    }
}

