/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeStAXStreamBuilder;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;
import org.jetbrains.kotlin.org.jdom.JDOMInterner;
import org.jetbrains.kotlin.org.jdom.Text;
import org.jetbrains.kotlin.org.jdom.filter.Filter;
import org.jetbrains.kotlin.org.jdom.output.Format;
import org.jetbrains.kotlin.org.jdom.output.XMLOutputter;

public class JDOMUtil {
    private static final Condition<Attribute> NOT_EMPTY_VALUE_CONDITION = attribute -> !StringUtil.isEmpty(attribute.getValue());
    private static final NotNullLazyValue<XMLInputFactory> XML_INPUT_FACTORY = new NotNullLazyValue<XMLInputFactory>(){

        @Override
        @NotNull
        protected XMLInputFactory compute() {
            XMLInputFactory factory2;
            String property = System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
            try {
                factory2 = XMLInputFactory.newFactory();
            }
            finally {
                if (property != null) {
                    System.setProperty("javax.xml.stream.XMLInputFactory", property);
                } else {
                    System.clearProperty("javax.xml.stream.XMLInputFactory");
                }
            }
            if (!SystemInfo.isIbmJvm) {
                try {
                    factory2.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", true);
                }
                catch (Exception e) {
                    JDOMUtil.getLogger().error("cannot set \"report-cdata-event\" property for XMLInputFactory", e);
                }
            }
            factory2.setProperty("javax.xml.stream.isCoalescing", true);
            factory2.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory2.setProperty("javax.xml.stream.supportDTD", false);
            XMLInputFactory xMLInputFactory = factory2;
            if (xMLInputFactory == null) {
                1.$$$reportNull$$$0(0);
            }
            return xMLInputFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$1", "compute"));
        }
    };
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();
    private static final JDOMInterner ourJDOMInterner = new JDOMInterner();

    private JDOMUtil() {
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull Reader reader, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(17);
        }
        XMLStreamReader xmlStreamReader = XML_INPUT_FACTORY.getValue().createXMLStreamReader(reader);
        Element element = SafeStAXStreamBuilder.build(xmlStreamReader, true, factory2 == null ? SafeStAXStreamBuilder.FACTORY : factory2);
        xmlStreamReader.close();
        Element element2 = element;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(18);
        }
        return element2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull File file2, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        Element element = JDOMUtil.loadUsingStaX(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8)), factory2);
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        return element;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.load(stream, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(35);
        }
        Element element = JDOMUtil.loadUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8), factory2);
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(36);
        }
        return element;
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(37);
        }
        if (resource == null) {
            JDOMUtil.$$$reportNull$$$0(38);
        }
        if ((stream = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Element element = JDOMUtil.load(stream);
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(39);
        }
        return element;
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(46);
        }
        Element element = JDOMUtil.load(URLUtil.openResourceStream(url));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(47);
        }
        return element;
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(73);
        }
        JDOMUtil.writeElement(element, writer, JDOMUtil.createOutputter(lineSeparator));
    }

    public static void writeElement(@NotNull Element element, @NotNull Writer writer, @NotNull XMLOutputter xmlOutputter) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(74);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(75);
        }
        if (xmlOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(76);
        }
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(77);
        }
        String string2 = JDOMUtil.writeElement(element, "\n");
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(78);
        }
        return string2;
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        String string2;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(79);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, (Writer)writer, lineSeparator);
            string2 = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(80);
        }
        return string2;
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        if (format == null) {
            JDOMUtil.$$$reportNull$$$0(86);
        }
        return format;
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        MyXMLOutputter myXMLOutputter = new MyXMLOutputter(JDOMUtil.createFormat(lineSeparator));
        if (myXMLOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(87);
        }
        return myXMLOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(90);
        }
        String string2 = JDOMUtil.escapeText(text2, false, escapeSpaces, escapeLineEnds);
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(91);
        }
        return string2;
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(92);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text2, buffer, i, quotation, ch);
        }
        String string2 = buffer == null ? text2 : buffer.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(93);
        }
        return string2;
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(94);
        }
        ElementInfo info2 = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info2.name;
        if (info2.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(95);
        }
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        ElementInfo elementInfo = new ElementInfo(buf, hasNullAttributes);
        if (elementInfo == null) {
            JDOMUtil.$$$reportNull$$$0(96);
        }
        return elementInfo;
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || !element.hasAttributes() && element.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        if (e == null) {
            JDOMUtil.$$$reportNull$$$0(100);
        }
        List<Attribute> list2 = e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
        if (list2 == null) {
            JDOMUtil.$$$reportNull$$$0(101);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 107: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 107: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 15: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: 
            case 35: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 40: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 48: 
            case 50: 
            case 61: 
            case 66: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 63: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 77: 
            case 79: 
            case 81: 
            case 94: 
            case 95: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 60: 
            case 65: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 75: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputter";
                break;
            }
            case 88: 
            case 90: 
            case 92: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocumentUsingStaX";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUsingStaX";
                break;
            }
            case 20: 
            case 24: 
            case 26: 
            case 34: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocument";
                break;
            }
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 36: 
            case 39: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResourceDocument";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResource";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 70: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 78: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormat";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputter";
                break;
            }
            case 89: 
            case 91: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMerge";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "removeControlChars";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "attEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadDocumentUsingStaX";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadUsingStaX";
                break;
            }
            case 19: 
            case 23: 
            case 25: 
            case 33: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 21: 
            case 27: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceDocument";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadResource";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 61: 
            case 62: 
            case 66: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 88: 
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "removeControlChars";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 105: 
            case 107: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementInfo {
        @NotNull
        final CharSequence name;
        final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            if (name == null) {
                ElementInfo.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.hasNullAttributes = attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$ElementInfo", "<init>"));
        }
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        MyXMLOutputter(@NotNull Format format) {
            if (format == null) {
                MyXMLOutputter.$$$reportNull$$$0(0);
            }
            super(format);
        }

        @Override
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(1);
            }
            String string2 = JDOMUtil.escapeText(str, false, true);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(3);
            }
            String string2 = JDOMUtil.escapeText(str, false, false);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeAttributeEntities";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeElementEntities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeAttributeEntities";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeElementEntities";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyTextFilter
    implements Filter<Content> {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");
    }
}

