/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.util.MergeOptionsUtil;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ForkedWorkerRequirement;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.ProvidesWorkResult;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerRequirement;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final WorkerFactory workerFactory;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;

    public AbstractDaemonCompiler(WorkerFactory workerFactory, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.workerFactory = workerFactory;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    public WorkResult execute(T spec) {
        CompilerParameters parameters;
        IsolatedClassLoaderWorkerRequirement workerRequirement = this.getWorkerRequirement(this.workerFactory.getIsolationMode(), spec);
        BuildOperationAwareWorker worker = this.workerFactory.getWorker((WorkerRequirement)workerRequirement);
        DefaultWorkResult result = worker.execute((ActionExecutionSpec)this.actionExecutionSpecFactory.newIsolatedSpec("compiler daemon", CompilerWorkAction.class, (WorkParameters)(parameters = this.getCompilerParameters(spec)), (WorkerRequirement)workerRequirement, true));
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    private IsolatedClassLoaderWorkerRequirement getWorkerRequirement(IsolationMode isolationMode, T spec) {
        DaemonForkOptions daemonForkOptions = this.toDaemonForkOptions(spec);
        switch (isolationMode) {
            case CLASSLOADER: {
                return new IsolatedClassLoaderWorkerRequirement(daemonForkOptions.getJavaForkOptions().getWorkingDir(), daemonForkOptions.getClassLoaderStructure());
            }
            case PROCESS: {
                return new ForkedWorkerRequirement(daemonForkOptions.getJavaForkOptions().getWorkingDir(), daemonForkOptions);
            }
        }
        throw new IllegalArgumentException("Received worker with unsupported isolation mode: " + isolationMode);
    }

    protected abstract DaemonForkOptions toDaemonForkOptions(T var1);

    protected abstract CompilerParameters getCompilerParameters(T var1);

    protected BaseForkOptions mergeForkOptions(BaseForkOptions left, BaseForkOptions right) {
        BaseForkOptions merged = new BaseForkOptions();
        merged.setMemoryInitialSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryInitialSize(), (String)right.getMemoryInitialSize()));
        merged.setMemoryMaximumSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryMaximumSize(), (String)right.getMemoryMaximumSize()));
        Set mergedJvmArgs = MergeOptionsUtil.normalized(left.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized(right.getJvmArgs()));
        merged.setJvmArgs(Lists.newArrayList((Iterable)mergedJvmArgs));
        return merged;
    }

    public static abstract class CompilerWorkAction
    implements WorkAction<CompilerParameters>,
    ProvidesWorkResult {
        private DefaultWorkResult workResult;
        private final Instantiator instantiator;

        @Inject
        public CompilerWorkAction(Instantiator instantiator) {
            this.instantiator = instantiator;
        }

        public void execute() {
            Class compilerClass = (Class)Cast.uncheckedCast((Object)ClassLoaderUtils.classFromContextLoader((String)((CompilerParameters)this.getParameters()).getCompilerClassName()));
            Compiler compiler = (Compiler)this.instantiator.newInstance(compilerClass, ((CompilerParameters)this.getParameters()).getCompilerInstanceParameters());
            this.setWorkResult(compiler.execute((CompileSpec)Cast.uncheckedCast((Object)((CompilerParameters)this.getParameters()).getCompileSpec())));
        }

        private void setWorkResult(WorkResult workResult) {
            this.workResult = workResult instanceof DefaultWorkResult ? (DefaultWorkResult)workResult : new DefaultWorkResult(workResult.getDidWork(), null);
        }

        public DefaultWorkResult getWorkResult() {
            return this.workResult;
        }
    }

    public static abstract class CompilerParameters
    implements WorkParameters,
    Serializable {
        private final String compilerClassName;
        private final Object[] compilerInstanceParameters;

        public CompilerParameters(String compilerClassName, Object[] compilerInstanceParameters) {
            this.compilerClassName = compilerClassName;
            this.compilerInstanceParameters = compilerInstanceParameters;
        }

        public String getCompilerClassName() {
            return this.compilerClassName;
        }

        public Object[] getCompilerInstanceParameters() {
            return this.compilerInstanceParameters;
        }

        public abstract CompileSpec getCompileSpec();
    }
}

