/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.internal.build.IncludedBuildState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludedBuildDependencySubstitutionsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludedBuildDependencySubstitutionsBuilder.class);
    private final CompositeBuildContext context;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IncludedBuildDependencySubstitutionsBuilder(CompositeBuildContext context, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.context = context;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public void build(IncludedBuildState build) {
        DependencySubstitutionsInternal substitutions = this.resolveDependencySubstitutions(build);
        if (!substitutions.hasRules()) {
            LOGGER.info("[composite-build] Configuring build: " + build.getRootDirectory());
            this.context.addAvailableModules(build.getAvailableModules());
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }

    private DependencySubstitutionsInternal resolveDependencySubstitutions(IncludedBuildState build) {
        DefaultDependencySubstitutions dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild((IncludedBuildState)build, (ImmutableModuleIdentifierFactory)this.moduleIdentifierFactory);
        build.getRegisteredDependencySubstitutions().execute((Object)dependencySubstitutions);
        return dependencySubstitutions;
    }
}

