/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ArtifactExclude;
import org.gradle.internal.component.model.IvyArtifactName;

final class DefaultModuleArtifactExclude
implements ArtifactExclude {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName artifactName;
    private final int hashCode;

    static ArtifactExclude of(ModuleIdentifier id, IvyArtifactName artifact) {
        return new DefaultModuleArtifactExclude(id, artifact);
    }

    private DefaultModuleArtifactExclude(ModuleIdentifier moduleId, IvyArtifactName artifactName) {
        this.moduleId = moduleId;
        this.artifactName = artifactName;
        this.hashCode = 31 * moduleId.hashCode() + artifactName.hashCode();
    }

    @Override
    public IvyArtifactName getArtifact() {
        return this.artifactName;
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifactName) {
        return this.moduleId.equals(module) && this.artifactName.equals(artifactName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleArtifactExclude that = (DefaultModuleArtifactExclude)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (!this.moduleId.equals(that.moduleId)) {
            return false;
        }
        return this.artifactName.equals(that.artifactName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "{ \"artifact\": { \"name\": \"" + this.artifactName + "\", \"module\" : \"" + this.moduleId + "\"} }";
    }
}

