/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;

public abstract class InstanceKeyDataSource
implements DataSource,
Referenceable,
Serializable,
AutoCloseable {
    private static final long serialVersionUID = -6819270431752240878L;
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static final String BAD_TRANSACTION_ISOLATION = "The requested TransactionIsolation level is invalid.";
    protected static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    private volatile boolean getConnectionCalled;
    private ConnectionPoolDataSource dataSource;
    private String dataSourceName;
    private String description;
    private Properties jndiEnvironment;
    private int loginTimeout;
    private PrintWriter logWriter;
    private String instanceKey;
    private boolean defaultBlockWhenExhausted = true;
    private String defaultEvictionPolicyClassName = BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME;
    private boolean defaultLifo = true;
    private int defaultMaxIdle = 8;
    private int defaultMaxTotal = -1;
    private long defaultMaxWaitMillis = -1L;
    private long defaultMinEvictableIdleTimeMillis = 1800000L;
    private int defaultMinIdle = 0;
    private int defaultNumTestsPerEvictionRun = 3;
    private long defaultSoftMinEvictableIdleTimeMillis = -1L;
    private boolean defaultTestOnCreate = false;
    private boolean defaultTestOnBorrow = false;
    private boolean defaultTestOnReturn = false;
    private boolean defaultTestWhileIdle = false;
    private long defaultTimeBetweenEvictionRunsMillis = -1L;
    private String validationQuery;
    private int validationQueryTimeoutSeconds = -1;
    private boolean rollbackAfterValidation;
    private long maxConnLifetimeMillis = -1L;
    private Boolean defaultAutoCommit;
    private int defaultTransactionIsolation = -1;
    private Boolean defaultReadOnly;

    protected void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    @Override
    public abstract void close() throws Exception;

    protected abstract PooledConnectionManager getConnectionManager(UserPassKey var1);

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("InstanceKeyDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean getDefaultBlockWhenExhausted() {
        return this.defaultBlockWhenExhausted;
    }

    public void setDefaultBlockWhenExhausted(boolean blockWhenExhausted) {
        this.assertInitializationAllowed();
        this.defaultBlockWhenExhausted = blockWhenExhausted;
    }

    public String getDefaultEvictionPolicyClassName() {
        return this.defaultEvictionPolicyClassName;
    }

    public void setDefaultEvictionPolicyClassName(String evictionPolicyClassName) {
        this.assertInitializationAllowed();
        this.defaultEvictionPolicyClassName = evictionPolicyClassName;
    }

    public boolean getDefaultLifo() {
        return this.defaultLifo;
    }

    public void setDefaultLifo(boolean lifo) {
        this.assertInitializationAllowed();
        this.defaultLifo = lifo;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int maxIdle) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = maxIdle;
    }

    public int getDefaultMaxTotal() {
        return this.defaultMaxTotal;
    }

    public void setDefaultMaxTotal(int maxTotal) {
        this.assertInitializationAllowed();
        this.defaultMaxTotal = maxTotal;
    }

    public long getDefaultMaxWaitMillis() {
        return this.defaultMaxWaitMillis;
    }

    public void setDefaultMaxWaitMillis(long maxWaitMillis) {
        this.assertInitializationAllowed();
        this.defaultMaxWaitMillis = maxWaitMillis;
    }

    public long getDefaultMinEvictableIdleTimeMillis() {
        return this.defaultMinEvictableIdleTimeMillis;
    }

    public void setDefaultMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this.defaultMinEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public int getDefaultMinIdle() {
        return this.defaultMinIdle;
    }

    public void setDefaultMinIdle(int minIdle) {
        this.assertInitializationAllowed();
        this.defaultMinIdle = minIdle;
    }

    public int getDefaultNumTestsPerEvictionRun() {
        return this.defaultNumTestsPerEvictionRun;
    }

    public void setDefaultNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        this.defaultNumTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public long getDefaultSoftMinEvictableIdleTimeMillis() {
        return this.defaultSoftMinEvictableIdleTimeMillis;
    }

    public void setDefaultSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this.defaultSoftMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public boolean getDefaultTestOnCreate() {
        return this.defaultTestOnCreate;
    }

    public void setDefaultTestOnCreate(boolean testOnCreate) {
        this.assertInitializationAllowed();
        this.defaultTestOnCreate = testOnCreate;
    }

    public boolean getDefaultTestOnBorrow() {
        return this.defaultTestOnBorrow;
    }

    public void setDefaultTestOnBorrow(boolean testOnBorrow) {
        this.assertInitializationAllowed();
        this.defaultTestOnBorrow = testOnBorrow;
    }

    public boolean getDefaultTestOnReturn() {
        return this.defaultTestOnReturn;
    }

    public void setDefaultTestOnReturn(boolean testOnReturn) {
        this.assertInitializationAllowed();
        this.defaultTestOnReturn = testOnReturn;
    }

    public boolean getDefaultTestWhileIdle() {
        return this.defaultTestWhileIdle;
    }

    public void setDefaultTestWhileIdle(boolean testWhileIdle) {
        this.assertInitializationAllowed();
        this.defaultTestWhileIdle = testWhileIdle;
    }

    public long getDefaultTimeBetweenEvictionRunsMillis() {
        return this.defaultTimeBetweenEvictionRunsMillis;
    }

    public void setDefaultTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        this.defaultTimeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.dataSource;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource v) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        if (this.dataSource != null) {
            throw new IllegalStateException("The CPDS has already been set. It cannot be altered.");
        }
        this.dataSource = v;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String v) {
        this.assertInitializationAllowed();
        if (this.dataSource != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.dataSourceName != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.dataSourceName = v;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean v) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = v;
    }

    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean v) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = v;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int v) {
        this.assertInitializationAllowed();
        switch (v) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_TRANSACTION_ISOLATION);
            }
        }
        this.defaultTransactionIsolation = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    protected String getInstanceKey() {
        return this.instanceKey;
    }

    public String getJndiEnvironment(String key) {
        String value = null;
        if (this.jndiEnvironment != null) {
            value = this.jndiEnvironment.getProperty(key);
        }
        return value;
    }

    public void setJndiEnvironment(String key, String value) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(key, value);
    }

    void setJndiEnvironment(Properties properties) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        } else {
            this.jndiEnvironment.clear();
        }
        this.jndiEnvironment.putAll((Map<?, ?>)properties);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int v) {
        this.loginTimeout = v;
    }

    @Override
    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        }
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter v) {
        this.logWriter = v;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.assertInitializationAllowed();
        this.validationQuery = validationQuery;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeoutSeconds;
    }

    public void setValidationQueryTimeout(int validationQueryTimeoutSeconds) {
        this.validationQueryTimeoutSeconds = validationQueryTimeoutSeconds;
    }

    public boolean isRollbackAfterValidation() {
        return this.rollbackAfterValidation;
    }

    public void setRollbackAfterValidation(boolean rollbackAfterValidation) {
        this.assertInitializationAllowed();
        this.rollbackAfterValidation = rollbackAfterValidation;
    }

    public long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String userName, String userPassword) throws SQLException {
        if (this.instanceKey == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        PooledConnectionAndInfo info = null;
        try {
            info = this.getPooledConnectionAndInfo(userName, userPassword);
        }
        catch (NoSuchElementException e) {
            this.closeDueToException(info);
            throw new SQLException("Cannot borrow connection from pool", e);
        }
        catch (RuntimeException e) {
            this.closeDueToException(info);
            throw e;
        }
        catch (SQLException e) {
            this.closeDueToException(info);
            throw e;
        }
        catch (Exception e) {
            this.closeDueToException(info);
            throw new SQLException("Cannot borrow connection from pool", e);
        }
        if (!(null != userPassword ? userPassword.equals(info.getPassword()) : null == info.getPassword())) {
            try {
                this.testCPDS(userName, userPassword);
            }
            catch (SQLException ex) {
                this.closeDueToException(info);
                throw new SQLException("Given password did not match password used to create the PooledConnection.", ex);
            }
            catch (NamingException ne) {
                throw new SQLException("NamingException encountered connecting to database", ne);
            }
            UserPassKey upkey = info.getUserPassKey();
            PooledConnectionManager manager = this.getConnectionManager(upkey);
            manager.invalidate(info.getPooledConnection());
            manager.setPassword(upkey.getPassword());
            info = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    info = this.getPooledConnectionAndInfo(userName, userPassword);
                }
                catch (NoSuchElementException e) {
                    this.closeDueToException(info);
                    throw new SQLException("Cannot borrow connection from pool", e);
                }
                catch (RuntimeException e) {
                    this.closeDueToException(info);
                    throw e;
                }
                catch (SQLException e) {
                    this.closeDueToException(info);
                    throw e;
                }
                catch (Exception e) {
                    this.closeDueToException(info);
                    throw new SQLException("Cannot borrow connection from pool", e);
                }
                if (info != null && userPassword != null && userPassword.equals(info.getPassword())) break;
                if (info != null) {
                    manager.invalidate(info.getPooledConnection());
                }
                info = null;
            }
            if (info == null) {
                throw new SQLException("Cannot borrow connection from pool - password change failure.");
            }
        }
        Connection con = info.getPooledConnection().getConnection();
        try {
            this.setupDefaults(con, userName);
            con.clearWarnings();
            return con;
        }
        catch (SQLException ex) {
            try {
                con.close();
            }
            catch (Exception exc) {
                this.getLogWriter().println("ignoring exception during close: " + exc);
            }
            throw ex;
        }
    }

    protected abstract PooledConnectionAndInfo getPooledConnectionAndInfo(String var1, String var2) throws SQLException;

    protected abstract void setupDefaults(Connection var1, String var2) throws SQLException;

    private void closeDueToException(PooledConnectionAndInfo info) {
        if (info != null) {
            try {
                info.getPooledConnection().getConnection().close();
            }
            catch (Exception e) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionPoolDataSource testCPDS(String userName, String userPassword) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.dataSource;
        if (cpds == null) {
            InitialContext ctx = null;
            ctx = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
            Object ds = ctx.lookup(this.dataSourceName);
            if (ds instanceof ConnectionPoolDataSource) {
                cpds = (ConnectionPoolDataSource)ds;
            } else {
                throw new SQLException("Illegal configuration: DataSource " + this.dataSourceName + " (" + ds.getClass().getName() + ")" + " doesn't implement javax.sql.ConnectionPoolDataSource");
            }
        }
        PooledConnection conn = null;
        try {
            conn = userName != null ? cpds.getPooledConnection(userName, userPassword) : cpds.getPooledConnection();
            if (conn == null) {
                throw new SQLException("Cannot connect using the supplied userName/password");
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return cpds;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append('[');
        this.toStringFields(builder);
        builder.append(']');
        return builder.toString();
    }

    protected void toStringFields(StringBuilder builder) {
        builder.append("getConnectionCalled=");
        builder.append(this.getConnectionCalled);
        builder.append(", dataSource=");
        builder.append(this.dataSource);
        builder.append(", dataSourceName=");
        builder.append(this.dataSourceName);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", jndiEnvironment=");
        builder.append(this.jndiEnvironment);
        builder.append(", loginTimeout=");
        builder.append(this.loginTimeout);
        builder.append(", logWriter=");
        builder.append(this.logWriter);
        builder.append(", instanceKey=");
        builder.append(this.instanceKey);
        builder.append(", defaultBlockWhenExhausted=");
        builder.append(this.defaultBlockWhenExhausted);
        builder.append(", defaultEvictionPolicyClassName=");
        builder.append(this.defaultEvictionPolicyClassName);
        builder.append(", defaultLifo=");
        builder.append(this.defaultLifo);
        builder.append(", defaultMaxIdle=");
        builder.append(this.defaultMaxIdle);
        builder.append(", defaultMaxTotal=");
        builder.append(this.defaultMaxTotal);
        builder.append(", defaultMaxWaitMillis=");
        builder.append(this.defaultMaxWaitMillis);
        builder.append(", defaultMinEvictableIdleTimeMillis=");
        builder.append(this.defaultMinEvictableIdleTimeMillis);
        builder.append(", defaultMinIdle=");
        builder.append(this.defaultMinIdle);
        builder.append(", defaultNumTestsPerEvictionRun=");
        builder.append(this.defaultNumTestsPerEvictionRun);
        builder.append(", defaultSoftMinEvictableIdleTimeMillis=");
        builder.append(this.defaultSoftMinEvictableIdleTimeMillis);
        builder.append(", defaultTestOnCreate=");
        builder.append(this.defaultTestOnCreate);
        builder.append(", defaultTestOnBorrow=");
        builder.append(this.defaultTestOnBorrow);
        builder.append(", defaultTestOnReturn=");
        builder.append(this.defaultTestOnReturn);
        builder.append(", defaultTestWhileIdle=");
        builder.append(this.defaultTestWhileIdle);
        builder.append(", defaultTimeBetweenEvictionRunsMillis=");
        builder.append(this.defaultTimeBetweenEvictionRunsMillis);
        builder.append(", validationQuery=");
        builder.append(this.validationQuery);
        builder.append(", validationQueryTimeoutSeconds=");
        builder.append(this.validationQueryTimeoutSeconds);
        builder.append(", rollbackAfterValidation=");
        builder.append(this.rollbackAfterValidation);
        builder.append(", maxConnLifetimeMillis=");
        builder.append(this.maxConnLifetimeMillis);
        builder.append(", defaultAutoCommit=");
        builder.append(this.defaultAutoCommit);
        builder.append(", defaultTransactionIsolation=");
        builder.append(this.defaultTransactionIsolation);
        builder.append(", defaultReadOnly=");
        builder.append(this.defaultReadOnly);
    }
}

