var fs = require('fs');
var path = require('path');

/*
 * Start state, single and multiline comment states
 */
var START_S = 0;
var SINGLE_S = 1;
var MULTI_S = 2;

/*
 * Tokens
 */
var NL = '\n';
var EMPTY = '';
var ESCAPE = '\\';

var START_COMMENT = END_COMMENT = '/';
var OPEN_COMMENT = CLOSE_COMMENT = '*';

var DQUOTE = '"';
// var SQUOTE = "'";

/*
 * Strip single and multiline comments
 */
var strip = function(input) {
  var current;
  var next;

  var state = START_S;
  var output = EMPTY;
  var string = false;

  for (var i = 0; i < input.length; i++) {
    current = input.charAt(i);
    next = input.charAt(i + 1);

    if (START_S === state) {
      if (DQUOTE === current) {
        if(ESCAPE !== input.charAt(i - 1)) {
          string = !string;
        }
      }
    }

    /*
     * Inside string literal?
     */
    if (!string) {
      switch(state) {
        case START_S:
          if(START_COMMENT === current) {
            switch(next) {
              case START_COMMENT:
                state = SINGLE_S;
                i++;
                break;
              case OPEN_COMMENT:
                state = MULTI_S;
                i++;
                break;
            }
          }
          break;
        case SINGLE_S:
          if(NL === current) {
            state = START_S;
          }
          break;
        case MULTI_S:
          if(CLOSE_COMMENT === current) {
            if(END_COMMENT === next) {
              state = START_S;
              current = EMPTY;
              i++;
            }
          }
          break;
      }

      if (START_S !== state) {
        current = EMPTY;
      }
    }
    output = output + current;
  }
  return output;
}

var jReadSync = function(file) {
  try {
    return JSON.parse(strip(fs.readFileSync(file, 'utf8')));
  } catch(e) {
    return null;
  }
}

var fReadSync = function(file, encoding) {
  try {
    return fs.readFileSync(file, encoding || 'utf8');
  } catch(e) {
    return null;
  }
}

/*
 * Return array of subdirs
 */
var readSubDirs = function(dir) {
  var files = fs.readdirSync(dir);
  var dirs = [];

  for(var i = 0; i < files.length; i++) {
    if(fs.statSync(dir + '/' + files[i]).isDirectory()) {
      dirs.push(files[i]);
    }
  }

  return dirs;
}

var fileRead = function(file) {
  if(file.match(/\.js$/)) {
    return require(file);
  } else if(file.match(/\.json$/)) {
    return jReadSync(file);
  }

  return fReadSync(file);
}

var dirFactory = function(that) {
  return (function(file) {
    this.__root = path.resolve(that.__root);

    if(file) {
      return fileRead(path.join(this.__root, file));
    } else {
      var dirs = readSubDirs(this.__root);

      for(var i = 0; i < dirs.length; i++) {
        this[dirs[i]] = (function(self) {
          return new dirFactory(self);
        }) ({__root: path.join(this.__root, dirs[i])});
      }
    }
    return this;
  }).bind(this);
}

module.exports = function(root) {
  this.__root = root || process.cwd();
  return new dirFactory(this);
}

