/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.Yarn = void 0;
/**
 * Mock of the Yarn class.
 */
class Yarn {
    constructor() { }
    // mock any exec command by providing the output
    static __setDependencies(rootModule, dependencies) {
        Yarn.dependenciesMap.set(rootModule, dependencies);
    }
    async getDependencies(rootModule) {
        const result = Yarn.dependenciesMap.get(rootModule);
        if (result) {
            return Promise.resolve(result);
        }
        else {
            return Promise.resolve([]);
        }
    }
}
exports.Yarn = Yarn;
/**
 * Map between the name of the root Moduleand the output.
 */
Yarn.dependenciesMap = new Map();
//# sourceMappingURL=yarn.js.map