/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
/**
 * Allow to clone git repositories easily
 */
export declare class Repository {
    private readonly uri;
    /**
     * Default constructor with the given URI
     * @param uri
     */
    constructor(uri: string);
    /**
     * Grab the repository name based on the given URI of repository.
     */
    getRepositoryName(): string;
    /**
     * Performs the clone operation
     * @param checkoutFolder the CWD / directory where to launch the clone operation
     * @param dest the destination folder of the clone
     * @param checkoutTo the optional branch/tag to use when cloning
     * @param keepHistory the optional flag to keep / omit git history
     */
    clone(checkoutFolder: string, dest: string, checkoutTo?: string, keepHistory?: boolean): Promise<string>;
}
//# sourceMappingURL=repository.d.ts.map