"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdn = void 0;
const fs = require("fs-extra");
const path = require("path");
/**
 * Generates a `cdn.json` file with the prefixes of CDN where Theia and Monaco files
 * should be retrieved from.
 *
 * @author David Festal
 */
class Cdn {
    constructor(assemblyFolder, theiaCDN, monacoCDN) {
        this.assemblyFolder = assemblyFolder;
        this.theiaCDN = theiaCDN;
        this.monacoCDN = monacoCDN;
    }
    async create() {
        await fs.writeFile(path.join(this.assemblyFolder, 'cdn.json'), JSON.stringify({
            theia: this.theiaCDN,
            monaco: this.monacoCDN,
        }));
    }
}
exports.Cdn = Cdn;
Cdn.defaultTheiaCdnPrefix = 'https://cdn.jsdelivr.net/gh/davidfestal/che-theia-cdn@latest/che-theia-editor/';
Cdn.defaultMonacoCdnPrefix = 'https://cdn.jsdelivr.net/npm/';
// eslint-disable-next-line @typescript-eslint/no-explicit-any
Cdn.argBuilder = (theYargs) => theYargs
    .option('theia', {
    describe: 'Base URL of the CDN that will host Theia files',
    requiresArg: true,
    type: 'string',
    default: Cdn.defaultTheiaCdnPrefix,
    defaultDescription: Cdn.defaultTheiaCdnPrefix,
})
    .option('monaco', {
    describe: 'Base URL of the CDN that will host Monaco Editor files',
    requiresArg: true,
    type: 'string',
    default: Cdn.defaultMonacoCdnPrefix,
    defaultDescription: Cdn.defaultMonacoCdnPrefix,
});
//# sourceMappingURL=cdn.js.map