"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Command = void 0;
const cp = require("child_process");
const cli_error_1 = require("./cli-error");
/**
 * Allow to run some commands
 * @author Florent Benoit
 */
class Command {
    constructor(directory) {
        this.directory = directory;
    }
    async exec(commandLine) {
        return new Promise((resolve, reject) => {
            const execProcess = cp.exec(commandLine, {
                cwd: this.directory,
                maxBuffer: 1024 * 1024,
            }, (error, stdout, stderr) => {
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                const exitCode = execProcess.exitCode;
                if (error) {
                    reject(new cli_error_1.CliError('Unable to execute the command ' + commandLine + ': ' + error));
                }
                if (exitCode !== 0) {
                    reject(new cli_error_1.CliError('Invalid exit code ' + exitCode));
                }
                resolve(stdout);
            });
        });
    }
}
exports.Command = Command;
//# sourceMappingURL=command.js.map