/// <reference types="node" />
import * as http from 'http';
interface GetCredentialsResponse {
    client_email?: string;
}
export interface AuthClient {
    sign(blobToSign: string): Promise<string>;
    getCredentials(): Promise<GetCredentialsResponse>;
}
export interface BucketI {
    name: string;
}
export interface FileI {
    name: string;
}
export interface Query {
    [key: string]: string;
}
export interface GetSignedUrlConfigInternal {
    expiration: number;
    accessibleAt?: Date;
    method: string;
    extensionHeaders?: http.OutgoingHttpHeaders;
    queryParams?: Query;
    cname?: string;
    contentMd5?: string;
    contentType?: string;
    bucket: string;
    file?: string;
}
export interface SignerGetSignedUrlConfig {
    method: 'GET' | 'PUT' | 'DELETE' | 'POST';
    expires: string | number | Date;
    accessibleAt?: string | number | Date;
    virtualHostedStyle?: boolean;
    version?: 'v2' | 'v4';
    cname?: string;
    extensionHeaders?: http.OutgoingHttpHeaders;
    queryParams?: Query;
    contentMd5?: string;
    contentType?: string;
}
export declare type SignerGetSignedUrlResponse = string;
export declare type GetSignedUrlResponse = [SignerGetSignedUrlResponse];
export interface GetSignedUrlCallback {
    (err: Error | null, url?: string): void;
}
/**
 * @const {string}
 * @private
 */
export declare const PATH_STYLED_HOST = "https://storage.googleapis.com";
export declare class URLSigner {
    private authClient;
    private bucket;
    private file?;
    constructor(authClient: AuthClient, bucket: BucketI, file?: FileI);
    getSignedUrl(cfg: SignerGetSignedUrlConfig): Promise<SignerGetSignedUrlResponse>;
    private getSignedUrlV2;
    private getSignedUrlV4;
    /**
     * Create canonical headers for signing v4 url.
     *
     * The canonical headers for v4-signing a request demands header names are
     * first lowercased, followed by sorting the header names.
     * Then, construct the canonical headers part of the request:
     *  <lowercasedHeaderName> + ":" + Trim(<value>) + "\n"
     *  ..
     *  <lowercasedHeaderName> + ":" + Trim(<value>) + "\n"
     *
     * @param headers
     * @private
     */
    getCanonicalHeaders(headers: http.OutgoingHttpHeaders): string;
    getCanonicalRequest(method: string, path: string, query: string, headers: string, signedHeaders: string, contentSha256?: string): string;
    getCanonicalQueryParams(query: Query): string;
    getResourcePath(cname: boolean, bucket: string, file?: string): string;
    parseExpires(expires: string | number | Date, current?: Date): number;
    parseAccessibleAt(accessibleAt?: string | number | Date): number;
}
/**
 * Custom error type for errors related to getting signed errors and policies.
 *
 * @private
 */
export declare class SigningError extends Error {
    name: string;
}
export {};
