/**
 * Creates a matcher object for the passed expectation
 *
 * @alias module:samsam.createMatcher
 * @param {*} expectation An expecttation
 * @param {string} message A message for the expectation
 * @returns {object} A matcher object
 */
export function createMatcher(expectation: any, message: string, ...args: any[]): object;
export namespace createMatcher {
    export { isMatcher_1 as isMatcher };
    export const any: any;
    export const defined: any;
    export const truthy: any;
    export const falsy: any;
    export function same(expectation: any): any;
    function _in(arrayOfExpectations: any): any;
    export { _in as in };
    export function typeOf(type: any): any;
    export function instanceOf(type: any): any;
    export const has: any;
    export const hasOwn: any;
    export function hasNested(property: any, value: any, ...args: any[]): any;
    export function json(value: any): any;
    export function every(predicate: any): any;
    export function some(predicate: any): any;
    export const array: any;
    export const map: any;
    export const set: any;
    export const bool: any;
    export const number: any;
    export const string: any;
    export const object: any;
    export const func: any;
    export const regexp: any;
    export const date: any;
    export const symbol: any;
}
export function deepEqual(a: any, b: any): boolean;
declare namespace _default {
    export { createMatcher_1 as createMatcher };
    export { deepEqualCyclic$1 as deepEqual };
    export { identical_1 as identical };
    export { isArguments_1 as isArguments };
    export { isElement_1 as isElement };
    export { isMap_1 as isMap };
    export { isNegZero_1 as isNegZero };
    export { isSet_1 as isSet };
    export { match_1 as match };
}
export default _default;
/**
 * Strict equality check according to EcmaScript Harmony's `egal`.
 *
 * **From the Harmony wiki:**
 * > An `egal` function simply makes available the internal `SameValue` function
 * > from section 9.12 of the ES5 spec. If two values are egal, then they are not
 * > observably distinguishable.
 *
 * `identical` returns `true` when `===` is `true`, except for `-0` and
 * `+0`, where it returns `false`. Additionally, it returns `true` when
 * `NaN` is compared to itself.
 *
 * @alias module:samsam.identical
 * @param {*} obj1 The first value to compare
 * @param {*} obj2 The second value to compare
 * @returns {boolean} Returns `true` when the objects are *egal*, `false` otherwise
 */
export function identical(obj1: any, obj2: any): boolean;
/**
 * Returns `true` when `object` is an `arguments` object, `false` otherwise
 *
 * @alias module:samsam.isArguments
 * @param  {*}  object - The object to examine
 * @returns {boolean} `true` when `object` is an `arguments` object
 */
export function isArguments(object: any): boolean;
/**
 * Returns `true` when `object` is a DOM element node.
 *
 * Unlike Underscore.js/lodash, this function will return `false` if `object`
 * is an *element-like* object, i.e. a regular object with a `nodeType`
 * property that holds the value `1`.
 *
 * @alias module:samsam.isElement
 * @param {object} object The object to examine
 * @returns {boolean} Returns `true` for DOM element nodes
 */
export function isElement(object: object): boolean;
/**
 * Returns `true` when `value` is a Map
 *
 * @param {*} value A value to examine
 * @returns {boolean} `true` when `value` is an instance of `Map`, `false` otherwise
 * @private
 */
export function isMap(value: any): boolean;
/**
 * Returns `true` when `value` is `-0`
 *
 * @alias module:samsam.isNegZero
 * @param {*} value A value to examine
 * @returns {boolean} Returns `true` when `value` is `-0`
 */
export function isNegZero(value: any): boolean;
/**
 * Returns `true` when the argument is an instance of Set, `false` otherwise
 *
 * @alias module:samsam.isSet
 * @param  {*}  val - A value to examine
 * @returns {boolean} Returns `true` when the argument is an instance of Set, `false` otherwise
 */
export function isSet(val: any): boolean;
/**
 * Matches an object with a matcher (or value)
 *
 * @alias module:samsam.match
 * @param {object} object The object candidate to match
 * @param {object} matcherOrValue A matcher or value to match against
 * @returns {boolean} true when `object` matches `matcherOrValue`
 */
export function match(object: object, matcherOrValue: object): boolean;
export var __esModule: boolean;
/**
 * Returns `true` when `object` is a matcher
 *
 * @private
 * @param {*} object A value to examine
 * @returns {boolean} Returns `true` when `object` is a matcher
 */
declare function isMatcher_1(object: any): boolean;
/**
 * Creates a matcher object for the passed expectation
 *
 * @alias module:samsam.createMatcher
 * @param {*} expectation An expecttation
 * @param {string} message A message for the expectation
 * @returns {object} A matcher object
 */
declare function createMatcher_1(expectation: any, message: string, ...args: any[]): object;
declare namespace createMatcher_1 { }
declare function deepEqualCyclic$1(a: any, b: any): boolean;
/**
 * Strict equality check according to EcmaScript Harmony's `egal`.
 *
 * **From the Harmony wiki:**
 * > An `egal` function simply makes available the internal `SameValue` function
 * > from section 9.12 of the ES5 spec. If two values are egal, then they are not
 * > observably distinguishable.
 *
 * `identical` returns `true` when `===` is `true`, except for `-0` and
 * `+0`, where it returns `false`. Additionally, it returns `true` when
 * `NaN` is compared to itself.
 *
 * @alias module:samsam.identical
 * @param {*} obj1 The first value to compare
 * @param {*} obj2 The second value to compare
 * @returns {boolean} Returns `true` when the objects are *egal*, `false` otherwise
 */
declare function identical_1(obj1: any, obj2: any): boolean;
/**
 * Returns `true` when `object` is an `arguments` object, `false` otherwise
 *
 * @alias module:samsam.isArguments
 * @param  {*}  object - The object to examine
 * @returns {boolean} `true` when `object` is an `arguments` object
 */
declare function isArguments_1(object: any): boolean;
/**
 * Returns `true` when `object` is a DOM element node.
 *
 * Unlike Underscore.js/lodash, this function will return `false` if `object`
 * is an *element-like* object, i.e. a regular object with a `nodeType`
 * property that holds the value `1`.
 *
 * @alias module:samsam.isElement
 * @param {object} object The object to examine
 * @returns {boolean} Returns `true` for DOM element nodes
 */
declare function isElement_1(object: object): boolean;
/**
 * Returns `true` when `value` is a Map
 *
 * @param {*} value A value to examine
 * @returns {boolean} `true` when `value` is an instance of `Map`, `false` otherwise
 * @private
 */
declare function isMap_1(value: any): boolean;
/**
 * Returns `true` when `value` is `-0`
 *
 * @alias module:samsam.isNegZero
 * @param {*} value A value to examine
 * @returns {boolean} Returns `true` when `value` is `-0`
 */
declare function isNegZero_1(value: any): boolean;
/**
 * Returns `true` when the argument is an instance of Set, `false` otherwise
 *
 * @alias module:samsam.isSet
 * @param  {*}  val - A value to examine
 * @returns {boolean} Returns `true` when the argument is an instance of Set, `false` otherwise
 */
declare function isSet_1(val: any): boolean;
/**
 * Matches an object with a matcher (or value)
 *
 * @alias module:samsam.match
 * @param {object} object The object candidate to match
 * @param {object} matcherOrValue A matcher or value to match against
 * @returns {boolean} true when `object` matches `matcherOrValue`
 */
declare function match_1(object: object, matcherOrValue: object): boolean;
