#! /usr/bin/env python3

import sys
import requests

QUAY_IO_API = 'https://quay.io/api/v1'

def main(argv):
    if len(argv) != 2:
        sys.exit(1)
    url = '%s/repository/%s/tag/?onlyActiveTags=true&limit=2' % (QUAY_IO_API, argv[1])
    _req = requests.get(url)
    req = list(filter(
        lambda x: x['name'] != 'latest',
        _req.json()['tags']
    ))
    if len(req) != 1:
        sys.exit(2)
    print("quay.io/%s:%s" % (argv[1], req[0]['name']))

if __name__ == '__main__':
    main(sys.argv)
