#!/bin/bash

set -e

source hack/common.sh

export SKIP_MINIMUM="0.0.1"
export SKIP_RANGE=">=${SKIP_MINIMUM} <${CSV_VERSION}"

# Current dependency images our DEV CSV are pinned to
export ROOK_IMAGE=${ROOK_IMAGE:-${LATEST_ROOK_IMAGE}}
export NOOBAA_IMAGE=${NOOBAA_IMAGE:-${LATEST_NOOBAA_IMAGE}}
export NOOBAA_CORE_IMAGE=${NOOBAA_CORE_IMAGE:-${LATEST_NOOBAA_CORE_IMAGE}}
export NOOBAA_DB_IMAGE=${NOOBAA_DB_IMAGE:-${LATEST_NOOBAA_DB_IMAGE}}
export CEPH_IMAGE=${CEPH_IMAGE:-${LATEST_CEPH_IMAGE}}
export OCS_IMAGE=${OCS_IMAGE:-"${IMAGE_REGISTRY}/${REGISTRY_NAMESPACE}/${OPERATOR_IMAGE_NAME}:${IMAGE_TAG}"}
export OCS_MUST_GATHER_IMAGE=${OCS_MUST_GATHER_IMAGE:-"${MUST_GATHER_FULL_IMAGE_NAME}"}
export VOLUME_REPLICATION_OPERATOR_IMAGE=${VOLUME_REPLICATION_OPERATOR_IMAGE:-"${IMAGE_REGISTRY}/${LATEST_VOLUME_REPLICATION_OPERATOR_IMAGE}"}

echo "=== Generating DEV CSV with the following vars ==="
echo -e "\tCSV_VERSION=$CSV_VERSION"
echo -e "\tROOK_IMAGE=$ROOK_IMAGE"
echo -e "\tNOOBAA_IMAGE=$NOOBAA_IMAGE"
echo -e "\tNOOBAA_CORE_IMAGE=$NOOBAA_CORE_IMAGE"
echo -e "\tNOOBAA_DB_IMAGE=$NOOBAA_DB_IMAGE"
echo -e "\tCEPH_IMAGE=$CEPH_IMAGE"
echo -e "\tOCS_IMAGE=$OCS_IMAGE"

hack/generate-unified-csv.sh
