/*
Copyright 2019 Red Hat Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package provisioner

import (
	"github.com/go-logr/logr"
	"k8s.io/klog/klogr"

	"github.com/kube-object-storage/lib-bucket-provisioner/pkg/provisioner/api"
)

var (
	// log is a short lived variable that is overwritten each Reconcile() iteration with the current Request injected
	// into it.  This is for convenience of identifying which log lines were generated by which request without having
	// to pass the request to every method call.
	log logr.Logger

	// logD is a short lived variable that is overwritten each Reconcile() iteraion with the current Request injected
	// into it.  This is for convenience of identifying which log lines were generated by which request without having
	// to pass the request to every log method call.
	logD logr.InfoLogger
)

func init() {
	log = klogr.New().WithName(api.Domain + "/claim-reconciler")
	logD = log.V(1)
}

// setLoggerWith request overwrites log and logD with a new logger.  The passed in request is injected into the loggers.
func setLoggersWithRequest(key string) {
	log = klogr.New().WithValues("key", key)
	logD = klogr.New().WithValues("key", key)
}