/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CephNFSesGetter has a method to return a CephNFSInterface.
// A group's client should implement this interface.
type CephNFSesGetter interface {
	CephNFSes(namespace string) CephNFSInterface
}

// CephNFSInterface has methods to work with CephNFS resources.
type CephNFSInterface interface {
	Create(*v1.CephNFS) (*v1.CephNFS, error)
	Update(*v1.CephNFS) (*v1.CephNFS, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.CephNFS, error)
	List(opts metav1.ListOptions) (*v1.CephNFSList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephNFS, err error)
	CephNFSExpansion
}

// cephNFSes implements CephNFSInterface
type cephNFSes struct {
	client rest.Interface
	ns     string
}

// newCephNFSes returns a CephNFSes
func newCephNFSes(c *CephV1Client, namespace string) *cephNFSes {
	return &cephNFSes{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the cephNFS, and returns the corresponding cephNFS object, and an error if there is any.
func (c *cephNFSes) Get(name string, options metav1.GetOptions) (result *v1.CephNFS, err error) {
	result = &v1.CephNFS{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephnfses").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CephNFSes that match those selectors.
func (c *cephNFSes) List(opts metav1.ListOptions) (result *v1.CephNFSList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CephNFSList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephnfses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cephNFSes.
func (c *cephNFSes) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("cephnfses").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a cephNFS and creates it.  Returns the server's representation of the cephNFS, and an error, if there is any.
func (c *cephNFSes) Create(cephNFS *v1.CephNFS) (result *v1.CephNFS, err error) {
	result = &v1.CephNFS{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("cephnfses").
		Body(cephNFS).
		Do().
		Into(result)
	return
}

// Update takes the representation of a cephNFS and updates it. Returns the server's representation of the cephNFS, and an error, if there is any.
func (c *cephNFSes) Update(cephNFS *v1.CephNFS) (result *v1.CephNFS, err error) {
	result = &v1.CephNFS{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("cephnfses").
		Name(cephNFS.Name).
		Body(cephNFS).
		Do().
		Into(result)
	return
}

// Delete takes name of the cephNFS and deletes it. Returns an error if one occurs.
func (c *cephNFSes) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephnfses").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cephNFSes) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephnfses").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched cephNFS.
func (c *cephNFSes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephNFS, err error) {
	result = &v1.CephNFS{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("cephnfses").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
