/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/rook/rook/pkg/apis/nfs.rook.io/v1alpha1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// NFSServersGetter has a method to return a NFSServerInterface.
// A group's client should implement this interface.
type NFSServersGetter interface {
	NFSServers(namespace string) NFSServerInterface
}

// NFSServerInterface has methods to work with NFSServer resources.
type NFSServerInterface interface {
	Create(ctx context.Context, nFSServer *v1alpha1.NFSServer, opts v1.CreateOptions) (*v1alpha1.NFSServer, error)
	Update(ctx context.Context, nFSServer *v1alpha1.NFSServer, opts v1.UpdateOptions) (*v1alpha1.NFSServer, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.NFSServer, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.NFSServerList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.NFSServer, err error)
	NFSServerExpansion
}

// nFSServers implements NFSServerInterface
type nFSServers struct {
	client rest.Interface
	ns     string
}

// newNFSServers returns a NFSServers
func newNFSServers(c *NfsV1alpha1Client, namespace string) *nFSServers {
	return &nFSServers{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the nFSServer, and returns the corresponding nFSServer object, and an error if there is any.
func (c *nFSServers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.NFSServer, err error) {
	result = &v1alpha1.NFSServer{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nfsservers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of NFSServers that match those selectors.
func (c *nFSServers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.NFSServerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.NFSServerList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nfsservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested nFSServers.
func (c *nFSServers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("nfsservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a nFSServer and creates it.  Returns the server's representation of the nFSServer, and an error, if there is any.
func (c *nFSServers) Create(ctx context.Context, nFSServer *v1alpha1.NFSServer, opts v1.CreateOptions) (result *v1alpha1.NFSServer, err error) {
	result = &v1alpha1.NFSServer{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("nfsservers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nFSServer).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a nFSServer and updates it. Returns the server's representation of the nFSServer, and an error, if there is any.
func (c *nFSServers) Update(ctx context.Context, nFSServer *v1alpha1.NFSServer, opts v1.UpdateOptions) (result *v1alpha1.NFSServer, err error) {
	result = &v1alpha1.NFSServer{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("nfsservers").
		Name(nFSServer.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(nFSServer).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the nFSServer and deletes it. Returns an error if one occurs.
func (c *nFSServers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nfsservers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *nFSServers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nfsservers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched nFSServer.
func (c *nFSServers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.NFSServer, err error) {
	result = &v1alpha1.NFSServer{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("nfsservers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
