package v1alpha1

import (
	"k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// EmberStorageBackendSpec defines the desired state of EmberStorageBackend
type EmberStorageBackendSpec struct {
	Config       EmberStorageBackendConfig    `json:"config"`
	Image        string            `json:"image",omitempty`
	NodeSelector map[string]string `json:"nodeSelector",omitempty`
	Tolerations  []v1.Toleration   `json:"tolerations",omitempty`
	Topologies   []Topologies      `json:"topologies",omitempty`
}

type Topologies struct {
	// Key-value pairs corresponding to the NodeName
	Topology map[string]string `json:"topology,omitempty"`
	// Node Hostname with its allowed topology
	Nodes []v1.NodeSelectorRequirement `json:"nodes,omitempty"`
}

// EmberStorageBackendStatus defines the observed state of EmberStorageBackend
type EmberStorageBackendStatus struct {
	// INSERT ADDITIONAL STATUS FIELD - define observed state of cluster
	// Important: Run "operator-sdk generate k8s" to regenerate code after modifying this file
	Version string `json:"version"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// EmberStorageBackend is the Schema for the embercsis API
// +k8s:openapi-gen=true
type EmberStorageBackend struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   EmberStorageBackendSpec   `json:"spec,omitempty"`
	Status EmberStorageBackendStatus `json:"status"`
}

type EmberStorageBackendConfig struct {
	EnvVars  EnvVars `json:"envVars"`
	SysFiles Secrets `json:"sysFiles"`
	DriverImage string `json:"driverImage",omitempty`
}

// +k8s:deepcopy-gen=false
type EnvVars struct {
	X_CSI_BACKEND_CONFIG     interface{}    `yaml:"X_CSI_BACKEND_CONFIG",omitempty`
	X_CSI_EMBER_CONFIG       interface{}    `yaml:"X_CSI_EMBER_CONFIG",omitempty`
	X_CSI_PERSISTENCE_CONFIG interface{}    `yaml:"X_CSI_PERSISTENCE_CONFIG",omitempty`
	X_CSI_DEBUG_MODE         string    `json:"X_CSI_DEBUG_MODE",omitempty`
	X_CSI_ABORT_DUPLICATES   string    `json:"X_CSI_ABORT_DUPLICATES",omitempty`
	X_CSI_DEFAULT_MOUNT_FS   string    `json:"X_CSI_DEFAULT_MOUNT_FS",omitempty`
	X_CSI_NODE_ID            string    `json:"X_CSI_NODE_ID",omitempty`
	X_CSI_STORAGE_NW_IP      string    `json:"X_CSI_STORAGE_NW_IP",omitempty`
	CSI_ENDPOINT             string    `json:"CSI_ENDPOINT",omitempty`
	CSI_MODE                 string    `json:"CSI_MODE",omitempty`
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EnvVars) DeepCopyInto(out *EnvVars) {
       *out = *in
       return
}

type Secrets struct {
	Name string `json:"name",omitempty`
	Key  string `json:"key",omitempty`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// EmberStorageBackendList contains a list of EmberStorageBackend
type EmberStorageBackendList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []EmberStorageBackend `json:"items"`
}

func init() {
	SchemeBuilder.Register(&EmberStorageBackend{}, &EmberStorageBackendList{})
}
