// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V. licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// Code generated from specification version 7.10.0: DO NOT EDIT

package esapi

import (
	"context"
	"io"
	"net/http"
	"strconv"
	"strings"
	"time"
)

func newEqlSearchFunc(t Transport) EqlSearch {
	return func(index string, body io.Reader, o ...func(*EqlSearchRequest)) (*Response, error) {
		var r = EqlSearchRequest{Index: index, Body: body}
		for _, f := range o {
			f(&r)
		}
		return r.Do(r.ctx, t)
	}
}

// ----- API Definition -------------------------------------------------------

// EqlSearch - Returns results matching a query expressed in Event Query Language (EQL)
//
// This API is beta.
//
// See full documentation at https://www.elastic.co/guide/en/elasticsearch/reference/current/eql-search-api.html.
//
type EqlSearch func(index string, body io.Reader, o ...func(*EqlSearchRequest)) (*Response, error)

// EqlSearchRequest configures the Eql Search API request.
//
type EqlSearchRequest struct {
	Index string

	Body io.Reader

	KeepAlive                time.Duration
	KeepOnCompletion         *bool
	WaitForCompletionTimeout time.Duration

	Pretty     bool
	Human      bool
	ErrorTrace bool
	FilterPath []string

	Header http.Header

	ctx context.Context
}

// Do executes the request and returns response or error.
//
func (r EqlSearchRequest) Do(ctx context.Context, transport Transport) (*Response, error) {
	var (
		method string
		path   strings.Builder
		params map[string]string
	)

	method = "GET"

	path.Grow(1 + len(r.Index) + 1 + len("_eql") + 1 + len("search"))
	path.WriteString("/")
	path.WriteString(r.Index)
	path.WriteString("/")
	path.WriteString("_eql")
	path.WriteString("/")
	path.WriteString("search")

	params = make(map[string]string)

	if r.KeepAlive != 0 {
		params["keep_alive"] = formatDuration(r.KeepAlive)
	}

	if r.KeepOnCompletion != nil {
		params["keep_on_completion"] = strconv.FormatBool(*r.KeepOnCompletion)
	}

	if r.WaitForCompletionTimeout != 0 {
		params["wait_for_completion_timeout"] = formatDuration(r.WaitForCompletionTimeout)
	}

	if r.Pretty {
		params["pretty"] = "true"
	}

	if r.Human {
		params["human"] = "true"
	}

	if r.ErrorTrace {
		params["error_trace"] = "true"
	}

	if len(r.FilterPath) > 0 {
		params["filter_path"] = strings.Join(r.FilterPath, ",")
	}

	req, err := newRequest(method, path.String(), r.Body)
	if err != nil {
		return nil, err
	}

	if len(params) > 0 {
		q := req.URL.Query()
		for k, v := range params {
			q.Set(k, v)
		}
		req.URL.RawQuery = q.Encode()
	}

	if r.Body != nil {
		req.Header[headerContentType] = headerContentTypeJSON
	}

	if len(r.Header) > 0 {
		if len(req.Header) == 0 {
			req.Header = r.Header
		} else {
			for k, vv := range r.Header {
				for _, v := range vv {
					req.Header.Add(k, v)
				}
			}
		}
	}

	if ctx != nil {
		req = req.WithContext(ctx)
	}

	res, err := transport.Perform(req)
	if err != nil {
		return nil, err
	}

	response := Response{
		StatusCode: res.StatusCode,
		Body:       res.Body,
		Header:     res.Header,
	}

	return &response, nil
}

// WithContext sets the request context.
//
func (f EqlSearch) WithContext(v context.Context) func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.ctx = v
	}
}

// WithKeepAlive - update the time interval in which the results (partial or final) for this search will be available.
//
func (f EqlSearch) WithKeepAlive(v time.Duration) func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.KeepAlive = v
	}
}

// WithKeepOnCompletion - control whether the response should be stored in the cluster if it completed within the provided [wait_for_completion] time (default: false).
//
func (f EqlSearch) WithKeepOnCompletion(v bool) func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.KeepOnCompletion = &v
	}
}

// WithWaitForCompletionTimeout - specify the time that the request should block waiting for the final response.
//
func (f EqlSearch) WithWaitForCompletionTimeout(v time.Duration) func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.WaitForCompletionTimeout = v
	}
}

// WithPretty makes the response body pretty-printed.
//
func (f EqlSearch) WithPretty() func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.Pretty = true
	}
}

// WithHuman makes statistical values human-readable.
//
func (f EqlSearch) WithHuman() func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.Human = true
	}
}

// WithErrorTrace includes the stack trace for errors in the response body.
//
func (f EqlSearch) WithErrorTrace() func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.ErrorTrace = true
	}
}

// WithFilterPath filters the properties of the response body.
//
func (f EqlSearch) WithFilterPath(v ...string) func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		r.FilterPath = v
	}
}

// WithHeader adds the headers to the HTTP request.
//
func (f EqlSearch) WithHeader(h map[string]string) func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		if r.Header == nil {
			r.Header = make(http.Header)
		}
		for k, v := range h {
			r.Header.Add(k, v)
		}
	}
}

// WithOpaqueID adds the X-Opaque-Id header to the HTTP request.
//
func (f EqlSearch) WithOpaqueID(s string) func(*EqlSearchRequest) {
	return func(r *EqlSearchRequest) {
		if r.Header == nil {
			r.Header = make(http.Header)
		}
		r.Header.Set("X-Opaque-Id", s)
	}
}
