package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/batch/mgmt/2017-09-01/batch"

// Account contains information about an Azure Batch account.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - The properties associated with the account.
	*AccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// AccountCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountClient) (Account, error)
}

// AccountCreateParameters parameters supplied to the Create operation.
type AccountCreateParameters struct {
	// Location - The region in which to create the account.
	Location *string `json:"location,omitempty"`
	// Tags - The user-specified tags associated with the account.
	Tags map[string]*string `json:"tags"`
	// AccountCreateProperties - The properties of the Batch account.
	*AccountCreateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCreateParameters.
func (acp AccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acp.Location != nil {
		objectMap["location"] = acp.Location
	}
	if acp.Tags != nil {
		objectMap["tags"] = acp.Tags
	}
	if acp.AccountCreateProperties != nil {
		objectMap["properties"] = acp.AccountCreateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountCreateParameters struct.
func (acp *AccountCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				acp.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountCreateProperties AccountCreateProperties
				err = json.Unmarshal(*v, &accountCreateProperties)
				if err != nil {
					return err
				}
				acp.AccountCreateProperties = &accountCreateProperties
			}
		}
	}

	return nil
}

// AccountCreateProperties the properties of a Batch account.
type AccountCreateProperties struct {
	// AutoStorage - The properties related to the auto-storage account.
	AutoStorage *AutoStorageBaseProperties `json:"autoStorage,omitempty"`
	// PoolAllocationMode - The pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService. Possible values include: 'BatchService', 'UserSubscription'
	PoolAllocationMode PoolAllocationMode `json:"poolAllocationMode,omitempty"`
	// KeyVaultReference - A reference to the Azure key vault associated with the Batch account.
	KeyVaultReference *KeyVaultReference `json:"keyVaultReference,omitempty"`
}

// AccountDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountClient) (autorest.Response, error)
}

// AccountKeys a set of Azure Batch account keys.
type AccountKeys struct {
	autorest.Response `json:"-"`
	// AccountName - READ-ONLY; The Batch account name.
	AccountName *string `json:"accountName,omitempty"`
	// Primary - READ-ONLY; The primary key associated with the account.
	Primary *string `json:"primary,omitempty"`
	// Secondary - READ-ONLY; The secondary key associated with the account.
	Secondary *string `json:"secondary,omitempty"`
}

// AccountListResult values returned by the List operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of Batch accounts returned by the listing operation.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AccountListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(cur AccountListResult, getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AccountProperties account specific properties.
type AccountProperties struct {
	// AccountEndpoint - READ-ONLY; The account endpoint used to interact with the Batch service.
	AccountEndpoint *string `json:"accountEndpoint,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioned state of the resource. Possible values include: 'ProvisioningStateInvalid', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCancelled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PoolAllocationMode - READ-ONLY; Possible values include: 'BatchService', 'UserSubscription'
	PoolAllocationMode PoolAllocationMode `json:"poolAllocationMode,omitempty"`
	// KeyVaultReference - READ-ONLY
	KeyVaultReference *KeyVaultReference `json:"keyVaultReference,omitempty"`
	// AutoStorage - READ-ONLY
	AutoStorage *AutoStorageProperties `json:"autoStorage,omitempty"`
	// DedicatedCoreQuota - READ-ONLY
	DedicatedCoreQuota *int32 `json:"dedicatedCoreQuota,omitempty"`
	// LowPriorityCoreQuota - READ-ONLY
	LowPriorityCoreQuota *int32 `json:"lowPriorityCoreQuota,omitempty"`
	// PoolQuota - READ-ONLY
	PoolQuota *int32 `json:"poolQuota,omitempty"`
	// ActiveJobAndJobScheduleQuota - READ-ONLY
	ActiveJobAndJobScheduleQuota *int32 `json:"activeJobAndJobScheduleQuota,omitempty"`
}

// AccountRegenerateKeyParameters parameters supplied to the RegenerateKey operation.
type AccountRegenerateKeyParameters struct {
	// KeyName - The type of account key to regenerate. Possible values include: 'Primary', 'Secondary'
	KeyName AccountKeyType `json:"keyName,omitempty"`
}

// AccountUpdateParameters parameters for updating an Azure Batch account.
type AccountUpdateParameters struct {
	// Tags - The user-specified tags associated with the account.
	Tags map[string]*string `json:"tags"`
	// AccountUpdateProperties - The properties of the account.
	*AccountUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	if aup.AccountUpdateProperties != nil {
		objectMap["properties"] = aup.AccountUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateParameters struct.
func (aup *AccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountUpdateProperties AccountUpdateProperties
				err = json.Unmarshal(*v, &accountUpdateProperties)
				if err != nil {
					return err
				}
				aup.AccountUpdateProperties = &accountUpdateProperties
			}
		}
	}

	return nil
}

// AccountUpdateProperties the properties of a Batch account.
type AccountUpdateProperties struct {
	// AutoStorage - The properties related to the auto-storage account.
	AutoStorage *AutoStorageBaseProperties `json:"autoStorage,omitempty"`
}

// ActivateApplicationPackageParameters parameters for an activating an application package.
type ActivateApplicationPackageParameters struct {
	// Format - The format of the application package binary file.
	Format *string `json:"format,omitempty"`
}

// Application contains information about an application in a Batch account.
type Application struct {
	autorest.Response `json:"-"`
	// ID - A string that uniquely identifies the application within the account.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the application.
	DisplayName *string `json:"displayName,omitempty"`
	// Packages - The list of packages under this application.
	Packages *[]ApplicationPackage `json:"packages,omitempty"`
	// AllowUpdates - A value indicating whether packages within the application may be overwritten using the same version string.
	AllowUpdates *bool `json:"allowUpdates,omitempty"`
	// DefaultVersion - The package to use if a client requests the application but does not specify a version.
	DefaultVersion *string `json:"defaultVersion,omitempty"`
}

// ApplicationCreateParameters parameters for adding an Application.
type ApplicationCreateParameters struct {
	// AllowUpdates - A value indicating whether packages within the application may be overwritten using the same version string.
	AllowUpdates *bool `json:"allowUpdates,omitempty"`
	// DisplayName - The display name for the application.
	DisplayName *string `json:"displayName,omitempty"`
}

// ApplicationPackage an application package which represents a particular version of an application.
type ApplicationPackage struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the application.
	ID *string `json:"id,omitempty"`
	// Version - READ-ONLY; The version of the application package.
	Version *string `json:"version,omitempty"`
	// State - READ-ONLY; The current state of the application package. Possible values include: 'Pending', 'Active', 'Unmapped'
	State PackageState `json:"state,omitempty"`
	// Format - READ-ONLY; The format of the application package, if the package is active.
	Format *string `json:"format,omitempty"`
	// StorageURL - READ-ONLY; The URL for the application package in Azure Storage.
	StorageURL *string `json:"storageUrl,omitempty"`
	// StorageURLExpiry - READ-ONLY; The UTC time at which the Azure Storage URL will expire.
	StorageURLExpiry *date.Time `json:"storageUrlExpiry,omitempty"`
	// LastActivationTime - READ-ONLY; The time at which the package was last activated, if the package is active.
	LastActivationTime *date.Time `json:"lastActivationTime,omitempty"`
}

// ApplicationPackageReference ...
type ApplicationPackageReference struct {
	ID *string `json:"id,omitempty"`
	// Version - If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
	Version *string `json:"version,omitempty"`
}

// ApplicationUpdateParameters parameters for an update application request.
type ApplicationUpdateParameters struct {
	// AllowUpdates - A value indicating whether packages within the application may be overwritten using the same version string.
	AllowUpdates *bool `json:"allowUpdates,omitempty"`
	// DefaultVersion - The package to use if a client requests the application but does not specify a version.
	DefaultVersion *string `json:"defaultVersion,omitempty"`
	// DisplayName - The display name for the application.
	DisplayName *string `json:"displayName,omitempty"`
}

// AutoScaleRun ...
type AutoScaleRun struct {
	EvaluationTime *date.Time `json:"evaluationTime,omitempty"`
	// Results - Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
	Results *string            `json:"results,omitempty"`
	Error   *AutoScaleRunError `json:"error,omitempty"`
}

// AutoScaleRunError ...
type AutoScaleRunError struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string              `json:"message,omitempty"`
	Details *[]AutoScaleRunError `json:"details,omitempty"`
}

// AutoScaleSettings ...
type AutoScaleSettings struct {
	Formula *string `json:"formula,omitempty"`
	// EvaluationInterval - If omitted, the default value is 15 minutes (PT15M).
	EvaluationInterval *string `json:"evaluationInterval,omitempty"`
}

// AutoStorageBaseProperties the properties related to the auto-storage account.
type AutoStorageBaseProperties struct {
	// StorageAccountID - The resource ID of the storage account to be used for auto-storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// AutoStorageProperties contains information about the auto-storage account associated with a Batch
// account.
type AutoStorageProperties struct {
	// LastKeySync - The UTC time at which storage keys were last synchronized with the Batch account.
	LastKeySync *date.Time `json:"lastKeySync,omitempty"`
	// StorageAccountID - The resource ID of the storage account to be used for auto-storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// AutoUserSpecification ...
type AutoUserSpecification struct {
	// Scope - pool - specifies that the task runs as the common auto user account which is created on every node in a pool. task - specifies that the service should create a new user for the task. The default value is task. Possible values include: 'AutoUserScopeTask', 'AutoUserScopePool'
	Scope AutoUserScope `json:"scope,omitempty"`
	// ElevationLevel - nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
}

// Certificate contains information about a certificate.
type Certificate struct {
	autorest.Response `json:"-"`
	// CertificateProperties - The properties associated with the certificate.
	*CertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CertificateProperties != nil {
		objectMap["properties"] = c.CertificateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Certificate struct.
func (c *Certificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateProperties CertificateProperties
				err = json.Unmarshal(*v, &certificateProperties)
				if err != nil {
					return err
				}
				c.CertificateProperties = &certificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		}
	}

	return nil
}

// CertificateBaseProperties ...
type CertificateBaseProperties struct {
	// ThumbprintAlgorithm - This must match the first portion of the certificate name. Currently required to be 'SHA1'.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// Thumbprint - This must match the thumbprint from the name.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Format - The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
	Format CertificateFormat `json:"format,omitempty"`
}

// CertificateCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CertificateCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CertificateClient) (Certificate, error)
}

// CertificateCreateOrUpdateParameters contains information about a certificate.
type CertificateCreateOrUpdateParameters struct {
	// CertificateCreateOrUpdateProperties - The properties associated with the certificate.
	*CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateCreateOrUpdateParameters.
func (ccoup CertificateCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.CertificateCreateOrUpdateProperties != nil {
		objectMap["properties"] = ccoup.CertificateCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateCreateOrUpdateParameters struct.
func (ccoup *CertificateCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateCreateOrUpdateProperties CertificateCreateOrUpdateProperties
				err = json.Unmarshal(*v, &certificateCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.CertificateCreateOrUpdateProperties = &certificateCreateOrUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ccoup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ccoup.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ccoup.Etag = &etag
			}
		}
	}

	return nil
}

// CertificateCreateOrUpdateProperties certificate properties for create operations
type CertificateCreateOrUpdateProperties struct {
	// Data - The maximum size is 10KB.
	Data *string `json:"data,omitempty"`
	// Password - This is required if the certificate format is pfx and must be omitted if the certificate format is cer.
	Password *string `json:"password,omitempty"`
	// ThumbprintAlgorithm - This must match the first portion of the certificate name. Currently required to be 'SHA1'.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// Thumbprint - This must match the thumbprint from the name.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Format - The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
	Format CertificateFormat `json:"format,omitempty"`
}

// CertificateDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CertificateDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CertificateClient) (autorest.Response, error)
}

// CertificateProperties certificate properties.
type CertificateProperties struct {
	// ProvisioningState - READ-ONLY; Values are:
	//  Succeeded - The certificate is available for use in pools.
	//  Deleting - The user has requested that the certificate be deleted, but the delete operation has not yet completed. You may not reference the certificate when creating or updating pools.
	//  Failed - The user requested that the certificate be deleted, but there are pools that still have references to the certificate, or it is still installed on one or more compute nodes. (The latter can occur if the certificate has been removed from the pool, but the node has not yet restarted. Nodes refresh their certificates only when they restart.) You may use the cancel certificate delete operation to cancel the delete, or the delete certificate operation to retry the delete. Possible values include: 'Succeeded', 'Deleting', 'Failed'
	ProvisioningState CertificateProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// PreviousProvisioningState - READ-ONLY; The previous provisioned state of the resource. Possible values include: 'Succeeded', 'Deleting', 'Failed'
	PreviousProvisioningState CertificateProvisioningState `json:"previousProvisioningState,omitempty"`
	// PreviousProvisioningStateTransitionTime - READ-ONLY
	PreviousProvisioningStateTransitionTime *date.Time `json:"previousProvisioningStateTransitionTime,omitempty"`
	// PublicData - READ-ONLY; The public key of the certificate.
	PublicData *string `json:"publicData,omitempty"`
	// DeleteCertificateError - READ-ONLY; This is only returned when the certificate provisioningState is 'Failed'.
	DeleteCertificateError *DeleteCertificateError `json:"deleteCertificateError,omitempty"`
	// ThumbprintAlgorithm - This must match the first portion of the certificate name. Currently required to be 'SHA1'.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// Thumbprint - This must match the thumbprint from the name.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Format - The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
	Format CertificateFormat `json:"format,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateProperties.
func (cp CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ThumbprintAlgorithm != nil {
		objectMap["thumbprintAlgorithm"] = cp.ThumbprintAlgorithm
	}
	if cp.Thumbprint != nil {
		objectMap["thumbprint"] = cp.Thumbprint
	}
	if cp.Format != "" {
		objectMap["format"] = cp.Format
	}
	return json.Marshal(objectMap)
}

// CertificateReference ...
type CertificateReference struct {
	ID *string `json:"id,omitempty"`
	// StoreLocation - The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory. Possible values include: 'CurrentUser', 'LocalMachine'
	StoreLocation CertificateStoreLocation `json:"storeLocation,omitempty"`
	// StoreName - This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
	StoreName *string `json:"storeName,omitempty"`
	// Visibility - Values are:
	//  starttask - The user account under which the start task is run.
	//  task - The accounts under which job tasks are run.
	//  remoteuser - The accounts under which users remotely access the node.
	//  You can specify more than one visibility in this collection. The default is all accounts.
	Visibility *[]CertificateVisibility `json:"visibility,omitempty"`
}

// CheckNameAvailabilityParameters parameters for a check name availability request.
type CheckNameAvailabilityParameters struct {
	// Name - The name to check for availability
	Name *string `json:"name,omitempty"`
	// Type - The resource type. Must be set to Microsoft.Batch/batchAccounts
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; Gets the reason that a Batch account name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'Invalid', 'AlreadyExists'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
	// Message - READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// CloudError an error response from the Batch service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Batch service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CloudServiceConfiguration ...
type CloudServiceConfiguration struct {
	// OsFamily - Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
	OsFamily *string `json:"osFamily,omitempty"`
	// TargetOSVersion - The default value is * which specifies the latest operating system version for the specified OS family.
	TargetOSVersion *string `json:"targetOSVersion,omitempty"`
	// CurrentOSVersion - This may differ from targetOSVersion if the pool state is Upgrading. In this case some virtual machines may be on the targetOSVersion and some may be on the currentOSVersion during the upgrade process. Once all virtual machines have upgraded, currentOSVersion is updated to be the same as targetOSVersion.
	CurrentOSVersion *string `json:"currentOSVersion,omitempty"`
}

// DataDisk data Disk settings which will be used by the data disks associated to Compute Nodes in the
// pool.
type DataDisk struct {
	// Lun - The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
	Lun *int32 `json:"lun,omitempty"`
	// Caching - Values are:
	//  none - The caching mode for the disk is not enabled.
	//  readOnly - The caching mode for the disk is read only.
	//  readWrite - The caching mode for the disk is read and write.
	//  The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. Possible values include: 'None', 'ReadOnly', 'ReadWrite'
	Caching    CachingType `json:"caching,omitempty"`
	DiskSizeGB *int32      `json:"diskSizeGB,omitempty"`
	// StorageAccountType - If omitted, the default is "Standard_LRS". Values are:
	//  Standard_LRS - The data disk should use standard locally redundant storage.
	//  Premium_LRS - The data disk should use premium locally redundant storage. Possible values include: 'StandardLRS', 'PremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
}

// DeleteCertificateError an error response from the Batch service.
type DeleteCertificateError struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]DeleteCertificateError `json:"details,omitempty"`
}

// DeploymentConfiguration ...
type DeploymentConfiguration struct {
	// CloudServiceConfiguration - This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
}

// EnvironmentSetting ...
type EnvironmentSetting struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// FixedScaleSettings ...
type FixedScaleSettings struct {
	// ResizeTimeout - The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicatedNodes - At least one of targetDedicatedNodes, targetLowPriority nodes must be set.
	TargetDedicatedNodes *int32 `json:"targetDedicatedNodes,omitempty"`
	// TargetLowPriorityNodes - At least one of targetDedicatedNodes, targetLowPriority nodes must be set.
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// NodeDeallocationOption - If omitted, the default value is Requeue. Possible values include: 'Requeue', 'Terminate', 'TaskCompletion', 'RetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// ImageReference ...
type ImageReference struct {
	// Publisher - For example, Canonical or MicrosoftWindowsServer.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - For example, UbuntuServer or WindowsServer.
	Offer *string `json:"offer,omitempty"`
	// Sku - For example, 14.04.0-LTS or 2012-R2-Datacenter.
	Sku *string `json:"sku,omitempty"`
	// Version - A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
	Version *string `json:"version,omitempty"`
	// ID - This property is mutually exclusive with other properties. The virtual machine image must be in the same region and subscription as the Azure Batch account. For information about the firewall settings for Batch node agent to communicate with Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration .
	ID *string `json:"id,omitempty"`
}

// InboundNatPool ...
type InboundNatPool struct {
	// Name - The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
	Name *string `json:"name,omitempty"`
	// Protocol - Possible values include: 'TCP', 'UDP'
	Protocol InboundEndpointProtocol `json:"protocol,omitempty"`
	// BackendPort - This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// FrontendPortRangeStart - Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// NetworkSecurityGroupRules - The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
	NetworkSecurityGroupRules *[]NetworkSecurityGroupRule `json:"networkSecurityGroupRules,omitempty"`
}

// KeyVaultReference identifies the Azure key vault associated with a Batch account.
type KeyVaultReference struct {
	// ID - The resource ID of the Azure key vault associated with the Batch account.
	ID *string `json:"id,omitempty"`
	// URL - The URL of the Azure key vault associated with the Batch account.
	URL *string `json:"url,omitempty"`
}

// LinuxUserConfiguration ...
type LinuxUserConfiguration struct {
	// UID - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
	UID *int32 `json:"uid,omitempty"`
	// Gid - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
	Gid *int32 `json:"gid,omitempty"`
	// SSHPrivateKey - The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
	SSHPrivateKey *string `json:"sshPrivateKey,omitempty"`
}

// ListApplicationsResult the result of performing list applications.
type ListApplicationsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of applications.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListApplicationsResultIterator provides access to a complete listing of Application values.
type ListApplicationsResultIterator struct {
	i    int
	page ListApplicationsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListApplicationsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListApplicationsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListApplicationsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListApplicationsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListApplicationsResultIterator) Response() ListApplicationsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListApplicationsResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListApplicationsResultIterator type.
func NewListApplicationsResultIterator(page ListApplicationsResultPage) ListApplicationsResultIterator {
	return ListApplicationsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lar ListApplicationsResult) IsEmpty() bool {
	return lar.Value == nil || len(*lar.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lar ListApplicationsResult) hasNextLink() bool {
	return lar.NextLink != nil && len(*lar.NextLink) != 0
}

// listApplicationsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lar ListApplicationsResult) listApplicationsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lar.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lar.NextLink)))
}

// ListApplicationsResultPage contains a page of Application values.
type ListApplicationsResultPage struct {
	fn  func(context.Context, ListApplicationsResult) (ListApplicationsResult, error)
	lar ListApplicationsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListApplicationsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListApplicationsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lar)
		if err != nil {
			return err
		}
		page.lar = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListApplicationsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListApplicationsResultPage) NotDone() bool {
	return !page.lar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListApplicationsResultPage) Response() ListApplicationsResult {
	return page.lar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListApplicationsResultPage) Values() []Application {
	if page.lar.IsEmpty() {
		return nil
	}
	return *page.lar.Value
}

// Creates a new instance of the ListApplicationsResultPage type.
func NewListApplicationsResultPage(cur ListApplicationsResult, getNextPage func(context.Context, ListApplicationsResult) (ListApplicationsResult, error)) ListApplicationsResultPage {
	return ListApplicationsResultPage{
		fn:  getNextPage,
		lar: cur,
	}
}

// ListCertificatesResult values returned by the List operation.
type ListCertificatesResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned certificates.
	Value *[]Certificate `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListCertificatesResultIterator provides access to a complete listing of Certificate values.
type ListCertificatesResultIterator struct {
	i    int
	page ListCertificatesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListCertificatesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListCertificatesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListCertificatesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListCertificatesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListCertificatesResultIterator) Response() ListCertificatesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListCertificatesResultIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListCertificatesResultIterator type.
func NewListCertificatesResultIterator(page ListCertificatesResultPage) ListCertificatesResultIterator {
	return ListCertificatesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lcr ListCertificatesResult) IsEmpty() bool {
	return lcr.Value == nil || len(*lcr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lcr ListCertificatesResult) hasNextLink() bool {
	return lcr.NextLink != nil && len(*lcr.NextLink) != 0
}

// listCertificatesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lcr ListCertificatesResult) listCertificatesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lcr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lcr.NextLink)))
}

// ListCertificatesResultPage contains a page of Certificate values.
type ListCertificatesResultPage struct {
	fn  func(context.Context, ListCertificatesResult) (ListCertificatesResult, error)
	lcr ListCertificatesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListCertificatesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListCertificatesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lcr)
		if err != nil {
			return err
		}
		page.lcr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListCertificatesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListCertificatesResultPage) NotDone() bool {
	return !page.lcr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListCertificatesResultPage) Response() ListCertificatesResult {
	return page.lcr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListCertificatesResultPage) Values() []Certificate {
	if page.lcr.IsEmpty() {
		return nil
	}
	return *page.lcr.Value
}

// Creates a new instance of the ListCertificatesResultPage type.
func NewListCertificatesResultPage(cur ListCertificatesResult, getNextPage func(context.Context, ListCertificatesResult) (ListCertificatesResult, error)) ListCertificatesResultPage {
	return ListCertificatesResultPage{
		fn:  getNextPage,
		lcr: cur,
	}
}

// ListPoolsResult values returned by the List operation.
type ListPoolsResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned pools.
	Value *[]Pool `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListPoolsResultIterator provides access to a complete listing of Pool values.
type ListPoolsResultIterator struct {
	i    int
	page ListPoolsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListPoolsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPoolsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListPoolsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListPoolsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListPoolsResultIterator) Response() ListPoolsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListPoolsResultIterator) Value() Pool {
	if !iter.page.NotDone() {
		return Pool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListPoolsResultIterator type.
func NewListPoolsResultIterator(page ListPoolsResultPage) ListPoolsResultIterator {
	return ListPoolsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lpr ListPoolsResult) IsEmpty() bool {
	return lpr.Value == nil || len(*lpr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lpr ListPoolsResult) hasNextLink() bool {
	return lpr.NextLink != nil && len(*lpr.NextLink) != 0
}

// listPoolsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lpr ListPoolsResult) listPoolsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lpr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lpr.NextLink)))
}

// ListPoolsResultPage contains a page of Pool values.
type ListPoolsResultPage struct {
	fn  func(context.Context, ListPoolsResult) (ListPoolsResult, error)
	lpr ListPoolsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPoolsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPoolsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lpr)
		if err != nil {
			return err
		}
		page.lpr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListPoolsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPoolsResultPage) NotDone() bool {
	return !page.lpr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPoolsResultPage) Response() ListPoolsResult {
	return page.lpr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPoolsResultPage) Values() []Pool {
	if page.lpr.IsEmpty() {
		return nil
	}
	return *page.lpr.Value
}

// Creates a new instance of the ListPoolsResultPage type.
func NewListPoolsResultPage(cur ListPoolsResult, getNextPage func(context.Context, ListPoolsResult) (ListPoolsResult, error)) ListPoolsResultPage {
	return ListPoolsResultPage{
		fn:  getNextPage,
		lpr: cur,
	}
}

// LocationQuota quotas associated with a Batch region for a particular subscription.
type LocationQuota struct {
	autorest.Response `json:"-"`
	// AccountQuota - READ-ONLY; The number of Batch accounts that may be created under the subscription in the specified region.
	AccountQuota *int32 `json:"accountQuota,omitempty"`
}

// MetadataItem the Batch service does not assign any meaning to this metadata; it is solely for the use of
// user code.
type MetadataItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// NetworkConfiguration the network configuration for a pool.
type NetworkConfiguration struct {
	// SubnetID - The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes, and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. For pools created via virtualMachineConfiguration the Batch account must have poolAllocationMode userSubscription in order to use a VNet. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
	SubnetID *string `json:"subnetId,omitempty"`
	// EndpointConfiguration - Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
	EndpointConfiguration *PoolEndpointConfiguration `json:"endpointConfiguration,omitempty"`
}

// NetworkSecurityGroupRule ...
type NetworkSecurityGroupRule struct {
	// Priority - Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 3500. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
	Priority *int32 `json:"priority,omitempty"`
	// Access - Possible values include: 'Allow', 'Deny'
	Access NetworkSecurityGroupRuleAccess `json:"access,omitempty"`
	// SourceAddressPrefix - Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
}

// Operation ...
type Operation struct {
	// Name - This is of the format {provider}/{resource}/{operation}
	Name       *string           `json:"name,omitempty"`
	Display    *OperationDisplay `json:"display,omitempty"`
	Origin     *string           `json:"origin,omitempty"`
	Properties interface{}       `json:"properties,omitempty"`
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider *string `json:"provider,omitempty"`
	// Operation - For example: read, write, delete, or listKeys/action
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult ...
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OSDisk ...
type OSDisk struct {
	// Caching - Default value is none. Possible values include: 'None', 'ReadOnly', 'ReadWrite'
	Caching CachingType `json:"caching,omitempty"`
}

// Pool contains information about a pool.
type Pool struct {
	autorest.Response `json:"-"`
	// PoolProperties - The properties associated with the pool.
	*PoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Pool.
func (p Pool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PoolProperties != nil {
		objectMap["properties"] = p.PoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Pool struct.
func (p *Pool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var poolProperties PoolProperties
				err = json.Unmarshal(*v, &poolProperties)
				if err != nil {
					return err
				}
				p.PoolProperties = &poolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		}
	}

	return nil
}

// PoolCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PoolCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoolClient) (Pool, error)
}

// PoolDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PoolDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoolClient) (autorest.Response, error)
}

// PoolEndpointConfiguration ...
type PoolEndpointConfiguration struct {
	// InboundNatPools - The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400.
	InboundNatPools *[]InboundNatPool `json:"inboundNatPools,omitempty"`
}

// PoolProperties pool properties.
type PoolProperties struct {
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// LastModified - READ-ONLY; This is the last time at which the pool level data, such as the targetDedicatedNodes or autoScaleSettings, changed. It does not factor in node-level changes such as a compute node changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// CreationTime - READ-ONLY
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - READ-ONLY; Values are:
	//  Succeeded - The pool is available to run tasks subject to the availability of compute nodes.
	//  Deleting - The user has requested that the pool be deleted, but the delete operation has not yet completed. Possible values include: 'PoolProvisioningStateSucceeded', 'PoolProvisioningStateDeleting'
	ProvisioningState PoolProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// AllocationState - READ-ONLY; Values are:
	//  Steady - The pool is not resizing. There are no changes to the number of nodes in the pool in progress. A pool enters this state when it is created and when no operations are being performed on the pool to change the number of dedicated nodes.
	//  Resizing - The pool is resizing; that is, compute nodes are being added to or removed from the pool.
	//  Stopping - The pool was resizing, but the user has requested that the resize be stopped, but the stop request has not yet been completed. Possible values include: 'Steady', 'Resizing', 'Stopping'
	AllocationState AllocationState `json:"allocationState,omitempty"`
	// AllocationStateTransitionTime - READ-ONLY
	AllocationStateTransitionTime *date.Time `json:"allocationStateTransitionTime,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// DeploymentConfiguration - Using CloudServiceConfiguration specifies that the nodes should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure Virtual Machines (IaaS).
	DeploymentConfiguration *DeploymentConfiguration `json:"deploymentConfiguration,omitempty"`
	// CurrentDedicatedNodes - READ-ONLY
	CurrentDedicatedNodes *int32 `json:"currentDedicatedNodes,omitempty"`
	// CurrentLowPriorityNodes - READ-ONLY
	CurrentLowPriorityNodes *int32         `json:"currentLowPriorityNodes,omitempty"`
	ScaleSettings           *ScaleSettings `json:"scaleSettings,omitempty"`
	// AutoScaleRun - READ-ONLY; This property is set only if the pool automatically scales, i.e. autoScaleSettings are used.
	AutoScaleRun *AutoScaleRun `json:"autoScaleRun,omitempty"`
	// InterNodeCommunication - This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'. Possible values include: 'Enabled', 'Disabled'
	InterNodeCommunication InterNodeCommunicationState `json:"interNodeCommunication,omitempty"`
	NetworkConfiguration   *NetworkConfiguration       `json:"networkConfiguration,omitempty"`
	MaxTasksPerNode        *int32                      `json:"maxTasksPerNode,omitempty"`
	TaskSchedulingPolicy   *TaskSchedulingPolicy       `json:"taskSchedulingPolicy,omitempty"`
	UserAccounts           *[]UserAccount              `json:"userAccounts,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// StartTask - In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// Certificates - For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	Certificates *[]CertificateReference `json:"certificates,omitempty"`
	// ApplicationPackages - Changes to application packages affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged.
	ApplicationPackages *[]ApplicationPackageReference `json:"applicationPackages,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
	ApplicationLicenses *[]string `json:"applicationLicenses,omitempty"`
	// ResizeOperationStatus - READ-ONLY
	ResizeOperationStatus *ResizeOperationStatus `json:"resizeOperationStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for PoolProperties.
func (pp PoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.DisplayName != nil {
		objectMap["displayName"] = pp.DisplayName
	}
	if pp.VMSize != nil {
		objectMap["vmSize"] = pp.VMSize
	}
	if pp.DeploymentConfiguration != nil {
		objectMap["deploymentConfiguration"] = pp.DeploymentConfiguration
	}
	if pp.ScaleSettings != nil {
		objectMap["scaleSettings"] = pp.ScaleSettings
	}
	if pp.InterNodeCommunication != "" {
		objectMap["interNodeCommunication"] = pp.InterNodeCommunication
	}
	if pp.NetworkConfiguration != nil {
		objectMap["networkConfiguration"] = pp.NetworkConfiguration
	}
	if pp.MaxTasksPerNode != nil {
		objectMap["maxTasksPerNode"] = pp.MaxTasksPerNode
	}
	if pp.TaskSchedulingPolicy != nil {
		objectMap["taskSchedulingPolicy"] = pp.TaskSchedulingPolicy
	}
	if pp.UserAccounts != nil {
		objectMap["userAccounts"] = pp.UserAccounts
	}
	if pp.Metadata != nil {
		objectMap["metadata"] = pp.Metadata
	}
	if pp.StartTask != nil {
		objectMap["startTask"] = pp.StartTask
	}
	if pp.Certificates != nil {
		objectMap["certificates"] = pp.Certificates
	}
	if pp.ApplicationPackages != nil {
		objectMap["applicationPackages"] = pp.ApplicationPackages
	}
	if pp.ApplicationLicenses != nil {
		objectMap["applicationLicenses"] = pp.ApplicationLicenses
	}
	return json.Marshal(objectMap)
}

// ProxyResource a definition of an Azure resource.
type ProxyResource struct {
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// ResizeError ...
type ResizeError struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string        `json:"message,omitempty"`
	Details *[]ResizeError `json:"details,omitempty"`
}

// ResizeOperationStatus describes either the current operation (if the pool AllocationState is Resizing)
// or the previously completed operation (if the AllocationState is Steady).
type ResizeOperationStatus struct {
	TargetDedicatedNodes   *int32 `json:"targetDedicatedNodes,omitempty"`
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// ResizeTimeout - The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - The default value is requeue. Possible values include: 'Requeue', 'Terminate', 'TaskCompletion', 'RetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
	StartTime              *date.Time                    `json:"startTime,omitempty"`
	// Errors - This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady.
	Errors *[]ResizeError `json:"errors,omitempty"`
}

// Resource a definition of an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceFile ...
type ResourceFile struct {
	// BlobSource - This URL must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
	BlobSource *string `json:"blobSource,omitempty"`
	FilePath   *string `json:"filePath,omitempty"`
	// FileMode - This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
	FileMode *string `json:"fileMode,omitempty"`
}

// ScaleSettings defines the desired size of the pool. This can either be 'fixedScale' where the requested
// targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically
// reevaluated. If this property is not specified, the pool will have a fixed scale with 0
// targetDedicatedNodes.
type ScaleSettings struct {
	// FixedScale - This property and autoScale are mutually exclusive and one of the properties must be specified.
	FixedScale *FixedScaleSettings `json:"fixedScale,omitempty"`
	// AutoScale - This property and fixedScale are mutually exclusive and one of the properties must be specified.
	AutoScale *AutoScaleSettings `json:"autoScale,omitempty"`
}

// StartTask ...
type StartTask struct {
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
	CommandLine         *string               `json:"commandLine,omitempty"`
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// MaxTaskRetryCount - The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
	// WaitForSuccess - If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is false.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
}

// TaskSchedulingPolicy ...
type TaskSchedulingPolicy struct {
	// NodeFillType - Possible values include: 'Spread', 'Pack'
	NodeFillType ComputeNodeFillType `json:"nodeFillType,omitempty"`
}

// UserAccount ...
type UserAccount struct {
	Name     *string `json:"name,omitempty"`
	Password *string `json:"password,omitempty"`
	// ElevationLevel - nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
	// LinuxUserConfiguration - This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
	LinuxUserConfiguration *LinuxUserConfiguration `json:"linuxUserConfiguration,omitempty"`
}

// UserIdentity specify either the userName or autoUser property, but not both.
type UserIdentity struct {
	// UserName - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	UserName *string `json:"userName,omitempty"`
	// AutoUser - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	AutoUser *AutoUserSpecification `json:"autoUser,omitempty"`
}

// VirtualMachineConfiguration ...
type VirtualMachineConfiguration struct {
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	OsDisk         *OSDisk         `json:"osDisk,omitempty"`
	// NodeAgentSkuID - The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
	NodeAgentSkuID *string `json:"nodeAgentSkuId,omitempty"`
	// WindowsConfiguration - This property must not be specified if the imageReference specifies a Linux OS image.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	// DataDisks - This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
	DataDisks *[]DataDisk `json:"dataDisks,omitempty"`
	// LicenseType - This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
	//  Windows_Server - The on-premises license is for Windows Server.
	//  Windows_Client - The on-premises license is for Windows Client.
	LicenseType *string `json:"licenseType,omitempty"`
}

// WindowsConfiguration ...
type WindowsConfiguration struct {
	// EnableAutomaticUpdates - If omitted, the default value is true.
	EnableAutomaticUpdates *bool `json:"enableAutomaticUpdates,omitempty"`
}
