// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/bigquery/reservation/v1beta1/reservation.proto

package reservation

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Commitment plan defines the current committed period. Capacity commitment
// cannot be deleted during it's committed period.
type CapacityCommitment_CommitmentPlan int32

const (
	// Invalid plan value. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED CapacityCommitment_CommitmentPlan = 0
	// Flex commitments have committed period of 1 minute after becoming ACTIVE.
	// After that, they are not in a committed period anymore and can be removed
	// any time.
	CapacityCommitment_FLEX CapacityCommitment_CommitmentPlan = 3
	// Trial commitments have a committed period of 182 days after becoming
	// ACTIVE. After that, they are converted to a new commitment based on the
	// `renewal_plan`. Default `renewal_plan` for Trial commitment is Flex so
	// that it can be deleted right after committed period ends.
	CapacityCommitment_TRIAL CapacityCommitment_CommitmentPlan = 5
	// Monthly commitments have a committed period of 30 days after becoming
	// ACTIVE. After that, they are not in a committed period anymore and can be
	// removed any time.
	CapacityCommitment_MONTHLY CapacityCommitment_CommitmentPlan = 2
	// Annual commitments have a committed period of 365 days after becoming
	// ACTIVE. After that they are converted to a new commitment based on the
	// renewal_plan.
	CapacityCommitment_ANNUAL CapacityCommitment_CommitmentPlan = 4
)

// Enum value maps for CapacityCommitment_CommitmentPlan.
var (
	CapacityCommitment_CommitmentPlan_name = map[int32]string{
		0: "COMMITMENT_PLAN_UNSPECIFIED",
		3: "FLEX",
		5: "TRIAL",
		2: "MONTHLY",
		4: "ANNUAL",
	}
	CapacityCommitment_CommitmentPlan_value = map[string]int32{
		"COMMITMENT_PLAN_UNSPECIFIED": 0,
		"FLEX":                        3,
		"TRIAL":                       5,
		"MONTHLY":                     2,
		"ANNUAL":                      4,
	}
)

func (x CapacityCommitment_CommitmentPlan) Enum() *CapacityCommitment_CommitmentPlan {
	p := new(CapacityCommitment_CommitmentPlan)
	*p = x
	return p
}

func (x CapacityCommitment_CommitmentPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CapacityCommitment_CommitmentPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[0].Descriptor()
}

func (CapacityCommitment_CommitmentPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[0]
}

func (x CapacityCommitment_CommitmentPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CapacityCommitment_CommitmentPlan.Descriptor instead.
func (CapacityCommitment_CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{1, 0}
}

// Capacity commitment can either become ACTIVE right away or transition
// from PENDING to ACTIVE or FAILED.
type CapacityCommitment_State int32

const (
	// Invalid state value.
	CapacityCommitment_STATE_UNSPECIFIED CapacityCommitment_State = 0
	// Capacity commitment is pending provisioning. Pending capacity commitment
	// does not contribute to the parent's slot_capacity.
	CapacityCommitment_PENDING CapacityCommitment_State = 1
	// Once slots are provisioned, capacity commitment becomes active.
	// slot_count is added to the parent's slot_capacity.
	CapacityCommitment_ACTIVE CapacityCommitment_State = 2
	// Capacity commitment is failed to be activated by the backend.
	CapacityCommitment_FAILED CapacityCommitment_State = 3
)

// Enum value maps for CapacityCommitment_State.
var (
	CapacityCommitment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
		3: "FAILED",
	}
	CapacityCommitment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ACTIVE":            2,
		"FAILED":            3,
	}
)

func (x CapacityCommitment_State) Enum() *CapacityCommitment_State {
	p := new(CapacityCommitment_State)
	*p = x
	return p
}

func (x CapacityCommitment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CapacityCommitment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[1].Descriptor()
}

func (CapacityCommitment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[1]
}

func (x CapacityCommitment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CapacityCommitment_State.Descriptor instead.
func (CapacityCommitment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{1, 1}
}

// Types of job, which could be specified when using the reservation.
type Assignment_JobType int32

const (
	// Invalid type. Requests with this value will be rejected with
	// error code `google.rpc.Code.INVALID_ARGUMENT`.
	Assignment_JOB_TYPE_UNSPECIFIED Assignment_JobType = 0
	// Pipeline (load/export) jobs from the project will use the reservation.
	Assignment_PIPELINE Assignment_JobType = 1
	// Query jobs from the project will use the reservation.
	Assignment_QUERY Assignment_JobType = 2
)

// Enum value maps for Assignment_JobType.
var (
	Assignment_JobType_name = map[int32]string{
		0: "JOB_TYPE_UNSPECIFIED",
		1: "PIPELINE",
		2: "QUERY",
	}
	Assignment_JobType_value = map[string]int32{
		"JOB_TYPE_UNSPECIFIED": 0,
		"PIPELINE":             1,
		"QUERY":                2,
	}
)

func (x Assignment_JobType) Enum() *Assignment_JobType {
	p := new(Assignment_JobType)
	*p = x
	return p
}

func (x Assignment_JobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Assignment_JobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[2].Descriptor()
}

func (Assignment_JobType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[2]
}

func (x Assignment_JobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Assignment_JobType.Descriptor instead.
func (Assignment_JobType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{17, 0}
}

// Assignment will remain in PENDING state if no active capacity commitment is
// present. It will become ACTIVE when some capacity commitment becomes
// active.
type Assignment_State int32

const (
	// Invalid state value.
	Assignment_STATE_UNSPECIFIED Assignment_State = 0
	// Queries from assignee will be executed as on-demand, if related
	// assignment is pending.
	Assignment_PENDING Assignment_State = 1
	// Assignment is ready.
	Assignment_ACTIVE Assignment_State = 2
)

// Enum value maps for Assignment_State.
var (
	Assignment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
	}
	Assignment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ACTIVE":            2,
	}
)

func (x Assignment_State) Enum() *Assignment_State {
	p := new(Assignment_State)
	*p = x
	return p
}

func (x Assignment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Assignment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[3].Descriptor()
}

func (Assignment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes[3]
}

func (x Assignment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Assignment_State.Descriptor instead.
func (Assignment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{17, 1}
}

// A reservation is a mechanism used to guarantee slots to users.
type Reservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the reservation, e.g.,
	// `projects/*/locations/*/reservations/team1-prod`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Minimum slots available to this reservation. A slot is a unit of
	// computational power in BigQuery, and serves as the unit of parallelism.
	//
	// Queries using this reservation might use more slots during runtime if
	// ignore_idle_slots is set to false.
	//
	// If the new reservation's slot capacity exceed the parent's slot capacity or
	// if total slot capacity of the new reservation and its siblings exceeds the
	// parent's slot capacity, the request will fail with
	// `google.rpc.Code.RESOURCE_EXHAUSTED`.
	SlotCapacity int64 `protobuf:"varint,2,opt,name=slot_capacity,json=slotCapacity,proto3" json:"slot_capacity,omitempty"`
	// If false, any query using this reservation will use idle slots from other
	// reservations within the same admin project. If true, a query using this
	// reservation will execute with the slot capacity specified above at most.
	IgnoreIdleSlots bool `protobuf:"varint,4,opt,name=ignore_idle_slots,json=ignoreIdleSlots,proto3" json:"ignore_idle_slots,omitempty"`
}

func (x *Reservation) Reset() {
	*x = Reservation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Reservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reservation) ProtoMessage() {}

func (x *Reservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reservation.ProtoReflect.Descriptor instead.
func (*Reservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{0}
}

func (x *Reservation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Reservation) GetSlotCapacity() int64 {
	if x != nil {
		return x.SlotCapacity
	}
	return 0
}

func (x *Reservation) GetIgnoreIdleSlots() bool {
	if x != nil {
		return x.IgnoreIdleSlots
	}
	return false
}

// Capacity commitment is a way to purchase compute capacity for BigQuery jobs
// (in the form of slots) with some committed period of usage. Annual
// commitments renew by default. Commitments can be removed after their
// commitment end time passes.
//
// In order to remove annual commitment, its plan needs to be changed
// to monthly or flex first.
//
// A capacity commitment resource exists as a child resource of the admin
// project.
type CapacityCommitment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the capacity commitment, e.g.,
	// `projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of slots in this commitment.
	SlotCount int64 `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
	// Capacity commitment commitment plan.
	Plan CapacityCommitment_CommitmentPlan `protobuf:"varint,3,opt,name=plan,proto3,enum=google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_CommitmentPlan" json:"plan,omitempty"`
	// Output only. State of the commitment.
	State CapacityCommitment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_State" json:"state,omitempty"`
	// Output only. The end of the current commitment period. It is applicable
	// only for ACTIVE capacity commitments.
	CommitmentEndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=commitment_end_time,json=commitmentEndTime,proto3" json:"commitment_end_time,omitempty"`
	// Output only. For FAILED commitment plan, provides the reason of failure.
	FailureStatus *status.Status `protobuf:"bytes,7,opt,name=failure_status,json=failureStatus,proto3" json:"failure_status,omitempty"`
	// The plan this capacity commitment is converted to after commitment_end_time
	// passes. Once the plan is changed, committed period is extended according to
	// commitment plan. Only applicable for ANNUAL commitments.
	RenewalPlan CapacityCommitment_CommitmentPlan `protobuf:"varint,8,opt,name=renewal_plan,json=renewalPlan,proto3,enum=google.cloud.bigquery.reservation.v1beta1.CapacityCommitment_CommitmentPlan" json:"renewal_plan,omitempty"`
}

func (x *CapacityCommitment) Reset() {
	*x = CapacityCommitment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapacityCommitment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapacityCommitment) ProtoMessage() {}

func (x *CapacityCommitment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapacityCommitment.ProtoReflect.Descriptor instead.
func (*CapacityCommitment) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{1}
}

func (x *CapacityCommitment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CapacityCommitment) GetSlotCount() int64 {
	if x != nil {
		return x.SlotCount
	}
	return 0
}

func (x *CapacityCommitment) GetPlan() CapacityCommitment_CommitmentPlan {
	if x != nil {
		return x.Plan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

func (x *CapacityCommitment) GetState() CapacityCommitment_State {
	if x != nil {
		return x.State
	}
	return CapacityCommitment_STATE_UNSPECIFIED
}

func (x *CapacityCommitment) GetCommitmentEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitmentEndTime
	}
	return nil
}

func (x *CapacityCommitment) GetFailureStatus() *status.Status {
	if x != nil {
		return x.FailureStatus
	}
	return nil
}

func (x *CapacityCommitment) GetRenewalPlan() CapacityCommitment_CommitmentPlan {
	if x != nil {
		return x.RenewalPlan
	}
	return CapacityCommitment_COMMITMENT_PLAN_UNSPECIFIED
}

// The request for
// [ReservationService.CreateReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateReservation].
type CreateReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project, location. E.g.,
	// `projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The reservation ID. This field must only contain lower case alphanumeric
	// characters or dash. Max length is 64 characters.
	ReservationId string `protobuf:"bytes,2,opt,name=reservation_id,json=reservationId,proto3" json:"reservation_id,omitempty"`
	// Content of the new reservation to create.
	Reservation *Reservation `protobuf:"bytes,3,opt,name=reservation,proto3" json:"reservation,omitempty"`
}

func (x *CreateReservationRequest) Reset() {
	*x = CreateReservationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReservationRequest) ProtoMessage() {}

func (x *CreateReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReservationRequest.ProtoReflect.Descriptor instead.
func (*CreateReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{2}
}

func (x *CreateReservationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReservationRequest) GetReservationId() string {
	if x != nil {
		return x.ReservationId
	}
	return ""
}

func (x *CreateReservationRequest) GetReservation() *Reservation {
	if x != nil {
		return x.Reservation
	}
	return nil
}

// The request for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListReservations].
type ListReservationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name containing project and location, e.g.:
	//   `projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Can be used to filter out reservations based on names, capacity, etc, e.g.:
	// filter="reservation.slot_capacity > 200"
	// filter="reservation.name = \"*dev/*\""
	// Advanced filtering syntax can be
	// [here](https://cloud.google.com/logging/docs/view/advanced-filters).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListReservationsRequest) Reset() {
	*x = ListReservationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReservationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReservationsRequest) ProtoMessage() {}

func (x *ListReservationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReservationsRequest.ProtoReflect.Descriptor instead.
func (*ListReservationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{3}
}

func (x *ListReservationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReservationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReservationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReservationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for
// [ReservationService.ListReservations][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListReservations].
type ListReservationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of reservations visible to the user.
	Reservations []*Reservation `protobuf:"bytes,1,rep,name=reservations,proto3" json:"reservations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReservationsResponse) Reset() {
	*x = ListReservationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReservationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReservationsResponse) ProtoMessage() {}

func (x *ListReservationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReservationsResponse.ProtoReflect.Descriptor instead.
func (*ListReservationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{4}
}

func (x *ListReservationsResponse) GetReservations() []*Reservation {
	if x != nil {
		return x.Reservations
	}
	return nil
}

func (x *ListReservationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.GetReservation].
type GetReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the reservation to retrieve. E.g.,
	//    `projects/myproject/locations/US/reservations/team1-prod`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReservationRequest) Reset() {
	*x = GetReservationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReservationRequest) ProtoMessage() {}

func (x *GetReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReservationRequest.ProtoReflect.Descriptor instead.
func (*GetReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{5}
}

func (x *GetReservationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteReservation].
type DeleteReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the reservation to retrieve. E.g.,
	//    `projects/myproject/locations/US/reservations/team1-prod`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteReservationRequest) Reset() {
	*x = DeleteReservationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReservationRequest) ProtoMessage() {}

func (x *DeleteReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReservationRequest.ProtoReflect.Descriptor instead.
func (*DeleteReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteReservationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.UpdateReservation][google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateReservation].
type UpdateReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the reservation to update.
	Reservation *Reservation `protobuf:"bytes,1,opt,name=reservation,proto3" json:"reservation,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateReservationRequest) Reset() {
	*x = UpdateReservationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReservationRequest) ProtoMessage() {}

func (x *UpdateReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReservationRequest.ProtoReflect.Descriptor instead.
func (*UpdateReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateReservationRequest) GetReservation() *Reservation {
	if x != nil {
		return x.Reservation
	}
	return nil
}

func (x *UpdateReservationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for
// [ReservationService.CreateCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateCapacityCommitment].
type CreateCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent reservation. E.g.,
	//    `projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Content of the capacity commitment to create.
	CapacityCommitment *CapacityCommitment `protobuf:"bytes,2,opt,name=capacity_commitment,json=capacityCommitment,proto3" json:"capacity_commitment,omitempty"`
	// If true, fail the request if another project in the organization has a
	// capacity commitment.
	EnforceSingleAdminProjectPerOrg bool `protobuf:"varint,4,opt,name=enforce_single_admin_project_per_org,json=enforceSingleAdminProjectPerOrg,proto3" json:"enforce_single_admin_project_per_org,omitempty"`
}

func (x *CreateCapacityCommitmentRequest) Reset() {
	*x = CreateCapacityCommitmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCapacityCommitmentRequest) ProtoMessage() {}

func (x *CreateCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*CreateCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{8}
}

func (x *CreateCapacityCommitmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCapacityCommitmentRequest) GetCapacityCommitment() *CapacityCommitment {
	if x != nil {
		return x.CapacityCommitment
	}
	return nil
}

func (x *CreateCapacityCommitmentRequest) GetEnforceSingleAdminProjectPerOrg() bool {
	if x != nil {
		return x.EnforceSingleAdminProjectPerOrg
	}
	return false
}

// The request for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent reservation. E.g.,
	//    `projects/myproject/locations/US`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCapacityCommitmentsRequest) Reset() {
	*x = ListCapacityCommitmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCapacityCommitmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCapacityCommitmentsRequest) ProtoMessage() {}

func (x *ListCapacityCommitmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCapacityCommitmentsRequest.ProtoReflect.Descriptor instead.
func (*ListCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{9}
}

func (x *ListCapacityCommitmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCapacityCommitmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCapacityCommitmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListCapacityCommitments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListCapacityCommitments].
type ListCapacityCommitmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of capacity commitments visible to the user.
	CapacityCommitments []*CapacityCommitment `protobuf:"bytes,1,rep,name=capacity_commitments,json=capacityCommitments,proto3" json:"capacity_commitments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCapacityCommitmentsResponse) Reset() {
	*x = ListCapacityCommitmentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCapacityCommitmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCapacityCommitmentsResponse) ProtoMessage() {}

func (x *ListCapacityCommitmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCapacityCommitmentsResponse.ProtoReflect.Descriptor instead.
func (*ListCapacityCommitmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{10}
}

func (x *ListCapacityCommitmentsResponse) GetCapacityCommitments() []*CapacityCommitment {
	if x != nil {
		return x.CapacityCommitments
	}
	return nil
}

func (x *ListCapacityCommitmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.GetCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.GetCapacityCommitment].
type GetCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the capacity commitment to retrieve. E.g.,
	//    `projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCapacityCommitmentRequest) Reset() {
	*x = GetCapacityCommitmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCapacityCommitmentRequest) ProtoMessage() {}

func (x *GetCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*GetCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{11}
}

func (x *GetCapacityCommitmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.DeleteCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteCapacityCommitment].
type DeleteCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the capacity commitment to delete. E.g.,
	//    `projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCapacityCommitmentRequest) Reset() {
	*x = DeleteCapacityCommitmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCapacityCommitmentRequest) ProtoMessage() {}

func (x *DeleteCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteCapacityCommitmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.UpdateCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateCapacityCommitment].
type UpdateCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the capacity commitment to update.
	CapacityCommitment *CapacityCommitment `protobuf:"bytes,1,opt,name=capacity_commitment,json=capacityCommitment,proto3" json:"capacity_commitment,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCapacityCommitmentRequest) Reset() {
	*x = UpdateCapacityCommitmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCapacityCommitmentRequest) ProtoMessage() {}

func (x *UpdateCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*UpdateCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateCapacityCommitmentRequest) GetCapacityCommitment() *CapacityCommitment {
	if x != nil {
		return x.CapacityCommitment
	}
	return nil
}

func (x *UpdateCapacityCommitmentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name e.g.,:
	//  `projects/myproject/locations/US/capacityCommitments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of slots in the capacity commitment after the split.
	SlotCount int64 `protobuf:"varint,2,opt,name=slot_count,json=slotCount,proto3" json:"slot_count,omitempty"`
}

func (x *SplitCapacityCommitmentRequest) Reset() {
	*x = SplitCapacityCommitmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitCapacityCommitmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitCapacityCommitmentRequest) ProtoMessage() {}

func (x *SplitCapacityCommitmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitCapacityCommitmentRequest.ProtoReflect.Descriptor instead.
func (*SplitCapacityCommitmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{14}
}

func (x *SplitCapacityCommitmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SplitCapacityCommitmentRequest) GetSlotCount() int64 {
	if x != nil {
		return x.SlotCount
	}
	return 0
}

// The response for
// [ReservationService.SplitCapacityCommitment][google.cloud.bigquery.reservation.v1beta1.ReservationService.SplitCapacityCommitment].
type SplitCapacityCommitmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// First capacity commitment, result of a split.
	First *CapacityCommitment `protobuf:"bytes,1,opt,name=first,proto3" json:"first,omitempty"`
	// Second capacity commitment, result of a split.
	Second *CapacityCommitment `protobuf:"bytes,2,opt,name=second,proto3" json:"second,omitempty"`
}

func (x *SplitCapacityCommitmentResponse) Reset() {
	*x = SplitCapacityCommitmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitCapacityCommitmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitCapacityCommitmentResponse) ProtoMessage() {}

func (x *SplitCapacityCommitmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitCapacityCommitmentResponse.ProtoReflect.Descriptor instead.
func (*SplitCapacityCommitmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{15}
}

func (x *SplitCapacityCommitmentResponse) GetFirst() *CapacityCommitment {
	if x != nil {
		return x.First
	}
	return nil
}

func (x *SplitCapacityCommitmentResponse) GetSecond() *CapacityCommitment {
	if x != nil {
		return x.Second
	}
	return nil
}

// The request for
// [ReservationService.MergeCapacityCommitments][google.cloud.bigquery.reservation.v1beta1.ReservationService.MergeCapacityCommitments].
type MergeCapacityCommitmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parent resource that identifies admin project and location e.g.,
	//  `projects/myproject/locations/us`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Ids of capacity commitments to merge.
	// These capacity commitments must exist under admin project and location
	// specified in the parent.
	CapacityCommitmentIds []string `protobuf:"bytes,2,rep,name=capacity_commitment_ids,json=capacityCommitmentIds,proto3" json:"capacity_commitment_ids,omitempty"`
}

func (x *MergeCapacityCommitmentsRequest) Reset() {
	*x = MergeCapacityCommitmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeCapacityCommitmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeCapacityCommitmentsRequest) ProtoMessage() {}

func (x *MergeCapacityCommitmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeCapacityCommitmentsRequest.ProtoReflect.Descriptor instead.
func (*MergeCapacityCommitmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{16}
}

func (x *MergeCapacityCommitmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *MergeCapacityCommitmentsRequest) GetCapacityCommitmentIds() []string {
	if x != nil {
		return x.CapacityCommitmentIds
	}
	return nil
}

// A Assignment allows a project to submit jobs
// of a certain type using slots from the specified reservation.
type Assignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the resource. E.g.:
	// `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource which will use the reservation. E.g.
	// `projects/myproject`, `folders/123`, or `organizations/456`.
	Assignee string `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// Which type of jobs will use the reservation.
	JobType Assignment_JobType `protobuf:"varint,3,opt,name=job_type,json=jobType,proto3,enum=google.cloud.bigquery.reservation.v1beta1.Assignment_JobType" json:"job_type,omitempty"`
	// Output only. State of the assignment.
	State Assignment_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.bigquery.reservation.v1beta1.Assignment_State" json:"state,omitempty"`
}

func (x *Assignment) Reset() {
	*x = Assignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Assignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assignment) ProtoMessage() {}

func (x *Assignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assignment.ProtoReflect.Descriptor instead.
func (*Assignment) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{17}
}

func (x *Assignment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Assignment) GetAssignee() string {
	if x != nil {
		return x.Assignee
	}
	return ""
}

func (x *Assignment) GetJobType() Assignment_JobType {
	if x != nil {
		return x.JobType
	}
	return Assignment_JOB_TYPE_UNSPECIFIED
}

func (x *Assignment) GetState() Assignment_State {
	if x != nil {
		return x.State
	}
	return Assignment_STATE_UNSPECIFIED
}

// The request for
// [ReservationService.CreateAssignment][google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateAssignment].
// Note: "bigquery.reservationAssignments.create" permission is required on the
// related assignee.
type CreateAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name of the assignment
	// E.g. `projects/myproject/locations/US/reservations/team1-prod`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Assignment resource to create.
	Assignment *Assignment `protobuf:"bytes,2,opt,name=assignment,proto3" json:"assignment,omitempty"`
}

func (x *CreateAssignmentRequest) Reset() {
	*x = CreateAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAssignmentRequest) ProtoMessage() {}

func (x *CreateAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAssignmentRequest.ProtoReflect.Descriptor instead.
func (*CreateAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{18}
}

func (x *CreateAssignmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAssignmentRequest) GetAssignment() *Assignment {
	if x != nil {
		return x.Assignment
	}
	return nil
}

// The request for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListAssignments].
type ListAssignmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name e.g.:
	//
	// `projects/myproject/locations/US/reservations/team1-prod`
	//
	// Or:
	//
	// `projects/myproject/locations/US/reservations/-`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAssignmentsRequest) Reset() {
	*x = ListAssignmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssignmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssignmentsRequest) ProtoMessage() {}

func (x *ListAssignmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssignmentsRequest.ProtoReflect.Descriptor instead.
func (*ListAssignmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{19}
}

func (x *ListAssignmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssignmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssignmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.ListAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.ListAssignments].
type ListAssignmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAssignmentsResponse) Reset() {
	*x = ListAssignmentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssignmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssignmentsResponse) ProtoMessage() {}

func (x *ListAssignmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssignmentsResponse.ProtoReflect.Descriptor instead.
func (*ListAssignmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{20}
}

func (x *ListAssignmentsResponse) GetAssignments() []*Assignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

func (x *ListAssignmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.DeleteAssignment][google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteAssignment].
// Note: "bigquery.reservationAssignments.delete" permission is required on the
// related assignee.
type DeleteAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource, e.g.
	//   `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAssignmentRequest) Reset() {
	*x = DeleteAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAssignmentRequest) ProtoMessage() {}

func (x *DeleteAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAssignmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteAssignmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.SearchAssignments].
// Note: "bigquery.reservationAssignments.search" permission is required on the
// related assignee.
type SearchAssignmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the admin project(containing project and
	// location), e.g.:
	//   `projects/myproject/locations/US`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Please specify resource name as assignee in the query.
	//
	// Examples:
	//
	// * `assignee=projects/myproject`
	// * `assignee=folders/123`
	// * `assignee=organizations/456`
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchAssignmentsRequest) Reset() {
	*x = SearchAssignmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAssignmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssignmentsRequest) ProtoMessage() {}

func (x *SearchAssignmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssignmentsRequest.ProtoReflect.Descriptor instead.
func (*SearchAssignmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{22}
}

func (x *SearchAssignmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchAssignmentsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAssignmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAssignmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ReservationService.SearchAssignments][google.cloud.bigquery.reservation.v1beta1.ReservationService.SearchAssignments].
type SearchAssignmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of assignments visible to the user.
	Assignments []*Assignment `protobuf:"bytes,1,rep,name=assignments,proto3" json:"assignments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAssignmentsResponse) Reset() {
	*x = SearchAssignmentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAssignmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssignmentsResponse) ProtoMessage() {}

func (x *SearchAssignmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssignmentsResponse.ProtoReflect.Descriptor instead.
func (*SearchAssignmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{23}
}

func (x *SearchAssignmentsResponse) GetAssignments() []*Assignment {
	if x != nil {
		return x.Assignments
	}
	return nil
}

func (x *SearchAssignmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ReservationService.MoveAssignment][google.cloud.bigquery.reservation.v1beta1.ReservationService.MoveAssignment].
//
// **Note**: "bigquery.reservationAssignments.create" permission is required on
// the destination_id.
//
// **Note**: "bigquery.reservationAssignments.create" and
// "bigquery.reservationAssignments.delete" permission are required on the
// related assignee.
type MoveAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the assignment,
	// e.g.
	// `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The new reservation ID, e.g.:
	//   `projects/myotherproject/locations/US/reservations/team2-prod`
	DestinationId string `protobuf:"bytes,3,opt,name=destination_id,json=destinationId,proto3" json:"destination_id,omitempty"`
}

func (x *MoveAssignmentRequest) Reset() {
	*x = MoveAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveAssignmentRequest) ProtoMessage() {}

func (x *MoveAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveAssignmentRequest.ProtoReflect.Descriptor instead.
func (*MoveAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{24}
}

func (x *MoveAssignmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MoveAssignmentRequest) GetDestinationId() string {
	if x != nil {
		return x.DestinationId
	}
	return ""
}

// Represents a BI Reservation.
type BiReservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the singleton BI reservation.
	// Reservation names have the form
	// `projects/{project_id}/locations/{location_id}/bireservation`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The last update timestamp of a reservation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Size of a reservation, in bytes.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
}

func (x *BiReservation) Reset() {
	*x = BiReservation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BiReservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BiReservation) ProtoMessage() {}

func (x *BiReservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BiReservation.ProtoReflect.Descriptor instead.
func (*BiReservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{25}
}

func (x *BiReservation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BiReservation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BiReservation) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// A request to get a singleton BI reservation.
type GetBiReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the requested reservation, for example:
	// `projects/{project_id}/locations/{location_id}/bireservation`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBiReservationRequest) Reset() {
	*x = GetBiReservationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBiReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBiReservationRequest) ProtoMessage() {}

func (x *GetBiReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBiReservationRequest.ProtoReflect.Descriptor instead.
func (*GetBiReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{26}
}

func (x *GetBiReservationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to update a BI reservation.
type UpdateBiReservationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A reservation to update.
	Reservation *BiReservation `protobuf:"bytes,1,opt,name=reservation,proto3" json:"reservation,omitempty"`
	// A list of fields to be updated in this request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBiReservationRequest) Reset() {
	*x = UpdateBiReservationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBiReservationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBiReservationRequest) ProtoMessage() {}

func (x *UpdateBiReservationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBiReservationRequest.ProtoReflect.Descriptor instead.
func (*UpdateBiReservationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP(), []int{27}
}

func (x *UpdateBiReservationRequest) GetReservation() *BiReservation {
	if x != nil {
		return x.Reservation
	}
	return nil
}

func (x *UpdateBiReservationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_cloud_bigquery_reservation_v1beta1_reservation_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xeb, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6c, 0x6f, 0x74,
	0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0c, 0x73, 0x6c, 0x6f, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x12, 0x2a, 0x0a,
	0x11, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x49, 0x64, 0x6c, 0x65, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x22, 0xc7, 0x06, 0x0a, 0x12, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x6c, 0x6f, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x60, 0x0a, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x70,
	0x6c, 0x61, 0x6e, 0x12, 0x5e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x6f, 0x0a, 0x0c, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x5f,
	0x70, 0x6c, 0x61, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61,
	0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x22, 0x5f, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4d, 0x4d, 0x49,
	0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x45, 0x58,
	0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x10, 0x05, 0x12, 0x0b, 0x0a,
	0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4e,
	0x4e, 0x55, 0x41, 0x4c, 0x10, 0x04, 0x22, 0x43, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x8e, 0x01, 0xea, 0x41,
	0x8a, 0x01, 0x0a, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xeb, 0x01, 0x0a,
	0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x30, 0x12, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x58, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbd, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x9e, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x63, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x66, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x30, 0x0a, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb7, 0x02, 0x0a,
	0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x55, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x12, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6e, 0x0a, 0x13, 0x63, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x12, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x24, 0x65, 0x6e, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6f, 0x72, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x50, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x22, 0xb3, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x37, 0x12, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbb, 0x01, 0x0a,
	0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x70, 0x0a, 0x14, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x63,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x71, 0x0a, 0x1c, 0x47, 0x65,
	0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37,
	0x0a, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x74, 0x0a,
	0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x0a, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6e, 0x0a, 0x13, 0x63, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x12, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x92, 0x01, 0x0a, 0x1e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x0a, 0x35, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6c,
	0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x73, 0x6c, 0x6f, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xcd, 0x01, 0x0a, 0x1f, 0x53, 0x70,
	0x6c, 0x69, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a,
	0x05, 0x66, 0x69, 0x72, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x66, 0x69, 0x72,
	0x73, 0x74, 0x12, 0x55, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x22, 0xad, 0x01, 0x0a, 0x1f, 0x4d, 0x65,
	0x72, 0x67, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xfa,
	0x41, 0x37, 0x12, 0x35, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x15, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x22, 0xfd, 0x03, 0x0a, 0x0a, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x12, 0x58, 0x0a,
	0x08, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07,
	0x6a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x3c, 0x0a, 0x07, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f,
	0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x22, 0x37, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x3a, 0x90, 0x01, 0xea, 0x41, 0x8c, 0x01, 0x0a, 0x2d, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xbf, 0x01, 0x0a, 0x17, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xa3, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x9a, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a,
	0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x64,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a,
	0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaf, 0x01, 0x0a, 0x18, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbd, 0x01, 0x0a, 0x15, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x0e, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xf7, 0x01, 0x0a, 0x0d, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a,
	0x65, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a, 0x30, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x52, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x62, 0x69, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x7b, 0x62, 0x69, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22,
	0x67, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32,
	0x0a, 0x30, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x32, 0xcb, 0x25, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x80, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x44, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12, 0xe3, 0x01, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37,
	0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0xd0, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xb6, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x82, 0x02, 0x0a,
	0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x17, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0x9d, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x76, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x53, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a,
	0x13, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0xf6, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xec, 0x01, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x4b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x18, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb7, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x8f, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x67, 0x32, 0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x13, 0x63, 0x61, 0x70, 0x61,
	0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0xda,
	0x41, 0x1f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0x91, 0x02, 0x0a, 0x17, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x42, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x70, 0x6c, 0x69, 0x74,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x73, 0x6c, 0x6f, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x95, 0x02, 0x0a, 0x18, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x65, 0x72, 0x67, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1e, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x12, 0xfa, 0x01,
	0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x51, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x0a, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xee, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc2, 0x01, 0x0a, 0x10,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x52, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x2a, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xf1, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x12, 0xf4, 0x01, 0x0a, 0x0e, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f,
	0x76, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x13, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12, 0xd5, 0x01, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x42, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x43,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x87, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42,
	0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4f, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x3a, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0xda, 0x41, 0x17, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x1a, 0x7f, 0xca,
	0x41, 0x22, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb3,
	0x01, 0x0a, 0x2d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x50, 0x01, 0x5a, 0x54, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xca, 0x02, 0x29, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x5c, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescData = file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDesc
)

func file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescData)
	})
	return file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDescData
}

var file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_goTypes = []interface{}{
	(CapacityCommitment_CommitmentPlan)(0),  // 0: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.CommitmentPlan
	(CapacityCommitment_State)(0),           // 1: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.State
	(Assignment_JobType)(0),                 // 2: google.cloud.bigquery.reservation.v1beta1.Assignment.JobType
	(Assignment_State)(0),                   // 3: google.cloud.bigquery.reservation.v1beta1.Assignment.State
	(*Reservation)(nil),                     // 4: google.cloud.bigquery.reservation.v1beta1.Reservation
	(*CapacityCommitment)(nil),              // 5: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	(*CreateReservationRequest)(nil),        // 6: google.cloud.bigquery.reservation.v1beta1.CreateReservationRequest
	(*ListReservationsRequest)(nil),         // 7: google.cloud.bigquery.reservation.v1beta1.ListReservationsRequest
	(*ListReservationsResponse)(nil),        // 8: google.cloud.bigquery.reservation.v1beta1.ListReservationsResponse
	(*GetReservationRequest)(nil),           // 9: google.cloud.bigquery.reservation.v1beta1.GetReservationRequest
	(*DeleteReservationRequest)(nil),        // 10: google.cloud.bigquery.reservation.v1beta1.DeleteReservationRequest
	(*UpdateReservationRequest)(nil),        // 11: google.cloud.bigquery.reservation.v1beta1.UpdateReservationRequest
	(*CreateCapacityCommitmentRequest)(nil), // 12: google.cloud.bigquery.reservation.v1beta1.CreateCapacityCommitmentRequest
	(*ListCapacityCommitmentsRequest)(nil),  // 13: google.cloud.bigquery.reservation.v1beta1.ListCapacityCommitmentsRequest
	(*ListCapacityCommitmentsResponse)(nil), // 14: google.cloud.bigquery.reservation.v1beta1.ListCapacityCommitmentsResponse
	(*GetCapacityCommitmentRequest)(nil),    // 15: google.cloud.bigquery.reservation.v1beta1.GetCapacityCommitmentRequest
	(*DeleteCapacityCommitmentRequest)(nil), // 16: google.cloud.bigquery.reservation.v1beta1.DeleteCapacityCommitmentRequest
	(*UpdateCapacityCommitmentRequest)(nil), // 17: google.cloud.bigquery.reservation.v1beta1.UpdateCapacityCommitmentRequest
	(*SplitCapacityCommitmentRequest)(nil),  // 18: google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentRequest
	(*SplitCapacityCommitmentResponse)(nil), // 19: google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentResponse
	(*MergeCapacityCommitmentsRequest)(nil), // 20: google.cloud.bigquery.reservation.v1beta1.MergeCapacityCommitmentsRequest
	(*Assignment)(nil),                      // 21: google.cloud.bigquery.reservation.v1beta1.Assignment
	(*CreateAssignmentRequest)(nil),         // 22: google.cloud.bigquery.reservation.v1beta1.CreateAssignmentRequest
	(*ListAssignmentsRequest)(nil),          // 23: google.cloud.bigquery.reservation.v1beta1.ListAssignmentsRequest
	(*ListAssignmentsResponse)(nil),         // 24: google.cloud.bigquery.reservation.v1beta1.ListAssignmentsResponse
	(*DeleteAssignmentRequest)(nil),         // 25: google.cloud.bigquery.reservation.v1beta1.DeleteAssignmentRequest
	(*SearchAssignmentsRequest)(nil),        // 26: google.cloud.bigquery.reservation.v1beta1.SearchAssignmentsRequest
	(*SearchAssignmentsResponse)(nil),       // 27: google.cloud.bigquery.reservation.v1beta1.SearchAssignmentsResponse
	(*MoveAssignmentRequest)(nil),           // 28: google.cloud.bigquery.reservation.v1beta1.MoveAssignmentRequest
	(*BiReservation)(nil),                   // 29: google.cloud.bigquery.reservation.v1beta1.BiReservation
	(*GetBiReservationRequest)(nil),         // 30: google.cloud.bigquery.reservation.v1beta1.GetBiReservationRequest
	(*UpdateBiReservationRequest)(nil),      // 31: google.cloud.bigquery.reservation.v1beta1.UpdateBiReservationRequest
	(*timestamppb.Timestamp)(nil),           // 32: google.protobuf.Timestamp
	(*status.Status)(nil),                   // 33: google.rpc.Status
	(*fieldmaskpb.FieldMask)(nil),           // 34: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                   // 35: google.protobuf.Empty
}
var file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_depIdxs = []int32{
	0,  // 0: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.plan:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.CommitmentPlan
	1,  // 1: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.state:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.State
	32, // 2: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.commitment_end_time:type_name -> google.protobuf.Timestamp
	33, // 3: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.failure_status:type_name -> google.rpc.Status
	0,  // 4: google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.renewal_plan:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment.CommitmentPlan
	4,  // 5: google.cloud.bigquery.reservation.v1beta1.CreateReservationRequest.reservation:type_name -> google.cloud.bigquery.reservation.v1beta1.Reservation
	4,  // 6: google.cloud.bigquery.reservation.v1beta1.ListReservationsResponse.reservations:type_name -> google.cloud.bigquery.reservation.v1beta1.Reservation
	4,  // 7: google.cloud.bigquery.reservation.v1beta1.UpdateReservationRequest.reservation:type_name -> google.cloud.bigquery.reservation.v1beta1.Reservation
	34, // 8: google.cloud.bigquery.reservation.v1beta1.UpdateReservationRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 9: google.cloud.bigquery.reservation.v1beta1.CreateCapacityCommitmentRequest.capacity_commitment:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	5,  // 10: google.cloud.bigquery.reservation.v1beta1.ListCapacityCommitmentsResponse.capacity_commitments:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	5,  // 11: google.cloud.bigquery.reservation.v1beta1.UpdateCapacityCommitmentRequest.capacity_commitment:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	34, // 12: google.cloud.bigquery.reservation.v1beta1.UpdateCapacityCommitmentRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 13: google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentResponse.first:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	5,  // 14: google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentResponse.second:type_name -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	2,  // 15: google.cloud.bigquery.reservation.v1beta1.Assignment.job_type:type_name -> google.cloud.bigquery.reservation.v1beta1.Assignment.JobType
	3,  // 16: google.cloud.bigquery.reservation.v1beta1.Assignment.state:type_name -> google.cloud.bigquery.reservation.v1beta1.Assignment.State
	21, // 17: google.cloud.bigquery.reservation.v1beta1.CreateAssignmentRequest.assignment:type_name -> google.cloud.bigquery.reservation.v1beta1.Assignment
	21, // 18: google.cloud.bigquery.reservation.v1beta1.ListAssignmentsResponse.assignments:type_name -> google.cloud.bigquery.reservation.v1beta1.Assignment
	21, // 19: google.cloud.bigquery.reservation.v1beta1.SearchAssignmentsResponse.assignments:type_name -> google.cloud.bigquery.reservation.v1beta1.Assignment
	32, // 20: google.cloud.bigquery.reservation.v1beta1.BiReservation.update_time:type_name -> google.protobuf.Timestamp
	29, // 21: google.cloud.bigquery.reservation.v1beta1.UpdateBiReservationRequest.reservation:type_name -> google.cloud.bigquery.reservation.v1beta1.BiReservation
	34, // 22: google.cloud.bigquery.reservation.v1beta1.UpdateBiReservationRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 23: google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateReservation:input_type -> google.cloud.bigquery.reservation.v1beta1.CreateReservationRequest
	7,  // 24: google.cloud.bigquery.reservation.v1beta1.ReservationService.ListReservations:input_type -> google.cloud.bigquery.reservation.v1beta1.ListReservationsRequest
	9,  // 25: google.cloud.bigquery.reservation.v1beta1.ReservationService.GetReservation:input_type -> google.cloud.bigquery.reservation.v1beta1.GetReservationRequest
	10, // 26: google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteReservation:input_type -> google.cloud.bigquery.reservation.v1beta1.DeleteReservationRequest
	11, // 27: google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateReservation:input_type -> google.cloud.bigquery.reservation.v1beta1.UpdateReservationRequest
	12, // 28: google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1beta1.CreateCapacityCommitmentRequest
	13, // 29: google.cloud.bigquery.reservation.v1beta1.ReservationService.ListCapacityCommitments:input_type -> google.cloud.bigquery.reservation.v1beta1.ListCapacityCommitmentsRequest
	15, // 30: google.cloud.bigquery.reservation.v1beta1.ReservationService.GetCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1beta1.GetCapacityCommitmentRequest
	16, // 31: google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1beta1.DeleteCapacityCommitmentRequest
	17, // 32: google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1beta1.UpdateCapacityCommitmentRequest
	18, // 33: google.cloud.bigquery.reservation.v1beta1.ReservationService.SplitCapacityCommitment:input_type -> google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentRequest
	20, // 34: google.cloud.bigquery.reservation.v1beta1.ReservationService.MergeCapacityCommitments:input_type -> google.cloud.bigquery.reservation.v1beta1.MergeCapacityCommitmentsRequest
	22, // 35: google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateAssignment:input_type -> google.cloud.bigquery.reservation.v1beta1.CreateAssignmentRequest
	23, // 36: google.cloud.bigquery.reservation.v1beta1.ReservationService.ListAssignments:input_type -> google.cloud.bigquery.reservation.v1beta1.ListAssignmentsRequest
	25, // 37: google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteAssignment:input_type -> google.cloud.bigquery.reservation.v1beta1.DeleteAssignmentRequest
	26, // 38: google.cloud.bigquery.reservation.v1beta1.ReservationService.SearchAssignments:input_type -> google.cloud.bigquery.reservation.v1beta1.SearchAssignmentsRequest
	28, // 39: google.cloud.bigquery.reservation.v1beta1.ReservationService.MoveAssignment:input_type -> google.cloud.bigquery.reservation.v1beta1.MoveAssignmentRequest
	30, // 40: google.cloud.bigquery.reservation.v1beta1.ReservationService.GetBiReservation:input_type -> google.cloud.bigquery.reservation.v1beta1.GetBiReservationRequest
	31, // 41: google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateBiReservation:input_type -> google.cloud.bigquery.reservation.v1beta1.UpdateBiReservationRequest
	4,  // 42: google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateReservation:output_type -> google.cloud.bigquery.reservation.v1beta1.Reservation
	8,  // 43: google.cloud.bigquery.reservation.v1beta1.ReservationService.ListReservations:output_type -> google.cloud.bigquery.reservation.v1beta1.ListReservationsResponse
	4,  // 44: google.cloud.bigquery.reservation.v1beta1.ReservationService.GetReservation:output_type -> google.cloud.bigquery.reservation.v1beta1.Reservation
	35, // 45: google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteReservation:output_type -> google.protobuf.Empty
	4,  // 46: google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateReservation:output_type -> google.cloud.bigquery.reservation.v1beta1.Reservation
	5,  // 47: google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	14, // 48: google.cloud.bigquery.reservation.v1beta1.ReservationService.ListCapacityCommitments:output_type -> google.cloud.bigquery.reservation.v1beta1.ListCapacityCommitmentsResponse
	5,  // 49: google.cloud.bigquery.reservation.v1beta1.ReservationService.GetCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	35, // 50: google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteCapacityCommitment:output_type -> google.protobuf.Empty
	5,  // 51: google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	19, // 52: google.cloud.bigquery.reservation.v1beta1.ReservationService.SplitCapacityCommitment:output_type -> google.cloud.bigquery.reservation.v1beta1.SplitCapacityCommitmentResponse
	5,  // 53: google.cloud.bigquery.reservation.v1beta1.ReservationService.MergeCapacityCommitments:output_type -> google.cloud.bigquery.reservation.v1beta1.CapacityCommitment
	21, // 54: google.cloud.bigquery.reservation.v1beta1.ReservationService.CreateAssignment:output_type -> google.cloud.bigquery.reservation.v1beta1.Assignment
	24, // 55: google.cloud.bigquery.reservation.v1beta1.ReservationService.ListAssignments:output_type -> google.cloud.bigquery.reservation.v1beta1.ListAssignmentsResponse
	35, // 56: google.cloud.bigquery.reservation.v1beta1.ReservationService.DeleteAssignment:output_type -> google.protobuf.Empty
	27, // 57: google.cloud.bigquery.reservation.v1beta1.ReservationService.SearchAssignments:output_type -> google.cloud.bigquery.reservation.v1beta1.SearchAssignmentsResponse
	21, // 58: google.cloud.bigquery.reservation.v1beta1.ReservationService.MoveAssignment:output_type -> google.cloud.bigquery.reservation.v1beta1.Assignment
	29, // 59: google.cloud.bigquery.reservation.v1beta1.ReservationService.GetBiReservation:output_type -> google.cloud.bigquery.reservation.v1beta1.BiReservation
	29, // 60: google.cloud.bigquery.reservation.v1beta1.ReservationService.UpdateBiReservation:output_type -> google.cloud.bigquery.reservation.v1beta1.BiReservation
	42, // [42:61] is the sub-list for method output_type
	23, // [23:42] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_init() }
func file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_init() {
	if File_google_cloud_bigquery_reservation_v1beta1_reservation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Reservation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapacityCommitment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReservationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReservationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReservationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReservationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteReservationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateReservationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCapacityCommitmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCapacityCommitmentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCapacityCommitmentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCapacityCommitmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCapacityCommitmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCapacityCommitmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitCapacityCommitmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitCapacityCommitmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeCapacityCommitmentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Assignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssignmentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssignmentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAssignmentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAssignmentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BiReservation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBiReservationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBiReservationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_reservation_v1beta1_reservation_proto = out.File
	file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_rawDesc = nil
	file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_goTypes = nil
	file_google_cloud_bigquery_reservation_v1beta1_reservation_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReservationServiceClient is the client API for ReservationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReservationServiceClient interface {
	// Creates a new reservation resource.
	CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Creates a new capacity commitment resource.
	CreateCapacityCommitment(ctx context.Context, in *CreateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only `plan` and `renewal_plan` fields can be updated.
	//
	// Plan can only be changed to a plan of a longer commitment period.
	// Attempting to change to a plan with shorter commitment period will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// `commitment_end_time`.
	//
	// A common use case is to enable downgrading commitments.
	//
	// For example, in order to downgrade from 10000 slots to 8000, you might
	// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
	// you would change the plan of the first one to `FLEX` and then delete it.
	SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into a single commitment.
	//
	// The resulting capacity commitment has the greater commitment_end_time
	// out of the to-be-merged capacity commitments.
	//
	// Attempting to merge capacity commitments of different plan will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Creates an assignment object which allows the given project to submit jobs
	// of a certain type using slots from the specified reservation.
	//
	// Currently a
	// resource (project, folder, organization) can only have one assignment per
	// each (job_type, location) combination, and that reservation will be used
	// for all jobs of the matching type.
	//
	// Different assignments can be created on different levels of the
	// projects, folders or organization hierarchy.  During query execution,
	// the assignment is looked up at the project, folder and organization levels
	// in that order. The first assignment found is applied to the query.
	//
	// When creating assignments, it does not matter if other assignments exist at
	// higher levels.
	//
	// Example:
	//
	// * The organization `organizationA` contains two projects, `project1`
	//   and `project2`.
	// * Assignments for all three entities (`organizationA`, `project1`, and
	//   `project2`) could all be created and mapped to the same or different
	//   reservations.
	//
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	//
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Lists assignments.
	//
	// Only explicitly created assignments will be returned.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, ListAssignments will just return the above two assignments
	// for reservation `res1`, and no expansion/merge will happen.
	//
	// The wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed.
	//
	// **Note** "-" cannot be used for projects nor locations.
	ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, deletion of the `<organizationA, res1>` assignment won't
	// affect the other assignment `<project1, res1>`. After said deletion,
	// queries from `project1` will still use `res1` while queries from
	// `project2` will switch to use on-demand mode.
	DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//
	// 1. Assignments created on the project will be returned if they exist.
	// 2. Otherwise assignments created on the closest ancestor will be
	//    returned.
	// 3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	// 1. permission on the assignee will be verified in this API.
	// 2. Hierarchy lookup (project->folder->organization) happens in this API.
	// 3. Parent here is `projects/*/locations/*`, instead of
	//    `projects/*/locations/*reservations/*`.
	//
	// **Note** "-" cannot be used for projects
	// nor locations.
	SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error)
	// Moves an assignment under a new reservation.
	//
	// This differs from removing an existing assignment and recreating a new one
	// by providing a transactional change that ensures an assignee always has an
	// associated reservation.
	MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
	// Updates a BI reservation.
	//
	// Only fields specified in the `field_mask` are updated.
	//
	// A singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
}

type reservationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReservationServiceClient(cc grpc.ClientConnInterface) ReservationServiceClient {
	return &reservationServiceClient{cc}
}

func (c *reservationServiceClient) CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error) {
	out := new(ListReservationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListReservations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateCapacityCommitment(ctx context.Context, in *CreateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error) {
	out := new(ListCapacityCommitmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListCapacityCommitments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error) {
	out := new(SplitCapacityCommitmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SplitCapacityCommitment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MergeCapacityCommitments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error) {
	out := new(ListAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error) {
	out := new(SearchAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SearchAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MoveAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetBiReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateBiReservation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReservationServiceServer is the server API for ReservationService service.
type ReservationServiceServer interface {
	// Creates a new reservation resource.
	CreateReservation(context.Context, *CreateReservationRequest) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(context.Context, *ListReservationsRequest) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(context.Context, *GetReservationRequest) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(context.Context, *DeleteReservationRequest) (*emptypb.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(context.Context, *UpdateReservationRequest) (*Reservation, error)
	// Creates a new capacity commitment resource.
	CreateCapacityCommitment(context.Context, *CreateCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(context.Context, *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(context.Context, *GetCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(context.Context, *DeleteCapacityCommitmentRequest) (*emptypb.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only `plan` and `renewal_plan` fields can be updated.
	//
	// Plan can only be changed to a plan of a longer commitment period.
	// Attempting to change to a plan with shorter commitment period will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	UpdateCapacityCommitment(context.Context, *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// `commitment_end_time`.
	//
	// A common use case is to enable downgrading commitments.
	//
	// For example, in order to downgrade from 10000 slots to 8000, you might
	// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
	// you would change the plan of the first one to `FLEX` and then delete it.
	SplitCapacityCommitment(context.Context, *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into a single commitment.
	//
	// The resulting capacity commitment has the greater commitment_end_time
	// out of the to-be-merged capacity commitments.
	//
	// Attempting to merge capacity commitments of different plan will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(context.Context, *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error)
	// Creates an assignment object which allows the given project to submit jobs
	// of a certain type using slots from the specified reservation.
	//
	// Currently a
	// resource (project, folder, organization) can only have one assignment per
	// each (job_type, location) combination, and that reservation will be used
	// for all jobs of the matching type.
	//
	// Different assignments can be created on different levels of the
	// projects, folders or organization hierarchy.  During query execution,
	// the assignment is looked up at the project, folder and organization levels
	// in that order. The first assignment found is applied to the query.
	//
	// When creating assignments, it does not matter if other assignments exist at
	// higher levels.
	//
	// Example:
	//
	// * The organization `organizationA` contains two projects, `project1`
	//   and `project2`.
	// * Assignments for all three entities (`organizationA`, `project1`, and
	//   `project2`) could all be created and mapped to the same or different
	//   reservations.
	//
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	//
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(context.Context, *CreateAssignmentRequest) (*Assignment, error)
	// Lists assignments.
	//
	// Only explicitly created assignments will be returned.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, ListAssignments will just return the above two assignments
	// for reservation `res1`, and no expansion/merge will happen.
	//
	// The wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed.
	//
	// **Note** "-" cannot be used for projects nor locations.
	ListAssignments(context.Context, *ListAssignmentsRequest) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	//
	// Example:
	//
	// * Organization `organizationA` contains two projects, `project1` and
	//   `project2`.
	// * Reservation `res1` exists and was created previously.
	// * CreateAssignment was used previously to define the following
	//   associations between entities and reservations: `<organizationA, res1>`
	//   and `<project1, res1>`
	//
	// In this example, deletion of the `<organizationA, res1>` assignment won't
	// affect the other assignment `<project1, res1>`. After said deletion,
	// queries from `project1` will still use `res1` while queries from
	// `project2` will switch to use on-demand mode.
	DeleteAssignment(context.Context, *DeleteAssignmentRequest) (*emptypb.Empty, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//
	// 1. Assignments created on the project will be returned if they exist.
	// 2. Otherwise assignments created on the closest ancestor will be
	//    returned.
	// 3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	// 1. permission on the assignee will be verified in this API.
	// 2. Hierarchy lookup (project->folder->organization) happens in this API.
	// 3. Parent here is `projects/*/locations/*`, instead of
	//    `projects/*/locations/*reservations/*`.
	//
	// **Note** "-" cannot be used for projects
	// nor locations.
	SearchAssignments(context.Context, *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error)
	// Moves an assignment under a new reservation.
	//
	// This differs from removing an existing assignment and recreating a new one
	// by providing a transactional change that ensures an assignee always has an
	// associated reservation.
	MoveAssignment(context.Context, *MoveAssignmentRequest) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(context.Context, *GetBiReservationRequest) (*BiReservation, error)
	// Updates a BI reservation.
	//
	// Only fields specified in the `field_mask` are updated.
	//
	// A singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(context.Context, *UpdateBiReservationRequest) (*BiReservation, error)
}

// UnimplementedReservationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReservationServiceServer struct {
}

func (*UnimplementedReservationServiceServer) CreateReservation(context.Context, *CreateReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReservation not implemented")
}
func (*UnimplementedReservationServiceServer) ListReservations(context.Context, *ListReservationsRequest) (*ListReservationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReservations not implemented")
}
func (*UnimplementedReservationServiceServer) GetReservation(context.Context, *GetReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReservation not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteReservation(context.Context, *DeleteReservationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteReservation not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateReservation(context.Context, *UpdateReservationRequest) (*Reservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateReservation not implemented")
}
func (*UnimplementedReservationServiceServer) CreateCapacityCommitment(context.Context, *CreateCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) ListCapacityCommitments(context.Context, *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCapacityCommitments not implemented")
}
func (*UnimplementedReservationServiceServer) GetCapacityCommitment(context.Context, *GetCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteCapacityCommitment(context.Context, *DeleteCapacityCommitmentRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateCapacityCommitment(context.Context, *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) SplitCapacityCommitment(context.Context, *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SplitCapacityCommitment not implemented")
}
func (*UnimplementedReservationServiceServer) MergeCapacityCommitments(context.Context, *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MergeCapacityCommitments not implemented")
}
func (*UnimplementedReservationServiceServer) CreateAssignment(context.Context, *CreateAssignmentRequest) (*Assignment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) ListAssignments(context.Context, *ListAssignmentsRequest) (*ListAssignmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssignments not implemented")
}
func (*UnimplementedReservationServiceServer) DeleteAssignment(context.Context, *DeleteAssignmentRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) SearchAssignments(context.Context, *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAssignments not implemented")
}
func (*UnimplementedReservationServiceServer) MoveAssignment(context.Context, *MoveAssignmentRequest) (*Assignment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MoveAssignment not implemented")
}
func (*UnimplementedReservationServiceServer) GetBiReservation(context.Context, *GetBiReservationRequest) (*BiReservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetBiReservation not implemented")
}
func (*UnimplementedReservationServiceServer) UpdateBiReservation(context.Context, *UpdateBiReservationRequest) (*BiReservation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateBiReservation not implemented")
}

func RegisterReservationServiceServer(s *grpc.Server, srv ReservationServiceServer) {
	s.RegisterService(&_ReservationService_serviceDesc, srv)
}

func _ReservationService_CreateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateReservation(ctx, req.(*CreateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListReservations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReservationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListReservations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListReservations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListReservations(ctx, req.(*ListReservationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetReservation(ctx, req.(*GetReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, req.(*DeleteReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, req.(*UpdateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateCapacityCommitment(ctx, req.(*CreateCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListCapacityCommitments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, req.(*ListCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, req.(*GetCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, req.(*DeleteCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, req.(*UpdateCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SplitCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SplitCapacityCommitment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, req.(*SplitCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MergeCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MergeCapacityCommitments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, req.(*MergeCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/CreateAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, req.(*CreateAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/ListAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListAssignments(ctx, req.(*ListAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/DeleteAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, req.(*DeleteAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SearchAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/SearchAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, req.(*SearchAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MoveAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/MoveAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, req.(*MoveAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/GetBiReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, req.(*GetBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.reservation.v1beta1.ReservationService/UpdateBiReservation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, req.(*UpdateBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReservationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.reservation.v1beta1.ReservationService",
	HandlerType: (*ReservationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReservation",
			Handler:    _ReservationService_CreateReservation_Handler,
		},
		{
			MethodName: "ListReservations",
			Handler:    _ReservationService_ListReservations_Handler,
		},
		{
			MethodName: "GetReservation",
			Handler:    _ReservationService_GetReservation_Handler,
		},
		{
			MethodName: "DeleteReservation",
			Handler:    _ReservationService_DeleteReservation_Handler,
		},
		{
			MethodName: "UpdateReservation",
			Handler:    _ReservationService_UpdateReservation_Handler,
		},
		{
			MethodName: "CreateCapacityCommitment",
			Handler:    _ReservationService_CreateCapacityCommitment_Handler,
		},
		{
			MethodName: "ListCapacityCommitments",
			Handler:    _ReservationService_ListCapacityCommitments_Handler,
		},
		{
			MethodName: "GetCapacityCommitment",
			Handler:    _ReservationService_GetCapacityCommitment_Handler,
		},
		{
			MethodName: "DeleteCapacityCommitment",
			Handler:    _ReservationService_DeleteCapacityCommitment_Handler,
		},
		{
			MethodName: "UpdateCapacityCommitment",
			Handler:    _ReservationService_UpdateCapacityCommitment_Handler,
		},
		{
			MethodName: "SplitCapacityCommitment",
			Handler:    _ReservationService_SplitCapacityCommitment_Handler,
		},
		{
			MethodName: "MergeCapacityCommitments",
			Handler:    _ReservationService_MergeCapacityCommitments_Handler,
		},
		{
			MethodName: "CreateAssignment",
			Handler:    _ReservationService_CreateAssignment_Handler,
		},
		{
			MethodName: "ListAssignments",
			Handler:    _ReservationService_ListAssignments_Handler,
		},
		{
			MethodName: "DeleteAssignment",
			Handler:    _ReservationService_DeleteAssignment_Handler,
		},
		{
			MethodName: "SearchAssignments",
			Handler:    _ReservationService_SearchAssignments_Handler,
		},
		{
			MethodName: "MoveAssignment",
			Handler:    _ReservationService_MoveAssignment_Handler,
		},
		{
			MethodName: "GetBiReservation",
			Handler:    _ReservationService_GetBiReservation_Handler,
		},
		{
			MethodName: "UpdateBiReservation",
			Handler:    _ReservationService_UpdateBiReservation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/reservation/v1beta1/reservation.proto",
}
