// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/webrisk/v1/webrisk.proto

package webrisk

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The type of threat. This maps dirrectly to the threat list a threat may
// belong to.
type ThreatType int32

const (
	// Unknown.
	ThreatType_THREAT_TYPE_UNSPECIFIED ThreatType = 0
	// Malware targeting any platform.
	ThreatType_MALWARE ThreatType = 1
	// Social engineering targeting any platform.
	ThreatType_SOCIAL_ENGINEERING ThreatType = 2
	// Unwanted software targeting any platform.
	ThreatType_UNWANTED_SOFTWARE ThreatType = 3
)

// Enum value maps for ThreatType.
var (
	ThreatType_name = map[int32]string{
		0: "THREAT_TYPE_UNSPECIFIED",
		1: "MALWARE",
		2: "SOCIAL_ENGINEERING",
		3: "UNWANTED_SOFTWARE",
	}
	ThreatType_value = map[string]int32{
		"THREAT_TYPE_UNSPECIFIED": 0,
		"MALWARE":                 1,
		"SOCIAL_ENGINEERING":      2,
		"UNWANTED_SOFTWARE":       3,
	}
)

func (x ThreatType) Enum() *ThreatType {
	p := new(ThreatType)
	*p = x
	return p
}

func (x ThreatType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ThreatType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_webrisk_v1_webrisk_proto_enumTypes[0].Descriptor()
}

func (ThreatType) Type() protoreflect.EnumType {
	return &file_google_cloud_webrisk_v1_webrisk_proto_enumTypes[0]
}

func (x ThreatType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ThreatType.Descriptor instead.
func (ThreatType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{0}
}

// The ways in which threat entry sets can be compressed.
type CompressionType int32

const (
	// Unknown.
	CompressionType_COMPRESSION_TYPE_UNSPECIFIED CompressionType = 0
	// Raw, uncompressed data.
	CompressionType_RAW CompressionType = 1
	// Rice-Golomb encoded data.
	CompressionType_RICE CompressionType = 2
)

// Enum value maps for CompressionType.
var (
	CompressionType_name = map[int32]string{
		0: "COMPRESSION_TYPE_UNSPECIFIED",
		1: "RAW",
		2: "RICE",
	}
	CompressionType_value = map[string]int32{
		"COMPRESSION_TYPE_UNSPECIFIED": 0,
		"RAW":                          1,
		"RICE":                         2,
	}
)

func (x CompressionType) Enum() *CompressionType {
	p := new(CompressionType)
	*p = x
	return p
}

func (x CompressionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompressionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_webrisk_v1_webrisk_proto_enumTypes[1].Descriptor()
}

func (CompressionType) Type() protoreflect.EnumType {
	return &file_google_cloud_webrisk_v1_webrisk_proto_enumTypes[1]
}

func (x CompressionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompressionType.Descriptor instead.
func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{1}
}

// The type of response sent to the client.
type ComputeThreatListDiffResponse_ResponseType int32

const (
	// Unknown.
	ComputeThreatListDiffResponse_RESPONSE_TYPE_UNSPECIFIED ComputeThreatListDiffResponse_ResponseType = 0
	// Partial updates are applied to the client's existing local database.
	ComputeThreatListDiffResponse_DIFF ComputeThreatListDiffResponse_ResponseType = 1
	// Full updates resets the client's entire local database. This means
	// that either the client had no state, was seriously out-of-date,
	// or the client is believed to be corrupt.
	ComputeThreatListDiffResponse_RESET ComputeThreatListDiffResponse_ResponseType = 2
)

// Enum value maps for ComputeThreatListDiffResponse_ResponseType.
var (
	ComputeThreatListDiffResponse_ResponseType_name = map[int32]string{
		0: "RESPONSE_TYPE_UNSPECIFIED",
		1: "DIFF",
		2: "RESET",
	}
	ComputeThreatListDiffResponse_ResponseType_value = map[string]int32{
		"RESPONSE_TYPE_UNSPECIFIED": 0,
		"DIFF":                      1,
		"RESET":                     2,
	}
)

func (x ComputeThreatListDiffResponse_ResponseType) Enum() *ComputeThreatListDiffResponse_ResponseType {
	p := new(ComputeThreatListDiffResponse_ResponseType)
	*p = x
	return p
}

func (x ComputeThreatListDiffResponse_ResponseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeThreatListDiffResponse_ResponseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_webrisk_v1_webrisk_proto_enumTypes[2].Descriptor()
}

func (ComputeThreatListDiffResponse_ResponseType) Type() protoreflect.EnumType {
	return &file_google_cloud_webrisk_v1_webrisk_proto_enumTypes[2]
}

func (x ComputeThreatListDiffResponse_ResponseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeThreatListDiffResponse_ResponseType.Descriptor instead.
func (ComputeThreatListDiffResponse_ResponseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{1, 0}
}

// Describes an API diff request.
type ComputeThreatListDiffRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The threat list to update. Only a single ThreatType should be specified.
	ThreatType ThreatType `protobuf:"varint,1,opt,name=threat_type,json=threatType,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_type,omitempty"`
	// The current version token of the client for the requested list (the
	// client version that was received from the last successful diff).
	// If the client does not have a version token (this is the first time calling
	// ComputeThreatListDiff), this may be left empty and a full database
	// snapshot will be returned.
	VersionToken []byte `protobuf:"bytes,2,opt,name=version_token,json=versionToken,proto3" json:"version_token,omitempty"`
	// Required. The constraints associated with this request.
	Constraints *ComputeThreatListDiffRequest_Constraints `protobuf:"bytes,3,opt,name=constraints,proto3" json:"constraints,omitempty"`
}

func (x *ComputeThreatListDiffRequest) Reset() {
	*x = ComputeThreatListDiffRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeThreatListDiffRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeThreatListDiffRequest) ProtoMessage() {}

func (x *ComputeThreatListDiffRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeThreatListDiffRequest.ProtoReflect.Descriptor instead.
func (*ComputeThreatListDiffRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{0}
}

func (x *ComputeThreatListDiffRequest) GetThreatType() ThreatType {
	if x != nil {
		return x.ThreatType
	}
	return ThreatType_THREAT_TYPE_UNSPECIFIED
}

func (x *ComputeThreatListDiffRequest) GetVersionToken() []byte {
	if x != nil {
		return x.VersionToken
	}
	return nil
}

func (x *ComputeThreatListDiffRequest) GetConstraints() *ComputeThreatListDiffRequest_Constraints {
	if x != nil {
		return x.Constraints
	}
	return nil
}

type ComputeThreatListDiffResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of response. This may indicate that an action must be taken by the
	// client when the response is received.
	ResponseType ComputeThreatListDiffResponse_ResponseType `protobuf:"varint,4,opt,name=response_type,json=responseType,proto3,enum=google.cloud.webrisk.v1.ComputeThreatListDiffResponse_ResponseType" json:"response_type,omitempty"`
	// A set of entries to add to a local threat type's list.
	Additions *ThreatEntryAdditions `protobuf:"bytes,5,opt,name=additions,proto3" json:"additions,omitempty"`
	// A set of entries to remove from a local threat type's list.
	// This field may be empty.
	Removals *ThreatEntryRemovals `protobuf:"bytes,6,opt,name=removals,proto3" json:"removals,omitempty"`
	// The new opaque client version token. This should be retained by the client
	// and passed into the next call of ComputeThreatListDiff as 'version_token'.
	// A separate version token should be stored and used for each threatList.
	NewVersionToken []byte `protobuf:"bytes,7,opt,name=new_version_token,json=newVersionToken,proto3" json:"new_version_token,omitempty"`
	// The expected SHA256 hash of the client state; that is, of the sorted list
	// of all hashes present in the database after applying the provided diff.
	// If the client state doesn't match the expected state, the client must
	// discard this diff and retry later.
	Checksum *ComputeThreatListDiffResponse_Checksum `protobuf:"bytes,8,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// The soonest the client should wait before issuing any diff
	// request. Querying sooner is unlikely to produce a meaningful diff.
	// Waiting longer is acceptable considering the use case.
	// If this field is not set clients may update as soon as they want.
	RecommendedNextDiff *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=recommended_next_diff,json=recommendedNextDiff,proto3" json:"recommended_next_diff,omitempty"`
}

func (x *ComputeThreatListDiffResponse) Reset() {
	*x = ComputeThreatListDiffResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeThreatListDiffResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeThreatListDiffResponse) ProtoMessage() {}

func (x *ComputeThreatListDiffResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeThreatListDiffResponse.ProtoReflect.Descriptor instead.
func (*ComputeThreatListDiffResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{1}
}

func (x *ComputeThreatListDiffResponse) GetResponseType() ComputeThreatListDiffResponse_ResponseType {
	if x != nil {
		return x.ResponseType
	}
	return ComputeThreatListDiffResponse_RESPONSE_TYPE_UNSPECIFIED
}

func (x *ComputeThreatListDiffResponse) GetAdditions() *ThreatEntryAdditions {
	if x != nil {
		return x.Additions
	}
	return nil
}

func (x *ComputeThreatListDiffResponse) GetRemovals() *ThreatEntryRemovals {
	if x != nil {
		return x.Removals
	}
	return nil
}

func (x *ComputeThreatListDiffResponse) GetNewVersionToken() []byte {
	if x != nil {
		return x.NewVersionToken
	}
	return nil
}

func (x *ComputeThreatListDiffResponse) GetChecksum() *ComputeThreatListDiffResponse_Checksum {
	if x != nil {
		return x.Checksum
	}
	return nil
}

func (x *ComputeThreatListDiffResponse) GetRecommendedNextDiff() *timestamppb.Timestamp {
	if x != nil {
		return x.RecommendedNextDiff
	}
	return nil
}

// Request to check URI entries against threatLists.
type SearchUrisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI to be checked for matches.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Required. The ThreatLists to search in. Multiple ThreatLists may be specified.
	ThreatTypes []ThreatType `protobuf:"varint,2,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
}

func (x *SearchUrisRequest) Reset() {
	*x = SearchUrisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchUrisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchUrisRequest) ProtoMessage() {}

func (x *SearchUrisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchUrisRequest.ProtoReflect.Descriptor instead.
func (*SearchUrisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{2}
}

func (x *SearchUrisRequest) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *SearchUrisRequest) GetThreatTypes() []ThreatType {
	if x != nil {
		return x.ThreatTypes
	}
	return nil
}

type SearchUrisResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The threat list matches. This may be empty if the URI is on no list.
	Threat *SearchUrisResponse_ThreatUri `protobuf:"bytes,1,opt,name=threat,proto3" json:"threat,omitempty"`
}

func (x *SearchUrisResponse) Reset() {
	*x = SearchUrisResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchUrisResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchUrisResponse) ProtoMessage() {}

func (x *SearchUrisResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchUrisResponse.ProtoReflect.Descriptor instead.
func (*SearchUrisResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{3}
}

func (x *SearchUrisResponse) GetThreat() *SearchUrisResponse_ThreatUri {
	if x != nil {
		return x.Threat
	}
	return nil
}

// Request to return full hashes matched by the provided hash prefixes.
type SearchHashesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A hash prefix, consisting of the most significant 4-32 bytes of a SHA256
	// hash. For JSON requests, this field is base64-encoded.
	HashPrefix []byte `protobuf:"bytes,1,opt,name=hash_prefix,json=hashPrefix,proto3" json:"hash_prefix,omitempty"`
	// Required. The ThreatLists to search in. Multiple ThreatLists may be specified.
	ThreatTypes []ThreatType `protobuf:"varint,2,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
}

func (x *SearchHashesRequest) Reset() {
	*x = SearchHashesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchHashesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchHashesRequest) ProtoMessage() {}

func (x *SearchHashesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchHashesRequest.ProtoReflect.Descriptor instead.
func (*SearchHashesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{4}
}

func (x *SearchHashesRequest) GetHashPrefix() []byte {
	if x != nil {
		return x.HashPrefix
	}
	return nil
}

func (x *SearchHashesRequest) GetThreatTypes() []ThreatType {
	if x != nil {
		return x.ThreatTypes
	}
	return nil
}

type SearchHashesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full hashes that matched the requested prefixes.
	// The hash will be populated in the key.
	Threats []*SearchHashesResponse_ThreatHash `protobuf:"bytes,1,rep,name=threats,proto3" json:"threats,omitempty"`
	// For requested entities that did not match the threat list, how long to
	// cache the response until.
	NegativeExpireTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=negative_expire_time,json=negativeExpireTime,proto3" json:"negative_expire_time,omitempty"`
}

func (x *SearchHashesResponse) Reset() {
	*x = SearchHashesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchHashesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchHashesResponse) ProtoMessage() {}

func (x *SearchHashesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchHashesResponse.ProtoReflect.Descriptor instead.
func (*SearchHashesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{5}
}

func (x *SearchHashesResponse) GetThreats() []*SearchHashesResponse_ThreatHash {
	if x != nil {
		return x.Threats
	}
	return nil
}

func (x *SearchHashesResponse) GetNegativeExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NegativeExpireTime
	}
	return nil
}

// Contains the set of entries to add to a local database.
// May contain a combination of compressed and raw data in a single response.
type ThreatEntryAdditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw SHA256-formatted entries.
	// Repeated to allow returning sets of hashes with different prefix sizes.
	RawHashes []*RawHashes `protobuf:"bytes,1,rep,name=raw_hashes,json=rawHashes,proto3" json:"raw_hashes,omitempty"`
	// The encoded 4-byte prefixes of SHA256-formatted entries, using a
	// Golomb-Rice encoding. The hashes are converted to uint32, sorted in
	// ascending order, then delta encoded and stored as encoded_data.
	RiceHashes *RiceDeltaEncoding `protobuf:"bytes,2,opt,name=rice_hashes,json=riceHashes,proto3" json:"rice_hashes,omitempty"`
}

func (x *ThreatEntryAdditions) Reset() {
	*x = ThreatEntryAdditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThreatEntryAdditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThreatEntryAdditions) ProtoMessage() {}

func (x *ThreatEntryAdditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThreatEntryAdditions.ProtoReflect.Descriptor instead.
func (*ThreatEntryAdditions) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{6}
}

func (x *ThreatEntryAdditions) GetRawHashes() []*RawHashes {
	if x != nil {
		return x.RawHashes
	}
	return nil
}

func (x *ThreatEntryAdditions) GetRiceHashes() *RiceDeltaEncoding {
	if x != nil {
		return x.RiceHashes
	}
	return nil
}

// Contains the set of entries to remove from a local database.
type ThreatEntryRemovals struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw removal indices for a local list.
	RawIndices *RawIndices `protobuf:"bytes,1,opt,name=raw_indices,json=rawIndices,proto3" json:"raw_indices,omitempty"`
	// The encoded local, lexicographically-sorted list indices, using a
	// Golomb-Rice encoding. Used for sending compressed removal indices. The
	// removal indices (uint32) are sorted in ascending order, then delta encoded
	// and stored as encoded_data.
	RiceIndices *RiceDeltaEncoding `protobuf:"bytes,2,opt,name=rice_indices,json=riceIndices,proto3" json:"rice_indices,omitempty"`
}

func (x *ThreatEntryRemovals) Reset() {
	*x = ThreatEntryRemovals{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThreatEntryRemovals) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThreatEntryRemovals) ProtoMessage() {}

func (x *ThreatEntryRemovals) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThreatEntryRemovals.ProtoReflect.Descriptor instead.
func (*ThreatEntryRemovals) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{7}
}

func (x *ThreatEntryRemovals) GetRawIndices() *RawIndices {
	if x != nil {
		return x.RawIndices
	}
	return nil
}

func (x *ThreatEntryRemovals) GetRiceIndices() *RiceDeltaEncoding {
	if x != nil {
		return x.RiceIndices
	}
	return nil
}

// A set of raw indices to remove from a local list.
type RawIndices struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The indices to remove from a lexicographically-sorted local list.
	Indices []int32 `protobuf:"varint,1,rep,packed,name=indices,proto3" json:"indices,omitempty"`
}

func (x *RawIndices) Reset() {
	*x = RawIndices{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RawIndices) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawIndices) ProtoMessage() {}

func (x *RawIndices) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawIndices.ProtoReflect.Descriptor instead.
func (*RawIndices) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{8}
}

func (x *RawIndices) GetIndices() []int32 {
	if x != nil {
		return x.Indices
	}
	return nil
}

// The uncompressed threat entries in hash format.
// Hashes can be anywhere from 4 to 32 bytes in size. A large majority are 4
// bytes, but some hashes are lengthened if they collide with the hash of a
// popular URI.
//
// Used for sending ThreatEntryAdditons to clients that do not support
// compression, or when sending non-4-byte hashes to clients that do support
// compression.
type RawHashes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of bytes for each prefix encoded below.  This field can be
	// anywhere from 4 (shortest prefix) to 32 (full SHA256 hash).
	// In practice this is almost always 4, except in exceptional circumstances.
	PrefixSize int32 `protobuf:"varint,1,opt,name=prefix_size,json=prefixSize,proto3" json:"prefix_size,omitempty"`
	// The hashes, in binary format, concatenated into one long string. Hashes are
	// sorted in lexicographic order. For JSON API users, hashes are
	// base64-encoded.
	RawHashes []byte `protobuf:"bytes,2,opt,name=raw_hashes,json=rawHashes,proto3" json:"raw_hashes,omitempty"`
}

func (x *RawHashes) Reset() {
	*x = RawHashes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RawHashes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawHashes) ProtoMessage() {}

func (x *RawHashes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawHashes.ProtoReflect.Descriptor instead.
func (*RawHashes) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{9}
}

func (x *RawHashes) GetPrefixSize() int32 {
	if x != nil {
		return x.PrefixSize
	}
	return 0
}

func (x *RawHashes) GetRawHashes() []byte {
	if x != nil {
		return x.RawHashes
	}
	return nil
}

// The Rice-Golomb encoded data. Used for sending compressed 4-byte hashes or
// compressed removal indices.
type RiceDeltaEncoding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The offset of the first entry in the encoded data, or, if only a single
	// integer was encoded, that single integer's value. If the field is empty or
	// missing, assume zero.
	FirstValue int64 `protobuf:"varint,1,opt,name=first_value,json=firstValue,proto3" json:"first_value,omitempty"`
	// The Golomb-Rice parameter, which is a number between 2 and 28. This field
	// is missing (that is, zero) if `num_entries` is zero.
	RiceParameter int32 `protobuf:"varint,2,opt,name=rice_parameter,json=riceParameter,proto3" json:"rice_parameter,omitempty"`
	// The number of entries that are delta encoded in the encoded data. If only a
	// single integer was encoded, this will be zero and the single value will be
	// stored in `first_value`.
	EntryCount int32 `protobuf:"varint,3,opt,name=entry_count,json=entryCount,proto3" json:"entry_count,omitempty"`
	// The encoded deltas that are encoded using the Golomb-Rice coder.
	EncodedData []byte `protobuf:"bytes,4,opt,name=encoded_data,json=encodedData,proto3" json:"encoded_data,omitempty"`
}

func (x *RiceDeltaEncoding) Reset() {
	*x = RiceDeltaEncoding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RiceDeltaEncoding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RiceDeltaEncoding) ProtoMessage() {}

func (x *RiceDeltaEncoding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RiceDeltaEncoding.ProtoReflect.Descriptor instead.
func (*RiceDeltaEncoding) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{10}
}

func (x *RiceDeltaEncoding) GetFirstValue() int64 {
	if x != nil {
		return x.FirstValue
	}
	return 0
}

func (x *RiceDeltaEncoding) GetRiceParameter() int32 {
	if x != nil {
		return x.RiceParameter
	}
	return 0
}

func (x *RiceDeltaEncoding) GetEntryCount() int32 {
	if x != nil {
		return x.EntryCount
	}
	return 0
}

func (x *RiceDeltaEncoding) GetEncodedData() []byte {
	if x != nil {
		return x.EncodedData
	}
	return nil
}

// Wraps a URI that might be displaying phishing content.
type Submission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI that is being reported for phishing content to be analyzed.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Submission) Reset() {
	*x = Submission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Submission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Submission) ProtoMessage() {}

func (x *Submission) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Submission.ProtoReflect.Descriptor instead.
func (*Submission) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{11}
}

func (x *Submission) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Request to send a potentially phishy URI to WebRisk.
type CreateSubmissionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project that is making the submission. This string is in
	// the format "projects/{project_number}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The submission that contains the content of the phishing report.
	Submission *Submission `protobuf:"bytes,2,opt,name=submission,proto3" json:"submission,omitempty"`
}

func (x *CreateSubmissionRequest) Reset() {
	*x = CreateSubmissionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSubmissionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSubmissionRequest) ProtoMessage() {}

func (x *CreateSubmissionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSubmissionRequest.ProtoReflect.Descriptor instead.
func (*CreateSubmissionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{12}
}

func (x *CreateSubmissionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSubmissionRequest) GetSubmission() *Submission {
	if x != nil {
		return x.Submission
	}
	return nil
}

// The constraints for this diff.
type ComputeThreatListDiffRequest_Constraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum size in number of entries. The diff will not contain more
	// entries than this value.  This should be a power of 2 between 2**10 and
	// 2**20.  If zero, no diff size limit is set.
	MaxDiffEntries int32 `protobuf:"varint,1,opt,name=max_diff_entries,json=maxDiffEntries,proto3" json:"max_diff_entries,omitempty"`
	// Sets the maximum number of entries that the client is willing to have
	// in the local database. This should be a power of 2 between 2**10 and
	// 2**20. If zero, no database size limit is set.
	MaxDatabaseEntries int32 `protobuf:"varint,2,opt,name=max_database_entries,json=maxDatabaseEntries,proto3" json:"max_database_entries,omitempty"`
	// The compression types supported by the client.
	SupportedCompressions []CompressionType `protobuf:"varint,3,rep,packed,name=supported_compressions,json=supportedCompressions,proto3,enum=google.cloud.webrisk.v1.CompressionType" json:"supported_compressions,omitempty"`
}

func (x *ComputeThreatListDiffRequest_Constraints) Reset() {
	*x = ComputeThreatListDiffRequest_Constraints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeThreatListDiffRequest_Constraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeThreatListDiffRequest_Constraints) ProtoMessage() {}

func (x *ComputeThreatListDiffRequest_Constraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeThreatListDiffRequest_Constraints.ProtoReflect.Descriptor instead.
func (*ComputeThreatListDiffRequest_Constraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ComputeThreatListDiffRequest_Constraints) GetMaxDiffEntries() int32 {
	if x != nil {
		return x.MaxDiffEntries
	}
	return 0
}

func (x *ComputeThreatListDiffRequest_Constraints) GetMaxDatabaseEntries() int32 {
	if x != nil {
		return x.MaxDatabaseEntries
	}
	return 0
}

func (x *ComputeThreatListDiffRequest_Constraints) GetSupportedCompressions() []CompressionType {
	if x != nil {
		return x.SupportedCompressions
	}
	return nil
}

// The expected state of a client's local database.
type ComputeThreatListDiffResponse_Checksum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SHA256 hash of the client state; that is, of the sorted list of all
	// hashes present in the database.
	Sha256 []byte `protobuf:"bytes,1,opt,name=sha256,proto3" json:"sha256,omitempty"`
}

func (x *ComputeThreatListDiffResponse_Checksum) Reset() {
	*x = ComputeThreatListDiffResponse_Checksum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeThreatListDiffResponse_Checksum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeThreatListDiffResponse_Checksum) ProtoMessage() {}

func (x *ComputeThreatListDiffResponse_Checksum) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeThreatListDiffResponse_Checksum.ProtoReflect.Descriptor instead.
func (*ComputeThreatListDiffResponse_Checksum) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ComputeThreatListDiffResponse_Checksum) GetSha256() []byte {
	if x != nil {
		return x.Sha256
	}
	return nil
}

// Contains threat information on a matching uri.
type SearchUrisResponse_ThreatUri struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ThreatList this threat belongs to.
	ThreatTypes []ThreatType `protobuf:"varint,1,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
	// The cache lifetime for the returned match. Clients must not cache this
	// response past this timestamp to avoid false positives.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *SearchUrisResponse_ThreatUri) Reset() {
	*x = SearchUrisResponse_ThreatUri{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchUrisResponse_ThreatUri) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchUrisResponse_ThreatUri) ProtoMessage() {}

func (x *SearchUrisResponse_ThreatUri) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchUrisResponse_ThreatUri.ProtoReflect.Descriptor instead.
func (*SearchUrisResponse_ThreatUri) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{3, 0}
}

func (x *SearchUrisResponse_ThreatUri) GetThreatTypes() []ThreatType {
	if x != nil {
		return x.ThreatTypes
	}
	return nil
}

func (x *SearchUrisResponse_ThreatUri) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// Contains threat information on a matching hash.
type SearchHashesResponse_ThreatHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ThreatList this threat belongs to.
	// This must contain at least one entry.
	ThreatTypes []ThreatType `protobuf:"varint,1,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1.ThreatType" json:"threat_types,omitempty"`
	// A 32 byte SHA256 hash. This field is in binary format. For JSON
	// requests, hashes are base64-encoded.
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	// The cache lifetime for the returned match. Clients must not cache this
	// response past this timestamp to avoid false positives.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *SearchHashesResponse_ThreatHash) Reset() {
	*x = SearchHashesResponse_ThreatHash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchHashesResponse_ThreatHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchHashesResponse_ThreatHash) ProtoMessage() {}

func (x *SearchHashesResponse_ThreatHash) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchHashesResponse_ThreatHash.ProtoReflect.Descriptor instead.
func (*SearchHashesResponse_ThreatHash) Descriptor() ([]byte, []int) {
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP(), []int{5, 0}
}

func (x *SearchHashesResponse_ThreatHash) GetThreatTypes() []ThreatType {
	if x != nil {
		return x.ThreatTypes
	}
	return nil
}

func (x *SearchHashesResponse_ThreatHash) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

func (x *SearchHashesResponse_ThreatHash) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

var File_google_cloud_webrisk_v1_webrisk_proto protoreflect.FileDescriptor

var file_google_cloud_webrisk_v1_webrisk_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x77,
	0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5, 0x03, 0x0a, 0x1c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0b, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73,
	0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x68, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73,
	0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x1a,
	0xca, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12,
	0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x69, 0x66, 0x66, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x44, 0x69,
	0x66, 0x66, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x6d, 0x61, 0x78,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x16, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69,
	0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe1, 0x04, 0x0a,
	0x1d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x68,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69,
	0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x09, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x0a, 0x08, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x61, 0x6c, 0x73, 0x52, 0x08, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x73, 0x12,
	0x2a, 0x0a, 0x11, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x6e, 0x65, 0x77, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x5b, 0x0a, 0x08, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62,
	0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x52, 0x08,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12, 0x4e, 0x0a, 0x15, 0x72, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x64, 0x69, 0x66,
	0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x13, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x4e, 0x65, 0x78, 0x74, 0x44, 0x69, 0x66, 0x66, 0x1a, 0x22, 0x0a, 0x08, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x73, 0x75, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0x42, 0x0a, 0x0c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19,
	0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x44,
	0x49, 0x46, 0x46, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x53, 0x45, 0x54, 0x10, 0x02,
	0x22, 0x77, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x4b, 0x0a, 0x0c,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xf6, 0x01, 0x0a, 0x12, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4d, 0x0a, 0x06, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x55, 0x72, 0x69, 0x52, 0x06, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x1a,
	0x90, 0x01, 0x0a, 0x09, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x55, 0x72, 0x69, 0x12, 0x46, 0x0a,
	0x0c, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x61, 0x73,
	0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x61,
	0x73, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0a, 0x68, 0x61, 0x73, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x4b, 0x0a, 0x0c, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xe0, 0x02, 0x0a, 0x14, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x52, 0x0a, 0x07, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x48, 0x61, 0x73, 0x68, 0x52, 0x07, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x14, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x12, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0xa5, 0x01, 0x0a, 0x0a, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x48, 0x61,
	0x73, 0x68, 0x12, 0x46, 0x0a, 0x0c, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x61,
	0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x12, 0x3b,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x14,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x41, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x0a, 0x72, 0x61, 0x77, 0x5f, 0x68, 0x61, 0x73, 0x68,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x61, 0x77, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x52, 0x09, 0x72, 0x61,
	0x77, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0b, 0x72, 0x69, 0x63, 0x65, 0x5f,
	0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72,
	0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x69, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x74, 0x61,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x72, 0x69, 0x63, 0x65, 0x48, 0x61,
	0x73, 0x68, 0x65, 0x73, 0x22, 0xaa, 0x01, 0x0a, 0x13, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x73, 0x12, 0x44, 0x0a, 0x0b,
	0x72, 0x61, 0x77, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x77, 0x49,
	0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x52, 0x0a, 0x72, 0x61, 0x77, 0x49, 0x6e, 0x64, 0x69, 0x63,
	0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x69, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x72, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65,
	0x73, 0x22, 0x26, 0x0a, 0x0a, 0x52, 0x61, 0x77, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05,
	0x52, 0x07, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x22, 0x4b, 0x0a, 0x09, 0x52, 0x61, 0x77,
	0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x61, 0x77, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72, 0x61, 0x77,
	0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x22, 0x9f, 0x01, 0x0a, 0x11, 0x52, 0x69, 0x63, 0x65, 0x44,
	0x65, 0x6c, 0x74, 0x61, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x1f, 0x0a, 0x0b,
	0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x66, 0x69, 0x72, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x72, 0x69, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x22, 0x23, 0x0a, 0x0a, 0x53, 0x75, 0x62, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xb0, 0x01,
	0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73,
	0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2a, 0x65, 0x0a, 0x0a, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x54, 0x48, 0x52, 0x45, 0x41, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4d,
	0x41, 0x4c, 0x57, 0x41, 0x52, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x43, 0x49,
	0x41, 0x4c, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x15, 0x0a, 0x11, 0x55, 0x4e, 0x57, 0x41, 0x4e, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x4f, 0x46,
	0x54, 0x57, 0x41, 0x52, 0x45, 0x10, 0x03, 0x2a, 0x46, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4f,
	0x4d, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x52, 0x41, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x49, 0x43, 0x45, 0x10, 0x02, 0x32,
	0xa3, 0x06, 0x0a, 0x0e, 0x57, 0x65, 0x62, 0x52, 0x69, 0x73, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xd3, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x66, 0x66, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72,
	0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x69, 0x66, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1d, 0x12, 0x1b, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x4c,
	0x69, 0x73, 0x74, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x44, 0x69, 0x66, 0x66,
	0xda, 0x41, 0x25, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2c, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x0a, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x55, 0x72, 0x69, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x55, 0x72, 0x69, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x11, 0x12, 0x0f, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x72,
	0x69, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0xda, 0x41, 0x10, 0x75, 0x72, 0x69, 0x2c,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0xa1, 0x01, 0x0a,
	0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x12, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62,
	0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x61,
	0x73, 0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69,
	0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x61, 0x73, 0x68,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x13, 0x12, 0x11, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x3a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0xda, 0x41, 0x18, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x2c, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x12, 0xb6, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75,
	0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73,
	0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x4a, 0xca, 0x41, 0x16, 0x77, 0x65,
	0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbf, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0x2e, 0x76, 0x31, 0x42,
	0x0c, 0x57, 0x65, 0x62, 0x52, 0x69, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x77, 0x65, 0x62,
	0x72, 0x69, 0x73, 0x6b, 0x2f, 0x76, 0x31, 0x3b, 0x77, 0x65, 0x62, 0x72, 0x69, 0x73, 0x6b, 0xa2,
	0x02, 0x04, 0x47, 0x43, 0x57, 0x52, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x57, 0x65, 0x62, 0x52, 0x69, 0x73, 0x6b, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x57, 0x65, 0x62, 0x52, 0x69, 0x73, 0x6b, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x57, 0x65, 0x62, 0x52,
	0x69, 0x73, 0x6b, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_webrisk_v1_webrisk_proto_rawDescOnce sync.Once
	file_google_cloud_webrisk_v1_webrisk_proto_rawDescData = file_google_cloud_webrisk_v1_webrisk_proto_rawDesc
)

func file_google_cloud_webrisk_v1_webrisk_proto_rawDescGZIP() []byte {
	file_google_cloud_webrisk_v1_webrisk_proto_rawDescOnce.Do(func() {
		file_google_cloud_webrisk_v1_webrisk_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_webrisk_v1_webrisk_proto_rawDescData)
	})
	return file_google_cloud_webrisk_v1_webrisk_proto_rawDescData
}

var file_google_cloud_webrisk_v1_webrisk_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_webrisk_v1_webrisk_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_webrisk_v1_webrisk_proto_goTypes = []interface{}{
	(ThreatType)(0),      // 0: google.cloud.webrisk.v1.ThreatType
	(CompressionType)(0), // 1: google.cloud.webrisk.v1.CompressionType
	(ComputeThreatListDiffResponse_ResponseType)(0),  // 2: google.cloud.webrisk.v1.ComputeThreatListDiffResponse.ResponseType
	(*ComputeThreatListDiffRequest)(nil),             // 3: google.cloud.webrisk.v1.ComputeThreatListDiffRequest
	(*ComputeThreatListDiffResponse)(nil),            // 4: google.cloud.webrisk.v1.ComputeThreatListDiffResponse
	(*SearchUrisRequest)(nil),                        // 5: google.cloud.webrisk.v1.SearchUrisRequest
	(*SearchUrisResponse)(nil),                       // 6: google.cloud.webrisk.v1.SearchUrisResponse
	(*SearchHashesRequest)(nil),                      // 7: google.cloud.webrisk.v1.SearchHashesRequest
	(*SearchHashesResponse)(nil),                     // 8: google.cloud.webrisk.v1.SearchHashesResponse
	(*ThreatEntryAdditions)(nil),                     // 9: google.cloud.webrisk.v1.ThreatEntryAdditions
	(*ThreatEntryRemovals)(nil),                      // 10: google.cloud.webrisk.v1.ThreatEntryRemovals
	(*RawIndices)(nil),                               // 11: google.cloud.webrisk.v1.RawIndices
	(*RawHashes)(nil),                                // 12: google.cloud.webrisk.v1.RawHashes
	(*RiceDeltaEncoding)(nil),                        // 13: google.cloud.webrisk.v1.RiceDeltaEncoding
	(*Submission)(nil),                               // 14: google.cloud.webrisk.v1.Submission
	(*CreateSubmissionRequest)(nil),                  // 15: google.cloud.webrisk.v1.CreateSubmissionRequest
	(*ComputeThreatListDiffRequest_Constraints)(nil), // 16: google.cloud.webrisk.v1.ComputeThreatListDiffRequest.Constraints
	(*ComputeThreatListDiffResponse_Checksum)(nil),   // 17: google.cloud.webrisk.v1.ComputeThreatListDiffResponse.Checksum
	(*SearchUrisResponse_ThreatUri)(nil),             // 18: google.cloud.webrisk.v1.SearchUrisResponse.ThreatUri
	(*SearchHashesResponse_ThreatHash)(nil),          // 19: google.cloud.webrisk.v1.SearchHashesResponse.ThreatHash
	(*timestamppb.Timestamp)(nil),                    // 20: google.protobuf.Timestamp
}
var file_google_cloud_webrisk_v1_webrisk_proto_depIdxs = []int32{
	0,  // 0: google.cloud.webrisk.v1.ComputeThreatListDiffRequest.threat_type:type_name -> google.cloud.webrisk.v1.ThreatType
	16, // 1: google.cloud.webrisk.v1.ComputeThreatListDiffRequest.constraints:type_name -> google.cloud.webrisk.v1.ComputeThreatListDiffRequest.Constraints
	2,  // 2: google.cloud.webrisk.v1.ComputeThreatListDiffResponse.response_type:type_name -> google.cloud.webrisk.v1.ComputeThreatListDiffResponse.ResponseType
	9,  // 3: google.cloud.webrisk.v1.ComputeThreatListDiffResponse.additions:type_name -> google.cloud.webrisk.v1.ThreatEntryAdditions
	10, // 4: google.cloud.webrisk.v1.ComputeThreatListDiffResponse.removals:type_name -> google.cloud.webrisk.v1.ThreatEntryRemovals
	17, // 5: google.cloud.webrisk.v1.ComputeThreatListDiffResponse.checksum:type_name -> google.cloud.webrisk.v1.ComputeThreatListDiffResponse.Checksum
	20, // 6: google.cloud.webrisk.v1.ComputeThreatListDiffResponse.recommended_next_diff:type_name -> google.protobuf.Timestamp
	0,  // 7: google.cloud.webrisk.v1.SearchUrisRequest.threat_types:type_name -> google.cloud.webrisk.v1.ThreatType
	18, // 8: google.cloud.webrisk.v1.SearchUrisResponse.threat:type_name -> google.cloud.webrisk.v1.SearchUrisResponse.ThreatUri
	0,  // 9: google.cloud.webrisk.v1.SearchHashesRequest.threat_types:type_name -> google.cloud.webrisk.v1.ThreatType
	19, // 10: google.cloud.webrisk.v1.SearchHashesResponse.threats:type_name -> google.cloud.webrisk.v1.SearchHashesResponse.ThreatHash
	20, // 11: google.cloud.webrisk.v1.SearchHashesResponse.negative_expire_time:type_name -> google.protobuf.Timestamp
	12, // 12: google.cloud.webrisk.v1.ThreatEntryAdditions.raw_hashes:type_name -> google.cloud.webrisk.v1.RawHashes
	13, // 13: google.cloud.webrisk.v1.ThreatEntryAdditions.rice_hashes:type_name -> google.cloud.webrisk.v1.RiceDeltaEncoding
	11, // 14: google.cloud.webrisk.v1.ThreatEntryRemovals.raw_indices:type_name -> google.cloud.webrisk.v1.RawIndices
	13, // 15: google.cloud.webrisk.v1.ThreatEntryRemovals.rice_indices:type_name -> google.cloud.webrisk.v1.RiceDeltaEncoding
	14, // 16: google.cloud.webrisk.v1.CreateSubmissionRequest.submission:type_name -> google.cloud.webrisk.v1.Submission
	1,  // 17: google.cloud.webrisk.v1.ComputeThreatListDiffRequest.Constraints.supported_compressions:type_name -> google.cloud.webrisk.v1.CompressionType
	0,  // 18: google.cloud.webrisk.v1.SearchUrisResponse.ThreatUri.threat_types:type_name -> google.cloud.webrisk.v1.ThreatType
	20, // 19: google.cloud.webrisk.v1.SearchUrisResponse.ThreatUri.expire_time:type_name -> google.protobuf.Timestamp
	0,  // 20: google.cloud.webrisk.v1.SearchHashesResponse.ThreatHash.threat_types:type_name -> google.cloud.webrisk.v1.ThreatType
	20, // 21: google.cloud.webrisk.v1.SearchHashesResponse.ThreatHash.expire_time:type_name -> google.protobuf.Timestamp
	3,  // 22: google.cloud.webrisk.v1.WebRiskService.ComputeThreatListDiff:input_type -> google.cloud.webrisk.v1.ComputeThreatListDiffRequest
	5,  // 23: google.cloud.webrisk.v1.WebRiskService.SearchUris:input_type -> google.cloud.webrisk.v1.SearchUrisRequest
	7,  // 24: google.cloud.webrisk.v1.WebRiskService.SearchHashes:input_type -> google.cloud.webrisk.v1.SearchHashesRequest
	15, // 25: google.cloud.webrisk.v1.WebRiskService.CreateSubmission:input_type -> google.cloud.webrisk.v1.CreateSubmissionRequest
	4,  // 26: google.cloud.webrisk.v1.WebRiskService.ComputeThreatListDiff:output_type -> google.cloud.webrisk.v1.ComputeThreatListDiffResponse
	6,  // 27: google.cloud.webrisk.v1.WebRiskService.SearchUris:output_type -> google.cloud.webrisk.v1.SearchUrisResponse
	8,  // 28: google.cloud.webrisk.v1.WebRiskService.SearchHashes:output_type -> google.cloud.webrisk.v1.SearchHashesResponse
	14, // 29: google.cloud.webrisk.v1.WebRiskService.CreateSubmission:output_type -> google.cloud.webrisk.v1.Submission
	26, // [26:30] is the sub-list for method output_type
	22, // [22:26] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_cloud_webrisk_v1_webrisk_proto_init() }
func file_google_cloud_webrisk_v1_webrisk_proto_init() {
	if File_google_cloud_webrisk_v1_webrisk_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeThreatListDiffRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeThreatListDiffResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchUrisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchUrisResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchHashesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchHashesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ThreatEntryAdditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ThreatEntryRemovals); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RawIndices); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RawHashes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RiceDeltaEncoding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Submission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSubmissionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeThreatListDiffRequest_Constraints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeThreatListDiffResponse_Checksum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchUrisResponse_ThreatUri); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_webrisk_v1_webrisk_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchHashesResponse_ThreatHash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_webrisk_v1_webrisk_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_webrisk_v1_webrisk_proto_goTypes,
		DependencyIndexes: file_google_cloud_webrisk_v1_webrisk_proto_depIdxs,
		EnumInfos:         file_google_cloud_webrisk_v1_webrisk_proto_enumTypes,
		MessageInfos:      file_google_cloud_webrisk_v1_webrisk_proto_msgTypes,
	}.Build()
	File_google_cloud_webrisk_v1_webrisk_proto = out.File
	file_google_cloud_webrisk_v1_webrisk_proto_rawDesc = nil
	file_google_cloud_webrisk_v1_webrisk_proto_goTypes = nil
	file_google_cloud_webrisk_v1_webrisk_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// WebRiskServiceClient is the client API for WebRiskService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WebRiskServiceClient interface {
	// Gets the most recent threat list diffs. These diffs should be applied to
	// a local database of hashes to keep it up-to-date. If the local database is
	// empty or excessively out-of-date, a complete snapshot of the database will
	// be returned. This Method only updates a single ThreatList at a time. To
	// update multiple ThreatList databases, this method needs to be called once
	// for each list.
	ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	// Multiple threatLists may be searched in a single query.
	// The response will list all requested threatLists the URI was found to
	// match. If the URI is not found on any of the requested ThreatList an
	// empty response will be returned.
	SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error)
	// Creates a Submission of a URI suspected of containing phishing content to
	// be reviewed. If the result verifies the existence of malicious phishing
	// content, the site will be added to the [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// projects with CREATE_SUBMISSION_USERS visibility can use this method.
	CreateSubmission(ctx context.Context, in *CreateSubmissionRequest, opts ...grpc.CallOption) (*Submission, error)
}

type webRiskServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewWebRiskServiceClient(cc grpc.ClientConnInterface) WebRiskServiceClient {
	return &webRiskServiceClient{cc}
}

func (c *webRiskServiceClient) ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error) {
	out := new(ComputeThreatListDiffResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/ComputeThreatListDiff", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error) {
	out := new(SearchUrisResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/SearchUris", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error) {
	out := new(SearchHashesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/SearchHashes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceClient) CreateSubmission(ctx context.Context, in *CreateSubmissionRequest, opts ...grpc.CallOption) (*Submission, error) {
	out := new(Submission)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1.WebRiskService/CreateSubmission", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebRiskServiceServer is the server API for WebRiskService service.
type WebRiskServiceServer interface {
	// Gets the most recent threat list diffs. These diffs should be applied to
	// a local database of hashes to keep it up-to-date. If the local database is
	// empty or excessively out-of-date, a complete snapshot of the database will
	// be returned. This Method only updates a single ThreatList at a time. To
	// update multiple ThreatList databases, this method needs to be called once
	// for each list.
	ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	// Multiple threatLists may be searched in a single query.
	// The response will list all requested threatLists the URI was found to
	// match. If the URI is not found on any of the requested ThreatList an
	// empty response will be returned.
	SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error)
	// Creates a Submission of a URI suspected of containing phishing content to
	// be reviewed. If the result verifies the existence of malicious phishing
	// content, the site will be added to the [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future. Only
	// projects with CREATE_SUBMISSION_USERS visibility can use this method.
	CreateSubmission(context.Context, *CreateSubmissionRequest) (*Submission, error)
}

// UnimplementedWebRiskServiceServer can be embedded to have forward compatible implementations.
type UnimplementedWebRiskServiceServer struct {
}

func (*UnimplementedWebRiskServiceServer) ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeThreatListDiff not implemented")
}
func (*UnimplementedWebRiskServiceServer) SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchUris not implemented")
}
func (*UnimplementedWebRiskServiceServer) SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchHashes not implemented")
}
func (*UnimplementedWebRiskServiceServer) CreateSubmission(context.Context, *CreateSubmissionRequest) (*Submission, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubmission not implemented")
}

func RegisterWebRiskServiceServer(s *grpc.Server, srv WebRiskServiceServer) {
	s.RegisterService(&_WebRiskService_serviceDesc, srv)
}

func _WebRiskService_ComputeThreatListDiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeThreatListDiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).ComputeThreatListDiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/ComputeThreatListDiff",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).ComputeThreatListDiff(ctx, req.(*ComputeThreatListDiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_SearchUris_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchUrisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).SearchUris(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/SearchUris",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).SearchUris(ctx, req.(*SearchUrisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_SearchHashes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchHashesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).SearchHashes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/SearchHashes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).SearchHashes(ctx, req.(*SearchHashesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskService_CreateSubmission_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubmissionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceServer).CreateSubmission(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1.WebRiskService/CreateSubmission",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceServer).CreateSubmission(ctx, req.(*CreateSubmissionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WebRiskService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.webrisk.v1.WebRiskService",
	HandlerType: (*WebRiskServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeThreatListDiff",
			Handler:    _WebRiskService_ComputeThreatListDiff_Handler,
		},
		{
			MethodName: "SearchUris",
			Handler:    _WebRiskService_SearchUris_Handler,
		},
		{
			MethodName: "SearchHashes",
			Handler:    _WebRiskService_SearchHashes_Handler,
		},
		{
			MethodName: "CreateSubmission",
			Handler:    _WebRiskService_CreateSubmission_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/webrisk/v1/webrisk.proto",
}
