package eventgridapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/eventgrid/2018-01-01/eventgrid"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	PublishCloudEventEvents(ctx context.Context, topicHostname string, events []eventgrid.CloudEventEvent) (result autorest.Response, err error)
	PublishCustomEventEvents(ctx context.Context, topicHostname string, events []interface{}) (result autorest.Response, err error)
	PublishEvents(ctx context.Context, topicHostname string, events []eventgrid.Event) (result autorest.Response, err error)
}

var _ BaseClientAPI = (*eventgrid.BaseClient)(nil)
