package logic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RosettaNetProcessConfigurationsClient is the REST API for Azure Logic Apps.
type RosettaNetProcessConfigurationsClient struct {
	BaseClient
}

// NewRosettaNetProcessConfigurationsClient creates an instance of the RosettaNetProcessConfigurationsClient client.
func NewRosettaNetProcessConfigurationsClient(subscriptionID string) RosettaNetProcessConfigurationsClient {
	return NewRosettaNetProcessConfigurationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRosettaNetProcessConfigurationsClientWithBaseURI creates an instance of the RosettaNetProcessConfigurationsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewRosettaNetProcessConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) RosettaNetProcessConfigurationsClient {
	return RosettaNetProcessConfigurationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates an integration account RosettaNetProcessConfiguration.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// rosettaNetProcessConfigurationName - the integration account RosettaNet ProcessConfiguration name.
// rosettaNetProcessConfiguration - the integration account RosettaNet ProcessConfiguration.
func (client RosettaNetProcessConfigurationsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, rosettaNetProcessConfigurationName string, rosettaNetProcessConfiguration IntegrationAccountRosettaNetProcessConfiguration) (result IntegrationAccountRosettaNetProcessConfiguration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RosettaNetProcessConfigurationsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: rosettaNetProcessConfiguration,
			Constraints: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.ActivityBehavior", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.ActivityBehavior.IsAuthorizationRequired", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.ActivityBehavior.IsSecuredTransportRequired", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.ActivityBehavior.NonRepudiationOfOriginAndContent", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.ActivityBehavior.RetryCount", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.ActivityBehavior.TimeToPerformInSeconds", Name: validation.Null, Rule: true, Chain: nil},
						}},
						{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.AcknowledgmentOfReceiptSettings", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.AcknowledgmentOfReceiptSettings.IsNonRepudiationRequired", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ActivitySettings.AcknowledgmentOfReceiptSettings.TimeToAcknowledgeInSeconds", Name: validation.Null, Rule: true, Chain: nil},
							}},
					}},
					{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ProcessCode", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ProcessVersion", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ProcessName", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings.Action", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings.Role", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings.Service", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings.ServiceClassification", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings.BusinessDocument", Name: validation.Null, Rule: true,
								Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings.BusinessDocument.Name", Name: validation.Null, Rule: true, Chain: nil},
									{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.InitiatorRoleSettings.BusinessDocument.Version", Name: validation.Null, Rule: true, Chain: nil},
								}},
						}},
					{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings.Action", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings.Role", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings.Service", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings.ServiceClassification", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings.BusinessDocument", Name: validation.Null, Rule: true,
								Chain: []validation.Constraint{{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings.BusinessDocument.Name", Name: validation.Null, Rule: true, Chain: nil},
									{Target: "rosettaNetProcessConfiguration.IntegrationAccountRosettaNetProcessConfigurationProperties.ResponderRoleSettings.BusinessDocument.Version", Name: validation.Null, Rule: true, Chain: nil},
								}},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("logic.RosettaNetProcessConfigurationsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, integrationAccountName, rosettaNetProcessConfigurationName, rosettaNetProcessConfiguration)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client RosettaNetProcessConfigurationsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, rosettaNetProcessConfigurationName string, rosettaNetProcessConfiguration IntegrationAccountRosettaNetProcessConfiguration) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationAccountName":             autorest.Encode("path", integrationAccountName),
		"resourceGroupName":                  autorest.Encode("path", resourceGroupName),
		"rosettaNetProcessConfigurationName": autorest.Encode("path", rosettaNetProcessConfigurationName),
		"subscriptionId":                     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/rosettanetprocessconfigurations/{rosettaNetProcessConfigurationName}", pathParameters),
		autorest.WithJSON(rosettaNetProcessConfiguration),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client RosettaNetProcessConfigurationsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client RosettaNetProcessConfigurationsClient) CreateOrUpdateResponder(resp *http.Response) (result IntegrationAccountRosettaNetProcessConfiguration, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an integration account RosettaNet ProcessConfiguration.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// rosettaNetProcessConfigurationName - the integration account RosettaNetProcessConfiguration name.
func (client RosettaNetProcessConfigurationsClient) Delete(ctx context.Context, resourceGroupName string, integrationAccountName string, rosettaNetProcessConfigurationName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RosettaNetProcessConfigurationsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, integrationAccountName, rosettaNetProcessConfigurationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client RosettaNetProcessConfigurationsClient) DeletePreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, rosettaNetProcessConfigurationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationAccountName":             autorest.Encode("path", integrationAccountName),
		"resourceGroupName":                  autorest.Encode("path", resourceGroupName),
		"rosettaNetProcessConfigurationName": autorest.Encode("path", rosettaNetProcessConfigurationName),
		"subscriptionId":                     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/rosettanetprocessconfigurations/{rosettaNetProcessConfigurationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client RosettaNetProcessConfigurationsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client RosettaNetProcessConfigurationsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets an integration account RosettaNetProcessConfiguration.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// rosettaNetProcessConfigurationName - the integration account RosettaNetProcessConfiguration name.
func (client RosettaNetProcessConfigurationsClient) Get(ctx context.Context, resourceGroupName string, integrationAccountName string, rosettaNetProcessConfigurationName string) (result IntegrationAccountRosettaNetProcessConfiguration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RosettaNetProcessConfigurationsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, integrationAccountName, rosettaNetProcessConfigurationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RosettaNetProcessConfigurationsClient) GetPreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, rosettaNetProcessConfigurationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationAccountName":             autorest.Encode("path", integrationAccountName),
		"resourceGroupName":                  autorest.Encode("path", resourceGroupName),
		"rosettaNetProcessConfigurationName": autorest.Encode("path", rosettaNetProcessConfigurationName),
		"subscriptionId":                     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/rosettanetprocessconfigurations/{rosettaNetProcessConfigurationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RosettaNetProcessConfigurationsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RosettaNetProcessConfigurationsClient) GetResponder(resp *http.Response) (result IntegrationAccountRosettaNetProcessConfiguration, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByIntegrationAccounts gets a list of integration account RosettaNet process configurations.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// top - the number of items to be included in the result.
// filter - the filter to apply on the operation.
func (client RosettaNetProcessConfigurationsClient) ListByIntegrationAccounts(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result IntegrationAccountRosettaNetProcessConfigurationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RosettaNetProcessConfigurationsClient.ListByIntegrationAccounts")
		defer func() {
			sc := -1
			if result.iarnpclr.Response.Response != nil {
				sc = result.iarnpclr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByIntegrationAccountsNextResults
	req, err := client.ListByIntegrationAccountsPreparer(ctx, resourceGroupName, integrationAccountName, top, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "ListByIntegrationAccounts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByIntegrationAccountsSender(req)
	if err != nil {
		result.iarnpclr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "ListByIntegrationAccounts", resp, "Failure sending request")
		return
	}

	result.iarnpclr, err = client.ListByIntegrationAccountsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "ListByIntegrationAccounts", resp, "Failure responding to request")
		return
	}
	if result.iarnpclr.hasNextLink() && result.iarnpclr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByIntegrationAccountsPreparer prepares the ListByIntegrationAccounts request.
func (client RosettaNetProcessConfigurationsClient) ListByIntegrationAccountsPreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationAccountName": autorest.Encode("path", integrationAccountName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/rosettanetprocessconfigurations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByIntegrationAccountsSender sends the ListByIntegrationAccounts request. The method will close the
// http.Response Body if it receives an error.
func (client RosettaNetProcessConfigurationsClient) ListByIntegrationAccountsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByIntegrationAccountsResponder handles the response to the ListByIntegrationAccounts request. The method always
// closes the http.Response Body.
func (client RosettaNetProcessConfigurationsClient) ListByIntegrationAccountsResponder(resp *http.Response) (result IntegrationAccountRosettaNetProcessConfigurationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByIntegrationAccountsNextResults retrieves the next set of results, if any.
func (client RosettaNetProcessConfigurationsClient) listByIntegrationAccountsNextResults(ctx context.Context, lastResults IntegrationAccountRosettaNetProcessConfigurationListResult) (result IntegrationAccountRosettaNetProcessConfigurationListResult, err error) {
	req, err := lastResults.integrationAccountRosettaNetProcessConfigurationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "listByIntegrationAccountsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByIntegrationAccountsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "listByIntegrationAccountsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByIntegrationAccountsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.RosettaNetProcessConfigurationsClient", "listByIntegrationAccountsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByIntegrationAccountsComplete enumerates all values, automatically crossing page boundaries as required.
func (client RosettaNetProcessConfigurationsClient) ListByIntegrationAccountsComplete(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result IntegrationAccountRosettaNetProcessConfigurationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RosettaNetProcessConfigurationsClient.ListByIntegrationAccounts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByIntegrationAccounts(ctx, resourceGroupName, integrationAccountName, top, filter)
	return
}
