package inkrecognizer

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// Client is the the service is used to perform ink layout and recognition of written words and shapes. Ink strokes
// passed to the service are recognized and organized into recognition results in the response
type Client struct {
	BaseClient
}

// NewClient creates an instance of the Client client.
func NewClient(endpoint string) Client {
	return Client{New(endpoint)}
}

// Recognize ink Recognition operation is used to perform ink layout and recognition of written words and shapes. It
// allows passing the ink strokes to the service to get the recognition results in the response.
// Parameters:
// body - the collection of stroke objects to send for analysis
// xMsClientRequestID - the request id used to uniquely identify each request during troubleshooting. This is
// an optional parameter useful for correlating logs and other artifacts.
func (client Client) Recognize(ctx context.Context, body AnalysisRequest, xMsClientRequestID string) (result AnalysisResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Recognize")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.Language", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "body.Strokes", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("inkrecognizer.Client", "Recognize", err.Error())
	}

	req, err := client.RecognizePreparer(ctx, body, xMsClientRequestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "inkrecognizer.Client", "Recognize", nil, "Failure preparing request")
		return
	}

	resp, err := client.RecognizeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "inkrecognizer.Client", "Recognize", resp, "Failure sending request")
		return
	}

	result, err = client.RecognizeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "inkrecognizer.Client", "Recognize", resp, "Failure responding to request")
		return
	}

	return
}

// RecognizePreparer prepares the Recognize request.
func (client Client) RecognizePreparer(ctx context.Context, body AnalysisRequest, xMsClientRequestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("https://{Endpoint}/inkrecognizer/v1.0-preview", urlParameters),
		autorest.WithPath("/recognize"),
		autorest.WithJSON(body))
	if len(xMsClientRequestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(xMsClientRequestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RecognizeSender sends the Recognize request. The method will close the
// http.Response Body if it receives an error.
func (client Client) RecognizeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// RecognizeResponder handles the response to the Recognize request. The method always
// closes the http.Response Body.
func (client Client) RecognizeResponder(resp *http.Response) (result AnalysisResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
