package commerce

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AggregationGranularity enumerates the values for aggregation granularity.
type AggregationGranularity string

const (
	// Daily ...
	Daily AggregationGranularity = "Daily"
	// Hourly ...
	Hourly AggregationGranularity = "Hourly"
)

// PossibleAggregationGranularityValues returns an array of possible values for the AggregationGranularity const type.
func PossibleAggregationGranularityValues() []AggregationGranularity {
	return []AggregationGranularity{Daily, Hourly}
}

// Name enumerates the values for name.
type Name string

const (
	// NameMonetaryCommitment ...
	NameMonetaryCommitment Name = "Monetary Commitment"
	// NameMonetaryCredit ...
	NameMonetaryCredit Name = "Monetary Credit"
	// NameOfferTermInfo ...
	NameOfferTermInfo Name = "OfferTermInfo"
	// NameRecurringCharge ...
	NameRecurringCharge Name = "Recurring Charge"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameMonetaryCommitment, NameMonetaryCredit, NameOfferTermInfo, NameRecurringCharge}
}
