package logic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// KeyType enumerates the values for key type.
type KeyType string

const (
	// NotSpecified ...
	NotSpecified KeyType = "NotSpecified"
	// Primary ...
	Primary KeyType = "Primary"
	// Secondary ...
	Secondary KeyType = "Secondary"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{NotSpecified, Primary, Secondary}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool ...
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeNotSpecified ...
	ParameterTypeNotSpecified ParameterType = "NotSpecified"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureObject ...
	ParameterTypeSecureObject ParameterType = "SecureObject"
	// ParameterTypeSecureString ...
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBool, ParameterTypeFloat, ParameterTypeInt, ParameterTypeNotSpecified, ParameterTypeObject, ParameterTypeSecureObject, ParameterTypeSecureString, ParameterTypeString}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day ...
	Day RecurrenceFrequency = "Day"
	// Hour ...
	Hour RecurrenceFrequency = "Hour"
	// Minute ...
	Minute RecurrenceFrequency = "Minute"
	// Month ...
	Month RecurrenceFrequency = "Month"
	// Second ...
	Second RecurrenceFrequency = "Second"
	// Week ...
	Week RecurrenceFrequency = "Week"
	// Year ...
	Year RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{Day, Hour, Minute, Month, Second, Week, Year}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameFree ...
	SkuNameFree SkuName = "Free"
	// SkuNameNotSpecified ...
	SkuNameNotSpecified SkuName = "NotSpecified"
	// SkuNamePremium ...
	SkuNamePremium SkuName = "Premium"
	// SkuNameShared ...
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameFree, SkuNameNotSpecified, SkuNamePremium, SkuNameShared, SkuNameStandard}
}

// WorkflowProvisioningState enumerates the values for workflow provisioning state.
type WorkflowProvisioningState string

const (
	// WorkflowProvisioningStateMoving ...
	WorkflowProvisioningStateMoving WorkflowProvisioningState = "Moving"
	// WorkflowProvisioningStateNotSpecified ...
	WorkflowProvisioningStateNotSpecified WorkflowProvisioningState = "NotSpecified"
	// WorkflowProvisioningStateSucceeded ...
	WorkflowProvisioningStateSucceeded WorkflowProvisioningState = "Succeeded"
)

// PossibleWorkflowProvisioningStateValues returns an array of possible values for the WorkflowProvisioningState const type.
func PossibleWorkflowProvisioningStateValues() []WorkflowProvisioningState {
	return []WorkflowProvisioningState{WorkflowProvisioningStateMoving, WorkflowProvisioningStateNotSpecified, WorkflowProvisioningStateSucceeded}
}

// WorkflowState enumerates the values for workflow state.
type WorkflowState string

const (
	// WorkflowStateDeleted ...
	WorkflowStateDeleted WorkflowState = "Deleted"
	// WorkflowStateDisabled ...
	WorkflowStateDisabled WorkflowState = "Disabled"
	// WorkflowStateEnabled ...
	WorkflowStateEnabled WorkflowState = "Enabled"
	// WorkflowStateNotSpecified ...
	WorkflowStateNotSpecified WorkflowState = "NotSpecified"
	// WorkflowStateSuspended ...
	WorkflowStateSuspended WorkflowState = "Suspended"
)

// PossibleWorkflowStateValues returns an array of possible values for the WorkflowState const type.
func PossibleWorkflowStateValues() []WorkflowState {
	return []WorkflowState{WorkflowStateDeleted, WorkflowStateDisabled, WorkflowStateEnabled, WorkflowStateNotSpecified, WorkflowStateSuspended}
}

// WorkflowStatus enumerates the values for workflow status.
type WorkflowStatus string

const (
	// WorkflowStatusAborted ...
	WorkflowStatusAborted WorkflowStatus = "Aborted"
	// WorkflowStatusCancelled ...
	WorkflowStatusCancelled WorkflowStatus = "Cancelled"
	// WorkflowStatusFailed ...
	WorkflowStatusFailed WorkflowStatus = "Failed"
	// WorkflowStatusFaulted ...
	WorkflowStatusFaulted WorkflowStatus = "Faulted"
	// WorkflowStatusNotSpecified ...
	WorkflowStatusNotSpecified WorkflowStatus = "NotSpecified"
	// WorkflowStatusPaused ...
	WorkflowStatusPaused WorkflowStatus = "Paused"
	// WorkflowStatusRunning ...
	WorkflowStatusRunning WorkflowStatus = "Running"
	// WorkflowStatusSkipped ...
	WorkflowStatusSkipped WorkflowStatus = "Skipped"
	// WorkflowStatusSucceeded ...
	WorkflowStatusSucceeded WorkflowStatus = "Succeeded"
	// WorkflowStatusSuspended ...
	WorkflowStatusSuspended WorkflowStatus = "Suspended"
	// WorkflowStatusTimedOut ...
	WorkflowStatusTimedOut WorkflowStatus = "TimedOut"
	// WorkflowStatusWaiting ...
	WorkflowStatusWaiting WorkflowStatus = "Waiting"
)

// PossibleWorkflowStatusValues returns an array of possible values for the WorkflowStatus const type.
func PossibleWorkflowStatusValues() []WorkflowStatus {
	return []WorkflowStatus{WorkflowStatusAborted, WorkflowStatusCancelled, WorkflowStatusFailed, WorkflowStatusFaulted, WorkflowStatusNotSpecified, WorkflowStatusPaused, WorkflowStatusRunning, WorkflowStatusSkipped, WorkflowStatusSucceeded, WorkflowStatusSuspended, WorkflowStatusTimedOut, WorkflowStatusWaiting}
}

// WorkflowTriggerProvisioningState enumerates the values for workflow trigger provisioning state.
type WorkflowTriggerProvisioningState string

const (
	// WorkflowTriggerProvisioningStateCreating ...
	WorkflowTriggerProvisioningStateCreating WorkflowTriggerProvisioningState = "Creating"
	// WorkflowTriggerProvisioningStateNotSpecified ...
	WorkflowTriggerProvisioningStateNotSpecified WorkflowTriggerProvisioningState = "NotSpecified"
	// WorkflowTriggerProvisioningStateSucceeded ...
	WorkflowTriggerProvisioningStateSucceeded WorkflowTriggerProvisioningState = "Succeeded"
	// WorkflowTriggerProvisioningStateUpdating ...
	WorkflowTriggerProvisioningStateUpdating WorkflowTriggerProvisioningState = "Updating"
)

// PossibleWorkflowTriggerProvisioningStateValues returns an array of possible values for the WorkflowTriggerProvisioningState const type.
func PossibleWorkflowTriggerProvisioningStateValues() []WorkflowTriggerProvisioningState {
	return []WorkflowTriggerProvisioningState{WorkflowTriggerProvisioningStateCreating, WorkflowTriggerProvisioningStateNotSpecified, WorkflowTriggerProvisioningStateSucceeded, WorkflowTriggerProvisioningStateUpdating}
}
