package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AadConnectivityState enumerates the values for aad connectivity state.
type AadConnectivityState string

const (
	// Connected ...
	Connected AadConnectivityState = "Connected"
	// Discovered ...
	Discovered AadConnectivityState = "Discovered"
	// NotLicensed ...
	NotLicensed AadConnectivityState = "NotLicensed"
)

// PossibleAadConnectivityStateValues returns an array of possible values for the AadConnectivityState const type.
func PossibleAadConnectivityStateValues() []AadConnectivityState {
	return []AadConnectivityState{Connected, Discovered, NotLicensed}
}

// Action enumerates the values for action.
type Action string

const (
	// Add ...
	Add Action = "Add"
	// Recommended ...
	Recommended Action = "Recommended"
	// Remove ...
	Remove Action = "Remove"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Add, Recommended, Remove}
}

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeAutomationAction ...
	ActionTypeAutomationAction ActionType = "AutomationAction"
	// ActionTypeEventHub ...
	ActionTypeEventHub ActionType = "EventHub"
	// ActionTypeLogicApp ...
	ActionTypeLogicApp ActionType = "LogicApp"
	// ActionTypeWorkspace ...
	ActionTypeWorkspace ActionType = "Workspace"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeAutomationAction, ActionTypeEventHub, ActionTypeLogicApp, ActionTypeWorkspace}
}

// AlertNotifications enumerates the values for alert notifications.
type AlertNotifications string

const (
	// Off Don't get notifications on new alerts
	Off AlertNotifications = "Off"
	// On Get notifications on new alerts
	On AlertNotifications = "On"
)

// PossibleAlertNotificationsValues returns an array of possible values for the AlertNotifications const type.
func PossibleAlertNotificationsValues() []AlertNotifications {
	return []AlertNotifications{Off, On}
}

// AlertsToAdmins enumerates the values for alerts to admins.
type AlertsToAdmins string

const (
	// AlertsToAdminsOff Don't send notification on new alerts to the subscription's admins
	AlertsToAdminsOff AlertsToAdmins = "Off"
	// AlertsToAdminsOn Send notification on new alerts to the subscription's admins
	AlertsToAdminsOn AlertsToAdmins = "On"
)

// PossibleAlertsToAdminsValues returns an array of possible values for the AlertsToAdmins const type.
func PossibleAlertsToAdminsValues() []AlertsToAdmins {
	return []AlertsToAdmins{AlertsToAdminsOff, AlertsToAdminsOn}
}

// AssessedResourceType enumerates the values for assessed resource type.
type AssessedResourceType string

const (
	// AssessedResourceTypeAdditionalData ...
	AssessedResourceTypeAdditionalData AssessedResourceType = "AdditionalData"
	// AssessedResourceTypeContainerRegistryVulnerability ...
	AssessedResourceTypeContainerRegistryVulnerability AssessedResourceType = "ContainerRegistryVulnerability"
	// AssessedResourceTypeServerVulnerabilityAssessment ...
	AssessedResourceTypeServerVulnerabilityAssessment AssessedResourceType = "ServerVulnerabilityAssessment"
	// AssessedResourceTypeSQLServerVulnerability ...
	AssessedResourceTypeSQLServerVulnerability AssessedResourceType = "SqlServerVulnerability"
)

// PossibleAssessedResourceTypeValues returns an array of possible values for the AssessedResourceType const type.
func PossibleAssessedResourceTypeValues() []AssessedResourceType {
	return []AssessedResourceType{AssessedResourceTypeAdditionalData, AssessedResourceTypeContainerRegistryVulnerability, AssessedResourceTypeServerVulnerabilityAssessment, AssessedResourceTypeSQLServerVulnerability}
}

// AuthenticationProvisioningState enumerates the values for authentication provisioning state.
type AuthenticationProvisioningState string

const (
	// Expired the connection has expired
	Expired AuthenticationProvisioningState = "Expired"
	// IncorrectPolicy Incorrect policy of the connector
	IncorrectPolicy AuthenticationProvisioningState = "IncorrectPolicy"
	// Invalid Invalid connector
	Invalid AuthenticationProvisioningState = "Invalid"
	// Valid Valid connector
	Valid AuthenticationProvisioningState = "Valid"
)

// PossibleAuthenticationProvisioningStateValues returns an array of possible values for the AuthenticationProvisioningState const type.
func PossibleAuthenticationProvisioningStateValues() []AuthenticationProvisioningState {
	return []AuthenticationProvisioningState{Expired, IncorrectPolicy, Invalid, Valid}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAuthenticationDetailsProperties ...
	AuthenticationTypeAuthenticationDetailsProperties AuthenticationType = "AuthenticationDetailsProperties"
	// AuthenticationTypeAwsAssumeRole ...
	AuthenticationTypeAwsAssumeRole AuthenticationType = "awsAssumeRole"
	// AuthenticationTypeAwsCreds ...
	AuthenticationTypeAwsCreds AuthenticationType = "awsCreds"
	// AuthenticationTypeGcpCredentials ...
	AuthenticationTypeGcpCredentials AuthenticationType = "gcpCredentials"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeAuthenticationDetailsProperties, AuthenticationTypeAwsAssumeRole, AuthenticationTypeAwsCreds, AuthenticationTypeGcpCredentials}
}

// AutoProvision enumerates the values for auto provision.
type AutoProvision string

const (
	// AutoProvisionOff Do not install Azure Arc agent on the machines automatically
	AutoProvisionOff AutoProvision = "Off"
	// AutoProvisionOn Install missing Azure Arc agents on machines automatically
	AutoProvisionOn AutoProvision = "On"
)

// PossibleAutoProvisionValues returns an array of possible values for the AutoProvision const type.
func PossibleAutoProvisionValues() []AutoProvision {
	return []AutoProvision{AutoProvisionOff, AutoProvisionOn}
}

// ConfigurationStatus enumerates the values for configuration status.
type ConfigurationStatus string

const (
	// Configured ...
	Configured ConfigurationStatus = "Configured"
	// Failed ...
	Failed ConfigurationStatus = "Failed"
	// InProgress ...
	InProgress ConfigurationStatus = "InProgress"
	// NoStatus ...
	NoStatus ConfigurationStatus = "NoStatus"
	// NotConfigured ...
	NotConfigured ConfigurationStatus = "NotConfigured"
)

// PossibleConfigurationStatusValues returns an array of possible values for the ConfigurationStatus const type.
func PossibleConfigurationStatusValues() []ConfigurationStatus {
	return []ConfigurationStatus{Configured, Failed, InProgress, NoStatus, NotConfigured}
}

// ConfigurationStatus1 enumerates the values for configuration status 1.
type ConfigurationStatus1 string

const (
	// ConfigurationStatus1Configured ...
	ConfigurationStatus1Configured ConfigurationStatus1 = "Configured"
	// ConfigurationStatus1Failed ...
	ConfigurationStatus1Failed ConfigurationStatus1 = "Failed"
	// ConfigurationStatus1InProgress ...
	ConfigurationStatus1InProgress ConfigurationStatus1 = "InProgress"
	// ConfigurationStatus1NoStatus ...
	ConfigurationStatus1NoStatus ConfigurationStatus1 = "NoStatus"
	// ConfigurationStatus1NotConfigured ...
	ConfigurationStatus1NotConfigured ConfigurationStatus1 = "NotConfigured"
)

// PossibleConfigurationStatus1Values returns an array of possible values for the ConfigurationStatus1 const type.
func PossibleConfigurationStatus1Values() []ConfigurationStatus1 {
	return []ConfigurationStatus1{ConfigurationStatus1Configured, ConfigurationStatus1Failed, ConfigurationStatus1InProgress, ConfigurationStatus1NoStatus, ConfigurationStatus1NotConfigured}
}

// ConfigurationStatus2 enumerates the values for configuration status 2.
type ConfigurationStatus2 string

const (
	// ConfigurationStatus2Configured ...
	ConfigurationStatus2Configured ConfigurationStatus2 = "Configured"
	// ConfigurationStatus2Failed ...
	ConfigurationStatus2Failed ConfigurationStatus2 = "Failed"
	// ConfigurationStatus2InProgress ...
	ConfigurationStatus2InProgress ConfigurationStatus2 = "InProgress"
	// ConfigurationStatus2NoStatus ...
	ConfigurationStatus2NoStatus ConfigurationStatus2 = "NoStatus"
	// ConfigurationStatus2NotConfigured ...
	ConfigurationStatus2NotConfigured ConfigurationStatus2 = "NotConfigured"
)

// PossibleConfigurationStatus2Values returns an array of possible values for the ConfigurationStatus2 const type.
func PossibleConfigurationStatus2Values() []ConfigurationStatus2 {
	return []ConfigurationStatus2{ConfigurationStatus2Configured, ConfigurationStatus2Failed, ConfigurationStatus2InProgress, ConfigurationStatus2NoStatus, ConfigurationStatus2NotConfigured}
}

// ConnectionType enumerates the values for connection type.
type ConnectionType string

const (
	// External ...
	External ConnectionType = "External"
	// Internal ...
	Internal ConnectionType = "Internal"
)

// PossibleConnectionTypeValues returns an array of possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{External, Internal}
}

// ControlType enumerates the values for control type.
type ControlType string

const (
	// BuiltIn Azure Security Center managed assessments
	BuiltIn ControlType = "BuiltIn"
	// Custom Non Azure Security Center managed assessments
	Custom ControlType = "Custom"
)

// PossibleControlTypeValues returns an array of possible values for the ControlType const type.
func PossibleControlTypeValues() []ControlType {
	return []ControlType{BuiltIn, Custom}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound ...
	Inbound Direction = "Inbound"
	// Outbound ...
	Outbound Direction = "Outbound"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{Inbound, Outbound}
}

// EnforcementMode enumerates the values for enforcement mode.
type EnforcementMode string

const (
	// Audit ...
	Audit EnforcementMode = "Audit"
	// Enforce ...
	Enforce EnforcementMode = "Enforce"
	// None ...
	None EnforcementMode = "None"
)

// PossibleEnforcementModeValues returns an array of possible values for the EnforcementMode const type.
func PossibleEnforcementModeValues() []EnforcementMode {
	return []EnforcementMode{Audit, Enforce, None}
}

// EnforcementMode1 enumerates the values for enforcement mode 1.
type EnforcementMode1 string

const (
	// EnforcementMode1Audit ...
	EnforcementMode1Audit EnforcementMode1 = "Audit"
	// EnforcementMode1Enforce ...
	EnforcementMode1Enforce EnforcementMode1 = "Enforce"
	// EnforcementMode1None ...
	EnforcementMode1None EnforcementMode1 = "None"
)

// PossibleEnforcementMode1Values returns an array of possible values for the EnforcementMode1 const type.
func PossibleEnforcementMode1Values() []EnforcementMode1 {
	return []EnforcementMode1{EnforcementMode1Audit, EnforcementMode1Enforce, EnforcementMode1None}
}

// EnforcementSupport enumerates the values for enforcement support.
type EnforcementSupport string

const (
	// NotSupported ...
	NotSupported EnforcementSupport = "NotSupported"
	// Supported ...
	Supported EnforcementSupport = "Supported"
	// Unknown ...
	Unknown EnforcementSupport = "Unknown"
)

// PossibleEnforcementSupportValues returns an array of possible values for the EnforcementSupport const type.
func PossibleEnforcementSupportValues() []EnforcementSupport {
	return []EnforcementSupport{NotSupported, Supported, Unknown}
}

// EventSource enumerates the values for event source.
type EventSource string

const (
	// Alerts ...
	Alerts EventSource = "Alerts"
	// Assessments ...
	Assessments EventSource = "Assessments"
	// SecureScoreControls ...
	SecureScoreControls EventSource = "SecureScoreControls"
	// SecureScores ...
	SecureScores EventSource = "SecureScores"
	// SubAssessments ...
	SubAssessments EventSource = "SubAssessments"
)

// PossibleEventSourceValues returns an array of possible values for the EventSource const type.
func PossibleEventSourceValues() []EventSource {
	return []EventSource{Alerts, Assessments, SecureScoreControls, SecureScores, SubAssessments}
}

// Exe enumerates the values for exe.
type Exe string

const (
	// ExeAudit ...
	ExeAudit Exe = "Audit"
	// ExeEnforce ...
	ExeEnforce Exe = "Enforce"
	// ExeNone ...
	ExeNone Exe = "None"
)

// PossibleExeValues returns an array of possible values for the Exe const type.
func PossibleExeValues() []Exe {
	return []Exe{ExeAudit, ExeEnforce, ExeNone}
}

// Executable enumerates the values for executable.
type Executable string

const (
	// ExecutableAudit ...
	ExecutableAudit Executable = "Audit"
	// ExecutableEnforce ...
	ExecutableEnforce Executable = "Enforce"
	// ExecutableNone ...
	ExecutableNone Executable = "None"
)

// PossibleExecutableValues returns an array of possible values for the Executable const type.
func PossibleExecutableValues() []Executable {
	return []Executable{ExecutableAudit, ExecutableEnforce, ExecutableNone}
}

// ExpandControlsEnum enumerates the values for expand controls enum.
type ExpandControlsEnum string

const (
	// Definition Add definition object for each control
	Definition ExpandControlsEnum = "definition"
)

// PossibleExpandControlsEnumValues returns an array of possible values for the ExpandControlsEnum const type.
func PossibleExpandControlsEnumValues() []ExpandControlsEnum {
	return []ExpandControlsEnum{Definition}
}

// ExternalSecuritySolutionKind enumerates the values for external security solution kind.
type ExternalSecuritySolutionKind string

const (
	// AAD ...
	AAD ExternalSecuritySolutionKind = "AAD"
	// ATA ...
	ATA ExternalSecuritySolutionKind = "ATA"
	// CEF ...
	CEF ExternalSecuritySolutionKind = "CEF"
)

// PossibleExternalSecuritySolutionKindValues returns an array of possible values for the ExternalSecuritySolutionKind const type.
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return []ExternalSecuritySolutionKind{AAD, ATA, CEF}
}

// Family enumerates the values for family.
type Family string

const (
	// Ngfw ...
	Ngfw Family = "Ngfw"
	// SaasWaf ...
	SaasWaf Family = "SaasWaf"
	// Va ...
	Va Family = "Va"
	// Waf ...
	Waf Family = "Waf"
)

// PossibleFamilyValues returns an array of possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{Ngfw, SaasWaf, Va, Waf}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// FileTypeDll ...
	FileTypeDll FileType = "Dll"
	// FileTypeExe ...
	FileTypeExe FileType = "Exe"
	// FileTypeExecutable ...
	FileTypeExecutable FileType = "Executable"
	// FileTypeMsi ...
	FileTypeMsi FileType = "Msi"
	// FileTypeScript ...
	FileTypeScript FileType = "Script"
	// FileTypeUnknown ...
	FileTypeUnknown FileType = "Unknown"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{FileTypeDll, FileTypeExe, FileTypeExecutable, FileTypeMsi, FileTypeScript, FileTypeUnknown}
}

// HybridComputeProvisioningState enumerates the values for hybrid compute provisioning state.
type HybridComputeProvisioningState string

const (
	// HybridComputeProvisioningStateExpired the service principal details are expired
	HybridComputeProvisioningStateExpired HybridComputeProvisioningState = "Expired"
	// HybridComputeProvisioningStateInvalid Invalid service principal details.
	HybridComputeProvisioningStateInvalid HybridComputeProvisioningState = "Invalid"
	// HybridComputeProvisioningStateValid Valid service principal details.
	HybridComputeProvisioningStateValid HybridComputeProvisioningState = "Valid"
)

// PossibleHybridComputeProvisioningStateValues returns an array of possible values for the HybridComputeProvisioningState const type.
func PossibleHybridComputeProvisioningStateValues() []HybridComputeProvisioningState {
	return []HybridComputeProvisioningState{HybridComputeProvisioningStateExpired, HybridComputeProvisioningStateInvalid, HybridComputeProvisioningStateValid}
}

// Issue enumerates the values for issue.
type Issue string

const (
	// ExecutableViolationsAudited ...
	ExecutableViolationsAudited Issue = "ExecutableViolationsAudited"
	// MsiAndScriptViolationsAudited ...
	MsiAndScriptViolationsAudited Issue = "MsiAndScriptViolationsAudited"
	// MsiAndScriptViolationsBlocked ...
	MsiAndScriptViolationsBlocked Issue = "MsiAndScriptViolationsBlocked"
	// RulesViolatedManually ...
	RulesViolatedManually Issue = "RulesViolatedManually"
	// ViolationsAudited ...
	ViolationsAudited Issue = "ViolationsAudited"
	// ViolationsBlocked ...
	ViolationsBlocked Issue = "ViolationsBlocked"
)

// PossibleIssueValues returns an array of possible values for the Issue const type.
func PossibleIssueValues() []Issue {
	return []Issue{ExecutableViolationsAudited, MsiAndScriptViolationsAudited, MsiAndScriptViolationsBlocked, RulesViolatedManually, ViolationsAudited, ViolationsBlocked}
}

// KindEnum enumerates the values for kind enum.
type KindEnum string

const (
	// KindAAD ...
	KindAAD KindEnum = "AAD"
	// KindATA ...
	KindATA KindEnum = "ATA"
	// KindCEF ...
	KindCEF KindEnum = "CEF"
	// KindExternalSecuritySolution ...
	KindExternalSecuritySolution KindEnum = "ExternalSecuritySolution"
)

// PossibleKindEnumValues returns an array of possible values for the KindEnum const type.
func PossibleKindEnumValues() []KindEnum {
	return []KindEnum{KindAAD, KindATA, KindCEF, KindExternalSecuritySolution}
}

// Msi enumerates the values for msi.
type Msi string

const (
	// MsiAudit ...
	MsiAudit Msi = "Audit"
	// MsiEnforce ...
	MsiEnforce Msi = "Enforce"
	// MsiNone ...
	MsiNone Msi = "None"
)

// PossibleMsiValues returns an array of possible values for the Msi const type.
func PossibleMsiValues() []Msi {
	return []Msi{MsiAudit, MsiEnforce, MsiNone}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Contains ...
	Contains Operator = "Contains"
	// EndsWith ...
	EndsWith Operator = "EndsWith"
	// Equals ...
	Equals Operator = "Equals"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqualTo ...
	GreaterThanOrEqualTo Operator = "GreaterThanOrEqualTo"
	// LesserThan ...
	LesserThan Operator = "LesserThan"
	// LesserThanOrEqualTo ...
	LesserThanOrEqualTo Operator = "LesserThanOrEqualTo"
	// NotEquals ...
	NotEquals Operator = "NotEquals"
	// StartsWith ...
	StartsWith Operator = "StartsWith"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Contains, EndsWith, Equals, GreaterThan, GreaterThanOrEqualTo, LesserThan, LesserThanOrEqualTo, NotEquals, StartsWith}
}

// PermissionProperty enumerates the values for permission property.
type PermissionProperty string

const (
	// AWSAmazonSSMAutomationRole The permission provides for EC2 Automation service to execute activities
	// defined within Automation documents.
	AWSAmazonSSMAutomationRole PermissionProperty = "AWS::AmazonSSMAutomationRole"
	// AWSAWSSecurityHubReadOnlyAccess This permission provides read only access to AWS Security Hub resources.
	AWSAWSSecurityHubReadOnlyAccess PermissionProperty = "AWS::AWSSecurityHubReadOnlyAccess"
	// AWSSecurityAudit This permission grants access to read security configuration metadata.
	AWSSecurityAudit PermissionProperty = "AWS::SecurityAudit"
	// GCPSecurityCenterAdminViewer This permission provides read only access to GCP Security Command Center.
	GCPSecurityCenterAdminViewer PermissionProperty = "GCP::Security Center Admin Viewer"
)

// PossiblePermissionPropertyValues returns an array of possible values for the PermissionProperty const type.
func PossiblePermissionPropertyValues() []PermissionProperty {
	return []PermissionProperty{AWSAmazonSSMAutomationRole, AWSAWSSecurityHubReadOnlyAccess, AWSSecurityAudit, GCPSecurityCenterAdminViewer}
}

// PricingTier enumerates the values for pricing tier.
type PricingTier string

const (
	// Free Get free Azure security center experience with basic security features
	Free PricingTier = "Free"
	// Standard Get the standard Azure security center experience with advanced security features
	Standard PricingTier = "Standard"
)

// PossiblePricingTierValues returns an array of possible values for the PricingTier const type.
func PossiblePricingTierValues() []PricingTier {
	return []PricingTier{Free, Standard}
}

// PropertyType enumerates the values for property type.
type PropertyType string

const (
	// Boolean ...
	Boolean PropertyType = "Boolean"
	// Integer ...
	Integer PropertyType = "Integer"
	// Number ...
	Number PropertyType = "Number"
	// String ...
	String PropertyType = "String"
)

// PossiblePropertyTypeValues returns an array of possible values for the PropertyType const type.
func PossiblePropertyTypeValues() []PropertyType {
	return []PropertyType{Boolean, Integer, Number, String}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// All ...
	All Protocol = "*"
	// TCP ...
	TCP Protocol = "TCP"
	// UDP ...
	UDP Protocol = "UDP"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{All, TCP, UDP}
}

// Rank enumerates the values for rank.
type Rank string

const (
	// RankCritical ...
	RankCritical Rank = "Critical"
	// RankHigh ...
	RankHigh Rank = "High"
	// RankLow ...
	RankLow Rank = "Low"
	// RankMedium ...
	RankMedium Rank = "Medium"
	// RankNone ...
	RankNone Rank = "None"
)

// PossibleRankValues returns an array of possible values for the Rank const type.
func PossibleRankValues() []Rank {
	return []Rank{RankCritical, RankHigh, RankLow, RankMedium, RankNone}
}

// RecommendationAction enumerates the values for recommendation action.
type RecommendationAction string

const (
	// RecommendationActionAdd ...
	RecommendationActionAdd RecommendationAction = "Add"
	// RecommendationActionRecommended ...
	RecommendationActionRecommended RecommendationAction = "Recommended"
	// RecommendationActionRemove ...
	RecommendationActionRemove RecommendationAction = "Remove"
)

// PossibleRecommendationActionValues returns an array of possible values for the RecommendationAction const type.
func PossibleRecommendationActionValues() []RecommendationAction {
	return []RecommendationAction{RecommendationActionAdd, RecommendationActionRecommended, RecommendationActionRemove}
}

// RecommendationAction1 enumerates the values for recommendation action 1.
type RecommendationAction1 string

const (
	// RecommendationAction1Add ...
	RecommendationAction1Add RecommendationAction1 = "Add"
	// RecommendationAction1Recommended ...
	RecommendationAction1Recommended RecommendationAction1 = "Recommended"
	// RecommendationAction1Remove ...
	RecommendationAction1Remove RecommendationAction1 = "Remove"
)

// PossibleRecommendationAction1Values returns an array of possible values for the RecommendationAction1 const type.
func PossibleRecommendationAction1Values() []RecommendationAction1 {
	return []RecommendationAction1{RecommendationAction1Add, RecommendationAction1Recommended, RecommendationAction1Remove}
}

// RecommendationStatus enumerates the values for recommendation status.
type RecommendationStatus string

const (
	// RecommendationStatusNoStatus ...
	RecommendationStatusNoStatus RecommendationStatus = "NoStatus"
	// RecommendationStatusNotAvailable ...
	RecommendationStatusNotAvailable RecommendationStatus = "NotAvailable"
	// RecommendationStatusNotRecommended ...
	RecommendationStatusNotRecommended RecommendationStatus = "NotRecommended"
	// RecommendationStatusRecommended ...
	RecommendationStatusRecommended RecommendationStatus = "Recommended"
)

// PossibleRecommendationStatusValues returns an array of possible values for the RecommendationStatus const type.
func PossibleRecommendationStatusValues() []RecommendationStatus {
	return []RecommendationStatus{RecommendationStatusNoStatus, RecommendationStatusNotAvailable, RecommendationStatusNotRecommended, RecommendationStatusRecommended}
}

// ReportedSeverity enumerates the values for reported severity.
type ReportedSeverity string

const (
	// High ...
	High ReportedSeverity = "High"
	// Information ...
	Information ReportedSeverity = "Information"
	// Low ...
	Low ReportedSeverity = "Low"
	// Silent ...
	Silent ReportedSeverity = "Silent"
)

// PossibleReportedSeverityValues returns an array of possible values for the ReportedSeverity const type.
func PossibleReportedSeverityValues() []ReportedSeverity {
	return []ReportedSeverity{High, Information, Low, Silent}
}

// RuleSeverity enumerates the values for rule severity.
type RuleSeverity string

const (
	// RuleSeverityHigh High
	RuleSeverityHigh RuleSeverity = "High"
	// RuleSeverityInformational Informational
	RuleSeverityInformational RuleSeverity = "Informational"
	// RuleSeverityLow Low
	RuleSeverityLow RuleSeverity = "Low"
	// RuleSeverityMedium Medium
	RuleSeverityMedium RuleSeverity = "Medium"
	// RuleSeverityObsolete Obsolete
	RuleSeverityObsolete RuleSeverity = "Obsolete"
)

// PossibleRuleSeverityValues returns an array of possible values for the RuleSeverity const type.
func PossibleRuleSeverityValues() []RuleSeverity {
	return []RuleSeverity{RuleSeverityHigh, RuleSeverityInformational, RuleSeverityLow, RuleSeverityMedium, RuleSeverityObsolete}
}

// RuleState enumerates the values for rule state.
type RuleState string

const (
	// RuleStateDisabled ...
	RuleStateDisabled RuleState = "Disabled"
	// RuleStateEnabled ...
	RuleStateEnabled RuleState = "Enabled"
	// RuleStateExpired ...
	RuleStateExpired RuleState = "Expired"
)

// PossibleRuleStateValues returns an array of possible values for the RuleState const type.
func PossibleRuleStateValues() []RuleState {
	return []RuleState{RuleStateDisabled, RuleStateEnabled, RuleStateExpired}
}

// RuleStatus enumerates the values for rule status.
type RuleStatus string

const (
	// Finding Finding
	Finding RuleStatus = "Finding"
	// InternalError InternalError
	InternalError RuleStatus = "InternalError"
	// NonFinding NonFinding
	NonFinding RuleStatus = "NonFinding"
)

// PossibleRuleStatusValues returns an array of possible values for the RuleStatus const type.
func PossibleRuleStatusValues() []RuleStatus {
	return []RuleStatus{Finding, InternalError, NonFinding}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// BaselineExpected BaselineExpected
	BaselineExpected RuleType = "BaselineExpected"
	// Binary Binary
	Binary RuleType = "Binary"
	// NegativeList NegativeList
	NegativeList RuleType = "NegativeList"
	// PositiveList PositiveList
	PositiveList RuleType = "PositiveList"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{BaselineExpected, Binary, NegativeList, PositiveList}
}

// RuleTypeBasicCustomAlertRule enumerates the values for rule type basic custom alert rule.
type RuleTypeBasicCustomAlertRule string

const (
	// RuleTypeActiveConnectionsNotInAllowedRange ...
	RuleTypeActiveConnectionsNotInAllowedRange RuleTypeBasicCustomAlertRule = "ActiveConnectionsNotInAllowedRange"
	// RuleTypeAllowlistCustomAlertRule ...
	RuleTypeAllowlistCustomAlertRule RuleTypeBasicCustomAlertRule = "AllowlistCustomAlertRule"
	// RuleTypeAmqpC2DMessagesNotInAllowedRange ...
	RuleTypeAmqpC2DMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "AmqpC2DMessagesNotInAllowedRange"
	// RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "AmqpC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeAmqpD2CMessagesNotInAllowedRange ...
	RuleTypeAmqpD2CMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "AmqpD2CMessagesNotInAllowedRange"
	// RuleTypeConnectionToIPNotAllowed ...
	RuleTypeConnectionToIPNotAllowed RuleTypeBasicCustomAlertRule = "ConnectionToIpNotAllowed"
	// RuleTypeCustomAlertRule ...
	RuleTypeCustomAlertRule RuleTypeBasicCustomAlertRule = "CustomAlertRule"
	// RuleTypeDenylistCustomAlertRule ...
	RuleTypeDenylistCustomAlertRule RuleTypeBasicCustomAlertRule = "DenylistCustomAlertRule"
	// RuleTypeDirectMethodInvokesNotInAllowedRange ...
	RuleTypeDirectMethodInvokesNotInAllowedRange RuleTypeBasicCustomAlertRule = "DirectMethodInvokesNotInAllowedRange"
	// RuleTypeFailedLocalLoginsNotInAllowedRange ...
	RuleTypeFailedLocalLoginsNotInAllowedRange RuleTypeBasicCustomAlertRule = "FailedLocalLoginsNotInAllowedRange"
	// RuleTypeFileUploadsNotInAllowedRange ...
	RuleTypeFileUploadsNotInAllowedRange RuleTypeBasicCustomAlertRule = "FileUploadsNotInAllowedRange"
	// RuleTypeHTTPC2DMessagesNotInAllowedRange ...
	RuleTypeHTTPC2DMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "HttpC2DMessagesNotInAllowedRange"
	// RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "HttpC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeHTTPD2CMessagesNotInAllowedRange ...
	RuleTypeHTTPD2CMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "HttpD2CMessagesNotInAllowedRange"
	// RuleTypeListCustomAlertRule ...
	RuleTypeListCustomAlertRule RuleTypeBasicCustomAlertRule = "ListCustomAlertRule"
	// RuleTypeLocalUserNotAllowed ...
	RuleTypeLocalUserNotAllowed RuleTypeBasicCustomAlertRule = "LocalUserNotAllowed"
	// RuleTypeMqttC2DMessagesNotInAllowedRange ...
	RuleTypeMqttC2DMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "MqttC2DMessagesNotInAllowedRange"
	// RuleTypeMqttC2DRejectedMessagesNotInAllowedRange ...
	RuleTypeMqttC2DRejectedMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "MqttC2DRejectedMessagesNotInAllowedRange"
	// RuleTypeMqttD2CMessagesNotInAllowedRange ...
	RuleTypeMqttD2CMessagesNotInAllowedRange RuleTypeBasicCustomAlertRule = "MqttD2CMessagesNotInAllowedRange"
	// RuleTypeProcessNotAllowed ...
	RuleTypeProcessNotAllowed RuleTypeBasicCustomAlertRule = "ProcessNotAllowed"
	// RuleTypeQueuePurgesNotInAllowedRange ...
	RuleTypeQueuePurgesNotInAllowedRange RuleTypeBasicCustomAlertRule = "QueuePurgesNotInAllowedRange"
	// RuleTypeThresholdCustomAlertRule ...
	RuleTypeThresholdCustomAlertRule RuleTypeBasicCustomAlertRule = "ThresholdCustomAlertRule"
	// RuleTypeTimeWindowCustomAlertRule ...
	RuleTypeTimeWindowCustomAlertRule RuleTypeBasicCustomAlertRule = "TimeWindowCustomAlertRule"
	// RuleTypeTwinUpdatesNotInAllowedRange ...
	RuleTypeTwinUpdatesNotInAllowedRange RuleTypeBasicCustomAlertRule = "TwinUpdatesNotInAllowedRange"
	// RuleTypeUnauthorizedOperationsNotInAllowedRange ...
	RuleTypeUnauthorizedOperationsNotInAllowedRange RuleTypeBasicCustomAlertRule = "UnauthorizedOperationsNotInAllowedRange"
)

// PossibleRuleTypeBasicCustomAlertRuleValues returns an array of possible values for the RuleTypeBasicCustomAlertRule const type.
func PossibleRuleTypeBasicCustomAlertRuleValues() []RuleTypeBasicCustomAlertRule {
	return []RuleTypeBasicCustomAlertRule{RuleTypeActiveConnectionsNotInAllowedRange, RuleTypeAllowlistCustomAlertRule, RuleTypeAmqpC2DMessagesNotInAllowedRange, RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange, RuleTypeAmqpD2CMessagesNotInAllowedRange, RuleTypeConnectionToIPNotAllowed, RuleTypeCustomAlertRule, RuleTypeDenylistCustomAlertRule, RuleTypeDirectMethodInvokesNotInAllowedRange, RuleTypeFailedLocalLoginsNotInAllowedRange, RuleTypeFileUploadsNotInAllowedRange, RuleTypeHTTPC2DMessagesNotInAllowedRange, RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange, RuleTypeHTTPD2CMessagesNotInAllowedRange, RuleTypeListCustomAlertRule, RuleTypeLocalUserNotAllowed, RuleTypeMqttC2DMessagesNotInAllowedRange, RuleTypeMqttC2DRejectedMessagesNotInAllowedRange, RuleTypeMqttD2CMessagesNotInAllowedRange, RuleTypeProcessNotAllowed, RuleTypeQueuePurgesNotInAllowedRange, RuleTypeThresholdCustomAlertRule, RuleTypeTimeWindowCustomAlertRule, RuleTypeTwinUpdatesNotInAllowedRange, RuleTypeUnauthorizedOperationsNotInAllowedRange}
}

// ScanState enumerates the values for scan state.
type ScanState string

const (
	// ScanStateFailed Failed
	ScanStateFailed ScanState = "Failed"
	// ScanStateFailedToRun FailedToRun
	ScanStateFailedToRun ScanState = "FailedToRun"
	// ScanStateInProgress InProgress
	ScanStateInProgress ScanState = "InProgress"
	// ScanStatePassed Passed
	ScanStatePassed ScanState = "Passed"
)

// PossibleScanStateValues returns an array of possible values for the ScanState const type.
func PossibleScanStateValues() []ScanState {
	return []ScanState{ScanStateFailed, ScanStateFailedToRun, ScanStateInProgress, ScanStatePassed}
}

// ScanTriggerType enumerates the values for scan trigger type.
type ScanTriggerType string

const (
	// OnDemand OnDemand
	OnDemand ScanTriggerType = "OnDemand"
	// Recurring Recurring
	Recurring ScanTriggerType = "Recurring"
)

// PossibleScanTriggerTypeValues returns an array of possible values for the ScanTriggerType const type.
func PossibleScanTriggerTypeValues() []ScanTriggerType {
	return []ScanTriggerType{OnDemand, Recurring}
}

// Script enumerates the values for script.
type Script string

const (
	// ScriptAudit ...
	ScriptAudit Script = "Audit"
	// ScriptEnforce ...
	ScriptEnforce Script = "Enforce"
	// ScriptNone ...
	ScriptNone Script = "None"
)

// PossibleScriptValues returns an array of possible values for the Script const type.
func PossibleScriptValues() []Script {
	return []Script{ScriptAudit, ScriptEnforce, ScriptNone}
}

// SettingKind enumerates the values for setting kind.
type SettingKind string

const (
	// SettingKindAlertSuppressionSetting ...
	SettingKindAlertSuppressionSetting SettingKind = "AlertSuppressionSetting"
	// SettingKindDataExportSetting ...
	SettingKindDataExportSetting SettingKind = "DataExportSetting"
)

// PossibleSettingKindValues returns an array of possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{SettingKindAlertSuppressionSetting, SettingKindDataExportSetting}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityHigh ...
	SeverityHigh Severity = "High"
	// SeverityLow ...
	SeverityLow Severity = "Low"
	// SeverityMedium ...
	SeverityMedium Severity = "Medium"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityHigh, SeverityLow, SeverityMedium}
}

// Source enumerates the values for source.
type Source string

const (
	// SourceAzure ...
	SourceAzure Source = "Azure"
	// SourceOnPremise ...
	SourceOnPremise Source = "OnPremise"
	// SourceOnPremiseSQL ...
	SourceOnPremiseSQL Source = "OnPremiseSql"
	// SourceResourceDetails ...
	SourceResourceDetails Source = "ResourceDetails"
)

// PossibleSourceValues returns an array of possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{SourceAzure, SourceOnPremise, SourceOnPremiseSQL, SourceResourceDetails}
}

// SourceSystem enumerates the values for source system.
type SourceSystem string

const (
	// SourceSystemAzureAppLocker ...
	SourceSystemAzureAppLocker SourceSystem = "Azure_AppLocker"
	// SourceSystemAzureAuditD ...
	SourceSystemAzureAuditD SourceSystem = "Azure_AuditD"
	// SourceSystemNonAzureAppLocker ...
	SourceSystemNonAzureAppLocker SourceSystem = "NonAzure_AppLocker"
	// SourceSystemNonAzureAuditD ...
	SourceSystemNonAzureAuditD SourceSystem = "NonAzure_AuditD"
	// SourceSystemNone ...
	SourceSystemNone SourceSystem = "None"
)

// PossibleSourceSystemValues returns an array of possible values for the SourceSystem const type.
func PossibleSourceSystemValues() []SourceSystem {
	return []SourceSystem{SourceSystemAzureAppLocker, SourceSystemAzureAuditD, SourceSystemNonAzureAppLocker, SourceSystemNonAzureAuditD, SourceSystemNone}
}

// State enumerates the values for state.
type State string

const (
	// StateFailed At least one supported regulatory compliance control in the given standard has a state of
	// failed
	StateFailed State = "Failed"
	// StatePassed All supported regulatory compliance controls in the given standard have a passed state
	StatePassed State = "Passed"
	// StateSkipped All supported regulatory compliance controls in the given standard have a state of skipped
	StateSkipped State = "Skipped"
	// StateUnsupported No supported regulatory compliance data for the given standard
	StateUnsupported State = "Unsupported"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateFailed, StatePassed, StateSkipped, StateUnsupported}
}

// Status enumerates the values for status.
type Status string

const (
	// Initiated ...
	Initiated Status = "Initiated"
	// Revoked ...
	Revoked Status = "Revoked"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Initiated, Revoked}
}

// StatusReason enumerates the values for status reason.
type StatusReason string

const (
	// StatusReasonExpired ...
	StatusReasonExpired StatusReason = "Expired"
	// StatusReasonNewerRequestInitiated ...
	StatusReasonNewerRequestInitiated StatusReason = "NewerRequestInitiated"
	// StatusReasonUserRequested ...
	StatusReasonUserRequested StatusReason = "UserRequested"
)

// PossibleStatusReasonValues returns an array of possible values for the StatusReason const type.
func PossibleStatusReasonValues() []StatusReason {
	return []StatusReason{StatusReasonExpired, StatusReasonNewerRequestInitiated, StatusReasonUserRequested}
}

// SubAssessmentStatusCode enumerates the values for sub assessment status code.
type SubAssessmentStatusCode string

const (
	// Healthy The resource is healthy
	Healthy SubAssessmentStatusCode = "Healthy"
	// NotApplicable Assessment for this resource did not happen
	NotApplicable SubAssessmentStatusCode = "NotApplicable"
	// Unhealthy The resource has a security issue that needs to be addressed
	Unhealthy SubAssessmentStatusCode = "Unhealthy"
)

// PossibleSubAssessmentStatusCodeValues returns an array of possible values for the SubAssessmentStatusCode const type.
func PossibleSubAssessmentStatusCodeValues() []SubAssessmentStatusCode {
	return []SubAssessmentStatusCode{Healthy, NotApplicable, Unhealthy}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "TCP"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "UDP"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolTCP, TransportProtocolUDP}
}

// Type enumerates the values for type.
type Type string

const (
	// BinarySignature ...
	BinarySignature Type = "BinarySignature"
	// File ...
	File Type = "File"
	// FileHash ...
	FileHash Type = "FileHash"
	// ProductSignature ...
	ProductSignature Type = "ProductSignature"
	// PublisherSignature ...
	PublisherSignature Type = "PublisherSignature"
	// VersionAndAboveSignature ...
	VersionAndAboveSignature Type = "VersionAndAboveSignature"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{BinarySignature, File, FileHash, ProductSignature, PublisherSignature, VersionAndAboveSignature}
}

// ValueType enumerates the values for value type.
type ValueType string

const (
	// ValueTypeIPCidr An IP range in CIDR format (e.g. '192.168.0.1/8').
	ValueTypeIPCidr ValueType = "IpCidr"
	// ValueTypeString Any string value.
	ValueTypeString ValueType = "String"
)

// PossibleValueTypeValues returns an array of possible values for the ValueType const type.
func PossibleValueTypeValues() []ValueType {
	return []ValueType{ValueTypeIPCidr, ValueTypeString}
}
