package windowsesu

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// MultipleActivationKeysClient is the manage Multi-Access Keys (MAK) that enable Windows Extended Security Updates
// (ESU).
type MultipleActivationKeysClient struct {
	BaseClient
}

// NewMultipleActivationKeysClient creates an instance of the MultipleActivationKeysClient client.
func NewMultipleActivationKeysClient(subscriptionID string) MultipleActivationKeysClient {
	return NewMultipleActivationKeysClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewMultipleActivationKeysClientWithBaseURI creates an instance of the MultipleActivationKeysClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewMultipleActivationKeysClientWithBaseURI(baseURI string, subscriptionID string) MultipleActivationKeysClient {
	return MultipleActivationKeysClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create create a MAK key.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// multipleActivationKeyName - the name of the MAK key.
// multipleActivationKey - details of the MAK key.
func (client MultipleActivationKeysClient) Create(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey MultipleActivationKey) (result MultipleActivationKeysCreateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.Create")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: multipleActivationKey,
			Constraints: []validation.Constraint{{Target: "multipleActivationKey.MultipleActivationKeyProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "multipleActivationKey.MultipleActivationKeyProperties.InstalledServerNumber", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "multipleActivationKey.MultipleActivationKeyProperties.InstalledServerNumber", Name: validation.InclusiveMaximum, Rule: int64(5000), Chain: nil},
						{Target: "multipleActivationKey.MultipleActivationKeyProperties.InstalledServerNumber", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("windowsesu.MultipleActivationKeysClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, multipleActivationKeyName, multipleActivationKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Create", nil, "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client MultipleActivationKeysClient) CreatePreparer(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey MultipleActivationKey) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"multipleActivationKeyName": autorest.Encode("path", multipleActivationKeyName),
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-09-16-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsESU/multipleActivationKeys/{multipleActivationKeyName}", pathParameters),
		autorest.WithJSON(multipleActivationKey),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client MultipleActivationKeysClient) CreateSender(req *http.Request) (future MultipleActivationKeysCreateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client MultipleActivationKeysClient) (mak MultipleActivationKey, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysCreateFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("windowsesu.MultipleActivationKeysCreateFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		if mak.Response.Response, err = future.GetResult(sender); err == nil && mak.Response.Response.StatusCode != http.StatusNoContent {
			mak, err = client.CreateResponder(mak.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysCreateFuture", "Result", mak.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client MultipleActivationKeysClient) CreateResponder(resp *http.Response) (result MultipleActivationKey, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a MAK key.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// multipleActivationKeyName - the name of the MAK key.
func (client MultipleActivationKeysClient) Delete(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("windowsesu.MultipleActivationKeysClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, multipleActivationKeyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client MultipleActivationKeysClient) DeletePreparer(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"multipleActivationKeyName": autorest.Encode("path", multipleActivationKeyName),
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-09-16-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsESU/multipleActivationKeys/{multipleActivationKeyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client MultipleActivationKeysClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client MultipleActivationKeysClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get a MAK key.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// multipleActivationKeyName - the name of the MAK key.
func (client MultipleActivationKeysClient) Get(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (result MultipleActivationKey, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("windowsesu.MultipleActivationKeysClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, multipleActivationKeyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client MultipleActivationKeysClient) GetPreparer(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"multipleActivationKeyName": autorest.Encode("path", multipleActivationKeyName),
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-09-16-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsESU/multipleActivationKeys/{multipleActivationKeyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client MultipleActivationKeysClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client MultipleActivationKeysClient) GetResponder(resp *http.Response) (result MultipleActivationKey, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list all Multiple Activation Keys (MAK) created for a subscription.
func (client MultipleActivationKeysClient) List(ctx context.Context) (result MultipleActivationKeyListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.List")
		defer func() {
			sc := -1
			if result.makl.Response.Response != nil {
				sc = result.makl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("windowsesu.MultipleActivationKeysClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.makl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "List", resp, "Failure sending request")
		return
	}

	result.makl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "List", resp, "Failure responding to request")
		return
	}
	if result.makl.hasNextLink() && result.makl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client MultipleActivationKeysClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-09-16-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.WindowsESU/multipleActivationKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client MultipleActivationKeysClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client MultipleActivationKeysClient) ListResponder(resp *http.Response) (result MultipleActivationKeyList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client MultipleActivationKeysClient) listNextResults(ctx context.Context, lastResults MultipleActivationKeyList) (result MultipleActivationKeyList, err error) {
	req, err := lastResults.multipleActivationKeyListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client MultipleActivationKeysClient) ListComplete(ctx context.Context) (result MultipleActivationKeyListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListByResourceGroup list all Multiple Activation Keys (MAK) in a resource group.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client MultipleActivationKeysClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result MultipleActivationKeyListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.makl.Response.Response != nil {
				sc = result.makl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("windowsesu.MultipleActivationKeysClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.makl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.makl, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.makl.hasNextLink() && result.makl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client MultipleActivationKeysClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-09-16-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsESU/multipleActivationKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client MultipleActivationKeysClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client MultipleActivationKeysClient) ListByResourceGroupResponder(resp *http.Response) (result MultipleActivationKeyList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client MultipleActivationKeysClient) listByResourceGroupNextResults(ctx context.Context, lastResults MultipleActivationKeyList) (result MultipleActivationKeyList, err error) {
	req, err := lastResults.multipleActivationKeyListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client MultipleActivationKeysClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result MultipleActivationKeyListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// Update update a MAK key.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// multipleActivationKeyName - the name of the MAK key.
// multipleActivationKey - details of the MAK key.
func (client MultipleActivationKeysClient) Update(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey MultipleActivationKeyUpdate) (result MultipleActivationKey, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MultipleActivationKeysClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("windowsesu.MultipleActivationKeysClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, multipleActivationKeyName, multipleActivationKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "windowsesu.MultipleActivationKeysClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client MultipleActivationKeysClient) UpdatePreparer(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey MultipleActivationKeyUpdate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"multipleActivationKeyName": autorest.Encode("path", multipleActivationKeyName),
		"resourceGroupName":         autorest.Encode("path", resourceGroupName),
		"subscriptionId":            autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-09-16-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.WindowsESU/multipleActivationKeys/{multipleActivationKeyName}", pathParameters),
		autorest.WithJSON(multipleActivationKey),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client MultipleActivationKeysClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client MultipleActivationKeysClient) UpdateResponder(resp *http.Response) (result MultipleActivationKey, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
