/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// KubernetesApiService KubernetesApi service
type KubernetesApiService service

type ApiK8sDeleteRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sDeleteRequest) Pretty(pretty bool) ApiK8sDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sDeleteRequest) Depth(depth int32) ApiK8sDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sDeleteRequest) XContractNumber(xContractNumber int32) ApiK8sDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.K8sDeleteExecute(r)
}

/*
 * K8sDelete Delete Kubernetes Cluster
 * This will remove a Kubernetes Cluster.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @return ApiK8sDeleteRequest
 */
func (a *KubernetesApiService) K8sDelete(ctx _context.Context, k8sClusterId string) ApiK8sDeleteRequest {
	return ApiK8sDeleteRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *KubernetesApiService) K8sDeleteExecute(r ApiK8sDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sFindByClusteridRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sFindByClusteridRequest) Pretty(pretty bool) ApiK8sFindByClusteridRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sFindByClusteridRequest) Depth(depth int32) ApiK8sFindByClusteridRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sFindByClusteridRequest) XContractNumber(xContractNumber int32) ApiK8sFindByClusteridRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sFindByClusteridRequest) Execute() (KubernetesCluster, *APIResponse, error) {
	return r.ApiService.K8sFindByClusteridExecute(r)
}

/*
 * K8sFindByClusterid Retrieve Kubernetes Cluster
 * This will retrieve a single Kubernetes Cluster.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @return ApiK8sFindByClusteridRequest
 */
func (a *KubernetesApiService) K8sFindByClusterid(ctx _context.Context, k8sClusterId string) ApiK8sFindByClusteridRequest {
	return ApiK8sFindByClusteridRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesCluster
 */
func (a *KubernetesApiService) K8sFindByClusteridExecute(r ApiK8sFindByClusteridRequest) (KubernetesCluster, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesCluster
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sFindByClusterid")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sFindByClusterid",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sGetRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sGetRequest) Pretty(pretty bool) ApiK8sGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sGetRequest) Depth(depth int32) ApiK8sGetRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sGetRequest) XContractNumber(xContractNumber int32) ApiK8sGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sGetRequest) Execute() (KubernetesClusters, *APIResponse, error) {
	return r.ApiService.K8sGetExecute(r)
}

/*
 * K8sGet List Kubernetes Clusters
 * You can retrieve a list of all kubernetes clusters associated with a contract
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiK8sGetRequest
 */
func (a *KubernetesApiService) K8sGet(ctx _context.Context) ApiK8sGetRequest {
	return ApiK8sGetRequest{
		ApiService: a,
		ctx: ctx,
	}
}

/*
 * Execute executes the request
 * @return KubernetesClusters
 */
func (a *KubernetesApiService) K8sGetExecute(r ApiK8sGetRequest) (KubernetesClusters, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesClusters
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sKubeconfigGetRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sKubeconfigGetRequest) Pretty(pretty bool) ApiK8sKubeconfigGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sKubeconfigGetRequest) Depth(depth int32) ApiK8sKubeconfigGetRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sKubeconfigGetRequest) XContractNumber(xContractNumber int32) ApiK8sKubeconfigGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sKubeconfigGetRequest) Execute() (KubernetesConfig, *APIResponse, error) {
	return r.ApiService.K8sKubeconfigGetExecute(r)
}

/*
 * K8sKubeconfigGet Retrieve Kubernetes Configuration File
 * You can retrieve kubernetes configuration file for the kubernetes cluster.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @return ApiK8sKubeconfigGetRequest
 */
func (a *KubernetesApiService) K8sKubeconfigGet(ctx _context.Context, k8sClusterId string) ApiK8sKubeconfigGetRequest {
	return ApiK8sKubeconfigGetRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesConfig
 */
func (a *KubernetesApiService) K8sKubeconfigGetExecute(r ApiK8sKubeconfigGetRequest) (KubernetesConfig, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesConfig
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sKubeconfigGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/kubeconfig"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sKubeconfigGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsDeleteRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	nodepoolId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsDeleteRequest) Pretty(pretty bool) ApiK8sNodepoolsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsDeleteRequest) Depth(depth int32) ApiK8sNodepoolsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsDeleteRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsDeleteExecute(r)
}

/*
 * K8sNodepoolsDelete Delete Kubernetes Node Pool
 * This will remove a Kubernetes Node Pool.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @param nodepoolId The unique ID of the Kubernetes Node Pool
 * @return ApiK8sNodepoolsDeleteRequest
 */
func (a *KubernetesApiService) K8sNodepoolsDelete(ctx _context.Context, k8sClusterId string, nodepoolId string) ApiK8sNodepoolsDeleteRequest {
	return ApiK8sNodepoolsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
		nodepoolId: nodepoolId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *KubernetesApiService) K8sNodepoolsDeleteExecute(r ApiK8sNodepoolsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools/{nodepoolId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodepoolId"+"}", _neturl.PathEscape(parameterToString(r.nodepoolId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsFindByIdRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	nodepoolId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsFindByIdRequest) Pretty(pretty bool) ApiK8sNodepoolsFindByIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsFindByIdRequest) Depth(depth int32) ApiK8sNodepoolsFindByIdRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsFindByIdRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsFindByIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsFindByIdRequest) Execute() (KubernetesNodePool, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsFindByIdExecute(r)
}

/*
 * K8sNodepoolsFindById Retrieve Kubernetes Node Pool
 * You can retrieve a single Kubernetes Node Pool.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @param nodepoolId The unique ID of the Kubernetes Node Pool
 * @return ApiK8sNodepoolsFindByIdRequest
 */
func (a *KubernetesApiService) K8sNodepoolsFindById(ctx _context.Context, k8sClusterId string, nodepoolId string) ApiK8sNodepoolsFindByIdRequest {
	return ApiK8sNodepoolsFindByIdRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
		nodepoolId: nodepoolId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesNodePool
 */
func (a *KubernetesApiService) K8sNodepoolsFindByIdExecute(r ApiK8sNodepoolsFindByIdRequest) (KubernetesNodePool, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesNodePool
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsFindById")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools/{nodepoolId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodepoolId"+"}", _neturl.PathEscape(parameterToString(r.nodepoolId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsFindById",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsGetRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsGetRequest) Pretty(pretty bool) ApiK8sNodepoolsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsGetRequest) Depth(depth int32) ApiK8sNodepoolsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsGetRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsGetRequest) Execute() (KubernetesNodePools, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsGetExecute(r)
}

/*
 * K8sNodepoolsGet List Kubernetes Node Pools
 * You can retrieve a list of all kubernetes node pools part of kubernetes cluster
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @return ApiK8sNodepoolsGetRequest
 */
func (a *KubernetesApiService) K8sNodepoolsGet(ctx _context.Context, k8sClusterId string) ApiK8sNodepoolsGetRequest {
	return ApiK8sNodepoolsGetRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesNodePools
 */
func (a *KubernetesApiService) K8sNodepoolsGetExecute(r ApiK8sNodepoolsGetRequest) (KubernetesNodePools, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesNodePools
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsNodesDeleteRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	nodepoolId string
	nodeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsNodesDeleteRequest) Pretty(pretty bool) ApiK8sNodepoolsNodesDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsNodesDeleteRequest) Depth(depth int32) ApiK8sNodepoolsNodesDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsNodesDeleteRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsNodesDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsNodesDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsNodesDeleteExecute(r)
}

/*
 * K8sNodepoolsNodesDelete Delete Kubernetes node
 * This will remove a Kubernetes node.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @param nodepoolId The unique ID of the Kubernetes Node Pool
 * @param nodeId The unique ID of the Kubernetes node
 * @return ApiK8sNodepoolsNodesDeleteRequest
 */
func (a *KubernetesApiService) K8sNodepoolsNodesDelete(ctx _context.Context, k8sClusterId string, nodepoolId string, nodeId string) ApiK8sNodepoolsNodesDeleteRequest {
	return ApiK8sNodepoolsNodesDeleteRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
		nodepoolId: nodepoolId,
		nodeId: nodeId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *KubernetesApiService) K8sNodepoolsNodesDeleteExecute(r ApiK8sNodepoolsNodesDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsNodesDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools/{nodepoolId}/nodes/{nodeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodepoolId"+"}", _neturl.PathEscape(parameterToString(r.nodepoolId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodeId"+"}", _neturl.PathEscape(parameterToString(r.nodeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsNodesDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsNodesFindByIdRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	nodepoolId string
	nodeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsNodesFindByIdRequest) Pretty(pretty bool) ApiK8sNodepoolsNodesFindByIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsNodesFindByIdRequest) Depth(depth int32) ApiK8sNodepoolsNodesFindByIdRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsNodesFindByIdRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsNodesFindByIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsNodesFindByIdRequest) Execute() (KubernetesNode, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsNodesFindByIdExecute(r)
}

/*
 * K8sNodepoolsNodesFindById Retrieve Kubernetes node
 * You can retrieve a single Kubernetes Node.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @param nodepoolId The unique ID of the Kubernetes Node Pool
 * @param nodeId The unique ID of the Kubernetes Node.
 * @return ApiK8sNodepoolsNodesFindByIdRequest
 */
func (a *KubernetesApiService) K8sNodepoolsNodesFindById(ctx _context.Context, k8sClusterId string, nodepoolId string, nodeId string) ApiK8sNodepoolsNodesFindByIdRequest {
	return ApiK8sNodepoolsNodesFindByIdRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
		nodepoolId: nodepoolId,
		nodeId: nodeId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesNode
 */
func (a *KubernetesApiService) K8sNodepoolsNodesFindByIdExecute(r ApiK8sNodepoolsNodesFindByIdRequest) (KubernetesNode, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesNode
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsNodesFindById")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools/{nodepoolId}/nodes/{nodeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodepoolId"+"}", _neturl.PathEscape(parameterToString(r.nodepoolId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodeId"+"}", _neturl.PathEscape(parameterToString(r.nodeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsNodesFindById",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsNodesGetRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	nodepoolId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsNodesGetRequest) Pretty(pretty bool) ApiK8sNodepoolsNodesGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsNodesGetRequest) Depth(depth int32) ApiK8sNodepoolsNodesGetRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsNodesGetRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsNodesGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsNodesGetRequest) Execute() (KubernetesNodes, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsNodesGetExecute(r)
}

/*
 * K8sNodepoolsNodesGet Retrieve Kubernetes nodes.
 * You can retrieve all nodes of Kubernetes Node Pool.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @param nodepoolId The unique ID of the Kubernetes Node Pool
 * @return ApiK8sNodepoolsNodesGetRequest
 */
func (a *KubernetesApiService) K8sNodepoolsNodesGet(ctx _context.Context, k8sClusterId string, nodepoolId string) ApiK8sNodepoolsNodesGetRequest {
	return ApiK8sNodepoolsNodesGetRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
		nodepoolId: nodepoolId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesNodes
 */
func (a *KubernetesApiService) K8sNodepoolsNodesGetExecute(r ApiK8sNodepoolsNodesGetRequest) (KubernetesNodes, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesNodes
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsNodesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools/{nodepoolId}/nodes"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodepoolId"+"}", _neturl.PathEscape(parameterToString(r.nodepoolId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsNodesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsNodesReplacePostRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	nodepoolId string
	nodeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsNodesReplacePostRequest) Pretty(pretty bool) ApiK8sNodepoolsNodesReplacePostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsNodesReplacePostRequest) Depth(depth int32) ApiK8sNodepoolsNodesReplacePostRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsNodesReplacePostRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsNodesReplacePostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsNodesReplacePostRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsNodesReplacePostExecute(r)
}

/*
 * K8sNodepoolsNodesReplacePost Recreate the Kubernetes node
 * You can recreate a single Kubernetes Node.

Managed Kubernetes starts a process which based on the nodepool's template creates & configures a new node, waits for status "ACTIVE", and migrates all the pods from the faulty node, deleting it once empty. While this operation occurs, the nodepool will have an extra billable "ACTIVE" node.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @param nodepoolId The unique ID of the Kubernetes Node Pool
 * @param nodeId The unique ID of the Kubernetes Node.
 * @return ApiK8sNodepoolsNodesReplacePostRequest
 */
func (a *KubernetesApiService) K8sNodepoolsNodesReplacePost(ctx _context.Context, k8sClusterId string, nodepoolId string, nodeId string) ApiK8sNodepoolsNodesReplacePostRequest {
	return ApiK8sNodepoolsNodesReplacePostRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
		nodepoolId: nodepoolId,
		nodeId: nodeId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *KubernetesApiService) K8sNodepoolsNodesReplacePostExecute(r ApiK8sNodepoolsNodesReplacePostRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsNodesReplacePost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools/{nodepoolId}/nodes/{nodeId}/replace"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodepoolId"+"}", _neturl.PathEscape(parameterToString(r.nodepoolId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodeId"+"}", _neturl.PathEscape(parameterToString(r.nodeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsNodesReplacePost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsPostRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	kubernetesNodePool *KubernetesNodePool
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsPostRequest) KubernetesNodePool(kubernetesNodePool KubernetesNodePool) ApiK8sNodepoolsPostRequest {
	r.kubernetesNodePool = &kubernetesNodePool
	return r
}
func (r ApiK8sNodepoolsPostRequest) Pretty(pretty bool) ApiK8sNodepoolsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsPostRequest) Depth(depth int32) ApiK8sNodepoolsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsPostRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsPostRequest) Execute() (KubernetesNodePool, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsPostExecute(r)
}

/*
 * K8sNodepoolsPost Create a Kubernetes Node Pool
 * This will create a new Kubernetes Node Pool inside a Kubernetes Cluster.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @return ApiK8sNodepoolsPostRequest
 */
func (a *KubernetesApiService) K8sNodepoolsPost(ctx _context.Context, k8sClusterId string) ApiK8sNodepoolsPostRequest {
	return ApiK8sNodepoolsPostRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesNodePool
 */
func (a *KubernetesApiService) K8sNodepoolsPostExecute(r ApiK8sNodepoolsPostRequest) (KubernetesNodePool, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesNodePool
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.kubernetesNodePool == nil {
		return localVarReturnValue, nil, reportError("kubernetesNodePool is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.kubernetesNodePool
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sNodepoolsPutRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	nodepoolId string
	kubernetesNodePoolProperties *KubernetesNodePoolPropertiesForPut
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sNodepoolsPutRequest) KubernetesNodePoolProperties(kubernetesNodePoolProperties KubernetesNodePoolPropertiesForPut) ApiK8sNodepoolsPutRequest {
	r.kubernetesNodePoolProperties = &kubernetesNodePoolProperties
	return r
}
func (r ApiK8sNodepoolsPutRequest) Pretty(pretty bool) ApiK8sNodepoolsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sNodepoolsPutRequest) Depth(depth int32) ApiK8sNodepoolsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sNodepoolsPutRequest) XContractNumber(xContractNumber int32) ApiK8sNodepoolsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sNodepoolsPutRequest) Execute() (KubernetesNodePoolForPut, *APIResponse, error) {
	return r.ApiService.K8sNodepoolsPutExecute(r)
}

/*
 * K8sNodepoolsPut Modify Kubernetes Node Pool
 * This will modify the Kubernetes Node Pool.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @param nodepoolId The unique ID of the Kubernetes Node Pool
 * @return ApiK8sNodepoolsPutRequest
 */
func (a *KubernetesApiService) K8sNodepoolsPut(ctx _context.Context, k8sClusterId string, nodepoolId string) ApiK8sNodepoolsPutRequest {
	return ApiK8sNodepoolsPutRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
		nodepoolId: nodepoolId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesNodePoolForPut
 */
func (a *KubernetesApiService) K8sNodepoolsPutExecute(r ApiK8sNodepoolsPutRequest) (KubernetesNodePoolForPut, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesNodePoolForPut
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sNodepoolsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}/nodepools/{nodepoolId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nodepoolId"+"}", _neturl.PathEscape(parameterToString(r.nodepoolId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.kubernetesNodePoolProperties == nil {
		return localVarReturnValue, nil, reportError("kubernetesNodePoolProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = map[string]interface{}{"properties": r.kubernetesNodePoolProperties}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sNodepoolsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sPostRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	kubernetesCluster *KubernetesCluster
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sPostRequest) KubernetesCluster(kubernetesCluster KubernetesCluster) ApiK8sPostRequest {
	r.kubernetesCluster = &kubernetesCluster
	return r
}
func (r ApiK8sPostRequest) Pretty(pretty bool) ApiK8sPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sPostRequest) Depth(depth int32) ApiK8sPostRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sPostRequest) XContractNumber(xContractNumber int32) ApiK8sPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sPostRequest) Execute() (KubernetesCluster, *APIResponse, error) {
	return r.ApiService.K8sPostExecute(r)
}

/*
 * K8sPost Create Kubernetes Cluster
 * This will create a new Kubernetes Cluster.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiK8sPostRequest
 */
func (a *KubernetesApiService) K8sPost(ctx _context.Context) ApiK8sPostRequest {
	return ApiK8sPostRequest{
		ApiService: a,
		ctx: ctx,
	}
}

/*
 * Execute executes the request
 * @return KubernetesCluster
 */
func (a *KubernetesApiService) K8sPostExecute(r ApiK8sPostRequest) (KubernetesCluster, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesCluster
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.kubernetesCluster == nil {
		return localVarReturnValue, nil, reportError("kubernetesCluster is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.kubernetesCluster
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sPutRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	k8sClusterId string
	kubernetescluster *KubernetesCluster
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiK8sPutRequest) Kubernetescluster(kubernetescluster KubernetesCluster) ApiK8sPutRequest {
	r.kubernetescluster = &kubernetescluster
	return r
}
func (r ApiK8sPutRequest) Pretty(pretty bool) ApiK8sPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiK8sPutRequest) Depth(depth int32) ApiK8sPutRequest {
	r.depth = &depth
	return r
}
func (r ApiK8sPutRequest) XContractNumber(xContractNumber int32) ApiK8sPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiK8sPutRequest) Execute() (KubernetesCluster, *APIResponse, error) {
	return r.ApiService.K8sPutExecute(r)
}

/*
 * K8sPut Modify Kubernetes Cluster
 * This will modify the Kubernetes Cluster.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param k8sClusterId The unique ID of the Kubernetes Cluster
 * @return ApiK8sPutRequest
 */
func (a *KubernetesApiService) K8sPut(ctx _context.Context, k8sClusterId string) ApiK8sPutRequest {
	return ApiK8sPutRequest{
		ApiService: a,
		ctx: ctx,
		k8sClusterId: k8sClusterId,
	}
}

/*
 * Execute executes the request
 * @return KubernetesCluster
 */
func (a *KubernetesApiService) K8sPutExecute(r ApiK8sPutRequest) (KubernetesCluster, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  KubernetesCluster
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/{k8sClusterId}"
	localVarPath = strings.Replace(localVarPath, "{"+"k8sClusterId"+"}", _neturl.PathEscape(parameterToString(r.k8sClusterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.kubernetescluster == nil {
		return localVarReturnValue, nil, reportError("kubernetescluster is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.kubernetescluster
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sVersionsCompatibilitiesGetRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
	clusterVersion string
}


func (r ApiK8sVersionsCompatibilitiesGetRequest) Execute() ([]string, *APIResponse, error) {
	return r.ApiService.K8sVersionsCompatibilitiesGetExecute(r)
}

/*
 * K8sVersionsCompatibilitiesGet Retrieves a list of available kubernetes versions for nodepools depending on the given kubernetes version running in the cluster.
 * You can retrieve a list of available kubernetes versions for nodepools depending on the given kubernetes version running in the cluster.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param clusterVersion
 * @return ApiK8sVersionsCompatibilitiesGetRequest
 */
func (a *KubernetesApiService) K8sVersionsCompatibilitiesGet(ctx _context.Context, clusterVersion string) ApiK8sVersionsCompatibilitiesGetRequest {
	return ApiK8sVersionsCompatibilitiesGetRequest{
		ApiService: a,
		ctx: ctx,
		clusterVersion: clusterVersion,
	}
}

/*
 * Execute executes the request
 * @return []string
 */
func (a *KubernetesApiService) K8sVersionsCompatibilitiesGetExecute(r ApiK8sVersionsCompatibilitiesGetRequest) ([]string, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  []string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sVersionsCompatibilitiesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/versions/{clusterVersion}/compatibilities"
	localVarPath = strings.Replace(localVarPath, "{"+"clusterVersion"+"}", _neturl.PathEscape(parameterToString(r.clusterVersion, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sVersionsCompatibilitiesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sVersionsDefaultGetRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
}


func (r ApiK8sVersionsDefaultGetRequest) Execute() (string, *APIResponse, error) {
	return r.ApiService.K8sVersionsDefaultGetExecute(r)
}

/*
 * K8sVersionsDefaultGet Retrieve the current default kubernetes version for clusters and nodepools.
 * You can retrieve the current default kubernetes version for clusters and nodepools.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiK8sVersionsDefaultGetRequest
 */
func (a *KubernetesApiService) K8sVersionsDefaultGet(ctx _context.Context) ApiK8sVersionsDefaultGetRequest {
	return ApiK8sVersionsDefaultGetRequest{
		ApiService: a,
		ctx: ctx,
	}
}

/*
 * Execute executes the request
 * @return string
 */
func (a *KubernetesApiService) K8sVersionsDefaultGetExecute(r ApiK8sVersionsDefaultGetRequest) (string, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sVersionsDefaultGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/versions/default"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sVersionsDefaultGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiK8sVersionsGetRequest struct {
	ctx _context.Context
	ApiService *KubernetesApiService
}


func (r ApiK8sVersionsGetRequest) Execute() ([]string, *APIResponse, error) {
	return r.ApiService.K8sVersionsGetExecute(r)
}

/*
 * K8sVersionsGet Retrieve available Kubernetes versions
 * You can retrieve a list of available kubernetes versions
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiK8sVersionsGetRequest
 */
func (a *KubernetesApiService) K8sVersionsGet(ctx _context.Context) ApiK8sVersionsGetRequest {
	return ApiK8sVersionsGetRequest{
		ApiService: a,
		ctx: ctx,
	}
}

/*
 * Execute executes the request
 * @return []string
 */
func (a *KubernetesApiService) K8sVersionsGetExecute(r ApiK8sVersionsGetRequest) ([]string, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  []string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "KubernetesApiService.K8sVersionsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/k8s/versions"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "K8sVersionsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
