/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// GroupProperties struct for GroupProperties
type GroupProperties struct {
	// A name of that resource
	Name *string `json:"name,omitempty"`
	// create data center privilege
	CreateDataCenter *bool `json:"createDataCenter,omitempty"`
	// create snapshot privilege
	CreateSnapshot *bool `json:"createSnapshot,omitempty"`
	// reserve ip block privilege
	ReserveIp *bool `json:"reserveIp,omitempty"`
	// activity log access privilege
	AccessActivityLog *bool `json:"accessActivityLog,omitempty"`
	// create pcc privilege
	CreatePcc *bool `json:"createPcc,omitempty"`
	// S3 privilege
	S3Privilege *bool `json:"s3Privilege,omitempty"`
	// create backup unit privilege
	CreateBackupUnit *bool `json:"createBackupUnit,omitempty"`
	// create internet access privilege
	CreateInternetAccess *bool `json:"createInternetAccess,omitempty"`
	// create kubernetes cluster privilege
	CreateK8sCluster *bool `json:"createK8sCluster,omitempty"`
}



// GetName returns the Name field value
// If the value is explicit nil, the zero value for string will be returned
func (o *GroupProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Name, true
}

// SetName sets field value
func (o *GroupProperties) SetName(v string) {
	o.Name = &v
}

// HasName returns a boolean if a field has been set.
func (o *GroupProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}



// GetCreateDataCenter returns the CreateDataCenter field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetCreateDataCenter() *bool {
	if o == nil {
		return nil
	}

	return o.CreateDataCenter
}

// GetCreateDataCenterOk returns a tuple with the CreateDataCenter field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetCreateDataCenterOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CreateDataCenter, true
}

// SetCreateDataCenter sets field value
func (o *GroupProperties) SetCreateDataCenter(v bool) {
	o.CreateDataCenter = &v
}

// HasCreateDataCenter returns a boolean if a field has been set.
func (o *GroupProperties) HasCreateDataCenter() bool {
	if o != nil && o.CreateDataCenter != nil {
		return true
	}

	return false
}



// GetCreateSnapshot returns the CreateSnapshot field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetCreateSnapshot() *bool {
	if o == nil {
		return nil
	}

	return o.CreateSnapshot
}

// GetCreateSnapshotOk returns a tuple with the CreateSnapshot field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetCreateSnapshotOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CreateSnapshot, true
}

// SetCreateSnapshot sets field value
func (o *GroupProperties) SetCreateSnapshot(v bool) {
	o.CreateSnapshot = &v
}

// HasCreateSnapshot returns a boolean if a field has been set.
func (o *GroupProperties) HasCreateSnapshot() bool {
	if o != nil && o.CreateSnapshot != nil {
		return true
	}

	return false
}



// GetReserveIp returns the ReserveIp field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetReserveIp() *bool {
	if o == nil {
		return nil
	}

	return o.ReserveIp
}

// GetReserveIpOk returns a tuple with the ReserveIp field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetReserveIpOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.ReserveIp, true
}

// SetReserveIp sets field value
func (o *GroupProperties) SetReserveIp(v bool) {
	o.ReserveIp = &v
}

// HasReserveIp returns a boolean if a field has been set.
func (o *GroupProperties) HasReserveIp() bool {
	if o != nil && o.ReserveIp != nil {
		return true
	}

	return false
}



// GetAccessActivityLog returns the AccessActivityLog field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetAccessActivityLog() *bool {
	if o == nil {
		return nil
	}

	return o.AccessActivityLog
}

// GetAccessActivityLogOk returns a tuple with the AccessActivityLog field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetAccessActivityLogOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.AccessActivityLog, true
}

// SetAccessActivityLog sets field value
func (o *GroupProperties) SetAccessActivityLog(v bool) {
	o.AccessActivityLog = &v
}

// HasAccessActivityLog returns a boolean if a field has been set.
func (o *GroupProperties) HasAccessActivityLog() bool {
	if o != nil && o.AccessActivityLog != nil {
		return true
	}

	return false
}



// GetCreatePcc returns the CreatePcc field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetCreatePcc() *bool {
	if o == nil {
		return nil
	}

	return o.CreatePcc
}

// GetCreatePccOk returns a tuple with the CreatePcc field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetCreatePccOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CreatePcc, true
}

// SetCreatePcc sets field value
func (o *GroupProperties) SetCreatePcc(v bool) {
	o.CreatePcc = &v
}

// HasCreatePcc returns a boolean if a field has been set.
func (o *GroupProperties) HasCreatePcc() bool {
	if o != nil && o.CreatePcc != nil {
		return true
	}

	return false
}



// GetS3Privilege returns the S3Privilege field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetS3Privilege() *bool {
	if o == nil {
		return nil
	}

	return o.S3Privilege
}

// GetS3PrivilegeOk returns a tuple with the S3Privilege field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetS3PrivilegeOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.S3Privilege, true
}

// SetS3Privilege sets field value
func (o *GroupProperties) SetS3Privilege(v bool) {
	o.S3Privilege = &v
}

// HasS3Privilege returns a boolean if a field has been set.
func (o *GroupProperties) HasS3Privilege() bool {
	if o != nil && o.S3Privilege != nil {
		return true
	}

	return false
}



// GetCreateBackupUnit returns the CreateBackupUnit field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetCreateBackupUnit() *bool {
	if o == nil {
		return nil
	}

	return o.CreateBackupUnit
}

// GetCreateBackupUnitOk returns a tuple with the CreateBackupUnit field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetCreateBackupUnitOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CreateBackupUnit, true
}

// SetCreateBackupUnit sets field value
func (o *GroupProperties) SetCreateBackupUnit(v bool) {
	o.CreateBackupUnit = &v
}

// HasCreateBackupUnit returns a boolean if a field has been set.
func (o *GroupProperties) HasCreateBackupUnit() bool {
	if o != nil && o.CreateBackupUnit != nil {
		return true
	}

	return false
}



// GetCreateInternetAccess returns the CreateInternetAccess field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetCreateInternetAccess() *bool {
	if o == nil {
		return nil
	}

	return o.CreateInternetAccess
}

// GetCreateInternetAccessOk returns a tuple with the CreateInternetAccess field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetCreateInternetAccessOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CreateInternetAccess, true
}

// SetCreateInternetAccess sets field value
func (o *GroupProperties) SetCreateInternetAccess(v bool) {
	o.CreateInternetAccess = &v
}

// HasCreateInternetAccess returns a boolean if a field has been set.
func (o *GroupProperties) HasCreateInternetAccess() bool {
	if o != nil && o.CreateInternetAccess != nil {
		return true
	}

	return false
}



// GetCreateK8sCluster returns the CreateK8sCluster field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *GroupProperties) GetCreateK8sCluster() *bool {
	if o == nil {
		return nil
	}

	return o.CreateK8sCluster
}

// GetCreateK8sClusterOk returns a tuple with the CreateK8sCluster field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *GroupProperties) GetCreateK8sClusterOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CreateK8sCluster, true
}

// SetCreateK8sCluster sets field value
func (o *GroupProperties) SetCreateK8sCluster(v bool) {
	o.CreateK8sCluster = &v
}

// HasCreateK8sCluster returns a boolean if a field has been set.
func (o *GroupProperties) HasCreateK8sCluster() bool {
	if o != nil && o.CreateK8sCluster != nil {
		return true
	}

	return false
}


func (o GroupProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	

	if o.CreateDataCenter != nil {
		toSerialize["createDataCenter"] = o.CreateDataCenter
	}
	

	if o.CreateSnapshot != nil {
		toSerialize["createSnapshot"] = o.CreateSnapshot
	}
	

	if o.ReserveIp != nil {
		toSerialize["reserveIp"] = o.ReserveIp
	}
	

	if o.AccessActivityLog != nil {
		toSerialize["accessActivityLog"] = o.AccessActivityLog
	}
	

	if o.CreatePcc != nil {
		toSerialize["createPcc"] = o.CreatePcc
	}
	

	if o.S3Privilege != nil {
		toSerialize["s3Privilege"] = o.S3Privilege
	}
	

	if o.CreateBackupUnit != nil {
		toSerialize["createBackupUnit"] = o.CreateBackupUnit
	}
	

	if o.CreateInternetAccess != nil {
		toSerialize["createInternetAccess"] = o.CreateInternetAccess
	}
	

	if o.CreateK8sCluster != nil {
		toSerialize["createK8sCluster"] = o.CreateK8sCluster
	}
	
	return json.Marshal(toSerialize)
}

type NullableGroupProperties struct {
	value *GroupProperties
	isSet bool
}

func (v NullableGroupProperties) Get() *GroupProperties {
	return v.value
}

func (v *NullableGroupProperties) Set(val *GroupProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableGroupProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableGroupProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGroupProperties(val *GroupProperties) *NullableGroupProperties {
	return &NullableGroupProperties{value: val, isSet: true}
}

func (v NullableGroupProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGroupProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


