/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// ConnectableDatacenter struct for ConnectableDatacenter
type ConnectableDatacenter struct {
	Id *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Location *string `json:"location,omitempty"`
}



// GetId returns the Id field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ConnectableDatacenter) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ConnectableDatacenter) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Id, true
}

// SetId sets field value
func (o *ConnectableDatacenter) SetId(v string) {
	o.Id = &v
}

// HasId returns a boolean if a field has been set.
func (o *ConnectableDatacenter) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}



// GetName returns the Name field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ConnectableDatacenter) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ConnectableDatacenter) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Name, true
}

// SetName sets field value
func (o *ConnectableDatacenter) SetName(v string) {
	o.Name = &v
}

// HasName returns a boolean if a field has been set.
func (o *ConnectableDatacenter) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}



// GetLocation returns the Location field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ConnectableDatacenter) GetLocation() *string {
	if o == nil {
		return nil
	}

	return o.Location
}

// GetLocationOk returns a tuple with the Location field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ConnectableDatacenter) GetLocationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Location, true
}

// SetLocation sets field value
func (o *ConnectableDatacenter) SetLocation(v string) {
	o.Location = &v
}

// HasLocation returns a boolean if a field has been set.
func (o *ConnectableDatacenter) HasLocation() bool {
	if o != nil && o.Location != nil {
		return true
	}

	return false
}


func (o ConnectableDatacenter) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	

	if o.Location != nil {
		toSerialize["location"] = o.Location
	}
	
	return json.Marshal(toSerialize)
}

type NullableConnectableDatacenter struct {
	value *ConnectableDatacenter
	isSet bool
}

func (v NullableConnectableDatacenter) Get() *ConnectableDatacenter {
	return v.value
}

func (v *NullableConnectableDatacenter) Set(val *ConnectableDatacenter) {
	v.value = val
	v.isSet = true
}

func (v NullableConnectableDatacenter) IsSet() bool {
	return v.isSet
}

func (v *NullableConnectableDatacenter) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableConnectableDatacenter(val *ConnectableDatacenter) *NullableConnectableDatacenter {
	return &NullableConnectableDatacenter{value: val, isSet: true}
}

func (v NullableConnectableDatacenter) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableConnectableDatacenter) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


