/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: summary.proto

package summary

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DashboardTabSummary_TabStatus int32

const (
	DashboardTabSummary_NOT_SET DashboardTabSummary_TabStatus = 0
	DashboardTabSummary_UNKNOWN DashboardTabSummary_TabStatus = 1
	DashboardTabSummary_PASS    DashboardTabSummary_TabStatus = 2
	DashboardTabSummary_FAIL    DashboardTabSummary_TabStatus = 3
	DashboardTabSummary_FLAKY   DashboardTabSummary_TabStatus = 4
	DashboardTabSummary_STALE   DashboardTabSummary_TabStatus = 5
)

var DashboardTabSummary_TabStatus_name = map[int32]string{
	0: "NOT_SET",
	1: "UNKNOWN",
	2: "PASS",
	3: "FAIL",
	4: "FLAKY",
	5: "STALE",
}

var DashboardTabSummary_TabStatus_value = map[string]int32{
	"NOT_SET": 0,
	"UNKNOWN": 1,
	"PASS":    2,
	"FAIL":    3,
	"FLAKY":   4,
	"STALE":   5,
}

func (x DashboardTabSummary_TabStatus) String() string {
	return proto.EnumName(DashboardTabSummary_TabStatus_name, int32(x))
}

func (DashboardTabSummary_TabStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f7168d0e3f3f5589, []int{1, 0}
}

// Summary of a failing test.
type FailingTestSummary struct {
	// Display name of the test.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Name of the test. E.g., the target for tests in Sponge.
	TestName string `protobuf:"bytes,2,opt,name=test_name,json=testName,proto3" json:"test_name,omitempty"`
	// First build ID at which the test failed.
	FailBuildId string `protobuf:"bytes,3,opt,name=fail_build_id,json=failBuildId,proto3" json:"fail_build_id,omitempty"`
	// Timestamp for the first cycle in which the test failed.
	FailTimestamp float64 `protobuf:"fixed64,4,opt,name=fail_timestamp,json=failTimestamp,proto3" json:"fail_timestamp,omitempty"`
	// Last build ID at which the test passed.
	PassBuildId string `protobuf:"bytes,5,opt,name=pass_build_id,json=passBuildId,proto3" json:"pass_build_id,omitempty"`
	// Timestamp for the last cycle in which the test passed.
	PassTimestamp float64 `protobuf:"fixed64,6,opt,name=pass_timestamp,json=passTimestamp,proto3" json:"pass_timestamp,omitempty"`
	// Number of times the test has failed.
	FailCount int32 `protobuf:"varint,7,opt,name=fail_count,json=failCount,proto3" json:"fail_count,omitempty"`
	// Link to search for build changes.
	BuildLink string `protobuf:"bytes,8,opt,name=build_link,json=buildLink,proto3" json:"build_link,omitempty"`
	// Text for option to search for build changes.
	BuildLinkText string `protobuf:"bytes,9,opt,name=build_link_text,json=buildLinkText,proto3" json:"build_link_text,omitempty"`
	// Text to display for link to search for build changes.
	BuildUrlText string `protobuf:"bytes,10,opt,name=build_url_text,json=buildUrlText,proto3" json:"build_url_text,omitempty"`
	// Text for failure statuses associated with this test.
	FailureMessage string `protobuf:"bytes,11,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
	// List of bug IDs for bugs associated with this test.
	LinkedBugs []string `protobuf:"bytes,12,rep,name=linked_bugs,json=linkedBugs,proto3" json:"linked_bugs,omitempty"`
	// A link to the first build in which the test failed.
	FailTestLink         string   `protobuf:"bytes,13,opt,name=fail_test_link,json=failTestLink,proto3" json:"fail_test_link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FailingTestSummary) Reset()         { *m = FailingTestSummary{} }
func (m *FailingTestSummary) String() string { return proto.CompactTextString(m) }
func (*FailingTestSummary) ProtoMessage()    {}
func (*FailingTestSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_f7168d0e3f3f5589, []int{0}
}

func (m *FailingTestSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailingTestSummary.Unmarshal(m, b)
}
func (m *FailingTestSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailingTestSummary.Marshal(b, m, deterministic)
}
func (m *FailingTestSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailingTestSummary.Merge(m, src)
}
func (m *FailingTestSummary) XXX_Size() int {
	return xxx_messageInfo_FailingTestSummary.Size(m)
}
func (m *FailingTestSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_FailingTestSummary.DiscardUnknown(m)
}

var xxx_messageInfo_FailingTestSummary proto.InternalMessageInfo

func (m *FailingTestSummary) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *FailingTestSummary) GetTestName() string {
	if m != nil {
		return m.TestName
	}
	return ""
}

func (m *FailingTestSummary) GetFailBuildId() string {
	if m != nil {
		return m.FailBuildId
	}
	return ""
}

func (m *FailingTestSummary) GetFailTimestamp() float64 {
	if m != nil {
		return m.FailTimestamp
	}
	return 0
}

func (m *FailingTestSummary) GetPassBuildId() string {
	if m != nil {
		return m.PassBuildId
	}
	return ""
}

func (m *FailingTestSummary) GetPassTimestamp() float64 {
	if m != nil {
		return m.PassTimestamp
	}
	return 0
}

func (m *FailingTestSummary) GetFailCount() int32 {
	if m != nil {
		return m.FailCount
	}
	return 0
}

func (m *FailingTestSummary) GetBuildLink() string {
	if m != nil {
		return m.BuildLink
	}
	return ""
}

func (m *FailingTestSummary) GetBuildLinkText() string {
	if m != nil {
		return m.BuildLinkText
	}
	return ""
}

func (m *FailingTestSummary) GetBuildUrlText() string {
	if m != nil {
		return m.BuildUrlText
	}
	return ""
}

func (m *FailingTestSummary) GetFailureMessage() string {
	if m != nil {
		return m.FailureMessage
	}
	return ""
}

func (m *FailingTestSummary) GetLinkedBugs() []string {
	if m != nil {
		return m.LinkedBugs
	}
	return nil
}

func (m *FailingTestSummary) GetFailTestLink() string {
	if m != nil {
		return m.FailTestLink
	}
	return ""
}

// Summary of a dashboard tab.
type DashboardTabSummary struct {
	// The name of the dashboard.
	DashboardName string `protobuf:"bytes,1,opt,name=dashboard_name,json=dashboardName,proto3" json:"dashboard_name,omitempty"`
	// The name of the dashboard tab.
	DashboardTabName string `protobuf:"bytes,2,opt,name=dashboard_tab_name,json=dashboardTabName,proto3" json:"dashboard_tab_name,omitempty"`
	// Any top-level alert on this dashboard tab.
	Alert string `protobuf:"bytes,3,opt,name=alert,proto3" json:"alert,omitempty"`
	// List of failing test summary information.
	FailingTestSummaries []*FailingTestSummary `protobuf:"bytes,4,rep,name=failing_test_summaries,json=failingTestSummaries,proto3" json:"failing_test_summaries,omitempty"`
	// Seconds since epoch at which the test group was last updated.
	LastUpdateTimestamp float64 `protobuf:"fixed64,5,opt,name=last_update_timestamp,json=lastUpdateTimestamp,proto3" json:"last_update_timestamp,omitempty"`
	// A summary of the status of this dashboard tab.
	Status string `protobuf:"bytes,6,opt,name=status,proto3" json:"status,omitempty"`
	// The overall status for this dashboard tab.
	OverallStatus DashboardTabSummary_TabStatus `protobuf:"varint,7,opt,name=overall_status,json=overallStatus,proto3,enum=DashboardTabSummary_TabStatus" json:"overall_status,omitempty"`
	// The ID for the latest passing build.
	LatestGreen string `protobuf:"bytes,8,opt,name=latest_green,json=latestGreen,proto3" json:"latest_green,omitempty"`
	// Seconds since epoch at which tests last ran.
	LastRunTimestamp float64 `protobuf:"fixed64,9,opt,name=last_run_timestamp,json=lastRunTimestamp,proto3" json:"last_run_timestamp,omitempty"`
	// String indicating the URL for linking to a bug.
	BugUrl               string   `protobuf:"bytes,10,opt,name=bug_url,json=bugUrl,proto3" json:"bug_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DashboardTabSummary) Reset()         { *m = DashboardTabSummary{} }
func (m *DashboardTabSummary) String() string { return proto.CompactTextString(m) }
func (*DashboardTabSummary) ProtoMessage()    {}
func (*DashboardTabSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_f7168d0e3f3f5589, []int{1}
}

func (m *DashboardTabSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTabSummary.Unmarshal(m, b)
}
func (m *DashboardTabSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTabSummary.Marshal(b, m, deterministic)
}
func (m *DashboardTabSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTabSummary.Merge(m, src)
}
func (m *DashboardTabSummary) XXX_Size() int {
	return xxx_messageInfo_DashboardTabSummary.Size(m)
}
func (m *DashboardTabSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTabSummary.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTabSummary proto.InternalMessageInfo

func (m *DashboardTabSummary) GetDashboardName() string {
	if m != nil {
		return m.DashboardName
	}
	return ""
}

func (m *DashboardTabSummary) GetDashboardTabName() string {
	if m != nil {
		return m.DashboardTabName
	}
	return ""
}

func (m *DashboardTabSummary) GetAlert() string {
	if m != nil {
		return m.Alert
	}
	return ""
}

func (m *DashboardTabSummary) GetFailingTestSummaries() []*FailingTestSummary {
	if m != nil {
		return m.FailingTestSummaries
	}
	return nil
}

func (m *DashboardTabSummary) GetLastUpdateTimestamp() float64 {
	if m != nil {
		return m.LastUpdateTimestamp
	}
	return 0
}

func (m *DashboardTabSummary) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DashboardTabSummary) GetOverallStatus() DashboardTabSummary_TabStatus {
	if m != nil {
		return m.OverallStatus
	}
	return DashboardTabSummary_NOT_SET
}

func (m *DashboardTabSummary) GetLatestGreen() string {
	if m != nil {
		return m.LatestGreen
	}
	return ""
}

func (m *DashboardTabSummary) GetLastRunTimestamp() float64 {
	if m != nil {
		return m.LastRunTimestamp
	}
	return 0
}

func (m *DashboardTabSummary) GetBugUrl() string {
	if m != nil {
		return m.BugUrl
	}
	return ""
}

// Summary state of a dashboard.
type DashboardSummary struct {
	// Summary of a dashboard tab; see config.proto.
	TabSummaries         []*DashboardTabSummary `protobuf:"bytes,1,rep,name=tab_summaries,json=tabSummaries,proto3" json:"tab_summaries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *DashboardSummary) Reset()         { *m = DashboardSummary{} }
func (m *DashboardSummary) String() string { return proto.CompactTextString(m) }
func (*DashboardSummary) ProtoMessage()    {}
func (*DashboardSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_f7168d0e3f3f5589, []int{2}
}

func (m *DashboardSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardSummary.Unmarshal(m, b)
}
func (m *DashboardSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardSummary.Marshal(b, m, deterministic)
}
func (m *DashboardSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardSummary.Merge(m, src)
}
func (m *DashboardSummary) XXX_Size() int {
	return xxx_messageInfo_DashboardSummary.Size(m)
}
func (m *DashboardSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardSummary.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardSummary proto.InternalMessageInfo

func (m *DashboardSummary) GetTabSummaries() []*DashboardTabSummary {
	if m != nil {
		return m.TabSummaries
	}
	return nil
}

func init() {
	proto.RegisterEnum("DashboardTabSummary_TabStatus", DashboardTabSummary_TabStatus_name, DashboardTabSummary_TabStatus_value)
	proto.RegisterType((*FailingTestSummary)(nil), "FailingTestSummary")
	proto.RegisterType((*DashboardTabSummary)(nil), "DashboardTabSummary")
	proto.RegisterType((*DashboardSummary)(nil), "DashboardSummary")
}

func init() { proto.RegisterFile("summary.proto", fileDescriptor_f7168d0e3f3f5589) }

var fileDescriptor_f7168d0e3f3f5589 = []byte{
	// 610 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x94, 0xdf, 0x6e, 0xd3, 0x4a,
	0x10, 0xc6, 0x8f, 0x9b, 0x3f, 0xad, 0x27, 0x71, 0x6a, 0x6d, 0x7b, 0x7a, 0x2c, 0x1d, 0x01, 0x21,
	0xa2, 0x90, 0x0b, 0x94, 0x8b, 0x72, 0xc5, 0x65, 0x0a, 0x2d, 0xaa, 0x9a, 0xa6, 0xc8, 0x71, 0x84,
	0xb8, 0xb2, 0xd6, 0x78, 0x6b, 0xac, 0xae, 0x9d, 0xc8, 0xbb, 0x8b, 0xda, 0x47, 0xe1, 0x05, 0x79,
	0x0e, 0x34, 0xb3, 0x4e, 0x1c, 0x41, 0xef, 0x76, 0x7f, 0xf3, 0x79, 0x66, 0x76, 0xbe, 0x49, 0xc0,
	0x53, 0xa6, 0x28, 0x78, 0xf5, 0x38, 0x59, 0x57, 0x2b, 0xbd, 0x1a, 0xfd, 0x6a, 0x01, 0xbb, 0xe4,
	0xb9, 0xcc, 0xcb, 0x2c, 0x12, 0x4a, 0x2f, 0x6c, 0x90, 0xbd, 0x84, 0x7e, 0x9a, 0xab, 0xb5, 0xe4,
	0x8f, 0x71, 0xc9, 0x0b, 0x11, 0x38, 0x43, 0x67, 0xec, 0x86, 0xbd, 0x9a, 0xcd, 0x79, 0x21, 0xd8,
	0xff, 0xe0, 0x6a, 0xa1, 0xb4, 0x8d, 0xef, 0x51, 0xfc, 0x00, 0x01, 0x05, 0x47, 0xe0, 0xdd, 0xf1,
	0x5c, 0xc6, 0x89, 0xc9, 0x65, 0x1a, 0xe7, 0x69, 0xd0, 0xb2, 0x09, 0x10, 0x9e, 0x23, 0xbb, 0x4a,
	0xd9, 0x29, 0x0c, 0x48, 0xa3, 0xf3, 0x42, 0x28, 0xcd, 0x8b, 0x75, 0xd0, 0x1e, 0x3a, 0x63, 0x27,
	0xa4, 0x2f, 0xa3, 0x0d, 0xc4, 0x54, 0x6b, 0xae, 0x54, 0x93, 0xaa, 0x63, 0x53, 0x21, 0xdc, 0x49,
	0x45, 0x9a, 0x26, 0x55, 0xd7, 0xa6, 0x42, 0xda, 0xa4, 0x7a, 0x06, 0x40, 0x15, 0xbf, 0xad, 0x4c,
	0xa9, 0x83, 0xfd, 0xa1, 0x33, 0xee, 0x84, 0x2e, 0x92, 0x0f, 0x08, 0x30, 0x6c, 0x8b, 0xc8, 0xbc,
	0xbc, 0x0f, 0x0e, 0xa8, 0x8c, 0x4b, 0x64, 0x96, 0x97, 0xf7, 0xec, 0x35, 0x1c, 0x36, 0xe1, 0x58,
	0x8b, 0x07, 0x1d, 0xb8, 0xa4, 0xf1, 0xb6, 0x9a, 0x48, 0x3c, 0x68, 0xf6, 0x0a, 0x06, 0x56, 0x67,
	0x2a, 0x69, 0x65, 0x40, 0xb2, 0x3e, 0xd1, 0x65, 0x25, 0x49, 0xf5, 0x06, 0x0e, 0xb1, 0xb2, 0xa9,
	0x44, 0x5c, 0x08, 0xa5, 0x78, 0x26, 0x82, 0x1e, 0xc9, 0x06, 0x35, 0xbe, 0xb1, 0x94, 0xbd, 0x80,
	0x1e, 0x16, 0x14, 0x69, 0x9c, 0x98, 0x4c, 0x05, 0xfd, 0x61, 0x6b, 0xec, 0x86, 0x60, 0xd1, 0xb9,
	0xc9, 0x14, 0xd6, 0xb3, 0x73, 0x44, 0x37, 0xa8, 0x75, 0xcf, 0xd6, 0xa3, 0x39, 0x0a, 0xa5, 0xb1,
	0xb3, 0xd1, 0xcf, 0x36, 0x1c, 0x7d, 0xe4, 0xea, 0x7b, 0xb2, 0xe2, 0x55, 0x1a, 0xf1, 0x64, 0xe3,
	0xf4, 0x29, 0x0c, 0xd2, 0x0d, 0xde, 0xf5, 0xda, 0xdb, 0x52, 0x32, 0xf4, 0x2d, 0xb0, 0x46, 0xa6,
	0x79, 0xb2, 0x6b, 0xbb, 0x9f, 0xee, 0xe4, 0x25, 0xf5, 0x31, 0x74, 0xb8, 0x14, 0x95, 0xae, 0x6d,
	0xb7, 0x17, 0x76, 0x05, 0x27, 0x77, 0x76, 0xd5, 0x6c, 0xaf, 0x76, 0x13, 0x73, 0xa1, 0x82, 0xf6,
	0xb0, 0x35, 0xee, 0x9d, 0x1d, 0x4d, 0xfe, 0xde, 0xc4, 0xf0, 0xf8, 0xee, 0x4f, 0x96, 0x0b, 0xc5,
	0xce, 0xe0, 0x5f, 0xc9, 0x95, 0x8e, 0xcd, 0x3a, 0xe5, 0x5a, 0xec, 0xf8, 0xde, 0x21, 0xdf, 0x8f,
	0x30, 0xb8, 0xa4, 0x58, 0xe3, 0xfe, 0x09, 0x74, 0x95, 0xe6, 0xda, 0x28, 0x5a, 0x0e, 0x37, 0xac,
	0x6f, 0xec, 0x02, 0x06, 0xab, 0x1f, 0xa2, 0xe2, 0x52, 0xc6, 0x75, 0x1c, 0x37, 0x63, 0x70, 0xf6,
	0x7c, 0xf2, 0xc4, 0xbc, 0x26, 0x78, 0x24, 0x55, 0xe8, 0xd5, 0x5f, 0xd9, 0x2b, 0xfe, 0x64, 0x24,
	0xa7, 0x77, 0x65, 0x95, 0x10, 0x65, 0xbd, 0x3f, 0x3d, 0xcb, 0x3e, 0x21, 0xc2, 0x21, 0x52, 0xd7,
	0x95, 0x29, 0x77, 0x5a, 0x76, 0xa9, 0x65, 0x1f, 0x23, 0xa1, 0x29, 0x9b, 0x7e, 0xff, 0x83, 0xfd,
	0xc4, 0x64, 0xb8, 0x45, 0xf5, 0x02, 0x75, 0x13, 0x93, 0x2d, 0x2b, 0x39, 0xba, 0x05, 0x77, 0xdb,
	0x05, 0xeb, 0xc1, 0xfe, 0xfc, 0x36, 0x8a, 0x17, 0x17, 0x91, 0xff, 0x0f, 0x5e, 0x96, 0xf3, 0xeb,
	0xf9, 0xed, 0x97, 0xb9, 0xef, 0xb0, 0x03, 0x68, 0x7f, 0x9e, 0x2e, 0x16, 0xfe, 0x1e, 0x9e, 0x2e,
	0xa7, 0x57, 0x33, 0xbf, 0xc5, 0x5c, 0xe8, 0x5c, 0xce, 0xa6, 0xd7, 0x5f, 0xfd, 0x36, 0x1e, 0x17,
	0xd1, 0x74, 0x76, 0xe1, 0x77, 0x46, 0x37, 0xe0, 0x6f, 0x9f, 0xba, 0xd9, 0x8b, 0xf7, 0xe0, 0xa1,
	0xcd, 0x8d, 0x47, 0x0e, 0x79, 0x74, 0xfc, 0xd4, 0x50, 0xc2, 0xbe, 0xde, 0x9c, 0x73, 0xa1, 0x92,
	0x2e, 0xfd, 0xb5, 0xbc, 0xfb, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xd7, 0x49, 0xcd, 0xf5, 0x6b, 0x04,
	0x00, 0x00,
}
