// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mesos.proto

/*
	Package mesos is a generated protocol buffer package.

	It is generated from these files:
		mesos.proto

	It has these top-level messages:
		FrameworkID
		OfferID
		AgentID
		TaskID
		ExecutorID
		ContainerID
		ResourceProviderID
		OperationID
		TimeInfo
		DurationInfo
		Address
		URL
		Unavailability
		MachineID
		MachineInfo
		FrameworkInfo
		CheckInfo
		HealthCheck
		KillPolicy
		CommandInfo
		ExecutorInfo
		DomainInfo
		MasterInfo
		AgentInfo
		CSIPluginContainerInfo
		CSIPluginInfo
		ResourceProviderInfo
		Value
		Attribute
		Resource
		TrafficControlStatistics
		IpStatistics
		IcmpStatistics
		TcpStatistics
		UdpStatistics
		SNMPStatistics
		DiskStatistics
		ResourceStatistics
		ResourceUsage
		PerfStatistics
		Request
		Offer
		InverseOffer
		TaskInfo
		TaskGroupInfo
		Task
		TaskResourceLimitation
		UUID
		Operation
		OperationStatus
		CheckStatusInfo
		TaskStatus
		Filters
		Environment
		Parameter
		Parameters
		Credential
		Credentials
		Secret
		RateLimit
		RateLimits
		Image
		MountPropagation
		Volume
		NetworkInfo
		CapabilityInfo
		LinuxInfo
		RLimitInfo
		TTYInfo
		ContainerInfo
		ContainerStatus
		CgroupInfo
		Labels
		Label
		Port
		Ports
		DiscoveryInfo
		WeightInfo
		VersionInfo
		Flag
		Role
		Metric
		FileInfo
		Device
		DeviceAccess
		DeviceWhitelist
*/
package mesos

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import strconv "strconv"

import bytes "bytes"

import strings "strings"
import reflect "reflect"

import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// *
// Status is used to indicate the state of the scheduler and executor
// driver after function calls.
type Status int32

const (
	DRIVER_NOT_STARTED Status = 1
	DRIVER_RUNNING     Status = 2
	DRIVER_ABORTED     Status = 3
	DRIVER_STOPPED     Status = 4
)

var Status_name = map[int32]string{
	1: "DRIVER_NOT_STARTED",
	2: "DRIVER_RUNNING",
	3: "DRIVER_ABORTED",
	4: "DRIVER_STOPPED",
}
var Status_value = map[string]int32{
	"DRIVER_NOT_STARTED": 1,
	"DRIVER_RUNNING":     2,
	"DRIVER_ABORTED":     3,
	"DRIVER_STOPPED":     4,
}

func (x Status) Enum() *Status {
	p := new(Status)
	*p = x
	return p
}
func (x Status) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Status_name, int32(x))
}
func (x *Status) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Status_value, data, "Status")
	if err != nil {
		return err
	}
	*x = Status(value)
	return nil
}
func (Status) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{0} }

// *
// Describes possible task states. IMPORTANT: Mesos assumes tasks that
// enter terminal states (see below) imply the task is no longer
// running and thus clean up any thing associated with the task
// (ultimately offering any resources being consumed by that task to
// another task).
type TaskState int32

const (
	TASK_STAGING  TaskState = 6
	TASK_STARTING TaskState = 0
	TASK_RUNNING  TaskState = 1
	// NOTE: This should only be sent when the framework has
	// the TASK_KILLING_STATE capability.
	TASK_KILLING TaskState = 8
	// The task finished successfully on its own without external interference.
	TASK_FINISHED TaskState = 2
	TASK_FAILED   TaskState = 3
	TASK_KILLED   TaskState = 4
	TASK_ERROR    TaskState = 7
	// In Mesos 1.3, this will only be sent when the framework does NOT
	// opt-in to the PARTITION_AWARE capability.
	//
	// NOTE: This state is not always terminal. For example, tasks might
	// transition from TASK_LOST to TASK_RUNNING or other states when a
	// partitioned agent re-registers.
	TASK_LOST TaskState = 5
	// The task failed to launch because of a transient error. The
	// task's executor never started running. Unlike TASK_ERROR, the
	// task description is valid -- attempting to launch the task again
	// may be successful.
	TASK_DROPPED TaskState = 9
	// The task was running on an agent that has lost contact with the
	// master, typically due to a network failure or partition. The task
	// may or may not still be running.
	TASK_UNREACHABLE TaskState = 10
	// The task is no longer running. This can occur if the agent has
	// been terminated along with all of its tasks (e.g., the host that
	// was running the agent was rebooted). It might also occur if the
	// task was terminated due to an agent or containerizer error, or if
	// the task was preempted by the QoS controller in an
	// oversubscription scenario.
	TASK_GONE TaskState = 11
	// The task was running on an agent that the master cannot contact;
	// the operator has asserted that the agent has been shutdown, but
	// this has not been directly confirmed by the master. If the
	// operator is correct, the task is not running and this is a
	// terminal state; if the operator is mistaken, the task may still
	// be running and might return to RUNNING in the future.
	TASK_GONE_BY_OPERATOR TaskState = 12
	// The master has no knowledge of the task. This is typically
	// because either (a) the master never had knowledge of the task, or
	// (b) the master forgot about the task because it garbage collected
	// its metadata about the task. The task may or may not still be
	// running.
	TASK_UNKNOWN TaskState = 13
)

var TaskState_name = map[int32]string{
	6:  "TASK_STAGING",
	0:  "TASK_STARTING",
	1:  "TASK_RUNNING",
	8:  "TASK_KILLING",
	2:  "TASK_FINISHED",
	3:  "TASK_FAILED",
	4:  "TASK_KILLED",
	7:  "TASK_ERROR",
	5:  "TASK_LOST",
	9:  "TASK_DROPPED",
	10: "TASK_UNREACHABLE",
	11: "TASK_GONE",
	12: "TASK_GONE_BY_OPERATOR",
	13: "TASK_UNKNOWN",
}
var TaskState_value = map[string]int32{
	"TASK_STAGING":          6,
	"TASK_STARTING":         0,
	"TASK_RUNNING":          1,
	"TASK_KILLING":          8,
	"TASK_FINISHED":         2,
	"TASK_FAILED":           3,
	"TASK_KILLED":           4,
	"TASK_ERROR":            7,
	"TASK_LOST":             5,
	"TASK_DROPPED":          9,
	"TASK_UNREACHABLE":      10,
	"TASK_GONE":             11,
	"TASK_GONE_BY_OPERATOR": 12,
	"TASK_UNKNOWN":          13,
}

func (x TaskState) Enum() *TaskState {
	p := new(TaskState)
	*p = x
	return p
}
func (x TaskState) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(TaskState_name, int32(x))
}
func (x *TaskState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskState_value, data, "TaskState")
	if err != nil {
		return err
	}
	*x = TaskState(value)
	return nil
}
func (TaskState) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{1} }

// *
// Describes possible operation states.
type OperationState int32

const (
	// Default value if the enum is not set. See MESOS-4997.
	OPERATION_UNSUPPORTED OperationState = 0
	// Initial state.
	OPERATION_PENDING OperationState = 1
	// TERMINAL: The operation was successfully applied.
	OPERATION_FINISHED OperationState = 2
	// TERMINAL: The operation failed to apply.
	OPERATION_FAILED OperationState = 3
	// TERMINAL: The operation description contains an error.
	OPERATION_ERROR OperationState = 4
	// TERMINAL: The operation was dropped due to a transient error.
	OPERATION_DROPPED OperationState = 5
)

var OperationState_name = map[int32]string{
	0: "OPERATION_UNSUPPORTED",
	1: "OPERATION_PENDING",
	2: "OPERATION_FINISHED",
	3: "OPERATION_FAILED",
	4: "OPERATION_ERROR",
	5: "OPERATION_DROPPED",
}
var OperationState_value = map[string]int32{
	"OPERATION_UNSUPPORTED": 0,
	"OPERATION_PENDING":     1,
	"OPERATION_FINISHED":    2,
	"OPERATION_FAILED":      3,
	"OPERATION_ERROR":       4,
	"OPERATION_DROPPED":     5,
}

func (x OperationState) Enum() *OperationState {
	p := new(OperationState)
	*p = x
	return p
}
func (x OperationState) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(OperationState_name, int32(x))
}
func (x *OperationState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(OperationState_value, data, "OperationState")
	if err != nil {
		return err
	}
	*x = OperationState(value)
	return nil
}
func (OperationState) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{2} }

// Describes the several states that a machine can be in.  A `Mode`
// applies to a machine and to all associated agents on the machine.
type MachineInfo_Mode int32

const (
	// In this mode, a machine is behaving normally;
	// offering resources, executing tasks, etc.
	UP MachineInfo_Mode = 1
	// In this mode, all agents on the machine are expected to cooperate with
	// frameworks to drain resources.  In general, draining is done ahead of
	// a pending `unavailability`.  The resources should be drained so as to
	// maximize utilization prior to the maintenance but without knowingly
	// violating the frameworks' requirements.
	DRAINING MachineInfo_Mode = 2
	// In this mode, a machine is not running any tasks and will not offer
	// any of its resources.  Agents on the machine will not be allowed to
	// register with the master.
	DOWN MachineInfo_Mode = 3
)

var MachineInfo_Mode_name = map[int32]string{
	1: "UP",
	2: "DRAINING",
	3: "DOWN",
}
var MachineInfo_Mode_value = map[string]int32{
	"UP":       1,
	"DRAINING": 2,
	"DOWN":     3,
}

func (x MachineInfo_Mode) Enum() *MachineInfo_Mode {
	p := new(MachineInfo_Mode)
	*p = x
	return p
}
func (x MachineInfo_Mode) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(MachineInfo_Mode_name, int32(x))
}
func (x *MachineInfo_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(MachineInfo_Mode_value, data, "MachineInfo_Mode")
	if err != nil {
		return err
	}
	*x = MachineInfo_Mode(value)
	return nil
}
func (MachineInfo_Mode) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{14, 0} }

type FrameworkInfo_Capability_Type int32

const (
	// This must be the first enum value in this list, to
	// ensure that if 'type' is not set, the default value
	// is UNKNOWN. This enables enum values to be added
	// in a backwards-compatible way. See: MESOS-4997.
	FrameworkInfo_Capability_UNKNOWN FrameworkInfo_Capability_Type = 0
	// Receive offers with revocable resources. See 'Resource'
	// message for details.
	FrameworkInfo_Capability_REVOCABLE_RESOURCES FrameworkInfo_Capability_Type = 1
	// Receive the TASK_KILLING TaskState when a task is being
	// killed by an executor. The executor will examine this
	// capability to determine whether it can send TASK_KILLING.
	FrameworkInfo_Capability_TASK_KILLING_STATE FrameworkInfo_Capability_Type = 2
	// Indicates whether the framework is aware of GPU resources.
	// Frameworks that are aware of GPU resources are expected to
	// avoid placing non-GPU workloads on GPU agents, in order
	// to avoid occupying a GPU agent and preventing GPU workloads
	// from running! Currently, if a framework is unaware of GPU
	// resources, it will not be offered *any* of the resources on
	// an agent with GPUs. This restriction is in place because we
	// do not have a revocation mechanism that ensures GPU workloads
	// can evict GPU agent occupants if necessary.
	//
	// TODO(bmahler): As we add revocation we can relax the
	// restriction here. See MESOS-5634 for more information.
	FrameworkInfo_Capability_GPU_RESOURCES FrameworkInfo_Capability_Type = 3
	// Receive offers with resources that are shared.
	FrameworkInfo_Capability_SHARED_RESOURCES FrameworkInfo_Capability_Type = 4
	// Indicates that (1) the framework is prepared to handle the
	// following TaskStates: TASK_UNREACHABLE, TASK_DROPPED,
	// TASK_GONE, TASK_GONE_BY_OPERATOR, and TASK_UNKNOWN, and (2)
	// the framework will assume responsibility for managing
	// partitioned tasks that reregister with the master.
	//
	// Frameworks that enable this capability can define how they
	// would like to handle partitioned tasks. Frameworks will
	// receive TASK_UNREACHABLE for tasks on agents that are
	// partitioned from the master.
	//
	// Without this capability, frameworks will receive TASK_LOST
	// for tasks on partitioned agents.
	// NOTE: Prior to Mesos 1.5, such tasks will be killed by Mesos
	// when the agent reregisters (unless the master has failed over).
	// However due to the lack of benefit in maintaining different
	// behaviors depending on whether the master has failed over
	// (see MESOS-7215), as of 1.5, Mesos will not kill these
	// tasks in either case.
	FrameworkInfo_Capability_PARTITION_AWARE FrameworkInfo_Capability_Type = 5
	// This expresses the ability for the framework to be
	// "multi-tenant" via using the newly introduced `roles`
	// field, and examining `Offer.allocation_info` to determine
	// which role the offers are being made to. We also
	// expect that "single-tenant" schedulers eventually
	// provide this and move away from the deprecated
	// `role` field.
	FrameworkInfo_Capability_MULTI_ROLE FrameworkInfo_Capability_Type = 6
	// This capability has two effects for a framework.
	//
	// (1) The framework is offered resources in a new format.
	//
	//     The offered resources have the `Resource.reservations` field set
	//     rather than `Resource.role` and `Resource.reservation`. In short,
	//     an empty `reservations` field denotes unreserved resources, and
	//     each `ReservationInfo` in the `reservations` field denotes a
	//     reservation that refines the previous one.
	//
	//     See the 'Resource Format' section for more details.
	//
	// (2) The framework can create refined reservations.
	//
	//     A framework can refine an existing reservation via the
	//     `Resource.reservations` field. For example, a reservation for role
	//     `eng` can be refined to `eng/front_end`.
	//
	//     See `ReservationInfo.reservations` for more details.
	//
	// NOTE: Without this capability, a framework is not offered resources
	// that have refined reservations. A resource is said to have refined
	// reservations if it uses the `Resource.reservations` field, and
	// `Resource.reservations_size() > 1`.
	FrameworkInfo_Capability_RESERVATION_REFINEMENT FrameworkInfo_Capability_Type = 7
	// Indicates that the framework is prepared to receive offers
	// for agents whose region is different from the master's
	// region. Network links between hosts in different regions
	// typically have higher latency and lower bandwidth than
	// network links within a region, so frameworks should be
	// careful to only place suitable workloads in remote regions.
	// Frameworks that are not region-aware will never receive
	// offers for remote agents; region-aware frameworks are assumed
	// to implement their own logic to decide which workloads (if
	// any) are suitable for placement on remote agents.
	FrameworkInfo_Capability_REGION_AWARE FrameworkInfo_Capability_Type = 8
)

var FrameworkInfo_Capability_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "REVOCABLE_RESOURCES",
	2: "TASK_KILLING_STATE",
	3: "GPU_RESOURCES",
	4: "SHARED_RESOURCES",
	5: "PARTITION_AWARE",
	6: "MULTI_ROLE",
	7: "RESERVATION_REFINEMENT",
	8: "REGION_AWARE",
}
var FrameworkInfo_Capability_Type_value = map[string]int32{
	"UNKNOWN":                0,
	"REVOCABLE_RESOURCES":    1,
	"TASK_KILLING_STATE":     2,
	"GPU_RESOURCES":          3,
	"SHARED_RESOURCES":       4,
	"PARTITION_AWARE":        5,
	"MULTI_ROLE":             6,
	"RESERVATION_REFINEMENT": 7,
	"REGION_AWARE":           8,
}

func (x FrameworkInfo_Capability_Type) Enum() *FrameworkInfo_Capability_Type {
	p := new(FrameworkInfo_Capability_Type)
	*p = x
	return p
}
func (x FrameworkInfo_Capability_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(FrameworkInfo_Capability_Type_name, int32(x))
}
func (x *FrameworkInfo_Capability_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FrameworkInfo_Capability_Type_value, data, "FrameworkInfo_Capability_Type")
	if err != nil {
		return err
	}
	*x = FrameworkInfo_Capability_Type(value)
	return nil
}
func (FrameworkInfo_Capability_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{15, 0, 0}
}

type CheckInfo_Type int32

const (
	CheckInfo_UNKNOWN CheckInfo_Type = 0
	CheckInfo_COMMAND CheckInfo_Type = 1
	CheckInfo_HTTP    CheckInfo_Type = 2
	CheckInfo_TCP     CheckInfo_Type = 3
)

var CheckInfo_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "COMMAND",
	2: "HTTP",
	3: "TCP",
}
var CheckInfo_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"COMMAND": 1,
	"HTTP":    2,
	"TCP":     3,
}

func (x CheckInfo_Type) Enum() *CheckInfo_Type {
	p := new(CheckInfo_Type)
	*p = x
	return p
}
func (x CheckInfo_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(CheckInfo_Type_name, int32(x))
}
func (x *CheckInfo_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CheckInfo_Type_value, data, "CheckInfo_Type")
	if err != nil {
		return err
	}
	*x = CheckInfo_Type(value)
	return nil
}
func (CheckInfo_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{16, 0} }

type HealthCheck_Type int32

const (
	HealthCheck_UNKNOWN HealthCheck_Type = 0
	HealthCheck_COMMAND HealthCheck_Type = 1
	HealthCheck_HTTP    HealthCheck_Type = 2
	HealthCheck_TCP     HealthCheck_Type = 3
)

var HealthCheck_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "COMMAND",
	2: "HTTP",
	3: "TCP",
}
var HealthCheck_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"COMMAND": 1,
	"HTTP":    2,
	"TCP":     3,
}

func (x HealthCheck_Type) Enum() *HealthCheck_Type {
	p := new(HealthCheck_Type)
	*p = x
	return p
}
func (x HealthCheck_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(HealthCheck_Type_name, int32(x))
}
func (x *HealthCheck_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(HealthCheck_Type_value, data, "HealthCheck_Type")
	if err != nil {
		return err
	}
	*x = HealthCheck_Type(value)
	return nil
}
func (HealthCheck_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{17, 0} }

type ExecutorInfo_Type int32

const (
	ExecutorInfo_UNKNOWN ExecutorInfo_Type = 0
	// Mesos provides a simple built-in default executor that frameworks can
	// leverage to run shell commands and containers.
	//
	// NOTES:
	//
	// 1) `command` must not be set when using a default executor.
	//
	// 2) Default executor only accepts a *single* `LAUNCH` or `LAUNCH_GROUP`
	//    operation.
	//
	// 3) If `container` is set, `container.type` must be `MESOS`
	//    and `container.mesos.image` must not be set.
	ExecutorInfo_DEFAULT ExecutorInfo_Type = 1
	// For frameworks that need custom functionality to run tasks, a `CUSTOM`
	// executor can be used. Note that `command` must be set when using a
	// `CUSTOM` executor.
	ExecutorInfo_CUSTOM ExecutorInfo_Type = 2
)

var ExecutorInfo_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "DEFAULT",
	2: "CUSTOM",
}
var ExecutorInfo_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"DEFAULT": 1,
	"CUSTOM":  2,
}

func (x ExecutorInfo_Type) Enum() *ExecutorInfo_Type {
	p := new(ExecutorInfo_Type)
	*p = x
	return p
}
func (x ExecutorInfo_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(ExecutorInfo_Type_name, int32(x))
}
func (x *ExecutorInfo_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ExecutorInfo_Type_value, data, "ExecutorInfo_Type")
	if err != nil {
		return err
	}
	*x = ExecutorInfo_Type(value)
	return nil
}
func (ExecutorInfo_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{20, 0} }

type MasterInfo_Capability_Type int32

const (
	MasterInfo_Capability_UNKNOWN MasterInfo_Capability_Type = 0
	// The master can handle slaves whose state
	// changes after re-registering.
	MasterInfo_Capability_AGENT_UPDATE MasterInfo_Capability_Type = 1
)

var MasterInfo_Capability_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "AGENT_UPDATE",
}
var MasterInfo_Capability_Type_value = map[string]int32{
	"UNKNOWN":      0,
	"AGENT_UPDATE": 1,
}

func (x MasterInfo_Capability_Type) Enum() *MasterInfo_Capability_Type {
	p := new(MasterInfo_Capability_Type)
	*p = x
	return p
}
func (x MasterInfo_Capability_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(MasterInfo_Capability_Type_name, int32(x))
}
func (x *MasterInfo_Capability_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(MasterInfo_Capability_Type_value, data, "MasterInfo_Capability_Type")
	if err != nil {
		return err
	}
	*x = MasterInfo_Capability_Type(value)
	return nil
}
func (MasterInfo_Capability_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{22, 0, 0}
}

type AgentInfo_Capability_Type int32

const (
	// This must be the first enum value in this list, to
	// ensure that if 'type' is not set, the default value
	// is UNKNOWN. This enables enum values to be added
	// in a backwards-compatible way. See: MESOS-4997.
	AgentInfo_Capability_UNKNOWN AgentInfo_Capability_Type = 0
	// This expresses the ability for the agent to be able
	// to launch tasks of a 'multi-role' framework.
	AgentInfo_Capability_MULTI_ROLE AgentInfo_Capability_Type = 1
	// This expresses the ability for the agent to be able to launch
	// tasks, reserve resources, and create volumes using resources
	// allocated to a 'hierarchical-role'.
	// NOTE: This capability is required specifically for creating
	// volumes because a hierchical role includes '/' (slashes) in them.
	// Agents with this capability know to transform the '/' (slashes)
	// into ' ' (spaces).
	AgentInfo_Capability_HIERARCHICAL_ROLE AgentInfo_Capability_Type = 2
	// This capability has three effects for an agent.
	//
	// (1) The format of the checkpointed resources, and
	//     the resources reported to master.
	//
	//     These resources are reported in the "pre-reservation-refinement"
	//     format if none of the resources have refined reservations. If any
	//     of the resources have refined reservations, they are reported in
	//     the "post-reservation-refinement" format. The purpose is to allow
	//     downgrading of an agent as well as communication with a pre-1.4.0
	//     master until the reservation refinement feature is actually used.
	//
	//     See the 'Resource Format' section for more details.
	//
	// (2) The format of the resources reported by the HTTP endpoints.
	//
	//     For resources reported by agent endpoints, the
	//     "pre-reservation-refinement" format is "injected" if possible.
	//     That is, resources without refined reservations will have the
	//     `Resource.role` and `Resource.reservation` set, whereas
	//     resources with refined reservations will not.
	//
	//     See the 'Resource Format' section for more details.
	//
	// (3) The ability for the agent to launch tasks, reserve resources, and
	//     create volumes using resources that have refined reservations.
	//
	//     See `ReservationInfo.reservations` section for more details.
	//
	// NOTE: Resources are said to have refined reservations if it uses the
	// `Resource.reservations` field, and `Resource.reservations_size() > 1`.
	AgentInfo_Capability_RESERVATION_REFINEMENT AgentInfo_Capability_Type = 3
	// This expresses the ability for the agent to handle resource
	// provider related operations. This includes the following:
	//
	// (1) The ability to report resources that are provided by some
	//     local resource providers through the resource provider API.
	//
	// (2) The ability to provide operation feedback.
	AgentInfo_Capability_RESOURCE_PROVIDER AgentInfo_Capability_Type = 4
)

var AgentInfo_Capability_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "MULTI_ROLE",
	2: "HIERARCHICAL_ROLE",
	3: "RESERVATION_REFINEMENT",
	4: "RESOURCE_PROVIDER",
}
var AgentInfo_Capability_Type_value = map[string]int32{
	"UNKNOWN":                0,
	"MULTI_ROLE":             1,
	"HIERARCHICAL_ROLE":      2,
	"RESERVATION_REFINEMENT": 3,
	"RESOURCE_PROVIDER":      4,
}

func (x AgentInfo_Capability_Type) Enum() *AgentInfo_Capability_Type {
	p := new(AgentInfo_Capability_Type)
	*p = x
	return p
}
func (x AgentInfo_Capability_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(AgentInfo_Capability_Type_name, int32(x))
}
func (x *AgentInfo_Capability_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AgentInfo_Capability_Type_value, data, "AgentInfo_Capability_Type")
	if err != nil {
		return err
	}
	*x = AgentInfo_Capability_Type(value)
	return nil
}
func (AgentInfo_Capability_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{23, 0, 0}
}

type CSIPluginContainerInfo_Service int32

const (
	CSIPluginContainerInfo_UNKNOWN            CSIPluginContainerInfo_Service = 0
	CSIPluginContainerInfo_CONTROLLER_SERVICE CSIPluginContainerInfo_Service = 1
	CSIPluginContainerInfo_NODE_SERVICE       CSIPluginContainerInfo_Service = 2
)

var CSIPluginContainerInfo_Service_name = map[int32]string{
	0: "UNKNOWN",
	1: "CONTROLLER_SERVICE",
	2: "NODE_SERVICE",
}
var CSIPluginContainerInfo_Service_value = map[string]int32{
	"UNKNOWN":            0,
	"CONTROLLER_SERVICE": 1,
	"NODE_SERVICE":       2,
}

func (x CSIPluginContainerInfo_Service) Enum() *CSIPluginContainerInfo_Service {
	p := new(CSIPluginContainerInfo_Service)
	*p = x
	return p
}
func (x CSIPluginContainerInfo_Service) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(CSIPluginContainerInfo_Service_name, int32(x))
}
func (x *CSIPluginContainerInfo_Service) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CSIPluginContainerInfo_Service_value, data, "CSIPluginContainerInfo_Service")
	if err != nil {
		return err
	}
	*x = CSIPluginContainerInfo_Service(value)
	return nil
}
func (CSIPluginContainerInfo_Service) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{24, 0}
}

type Value_Type int32

const (
	SCALAR Value_Type = 0
	RANGES Value_Type = 1
	SET    Value_Type = 2
	TEXT   Value_Type = 3
)

var Value_Type_name = map[int32]string{
	0: "SCALAR",
	1: "RANGES",
	2: "SET",
	3: "TEXT",
}
var Value_Type_value = map[string]int32{
	"SCALAR": 0,
	"RANGES": 1,
	"SET":    2,
	"TEXT":   3,
}

func (x Value_Type) Enum() *Value_Type {
	p := new(Value_Type)
	*p = x
	return p
}
func (x Value_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Value_Type_name, int32(x))
}
func (x *Value_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Value_Type_value, data, "Value_Type")
	if err != nil {
		return err
	}
	*x = Value_Type(value)
	return nil
}
func (Value_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{27, 0} }

type Resource_ReservationInfo_Type int32

const (
	Resource_ReservationInfo_UNKNOWN Resource_ReservationInfo_Type = 0
	Resource_ReservationInfo_STATIC  Resource_ReservationInfo_Type = 1
	Resource_ReservationInfo_DYNAMIC Resource_ReservationInfo_Type = 2
)

var Resource_ReservationInfo_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "STATIC",
	2: "DYNAMIC",
}
var Resource_ReservationInfo_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"STATIC":  1,
	"DYNAMIC": 2,
}

func (x Resource_ReservationInfo_Type) Enum() *Resource_ReservationInfo_Type {
	p := new(Resource_ReservationInfo_Type)
	*p = x
	return p
}
func (x Resource_ReservationInfo_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Resource_ReservationInfo_Type_name, int32(x))
}
func (x *Resource_ReservationInfo_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Resource_ReservationInfo_Type_value, data, "Resource_ReservationInfo_Type")
	if err != nil {
		return err
	}
	*x = Resource_ReservationInfo_Type(value)
	return nil
}
func (Resource_ReservationInfo_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{29, 1, 0}
}

type Resource_DiskInfo_Source_Type int32

const (
	Resource_DiskInfo_Source_UNKNOWN Resource_DiskInfo_Source_Type = 0
	Resource_DiskInfo_Source_PATH    Resource_DiskInfo_Source_Type = 1
	Resource_DiskInfo_Source_MOUNT   Resource_DiskInfo_Source_Type = 2
	Resource_DiskInfo_Source_BLOCK   Resource_DiskInfo_Source_Type = 3
	Resource_DiskInfo_Source_RAW     Resource_DiskInfo_Source_Type = 4
)

var Resource_DiskInfo_Source_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "PATH",
	2: "MOUNT",
	3: "BLOCK",
	4: "RAW",
}
var Resource_DiskInfo_Source_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"PATH":    1,
	"MOUNT":   2,
	"BLOCK":   3,
	"RAW":     4,
}

func (x Resource_DiskInfo_Source_Type) Enum() *Resource_DiskInfo_Source_Type {
	p := new(Resource_DiskInfo_Source_Type)
	*p = x
	return p
}
func (x Resource_DiskInfo_Source_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Resource_DiskInfo_Source_Type_name, int32(x))
}
func (x *Resource_DiskInfo_Source_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Resource_DiskInfo_Source_Type_value, data, "Resource_DiskInfo_Source_Type")
	if err != nil {
		return err
	}
	*x = Resource_DiskInfo_Source_Type(value)
	return nil
}
func (Resource_DiskInfo_Source_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{29, 2, 1, 0}
}

type Offer_Operation_Type int32

const (
	Offer_Operation_UNKNOWN        Offer_Operation_Type = 0
	Offer_Operation_LAUNCH         Offer_Operation_Type = 1
	Offer_Operation_LAUNCH_GROUP   Offer_Operation_Type = 6
	Offer_Operation_RESERVE        Offer_Operation_Type = 2
	Offer_Operation_UNRESERVE      Offer_Operation_Type = 3
	Offer_Operation_CREATE         Offer_Operation_Type = 4
	Offer_Operation_DESTROY        Offer_Operation_Type = 5
	Offer_Operation_CREATE_VOLUME  Offer_Operation_Type = 7
	Offer_Operation_DESTROY_VOLUME Offer_Operation_Type = 8
	Offer_Operation_CREATE_BLOCK   Offer_Operation_Type = 9
	Offer_Operation_DESTROY_BLOCK  Offer_Operation_Type = 10
)

var Offer_Operation_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "LAUNCH",
	6:  "LAUNCH_GROUP",
	2:  "RESERVE",
	3:  "UNRESERVE",
	4:  "CREATE",
	5:  "DESTROY",
	7:  "CREATE_VOLUME",
	8:  "DESTROY_VOLUME",
	9:  "CREATE_BLOCK",
	10: "DESTROY_BLOCK",
}
var Offer_Operation_Type_value = map[string]int32{
	"UNKNOWN":        0,
	"LAUNCH":         1,
	"LAUNCH_GROUP":   6,
	"RESERVE":        2,
	"UNRESERVE":      3,
	"CREATE":         4,
	"DESTROY":        5,
	"CREATE_VOLUME":  7,
	"DESTROY_VOLUME": 8,
	"CREATE_BLOCK":   9,
	"DESTROY_BLOCK":  10,
}

func (x Offer_Operation_Type) Enum() *Offer_Operation_Type {
	p := new(Offer_Operation_Type)
	*p = x
	return p
}
func (x Offer_Operation_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Offer_Operation_Type_name, int32(x))
}
func (x *Offer_Operation_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Offer_Operation_Type_value, data, "Offer_Operation_Type")
	if err != nil {
		return err
	}
	*x = Offer_Operation_Type(value)
	return nil
}
func (Offer_Operation_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 0}
}

// Describes the source of the task status update.
type TaskStatus_Source int32

const (
	SOURCE_MASTER   TaskStatus_Source = 0
	SOURCE_AGENT    TaskStatus_Source = 1
	SOURCE_EXECUTOR TaskStatus_Source = 2
)

var TaskStatus_Source_name = map[int32]string{
	0: "SOURCE_MASTER",
	1: "SOURCE_AGENT",
	2: "SOURCE_EXECUTOR",
}
var TaskStatus_Source_value = map[string]int32{
	"SOURCE_MASTER":   0,
	"SOURCE_AGENT":    1,
	"SOURCE_EXECUTOR": 2,
}

func (x TaskStatus_Source) Enum() *TaskStatus_Source {
	p := new(TaskStatus_Source)
	*p = x
	return p
}
func (x TaskStatus_Source) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(TaskStatus_Source_name, int32(x))
}
func (x *TaskStatus_Source) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskStatus_Source_value, data, "TaskStatus_Source")
	if err != nil {
		return err
	}
	*x = TaskStatus_Source(value)
	return nil
}
func (TaskStatus_Source) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{51, 0} }

// Detailed reason for the task status update.
// Refer to docs/task-state-reasons.md for additional explanation.
type TaskStatus_Reason int32

const (
	// TODO(jieyu): The default value when a caller doesn't check for
	// presence is 0 and so ideally the 0 reason is not a valid one.
	// Since this is not used anywhere, consider removing this reason.
	REASON_COMMAND_EXECUTOR_FAILED          TaskStatus_Reason = 0
	REASON_CONTAINER_LAUNCH_FAILED          TaskStatus_Reason = 21
	REASON_CONTAINER_LIMITATION             TaskStatus_Reason = 19
	REASON_CONTAINER_LIMITATION_DISK        TaskStatus_Reason = 20
	REASON_CONTAINER_LIMITATION_MEMORY      TaskStatus_Reason = 8
	REASON_CONTAINER_PREEMPTED              TaskStatus_Reason = 17
	REASON_CONTAINER_UPDATE_FAILED          TaskStatus_Reason = 22
	REASON_EXECUTOR_REGISTRATION_TIMEOUT    TaskStatus_Reason = 23
	REASON_EXECUTOR_REREGISTRATION_TIMEOUT  TaskStatus_Reason = 24
	REASON_EXECUTOR_TERMINATED              TaskStatus_Reason = 1
	REASON_EXECUTOR_UNREGISTERED            TaskStatus_Reason = 2
	REASON_FRAMEWORK_REMOVED                TaskStatus_Reason = 3
	REASON_GC_ERROR                         TaskStatus_Reason = 4
	REASON_INVALID_FRAMEWORKID              TaskStatus_Reason = 5
	REASON_INVALID_OFFERS                   TaskStatus_Reason = 6
	REASON_IO_SWITCHBOARD_EXITED            TaskStatus_Reason = 27
	REASON_MASTER_DISCONNECTED              TaskStatus_Reason = 7
	REASON_RECONCILIATION                   TaskStatus_Reason = 9
	REASON_RESOURCES_UNKNOWN                TaskStatus_Reason = 18
	REASON_AGENT_DISCONNECTED               TaskStatus_Reason = 10
	REASON_AGENT_REMOVED                    TaskStatus_Reason = 11
	REASON_AGENT_REMOVED_BY_OPERATOR        TaskStatus_Reason = 31
	REASON_AGENT_REREGISTERED               TaskStatus_Reason = 32
	REASON_AGENT_RESTARTED                  TaskStatus_Reason = 12
	REASON_AGENT_UNKNOWN                    TaskStatus_Reason = 13
	REASON_TASK_KILLED_DURING_LAUNCH        TaskStatus_Reason = 30
	REASON_TASK_CHECK_STATUS_UPDATED        TaskStatus_Reason = 28
	REASON_TASK_HEALTH_CHECK_STATUS_UPDATED TaskStatus_Reason = 29
	REASON_TASK_GROUP_INVALID               TaskStatus_Reason = 25
	REASON_TASK_GROUP_UNAUTHORIZED          TaskStatus_Reason = 26
	REASON_TASK_INVALID                     TaskStatus_Reason = 14
	REASON_TASK_UNAUTHORIZED                TaskStatus_Reason = 15
	REASON_TASK_UNKNOWN                     TaskStatus_Reason = 16
)

var TaskStatus_Reason_name = map[int32]string{
	0:  "REASON_COMMAND_EXECUTOR_FAILED",
	21: "REASON_CONTAINER_LAUNCH_FAILED",
	19: "REASON_CONTAINER_LIMITATION",
	20: "REASON_CONTAINER_LIMITATION_DISK",
	8:  "REASON_CONTAINER_LIMITATION_MEMORY",
	17: "REASON_CONTAINER_PREEMPTED",
	22: "REASON_CONTAINER_UPDATE_FAILED",
	23: "REASON_EXECUTOR_REGISTRATION_TIMEOUT",
	24: "REASON_EXECUTOR_REREGISTRATION_TIMEOUT",
	1:  "REASON_EXECUTOR_TERMINATED",
	2:  "REASON_EXECUTOR_UNREGISTERED",
	3:  "REASON_FRAMEWORK_REMOVED",
	4:  "REASON_GC_ERROR",
	5:  "REASON_INVALID_FRAMEWORKID",
	6:  "REASON_INVALID_OFFERS",
	27: "REASON_IO_SWITCHBOARD_EXITED",
	7:  "REASON_MASTER_DISCONNECTED",
	9:  "REASON_RECONCILIATION",
	18: "REASON_RESOURCES_UNKNOWN",
	10: "REASON_AGENT_DISCONNECTED",
	11: "REASON_AGENT_REMOVED",
	31: "REASON_AGENT_REMOVED_BY_OPERATOR",
	32: "REASON_AGENT_REREGISTERED",
	12: "REASON_AGENT_RESTARTED",
	13: "REASON_AGENT_UNKNOWN",
	30: "REASON_TASK_KILLED_DURING_LAUNCH",
	28: "REASON_TASK_CHECK_STATUS_UPDATED",
	29: "REASON_TASK_HEALTH_CHECK_STATUS_UPDATED",
	25: "REASON_TASK_GROUP_INVALID",
	26: "REASON_TASK_GROUP_UNAUTHORIZED",
	14: "REASON_TASK_INVALID",
	15: "REASON_TASK_UNAUTHORIZED",
	16: "REASON_TASK_UNKNOWN",
}
var TaskStatus_Reason_value = map[string]int32{
	"REASON_COMMAND_EXECUTOR_FAILED":          0,
	"REASON_CONTAINER_LAUNCH_FAILED":          21,
	"REASON_CONTAINER_LIMITATION":             19,
	"REASON_CONTAINER_LIMITATION_DISK":        20,
	"REASON_CONTAINER_LIMITATION_MEMORY":      8,
	"REASON_CONTAINER_PREEMPTED":              17,
	"REASON_CONTAINER_UPDATE_FAILED":          22,
	"REASON_EXECUTOR_REGISTRATION_TIMEOUT":    23,
	"REASON_EXECUTOR_REREGISTRATION_TIMEOUT":  24,
	"REASON_EXECUTOR_TERMINATED":              1,
	"REASON_EXECUTOR_UNREGISTERED":            2,
	"REASON_FRAMEWORK_REMOVED":                3,
	"REASON_GC_ERROR":                         4,
	"REASON_INVALID_FRAMEWORKID":              5,
	"REASON_INVALID_OFFERS":                   6,
	"REASON_IO_SWITCHBOARD_EXITED":            27,
	"REASON_MASTER_DISCONNECTED":              7,
	"REASON_RECONCILIATION":                   9,
	"REASON_RESOURCES_UNKNOWN":                18,
	"REASON_AGENT_DISCONNECTED":               10,
	"REASON_AGENT_REMOVED":                    11,
	"REASON_AGENT_REMOVED_BY_OPERATOR":        31,
	"REASON_AGENT_REREGISTERED":               32,
	"REASON_AGENT_RESTARTED":                  12,
	"REASON_AGENT_UNKNOWN":                    13,
	"REASON_TASK_KILLED_DURING_LAUNCH":        30,
	"REASON_TASK_CHECK_STATUS_UPDATED":        28,
	"REASON_TASK_HEALTH_CHECK_STATUS_UPDATED": 29,
	"REASON_TASK_GROUP_INVALID":               25,
	"REASON_TASK_GROUP_UNAUTHORIZED":          26,
	"REASON_TASK_INVALID":                     14,
	"REASON_TASK_UNAUTHORIZED":                15,
	"REASON_TASK_UNKNOWN":                     16,
}

func (x TaskStatus_Reason) Enum() *TaskStatus_Reason {
	p := new(TaskStatus_Reason)
	*p = x
	return p
}
func (x TaskStatus_Reason) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(TaskStatus_Reason_name, int32(x))
}
func (x *TaskStatus_Reason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskStatus_Reason_value, data, "TaskStatus_Reason")
	if err != nil {
		return err
	}
	*x = TaskStatus_Reason(value)
	return nil
}
func (TaskStatus_Reason) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{51, 1} }

type Environment_Variable_Type int32

const (
	Environment_Variable_UNKNOWN Environment_Variable_Type = 0
	Environment_Variable_VALUE   Environment_Variable_Type = 1
	Environment_Variable_SECRET  Environment_Variable_Type = 2
)

var Environment_Variable_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "VALUE",
	2: "SECRET",
}
var Environment_Variable_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"VALUE":   1,
	"SECRET":  2,
}

func (x Environment_Variable_Type) Enum() *Environment_Variable_Type {
	p := new(Environment_Variable_Type)
	*p = x
	return p
}
func (x Environment_Variable_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Environment_Variable_Type_name, int32(x))
}
func (x *Environment_Variable_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Environment_Variable_Type_value, data, "Environment_Variable_Type")
	if err != nil {
		return err
	}
	*x = Environment_Variable_Type(value)
	return nil
}
func (Environment_Variable_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{53, 0, 0}
}

type Secret_Type int32

const (
	Secret_UNKNOWN   Secret_Type = 0
	Secret_REFERENCE Secret_Type = 1
	Secret_VALUE     Secret_Type = 2
)

var Secret_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "REFERENCE",
	2: "VALUE",
}
var Secret_Type_value = map[string]int32{
	"UNKNOWN":   0,
	"REFERENCE": 1,
	"VALUE":     2,
}

func (x Secret_Type) Enum() *Secret_Type {
	p := new(Secret_Type)
	*p = x
	return p
}
func (x Secret_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Secret_Type_name, int32(x))
}
func (x *Secret_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Secret_Type_value, data, "Secret_Type")
	if err != nil {
		return err
	}
	*x = Secret_Type(value)
	return nil
}
func (Secret_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{58, 0} }

type Image_Type int32

const (
	Image_APPC   Image_Type = 1
	Image_DOCKER Image_Type = 2
)

var Image_Type_name = map[int32]string{
	1: "APPC",
	2: "DOCKER",
}
var Image_Type_value = map[string]int32{
	"APPC":   1,
	"DOCKER": 2,
}

func (x Image_Type) Enum() *Image_Type {
	p := new(Image_Type)
	*p = x
	return p
}
func (x Image_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Image_Type_name, int32(x))
}
func (x *Image_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Image_Type_value, data, "Image_Type")
	if err != nil {
		return err
	}
	*x = Image_Type(value)
	return nil
}
func (Image_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{61, 0} }

type MountPropagation_Mode int32

const (
	MountPropagation_UNKNOWN MountPropagation_Mode = 0
	// The volume in a container will receive new mounts from the host
	// or other containers, but filesystems mounted inside the
	// container won't be propagated to the host or other containers.
	// This is currently the default behavior for all volumes.
	MountPropagation_HOST_TO_CONTAINER MountPropagation_Mode = 1
	// The volume in a container will receive new mounts from the host
	// or other containers, and its own mounts will be propagated from
	// the container to the host or other containers.
	MountPropagation_BIDIRECTIONAL MountPropagation_Mode = 2
)

var MountPropagation_Mode_name = map[int32]string{
	0: "UNKNOWN",
	1: "HOST_TO_CONTAINER",
	2: "BIDIRECTIONAL",
}
var MountPropagation_Mode_value = map[string]int32{
	"UNKNOWN":           0,
	"HOST_TO_CONTAINER": 1,
	"BIDIRECTIONAL":     2,
}

func (x MountPropagation_Mode) Enum() *MountPropagation_Mode {
	p := new(MountPropagation_Mode)
	*p = x
	return p
}
func (x MountPropagation_Mode) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(MountPropagation_Mode_name, int32(x))
}
func (x *MountPropagation_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(MountPropagation_Mode_value, data, "MountPropagation_Mode")
	if err != nil {
		return err
	}
	*x = MountPropagation_Mode(value)
	return nil
}
func (MountPropagation_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{62, 0}
}

type Volume_Mode int32

const (
	RW Volume_Mode = 1
	RO Volume_Mode = 2
)

var Volume_Mode_name = map[int32]string{
	1: "RW",
	2: "RO",
}
var Volume_Mode_value = map[string]int32{
	"RW": 1,
	"RO": 2,
}

func (x Volume_Mode) Enum() *Volume_Mode {
	p := new(Volume_Mode)
	*p = x
	return p
}
func (x Volume_Mode) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Volume_Mode_name, int32(x))
}
func (x *Volume_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Volume_Mode_value, data, "Volume_Mode")
	if err != nil {
		return err
	}
	*x = Volume_Mode(value)
	return nil
}
func (Volume_Mode) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{63, 0} }

type Volume_Source_Type int32

const (
	// This must be the first enum value in this list, to
	// ensure that if 'type' is not set, the default value
	// is UNKNOWN. This enables enum values to be added
	// in a backwards-compatible way. See: MESOS-4997.
	Volume_Source_UNKNOWN Volume_Source_Type = 0
	// TODO(gyliu513): Add IMAGE as volume source type.
	Volume_Source_DOCKER_VOLUME Volume_Source_Type = 1
	Volume_Source_HOST_PATH     Volume_Source_Type = 4
	Volume_Source_SANDBOX_PATH  Volume_Source_Type = 2
	Volume_Source_SECRET        Volume_Source_Type = 3
)

var Volume_Source_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "DOCKER_VOLUME",
	4: "HOST_PATH",
	2: "SANDBOX_PATH",
	3: "SECRET",
}
var Volume_Source_Type_value = map[string]int32{
	"UNKNOWN":       0,
	"DOCKER_VOLUME": 1,
	"HOST_PATH":     4,
	"SANDBOX_PATH":  2,
	"SECRET":        3,
}

func (x Volume_Source_Type) Enum() *Volume_Source_Type {
	p := new(Volume_Source_Type)
	*p = x
	return p
}
func (x Volume_Source_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Volume_Source_Type_name, int32(x))
}
func (x *Volume_Source_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Volume_Source_Type_value, data, "Volume_Source_Type")
	if err != nil {
		return err
	}
	*x = Volume_Source_Type(value)
	return nil
}
func (Volume_Source_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{63, 0, 0}
}

type Volume_Source_SandboxPath_Type int32

const (
	Volume_Source_SandboxPath_UNKNOWN Volume_Source_SandboxPath_Type = 0
	Volume_Source_SandboxPath_SELF    Volume_Source_SandboxPath_Type = 1
	Volume_Source_SandboxPath_PARENT  Volume_Source_SandboxPath_Type = 2
)

var Volume_Source_SandboxPath_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "SELF",
	2: "PARENT",
}
var Volume_Source_SandboxPath_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"SELF":    1,
	"PARENT":  2,
}

func (x Volume_Source_SandboxPath_Type) Enum() *Volume_Source_SandboxPath_Type {
	p := new(Volume_Source_SandboxPath_Type)
	*p = x
	return p
}
func (x Volume_Source_SandboxPath_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Volume_Source_SandboxPath_Type_name, int32(x))
}
func (x *Volume_Source_SandboxPath_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Volume_Source_SandboxPath_Type_value, data, "Volume_Source_SandboxPath_Type")
	if err != nil {
		return err
	}
	*x = Volume_Source_SandboxPath_Type(value)
	return nil
}
func (Volume_Source_SandboxPath_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{63, 0, 2, 0}
}

type NetworkInfo_Protocol int32

const (
	IPv4 NetworkInfo_Protocol = 1
	IPv6 NetworkInfo_Protocol = 2
)

var NetworkInfo_Protocol_name = map[int32]string{
	1: "IPv4",
	2: "IPv6",
}
var NetworkInfo_Protocol_value = map[string]int32{
	"IPv4": 1,
	"IPv6": 2,
}

func (x NetworkInfo_Protocol) Enum() *NetworkInfo_Protocol {
	p := new(NetworkInfo_Protocol)
	*p = x
	return p
}
func (x NetworkInfo_Protocol) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(NetworkInfo_Protocol_name, int32(x))
}
func (x *NetworkInfo_Protocol) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(NetworkInfo_Protocol_value, data, "NetworkInfo_Protocol")
	if err != nil {
		return err
	}
	*x = NetworkInfo_Protocol(value)
	return nil
}
func (NetworkInfo_Protocol) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{64, 0} }

// We start the actual values at an offset(1000) because Protobuf 2
// uses the first value as the default one. Separating the default
// value from the real first value helps to disambiguate them. This
// is especially valuable for backward compatibility.
// See: MESOS-4997.
type CapabilityInfo_Capability int32

const (
	CapabilityInfo_UNKNOWN          CapabilityInfo_Capability = 0
	CapabilityInfo_CHOWN            CapabilityInfo_Capability = 1000
	CapabilityInfo_DAC_OVERRIDE     CapabilityInfo_Capability = 1001
	CapabilityInfo_DAC_READ_SEARCH  CapabilityInfo_Capability = 1002
	CapabilityInfo_FOWNER           CapabilityInfo_Capability = 1003
	CapabilityInfo_FSETID           CapabilityInfo_Capability = 1004
	CapabilityInfo_KILL             CapabilityInfo_Capability = 1005
	CapabilityInfo_SETGID           CapabilityInfo_Capability = 1006
	CapabilityInfo_SETUID           CapabilityInfo_Capability = 1007
	CapabilityInfo_SETPCAP          CapabilityInfo_Capability = 1008
	CapabilityInfo_LINUX_IMMUTABLE  CapabilityInfo_Capability = 1009
	CapabilityInfo_NET_BIND_SERVICE CapabilityInfo_Capability = 1010
	CapabilityInfo_NET_BROADCAST    CapabilityInfo_Capability = 1011
	CapabilityInfo_NET_ADMIN        CapabilityInfo_Capability = 1012
	CapabilityInfo_NET_RAW          CapabilityInfo_Capability = 1013
	CapabilityInfo_IPC_LOCK         CapabilityInfo_Capability = 1014
	CapabilityInfo_IPC_OWNER        CapabilityInfo_Capability = 1015
	CapabilityInfo_SYS_MODULE       CapabilityInfo_Capability = 1016
	CapabilityInfo_SYS_RAWIO        CapabilityInfo_Capability = 1017
	CapabilityInfo_SYS_CHROOT       CapabilityInfo_Capability = 1018
	CapabilityInfo_SYS_PTRACE       CapabilityInfo_Capability = 1019
	CapabilityInfo_SYS_PACCT        CapabilityInfo_Capability = 1020
	CapabilityInfo_SYS_ADMIN        CapabilityInfo_Capability = 1021
	CapabilityInfo_SYS_BOOT         CapabilityInfo_Capability = 1022
	CapabilityInfo_SYS_NICE         CapabilityInfo_Capability = 1023
	CapabilityInfo_SYS_RESOURCE     CapabilityInfo_Capability = 1024
	CapabilityInfo_SYS_TIME         CapabilityInfo_Capability = 1025
	CapabilityInfo_SYS_TTY_CONFIG   CapabilityInfo_Capability = 1026
	CapabilityInfo_MKNOD            CapabilityInfo_Capability = 1027
	CapabilityInfo_LEASE            CapabilityInfo_Capability = 1028
	CapabilityInfo_AUDIT_WRITE      CapabilityInfo_Capability = 1029
	CapabilityInfo_AUDIT_CONTROL    CapabilityInfo_Capability = 1030
	CapabilityInfo_SETFCAP          CapabilityInfo_Capability = 1031
	CapabilityInfo_MAC_OVERRIDE     CapabilityInfo_Capability = 1032
	CapabilityInfo_MAC_ADMIN        CapabilityInfo_Capability = 1033
	CapabilityInfo_SYSLOG           CapabilityInfo_Capability = 1034
	CapabilityInfo_WAKE_ALARM       CapabilityInfo_Capability = 1035
	CapabilityInfo_BLOCK_SUSPEND    CapabilityInfo_Capability = 1036
	CapabilityInfo_AUDIT_READ       CapabilityInfo_Capability = 1037
)

var CapabilityInfo_Capability_name = map[int32]string{
	0:    "UNKNOWN",
	1000: "CHOWN",
	1001: "DAC_OVERRIDE",
	1002: "DAC_READ_SEARCH",
	1003: "FOWNER",
	1004: "FSETID",
	1005: "KILL",
	1006: "SETGID",
	1007: "SETUID",
	1008: "SETPCAP",
	1009: "LINUX_IMMUTABLE",
	1010: "NET_BIND_SERVICE",
	1011: "NET_BROADCAST",
	1012: "NET_ADMIN",
	1013: "NET_RAW",
	1014: "IPC_LOCK",
	1015: "IPC_OWNER",
	1016: "SYS_MODULE",
	1017: "SYS_RAWIO",
	1018: "SYS_CHROOT",
	1019: "SYS_PTRACE",
	1020: "SYS_PACCT",
	1021: "SYS_ADMIN",
	1022: "SYS_BOOT",
	1023: "SYS_NICE",
	1024: "SYS_RESOURCE",
	1025: "SYS_TIME",
	1026: "SYS_TTY_CONFIG",
	1027: "MKNOD",
	1028: "LEASE",
	1029: "AUDIT_WRITE",
	1030: "AUDIT_CONTROL",
	1031: "SETFCAP",
	1032: "MAC_OVERRIDE",
	1033: "MAC_ADMIN",
	1034: "SYSLOG",
	1035: "WAKE_ALARM",
	1036: "BLOCK_SUSPEND",
	1037: "AUDIT_READ",
}
var CapabilityInfo_Capability_value = map[string]int32{
	"UNKNOWN":          0,
	"CHOWN":            1000,
	"DAC_OVERRIDE":     1001,
	"DAC_READ_SEARCH":  1002,
	"FOWNER":           1003,
	"FSETID":           1004,
	"KILL":             1005,
	"SETGID":           1006,
	"SETUID":           1007,
	"SETPCAP":          1008,
	"LINUX_IMMUTABLE":  1009,
	"NET_BIND_SERVICE": 1010,
	"NET_BROADCAST":    1011,
	"NET_ADMIN":        1012,
	"NET_RAW":          1013,
	"IPC_LOCK":         1014,
	"IPC_OWNER":        1015,
	"SYS_MODULE":       1016,
	"SYS_RAWIO":        1017,
	"SYS_CHROOT":       1018,
	"SYS_PTRACE":       1019,
	"SYS_PACCT":        1020,
	"SYS_ADMIN":        1021,
	"SYS_BOOT":         1022,
	"SYS_NICE":         1023,
	"SYS_RESOURCE":     1024,
	"SYS_TIME":         1025,
	"SYS_TTY_CONFIG":   1026,
	"MKNOD":            1027,
	"LEASE":            1028,
	"AUDIT_WRITE":      1029,
	"AUDIT_CONTROL":    1030,
	"SETFCAP":          1031,
	"MAC_OVERRIDE":     1032,
	"MAC_ADMIN":        1033,
	"SYSLOG":           1034,
	"WAKE_ALARM":       1035,
	"BLOCK_SUSPEND":    1036,
	"AUDIT_READ":       1037,
}

func (x CapabilityInfo_Capability) Enum() *CapabilityInfo_Capability {
	p := new(CapabilityInfo_Capability)
	*p = x
	return p
}
func (x CapabilityInfo_Capability) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(CapabilityInfo_Capability_name, int32(x))
}
func (x *CapabilityInfo_Capability) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CapabilityInfo_Capability_value, data, "CapabilityInfo_Capability")
	if err != nil {
		return err
	}
	*x = CapabilityInfo_Capability(value)
	return nil
}
func (CapabilityInfo_Capability) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{65, 0}
}

type RLimitInfo_RLimit_Type int32

const (
	RLimitInfo_RLimit_UNKNOWN         RLimitInfo_RLimit_Type = 0
	RLimitInfo_RLimit_RLMT_AS         RLimitInfo_RLimit_Type = 1
	RLimitInfo_RLimit_RLMT_CORE       RLimitInfo_RLimit_Type = 2
	RLimitInfo_RLimit_RLMT_CPU        RLimitInfo_RLimit_Type = 3
	RLimitInfo_RLimit_RLMT_DATA       RLimitInfo_RLimit_Type = 4
	RLimitInfo_RLimit_RLMT_FSIZE      RLimitInfo_RLimit_Type = 5
	RLimitInfo_RLimit_RLMT_LOCKS      RLimitInfo_RLimit_Type = 6
	RLimitInfo_RLimit_RLMT_MEMLOCK    RLimitInfo_RLimit_Type = 7
	RLimitInfo_RLimit_RLMT_MSGQUEUE   RLimitInfo_RLimit_Type = 8
	RLimitInfo_RLimit_RLMT_NICE       RLimitInfo_RLimit_Type = 9
	RLimitInfo_RLimit_RLMT_NOFILE     RLimitInfo_RLimit_Type = 10
	RLimitInfo_RLimit_RLMT_NPROC      RLimitInfo_RLimit_Type = 11
	RLimitInfo_RLimit_RLMT_RSS        RLimitInfo_RLimit_Type = 12
	RLimitInfo_RLimit_RLMT_RTPRIO     RLimitInfo_RLimit_Type = 13
	RLimitInfo_RLimit_RLMT_RTTIME     RLimitInfo_RLimit_Type = 14
	RLimitInfo_RLimit_RLMT_SIGPENDING RLimitInfo_RLimit_Type = 15
	RLimitInfo_RLimit_RLMT_STACK      RLimitInfo_RLimit_Type = 16
)

var RLimitInfo_RLimit_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "RLMT_AS",
	2:  "RLMT_CORE",
	3:  "RLMT_CPU",
	4:  "RLMT_DATA",
	5:  "RLMT_FSIZE",
	6:  "RLMT_LOCKS",
	7:  "RLMT_MEMLOCK",
	8:  "RLMT_MSGQUEUE",
	9:  "RLMT_NICE",
	10: "RLMT_NOFILE",
	11: "RLMT_NPROC",
	12: "RLMT_RSS",
	13: "RLMT_RTPRIO",
	14: "RLMT_RTTIME",
	15: "RLMT_SIGPENDING",
	16: "RLMT_STACK",
}
var RLimitInfo_RLimit_Type_value = map[string]int32{
	"UNKNOWN":         0,
	"RLMT_AS":         1,
	"RLMT_CORE":       2,
	"RLMT_CPU":        3,
	"RLMT_DATA":       4,
	"RLMT_FSIZE":      5,
	"RLMT_LOCKS":      6,
	"RLMT_MEMLOCK":    7,
	"RLMT_MSGQUEUE":   8,
	"RLMT_NICE":       9,
	"RLMT_NOFILE":     10,
	"RLMT_NPROC":      11,
	"RLMT_RSS":        12,
	"RLMT_RTPRIO":     13,
	"RLMT_RTTIME":     14,
	"RLMT_SIGPENDING": 15,
	"RLMT_STACK":      16,
}

func (x RLimitInfo_RLimit_Type) Enum() *RLimitInfo_RLimit_Type {
	p := new(RLimitInfo_RLimit_Type)
	*p = x
	return p
}
func (x RLimitInfo_RLimit_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(RLimitInfo_RLimit_Type_name, int32(x))
}
func (x *RLimitInfo_RLimit_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(RLimitInfo_RLimit_Type_value, data, "RLimitInfo_RLimit_Type")
	if err != nil {
		return err
	}
	*x = RLimitInfo_RLimit_Type(value)
	return nil
}
func (RLimitInfo_RLimit_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{67, 0, 0}
}

// All container implementation types.
type ContainerInfo_Type int32

const (
	ContainerInfo_DOCKER ContainerInfo_Type = 1
	ContainerInfo_MESOS  ContainerInfo_Type = 2
)

var ContainerInfo_Type_name = map[int32]string{
	1: "DOCKER",
	2: "MESOS",
}
var ContainerInfo_Type_value = map[string]int32{
	"DOCKER": 1,
	"MESOS":  2,
}

func (x ContainerInfo_Type) Enum() *ContainerInfo_Type {
	p := new(ContainerInfo_Type)
	*p = x
	return p
}
func (x ContainerInfo_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(ContainerInfo_Type_name, int32(x))
}
func (x *ContainerInfo_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerInfo_Type_value, data, "ContainerInfo_Type")
	if err != nil {
		return err
	}
	*x = ContainerInfo_Type(value)
	return nil
}
func (ContainerInfo_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorMesos, []int{69, 0} }

// Network options.
type ContainerInfo_DockerInfo_Network int32

const (
	ContainerInfo_DockerInfo_HOST   ContainerInfo_DockerInfo_Network = 1
	ContainerInfo_DockerInfo_BRIDGE ContainerInfo_DockerInfo_Network = 2
	ContainerInfo_DockerInfo_NONE   ContainerInfo_DockerInfo_Network = 3
	ContainerInfo_DockerInfo_USER   ContainerInfo_DockerInfo_Network = 4
)

var ContainerInfo_DockerInfo_Network_name = map[int32]string{
	1: "HOST",
	2: "BRIDGE",
	3: "NONE",
	4: "USER",
}
var ContainerInfo_DockerInfo_Network_value = map[string]int32{
	"HOST":   1,
	"BRIDGE": 2,
	"NONE":   3,
	"USER":   4,
}

func (x ContainerInfo_DockerInfo_Network) Enum() *ContainerInfo_DockerInfo_Network {
	p := new(ContainerInfo_DockerInfo_Network)
	*p = x
	return p
}
func (x ContainerInfo_DockerInfo_Network) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(ContainerInfo_DockerInfo_Network_name, int32(x))
}
func (x *ContainerInfo_DockerInfo_Network) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerInfo_DockerInfo_Network_value, data, "ContainerInfo_DockerInfo_Network")
	if err != nil {
		return err
	}
	*x = ContainerInfo_DockerInfo_Network(value)
	return nil
}
func (ContainerInfo_DockerInfo_Network) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{69, 0, 0}
}

type CgroupInfo_Blkio_Operation int32

const (
	CgroupInfo_Blkio_UNKNOWN CgroupInfo_Blkio_Operation = 0
	CgroupInfo_Blkio_TOTAL   CgroupInfo_Blkio_Operation = 1
	CgroupInfo_Blkio_READ    CgroupInfo_Blkio_Operation = 2
	CgroupInfo_Blkio_WRITE   CgroupInfo_Blkio_Operation = 3
	CgroupInfo_Blkio_SYNC    CgroupInfo_Blkio_Operation = 4
	CgroupInfo_Blkio_ASYNC   CgroupInfo_Blkio_Operation = 5
)

var CgroupInfo_Blkio_Operation_name = map[int32]string{
	0: "UNKNOWN",
	1: "TOTAL",
	2: "READ",
	3: "WRITE",
	4: "SYNC",
	5: "ASYNC",
}
var CgroupInfo_Blkio_Operation_value = map[string]int32{
	"UNKNOWN": 0,
	"TOTAL":   1,
	"READ":    2,
	"WRITE":   3,
	"SYNC":    4,
	"ASYNC":   5,
}

func (x CgroupInfo_Blkio_Operation) Enum() *CgroupInfo_Blkio_Operation {
	p := new(CgroupInfo_Blkio_Operation)
	*p = x
	return p
}
func (x CgroupInfo_Blkio_Operation) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(CgroupInfo_Blkio_Operation_name, int32(x))
}
func (x *CgroupInfo_Blkio_Operation) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CgroupInfo_Blkio_Operation_value, data, "CgroupInfo_Blkio_Operation")
	if err != nil {
		return err
	}
	*x = CgroupInfo_Blkio_Operation(value)
	return nil
}
func (CgroupInfo_Blkio_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{71, 0, 0}
}

type DiscoveryInfo_Visibility int32

const (
	FRAMEWORK DiscoveryInfo_Visibility = 0
	CLUSTER   DiscoveryInfo_Visibility = 1
	EXTERNAL  DiscoveryInfo_Visibility = 2
)

var DiscoveryInfo_Visibility_name = map[int32]string{
	0: "FRAMEWORK",
	1: "CLUSTER",
	2: "EXTERNAL",
}
var DiscoveryInfo_Visibility_value = map[string]int32{
	"FRAMEWORK": 0,
	"CLUSTER":   1,
	"EXTERNAL":  2,
}

func (x DiscoveryInfo_Visibility) Enum() *DiscoveryInfo_Visibility {
	p := new(DiscoveryInfo_Visibility)
	*p = x
	return p
}
func (x DiscoveryInfo_Visibility) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(DiscoveryInfo_Visibility_name, int32(x))
}
func (x *DiscoveryInfo_Visibility) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DiscoveryInfo_Visibility_value, data, "DiscoveryInfo_Visibility")
	if err != nil {
		return err
	}
	*x = DiscoveryInfo_Visibility(value)
	return nil
}
func (DiscoveryInfo_Visibility) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{76, 0}
}

// *
// A unique ID assigned to a framework. A framework can reuse this ID
// in order to do failover (see MesosSchedulerDriver).
type FrameworkID struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *FrameworkID) Reset()                    { *m = FrameworkID{} }
func (*FrameworkID) ProtoMessage()               {}
func (*FrameworkID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{0} }

func (m *FrameworkID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// A unique ID assigned to an offer.
type OfferID struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *OfferID) Reset()                    { *m = OfferID{} }
func (*OfferID) ProtoMessage()               {}
func (*OfferID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{1} }

func (m *OfferID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// A unique ID assigned to an agent. Currently, an agent gets a new ID
// whenever it (re)registers with Mesos. Framework writers shouldn't
// assume any binding between an agent ID and and a hostname.
type AgentID struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *AgentID) Reset()                    { *m = AgentID{} }
func (*AgentID) ProtoMessage()               {}
func (*AgentID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{2} }

func (m *AgentID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// A framework-generated ID to distinguish a task. The ID must remain
// unique while the task is active. A framework can reuse an ID _only_
// if the previous task with the same ID has reached a terminal state
// (e.g., TASK_FINISHED, TASK_KILLED, etc.). However, reusing task IDs
// is strongly discouraged (MESOS-2198).
type TaskID struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *TaskID) Reset()                    { *m = TaskID{} }
func (*TaskID) ProtoMessage()               {}
func (*TaskID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{3} }

func (m *TaskID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// A framework-generated ID to distinguish an executor. Only one
// executor with the same ID can be active on the same agent at a
// time. However, reusing executor IDs is discouraged.
type ExecutorID struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *ExecutorID) Reset()                    { *m = ExecutorID{} }
func (*ExecutorID) ProtoMessage()               {}
func (*ExecutorID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{4} }

func (m *ExecutorID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// ID used to uniquely identify a container. If the `parent` is not
// specified, the ID is a UUID generated by the agent to uniquely
// identify the container of an executor run. If the `parent` field is
// specified, it represents a nested container.
type ContainerID struct {
	Value  string       `protobuf:"bytes,1,req,name=value" json:"value"`
	Parent *ContainerID `protobuf:"bytes,2,opt,name=parent" json:"parent,omitempty"`
}

func (m *ContainerID) Reset()                    { *m = ContainerID{} }
func (*ContainerID) ProtoMessage()               {}
func (*ContainerID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{5} }

func (m *ContainerID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *ContainerID) GetParent() *ContainerID {
	if m != nil {
		return m.Parent
	}
	return nil
}

// *
// A unique ID assigned to a resource provider. Currently, a resource
// provider gets a new ID whenever it (re)registers with Mesos.
type ResourceProviderID struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *ResourceProviderID) Reset()                    { *m = ResourceProviderID{} }
func (*ResourceProviderID) ProtoMessage()               {}
func (*ResourceProviderID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{6} }

func (m *ResourceProviderID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// A framework-generated ID to distinguish an operation. The ID
// must be unique within the framework.
type OperationID struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *OperationID) Reset()                    { *m = OperationID{} }
func (*OperationID) ProtoMessage()               {}
func (*OperationID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{7} }

func (m *OperationID) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// Represents time since the epoch, in nanoseconds.
type TimeInfo struct {
	Nanoseconds int64 `protobuf:"varint,1,req,name=nanoseconds" json:"nanoseconds"`
}

func (m *TimeInfo) Reset()                    { *m = TimeInfo{} }
func (*TimeInfo) ProtoMessage()               {}
func (*TimeInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{8} }

func (m *TimeInfo) GetNanoseconds() int64 {
	if m != nil {
		return m.Nanoseconds
	}
	return 0
}

// *
// Represents duration in nanoseconds.
type DurationInfo struct {
	Nanoseconds int64 `protobuf:"varint,1,req,name=nanoseconds" json:"nanoseconds"`
}

func (m *DurationInfo) Reset()                    { *m = DurationInfo{} }
func (*DurationInfo) ProtoMessage()               {}
func (*DurationInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{9} }

func (m *DurationInfo) GetNanoseconds() int64 {
	if m != nil {
		return m.Nanoseconds
	}
	return 0
}

// *
// A network address.
//
// TODO(bmahler): Use this more widely.
type Address struct {
	// May contain a hostname, IP address, or both.
	Hostname *string `protobuf:"bytes,1,opt,name=hostname" json:"hostname,omitempty"`
	IP       *string `protobuf:"bytes,2,opt,name=ip" json:"ip,omitempty"`
	Port     int32   `protobuf:"varint,3,req,name=port" json:"port"`
}

func (m *Address) Reset()                    { *m = Address{} }
func (*Address) ProtoMessage()               {}
func (*Address) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{10} }

func (m *Address) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *Address) GetIP() string {
	if m != nil && m.IP != nil {
		return *m.IP
	}
	return ""
}

func (m *Address) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// *
// Represents a URL.
type URL struct {
	Scheme   string      `protobuf:"bytes,1,req,name=scheme" json:"scheme"`
	Address  Address     `protobuf:"bytes,2,req,name=address" json:"address"`
	Path     *string     `protobuf:"bytes,3,opt,name=path" json:"path,omitempty"`
	Query    []Parameter `protobuf:"bytes,4,rep,name=query" json:"query"`
	Fragment *string     `protobuf:"bytes,5,opt,name=fragment" json:"fragment,omitempty"`
}

func (m *URL) Reset()                    { *m = URL{} }
func (*URL) ProtoMessage()               {}
func (*URL) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{11} }

func (m *URL) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *URL) GetAddress() Address {
	if m != nil {
		return m.Address
	}
	return Address{}
}

func (m *URL) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *URL) GetQuery() []Parameter {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *URL) GetFragment() string {
	if m != nil && m.Fragment != nil {
		return *m.Fragment
	}
	return ""
}

// *
// Represents an interval, from a given start time over a given duration.
// This interval pertains to an unavailability event, such as maintenance,
// and is not a generic interval.
type Unavailability struct {
	Start TimeInfo `protobuf:"bytes,1,req,name=start" json:"start"`
	// When added to `start`, this represents the end of the interval.
	// If unspecified, the duration is assumed to be infinite.
	Duration *DurationInfo `protobuf:"bytes,2,opt,name=duration" json:"duration,omitempty"`
}

func (m *Unavailability) Reset()                    { *m = Unavailability{} }
func (*Unavailability) ProtoMessage()               {}
func (*Unavailability) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{12} }

func (m *Unavailability) GetStart() TimeInfo {
	if m != nil {
		return m.Start
	}
	return TimeInfo{}
}

func (m *Unavailability) GetDuration() *DurationInfo {
	if m != nil {
		return m.Duration
	}
	return nil
}

// *
// Represents a single machine, which may hold one or more agents.
//
// NOTE: In order to match an agent to a machine, both the `hostname` and
// `ip` must match the values advertised by the agent to the master.
// Hostname is not case-sensitive.
type MachineID struct {
	Hostname *string `protobuf:"bytes,1,opt,name=hostname" json:"hostname,omitempty"`
	IP       *string `protobuf:"bytes,2,opt,name=ip" json:"ip,omitempty"`
}

func (m *MachineID) Reset()                    { *m = MachineID{} }
func (*MachineID) ProtoMessage()               {}
func (*MachineID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{13} }

func (m *MachineID) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *MachineID) GetIP() string {
	if m != nil && m.IP != nil {
		return *m.IP
	}
	return ""
}

// *
// Holds information about a single machine, its `mode`, and any other
// relevant information which may affect the behavior of the machine.
type MachineInfo struct {
	ID   MachineID         `protobuf:"bytes,1,req,name=id" json:"id"`
	Mode *MachineInfo_Mode `protobuf:"varint,2,opt,name=mode,enum=mesos.MachineInfo_Mode" json:"mode,omitempty"`
	// Signifies that the machine may be unavailable during the given interval.
	// See comments in `Unavailability` and for the `unavailability` fields
	// in `Offer` and `InverseOffer` for more information.
	Unavailability *Unavailability `protobuf:"bytes,3,opt,name=unavailability" json:"unavailability,omitempty"`
}

func (m *MachineInfo) Reset()                    { *m = MachineInfo{} }
func (*MachineInfo) ProtoMessage()               {}
func (*MachineInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{14} }

func (m *MachineInfo) GetID() MachineID {
	if m != nil {
		return m.ID
	}
	return MachineID{}
}

func (m *MachineInfo) GetMode() MachineInfo_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return UP
}

func (m *MachineInfo) GetUnavailability() *Unavailability {
	if m != nil {
		return m.Unavailability
	}
	return nil
}

// *
// Describes a framework.
type FrameworkInfo struct {
	// Used to determine the Unix user that an executor or task should be
	// launched as.
	//
	// When using the MesosSchedulerDriver, if the field is set to an
	// empty string, it will automagically set it to the current user.
	//
	// When using the HTTP Scheduler API, the user has to be set
	// explicitly.
	User string `protobuf:"bytes,1,req,name=user" json:"user"`
	// Name of the framework that shows up in the Mesos Web UI.
	Name string `protobuf:"bytes,2,req,name=name" json:"name"`
	// Note that 'id' is only available after a framework has
	// registered, however, it is included here in order to facilitate
	// scheduler failover (i.e., if it is set then the
	// MesosSchedulerDriver expects the scheduler is performing
	// failover).
	ID *FrameworkID `protobuf:"bytes,3,opt,name=id" json:"id,omitempty"`
	// The amount of time (in seconds) that the master will wait for the
	// scheduler to failover before it tears down the framework by
	// killing all its tasks/executors. This should be non-zero if a
	// framework expects to reconnect after a failure and not lose its
	// tasks/executors.
	//
	// NOTE: To avoid accidental destruction of tasks, production
	// frameworks typically set this to a large value (e.g., 1 week).
	FailoverTimeout *float64 `protobuf:"fixed64,4,opt,name=failover_timeout,json=failoverTimeout,def=0" json:"failover_timeout,omitempty"`
	// If set, agents running tasks started by this framework will write
	// the framework pid, executor pids and status updates to disk. If
	// the agent exits (e.g., due to a crash or as part of upgrading
	// Mesos), this checkpointed data allows the restarted agent to
	// reconnect to executors that were started by the old instance of
	// the agent. Enabling checkpointing improves fault tolerance, at
	// the cost of a (usually small) increase in disk I/O.
	Checkpoint *bool `protobuf:"varint,5,opt,name=checkpoint,def=0" json:"checkpoint,omitempty"`
	// Roles are the entities to which allocations are made.
	// The framework must have at least one role in order to
	// be offered resources. Note that `role` is deprecated
	// in favor of `roles` and only one of these fields must
	// be used. Since we cannot distinguish between empty
	// `roles` and the default unset `role`, we require that
	// frameworks set the `MULTI_ROLE` capability if
	// setting the `roles` field.
	Role  *string  `protobuf:"bytes,6,opt,name=role,def=*" json:"role,omitempty"`
	Roles []string `protobuf:"bytes,12,rep,name=roles" json:"roles,omitempty"`
	// Used to indicate the current host from which the scheduler is
	// registered in the Mesos Web UI. If set to an empty string Mesos
	// will automagically set it to the current hostname if one is
	// available.
	Hostname *string `protobuf:"bytes,7,opt,name=hostname" json:"hostname,omitempty"`
	// This field should match the credential's principal the framework
	// uses for authentication. This field is used for framework API
	// rate limiting and dynamic reservations. It should be set even
	// if authentication is not enabled if these features are desired.
	Principal *string `protobuf:"bytes,8,opt,name=principal" json:"principal,omitempty"`
	// This field allows a framework to advertise its web UI, so that
	// the Mesos web UI can link to it. It is expected to be a full URL,
	// for example http://my-scheduler.example.com:8080/.
	WebUiURL *string `protobuf:"bytes,9,opt,name=webui_url,json=webuiUrl" json:"webui_url,omitempty"`
	// This field allows a framework to advertise its set of
	// capabilities (e.g., ability to receive offers for revocable
	// resources).
	Capabilities []FrameworkInfo_Capability `protobuf:"bytes,10,rep,name=capabilities" json:"capabilities"`
	// Labels are free-form key value pairs supplied by the framework
	// scheduler (e.g., to describe additional functionality offered by
	// the framework). These labels are not interpreted by Mesos itself.
	// Labels should not contain duplicate key-value pairs.
	Labels *Labels `protobuf:"bytes,11,opt,name=labels" json:"labels,omitempty"`
}

func (m *FrameworkInfo) Reset()                    { *m = FrameworkInfo{} }
func (*FrameworkInfo) ProtoMessage()               {}
func (*FrameworkInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{15} }

const Default_FrameworkInfo_FailoverTimeout float64 = 0
const Default_FrameworkInfo_Checkpoint bool = false
const Default_FrameworkInfo_Role string = "*"

func (m *FrameworkInfo) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *FrameworkInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FrameworkInfo) GetID() *FrameworkID {
	if m != nil {
		return m.ID
	}
	return nil
}

func (m *FrameworkInfo) GetFailoverTimeout() float64 {
	if m != nil && m.FailoverTimeout != nil {
		return *m.FailoverTimeout
	}
	return Default_FrameworkInfo_FailoverTimeout
}

func (m *FrameworkInfo) GetCheckpoint() bool {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return Default_FrameworkInfo_Checkpoint
}

func (m *FrameworkInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return Default_FrameworkInfo_Role
}

func (m *FrameworkInfo) GetRoles() []string {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *FrameworkInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *FrameworkInfo) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *FrameworkInfo) GetWebUiURL() string {
	if m != nil && m.WebUiURL != nil {
		return *m.WebUiURL
	}
	return ""
}

func (m *FrameworkInfo) GetCapabilities() []FrameworkInfo_Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *FrameworkInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

type FrameworkInfo_Capability struct {
	// Enum fields should be optional, see: MESOS-4997.
	Type FrameworkInfo_Capability_Type `protobuf:"varint,1,opt,name=type,enum=mesos.FrameworkInfo_Capability_Type" json:"type"`
}

func (m *FrameworkInfo_Capability) Reset()      { *m = FrameworkInfo_Capability{} }
func (*FrameworkInfo_Capability) ProtoMessage() {}
func (*FrameworkInfo_Capability) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{15, 0}
}

func (m *FrameworkInfo_Capability) GetType() FrameworkInfo_Capability_Type {
	if m != nil {
		return m.Type
	}
	return FrameworkInfo_Capability_UNKNOWN
}

// *
// Describes a general non-interpreting non-killing check for a task or
// executor (or any arbitrary process/command). A type is picked by
// specifying one of the optional fields. Specifying more than one type
// is an error.
//
// NOTE: This API is unstable and the related feature is experimental.
type CheckInfo struct {
	// The type of the check.
	Type CheckInfo_Type `protobuf:"varint,1,opt,name=type,enum=mesos.CheckInfo_Type" json:"type"`
	// Command check.
	Command *CheckInfo_Command `protobuf:"bytes,2,opt,name=command" json:"command,omitempty"`
	// HTTP check.
	HTTP *CheckInfo_Http `protobuf:"bytes,3,opt,name=http" json:"http,omitempty"`
	// TCP check.
	TCP *CheckInfo_Tcp `protobuf:"bytes,7,opt,name=tcp" json:"tcp,omitempty"`
	// Amount of time to wait to start checking the task after it
	// transitions to `TASK_RUNNING` or `TASK_STARTING` if the latter
	// is used by the executor.
	DelaySeconds *float64 `protobuf:"fixed64,4,opt,name=delay_seconds,json=delaySeconds,def=15" json:"delay_seconds,omitempty"`
	// Interval between check attempts, i.e., amount of time to wait after
	// the previous check finished or timed out to start the next check.
	IntervalSeconds *float64 `protobuf:"fixed64,5,opt,name=interval_seconds,json=intervalSeconds,def=10" json:"interval_seconds,omitempty"`
	// Amount of time to wait for the check to complete. Zero means infinite
	// timeout.
	//
	// After this timeout, the check attempt is aborted and no result is
	// reported. Note that this may be considered a state change and hence
	// may trigger a check status change delivery to the corresponding
	// scheduler. See `CheckStatusInfo` for more details.
	TimeoutSeconds *float64 `protobuf:"fixed64,6,opt,name=timeout_seconds,json=timeoutSeconds,def=20" json:"timeout_seconds,omitempty"`
}

func (m *CheckInfo) Reset()                    { *m = CheckInfo{} }
func (*CheckInfo) ProtoMessage()               {}
func (*CheckInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{16} }

const Default_CheckInfo_DelaySeconds float64 = 15
const Default_CheckInfo_IntervalSeconds float64 = 10
const Default_CheckInfo_TimeoutSeconds float64 = 20

func (m *CheckInfo) GetType() CheckInfo_Type {
	if m != nil {
		return m.Type
	}
	return CheckInfo_UNKNOWN
}

func (m *CheckInfo) GetCommand() *CheckInfo_Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *CheckInfo) GetHTTP() *CheckInfo_Http {
	if m != nil {
		return m.HTTP
	}
	return nil
}

func (m *CheckInfo) GetTCP() *CheckInfo_Tcp {
	if m != nil {
		return m.TCP
	}
	return nil
}

func (m *CheckInfo) GetDelaySeconds() float64 {
	if m != nil && m.DelaySeconds != nil {
		return *m.DelaySeconds
	}
	return Default_CheckInfo_DelaySeconds
}

func (m *CheckInfo) GetIntervalSeconds() float64 {
	if m != nil && m.IntervalSeconds != nil {
		return *m.IntervalSeconds
	}
	return Default_CheckInfo_IntervalSeconds
}

func (m *CheckInfo) GetTimeoutSeconds() float64 {
	if m != nil && m.TimeoutSeconds != nil {
		return *m.TimeoutSeconds
	}
	return Default_CheckInfo_TimeoutSeconds
}

// Describes a command check. If applicable, enters mount and/or network
// namespaces of the task.
type CheckInfo_Command struct {
	Command CommandInfo `protobuf:"bytes,1,req,name=command" json:"command"`
}

func (m *CheckInfo_Command) Reset()                    { *m = CheckInfo_Command{} }
func (*CheckInfo_Command) ProtoMessage()               {}
func (*CheckInfo_Command) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{16, 0} }

func (m *CheckInfo_Command) GetCommand() CommandInfo {
	if m != nil {
		return m.Command
	}
	return CommandInfo{}
}

// Describes an HTTP check. Sends a GET request to
// http://<host>:port/path. Note that <host> is not configurable and is
// resolved automatically to 127.0.0.1.
type CheckInfo_Http struct {
	// Port to send the HTTP request.
	Port uint32 `protobuf:"varint,1,req,name=port" json:"port"`
	// HTTP request path.
	Path *string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
}

func (m *CheckInfo_Http) Reset()                    { *m = CheckInfo_Http{} }
func (*CheckInfo_Http) ProtoMessage()               {}
func (*CheckInfo_Http) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{16, 1} }

func (m *CheckInfo_Http) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *CheckInfo_Http) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

// Describes a TCP check, i.e. based on establishing a TCP connection to
// the specified port. Note that <host> is not configurable and is resolved
// automatically to 127.0.0.1.
type CheckInfo_Tcp struct {
	Port uint32 `protobuf:"varint,1,req,name=port" json:"port"`
}

func (m *CheckInfo_Tcp) Reset()                    { *m = CheckInfo_Tcp{} }
func (*CheckInfo_Tcp) ProtoMessage()               {}
func (*CheckInfo_Tcp) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{16, 2} }

func (m *CheckInfo_Tcp) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// *
// Describes a health check for a task or executor (or any arbitrary
// process/command). A type is picked by specifying one of the
// optional fields. Specifying more than one type is an error.
type HealthCheck struct {
	// Amount of time to wait to start health checking the task after it
	// transitions to `TASK_RUNNING` or `TASK_STATING` if the latter is
	// used by the executor.
	DelaySeconds *float64 `protobuf:"fixed64,2,opt,name=delay_seconds,json=delaySeconds,def=15" json:"delay_seconds,omitempty"`
	// Interval between health checks, i.e., amount of time to wait after
	// the previous health check finished or timed out to start the next
	// health check.
	IntervalSeconds *float64 `protobuf:"fixed64,3,opt,name=interval_seconds,json=intervalSeconds,def=10" json:"interval_seconds,omitempty"`
	// Amount of time to wait for the health check to complete. After this
	// timeout, the health check is aborted and treated as a failure. Zero
	// means infinite timeout.
	TimeoutSeconds *float64 `protobuf:"fixed64,4,opt,name=timeout_seconds,json=timeoutSeconds,def=20" json:"timeout_seconds,omitempty"`
	// Number of consecutive failures until the task is killed by the executor.
	ConsecutiveFailures *uint32 `protobuf:"varint,5,opt,name=consecutive_failures,json=consecutiveFailures,def=3" json:"consecutive_failures,omitempty"`
	// Amount of time after the task is launched during which health check
	// failures are ignored. Once a check succeeds for the first time,
	// the grace period does not apply anymore. Note that it includes
	// `delay_seconds`, i.e., setting `grace_period_seconds` < `delay_seconds`
	// has no effect.
	GracePeriodSeconds *float64 `protobuf:"fixed64,6,opt,name=grace_period_seconds,json=gracePeriodSeconds,def=10" json:"grace_period_seconds,omitempty"`
	// The type of health check.
	Type HealthCheck_Type `protobuf:"varint,8,opt,name=type,enum=mesos.HealthCheck_Type" json:"type"`
	// Command health check.
	Command *CommandInfo `protobuf:"bytes,7,opt,name=command" json:"command,omitempty"`
	// HTTP health check.
	HTTP *HealthCheck_HTTPCheckInfo `protobuf:"bytes,1,opt,name=http" json:"http,omitempty"`
	// TCP health check.
	TCP *HealthCheck_TCPCheckInfo `protobuf:"bytes,9,opt,name=tcp" json:"tcp,omitempty"`
}

func (m *HealthCheck) Reset()                    { *m = HealthCheck{} }
func (*HealthCheck) ProtoMessage()               {}
func (*HealthCheck) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{17} }

const Default_HealthCheck_DelaySeconds float64 = 15
const Default_HealthCheck_IntervalSeconds float64 = 10
const Default_HealthCheck_TimeoutSeconds float64 = 20
const Default_HealthCheck_ConsecutiveFailures uint32 = 3
const Default_HealthCheck_GracePeriodSeconds float64 = 10

func (m *HealthCheck) GetDelaySeconds() float64 {
	if m != nil && m.DelaySeconds != nil {
		return *m.DelaySeconds
	}
	return Default_HealthCheck_DelaySeconds
}

func (m *HealthCheck) GetIntervalSeconds() float64 {
	if m != nil && m.IntervalSeconds != nil {
		return *m.IntervalSeconds
	}
	return Default_HealthCheck_IntervalSeconds
}

func (m *HealthCheck) GetTimeoutSeconds() float64 {
	if m != nil && m.TimeoutSeconds != nil {
		return *m.TimeoutSeconds
	}
	return Default_HealthCheck_TimeoutSeconds
}

func (m *HealthCheck) GetConsecutiveFailures() uint32 {
	if m != nil && m.ConsecutiveFailures != nil {
		return *m.ConsecutiveFailures
	}
	return Default_HealthCheck_ConsecutiveFailures
}

func (m *HealthCheck) GetGracePeriodSeconds() float64 {
	if m != nil && m.GracePeriodSeconds != nil {
		return *m.GracePeriodSeconds
	}
	return Default_HealthCheck_GracePeriodSeconds
}

func (m *HealthCheck) GetType() HealthCheck_Type {
	if m != nil {
		return m.Type
	}
	return HealthCheck_UNKNOWN
}

func (m *HealthCheck) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *HealthCheck) GetHTTP() *HealthCheck_HTTPCheckInfo {
	if m != nil {
		return m.HTTP
	}
	return nil
}

func (m *HealthCheck) GetTCP() *HealthCheck_TCPCheckInfo {
	if m != nil {
		return m.TCP
	}
	return nil
}

// Describes an HTTP health check. Sends a GET request to
// scheme://<host>:port/path. Note that <host> is not configurable and is
// resolved automatically, in most cases to 127.0.0.1. Default executors
// treat return codes between 200 and 399 as success; custom executors
// may employ a different strategy, e.g. leveraging the `statuses` field.
type HealthCheck_HTTPCheckInfo struct {
	Protocol *NetworkInfo_Protocol `protobuf:"varint,5,opt,name=protocol,enum=mesos.NetworkInfo_Protocol,def=1" json:"protocol,omitempty"`
	// Currently "http" and "https" are supported.
	Scheme *string `protobuf:"bytes,3,opt,name=scheme" json:"scheme,omitempty"`
	// Port to send the HTTP request.
	Port uint32 `protobuf:"varint,1,req,name=port" json:"port"`
	// HTTP request path.
	Path *string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// NOTE: It is up to the custom executor to interpret and act on this
	// field. Setting this field has no effect on the default executors.
	//
	// TODO(haosdent): Deprecate this field when we add better support for
	// success and possibly failure statuses, e.g. ranges of success and
	// failure statuses.
	Statuses []uint32 `protobuf:"varint,4,rep,name=statuses" json:"statuses,omitempty"`
}

func (m *HealthCheck_HTTPCheckInfo) Reset()      { *m = HealthCheck_HTTPCheckInfo{} }
func (*HealthCheck_HTTPCheckInfo) ProtoMessage() {}
func (*HealthCheck_HTTPCheckInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{17, 0}
}

const Default_HealthCheck_HTTPCheckInfo_Protocol NetworkInfo_Protocol = IPv4

func (m *HealthCheck_HTTPCheckInfo) GetProtocol() NetworkInfo_Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return Default_HealthCheck_HTTPCheckInfo_Protocol
}

func (m *HealthCheck_HTTPCheckInfo) GetScheme() string {
	if m != nil && m.Scheme != nil {
		return *m.Scheme
	}
	return ""
}

func (m *HealthCheck_HTTPCheckInfo) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *HealthCheck_HTTPCheckInfo) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *HealthCheck_HTTPCheckInfo) GetStatuses() []uint32 {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// Describes a TCP health check, i.e. based on establishing
// a TCP connection to the specified port.
type HealthCheck_TCPCheckInfo struct {
	Protocol *NetworkInfo_Protocol `protobuf:"varint,2,opt,name=protocol,enum=mesos.NetworkInfo_Protocol,def=1" json:"protocol,omitempty"`
	// Port expected to be open.
	Port uint32 `protobuf:"varint,1,req,name=port" json:"port"`
}

func (m *HealthCheck_TCPCheckInfo) Reset()      { *m = HealthCheck_TCPCheckInfo{} }
func (*HealthCheck_TCPCheckInfo) ProtoMessage() {}
func (*HealthCheck_TCPCheckInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{17, 1}
}

const Default_HealthCheck_TCPCheckInfo_Protocol NetworkInfo_Protocol = IPv4

func (m *HealthCheck_TCPCheckInfo) GetProtocol() NetworkInfo_Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return Default_HealthCheck_TCPCheckInfo_Protocol
}

func (m *HealthCheck_TCPCheckInfo) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// *
// Describes a kill policy for a task. Currently does not express
// different policies (e.g. hitting HTTP endpoints), only controls
// how long to wait between graceful and forcible task kill:
//
//     graceful kill --------------> forcible kill
//                    grace_period
//
// Kill policies are best-effort, because machine failures / forcible
// terminations may occur.
//
// NOTE: For executor-less command-based tasks, the kill is performed
// via sending a signal to the task process: SIGTERM for the graceful
// kill and SIGKILL for the forcible kill. For the docker executor-less
// tasks the grace period is passed to 'docker stop --time'.
type KillPolicy struct {
	// The grace period specifies how long to wait before forcibly
	// killing the task. It is recommended to attempt to gracefully
	// kill the task (and send TASK_KILLING) to indicate that the
	// graceful kill is in progress. Once the grace period elapses,
	// if the task has not terminated, a forcible kill should occur.
	// The task should not assume that it will always be allotted
	// the full grace period. For example, the executor may be
	// shutdown more quickly by the agent, or failures / forcible
	// terminations may occur.
	GracePeriod *DurationInfo `protobuf:"bytes,1,opt,name=grace_period,json=gracePeriod" json:"grace_period,omitempty"`
}

func (m *KillPolicy) Reset()                    { *m = KillPolicy{} }
func (*KillPolicy) ProtoMessage()               {}
func (*KillPolicy) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{18} }

func (m *KillPolicy) GetGracePeriod() *DurationInfo {
	if m != nil {
		return m.GracePeriod
	}
	return nil
}

// *
// Describes a command, executed via: '/bin/sh -c value'. Any URIs specified
// are fetched before executing the command.  If the executable field for an
// uri is set, executable file permission is set on the downloaded file.
// Otherwise, if the downloaded file has a recognized archive extension
// (currently [compressed] tar and zip) it is extracted into the executor's
// working directory. This extraction can be disabled by setting `extract` to
// false. In addition, any environment variables are set before executing
// the command (so they can be used to "parameterize" your command).
type CommandInfo struct {
	URIs        []CommandInfo_URI `protobuf:"bytes,1,rep,name=uris" json:"uris"`
	Environment *Environment      `protobuf:"bytes,2,opt,name=environment" json:"environment,omitempty"`
	// There are two ways to specify the command:
	// 1) If 'shell == true', the command will be launched via shell
	// 		(i.e., /bin/sh -c 'value'). The 'value' specified will be
	// 		treated as the shell command. The 'arguments' will be ignored.
	// 2) If 'shell == false', the command will be launched by passing
	// 		arguments to an executable. The 'value' specified will be
	// 		treated as the filename of the executable. The 'arguments'
	// 		will be treated as the arguments to the executable. This is
	// 		similar to how POSIX exec families launch processes (i.e.,
	// 		execlp(value, arguments(0), arguments(1), ...)).
	// NOTE: The field 'value' is changed from 'required' to 'optional'
	// in 0.20.0. It will only cause issues if a new framework is
	// connecting to an old master.
	Shell     *bool    `protobuf:"varint,6,opt,name=shell,def=1" json:"shell,omitempty"`
	Value     *string  `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
	Arguments []string `protobuf:"bytes,7,rep,name=arguments" json:"arguments,omitempty"`
	// Enables executor and tasks to run as a specific user. If the user
	// field is present both in FrameworkInfo and here, the CommandInfo
	// user value takes precedence.
	User *string `protobuf:"bytes,5,opt,name=user" json:"user,omitempty"`
}

func (m *CommandInfo) Reset()                    { *m = CommandInfo{} }
func (*CommandInfo) ProtoMessage()               {}
func (*CommandInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{19} }

const Default_CommandInfo_Shell bool = true

func (m *CommandInfo) GetURIs() []CommandInfo_URI {
	if m != nil {
		return m.URIs
	}
	return nil
}

func (m *CommandInfo) GetEnvironment() *Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (m *CommandInfo) GetShell() bool {
	if m != nil && m.Shell != nil {
		return *m.Shell
	}
	return Default_CommandInfo_Shell
}

func (m *CommandInfo) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *CommandInfo) GetArguments() []string {
	if m != nil {
		return m.Arguments
	}
	return nil
}

func (m *CommandInfo) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

type CommandInfo_URI struct {
	Value      string `protobuf:"bytes,1,req,name=value" json:"value"`
	Executable *bool  `protobuf:"varint,2,opt,name=executable" json:"executable,omitempty"`
	// In case the fetched file is recognized as an archive, extract
	// its contents into the sandbox. Note that a cached archive is
	// not copied from the cache to the sandbox in case extraction
	// originates from an archive in the cache.
	Extract *bool `protobuf:"varint,3,opt,name=extract,def=1" json:"extract,omitempty"`
	// If this field is "true", the fetcher cache will be used. If not,
	// fetching bypasses the cache and downloads directly into the
	// sandbox directory, no matter whether a suitable cache file is
	// available or not. The former directs the fetcher to download to
	// the file cache, then copy from there to the sandbox. Subsequent
	// fetch attempts with the same URI will omit downloading and copy
	// from the cache as long as the file is resident there. Cache files
	// may get evicted at any time, which then leads to renewed
	// downloading. See also "docs/fetcher.md" and
	// "docs/fetcher-cache-internals.md".
	Cache *bool `protobuf:"varint,4,opt,name=cache" json:"cache,omitempty"`
	// The fetcher's default behavior is to use the URI string's basename to
	// name the local copy. If this field is provided, the local copy will be
	// named with its value instead. If there is a directory component (which
	// must be a relative path), the local copy will be stored in that
	// subdirectory inside the sandbox.
	OutputFile *string `protobuf:"bytes,5,opt,name=output_file,json=outputFile" json:"output_file,omitempty"`
}

func (m *CommandInfo_URI) Reset()                    { *m = CommandInfo_URI{} }
func (*CommandInfo_URI) ProtoMessage()               {}
func (*CommandInfo_URI) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{19, 0} }

const Default_CommandInfo_URI_Extract bool = true

func (m *CommandInfo_URI) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *CommandInfo_URI) GetExecutable() bool {
	if m != nil && m.Executable != nil {
		return *m.Executable
	}
	return false
}

func (m *CommandInfo_URI) GetExtract() bool {
	if m != nil && m.Extract != nil {
		return *m.Extract
	}
	return Default_CommandInfo_URI_Extract
}

func (m *CommandInfo_URI) GetCache() bool {
	if m != nil && m.Cache != nil {
		return *m.Cache
	}
	return false
}

func (m *CommandInfo_URI) GetOutputFile() string {
	if m != nil && m.OutputFile != nil {
		return *m.OutputFile
	}
	return ""
}

// *
// Describes information about an executor.
type ExecutorInfo struct {
	// For backwards compatibility, if this field is not set when using `LAUNCH`
	// operation, Mesos will infer the type by checking if `command` is set
	// (`CUSTOM`) or unset (`DEFAULT`). `type` must be set when using
	// `LAUNCH_GROUP` operation.
	//
	// TODO(vinod): Add support for explicitly setting `type` to `DEFAULT` in
	// `LAUNCH` operation.
	Type        ExecutorInfo_Type `protobuf:"varint,15,opt,name=type,enum=mesos.ExecutorInfo_Type" json:"type"`
	ExecutorID  ExecutorID        `protobuf:"bytes,1,req,name=executor_id,json=executorId" json:"executor_id"`
	FrameworkID *FrameworkID      `protobuf:"bytes,8,opt,name=framework_id,json=frameworkId" json:"framework_id,omitempty"`
	Command     *CommandInfo      `protobuf:"bytes,7,opt,name=command" json:"command,omitempty"`
	// Executor provided with a container will launch the container
	// with the executor's CommandInfo and we expect the container to
	// act as a Mesos executor.
	Container *ContainerInfo `protobuf:"bytes,11,opt,name=container" json:"container,omitempty"`
	Resources []Resource     `protobuf:"bytes,5,rep,name=resources" json:"resources"`
	Name      *string        `protobuf:"bytes,9,opt,name=name" json:"name,omitempty"`
	// 'source' is an identifier style string used by frameworks to
	// track the source of an executor. This is useful when it's
	// possible for different executor ids to be related semantically.
	//
	// NOTE: 'source' is exposed alongside the resource usage of the
	// executor via JSON on the agent. This allows users to import usage
	// information into a time series database for monitoring.
	//
	// This field is deprecated since 1.0. Please use labels for
	// free-form metadata instead.
	Source *string `protobuf:"bytes,10,opt,name=source" json:"source,omitempty"`
	// This field can be used to pass arbitrary bytes to an executor.
	Data []byte `protobuf:"bytes,4,opt,name=data" json:"data,omitempty"`
	// Service discovery information for the executor. It is not
	// interpreted or acted upon by Mesos. It is up to a service
	// discovery system to use this information as needed and to handle
	// executors without service discovery information.
	Discovery *DiscoveryInfo `protobuf:"bytes,12,opt,name=discovery" json:"discovery,omitempty"`
	// When shutting down an executor the agent will wait in a
	// best-effort manner for the grace period specified here
	// before forcibly destroying the container. The executor
	// must not assume that it will always be allotted the full
	// grace period, as the agent may decide to allot a shorter
	// period and failures / forcible terminations may occur.
	ShutdownGracePeriod *DurationInfo `protobuf:"bytes,13,opt,name=shutdown_grace_period,json=shutdownGracePeriod" json:"shutdown_grace_period,omitempty"`
	// Labels are free-form key value pairs which are exposed through
	// master and agent endpoints. Labels will not be interpreted or
	// acted upon by Mesos itself. As opposed to the data field, labels
	// will be kept in memory on master and agent processes. Therefore,
	// labels should be used to tag executors with lightweight metadata.
	// Labels should not contain duplicate key-value pairs.
	Labels *Labels `protobuf:"bytes,14,opt,name=labels" json:"labels,omitempty"`
}

func (m *ExecutorInfo) Reset()                    { *m = ExecutorInfo{} }
func (*ExecutorInfo) ProtoMessage()               {}
func (*ExecutorInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{20} }

func (m *ExecutorInfo) GetType() ExecutorInfo_Type {
	if m != nil {
		return m.Type
	}
	return ExecutorInfo_UNKNOWN
}

func (m *ExecutorInfo) GetExecutorID() ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return ExecutorID{}
}

func (m *ExecutorInfo) GetFrameworkID() *FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return nil
}

func (m *ExecutorInfo) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ExecutorInfo) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *ExecutorInfo) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ExecutorInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ExecutorInfo) GetSource() string {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return ""
}

func (m *ExecutorInfo) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ExecutorInfo) GetDiscovery() *DiscoveryInfo {
	if m != nil {
		return m.Discovery
	}
	return nil
}

func (m *ExecutorInfo) GetShutdownGracePeriod() *DurationInfo {
	if m != nil {
		return m.ShutdownGracePeriod
	}
	return nil
}

func (m *ExecutorInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

// *
// Describes a domain. A domain is a collection of hosts that have
// similar characteristics. Mesos currently only supports "fault
// domains", which identify groups of hosts with similar failure
// characteristics.
//
// Frameworks can generally assume that network links between hosts in
// the same fault domain have lower latency, higher bandwidth, and better
// availability than network links between hosts in different domains.
// Schedulers may prefer to place network-intensive workloads in the
// same domain, as this may improve performance. Conversely, a single
// failure that affects a host in a domain may be more likely to
// affect other hosts in the same domain; hence, schedulers may prefer
// to place workloads that require high availability in multiple
// domains. (For example, all the hosts in a single rack might lose
// power or network connectivity simultaneously.)
//
// There are two kinds of fault domains: regions and zones. Regions
// offer the highest degree of fault isolation, but network latency
// between regions is typically high (typically >50 ms). Zones offer a
// modest degree of fault isolation along with reasonably low network
// latency (typically <10 ms).
//
// The mapping from fault domains to physical infrastructure is up to
// the operator to configure. In cloud environments, regions and zones
// can be mapped to the "region" and "availability zone" concepts
// exposed by most cloud providers, respectively. In on-premise
// deployments, regions and zones can be mapped to data centers and
// racks, respectively.
//
// Both masters and agents can be configured with domains. Frameworks
// can compare the domains of two hosts to determine if the hosts are
// in the same zone, in different zones in the same region, or in
// different regions. Note that all masters in a given Mesos cluster
// must be in the same region.
type DomainInfo struct {
	FaultDomain *DomainInfo_FaultDomain `protobuf:"bytes,1,opt,name=fault_domain,json=faultDomain" json:"fault_domain,omitempty"`
}

func (m *DomainInfo) Reset()                    { *m = DomainInfo{} }
func (*DomainInfo) ProtoMessage()               {}
func (*DomainInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{21} }

func (m *DomainInfo) GetFaultDomain() *DomainInfo_FaultDomain {
	if m != nil {
		return m.FaultDomain
	}
	return nil
}

type DomainInfo_FaultDomain struct {
	Region DomainInfo_FaultDomain_RegionInfo `protobuf:"bytes,1,req,name=region" json:"region"`
	Zone   DomainInfo_FaultDomain_ZoneInfo   `protobuf:"bytes,2,req,name=zone" json:"zone"`
}

func (m *DomainInfo_FaultDomain) Reset()                    { *m = DomainInfo_FaultDomain{} }
func (*DomainInfo_FaultDomain) ProtoMessage()               {}
func (*DomainInfo_FaultDomain) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{21, 0} }

func (m *DomainInfo_FaultDomain) GetRegion() DomainInfo_FaultDomain_RegionInfo {
	if m != nil {
		return m.Region
	}
	return DomainInfo_FaultDomain_RegionInfo{}
}

func (m *DomainInfo_FaultDomain) GetZone() DomainInfo_FaultDomain_ZoneInfo {
	if m != nil {
		return m.Zone
	}
	return DomainInfo_FaultDomain_ZoneInfo{}
}

type DomainInfo_FaultDomain_RegionInfo struct {
	Name string `protobuf:"bytes,1,req,name=name" json:"name"`
}

func (m *DomainInfo_FaultDomain_RegionInfo) Reset()      { *m = DomainInfo_FaultDomain_RegionInfo{} }
func (*DomainInfo_FaultDomain_RegionInfo) ProtoMessage() {}
func (*DomainInfo_FaultDomain_RegionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{21, 0, 0}
}

func (m *DomainInfo_FaultDomain_RegionInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type DomainInfo_FaultDomain_ZoneInfo struct {
	Name string `protobuf:"bytes,1,req,name=name" json:"name"`
}

func (m *DomainInfo_FaultDomain_ZoneInfo) Reset()      { *m = DomainInfo_FaultDomain_ZoneInfo{} }
func (*DomainInfo_FaultDomain_ZoneInfo) ProtoMessage() {}
func (*DomainInfo_FaultDomain_ZoneInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{21, 0, 1}
}

func (m *DomainInfo_FaultDomain_ZoneInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// *
// Describes a master. This will probably have more fields in the
// future which might be used, for example, to link a framework webui
// to a master webui.
type MasterInfo struct {
	ID string `protobuf:"bytes,1,req,name=id" json:"id"`
	// The IP address (only IPv4) as a packed 4-bytes integer,
	// stored in network order.  Deprecated, use `address.ip` instead.
	IP uint32 `protobuf:"varint,2,req,name=ip" json:"ip"`
	// The TCP port the Master is listening on for incoming
	// HTTP requests; deprecated, use `address.port` instead.
	Port *uint32 `protobuf:"varint,3,req,name=port,def=5050" json:"port,omitempty"`
	// In the default implementation, this will contain information
	// about both the IP address, port and Master name; it should really
	// not be relied upon by external tooling/frameworks and be
	// considered an "internal" implementation field.
	PID *string `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	// The server's hostname, if available; it may be unreliable
	// in environments where the DNS configuration does not resolve
	// internal hostnames (eg, some public cloud providers).
	// Deprecated, use `address.hostname` instead.
	Hostname *string `protobuf:"bytes,5,opt,name=hostname" json:"hostname,omitempty"`
	// The running Master version, as a string; taken from the
	// generated "master/version.hpp".
	Version *string `protobuf:"bytes,6,opt,name=version" json:"version,omitempty"`
	// The full IP address (supports both IPv4 and IPv6 formats)
	// and supersedes the use of `ip`, `port` and `hostname`.
	// Since Mesos 0.24.
	Address *Address `protobuf:"bytes,7,opt,name=address" json:"address,omitempty"`
	// The domain that this master belongs to. All masters in a Mesos
	// cluster should belong to the same region.
	Domain       *DomainInfo             `protobuf:"bytes,8,opt,name=domain" json:"domain,omitempty"`
	Capabilities []MasterInfo_Capability `protobuf:"bytes,9,rep,name=capabilities" json:"capabilities"`
}

func (m *MasterInfo) Reset()                    { *m = MasterInfo{} }
func (*MasterInfo) ProtoMessage()               {}
func (*MasterInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{22} }

const Default_MasterInfo_Port uint32 = 5050

func (m *MasterInfo) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *MasterInfo) GetIP() uint32 {
	if m != nil {
		return m.IP
	}
	return 0
}

func (m *MasterInfo) GetPort() uint32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return Default_MasterInfo_Port
}

func (m *MasterInfo) GetPID() string {
	if m != nil && m.PID != nil {
		return *m.PID
	}
	return ""
}

func (m *MasterInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *MasterInfo) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *MasterInfo) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *MasterInfo) GetDomain() *DomainInfo {
	if m != nil {
		return m.Domain
	}
	return nil
}

func (m *MasterInfo) GetCapabilities() []MasterInfo_Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

type MasterInfo_Capability struct {
	Type MasterInfo_Capability_Type `protobuf:"varint,1,opt,name=type,enum=mesos.MasterInfo_Capability_Type" json:"type"`
}

func (m *MasterInfo_Capability) Reset()                    { *m = MasterInfo_Capability{} }
func (*MasterInfo_Capability) ProtoMessage()               {}
func (*MasterInfo_Capability) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{22, 0} }

func (m *MasterInfo_Capability) GetType() MasterInfo_Capability_Type {
	if m != nil {
		return m.Type
	}
	return MasterInfo_Capability_UNKNOWN
}

// *
// Describes an agent. Note that the 'id' field is only available
// after an agent is registered with the master, and is made available
// here to facilitate re-registration.
type AgentInfo struct {
	Hostname string `protobuf:"bytes,1,req,name=hostname" json:"hostname"`
	Port     *int32 `protobuf:"varint,8,opt,name=port,def=5051" json:"port,omitempty"`
	// The configured resources at the agent. This does not include any
	// dynamic reservations or persistent volumes that may currently
	// exist at the agent.
	Resources  []Resource  `protobuf:"bytes,3,rep,name=resources" json:"resources"`
	Attributes []Attribute `protobuf:"bytes,5,rep,name=attributes" json:"attributes"`
	ID         *AgentID    `protobuf:"bytes,6,opt,name=id" json:"id,omitempty"`
	// The domain that this agent belongs to. If the agent's region
	// differs from the master's region, it will not appear in resource
	// offers to frameworks that have not enabled the REGION_AWARE
	// capability.
	Domain *DomainInfo `protobuf:"bytes,10,opt,name=domain" json:"domain,omitempty"`
}

func (m *AgentInfo) Reset()                    { *m = AgentInfo{} }
func (*AgentInfo) ProtoMessage()               {}
func (*AgentInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{23} }

const Default_AgentInfo_Port int32 = 5051

func (m *AgentInfo) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *AgentInfo) GetPort() int32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return Default_AgentInfo_Port
}

func (m *AgentInfo) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *AgentInfo) GetAttributes() []Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *AgentInfo) GetID() *AgentID {
	if m != nil {
		return m.ID
	}
	return nil
}

func (m *AgentInfo) GetDomain() *DomainInfo {
	if m != nil {
		return m.Domain
	}
	return nil
}

type AgentInfo_Capability struct {
	// Enum fields should be optional, see: MESOS-4997.
	Type AgentInfo_Capability_Type `protobuf:"varint,1,opt,name=type,enum=mesos.AgentInfo_Capability_Type" json:"type"`
}

func (m *AgentInfo_Capability) Reset()                    { *m = AgentInfo_Capability{} }
func (*AgentInfo_Capability) ProtoMessage()               {}
func (*AgentInfo_Capability) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{23, 0} }

func (m *AgentInfo_Capability) GetType() AgentInfo_Capability_Type {
	if m != nil {
		return m.Type
	}
	return AgentInfo_Capability_UNKNOWN
}

// *
// Describes the container configuration to run a CSI plugin component.
type CSIPluginContainerInfo struct {
	Services  []CSIPluginContainerInfo_Service `protobuf:"varint,1,rep,name=services,enum=mesos.CSIPluginContainerInfo_Service" json:"services,omitempty"`
	Command   *CommandInfo                     `protobuf:"bytes,2,opt,name=command" json:"command,omitempty"`
	Resources []Resource                       `protobuf:"bytes,3,rep,name=resources" json:"resources"`
	Container *ContainerInfo                   `protobuf:"bytes,4,opt,name=container" json:"container,omitempty"`
}

func (m *CSIPluginContainerInfo) Reset()                    { *m = CSIPluginContainerInfo{} }
func (*CSIPluginContainerInfo) ProtoMessage()               {}
func (*CSIPluginContainerInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{24} }

func (m *CSIPluginContainerInfo) GetServices() []CSIPluginContainerInfo_Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *CSIPluginContainerInfo) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *CSIPluginContainerInfo) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *CSIPluginContainerInfo) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

// *
// Describes a CSI plugin.
type CSIPluginInfo struct {
	// The type of the CSI service. This uniquely identifies a CSI
	// implementation. For instance:
	//     org.apache.mesos.csi.test
	//
	// Please follow to Java package naming convention
	// (https://en.wikipedia.org/wiki/Java_package#Package_naming_conventions)
	// to avoid conflicts on type names.
	Type string `protobuf:"bytes,1,req,name=type" json:"type"`
	// The name of the CSI service. There could be mutliple instances of a
	// type of CSI service. The name field is used to distinguish these
	// instances. It should be a legal Java identifier
	// (https://docs.oracle.com/javase/tutorial/java/nutsandbolts/variables.html)
	// to avoid conflicts on concatenation of type and name.
	Name string `protobuf:"bytes,2,req,name=name" json:"name"`
	// A list of container configurations to run CSI plugin components.
	// The controller service will be served by the first configuration
	// that contains `CONTROLLER_SERVICE`, and the node service will be
	// served by the first configuration that contains `NODE_SERVICE`.
	Containers []CSIPluginContainerInfo `protobuf:"bytes,3,rep,name=containers" json:"containers"`
}

func (m *CSIPluginInfo) Reset()                    { *m = CSIPluginInfo{} }
func (*CSIPluginInfo) ProtoMessage()               {}
func (*CSIPluginInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{25} }

func (m *CSIPluginInfo) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *CSIPluginInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CSIPluginInfo) GetContainers() []CSIPluginContainerInfo {
	if m != nil {
		return m.Containers
	}
	return nil
}

// *
// Describes a resource provider. Note that the 'id' field is only available
// after a resource provider is registered with the master, and is made
// available here to facilitate re-registration.
type ResourceProviderInfo struct {
	ID         *ResourceProviderID `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Attributes []Attribute         `protobuf:"bytes,2,rep,name=attributes" json:"attributes"`
	// The type of the resource provider. This uniquely identifies a
	// resource provider implementation. For instance:
	//     org.apache.mesos.rp.local.storage
	//
	// Please follow to Java package naming convention
	// (https://en.wikipedia.org/wiki/Java_package#Package_naming_conventions)
	// to avoid conflicts on type names.
	Type string `protobuf:"bytes,3,req,name=type" json:"type"`
	// The name of the resource provider. There could be multiple
	// instances of a type of resource provider. The name field is used
	// to distinguish these instances. It should be a legal Java identifier
	// (https://docs.oracle.com/javase/tutorial/java/nutsandbolts/variables.html)
	// to avoid conflicts on concatenation of type and name.
	Name string `protobuf:"bytes,4,req,name=name" json:"name"`
	// The stack of default reservations. If this field is not empty, it
	// indicates that resources from this resource provider are reserved
	// by default, except for the resources that have been reserved or
	// unreserved through operations. The first `ReservationInfo`
	// may have type `STATIC` or `DYNAMIC`, but the rest must have
	// `DYNAMIC`. One can create a new reservation on top of an existing
	// one by pushing a new `ReservationInfo` to the back. The last
	// `ReservationInfo` in this stack is the "current" reservation. The
	// new reservation's role must be a child of the current one.
	DefaultReservations []Resource_ReservationInfo    `protobuf:"bytes,5,rep,name=default_reservations,json=defaultReservations" json:"default_reservations"`
	Storage             *ResourceProviderInfo_Storage `protobuf:"bytes,6,opt,name=storage" json:"storage,omitempty"`
}

func (m *ResourceProviderInfo) Reset()                    { *m = ResourceProviderInfo{} }
func (*ResourceProviderInfo) ProtoMessage()               {}
func (*ResourceProviderInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{26} }

func (m *ResourceProviderInfo) GetID() *ResourceProviderID {
	if m != nil {
		return m.ID
	}
	return nil
}

func (m *ResourceProviderInfo) GetAttributes() []Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *ResourceProviderInfo) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *ResourceProviderInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ResourceProviderInfo) GetDefaultReservations() []Resource_ReservationInfo {
	if m != nil {
		return m.DefaultReservations
	}
	return nil
}

func (m *ResourceProviderInfo) GetStorage() *ResourceProviderInfo_Storage {
	if m != nil {
		return m.Storage
	}
	return nil
}

// Storage resource provider related information.
type ResourceProviderInfo_Storage struct {
	Plugin CSIPluginInfo `protobuf:"bytes,1,req,name=plugin" json:"plugin"`
}

func (m *ResourceProviderInfo_Storage) Reset()      { *m = ResourceProviderInfo_Storage{} }
func (*ResourceProviderInfo_Storage) ProtoMessage() {}
func (*ResourceProviderInfo_Storage) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{26, 0}
}

func (m *ResourceProviderInfo_Storage) GetPlugin() CSIPluginInfo {
	if m != nil {
		return m.Plugin
	}
	return CSIPluginInfo{}
}

// *
// Describes an Attribute or Resource "value". A value is described
// using the standard protocol buffer "union" trick.
type Value struct {
	Type   Value_Type    `protobuf:"varint,1,req,name=type,enum=mesos.Value_Type" json:"type"`
	Scalar *Value_Scalar `protobuf:"bytes,2,opt,name=scalar" json:"scalar,omitempty"`
	Ranges *Value_Ranges `protobuf:"bytes,3,opt,name=ranges" json:"ranges,omitempty"`
	Set    *Value_Set    `protobuf:"bytes,4,opt,name=set" json:"set,omitempty"`
	Text   *Value_Text   `protobuf:"bytes,5,opt,name=text" json:"text,omitempty"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{27} }

func (m *Value) GetType() Value_Type {
	if m != nil {
		return m.Type
	}
	return SCALAR
}

func (m *Value) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Value) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Value) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Value) GetText() *Value_Text {
	if m != nil {
		return m.Text
	}
	return nil
}

type Value_Scalar struct {
	// Scalar values are represented using floating point. To reduce
	// the chance of unpredictable floating point behavior due to
	// roundoff error, Mesos only supports three decimal digits of
	// precision for scalar resource values. That is, floating point
	// values are converted to a fixed point format that supports
	// three decimal digits of precision, and then converted back to
	// floating point on output. Any additional precision in scalar
	// resource values is discarded (via rounding).
	Value float64 `protobuf:"fixed64,1,req,name=value" json:"value"`
}

func (m *Value_Scalar) Reset()                    { *m = Value_Scalar{} }
func (*Value_Scalar) ProtoMessage()               {}
func (*Value_Scalar) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{27, 0} }

func (m *Value_Scalar) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type Value_Range struct {
	Begin uint64 `protobuf:"varint,1,req,name=begin" json:"begin"`
	End   uint64 `protobuf:"varint,2,req,name=end" json:"end"`
}

func (m *Value_Range) Reset()                    { *m = Value_Range{} }
func (*Value_Range) ProtoMessage()               {}
func (*Value_Range) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{27, 1} }

func (m *Value_Range) GetBegin() uint64 {
	if m != nil {
		return m.Begin
	}
	return 0
}

func (m *Value_Range) GetEnd() uint64 {
	if m != nil {
		return m.End
	}
	return 0
}

type Value_Ranges struct {
	Range []Value_Range `protobuf:"bytes,1,rep,name=range" json:"range"`
}

func (m *Value_Ranges) Reset()                    { *m = Value_Ranges{} }
func (*Value_Ranges) ProtoMessage()               {}
func (*Value_Ranges) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{27, 2} }

func (m *Value_Ranges) GetRange() []Value_Range {
	if m != nil {
		return m.Range
	}
	return nil
}

type Value_Set struct {
	Item []string `protobuf:"bytes,1,rep,name=item" json:"item,omitempty"`
}

func (m *Value_Set) Reset()                    { *m = Value_Set{} }
func (*Value_Set) ProtoMessage()               {}
func (*Value_Set) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{27, 3} }

func (m *Value_Set) GetItem() []string {
	if m != nil {
		return m.Item
	}
	return nil
}

type Value_Text struct {
	Value string `protobuf:"bytes,1,req,name=value" json:"value"`
}

func (m *Value_Text) Reset()                    { *m = Value_Text{} }
func (*Value_Text) ProtoMessage()               {}
func (*Value_Text) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{27, 4} }

func (m *Value_Text) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// Describes an attribute that can be set on a machine. For now,
// attributes and resources share the same "value" type, but this may
// change in the future and attributes may only be string based.
type Attribute struct {
	Name   string        `protobuf:"bytes,1,req,name=name" json:"name"`
	Type   Value_Type    `protobuf:"varint,2,req,name=type,enum=mesos.Value_Type" json:"type"`
	Scalar *Value_Scalar `protobuf:"bytes,3,opt,name=scalar" json:"scalar,omitempty"`
	Ranges *Value_Ranges `protobuf:"bytes,4,opt,name=ranges" json:"ranges,omitempty"`
	Set    *Value_Set    `protobuf:"bytes,6,opt,name=set" json:"set,omitempty"`
	Text   *Value_Text   `protobuf:"bytes,5,opt,name=text" json:"text,omitempty"`
}

func (m *Attribute) Reset()                    { *m = Attribute{} }
func (*Attribute) ProtoMessage()               {}
func (*Attribute) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{28} }

func (m *Attribute) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Attribute) GetType() Value_Type {
	if m != nil {
		return m.Type
	}
	return SCALAR
}

func (m *Attribute) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Attribute) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Attribute) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Attribute) GetText() *Value_Text {
	if m != nil {
		return m.Text
	}
	return nil
}

// *
// Describes a resource from a resource provider. The `name` field is
// a string like "cpus" or "mem" that indicates which kind of resource
// this is; the rest of the fields describe the properties of the
// resource. A resource can take on one of three types: scalar
// (double), a list of finite and discrete ranges (e.g., [1-10,
// 20-30]), or a set of items. A resource is described using the
// standard protocol buffer "union" trick.
//
// Note that "disk" and "mem" resources are scalar values expressed in
// megabytes. Fractional "cpus" values are allowed (e.g., "0.5"),
// which correspond to partial shares of a CPU.
type Resource struct {
	ProviderID *ResourceProviderID `protobuf:"bytes,12,opt,name=provider_id,json=providerId" json:"provider_id,omitempty"`
	Name       string              `protobuf:"bytes,1,req,name=name" json:"name"`
	Type       *Value_Type         `protobuf:"varint,2,req,name=type,enum=mesos.Value_Type" json:"type,omitempty"`
	Scalar     *Value_Scalar       `protobuf:"bytes,3,opt,name=scalar" json:"scalar,omitempty"`
	Ranges     *Value_Ranges       `protobuf:"bytes,4,opt,name=ranges" json:"ranges,omitempty"`
	Set        *Value_Set          `protobuf:"bytes,5,opt,name=set" json:"set,omitempty"`
	// The role that this resource is reserved for. If "*", this indicates
	// that the resource is unreserved. Otherwise, the resource will only
	// be offered to frameworks that belong to this role.
	//
	// NOTE: Frameworks must not set this field if `reservations` is set.
	//       See the 'Resource Format' section for more details.
	//
	// TODO(mpark): Deprecate once `reservations` is no longer experimental.
	Role           *string                  `protobuf:"bytes,6,opt,name=role,def=*" json:"role,omitempty"`
	AllocationInfo *Resource_AllocationInfo `protobuf:"bytes,11,opt,name=allocation_info,json=allocationInfo" json:"allocation_info,omitempty"`
	// If this is set, this resource was dynamically reserved by an
	// operator or a framework. Otherwise, this resource is either unreserved
	// or statically reserved by an operator via the --resources flag.
	//
	// NOTE: Frameworks must not set this field if `reservations` is set.
	//       See the 'Resource Format' section for more details.
	//
	// TODO(mpark): Deprecate once `reservations` is no longer experimental.
	Reservation *Resource_ReservationInfo `protobuf:"bytes,8,opt,name=reservation" json:"reservation,omitempty"`
	// The stack of reservations. If this field is empty, it indicates that this
	// resource is unreserved. Otherwise, the resource is reserved. The first
	// `ReservationInfo` may have type `STATIC` or `DYNAMIC`, but the rest must
	// have `DYNAMIC`. One can create a new reservation on top of an existing
	// one by pushing a new `ReservationInfo` to the back. The last
	// `ReservationInfo` in this stack is the "current" reservation. The new
	// reservation's role must be a child of the current reservation's role.
	//
	// NOTE: Frameworks must not set this field if `reservation` is set.
	//       See the 'Resource Format' section for more details.
	//
	// TODO(mpark): Deprecate `role` and `reservation` once this is stable.
	Reservations []Resource_ReservationInfo `protobuf:"bytes,13,rep,name=reservations" json:"reservations"`
	Disk         *Resource_DiskInfo         `protobuf:"bytes,7,opt,name=disk" json:"disk,omitempty"`
	// If this is set, the resources are revocable, i.e., any tasks or
	// executors launched using these resources could get preempted or
	// throttled at any time. This could be used by frameworks to run
	// best effort tasks that do not need strict uptime or performance
	// guarantees. Note that if this is set, 'disk' or 'reservation'
	// cannot be set.
	Revocable *Resource_RevocableInfo `protobuf:"bytes,9,opt,name=revocable" json:"revocable,omitempty"`
	// If this is set, the resources are shared, i.e. multiple tasks
	// can be launched using this resource and all of them shall refer
	// to the same physical resource on the cluster. Note that only
	// persistent volumes can be shared currently.
	Shared *Resource_SharedInfo `protobuf:"bytes,10,opt,name=shared" json:"shared,omitempty"`
}

func (m *Resource) Reset()                    { *m = Resource{} }
func (*Resource) ProtoMessage()               {}
func (*Resource) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{29} }

const Default_Resource_Role string = "*"

func (m *Resource) GetProviderID() *ResourceProviderID {
	if m != nil {
		return m.ProviderID
	}
	return nil
}

func (m *Resource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Resource) GetType() Value_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return SCALAR
}

func (m *Resource) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Resource) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Resource) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Resource) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return Default_Resource_Role
}

func (m *Resource) GetAllocationInfo() *Resource_AllocationInfo {
	if m != nil {
		return m.AllocationInfo
	}
	return nil
}

func (m *Resource) GetReservation() *Resource_ReservationInfo {
	if m != nil {
		return m.Reservation
	}
	return nil
}

func (m *Resource) GetReservations() []Resource_ReservationInfo {
	if m != nil {
		return m.Reservations
	}
	return nil
}

func (m *Resource) GetDisk() *Resource_DiskInfo {
	if m != nil {
		return m.Disk
	}
	return nil
}

func (m *Resource) GetRevocable() *Resource_RevocableInfo {
	if m != nil {
		return m.Revocable
	}
	return nil
}

func (m *Resource) GetShared() *Resource_SharedInfo {
	if m != nil {
		return m.Shared
	}
	return nil
}

// This was initially introduced to support MULTI_ROLE capable
// frameworks. Frameworks that are not MULTI_ROLE capable can
// continue to assume that the offered resources are allocated
// to their role.
type Resource_AllocationInfo struct {
	// If set, this resource is allocated to a role. Note that in the
	// future, this may be unset and the scheduler may be responsible
	// for allocating to one of its roles.
	Role *string `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
}

func (m *Resource_AllocationInfo) Reset()                    { *m = Resource_AllocationInfo{} }
func (*Resource_AllocationInfo) ProtoMessage()               {}
func (*Resource_AllocationInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{29, 0} }

func (m *Resource_AllocationInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

type Resource_ReservationInfo struct {
	// The type of this reservation.
	//
	// NOTE: This field must not be set for `Resource.reservation`.
	//       See the 'Resource Format' section for more details.
	Type *Resource_ReservationInfo_Type `protobuf:"varint,4,opt,name=type,enum=mesos.Resource_ReservationInfo_Type" json:"type,omitempty"`
	// The role to which this reservation is made for.
	//
	// NOTE: This field must not be set for `Resource.reservation`.
	//       See the 'Resource Format' section for more details.
	Role *string `protobuf:"bytes,3,opt,name=role" json:"role,omitempty"`
	// Indicates the principal, if any, of the framework or operator
	// that reserved this resource. If reserved by a framework, the
	// field should match the `FrameworkInfo.principal`. It is used in
	// conjunction with the `UnreserveResources` ACL to determine
	// whether the entity attempting to unreserve this resource is
	// permitted to do so.
	Principal *string `protobuf:"bytes,1,opt,name=principal" json:"principal,omitempty"`
	// Labels are free-form key value pairs that can be used to
	// associate arbitrary metadata with a reserved resource.  For
	// example, frameworks can use labels to identify the intended
	// purpose for a portion of the resources the framework has
	// reserved at a given agent. Labels should not contain duplicate
	// key-value pairs.
	Labels *Labels `protobuf:"bytes,2,opt,name=labels" json:"labels,omitempty"`
}

func (m *Resource_ReservationInfo) Reset()      { *m = Resource_ReservationInfo{} }
func (*Resource_ReservationInfo) ProtoMessage() {}
func (*Resource_ReservationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{29, 1}
}

func (m *Resource_ReservationInfo) GetType() Resource_ReservationInfo_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Resource_ReservationInfo_UNKNOWN
}

func (m *Resource_ReservationInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *Resource_ReservationInfo) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *Resource_ReservationInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

type Resource_DiskInfo struct {
	Persistence *Resource_DiskInfo_Persistence `protobuf:"bytes,1,opt,name=persistence" json:"persistence,omitempty"`
	// Describes how this disk resource will be mounted in the
	// container. If not set, the disk resource will be used as the
	// sandbox. Otherwise, it will be mounted according to the
	// 'container_path' inside 'volume'. The 'host_path' inside
	// 'volume' is ignored.
	// NOTE: If 'volume' is set but 'persistence' is not set, the
	// volume will be automatically garbage collected after
	// task/executor terminates. Currently, if 'persistence' is set,
	// 'volume' must be set.
	Volume *Volume                   `protobuf:"bytes,2,opt,name=volume" json:"volume,omitempty"`
	Source *Resource_DiskInfo_Source `protobuf:"bytes,3,opt,name=source" json:"source,omitempty"`
}

func (m *Resource_DiskInfo) Reset()                    { *m = Resource_DiskInfo{} }
func (*Resource_DiskInfo) ProtoMessage()               {}
func (*Resource_DiskInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{29, 2} }

func (m *Resource_DiskInfo) GetPersistence() *Resource_DiskInfo_Persistence {
	if m != nil {
		return m.Persistence
	}
	return nil
}

func (m *Resource_DiskInfo) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

func (m *Resource_DiskInfo) GetSource() *Resource_DiskInfo_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

// Describes a persistent disk volume.
//
// A persistent disk volume will not be automatically garbage
// collected if the task/executor/agent terminates, but will be
// re-offered to the framework(s) belonging to the 'role'.
//
// NOTE: Currently, we do not allow persistent disk volumes
// without a reservation (i.e., 'role' cannot be '*').
type Resource_DiskInfo_Persistence struct {
	// A unique ID for the persistent disk volume. This ID must be
	// unique per role on each agent. Although it is possible to use
	// the same ID on different agents in the cluster and to reuse
	// IDs after a volume with that ID has been destroyed, both
	// practices are discouraged.
	ID string `protobuf:"bytes,1,req,name=id" json:"id"`
	// This field indicates the principal of the operator or
	// framework that created this volume. It is used in conjunction
	// with the "destroy" ACL to determine whether an entity
	// attempting to destroy the volume is permitted to do so.
	//
	// NOTE: This field should match the FrameworkInfo.principal of
	// the framework that created the volume.
	Principal *string `protobuf:"bytes,2,opt,name=principal" json:"principal,omitempty"`
}

func (m *Resource_DiskInfo_Persistence) Reset()      { *m = Resource_DiskInfo_Persistence{} }
func (*Resource_DiskInfo_Persistence) ProtoMessage() {}
func (*Resource_DiskInfo_Persistence) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{29, 2, 0}
}

func (m *Resource_DiskInfo_Persistence) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Resource_DiskInfo_Persistence) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

// Describes where a disk originates from.
// TODO(jmlvanre): Add support for BLOCK devices.
type Resource_DiskInfo_Source struct {
	Type  Resource_DiskInfo_Source_Type   `protobuf:"varint,1,req,name=type,enum=mesos.Resource_DiskInfo_Source_Type" json:"type"`
	Path  *Resource_DiskInfo_Source_Path  `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	Mount *Resource_DiskInfo_Source_Mount `protobuf:"bytes,3,opt,name=mount" json:"mount,omitempty"`
	// An identifier for this source. This field maps onto CSI
	// volume IDs and is not expected to be set by frameworks.
	ID *string `protobuf:"bytes,4,opt,name=id" json:"id,omitempty"`
	// Additional metadata for this source. This field maps onto CSI
	// volume metadata and is not expected to be set by frameworks.
	Metadata *Labels `protobuf:"bytes,5,opt,name=metadata" json:"metadata,omitempty"`
	// This field serves as an indirection to a set of storage
	// vendor specific disk parameters which describe the properties
	// of the disk. The operator will setup mappings between a
	// profile name to a set of vendor specific disk parameters. And
	// the framework will do disk selection based on profile names,
	// instead of vendor specific disk parameters.
	//
	// Also see the DiskProfile module.
	Profile *string `protobuf:"bytes,6,opt,name=profile" json:"profile,omitempty"`
}

func (m *Resource_DiskInfo_Source) Reset()      { *m = Resource_DiskInfo_Source{} }
func (*Resource_DiskInfo_Source) ProtoMessage() {}
func (*Resource_DiskInfo_Source) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{29, 2, 1}
}

func (m *Resource_DiskInfo_Source) GetType() Resource_DiskInfo_Source_Type {
	if m != nil {
		return m.Type
	}
	return Resource_DiskInfo_Source_UNKNOWN
}

func (m *Resource_DiskInfo_Source) GetPath() *Resource_DiskInfo_Source_Path {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Resource_DiskInfo_Source) GetMount() *Resource_DiskInfo_Source_Mount {
	if m != nil {
		return m.Mount
	}
	return nil
}

func (m *Resource_DiskInfo_Source) GetID() string {
	if m != nil && m.ID != nil {
		return *m.ID
	}
	return ""
}

func (m *Resource_DiskInfo_Source) GetMetadata() *Labels {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Resource_DiskInfo_Source) GetProfile() string {
	if m != nil && m.Profile != nil {
		return *m.Profile
	}
	return ""
}

// A folder that can be located on a separate disk device. This
// can be shared and carved up as necessary between frameworks.
type Resource_DiskInfo_Source_Path struct {
	// Path to the folder (e.g., /mnt/raid/disk0). If the path is a
	// relative path, it is relative to the agent work directory.
	Root *string `protobuf:"bytes,1,opt,name=root" json:"root,omitempty"`
}

func (m *Resource_DiskInfo_Source_Path) Reset()      { *m = Resource_DiskInfo_Source_Path{} }
func (*Resource_DiskInfo_Source_Path) ProtoMessage() {}
func (*Resource_DiskInfo_Source_Path) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{29, 2, 1, 0}
}

func (m *Resource_DiskInfo_Source_Path) GetRoot() string {
	if m != nil && m.Root != nil {
		return *m.Root
	}
	return ""
}

// A mounted file-system set up by the Agent administrator. This
// can only be used exclusively: a framework cannot accept a
// partial amount of this disk.
type Resource_DiskInfo_Source_Mount struct {
	// Path to mount point (e.g., /mnt/raid/disk0). If the path is a
	// relative path, it is relative to the agent work directory.
	Root *string `protobuf:"bytes,1,opt,name=root" json:"root,omitempty"`
}

func (m *Resource_DiskInfo_Source_Mount) Reset()      { *m = Resource_DiskInfo_Source_Mount{} }
func (*Resource_DiskInfo_Source_Mount) ProtoMessage() {}
func (*Resource_DiskInfo_Source_Mount) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{29, 2, 1, 1}
}

func (m *Resource_DiskInfo_Source_Mount) GetRoot() string {
	if m != nil && m.Root != nil {
		return *m.Root
	}
	return ""
}

type Resource_RevocableInfo struct {
}

func (m *Resource_RevocableInfo) Reset()                    { *m = Resource_RevocableInfo{} }
func (*Resource_RevocableInfo) ProtoMessage()               {}
func (*Resource_RevocableInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{29, 3} }

// Allow the resource to be shared across tasks.
type Resource_SharedInfo struct {
}

func (m *Resource_SharedInfo) Reset()                    { *m = Resource_SharedInfo{} }
func (*Resource_SharedInfo) ProtoMessage()               {}
func (*Resource_SharedInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{29, 4} }

// *
// When the network bandwidth caps are enabled and the container
// is over its limit, outbound packets may be either delayed or
// dropped completely either because it exceeds the maximum bandwidth
// allocation for a single container (the cap) or because the combined
// network traffic of multiple containers on the host exceeds the
// transmit capacity of the host (the share). We can report the
// following statistics for each of these conditions exported directly
// from the Linux Traffic Control Queueing Discipline.
//
// id         : name of the limiter, e.g. 'tx_bw_cap'
// backlog    : number of packets currently delayed
// bytes      : total bytes seen
// drops      : number of packets dropped in total
// overlimits : number of packets which exceeded allocation
// packets    : total packets seen
// qlen       : number of packets currently queued
// rate_bps   : throughput in bytes/sec
// rate_pps   : throughput in packets/sec
// requeues   : number of times a packet has been delayed due to
//              locking or device contention issues
//
// More information on the operation of Linux Traffic Control can be
// found at http://www.lartc.org/lartc.html.
type TrafficControlStatistics struct {
	ID         string  `protobuf:"bytes,1,req,name=id" json:"id"`
	Backlog    *uint64 `protobuf:"varint,2,opt,name=backlog" json:"backlog,omitempty"`
	Bytes      *uint64 `protobuf:"varint,3,opt,name=bytes" json:"bytes,omitempty"`
	Drops      *uint64 `protobuf:"varint,4,opt,name=drops" json:"drops,omitempty"`
	Overlimits *uint64 `protobuf:"varint,5,opt,name=overlimits" json:"overlimits,omitempty"`
	Packets    *uint64 `protobuf:"varint,6,opt,name=packets" json:"packets,omitempty"`
	Qlen       *uint64 `protobuf:"varint,7,opt,name=qlen" json:"qlen,omitempty"`
	RateBPS    *uint64 `protobuf:"varint,8,opt,name=ratebps" json:"ratebps,omitempty"`
	RatePPS    *uint64 `protobuf:"varint,9,opt,name=ratepps" json:"ratepps,omitempty"`
	Requeues   *uint64 `protobuf:"varint,10,opt,name=requeues" json:"requeues,omitempty"`
}

func (m *TrafficControlStatistics) Reset()                    { *m = TrafficControlStatistics{} }
func (*TrafficControlStatistics) ProtoMessage()               {}
func (*TrafficControlStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{30} }

func (m *TrafficControlStatistics) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *TrafficControlStatistics) GetBacklog() uint64 {
	if m != nil && m.Backlog != nil {
		return *m.Backlog
	}
	return 0
}

func (m *TrafficControlStatistics) GetBytes() uint64 {
	if m != nil && m.Bytes != nil {
		return *m.Bytes
	}
	return 0
}

func (m *TrafficControlStatistics) GetDrops() uint64 {
	if m != nil && m.Drops != nil {
		return *m.Drops
	}
	return 0
}

func (m *TrafficControlStatistics) GetOverlimits() uint64 {
	if m != nil && m.Overlimits != nil {
		return *m.Overlimits
	}
	return 0
}

func (m *TrafficControlStatistics) GetPackets() uint64 {
	if m != nil && m.Packets != nil {
		return *m.Packets
	}
	return 0
}

func (m *TrafficControlStatistics) GetQlen() uint64 {
	if m != nil && m.Qlen != nil {
		return *m.Qlen
	}
	return 0
}

func (m *TrafficControlStatistics) GetRateBPS() uint64 {
	if m != nil && m.RateBPS != nil {
		return *m.RateBPS
	}
	return 0
}

func (m *TrafficControlStatistics) GetRatePPS() uint64 {
	if m != nil && m.RatePPS != nil {
		return *m.RatePPS
	}
	return 0
}

func (m *TrafficControlStatistics) GetRequeues() uint64 {
	if m != nil && m.Requeues != nil {
		return *m.Requeues
	}
	return 0
}

type IpStatistics struct {
	Forwarding      *int64 `protobuf:"varint,1,opt,name=Forwarding" json:"Forwarding,omitempty"`
	DefaultTTL      *int64 `protobuf:"varint,2,opt,name=DefaultTTL" json:"DefaultTTL,omitempty"`
	InReceives      *int64 `protobuf:"varint,3,opt,name=InReceives" json:"InReceives,omitempty"`
	InHdrErrors     *int64 `protobuf:"varint,4,opt,name=InHdrErrors" json:"InHdrErrors,omitempty"`
	InAddrErrors    *int64 `protobuf:"varint,5,opt,name=InAddrErrors" json:"InAddrErrors,omitempty"`
	ForwDatagrams   *int64 `protobuf:"varint,6,opt,name=ForwDatagrams" json:"ForwDatagrams,omitempty"`
	InUnknownProtos *int64 `protobuf:"varint,7,opt,name=InUnknownProtos" json:"InUnknownProtos,omitempty"`
	InDiscards      *int64 `protobuf:"varint,8,opt,name=InDiscards" json:"InDiscards,omitempty"`
	InDelivers      *int64 `protobuf:"varint,9,opt,name=InDelivers" json:"InDelivers,omitempty"`
	OutRequests     *int64 `protobuf:"varint,10,opt,name=OutRequests" json:"OutRequests,omitempty"`
	OutDiscards     *int64 `protobuf:"varint,11,opt,name=OutDiscards" json:"OutDiscards,omitempty"`
	OutNoRoutes     *int64 `protobuf:"varint,12,opt,name=OutNoRoutes" json:"OutNoRoutes,omitempty"`
	ReasmTimeout    *int64 `protobuf:"varint,13,opt,name=ReasmTimeout" json:"ReasmTimeout,omitempty"`
	ReasmReqds      *int64 `protobuf:"varint,14,opt,name=ReasmReqds" json:"ReasmReqds,omitempty"`
	ReasmOKs        *int64 `protobuf:"varint,15,opt,name=ReasmOKs" json:"ReasmOKs,omitempty"`
	ReasmFails      *int64 `protobuf:"varint,16,opt,name=ReasmFails" json:"ReasmFails,omitempty"`
	FragOKs         *int64 `protobuf:"varint,17,opt,name=FragOKs" json:"FragOKs,omitempty"`
	FragFails       *int64 `protobuf:"varint,18,opt,name=FragFails" json:"FragFails,omitempty"`
	FragCreates     *int64 `protobuf:"varint,19,opt,name=FragCreates" json:"FragCreates,omitempty"`
}

func (m *IpStatistics) Reset()                    { *m = IpStatistics{} }
func (*IpStatistics) ProtoMessage()               {}
func (*IpStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{31} }

func (m *IpStatistics) GetForwarding() int64 {
	if m != nil && m.Forwarding != nil {
		return *m.Forwarding
	}
	return 0
}

func (m *IpStatistics) GetDefaultTTL() int64 {
	if m != nil && m.DefaultTTL != nil {
		return *m.DefaultTTL
	}
	return 0
}

func (m *IpStatistics) GetInReceives() int64 {
	if m != nil && m.InReceives != nil {
		return *m.InReceives
	}
	return 0
}

func (m *IpStatistics) GetInHdrErrors() int64 {
	if m != nil && m.InHdrErrors != nil {
		return *m.InHdrErrors
	}
	return 0
}

func (m *IpStatistics) GetInAddrErrors() int64 {
	if m != nil && m.InAddrErrors != nil {
		return *m.InAddrErrors
	}
	return 0
}

func (m *IpStatistics) GetForwDatagrams() int64 {
	if m != nil && m.ForwDatagrams != nil {
		return *m.ForwDatagrams
	}
	return 0
}

func (m *IpStatistics) GetInUnknownProtos() int64 {
	if m != nil && m.InUnknownProtos != nil {
		return *m.InUnknownProtos
	}
	return 0
}

func (m *IpStatistics) GetInDiscards() int64 {
	if m != nil && m.InDiscards != nil {
		return *m.InDiscards
	}
	return 0
}

func (m *IpStatistics) GetInDelivers() int64 {
	if m != nil && m.InDelivers != nil {
		return *m.InDelivers
	}
	return 0
}

func (m *IpStatistics) GetOutRequests() int64 {
	if m != nil && m.OutRequests != nil {
		return *m.OutRequests
	}
	return 0
}

func (m *IpStatistics) GetOutDiscards() int64 {
	if m != nil && m.OutDiscards != nil {
		return *m.OutDiscards
	}
	return 0
}

func (m *IpStatistics) GetOutNoRoutes() int64 {
	if m != nil && m.OutNoRoutes != nil {
		return *m.OutNoRoutes
	}
	return 0
}

func (m *IpStatistics) GetReasmTimeout() int64 {
	if m != nil && m.ReasmTimeout != nil {
		return *m.ReasmTimeout
	}
	return 0
}

func (m *IpStatistics) GetReasmReqds() int64 {
	if m != nil && m.ReasmReqds != nil {
		return *m.ReasmReqds
	}
	return 0
}

func (m *IpStatistics) GetReasmOKs() int64 {
	if m != nil && m.ReasmOKs != nil {
		return *m.ReasmOKs
	}
	return 0
}

func (m *IpStatistics) GetReasmFails() int64 {
	if m != nil && m.ReasmFails != nil {
		return *m.ReasmFails
	}
	return 0
}

func (m *IpStatistics) GetFragOKs() int64 {
	if m != nil && m.FragOKs != nil {
		return *m.FragOKs
	}
	return 0
}

func (m *IpStatistics) GetFragFails() int64 {
	if m != nil && m.FragFails != nil {
		return *m.FragFails
	}
	return 0
}

func (m *IpStatistics) GetFragCreates() int64 {
	if m != nil && m.FragCreates != nil {
		return *m.FragCreates
	}
	return 0
}

type IcmpStatistics struct {
	InMsgs           *int64 `protobuf:"varint,1,opt,name=InMsgs" json:"InMsgs,omitempty"`
	InErrors         *int64 `protobuf:"varint,2,opt,name=InErrors" json:"InErrors,omitempty"`
	InCsumErrors     *int64 `protobuf:"varint,3,opt,name=InCsumErrors" json:"InCsumErrors,omitempty"`
	InDestUnreachs   *int64 `protobuf:"varint,4,opt,name=InDestUnreachs" json:"InDestUnreachs,omitempty"`
	InTimeExcds      *int64 `protobuf:"varint,5,opt,name=InTimeExcds" json:"InTimeExcds,omitempty"`
	InParmProbs      *int64 `protobuf:"varint,6,opt,name=InParmProbs" json:"InParmProbs,omitempty"`
	InSrcQuenchs     *int64 `protobuf:"varint,7,opt,name=InSrcQuenchs" json:"InSrcQuenchs,omitempty"`
	InRedirects      *int64 `protobuf:"varint,8,opt,name=InRedirects" json:"InRedirects,omitempty"`
	InEchos          *int64 `protobuf:"varint,9,opt,name=InEchos" json:"InEchos,omitempty"`
	InEchoReps       *int64 `protobuf:"varint,10,opt,name=InEchoReps" json:"InEchoReps,omitempty"`
	InTimestamps     *int64 `protobuf:"varint,11,opt,name=InTimestamps" json:"InTimestamps,omitempty"`
	InTimestampReps  *int64 `protobuf:"varint,12,opt,name=InTimestampReps" json:"InTimestampReps,omitempty"`
	InAddrMasks      *int64 `protobuf:"varint,13,opt,name=InAddrMasks" json:"InAddrMasks,omitempty"`
	InAddrMaskReps   *int64 `protobuf:"varint,14,opt,name=InAddrMaskReps" json:"InAddrMaskReps,omitempty"`
	OutMsgs          *int64 `protobuf:"varint,15,opt,name=OutMsgs" json:"OutMsgs,omitempty"`
	OutErrors        *int64 `protobuf:"varint,16,opt,name=OutErrors" json:"OutErrors,omitempty"`
	OutDestUnreachs  *int64 `protobuf:"varint,17,opt,name=OutDestUnreachs" json:"OutDestUnreachs,omitempty"`
	OutTimeExcds     *int64 `protobuf:"varint,18,opt,name=OutTimeExcds" json:"OutTimeExcds,omitempty"`
	OutParmProbs     *int64 `protobuf:"varint,19,opt,name=OutParmProbs" json:"OutParmProbs,omitempty"`
	OutSrcQuenchs    *int64 `protobuf:"varint,20,opt,name=OutSrcQuenchs" json:"OutSrcQuenchs,omitempty"`
	OutRedirects     *int64 `protobuf:"varint,21,opt,name=OutRedirects" json:"OutRedirects,omitempty"`
	OutEchos         *int64 `protobuf:"varint,22,opt,name=OutEchos" json:"OutEchos,omitempty"`
	OutEchoReps      *int64 `protobuf:"varint,23,opt,name=OutEchoReps" json:"OutEchoReps,omitempty"`
	OutTimestamps    *int64 `protobuf:"varint,24,opt,name=OutTimestamps" json:"OutTimestamps,omitempty"`
	OutTimestampReps *int64 `protobuf:"varint,25,opt,name=OutTimestampReps" json:"OutTimestampReps,omitempty"`
	OutAddrMasks     *int64 `protobuf:"varint,26,opt,name=OutAddrMasks" json:"OutAddrMasks,omitempty"`
	OutAddrMaskReps  *int64 `protobuf:"varint,27,opt,name=OutAddrMaskReps" json:"OutAddrMaskReps,omitempty"`
}

func (m *IcmpStatistics) Reset()                    { *m = IcmpStatistics{} }
func (*IcmpStatistics) ProtoMessage()               {}
func (*IcmpStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{32} }

func (m *IcmpStatistics) GetInMsgs() int64 {
	if m != nil && m.InMsgs != nil {
		return *m.InMsgs
	}
	return 0
}

func (m *IcmpStatistics) GetInErrors() int64 {
	if m != nil && m.InErrors != nil {
		return *m.InErrors
	}
	return 0
}

func (m *IcmpStatistics) GetInCsumErrors() int64 {
	if m != nil && m.InCsumErrors != nil {
		return *m.InCsumErrors
	}
	return 0
}

func (m *IcmpStatistics) GetInDestUnreachs() int64 {
	if m != nil && m.InDestUnreachs != nil {
		return *m.InDestUnreachs
	}
	return 0
}

func (m *IcmpStatistics) GetInTimeExcds() int64 {
	if m != nil && m.InTimeExcds != nil {
		return *m.InTimeExcds
	}
	return 0
}

func (m *IcmpStatistics) GetInParmProbs() int64 {
	if m != nil && m.InParmProbs != nil {
		return *m.InParmProbs
	}
	return 0
}

func (m *IcmpStatistics) GetInSrcQuenchs() int64 {
	if m != nil && m.InSrcQuenchs != nil {
		return *m.InSrcQuenchs
	}
	return 0
}

func (m *IcmpStatistics) GetInRedirects() int64 {
	if m != nil && m.InRedirects != nil {
		return *m.InRedirects
	}
	return 0
}

func (m *IcmpStatistics) GetInEchos() int64 {
	if m != nil && m.InEchos != nil {
		return *m.InEchos
	}
	return 0
}

func (m *IcmpStatistics) GetInEchoReps() int64 {
	if m != nil && m.InEchoReps != nil {
		return *m.InEchoReps
	}
	return 0
}

func (m *IcmpStatistics) GetInTimestamps() int64 {
	if m != nil && m.InTimestamps != nil {
		return *m.InTimestamps
	}
	return 0
}

func (m *IcmpStatistics) GetInTimestampReps() int64 {
	if m != nil && m.InTimestampReps != nil {
		return *m.InTimestampReps
	}
	return 0
}

func (m *IcmpStatistics) GetInAddrMasks() int64 {
	if m != nil && m.InAddrMasks != nil {
		return *m.InAddrMasks
	}
	return 0
}

func (m *IcmpStatistics) GetInAddrMaskReps() int64 {
	if m != nil && m.InAddrMaskReps != nil {
		return *m.InAddrMaskReps
	}
	return 0
}

func (m *IcmpStatistics) GetOutMsgs() int64 {
	if m != nil && m.OutMsgs != nil {
		return *m.OutMsgs
	}
	return 0
}

func (m *IcmpStatistics) GetOutErrors() int64 {
	if m != nil && m.OutErrors != nil {
		return *m.OutErrors
	}
	return 0
}

func (m *IcmpStatistics) GetOutDestUnreachs() int64 {
	if m != nil && m.OutDestUnreachs != nil {
		return *m.OutDestUnreachs
	}
	return 0
}

func (m *IcmpStatistics) GetOutTimeExcds() int64 {
	if m != nil && m.OutTimeExcds != nil {
		return *m.OutTimeExcds
	}
	return 0
}

func (m *IcmpStatistics) GetOutParmProbs() int64 {
	if m != nil && m.OutParmProbs != nil {
		return *m.OutParmProbs
	}
	return 0
}

func (m *IcmpStatistics) GetOutSrcQuenchs() int64 {
	if m != nil && m.OutSrcQuenchs != nil {
		return *m.OutSrcQuenchs
	}
	return 0
}

func (m *IcmpStatistics) GetOutRedirects() int64 {
	if m != nil && m.OutRedirects != nil {
		return *m.OutRedirects
	}
	return 0
}

func (m *IcmpStatistics) GetOutEchos() int64 {
	if m != nil && m.OutEchos != nil {
		return *m.OutEchos
	}
	return 0
}

func (m *IcmpStatistics) GetOutEchoReps() int64 {
	if m != nil && m.OutEchoReps != nil {
		return *m.OutEchoReps
	}
	return 0
}

func (m *IcmpStatistics) GetOutTimestamps() int64 {
	if m != nil && m.OutTimestamps != nil {
		return *m.OutTimestamps
	}
	return 0
}

func (m *IcmpStatistics) GetOutTimestampReps() int64 {
	if m != nil && m.OutTimestampReps != nil {
		return *m.OutTimestampReps
	}
	return 0
}

func (m *IcmpStatistics) GetOutAddrMasks() int64 {
	if m != nil && m.OutAddrMasks != nil {
		return *m.OutAddrMasks
	}
	return 0
}

func (m *IcmpStatistics) GetOutAddrMaskReps() int64 {
	if m != nil && m.OutAddrMaskReps != nil {
		return *m.OutAddrMaskReps
	}
	return 0
}

type TcpStatistics struct {
	RtoAlgorithm *int64 `protobuf:"varint,1,opt,name=RtoAlgorithm" json:"RtoAlgorithm,omitempty"`
	RtoMin       *int64 `protobuf:"varint,2,opt,name=RtoMin" json:"RtoMin,omitempty"`
	RtoMax       *int64 `protobuf:"varint,3,opt,name=RtoMax" json:"RtoMax,omitempty"`
	MaxConn      *int64 `protobuf:"varint,4,opt,name=MaxConn" json:"MaxConn,omitempty"`
	ActiveOpens  *int64 `protobuf:"varint,5,opt,name=ActiveOpens" json:"ActiveOpens,omitempty"`
	PassiveOpens *int64 `protobuf:"varint,6,opt,name=PassiveOpens" json:"PassiveOpens,omitempty"`
	AttemptFails *int64 `protobuf:"varint,7,opt,name=AttemptFails" json:"AttemptFails,omitempty"`
	EstabResets  *int64 `protobuf:"varint,8,opt,name=EstabResets" json:"EstabResets,omitempty"`
	CurrEstab    *int64 `protobuf:"varint,9,opt,name=CurrEstab" json:"CurrEstab,omitempty"`
	InSegs       *int64 `protobuf:"varint,10,opt,name=InSegs" json:"InSegs,omitempty"`
	OutSegs      *int64 `protobuf:"varint,11,opt,name=OutSegs" json:"OutSegs,omitempty"`
	RetransSegs  *int64 `protobuf:"varint,12,opt,name=RetransSegs" json:"RetransSegs,omitempty"`
	InErrs       *int64 `protobuf:"varint,13,opt,name=InErrs" json:"InErrs,omitempty"`
	OutRsts      *int64 `protobuf:"varint,14,opt,name=OutRsts" json:"OutRsts,omitempty"`
	InCsumErrors *int64 `protobuf:"varint,15,opt,name=InCsumErrors" json:"InCsumErrors,omitempty"`
}

func (m *TcpStatistics) Reset()                    { *m = TcpStatistics{} }
func (*TcpStatistics) ProtoMessage()               {}
func (*TcpStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{33} }

func (m *TcpStatistics) GetRtoAlgorithm() int64 {
	if m != nil && m.RtoAlgorithm != nil {
		return *m.RtoAlgorithm
	}
	return 0
}

func (m *TcpStatistics) GetRtoMin() int64 {
	if m != nil && m.RtoMin != nil {
		return *m.RtoMin
	}
	return 0
}

func (m *TcpStatistics) GetRtoMax() int64 {
	if m != nil && m.RtoMax != nil {
		return *m.RtoMax
	}
	return 0
}

func (m *TcpStatistics) GetMaxConn() int64 {
	if m != nil && m.MaxConn != nil {
		return *m.MaxConn
	}
	return 0
}

func (m *TcpStatistics) GetActiveOpens() int64 {
	if m != nil && m.ActiveOpens != nil {
		return *m.ActiveOpens
	}
	return 0
}

func (m *TcpStatistics) GetPassiveOpens() int64 {
	if m != nil && m.PassiveOpens != nil {
		return *m.PassiveOpens
	}
	return 0
}

func (m *TcpStatistics) GetAttemptFails() int64 {
	if m != nil && m.AttemptFails != nil {
		return *m.AttemptFails
	}
	return 0
}

func (m *TcpStatistics) GetEstabResets() int64 {
	if m != nil && m.EstabResets != nil {
		return *m.EstabResets
	}
	return 0
}

func (m *TcpStatistics) GetCurrEstab() int64 {
	if m != nil && m.CurrEstab != nil {
		return *m.CurrEstab
	}
	return 0
}

func (m *TcpStatistics) GetInSegs() int64 {
	if m != nil && m.InSegs != nil {
		return *m.InSegs
	}
	return 0
}

func (m *TcpStatistics) GetOutSegs() int64 {
	if m != nil && m.OutSegs != nil {
		return *m.OutSegs
	}
	return 0
}

func (m *TcpStatistics) GetRetransSegs() int64 {
	if m != nil && m.RetransSegs != nil {
		return *m.RetransSegs
	}
	return 0
}

func (m *TcpStatistics) GetInErrs() int64 {
	if m != nil && m.InErrs != nil {
		return *m.InErrs
	}
	return 0
}

func (m *TcpStatistics) GetOutRsts() int64 {
	if m != nil && m.OutRsts != nil {
		return *m.OutRsts
	}
	return 0
}

func (m *TcpStatistics) GetInCsumErrors() int64 {
	if m != nil && m.InCsumErrors != nil {
		return *m.InCsumErrors
	}
	return 0
}

type UdpStatistics struct {
	InDatagrams  *int64 `protobuf:"varint,1,opt,name=InDatagrams" json:"InDatagrams,omitempty"`
	NoPorts      *int64 `protobuf:"varint,2,opt,name=NoPorts" json:"NoPorts,omitempty"`
	InErrors     *int64 `protobuf:"varint,3,opt,name=InErrors" json:"InErrors,omitempty"`
	OutDatagrams *int64 `protobuf:"varint,4,opt,name=OutDatagrams" json:"OutDatagrams,omitempty"`
	RcvbufErrors *int64 `protobuf:"varint,5,opt,name=RcvbufErrors" json:"RcvbufErrors,omitempty"`
	SndbufErrors *int64 `protobuf:"varint,6,opt,name=SndbufErrors" json:"SndbufErrors,omitempty"`
	InCsumErrors *int64 `protobuf:"varint,7,opt,name=InCsumErrors" json:"InCsumErrors,omitempty"`
	IgnoredMulti *int64 `protobuf:"varint,8,opt,name=IgnoredMulti" json:"IgnoredMulti,omitempty"`
}

func (m *UdpStatistics) Reset()                    { *m = UdpStatistics{} }
func (*UdpStatistics) ProtoMessage()               {}
func (*UdpStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{34} }

func (m *UdpStatistics) GetInDatagrams() int64 {
	if m != nil && m.InDatagrams != nil {
		return *m.InDatagrams
	}
	return 0
}

func (m *UdpStatistics) GetNoPorts() int64 {
	if m != nil && m.NoPorts != nil {
		return *m.NoPorts
	}
	return 0
}

func (m *UdpStatistics) GetInErrors() int64 {
	if m != nil && m.InErrors != nil {
		return *m.InErrors
	}
	return 0
}

func (m *UdpStatistics) GetOutDatagrams() int64 {
	if m != nil && m.OutDatagrams != nil {
		return *m.OutDatagrams
	}
	return 0
}

func (m *UdpStatistics) GetRcvbufErrors() int64 {
	if m != nil && m.RcvbufErrors != nil {
		return *m.RcvbufErrors
	}
	return 0
}

func (m *UdpStatistics) GetSndbufErrors() int64 {
	if m != nil && m.SndbufErrors != nil {
		return *m.SndbufErrors
	}
	return 0
}

func (m *UdpStatistics) GetInCsumErrors() int64 {
	if m != nil && m.InCsumErrors != nil {
		return *m.InCsumErrors
	}
	return 0
}

func (m *UdpStatistics) GetIgnoredMulti() int64 {
	if m != nil && m.IgnoredMulti != nil {
		return *m.IgnoredMulti
	}
	return 0
}

type SNMPStatistics struct {
	IPStats   *IpStatistics   `protobuf:"bytes,1,opt,name=ip_stats,json=ipStats" json:"ip_stats,omitempty"`
	ICMPStats *IcmpStatistics `protobuf:"bytes,2,opt,name=icmp_stats,json=icmpStats" json:"icmp_stats,omitempty"`
	TCPStats  *TcpStatistics  `protobuf:"bytes,3,opt,name=tcp_stats,json=tcpStats" json:"tcp_stats,omitempty"`
	UDPStats  *UdpStatistics  `protobuf:"bytes,4,opt,name=udp_stats,json=udpStats" json:"udp_stats,omitempty"`
}

func (m *SNMPStatistics) Reset()                    { *m = SNMPStatistics{} }
func (*SNMPStatistics) ProtoMessage()               {}
func (*SNMPStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{35} }

func (m *SNMPStatistics) GetIPStats() *IpStatistics {
	if m != nil {
		return m.IPStats
	}
	return nil
}

func (m *SNMPStatistics) GetICMPStats() *IcmpStatistics {
	if m != nil {
		return m.ICMPStats
	}
	return nil
}

func (m *SNMPStatistics) GetTCPStats() *TcpStatistics {
	if m != nil {
		return m.TCPStats
	}
	return nil
}

func (m *SNMPStatistics) GetUDPStats() *UdpStatistics {
	if m != nil {
		return m.UDPStats
	}
	return nil
}

type DiskStatistics struct {
	Source      *Resource_DiskInfo_Source      `protobuf:"bytes,1,opt,name=source" json:"source,omitempty"`
	Persistence *Resource_DiskInfo_Persistence `protobuf:"bytes,2,opt,name=persistence" json:"persistence,omitempty"`
	LimitBytes  *uint64                        `protobuf:"varint,3,opt,name=limit_bytes,json=limitBytes" json:"limit_bytes,omitempty"`
	UsedBytes   *uint64                        `protobuf:"varint,4,opt,name=used_bytes,json=usedBytes" json:"used_bytes,omitempty"`
}

func (m *DiskStatistics) Reset()                    { *m = DiskStatistics{} }
func (*DiskStatistics) ProtoMessage()               {}
func (*DiskStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{36} }

func (m *DiskStatistics) GetSource() *Resource_DiskInfo_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *DiskStatistics) GetPersistence() *Resource_DiskInfo_Persistence {
	if m != nil {
		return m.Persistence
	}
	return nil
}

func (m *DiskStatistics) GetLimitBytes() uint64 {
	if m != nil && m.LimitBytes != nil {
		return *m.LimitBytes
	}
	return 0
}

func (m *DiskStatistics) GetUsedBytes() uint64 {
	if m != nil && m.UsedBytes != nil {
		return *m.UsedBytes
	}
	return 0
}

// *
// A snapshot of resource usage statistics.
type ResourceStatistics struct {
	Timestamp float64 `protobuf:"fixed64,1,req,name=timestamp" json:"timestamp"`
	Processes *uint32 `protobuf:"varint,30,opt,name=processes" json:"processes,omitempty"`
	Threads   *uint32 `protobuf:"varint,31,opt,name=threads" json:"threads,omitempty"`
	// CPU Usage Information:
	// Total CPU time spent in user mode, and kernel mode.
	CPUsUserTimeSecs   *float64 `protobuf:"fixed64,2,opt,name=cpus_user_time_secs,json=cpusUserTimeSecs" json:"cpus_user_time_secs,omitempty"`
	CPUsSystemTimeSecs *float64 `protobuf:"fixed64,3,opt,name=cpus_system_time_secs,json=cpusSystemTimeSecs" json:"cpus_system_time_secs,omitempty"`
	// Number of CPUs allocated.
	CPUsLimit *float64 `protobuf:"fixed64,4,opt,name=cpus_limit,json=cpusLimit" json:"cpus_limit,omitempty"`
	// cpu.stat on process throttling (for contention issues).
	CPUsNrPeriods         *uint32  `protobuf:"varint,7,opt,name=cpus_nr_periods,json=cpusNrPeriods" json:"cpus_nr_periods,omitempty"`
	CPUsNrThrottled       *uint32  `protobuf:"varint,8,opt,name=cpus_nr_throttled,json=cpusNrThrottled" json:"cpus_nr_throttled,omitempty"`
	CPUsThrottledTimeSecs *float64 `protobuf:"fixed64,9,opt,name=cpus_throttled_time_secs,json=cpusThrottledTimeSecs" json:"cpus_throttled_time_secs,omitempty"`
	// mem_total_bytes was added in 0.23.0 to represent the total memory
	// of a process in RAM (as opposed to in Swap). This was previously
	// reported as mem_rss_bytes, which was also changed in 0.23.0 to
	// represent only the anonymous memory usage, to keep in sync with
	// Linux kernel's (arguably erroneous) use of terminology.
	MemTotalBytes *uint64 `protobuf:"varint,36,opt,name=mem_total_bytes,json=memTotalBytes" json:"mem_total_bytes,omitempty"`
	// Total memory + swap usage. This is set if swap is enabled.
	MemTotalMemswBytes *uint64 `protobuf:"varint,37,opt,name=mem_total_memsw_bytes,json=memTotalMemswBytes" json:"mem_total_memsw_bytes,omitempty"`
	// Hard memory limit for a container.
	MemLimitBytes *uint64 `protobuf:"varint,6,opt,name=mem_limit_bytes,json=memLimitBytes" json:"mem_limit_bytes,omitempty"`
	// Soft memory limit for a container.
	MemSoftLimitBytes *uint64 `protobuf:"varint,38,opt,name=mem_soft_limit_bytes,json=memSoftLimitBytes" json:"mem_soft_limit_bytes,omitempty"`
	// TODO(chzhcn) mem_file_bytes and mem_anon_bytes are deprecated in
	// 0.23.0 and will be removed in 0.24.0.
	MemFileBytes *uint64 `protobuf:"varint,10,opt,name=mem_file_bytes,json=memFileBytes" json:"mem_file_bytes,omitempty"`
	MemAnonBytes *uint64 `protobuf:"varint,11,opt,name=mem_anon_bytes,json=memAnonBytes" json:"mem_anon_bytes,omitempty"`
	// mem_cache_bytes is added in 0.23.0 to represent page cache usage.
	MemCacheBytes *uint64 `protobuf:"varint,39,opt,name=mem_cache_bytes,json=memCacheBytes" json:"mem_cache_bytes,omitempty"`
	// Since 0.23.0, mem_rss_bytes is changed to represent only
	// anonymous memory usage. Note that neither its requiredness, type,
	// name nor numeric tag has been changed.
	MemRSSBytes        *uint64 `protobuf:"varint,5,opt,name=mem_rss_bytes,json=memRssBytes" json:"mem_rss_bytes,omitempty"`
	MemMappedFileBytes *uint64 `protobuf:"varint,12,opt,name=mem_mapped_file_bytes,json=memMappedFileBytes" json:"mem_mapped_file_bytes,omitempty"`
	// This is only set if swap is enabled.
	MemSwapBytes        *uint64 `protobuf:"varint,40,opt,name=mem_swap_bytes,json=memSwapBytes" json:"mem_swap_bytes,omitempty"`
	MemUnevictableBytes *uint64 `protobuf:"varint,41,opt,name=mem_unevictable_bytes,json=memUnevictableBytes" json:"mem_unevictable_bytes,omitempty"`
	// Number of occurrences of different levels of memory pressure
	// events reported by memory cgroup. Pressure listening (re)starts
	// with these values set to 0 when agent (re)starts. See
	// https://www.kernel.org/doc/Documentation/cgroups/memory.txt for
	// more details.
	MemLowPressureCounter      *uint64 `protobuf:"varint,32,opt,name=mem_low_pressure_counter,json=memLowPressureCounter" json:"mem_low_pressure_counter,omitempty"`
	MemMediumPressureCounter   *uint64 `protobuf:"varint,33,opt,name=mem_medium_pressure_counter,json=memMediumPressureCounter" json:"mem_medium_pressure_counter,omitempty"`
	MemCriticalPressureCounter *uint64 `protobuf:"varint,34,opt,name=mem_critical_pressure_counter,json=memCriticalPressureCounter" json:"mem_critical_pressure_counter,omitempty"`
	// Disk Usage Information for executor working directory.
	DiskLimitBytes *uint64 `protobuf:"varint,26,opt,name=disk_limit_bytes,json=diskLimitBytes" json:"disk_limit_bytes,omitempty"`
	DiskUsedBytes  *uint64 `protobuf:"varint,27,opt,name=disk_used_bytes,json=diskUsedBytes" json:"disk_used_bytes,omitempty"`
	// Per disk (resource) statistics.
	DiskStatistics []DiskStatistics `protobuf:"bytes,43,rep,name=disk_statistics,json=diskStatistics" json:"disk_statistics"`
	// Cgroups blkio statistics.
	BlkioStatistics *CgroupInfo_Blkio_Statistics `protobuf:"bytes,44,opt,name=blkio_statistics,json=blkioStatistics" json:"blkio_statistics,omitempty"`
	// Perf statistics.
	Perf *PerfStatistics `protobuf:"bytes,13,opt,name=perf" json:"perf,omitempty"`
	// Network Usage Information:
	NetRxPackets *uint64 `protobuf:"varint,14,opt,name=net_rx_packets,json=netRxPackets" json:"net_rx_packets,omitempty"`
	NetRxBytes   *uint64 `protobuf:"varint,15,opt,name=net_rx_bytes,json=netRxBytes" json:"net_rx_bytes,omitempty"`
	NetRxErrors  *uint64 `protobuf:"varint,16,opt,name=net_rx_errors,json=netRxErrors" json:"net_rx_errors,omitempty"`
	NetRxDropped *uint64 `protobuf:"varint,17,opt,name=net_rx_dropped,json=netRxDropped" json:"net_rx_dropped,omitempty"`
	NetTxPackets *uint64 `protobuf:"varint,18,opt,name=net_tx_packets,json=netTxPackets" json:"net_tx_packets,omitempty"`
	NetTxBytes   *uint64 `protobuf:"varint,19,opt,name=net_tx_bytes,json=netTxBytes" json:"net_tx_bytes,omitempty"`
	NetTxErrors  *uint64 `protobuf:"varint,20,opt,name=net_tx_errors,json=netTxErrors" json:"net_tx_errors,omitempty"`
	NetTxDropped *uint64 `protobuf:"varint,21,opt,name=net_tx_dropped,json=netTxDropped" json:"net_tx_dropped,omitempty"`
	// The kernel keeps track of RTT (round-trip time) for its TCP
	// sockets. RTT is a way to tell the latency of a container.
	NetTCPRttMicrosecsP50     *float64 `protobuf:"fixed64,22,opt,name=net_tcp_rtt_microsecs_p50,json=netTcpRttMicrosecsP50" json:"net_tcp_rtt_microsecs_p50,omitempty"`
	NetTCPRttMicrosecsP90     *float64 `protobuf:"fixed64,23,opt,name=net_tcp_rtt_microsecs_p90,json=netTcpRttMicrosecsP90" json:"net_tcp_rtt_microsecs_p90,omitempty"`
	NetTCPRttMicrosecsP95     *float64 `protobuf:"fixed64,24,opt,name=net_tcp_rtt_microsecs_p95,json=netTcpRttMicrosecsP95" json:"net_tcp_rtt_microsecs_p95,omitempty"`
	NetTCPRttMicrosecsP99     *float64 `protobuf:"fixed64,25,opt,name=net_tcp_rtt_microsecs_p99,json=netTcpRttMicrosecsP99" json:"net_tcp_rtt_microsecs_p99,omitempty"`
	NetTCPActiveConnections   *float64 `protobuf:"fixed64,28,opt,name=net_tcp_active_connections,json=netTcpActiveConnections" json:"net_tcp_active_connections,omitempty"`
	NetTCPTimeWaitConnections *float64 `protobuf:"fixed64,29,opt,name=net_tcp_time_wait_connections,json=netTcpTimeWaitConnections" json:"net_tcp_time_wait_connections,omitempty"`
	// Network traffic flowing into or out of a container can be delayed
	// or dropped due to congestion or policy inside and outside the
	// container.
	NetTrafficControlStatistics []TrafficControlStatistics `protobuf:"bytes,35,rep,name=net_traffic_control_statistics,json=netTrafficControlStatistics" json:"net_traffic_control_statistics"`
	// Network SNMP statistics for each container.
	NetSNMPStatistics *SNMPStatistics `protobuf:"bytes,42,opt,name=net_snmp_statistics,json=netSnmpStatistics" json:"net_snmp_statistics,omitempty"`
}

func (m *ResourceStatistics) Reset()                    { *m = ResourceStatistics{} }
func (*ResourceStatistics) ProtoMessage()               {}
func (*ResourceStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{37} }

func (m *ResourceStatistics) GetTimestamp() float64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *ResourceStatistics) GetProcesses() uint32 {
	if m != nil && m.Processes != nil {
		return *m.Processes
	}
	return 0
}

func (m *ResourceStatistics) GetThreads() uint32 {
	if m != nil && m.Threads != nil {
		return *m.Threads
	}
	return 0
}

func (m *ResourceStatistics) GetCPUsUserTimeSecs() float64 {
	if m != nil && m.CPUsUserTimeSecs != nil {
		return *m.CPUsUserTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetCPUsSystemTimeSecs() float64 {
	if m != nil && m.CPUsSystemTimeSecs != nil {
		return *m.CPUsSystemTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetCPUsLimit() float64 {
	if m != nil && m.CPUsLimit != nil {
		return *m.CPUsLimit
	}
	return 0
}

func (m *ResourceStatistics) GetCPUsNrPeriods() uint32 {
	if m != nil && m.CPUsNrPeriods != nil {
		return *m.CPUsNrPeriods
	}
	return 0
}

func (m *ResourceStatistics) GetCPUsNrThrottled() uint32 {
	if m != nil && m.CPUsNrThrottled != nil {
		return *m.CPUsNrThrottled
	}
	return 0
}

func (m *ResourceStatistics) GetCPUsThrottledTimeSecs() float64 {
	if m != nil && m.CPUsThrottledTimeSecs != nil {
		return *m.CPUsThrottledTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetMemTotalBytes() uint64 {
	if m != nil && m.MemTotalBytes != nil {
		return *m.MemTotalBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemTotalMemswBytes() uint64 {
	if m != nil && m.MemTotalMemswBytes != nil {
		return *m.MemTotalMemswBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemLimitBytes() uint64 {
	if m != nil && m.MemLimitBytes != nil {
		return *m.MemLimitBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemSoftLimitBytes() uint64 {
	if m != nil && m.MemSoftLimitBytes != nil {
		return *m.MemSoftLimitBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemFileBytes() uint64 {
	if m != nil && m.MemFileBytes != nil {
		return *m.MemFileBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemAnonBytes() uint64 {
	if m != nil && m.MemAnonBytes != nil {
		return *m.MemAnonBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemCacheBytes() uint64 {
	if m != nil && m.MemCacheBytes != nil {
		return *m.MemCacheBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemRSSBytes() uint64 {
	if m != nil && m.MemRSSBytes != nil {
		return *m.MemRSSBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemMappedFileBytes() uint64 {
	if m != nil && m.MemMappedFileBytes != nil {
		return *m.MemMappedFileBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemSwapBytes() uint64 {
	if m != nil && m.MemSwapBytes != nil {
		return *m.MemSwapBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemUnevictableBytes() uint64 {
	if m != nil && m.MemUnevictableBytes != nil {
		return *m.MemUnevictableBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemLowPressureCounter() uint64 {
	if m != nil && m.MemLowPressureCounter != nil {
		return *m.MemLowPressureCounter
	}
	return 0
}

func (m *ResourceStatistics) GetMemMediumPressureCounter() uint64 {
	if m != nil && m.MemMediumPressureCounter != nil {
		return *m.MemMediumPressureCounter
	}
	return 0
}

func (m *ResourceStatistics) GetMemCriticalPressureCounter() uint64 {
	if m != nil && m.MemCriticalPressureCounter != nil {
		return *m.MemCriticalPressureCounter
	}
	return 0
}

func (m *ResourceStatistics) GetDiskLimitBytes() uint64 {
	if m != nil && m.DiskLimitBytes != nil {
		return *m.DiskLimitBytes
	}
	return 0
}

func (m *ResourceStatistics) GetDiskUsedBytes() uint64 {
	if m != nil && m.DiskUsedBytes != nil {
		return *m.DiskUsedBytes
	}
	return 0
}

func (m *ResourceStatistics) GetDiskStatistics() []DiskStatistics {
	if m != nil {
		return m.DiskStatistics
	}
	return nil
}

func (m *ResourceStatistics) GetBlkioStatistics() *CgroupInfo_Blkio_Statistics {
	if m != nil {
		return m.BlkioStatistics
	}
	return nil
}

func (m *ResourceStatistics) GetPerf() *PerfStatistics {
	if m != nil {
		return m.Perf
	}
	return nil
}

func (m *ResourceStatistics) GetNetRxPackets() uint64 {
	if m != nil && m.NetRxPackets != nil {
		return *m.NetRxPackets
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxBytes() uint64 {
	if m != nil && m.NetRxBytes != nil {
		return *m.NetRxBytes
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxErrors() uint64 {
	if m != nil && m.NetRxErrors != nil {
		return *m.NetRxErrors
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxDropped() uint64 {
	if m != nil && m.NetRxDropped != nil {
		return *m.NetRxDropped
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxPackets() uint64 {
	if m != nil && m.NetTxPackets != nil {
		return *m.NetTxPackets
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxBytes() uint64 {
	if m != nil && m.NetTxBytes != nil {
		return *m.NetTxBytes
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxErrors() uint64 {
	if m != nil && m.NetTxErrors != nil {
		return *m.NetTxErrors
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxDropped() uint64 {
	if m != nil && m.NetTxDropped != nil {
		return *m.NetTxDropped
	}
	return 0
}

func (m *ResourceStatistics) GetNetTCPRttMicrosecsP50() float64 {
	if m != nil && m.NetTCPRttMicrosecsP50 != nil {
		return *m.NetTCPRttMicrosecsP50
	}
	return 0
}

func (m *ResourceStatistics) GetNetTCPRttMicrosecsP90() float64 {
	if m != nil && m.NetTCPRttMicrosecsP90 != nil {
		return *m.NetTCPRttMicrosecsP90
	}
	return 0
}

func (m *ResourceStatistics) GetNetTCPRttMicrosecsP95() float64 {
	if m != nil && m.NetTCPRttMicrosecsP95 != nil {
		return *m.NetTCPRttMicrosecsP95
	}
	return 0
}

func (m *ResourceStatistics) GetNetTCPRttMicrosecsP99() float64 {
	if m != nil && m.NetTCPRttMicrosecsP99 != nil {
		return *m.NetTCPRttMicrosecsP99
	}
	return 0
}

func (m *ResourceStatistics) GetNetTCPActiveConnections() float64 {
	if m != nil && m.NetTCPActiveConnections != nil {
		return *m.NetTCPActiveConnections
	}
	return 0
}

func (m *ResourceStatistics) GetNetTCPTimeWaitConnections() float64 {
	if m != nil && m.NetTCPTimeWaitConnections != nil {
		return *m.NetTCPTimeWaitConnections
	}
	return 0
}

func (m *ResourceStatistics) GetNetTrafficControlStatistics() []TrafficControlStatistics {
	if m != nil {
		return m.NetTrafficControlStatistics
	}
	return nil
}

func (m *ResourceStatistics) GetNetSNMPStatistics() *SNMPStatistics {
	if m != nil {
		return m.NetSNMPStatistics
	}
	return nil
}

// *
// Describes a snapshot of the resource usage for executors.
type ResourceUsage struct {
	Executors []ResourceUsage_Executor `protobuf:"bytes,1,rep,name=executors" json:"executors"`
	// Agent's total resources including checkpointed dynamic
	// reservations and persistent volumes.
	Total []Resource `protobuf:"bytes,2,rep,name=total" json:"total"`
}

func (m *ResourceUsage) Reset()                    { *m = ResourceUsage{} }
func (*ResourceUsage) ProtoMessage()               {}
func (*ResourceUsage) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{38} }

func (m *ResourceUsage) GetExecutors() []ResourceUsage_Executor {
	if m != nil {
		return m.Executors
	}
	return nil
}

func (m *ResourceUsage) GetTotal() []Resource {
	if m != nil {
		return m.Total
	}
	return nil
}

type ResourceUsage_Executor struct {
	ExecutorInfo ExecutorInfo `protobuf:"bytes,1,req,name=executor_info,json=executorInfo" json:"executor_info"`
	// This includes resources used by the executor itself
	// as well as its active tasks.
	Allocated []Resource `protobuf:"bytes,2,rep,name=allocated" json:"allocated"`
	// Current resource usage. If absent, the containerizer
	// cannot provide resource usage.
	Statistics *ResourceStatistics `protobuf:"bytes,3,opt,name=statistics" json:"statistics,omitempty"`
	// The container id for the executor specified in the executor_info field.
	ContainerID ContainerID `protobuf:"bytes,4,req,name=container_id,json=containerId" json:"container_id"`
	// Non-terminal tasks.
	Tasks []ResourceUsage_Executor_Task `protobuf:"bytes,5,rep,name=tasks" json:"tasks"`
}

func (m *ResourceUsage_Executor) Reset()                    { *m = ResourceUsage_Executor{} }
func (*ResourceUsage_Executor) ProtoMessage()               {}
func (*ResourceUsage_Executor) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{38, 0} }

func (m *ResourceUsage_Executor) GetExecutorInfo() ExecutorInfo {
	if m != nil {
		return m.ExecutorInfo
	}
	return ExecutorInfo{}
}

func (m *ResourceUsage_Executor) GetAllocated() []Resource {
	if m != nil {
		return m.Allocated
	}
	return nil
}

func (m *ResourceUsage_Executor) GetStatistics() *ResourceStatistics {
	if m != nil {
		return m.Statistics
	}
	return nil
}

func (m *ResourceUsage_Executor) GetContainerID() ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return ContainerID{}
}

func (m *ResourceUsage_Executor) GetTasks() []ResourceUsage_Executor_Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

type ResourceUsage_Executor_Task struct {
	Name      string     `protobuf:"bytes,1,req,name=name" json:"name"`
	ID        TaskID     `protobuf:"bytes,2,req,name=id" json:"id"`
	Resources []Resource `protobuf:"bytes,3,rep,name=resources" json:"resources"`
	Labels    *Labels    `protobuf:"bytes,4,opt,name=labels" json:"labels,omitempty"`
}

func (m *ResourceUsage_Executor_Task) Reset()      { *m = ResourceUsage_Executor_Task{} }
func (*ResourceUsage_Executor_Task) ProtoMessage() {}
func (*ResourceUsage_Executor_Task) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{38, 0, 0}
}

func (m *ResourceUsage_Executor_Task) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ResourceUsage_Executor_Task) GetID() TaskID {
	if m != nil {
		return m.ID
	}
	return TaskID{}
}

func (m *ResourceUsage_Executor_Task) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ResourceUsage_Executor_Task) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

// *
// Describes a sample of events from "perf stat". Only available on
// Linux.
//
// NOTE: Each optional field matches the name of a perf event (see
// "perf list") with the following changes:
// 1. Names are downcased.
// 2. Hyphens ('-') are replaced with underscores ('_').
// 3. Events with alternate names use the name "perf stat" returns,
//    e.g., for the event "cycles OR cpu-cycles" perf always returns
//    cycles.
type PerfStatistics struct {
	Timestamp float64 `protobuf:"fixed64,1,req,name=timestamp" json:"timestamp"`
	Duration  float64 `protobuf:"fixed64,2,req,name=duration" json:"duration"`
	// Hardware event.
	Cycles                *uint64 `protobuf:"varint,3,opt,name=cycles" json:"cycles,omitempty"`
	StalledCyclesFrontend *uint64 `protobuf:"varint,4,opt,name=stalled_cycles_frontend,json=stalledCyclesFrontend" json:"stalled_cycles_frontend,omitempty"`
	StalledCyclesBackend  *uint64 `protobuf:"varint,5,opt,name=stalled_cycles_backend,json=stalledCyclesBackend" json:"stalled_cycles_backend,omitempty"`
	Instructions          *uint64 `protobuf:"varint,6,opt,name=instructions" json:"instructions,omitempty"`
	CacheReferences       *uint64 `protobuf:"varint,7,opt,name=cache_references,json=cacheReferences" json:"cache_references,omitempty"`
	CacheMisses           *uint64 `protobuf:"varint,8,opt,name=cache_misses,json=cacheMisses" json:"cache_misses,omitempty"`
	Branches              *uint64 `protobuf:"varint,9,opt,name=branches" json:"branches,omitempty"`
	BranchMisses          *uint64 `protobuf:"varint,10,opt,name=branch_misses,json=branchMisses" json:"branch_misses,omitempty"`
	BusCycles             *uint64 `protobuf:"varint,11,opt,name=bus_cycles,json=busCycles" json:"bus_cycles,omitempty"`
	RefCycles             *uint64 `protobuf:"varint,12,opt,name=ref_cycles,json=refCycles" json:"ref_cycles,omitempty"`
	// Software event.
	CPUClock        *float64 `protobuf:"fixed64,13,opt,name=cpu_clock,json=cpuClock" json:"cpu_clock,omitempty"`
	TaskClock       *float64 `protobuf:"fixed64,14,opt,name=task_clock,json=taskClock" json:"task_clock,omitempty"`
	PageFaults      *uint64  `protobuf:"varint,15,opt,name=page_faults,json=pageFaults" json:"page_faults,omitempty"`
	MinorFaults     *uint64  `protobuf:"varint,16,opt,name=minor_faults,json=minorFaults" json:"minor_faults,omitempty"`
	MajorFaults     *uint64  `protobuf:"varint,17,opt,name=major_faults,json=majorFaults" json:"major_faults,omitempty"`
	ContextSwitches *uint64  `protobuf:"varint,18,opt,name=context_switches,json=contextSwitches" json:"context_switches,omitempty"`
	CPUMigrations   *uint64  `protobuf:"varint,19,opt,name=cpu_migrations,json=cpuMigrations" json:"cpu_migrations,omitempty"`
	AlignmentFaults *uint64  `protobuf:"varint,20,opt,name=alignment_faults,json=alignmentFaults" json:"alignment_faults,omitempty"`
	EmulationFaults *uint64  `protobuf:"varint,21,opt,name=emulation_faults,json=emulationFaults" json:"emulation_faults,omitempty"`
	// Hardware cache event.
	L1DcacheLoads          *uint64 `protobuf:"varint,22,opt,name=l1_dcache_loads,json=l1DcacheLoads" json:"l1_dcache_loads,omitempty"`
	L1DcacheLoadMisses     *uint64 `protobuf:"varint,23,opt,name=l1_dcache_load_misses,json=l1DcacheLoadMisses" json:"l1_dcache_load_misses,omitempty"`
	L1DcacheStores         *uint64 `protobuf:"varint,24,opt,name=l1_dcache_stores,json=l1DcacheStores" json:"l1_dcache_stores,omitempty"`
	L1DcacheStoreMisses    *uint64 `protobuf:"varint,25,opt,name=l1_dcache_store_misses,json=l1DcacheStoreMisses" json:"l1_dcache_store_misses,omitempty"`
	L1DcachePrefetches     *uint64 `protobuf:"varint,26,opt,name=l1_dcache_prefetches,json=l1DcachePrefetches" json:"l1_dcache_prefetches,omitempty"`
	L1DcachePrefetchMisses *uint64 `protobuf:"varint,27,opt,name=l1_dcache_prefetch_misses,json=l1DcachePrefetchMisses" json:"l1_dcache_prefetch_misses,omitempty"`
	L1IcacheLoads          *uint64 `protobuf:"varint,28,opt,name=l1_icache_loads,json=l1IcacheLoads" json:"l1_icache_loads,omitempty"`
	L1IcacheLoadMisses     *uint64 `protobuf:"varint,29,opt,name=l1_icache_load_misses,json=l1IcacheLoadMisses" json:"l1_icache_load_misses,omitempty"`
	L1IcachePrefetches     *uint64 `protobuf:"varint,30,opt,name=l1_icache_prefetches,json=l1IcachePrefetches" json:"l1_icache_prefetches,omitempty"`
	L1IcachePrefetchMisses *uint64 `protobuf:"varint,31,opt,name=l1_icache_prefetch_misses,json=l1IcachePrefetchMisses" json:"l1_icache_prefetch_misses,omitempty"`
	LLCLoads               *uint64 `protobuf:"varint,32,opt,name=llc_loads,json=llcLoads" json:"llc_loads,omitempty"`
	LLCLoadMisses          *uint64 `protobuf:"varint,33,opt,name=llc_load_misses,json=llcLoadMisses" json:"llc_load_misses,omitempty"`
	LLCStores              *uint64 `protobuf:"varint,34,opt,name=llc_stores,json=llcStores" json:"llc_stores,omitempty"`
	LLCStoreMisses         *uint64 `protobuf:"varint,35,opt,name=llc_store_misses,json=llcStoreMisses" json:"llc_store_misses,omitempty"`
	LLCPrefetches          *uint64 `protobuf:"varint,36,opt,name=llc_prefetches,json=llcPrefetches" json:"llc_prefetches,omitempty"`
	LLCPrefetchMisses      *uint64 `protobuf:"varint,37,opt,name=llc_prefetch_misses,json=llcPrefetchMisses" json:"llc_prefetch_misses,omitempty"`
	DTLBLoads              *uint64 `protobuf:"varint,38,opt,name=dtlb_loads,json=dtlbLoads" json:"dtlb_loads,omitempty"`
	DTLBLoadMisses         *uint64 `protobuf:"varint,39,opt,name=dtlb_load_misses,json=dtlbLoadMisses" json:"dtlb_load_misses,omitempty"`
	DTLBStores             *uint64 `protobuf:"varint,40,opt,name=dtlb_stores,json=dtlbStores" json:"dtlb_stores,omitempty"`
	DTLBStoreMisses        *uint64 `protobuf:"varint,41,opt,name=dtlb_store_misses,json=dtlbStoreMisses" json:"dtlb_store_misses,omitempty"`
	DTLBPrefetches         *uint64 `protobuf:"varint,42,opt,name=dtlb_prefetches,json=dtlbPrefetches" json:"dtlb_prefetches,omitempty"`
	DTLBPrefetchMisses     *uint64 `protobuf:"varint,43,opt,name=dtlb_prefetch_misses,json=dtlbPrefetchMisses" json:"dtlb_prefetch_misses,omitempty"`
	ITLBLoads              *uint64 `protobuf:"varint,44,opt,name=itlb_loads,json=itlbLoads" json:"itlb_loads,omitempty"`
	ITLBLoadMisses         *uint64 `protobuf:"varint,45,opt,name=itlb_load_misses,json=itlbLoadMisses" json:"itlb_load_misses,omitempty"`
	BranchLoads            *uint64 `protobuf:"varint,46,opt,name=branch_loads,json=branchLoads" json:"branch_loads,omitempty"`
	BranchLoadMisses       *uint64 `protobuf:"varint,47,opt,name=branch_load_misses,json=branchLoadMisses" json:"branch_load_misses,omitempty"`
	NodeLoads              *uint64 `protobuf:"varint,48,opt,name=node_loads,json=nodeLoads" json:"node_loads,omitempty"`
	NodeLoadMisses         *uint64 `protobuf:"varint,49,opt,name=node_load_misses,json=nodeLoadMisses" json:"node_load_misses,omitempty"`
	NodeStores             *uint64 `protobuf:"varint,50,opt,name=node_stores,json=nodeStores" json:"node_stores,omitempty"`
	NodeStoreMisses        *uint64 `protobuf:"varint,51,opt,name=node_store_misses,json=nodeStoreMisses" json:"node_store_misses,omitempty"`
	NodePrefetches         *uint64 `protobuf:"varint,52,opt,name=node_prefetches,json=nodePrefetches" json:"node_prefetches,omitempty"`
	NodePrefetchMisses     *uint64 `protobuf:"varint,53,opt,name=node_prefetch_misses,json=nodePrefetchMisses" json:"node_prefetch_misses,omitempty"`
}

func (m *PerfStatistics) Reset()                    { *m = PerfStatistics{} }
func (*PerfStatistics) ProtoMessage()               {}
func (*PerfStatistics) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{39} }

func (m *PerfStatistics) GetTimestamp() float64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *PerfStatistics) GetDuration() float64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *PerfStatistics) GetCycles() uint64 {
	if m != nil && m.Cycles != nil {
		return *m.Cycles
	}
	return 0
}

func (m *PerfStatistics) GetStalledCyclesFrontend() uint64 {
	if m != nil && m.StalledCyclesFrontend != nil {
		return *m.StalledCyclesFrontend
	}
	return 0
}

func (m *PerfStatistics) GetStalledCyclesBackend() uint64 {
	if m != nil && m.StalledCyclesBackend != nil {
		return *m.StalledCyclesBackend
	}
	return 0
}

func (m *PerfStatistics) GetInstructions() uint64 {
	if m != nil && m.Instructions != nil {
		return *m.Instructions
	}
	return 0
}

func (m *PerfStatistics) GetCacheReferences() uint64 {
	if m != nil && m.CacheReferences != nil {
		return *m.CacheReferences
	}
	return 0
}

func (m *PerfStatistics) GetCacheMisses() uint64 {
	if m != nil && m.CacheMisses != nil {
		return *m.CacheMisses
	}
	return 0
}

func (m *PerfStatistics) GetBranches() uint64 {
	if m != nil && m.Branches != nil {
		return *m.Branches
	}
	return 0
}

func (m *PerfStatistics) GetBranchMisses() uint64 {
	if m != nil && m.BranchMisses != nil {
		return *m.BranchMisses
	}
	return 0
}

func (m *PerfStatistics) GetBusCycles() uint64 {
	if m != nil && m.BusCycles != nil {
		return *m.BusCycles
	}
	return 0
}

func (m *PerfStatistics) GetRefCycles() uint64 {
	if m != nil && m.RefCycles != nil {
		return *m.RefCycles
	}
	return 0
}

func (m *PerfStatistics) GetCPUClock() float64 {
	if m != nil && m.CPUClock != nil {
		return *m.CPUClock
	}
	return 0
}

func (m *PerfStatistics) GetTaskClock() float64 {
	if m != nil && m.TaskClock != nil {
		return *m.TaskClock
	}
	return 0
}

func (m *PerfStatistics) GetPageFaults() uint64 {
	if m != nil && m.PageFaults != nil {
		return *m.PageFaults
	}
	return 0
}

func (m *PerfStatistics) GetMinorFaults() uint64 {
	if m != nil && m.MinorFaults != nil {
		return *m.MinorFaults
	}
	return 0
}

func (m *PerfStatistics) GetMajorFaults() uint64 {
	if m != nil && m.MajorFaults != nil {
		return *m.MajorFaults
	}
	return 0
}

func (m *PerfStatistics) GetContextSwitches() uint64 {
	if m != nil && m.ContextSwitches != nil {
		return *m.ContextSwitches
	}
	return 0
}

func (m *PerfStatistics) GetCPUMigrations() uint64 {
	if m != nil && m.CPUMigrations != nil {
		return *m.CPUMigrations
	}
	return 0
}

func (m *PerfStatistics) GetAlignmentFaults() uint64 {
	if m != nil && m.AlignmentFaults != nil {
		return *m.AlignmentFaults
	}
	return 0
}

func (m *PerfStatistics) GetEmulationFaults() uint64 {
	if m != nil && m.EmulationFaults != nil {
		return *m.EmulationFaults
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheLoads() uint64 {
	if m != nil && m.L1DcacheLoads != nil {
		return *m.L1DcacheLoads
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheLoadMisses() uint64 {
	if m != nil && m.L1DcacheLoadMisses != nil {
		return *m.L1DcacheLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheStores() uint64 {
	if m != nil && m.L1DcacheStores != nil {
		return *m.L1DcacheStores
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheStoreMisses() uint64 {
	if m != nil && m.L1DcacheStoreMisses != nil {
		return *m.L1DcacheStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1DcachePrefetches() uint64 {
	if m != nil && m.L1DcachePrefetches != nil {
		return *m.L1DcachePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetL1DcachePrefetchMisses() uint64 {
	if m != nil && m.L1DcachePrefetchMisses != nil {
		return *m.L1DcachePrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1IcacheLoads() uint64 {
	if m != nil && m.L1IcacheLoads != nil {
		return *m.L1IcacheLoads
	}
	return 0
}

func (m *PerfStatistics) GetL1IcacheLoadMisses() uint64 {
	if m != nil && m.L1IcacheLoadMisses != nil {
		return *m.L1IcacheLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1IcachePrefetches() uint64 {
	if m != nil && m.L1IcachePrefetches != nil {
		return *m.L1IcachePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetL1IcachePrefetchMisses() uint64 {
	if m != nil && m.L1IcachePrefetchMisses != nil {
		return *m.L1IcachePrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetLLCLoads() uint64 {
	if m != nil && m.LLCLoads != nil {
		return *m.LLCLoads
	}
	return 0
}

func (m *PerfStatistics) GetLLCLoadMisses() uint64 {
	if m != nil && m.LLCLoadMisses != nil {
		return *m.LLCLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetLLCStores() uint64 {
	if m != nil && m.LLCStores != nil {
		return *m.LLCStores
	}
	return 0
}

func (m *PerfStatistics) GetLLCStoreMisses() uint64 {
	if m != nil && m.LLCStoreMisses != nil {
		return *m.LLCStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetLLCPrefetches() uint64 {
	if m != nil && m.LLCPrefetches != nil {
		return *m.LLCPrefetches
	}
	return 0
}

func (m *PerfStatistics) GetLLCPrefetchMisses() uint64 {
	if m != nil && m.LLCPrefetchMisses != nil {
		return *m.LLCPrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetDTLBLoads() uint64 {
	if m != nil && m.DTLBLoads != nil {
		return *m.DTLBLoads
	}
	return 0
}

func (m *PerfStatistics) GetDTLBLoadMisses() uint64 {
	if m != nil && m.DTLBLoadMisses != nil {
		return *m.DTLBLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetDTLBStores() uint64 {
	if m != nil && m.DTLBStores != nil {
		return *m.DTLBStores
	}
	return 0
}

func (m *PerfStatistics) GetDTLBStoreMisses() uint64 {
	if m != nil && m.DTLBStoreMisses != nil {
		return *m.DTLBStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetDTLBPrefetches() uint64 {
	if m != nil && m.DTLBPrefetches != nil {
		return *m.DTLBPrefetches
	}
	return 0
}

func (m *PerfStatistics) GetDTLBPrefetchMisses() uint64 {
	if m != nil && m.DTLBPrefetchMisses != nil {
		return *m.DTLBPrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetITLBLoads() uint64 {
	if m != nil && m.ITLBLoads != nil {
		return *m.ITLBLoads
	}
	return 0
}

func (m *PerfStatistics) GetITLBLoadMisses() uint64 {
	if m != nil && m.ITLBLoadMisses != nil {
		return *m.ITLBLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetBranchLoads() uint64 {
	if m != nil && m.BranchLoads != nil {
		return *m.BranchLoads
	}
	return 0
}

func (m *PerfStatistics) GetBranchLoadMisses() uint64 {
	if m != nil && m.BranchLoadMisses != nil {
		return *m.BranchLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodeLoads() uint64 {
	if m != nil && m.NodeLoads != nil {
		return *m.NodeLoads
	}
	return 0
}

func (m *PerfStatistics) GetNodeLoadMisses() uint64 {
	if m != nil && m.NodeLoadMisses != nil {
		return *m.NodeLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodeStores() uint64 {
	if m != nil && m.NodeStores != nil {
		return *m.NodeStores
	}
	return 0
}

func (m *PerfStatistics) GetNodeStoreMisses() uint64 {
	if m != nil && m.NodeStoreMisses != nil {
		return *m.NodeStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodePrefetches() uint64 {
	if m != nil && m.NodePrefetches != nil {
		return *m.NodePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetNodePrefetchMisses() uint64 {
	if m != nil && m.NodePrefetchMisses != nil {
		return *m.NodePrefetchMisses
	}
	return 0
}

// *
// Describes a request for resources that can be used by a framework
// to proactively influence the allocator.  If 'agent_id' is provided
// then this request is assumed to only apply to resources on that
// agent.
type Request struct {
	AgentID   *AgentID   `protobuf:"bytes,1,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	Resources []Resource `protobuf:"bytes,2,rep,name=resources" json:"resources"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{40} }

func (m *Request) GetAgentID() *AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *Request) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Describes some resources available on an agent. An offer only
// contains resources from a single agent.
type Offer struct {
	ID          OfferID     `protobuf:"bytes,1,req,name=id" json:"id"`
	FrameworkID FrameworkID `protobuf:"bytes,2,req,name=framework_id,json=frameworkId" json:"framework_id"`
	AgentID     AgentID     `protobuf:"bytes,3,req,name=agent_id,json=agentId" json:"agent_id"`
	Hostname    string      `protobuf:"bytes,4,req,name=hostname" json:"hostname"`
	// URL for reaching the agent running on the host.
	URL *URL `protobuf:"bytes,8,opt,name=url" json:"url,omitempty"`
	// The domain of the agent.
	Domain      *DomainInfo  `protobuf:"bytes,11,opt,name=domain" json:"domain,omitempty"`
	Resources   []Resource   `protobuf:"bytes,5,rep,name=resources" json:"resources"`
	Attributes  []Attribute  `protobuf:"bytes,7,rep,name=attributes" json:"attributes"`
	ExecutorIDs []ExecutorID `protobuf:"bytes,6,rep,name=executor_ids,json=executorIds" json:"executor_ids"`
	// Signifies that the resources in this Offer may be unavailable during
	// the given interval.  Any tasks launched using these resources may be
	// killed when the interval arrives.  For example, these resources may be
	// part of a planned maintenance schedule.
	//
	// This field only provides information about a planned unavailability.
	// The unavailability interval may not necessarily start at exactly this
	// interval, nor last for exactly the duration of this interval.
	// The unavailability may also be forever!  See comments in
	// `Unavailability` for more details.
	Unavailability *Unavailability `protobuf:"bytes,9,opt,name=unavailability" json:"unavailability,omitempty"`
	// An offer represents resources allocated to *one* of the
	// roles managed by the scheduler. (Therefore, each
	// `Offer.resources[i].allocation_info` will match the
	// top level `Offer.allocation_info`).
	AllocationInfo *Resource_AllocationInfo `protobuf:"bytes,10,opt,name=allocation_info,json=allocationInfo" json:"allocation_info,omitempty"`
}

func (m *Offer) Reset()                    { *m = Offer{} }
func (*Offer) ProtoMessage()               {}
func (*Offer) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{41} }

func (m *Offer) GetID() OfferID {
	if m != nil {
		return m.ID
	}
	return OfferID{}
}

func (m *Offer) GetFrameworkID() FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return FrameworkID{}
}

func (m *Offer) GetAgentID() AgentID {
	if m != nil {
		return m.AgentID
	}
	return AgentID{}
}

func (m *Offer) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *Offer) GetURL() *URL {
	if m != nil {
		return m.URL
	}
	return nil
}

func (m *Offer) GetDomain() *DomainInfo {
	if m != nil {
		return m.Domain
	}
	return nil
}

func (m *Offer) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Offer) GetAttributes() []Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Offer) GetExecutorIDs() []ExecutorID {
	if m != nil {
		return m.ExecutorIDs
	}
	return nil
}

func (m *Offer) GetUnavailability() *Unavailability {
	if m != nil {
		return m.Unavailability
	}
	return nil
}

func (m *Offer) GetAllocationInfo() *Resource_AllocationInfo {
	if m != nil {
		return m.AllocationInfo
	}
	return nil
}

// Defines an operation that can be performed against offers.
type Offer_Operation struct {
	Type Offer_Operation_Type `protobuf:"varint,1,opt,name=type,enum=mesos.Offer_Operation_Type" json:"type"`
	// NOTE: The `id` field will allow frameworks to indicate that they wish to
	// receive feedback about an operation. Since this feature is not yet
	// implemented, the `id` field should NOT be set at present. See MESOS-8054.
	ID            *OperationID                   `protobuf:"bytes,12,opt,name=id" json:"id,omitempty"`
	Launch        *Offer_Operation_Launch        `protobuf:"bytes,2,opt,name=launch" json:"launch,omitempty"`
	LaunchGroup   *Offer_Operation_LaunchGroup   `protobuf:"bytes,7,opt,name=launch_group,json=launchGroup" json:"launch_group,omitempty"`
	Reserve       *Offer_Operation_Reserve       `protobuf:"bytes,3,opt,name=reserve" json:"reserve,omitempty"`
	Unreserve     *Offer_Operation_Unreserve     `protobuf:"bytes,4,opt,name=unreserve" json:"unreserve,omitempty"`
	Create        *Offer_Operation_Create        `protobuf:"bytes,5,opt,name=create" json:"create,omitempty"`
	Destroy       *Offer_Operation_Destroy       `protobuf:"bytes,6,opt,name=destroy" json:"destroy,omitempty"`
	CreateVolume  *Offer_Operation_CreateVolume  `protobuf:"bytes,8,opt,name=create_volume,json=createVolume" json:"create_volume,omitempty"`
	DestroyVolume *Offer_Operation_DestroyVolume `protobuf:"bytes,9,opt,name=destroy_volume,json=destroyVolume" json:"destroy_volume,omitempty"`
	CreateBlock   *Offer_Operation_CreateBlock   `protobuf:"bytes,10,opt,name=create_block,json=createBlock" json:"create_block,omitempty"`
	DestroyBlock  *Offer_Operation_DestroyBlock  `protobuf:"bytes,11,opt,name=destroy_block,json=destroyBlock" json:"destroy_block,omitempty"`
}

func (m *Offer_Operation) Reset()                    { *m = Offer_Operation{} }
func (*Offer_Operation) ProtoMessage()               {}
func (*Offer_Operation) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{41, 0} }

func (m *Offer_Operation) GetType() Offer_Operation_Type {
	if m != nil {
		return m.Type
	}
	return Offer_Operation_UNKNOWN
}

func (m *Offer_Operation) GetID() *OperationID {
	if m != nil {
		return m.ID
	}
	return nil
}

func (m *Offer_Operation) GetLaunch() *Offer_Operation_Launch {
	if m != nil {
		return m.Launch
	}
	return nil
}

func (m *Offer_Operation) GetLaunchGroup() *Offer_Operation_LaunchGroup {
	if m != nil {
		return m.LaunchGroup
	}
	return nil
}

func (m *Offer_Operation) GetReserve() *Offer_Operation_Reserve {
	if m != nil {
		return m.Reserve
	}
	return nil
}

func (m *Offer_Operation) GetUnreserve() *Offer_Operation_Unreserve {
	if m != nil {
		return m.Unreserve
	}
	return nil
}

func (m *Offer_Operation) GetCreate() *Offer_Operation_Create {
	if m != nil {
		return m.Create
	}
	return nil
}

func (m *Offer_Operation) GetDestroy() *Offer_Operation_Destroy {
	if m != nil {
		return m.Destroy
	}
	return nil
}

func (m *Offer_Operation) GetCreateVolume() *Offer_Operation_CreateVolume {
	if m != nil {
		return m.CreateVolume
	}
	return nil
}

func (m *Offer_Operation) GetDestroyVolume() *Offer_Operation_DestroyVolume {
	if m != nil {
		return m.DestroyVolume
	}
	return nil
}

func (m *Offer_Operation) GetCreateBlock() *Offer_Operation_CreateBlock {
	if m != nil {
		return m.CreateBlock
	}
	return nil
}

func (m *Offer_Operation) GetDestroyBlock() *Offer_Operation_DestroyBlock {
	if m != nil {
		return m.DestroyBlock
	}
	return nil
}

// TODO(vinod): Deprecate this in favor of `LaunchGroup` below.
type Offer_Operation_Launch struct {
	TaskInfos []TaskInfo `protobuf:"bytes,1,rep,name=task_infos,json=taskInfos" json:"task_infos"`
}

func (m *Offer_Operation_Launch) Reset()      { *m = Offer_Operation_Launch{} }
func (*Offer_Operation_Launch) ProtoMessage() {}
func (*Offer_Operation_Launch) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 0}
}

func (m *Offer_Operation_Launch) GetTaskInfos() []TaskInfo {
	if m != nil {
		return m.TaskInfos
	}
	return nil
}

// Unlike `Launch` above, all the tasks in a `task_group` are
// atomically delivered to an executor.
//
// `NetworkInfo` set on executor will be shared by all tasks in
// the task group.
//
// TODO(vinod): Any volumes set on executor could be used by a
// task by explicitly setting `Volume.source` in its resources.
type Offer_Operation_LaunchGroup struct {
	Executor  ExecutorInfo  `protobuf:"bytes,1,req,name=executor" json:"executor"`
	TaskGroup TaskGroupInfo `protobuf:"bytes,2,req,name=task_group,json=taskGroup" json:"task_group"`
}

func (m *Offer_Operation_LaunchGroup) Reset()      { *m = Offer_Operation_LaunchGroup{} }
func (*Offer_Operation_LaunchGroup) ProtoMessage() {}
func (*Offer_Operation_LaunchGroup) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 1}
}

func (m *Offer_Operation_LaunchGroup) GetExecutor() ExecutorInfo {
	if m != nil {
		return m.Executor
	}
	return ExecutorInfo{}
}

func (m *Offer_Operation_LaunchGroup) GetTaskGroup() TaskGroupInfo {
	if m != nil {
		return m.TaskGroup
	}
	return TaskGroupInfo{}
}

type Offer_Operation_Reserve struct {
	Resources []Resource `protobuf:"bytes,1,rep,name=resources" json:"resources"`
}

func (m *Offer_Operation_Reserve) Reset()      { *m = Offer_Operation_Reserve{} }
func (*Offer_Operation_Reserve) ProtoMessage() {}
func (*Offer_Operation_Reserve) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 2}
}

func (m *Offer_Operation_Reserve) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Offer_Operation_Unreserve struct {
	Resources []Resource `protobuf:"bytes,1,rep,name=resources" json:"resources"`
}

func (m *Offer_Operation_Unreserve) Reset()      { *m = Offer_Operation_Unreserve{} }
func (*Offer_Operation_Unreserve) ProtoMessage() {}
func (*Offer_Operation_Unreserve) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 3}
}

func (m *Offer_Operation_Unreserve) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Offer_Operation_Create struct {
	Volumes []Resource `protobuf:"bytes,1,rep,name=volumes" json:"volumes"`
}

func (m *Offer_Operation_Create) Reset()      { *m = Offer_Operation_Create{} }
func (*Offer_Operation_Create) ProtoMessage() {}
func (*Offer_Operation_Create) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 4}
}

func (m *Offer_Operation_Create) GetVolumes() []Resource {
	if m != nil {
		return m.Volumes
	}
	return nil
}

type Offer_Operation_Destroy struct {
	Volumes []Resource `protobuf:"bytes,1,rep,name=volumes" json:"volumes"`
}

func (m *Offer_Operation_Destroy) Reset()      { *m = Offer_Operation_Destroy{} }
func (*Offer_Operation_Destroy) ProtoMessage() {}
func (*Offer_Operation_Destroy) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 5}
}

func (m *Offer_Operation_Destroy) GetVolumes() []Resource {
	if m != nil {
		return m.Volumes
	}
	return nil
}

type Offer_Operation_CreateVolume struct {
	Source     Resource                      `protobuf:"bytes,1,req,name=source" json:"source"`
	TargetType Resource_DiskInfo_Source_Type `protobuf:"varint,2,req,name=target_type,json=targetType,enum=mesos.Resource_DiskInfo_Source_Type" json:"target_type"`
}

func (m *Offer_Operation_CreateVolume) Reset()      { *m = Offer_Operation_CreateVolume{} }
func (*Offer_Operation_CreateVolume) ProtoMessage() {}
func (*Offer_Operation_CreateVolume) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 6}
}

func (m *Offer_Operation_CreateVolume) GetSource() Resource {
	if m != nil {
		return m.Source
	}
	return Resource{}
}

func (m *Offer_Operation_CreateVolume) GetTargetType() Resource_DiskInfo_Source_Type {
	if m != nil {
		return m.TargetType
	}
	return Resource_DiskInfo_Source_UNKNOWN
}

type Offer_Operation_DestroyVolume struct {
	Volume Resource `protobuf:"bytes,1,req,name=volume" json:"volume"`
}

func (m *Offer_Operation_DestroyVolume) Reset()      { *m = Offer_Operation_DestroyVolume{} }
func (*Offer_Operation_DestroyVolume) ProtoMessage() {}
func (*Offer_Operation_DestroyVolume) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 7}
}

func (m *Offer_Operation_DestroyVolume) GetVolume() Resource {
	if m != nil {
		return m.Volume
	}
	return Resource{}
}

type Offer_Operation_CreateBlock struct {
	Source Resource `protobuf:"bytes,1,req,name=source" json:"source"`
}

func (m *Offer_Operation_CreateBlock) Reset()      { *m = Offer_Operation_CreateBlock{} }
func (*Offer_Operation_CreateBlock) ProtoMessage() {}
func (*Offer_Operation_CreateBlock) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 8}
}

func (m *Offer_Operation_CreateBlock) GetSource() Resource {
	if m != nil {
		return m.Source
	}
	return Resource{}
}

type Offer_Operation_DestroyBlock struct {
	Block Resource `protobuf:"bytes,1,req,name=block" json:"block"`
}

func (m *Offer_Operation_DestroyBlock) Reset()      { *m = Offer_Operation_DestroyBlock{} }
func (*Offer_Operation_DestroyBlock) ProtoMessage() {}
func (*Offer_Operation_DestroyBlock) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{41, 0, 9}
}

func (m *Offer_Operation_DestroyBlock) GetBlock() Resource {
	if m != nil {
		return m.Block
	}
	return Resource{}
}

// *
// A request to return some resources occupied by a framework.
type InverseOffer struct {
	// This is the same OfferID as found in normal offers, which allows
	// re-use of some of the OfferID-only messages.
	OfferID OfferID `protobuf:"bytes,1,req,name=id" json:"id"`
	// URL for reaching the agent running on the host.  This enables some
	// optimizations as described in MESOS-3012, such as allowing the
	// scheduler driver to bypass the master and talk directly with an agent.
	URL *URL `protobuf:"bytes,2,opt,name=url" json:"url,omitempty"`
	// The framework that should release its resources.
	// If no specifics are provided (i.e. which agent), all the framework's
	// resources are requested back.
	FrameworkID FrameworkID `protobuf:"bytes,3,req,name=framework_id,json=frameworkId" json:"framework_id"`
	// Specified if the resources need to be released from a particular agent.
	// All the framework's resources on this agent are requested back,
	// unless further qualified by the `resources` field.
	AgentID *AgentID `protobuf:"bytes,4,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	// This InverseOffer represents a planned unavailability event in the
	// specified interval.  Any tasks running on the given framework or agent
	// may be killed when the interval arrives.  Therefore, frameworks should
	// aim to gracefully terminate tasks prior to the arrival of the interval.
	//
	// For reserved resources, the resources are expected to be returned to the
	// framework after the unavailability interval.  This is an expectation,
	// not a guarantee.  For example, if the unavailability duration is not set,
	// the resources may be removed permanently.
	//
	// For other resources, there is no guarantee that requested resources will
	// be returned after the unavailability interval.  The allocator has no
	// obligation to re-offer these resources to the prior framework after
	// the unavailability.
	Unavailability Unavailability `protobuf:"bytes,5,req,name=unavailability" json:"unavailability"`
	// A list of resources being requested back from the framework,
	// on the agent identified by `agent_id`.  If no resources are specified
	// then all resources are being requested back.  For the purpose of
	// maintenance, this field is always empty (maintenance always requests
	// all resources back).
	Resources []Resource `protobuf:"bytes,6,rep,name=resources" json:"resources"`
}

func (m *InverseOffer) Reset()                    { *m = InverseOffer{} }
func (*InverseOffer) ProtoMessage()               {}
func (*InverseOffer) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{42} }

func (m *InverseOffer) GetOfferID() OfferID {
	if m != nil {
		return m.OfferID
	}
	return OfferID{}
}

func (m *InverseOffer) GetURL() *URL {
	if m != nil {
		return m.URL
	}
	return nil
}

func (m *InverseOffer) GetFrameworkID() FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return FrameworkID{}
}

func (m *InverseOffer) GetAgentID() *AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *InverseOffer) GetUnavailability() Unavailability {
	if m != nil {
		return m.Unavailability
	}
	return Unavailability{}
}

func (m *InverseOffer) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Describes a task. Passed from the scheduler all the way to an
// executor (see SchedulerDriver::launchTasks and
// Executor::launchTask). Either ExecutorInfo or CommandInfo should be set.
// A different executor can be used to launch this task, and subsequent tasks
// meant for the same executor can reuse the same ExecutorInfo struct.
type TaskInfo struct {
	Name      string        `protobuf:"bytes,1,req,name=name" json:"name"`
	TaskID    TaskID        `protobuf:"bytes,2,req,name=task_id,json=taskId" json:"task_id"`
	AgentID   AgentID       `protobuf:"bytes,3,req,name=agent_id,json=agentId" json:"agent_id"`
	Resources []Resource    `protobuf:"bytes,4,rep,name=resources" json:"resources"`
	Executor  *ExecutorInfo `protobuf:"bytes,5,opt,name=executor" json:"executor,omitempty"`
	Command   *CommandInfo  `protobuf:"bytes,7,opt,name=command" json:"command,omitempty"`
	// Task provided with a container will launch the container as part
	// of this task paired with the task's CommandInfo.
	Container *ContainerInfo `protobuf:"bytes,9,opt,name=container" json:"container,omitempty"`
	// A health check for the task. Implemented for executor-less
	// command-based tasks. For tasks that specify an executor, it is
	// the executor's responsibility to implement the health checking.
	HealthCheck *HealthCheck `protobuf:"bytes,8,opt,name=health_check,json=healthCheck" json:"health_check,omitempty"`
	// A general check for the task. Implemented for all built-in executors.
	// For tasks that specify an executor, it is the executor's responsibility
	// to implement checking support. Executors should (all built-in executors
	// will) neither interpret nor act on the check's result.
	//
	// NOTE: Check support in built-in executors is experimental.
	//
	// TODO(alexr): Consider supporting multiple checks per task.
	Check *CheckInfo `protobuf:"bytes,13,opt,name=check" json:"check,omitempty"`
	// A kill policy for the task. Implemented for executor-less
	// command-based and docker tasks. For tasks that specify an
	// executor, it is the executor's responsibility to implement
	// the kill policy.
	KillPolicy *KillPolicy `protobuf:"bytes,12,opt,name=kill_policy,json=killPolicy" json:"kill_policy,omitempty"`
	Data       []byte      `protobuf:"bytes,6,opt,name=data" json:"data,omitempty"`
	// Labels are free-form key value pairs which are exposed through
	// master and agent endpoints. Labels will not be interpreted or
	// acted upon by Mesos itself. As opposed to the data field, labels
	// will be kept in memory on master and agent processes. Therefore,
	// labels should be used to tag tasks with light-weight meta-data.
	// Labels should not contain duplicate key-value pairs.
	Labels *Labels `protobuf:"bytes,10,opt,name=labels" json:"labels,omitempty"`
	// Service discovery information for the task. It is not interpreted
	// or acted upon by Mesos. It is up to a service discovery system
	// to use this information as needed and to handle tasks without
	// service discovery information.
	Discovery *DiscoveryInfo `protobuf:"bytes,11,opt,name=discovery" json:"discovery,omitempty"`
}

func (m *TaskInfo) Reset()                    { *m = TaskInfo{} }
func (*TaskInfo) ProtoMessage()               {}
func (*TaskInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{43} }

func (m *TaskInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TaskInfo) GetTaskID() TaskID {
	if m != nil {
		return m.TaskID
	}
	return TaskID{}
}

func (m *TaskInfo) GetAgentID() AgentID {
	if m != nil {
		return m.AgentID
	}
	return AgentID{}
}

func (m *TaskInfo) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *TaskInfo) GetExecutor() *ExecutorInfo {
	if m != nil {
		return m.Executor
	}
	return nil
}

func (m *TaskInfo) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *TaskInfo) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *TaskInfo) GetHealthCheck() *HealthCheck {
	if m != nil {
		return m.HealthCheck
	}
	return nil
}

func (m *TaskInfo) GetCheck() *CheckInfo {
	if m != nil {
		return m.Check
	}
	return nil
}

func (m *TaskInfo) GetKillPolicy() *KillPolicy {
	if m != nil {
		return m.KillPolicy
	}
	return nil
}

func (m *TaskInfo) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *TaskInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *TaskInfo) GetDiscovery() *DiscoveryInfo {
	if m != nil {
		return m.Discovery
	}
	return nil
}

// *
// Describes a group of tasks that belong to an executor. The
// executor will receive the task group in a single message to
// allow the group to be launched "atomically".
//
// NOTES:
// 1) `NetworkInfo` must not be set inside task's `ContainerInfo`.
// 2) `TaskInfo.executor` doesn't need to set. If set, it should match
//    `LaunchGroup.executor`.
type TaskGroupInfo struct {
	Tasks []TaskInfo `protobuf:"bytes,1,rep,name=tasks" json:"tasks"`
}

func (m *TaskGroupInfo) Reset()                    { *m = TaskGroupInfo{} }
func (*TaskGroupInfo) ProtoMessage()               {}
func (*TaskGroupInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{44} }

func (m *TaskGroupInfo) GetTasks() []TaskInfo {
	if m != nil {
		return m.Tasks
	}
	return nil
}

// *
// Describes a task, similar to `TaskInfo`.
//
// `Task` is used in some of the Mesos messages found below.
// `Task` is used instead of `TaskInfo` if:
//   1) we need additional IDs, such as a specific
//      framework, executor, or agent; or
//   2) we do not need the additional data, such as the command run by the
//      task or the health checks.  These additional fields may be large and
//      unnecessary for some Mesos messages.
//
// `Task` is generally constructed from a `TaskInfo`.  See protobuf::createTask.
type Task struct {
	Name        string       `protobuf:"bytes,1,req,name=name" json:"name"`
	TaskID      TaskID       `protobuf:"bytes,2,req,name=task_id,json=taskId" json:"task_id"`
	FrameworkID FrameworkID  `protobuf:"bytes,3,req,name=framework_id,json=frameworkId" json:"framework_id"`
	ExecutorID  *ExecutorID  `protobuf:"bytes,4,opt,name=executor_id,json=executorId" json:"executor_id,omitempty"`
	AgentID     AgentID      `protobuf:"bytes,5,req,name=agent_id,json=agentId" json:"agent_id"`
	State       *TaskState   `protobuf:"varint,6,req,name=state,enum=mesos.TaskState" json:"state,omitempty"`
	Resources   []Resource   `protobuf:"bytes,7,rep,name=resources" json:"resources"`
	Statuses    []TaskStatus `protobuf:"bytes,8,rep,name=statuses" json:"statuses"`
	// These fields correspond to the state and uuid of the latest
	// status update forwarded to the master.
	// NOTE: Either both the fields must be set or both must be unset.
	StatusUpdateState *TaskState `protobuf:"varint,9,opt,name=status_update_state,json=statusUpdateState,enum=mesos.TaskState" json:"status_update_state,omitempty"`
	StatusUpdateUUID  []byte     `protobuf:"bytes,10,opt,name=status_update_uuid,json=statusUpdateUuid" json:"status_update_uuid,omitempty"`
	Labels            *Labels    `protobuf:"bytes,11,opt,name=labels" json:"labels,omitempty"`
	// Service discovery information for the task. It is not interpreted
	// or acted upon by Mesos. It is up to a service discovery system
	// to use this information as needed and to handle tasks without
	// service discovery information.
	Discovery *DiscoveryInfo `protobuf:"bytes,12,opt,name=discovery" json:"discovery,omitempty"`
	// Container information for the task.
	Container *ContainerInfo `protobuf:"bytes,13,opt,name=container" json:"container,omitempty"`
	// Specific user under which task is running.
	User *string `protobuf:"bytes,14,opt,name=user" json:"user,omitempty"`
}

func (m *Task) Reset()                    { *m = Task{} }
func (*Task) ProtoMessage()               {}
func (*Task) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{45} }

func (m *Task) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Task) GetTaskID() TaskID {
	if m != nil {
		return m.TaskID
	}
	return TaskID{}
}

func (m *Task) GetFrameworkID() FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return FrameworkID{}
}

func (m *Task) GetExecutorID() *ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return nil
}

func (m *Task) GetAgentID() AgentID {
	if m != nil {
		return m.AgentID
	}
	return AgentID{}
}

func (m *Task) GetState() TaskState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return TASK_STAGING
}

func (m *Task) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Task) GetStatuses() []TaskStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *Task) GetStatusUpdateState() TaskState {
	if m != nil && m.StatusUpdateState != nil {
		return *m.StatusUpdateState
	}
	return TASK_STAGING
}

func (m *Task) GetStatusUpdateUUID() []byte {
	if m != nil {
		return m.StatusUpdateUUID
	}
	return nil
}

func (m *Task) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Task) GetDiscovery() *DiscoveryInfo {
	if m != nil {
		return m.Discovery
	}
	return nil
}

func (m *Task) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *Task) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

// *
// Describes a resource limitation that caused a task failure.
type TaskResourceLimitation struct {
	// This field contains the resource whose limits were violated.
	//
	// NOTE: 'Resources' is used here because the resource may span
	// multiple roles (e.g. `"mem(*):1;mem(role):2"`).
	Resources []Resource `protobuf:"bytes,1,rep,name=resources" json:"resources"`
}

func (m *TaskResourceLimitation) Reset()                    { *m = TaskResourceLimitation{} }
func (*TaskResourceLimitation) ProtoMessage()               {}
func (*TaskResourceLimitation) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{46} }

func (m *TaskResourceLimitation) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Describes a UUID.
type UUID struct {
	Value []byte `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
}

func (m *UUID) Reset()                    { *m = UUID{} }
func (*UUID) ProtoMessage()               {}
func (*UUID) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{47} }

func (m *UUID) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// *
// Describes an operation, similar to `Offer.Operation`, with
// some additional information.
type Operation struct {
	FrameworkID  *FrameworkID    `protobuf:"bytes,1,opt,name=framework_id,json=frameworkId" json:"framework_id,omitempty"`
	AgentID      *AgentID        `protobuf:"bytes,2,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	Info         Offer_Operation `protobuf:"bytes,3,req,name=info" json:"info"`
	LatestStatus OperationStatus `protobuf:"bytes,4,req,name=latest_status,json=latestStatus" json:"latest_status"`
	// All the statuses known to this operation. Some of the statuses in this
	// list might not have been acknowledged yet. The statuses are ordered.
	Statuses []OperationStatus `protobuf:"bytes,5,rep,name=statuses" json:"statuses"`
	// This is the internal UUID for the operation, which is kept independently
	// from the framework-specified operation ID, which is optional.
	UUID UUID `protobuf:"bytes,6,req,name=uuid" json:"uuid"`
}

func (m *Operation) Reset()                    { *m = Operation{} }
func (*Operation) ProtoMessage()               {}
func (*Operation) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{48} }

func (m *Operation) GetFrameworkID() *FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return nil
}

func (m *Operation) GetAgentID() *AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *Operation) GetInfo() Offer_Operation {
	if m != nil {
		return m.Info
	}
	return Offer_Operation{}
}

func (m *Operation) GetLatestStatus() OperationStatus {
	if m != nil {
		return m.LatestStatus
	}
	return OperationStatus{}
}

func (m *Operation) GetStatuses() []OperationStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *Operation) GetUUID() UUID {
	if m != nil {
		return m.UUID
	}
	return UUID{}
}

// *
// Describes the current status of an operation.
type OperationStatus struct {
	OperationID *OperationID   `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	State       OperationState `protobuf:"varint,2,req,name=state,enum=mesos.OperationState" json:"state"`
	Message     *string        `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	// Converted resources after applying the operation. This only
	// applies if the `state` is `OPERATION_FINISHED`.
	ConvertedResources []Resource `protobuf:"bytes,4,rep,name=converted_resources,json=convertedResources" json:"converted_resources"`
	// Statuses that are delivered reliably to the scheduler will
	// include a `uuid`. The status is considered delivered once
	// it is acknowledged by the scheduler.
	UUID *UUID `protobuf:"bytes,5,opt,name=uuid" json:"uuid,omitempty"`
}

func (m *OperationStatus) Reset()                    { *m = OperationStatus{} }
func (*OperationStatus) ProtoMessage()               {}
func (*OperationStatus) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{49} }

func (m *OperationStatus) GetOperationID() *OperationID {
	if m != nil {
		return m.OperationID
	}
	return nil
}

func (m *OperationStatus) GetState() OperationState {
	if m != nil {
		return m.State
	}
	return OPERATION_UNSUPPORTED
}

func (m *OperationStatus) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *OperationStatus) GetConvertedResources() []Resource {
	if m != nil {
		return m.ConvertedResources
	}
	return nil
}

func (m *OperationStatus) GetUUID() *UUID {
	if m != nil {
		return m.UUID
	}
	return nil
}

// *
// Describes the status of a check. Type and the corresponding field, i.e.,
// `command` or `http` must be set. If the result of the check is not available
// (e.g., the check timed out), these fields must contain empty messages, i.e.,
// `exit_code` or `status_code` will be unset.
//
// NOTE: This API is unstable and the related feature is experimental.
type CheckStatusInfo struct {
	// The type of the check this status corresponds to.
	Type *CheckInfo_Type `protobuf:"varint,1,opt,name=type,enum=mesos.CheckInfo_Type" json:"type,omitempty"`
	// Status of a command check.
	Command *CheckStatusInfo_Command `protobuf:"bytes,2,opt,name=command" json:"command,omitempty"`
	// Status of an HTTP check.
	HTTP *CheckStatusInfo_Http `protobuf:"bytes,3,opt,name=http" json:"http,omitempty"`
	// Status of a TCP check.
	TCP *CheckStatusInfo_Tcp `protobuf:"bytes,4,opt,name=tcp" json:"tcp,omitempty"`
}

func (m *CheckStatusInfo) Reset()                    { *m = CheckStatusInfo{} }
func (*CheckStatusInfo) ProtoMessage()               {}
func (*CheckStatusInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{50} }

func (m *CheckStatusInfo) GetType() CheckInfo_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return CheckInfo_UNKNOWN
}

func (m *CheckStatusInfo) GetCommand() *CheckStatusInfo_Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *CheckStatusInfo) GetHTTP() *CheckStatusInfo_Http {
	if m != nil {
		return m.HTTP
	}
	return nil
}

func (m *CheckStatusInfo) GetTCP() *CheckStatusInfo_Tcp {
	if m != nil {
		return m.TCP
	}
	return nil
}

type CheckStatusInfo_Command struct {
	// Exit code of a command check. It is the result of calling
	// `WEXITSTATUS()` on `waitpid()` termination information on
	// Posix and calling `GetExitCodeProcess()` on Windows.
	ExitCode *int32 `protobuf:"varint,1,opt,name=exit_code,json=exitCode" json:"exit_code,omitempty"`
}

func (m *CheckStatusInfo_Command) Reset()                    { *m = CheckStatusInfo_Command{} }
func (*CheckStatusInfo_Command) ProtoMessage()               {}
func (*CheckStatusInfo_Command) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{50, 0} }

func (m *CheckStatusInfo_Command) GetExitCode() int32 {
	if m != nil && m.ExitCode != nil {
		return *m.ExitCode
	}
	return 0
}

type CheckStatusInfo_Http struct {
	// HTTP status code of an HTTP check.
	StatusCode *uint32 `protobuf:"varint,1,opt,name=status_code,json=statusCode" json:"status_code,omitempty"`
}

func (m *CheckStatusInfo_Http) Reset()                    { *m = CheckStatusInfo_Http{} }
func (*CheckStatusInfo_Http) ProtoMessage()               {}
func (*CheckStatusInfo_Http) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{50, 1} }

func (m *CheckStatusInfo_Http) GetStatusCode() uint32 {
	if m != nil && m.StatusCode != nil {
		return *m.StatusCode
	}
	return 0
}

type CheckStatusInfo_Tcp struct {
	// Whether a TCP connection succeeded.
	Succeeded *bool `protobuf:"varint,1,opt,name=succeeded" json:"succeeded,omitempty"`
}

func (m *CheckStatusInfo_Tcp) Reset()                    { *m = CheckStatusInfo_Tcp{} }
func (*CheckStatusInfo_Tcp) ProtoMessage()               {}
func (*CheckStatusInfo_Tcp) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{50, 2} }

func (m *CheckStatusInfo_Tcp) GetSucceeded() bool {
	if m != nil && m.Succeeded != nil {
		return *m.Succeeded
	}
	return false
}

// *
// Describes the current status of a task.
type TaskStatus struct {
	TaskID     TaskID             `protobuf:"bytes,1,req,name=task_id,json=taskId" json:"task_id"`
	State      *TaskState         `protobuf:"varint,2,req,name=state,enum=mesos.TaskState" json:"state,omitempty"`
	Message    *string            `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	Source     *TaskStatus_Source `protobuf:"varint,9,opt,name=source,enum=mesos.TaskStatus_Source" json:"source,omitempty"`
	Reason     *TaskStatus_Reason `protobuf:"varint,10,opt,name=reason,enum=mesos.TaskStatus_Reason" json:"reason,omitempty"`
	Data       []byte             `protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
	AgentID    *AgentID           `protobuf:"bytes,5,opt,name=agent_id,json=agentId" json:"agent_id,omitempty"`
	ExecutorID *ExecutorID        `protobuf:"bytes,7,opt,name=executor_id,json=executorId" json:"executor_id,omitempty"`
	Timestamp  *float64           `protobuf:"fixed64,6,opt,name=timestamp" json:"timestamp,omitempty"`
	// Statuses that are delivered reliably to the scheduler will
	// include a 'uuid'. The status is considered delivered once
	// it is acknowledged by the scheduler. Schedulers can choose
	// to either explicitly acknowledge statuses or let the scheduler
	// driver implicitly acknowledge (default).
	//
	// TODO(bmahler): This is currently overwritten in the scheduler
	// driver and executor driver, but executors will need to set this
	// to a valid RFC-4122 UUID if using the HTTP API.
	UUID []byte `protobuf:"bytes,11,opt,name=uuid" json:"uuid,omitempty"`
	// Describes whether the task has been determined to be healthy (true) or
	// unhealthy (false) according to the `health_check` field in `TaskInfo`.
	Healthy *bool `protobuf:"varint,8,opt,name=healthy" json:"healthy,omitempty"`
	// Contains check status for the check specified in the corresponding
	// `TaskInfo`. If no check has been specified, this field must be
	// absent, otherwise it must be present even if the check status is
	// not available yet. If the status update is triggered for a different
	// reason than `REASON_TASK_CHECK_STATUS_UPDATED`, this field will contain
	// the last known value.
	//
	// NOTE: A check-related task status update is triggered if and only if
	// the value or presence of any field in `CheckStatusInfo` changes.
	//
	// NOTE: Check support in built-in executors is experimental.
	CheckStatus *CheckStatusInfo `protobuf:"bytes,15,opt,name=check_status,json=checkStatus" json:"check_status,omitempty"`
	// Labels are free-form key value pairs which are exposed through
	// master and agent endpoints. Labels will not be interpreted or
	// acted upon by Mesos itself. As opposed to the data field, labels
	// will be kept in memory on master and agent processes. Therefore,
	// labels should be used to tag TaskStatus message with light-weight
	// meta-data. Labels should not contain duplicate key-value pairs.
	Labels *Labels `protobuf:"bytes,12,opt,name=labels" json:"labels,omitempty"`
	// Container related information that is resolved dynamically such as
	// network address.
	ContainerStatus *ContainerStatus `protobuf:"bytes,13,opt,name=container_status,json=containerStatus" json:"container_status,omitempty"`
	// The time (according to the master's clock) when the agent where
	// this task was running became unreachable. This is only set on
	// status updates for tasks running on agents that are unreachable
	// (e.g., partitioned away from the master).
	UnreachableTime *TimeInfo `protobuf:"bytes,14,opt,name=unreachable_time,json=unreachableTime" json:"unreachable_time,omitempty"`
	// If the reason field indicates a container resource limitation,
	// this field optionally contains additional information.
	Limitation *TaskResourceLimitation `protobuf:"bytes,16,opt,name=limitation" json:"limitation,omitempty"`
}

func (m *TaskStatus) Reset()                    { *m = TaskStatus{} }
func (*TaskStatus) ProtoMessage()               {}
func (*TaskStatus) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{51} }

func (m *TaskStatus) GetTaskID() TaskID {
	if m != nil {
		return m.TaskID
	}
	return TaskID{}
}

func (m *TaskStatus) GetState() TaskState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return TASK_STAGING
}

func (m *TaskStatus) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *TaskStatus) GetSource() TaskStatus_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return SOURCE_MASTER
}

func (m *TaskStatus) GetReason() TaskStatus_Reason {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return REASON_COMMAND_EXECUTOR_FAILED
}

func (m *TaskStatus) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *TaskStatus) GetAgentID() *AgentID {
	if m != nil {
		return m.AgentID
	}
	return nil
}

func (m *TaskStatus) GetExecutorID() *ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return nil
}

func (m *TaskStatus) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *TaskStatus) GetUUID() []byte {
	if m != nil {
		return m.UUID
	}
	return nil
}

func (m *TaskStatus) GetHealthy() bool {
	if m != nil && m.Healthy != nil {
		return *m.Healthy
	}
	return false
}

func (m *TaskStatus) GetCheckStatus() *CheckStatusInfo {
	if m != nil {
		return m.CheckStatus
	}
	return nil
}

func (m *TaskStatus) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *TaskStatus) GetContainerStatus() *ContainerStatus {
	if m != nil {
		return m.ContainerStatus
	}
	return nil
}

func (m *TaskStatus) GetUnreachableTime() *TimeInfo {
	if m != nil {
		return m.UnreachableTime
	}
	return nil
}

func (m *TaskStatus) GetLimitation() *TaskResourceLimitation {
	if m != nil {
		return m.Limitation
	}
	return nil
}

// *
// Describes possible filters that can be applied to unused resources
// (see SchedulerDriver::launchTasks) to influence the allocator.
type Filters struct {
	// Time to consider unused resources refused. Note that all unused
	// resources will be considered refused and use the default value
	// (below) regardless of whether Filters was passed to
	// SchedulerDriver::launchTasks. You MUST pass Filters with this
	// field set to change this behavior (i.e., get another offer which
	// includes unused resources sooner or later than the default).
	//
	// If this field is set to a number of seconds greater than 31536000
	// (365 days), then the resources will be considered refused for 365
	// days. If it is set to a negative number, then the default value
	// will be used.
	RefuseSeconds *float64 `protobuf:"fixed64,1,opt,name=refuse_seconds,json=refuseSeconds,def=5" json:"refuse_seconds,omitempty"`
}

func (m *Filters) Reset()                    { *m = Filters{} }
func (*Filters) ProtoMessage()               {}
func (*Filters) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{52} }

const Default_Filters_RefuseSeconds float64 = 5

func (m *Filters) GetRefuseSeconds() float64 {
	if m != nil && m.RefuseSeconds != nil {
		return *m.RefuseSeconds
	}
	return Default_Filters_RefuseSeconds
}

// *
// Describes a collection of environment variables. This is used with
// CommandInfo in order to set environment variables before running a
// command. The contents of each variable may be specified as a string
// or a Secret; only one of `value` and `secret` must be set.
type Environment struct {
	Variables []Environment_Variable `protobuf:"bytes,1,rep,name=variables" json:"variables"`
}

func (m *Environment) Reset()                    { *m = Environment{} }
func (*Environment) ProtoMessage()               {}
func (*Environment) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{53} }

func (m *Environment) GetVariables() []Environment_Variable {
	if m != nil {
		return m.Variables
	}
	return nil
}

type Environment_Variable struct {
	Name string `protobuf:"bytes,1,req,name=name" json:"name"`
	// In Mesos 1.2, the `Environment.variables.value` message was made
	// optional. The default type for `Environment.variables.type` is now VALUE,
	// which requires `value` to be set, maintaining backward compatibility.
	//
	// TODO(greggomann): The default can be removed in Mesos 2.1 (MESOS-7134).
	Type *Environment_Variable_Type `protobuf:"varint,3,opt,name=type,enum=mesos.Environment_Variable_Type,def=1" json:"type,omitempty"`
	// Only one of `value` and `secret` must be set.
	Value  *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	Secret *Secret `protobuf:"bytes,4,opt,name=secret" json:"secret,omitempty"`
}

func (m *Environment_Variable) Reset()                    { *m = Environment_Variable{} }
func (*Environment_Variable) ProtoMessage()               {}
func (*Environment_Variable) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{53, 0} }

const Default_Environment_Variable_Type Environment_Variable_Type = Environment_Variable_VALUE

func (m *Environment_Variable) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Environment_Variable) GetType() Environment_Variable_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Default_Environment_Variable_Type
}

func (m *Environment_Variable) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *Environment_Variable) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

// *
// A generic (key, value) pair used in various places for parameters.
type Parameter struct {
	Key   string `protobuf:"bytes,1,req,name=key" json:"key"`
	Value string `protobuf:"bytes,2,req,name=value" json:"value"`
}

func (m *Parameter) Reset()                    { *m = Parameter{} }
func (*Parameter) ProtoMessage()               {}
func (*Parameter) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{54} }

func (m *Parameter) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Parameter) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// *
// Collection of Parameter.
type Parameters struct {
	Parameter []Parameter `protobuf:"bytes,1,rep,name=parameter" json:"parameter"`
}

func (m *Parameters) Reset()                    { *m = Parameters{} }
func (*Parameters) ProtoMessage()               {}
func (*Parameters) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{55} }

func (m *Parameters) GetParameter() []Parameter {
	if m != nil {
		return m.Parameter
	}
	return nil
}

// *
// Credential used in various places for authentication and
// authorization.
//
// NOTE: A 'principal' is different from 'FrameworkInfo.user'. The
// former is used for authentication and authorization while the
// latter is used to determine the default user under which the
// framework's executors/tasks are run.
type Credential struct {
	Principal string  `protobuf:"bytes,1,req,name=principal" json:"principal"`
	Secret    *string `protobuf:"bytes,2,opt,name=secret" json:"secret,omitempty"`
}

func (m *Credential) Reset()                    { *m = Credential{} }
func (*Credential) ProtoMessage()               {}
func (*Credential) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{56} }

func (m *Credential) GetPrincipal() string {
	if m != nil {
		return m.Principal
	}
	return ""
}

func (m *Credential) GetSecret() string {
	if m != nil && m.Secret != nil {
		return *m.Secret
	}
	return ""
}

// *
// Credentials used for framework authentication, HTTP authentication
// (where the common 'username' and 'password' are captured as
// 'principal' and 'secret' respectively), etc.
type Credentials struct {
	Credentials []Credential `protobuf:"bytes,1,rep,name=credentials" json:"credentials"`
}

func (m *Credentials) Reset()                    { *m = Credentials{} }
func (*Credentials) ProtoMessage()               {}
func (*Credentials) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{57} }

func (m *Credentials) GetCredentials() []Credential {
	if m != nil {
		return m.Credentials
	}
	return nil
}

// *
// Secret used to pass privileged information. It is designed to provide
// pass-by-value or pass-by-reference semantics, where the REFERENCE type can be
// used by custom modules which interact with a secure back-end.
type Secret struct {
	Type Secret_Type `protobuf:"varint,1,opt,name=type,enum=mesos.Secret_Type" json:"type"`
	// Only one of `reference` and `value` must be set.
	Reference *Secret_Reference `protobuf:"bytes,2,opt,name=reference" json:"reference,omitempty"`
	Value     *Secret_Value     `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
}

func (m *Secret) Reset()                    { *m = Secret{} }
func (*Secret) ProtoMessage()               {}
func (*Secret) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{58} }

func (m *Secret) GetType() Secret_Type {
	if m != nil {
		return m.Type
	}
	return Secret_UNKNOWN
}

func (m *Secret) GetReference() *Secret_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (m *Secret) GetValue() *Secret_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// Can be used by modules to refer to a secret stored in a secure back-end.
// The `key` field is provided to permit reference to a single value within a
// secret containing arbitrary key-value pairs.
//
// For example, given a back-end secret store with a secret named
// "my-secret" containing the following key-value pairs:
//
//   {
//     "username": "my-user",
//     "password": "my-password
//   }
//
// the username could be referred to in a `Secret` by specifying
// "my-secret" for the `name` and "username" for the `key`.
type Secret_Reference struct {
	Name string  `protobuf:"bytes,1,req,name=name" json:"name"`
	Key  *string `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
}

func (m *Secret_Reference) Reset()                    { *m = Secret_Reference{} }
func (*Secret_Reference) ProtoMessage()               {}
func (*Secret_Reference) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{58, 0} }

func (m *Secret_Reference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Secret_Reference) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

// Used to pass the value of a secret.
type Secret_Value struct {
	Data []byte `protobuf:"bytes,1,req,name=data" json:"data,omitempty"`
}

func (m *Secret_Value) Reset()                    { *m = Secret_Value{} }
func (*Secret_Value) ProtoMessage()               {}
func (*Secret_Value) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{58, 1} }

func (m *Secret_Value) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// *
// Rate (queries per second, QPS) limit for messages from a framework to master.
// Strictly speaking they are the combined rate from all frameworks of the same
// principal.
type RateLimit struct {
	// Leaving QPS unset gives it unlimited rate (i.e., not throttled),
	// which also implies unlimited capacity.
	QPS *float64 `protobuf:"fixed64,1,opt,name=qps" json:"qps,omitempty"`
	// Principal of framework(s) to be throttled. Should match
	// FrameworkInfo.principal and Credential.principal (if using authentication).
	Principal string `protobuf:"bytes,2,req,name=principal" json:"principal"`
	// Max number of outstanding messages from frameworks of this principal
	// allowed by master before the next message is dropped and an error is sent
	// back to the sender. Messages received before the capacity is reached are
	// still going to be processed after the error is sent.
	// If unspecified, this principal is assigned unlimited capacity.
	// NOTE: This value is ignored if 'qps' is not set.
	Capacity *uint64 `protobuf:"varint,3,opt,name=capacity" json:"capacity,omitempty"`
}

func (m *RateLimit) Reset()                    { *m = RateLimit{} }
func (*RateLimit) ProtoMessage()               {}
func (*RateLimit) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{59} }

func (m *RateLimit) GetQPS() float64 {
	if m != nil && m.QPS != nil {
		return *m.QPS
	}
	return 0
}

func (m *RateLimit) GetPrincipal() string {
	if m != nil {
		return m.Principal
	}
	return ""
}

func (m *RateLimit) GetCapacity() uint64 {
	if m != nil && m.Capacity != nil {
		return *m.Capacity
	}
	return 0
}

// *
// Collection of RateLimit.
// Frameworks without rate limits defined here are not throttled unless
// 'aggregate_default_qps' is specified.
type RateLimits struct {
	// Items should have unique principals.
	Limits []RateLimit `protobuf:"bytes,1,rep,name=limits" json:"limits"`
	// All the frameworks not specified in 'limits' get this default rate.
	// This rate is an aggregate rate for all of them, i.e., their combined
	// traffic is throttled together at this rate.
	AggregateDefaultQPS *float64 `protobuf:"fixed64,2,opt,name=aggregate_default_qps,json=aggregateDefaultQps" json:"aggregate_default_qps,omitempty"`
	// All the frameworks not specified in 'limits' get this default capacity.
	// This is an aggregate value similar to 'aggregate_default_qps'.
	AggregateDefaultCapacity *uint64 `protobuf:"varint,3,opt,name=aggregate_default_capacity,json=aggregateDefaultCapacity" json:"aggregate_default_capacity,omitempty"`
}

func (m *RateLimits) Reset()                    { *m = RateLimits{} }
func (*RateLimits) ProtoMessage()               {}
func (*RateLimits) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{60} }

func (m *RateLimits) GetLimits() []RateLimit {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *RateLimits) GetAggregateDefaultQPS() float64 {
	if m != nil && m.AggregateDefaultQPS != nil {
		return *m.AggregateDefaultQPS
	}
	return 0
}

func (m *RateLimits) GetAggregateDefaultCapacity() uint64 {
	if m != nil && m.AggregateDefaultCapacity != nil {
		return *m.AggregateDefaultCapacity
	}
	return 0
}

// *
// Describe an image used by tasks or executors. Note that it's only
// for tasks or executors launched by MesosContainerizer currently.
type Image struct {
	Type *Image_Type `protobuf:"varint,1,req,name=type,enum=mesos.Image_Type" json:"type,omitempty"`
	// Only one of the following image messages should be set to match
	// the type.
	Appc   *Image_Appc   `protobuf:"bytes,2,opt,name=appc" json:"appc,omitempty"`
	Docker *Image_Docker `protobuf:"bytes,3,opt,name=docker" json:"docker,omitempty"`
	// With this flag set to false, the mesos containerizer will pull
	// the docker/appc image from the registry even if the image is
	// already downloaded on the agent.
	Cached *bool `protobuf:"varint,4,opt,name=cached,def=1" json:"cached,omitempty"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{61} }

const Default_Image_Cached bool = true

func (m *Image) GetType() Image_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Image_APPC
}

func (m *Image) GetAppc() *Image_Appc {
	if m != nil {
		return m.Appc
	}
	return nil
}

func (m *Image) GetDocker() *Image_Docker {
	if m != nil {
		return m.Docker
	}
	return nil
}

func (m *Image) GetCached() bool {
	if m != nil && m.Cached != nil {
		return *m.Cached
	}
	return Default_Image_Cached
}

// Protobuf for specifying an Appc container image. See:
// https://github.com/appc/spec/blob/master/spec/aci.md
type Image_Appc struct {
	// The name of the image.
	Name string `protobuf:"bytes,1,req,name=name" json:"name"`
	// An image ID is a string of the format "hash-value", where
	// "hash" is the hash algorithm used and "value" is the hex
	// encoded string of the digest. Currently the only permitted
	// hash algorithm is sha512.
	ID *string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Optional labels. Suggested labels: "version", "os", and "arch".
	Labels *Labels `protobuf:"bytes,3,opt,name=labels" json:"labels,omitempty"`
}

func (m *Image_Appc) Reset()                    { *m = Image_Appc{} }
func (*Image_Appc) ProtoMessage()               {}
func (*Image_Appc) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{61, 0} }

func (m *Image_Appc) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Image_Appc) GetID() string {
	if m != nil && m.ID != nil {
		return *m.ID
	}
	return ""
}

func (m *Image_Appc) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

type Image_Docker struct {
	// The name of the image. Expected format:
	//   [REGISTRY_HOST[:REGISTRY_PORT]/]REPOSITORY[:TAG|@TYPE:DIGEST]
	//
	// See: https://docs.docker.com/reference/commandline/pull/
	Name string `protobuf:"bytes,1,req,name=name" json:"name"`
	// Credential to authenticate with docker registry.
	// NOTE: This is not encrypted, therefore framework and operators
	// should enable SSL when passing this information.
	//
	// This field has never been used in Mesos before and is
	// deprecated since Mesos 1.3. Please use `config` below
	// (see MESOS-7088 for details).
	Credential *Credential `protobuf:"bytes,2,opt,name=credential" json:"credential,omitempty"`
	// Docker config containing credentails to authenticate with
	// docker registry. The secret is expected to be a docker
	// config file in JSON format with UTF-8 character encoding.
	Config *Secret `protobuf:"bytes,3,opt,name=config" json:"config,omitempty"`
}

func (m *Image_Docker) Reset()                    { *m = Image_Docker{} }
func (*Image_Docker) ProtoMessage()               {}
func (*Image_Docker) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{61, 1} }

func (m *Image_Docker) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Image_Docker) GetCredential() *Credential {
	if m != nil {
		return m.Credential
	}
	return nil
}

func (m *Image_Docker) GetConfig() *Secret {
	if m != nil {
		return m.Config
	}
	return nil
}

// *
// Describes how the mount will be propagated for a volume. See the
// following doc for more details about mount propagation:
// https://www.kernel.org/doc/Documentation/filesystems/sharedsubtree.txt
type MountPropagation struct {
	Mode *MountPropagation_Mode `protobuf:"varint,1,opt,name=mode,enum=mesos.MountPropagation_Mode" json:"mode,omitempty"`
}

func (m *MountPropagation) Reset()                    { *m = MountPropagation{} }
func (*MountPropagation) ProtoMessage()               {}
func (*MountPropagation) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{62} }

func (m *MountPropagation) GetMode() MountPropagation_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return MountPropagation_UNKNOWN
}

// *
// Describes a volume mapping either from host to container or vice
// versa. Both paths can either refer to a directory or a file.
type Volume struct {
	// TODO(gyliu513): Make this as `optional` after deprecation cycle of 1.0.
	Mode *Volume_Mode `protobuf:"varint,3,req,name=mode,enum=mesos.Volume_Mode" json:"mode,omitempty"`
	// Path pointing to a directory or file in the container. If the
	// path is a relative path, it is relative to the container work
	// directory. If the path is an absolute path, that path must
	// already exist.
	ContainerPath string `protobuf:"bytes,1,req,name=container_path,json=containerPath" json:"container_path"`
	// Absolute path pointing to a directory or file on the host or a
	// path relative to the container work directory.
	HostPath *string `protobuf:"bytes,2,opt,name=host_path,json=hostPath" json:"host_path,omitempty"`
	// The source of the volume is an Image which describes a root
	// filesystem which will be provisioned by Mesos.
	Image  *Image         `protobuf:"bytes,4,opt,name=image" json:"image,omitempty"`
	Source *Volume_Source `protobuf:"bytes,5,opt,name=source" json:"source,omitempty"`
}

func (m *Volume) Reset()                    { *m = Volume{} }
func (*Volume) ProtoMessage()               {}
func (*Volume) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{63} }

func (m *Volume) GetMode() Volume_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return RW
}

func (m *Volume) GetContainerPath() string {
	if m != nil {
		return m.ContainerPath
	}
	return ""
}

func (m *Volume) GetHostPath() string {
	if m != nil && m.HostPath != nil {
		return *m.HostPath
	}
	return ""
}

func (m *Volume) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Volume) GetSource() *Volume_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

// Describes where a volume originates from.
type Volume_Source struct {
	// Enum fields should be optional, see: MESOS-4997.
	Type Volume_Source_Type `protobuf:"varint,1,opt,name=type,enum=mesos.Volume_Source_Type" json:"type"`
	// The source of the volume created by docker volume driver.
	DockerVolume *Volume_Source_DockerVolume `protobuf:"bytes,2,opt,name=docker_volume,json=dockerVolume" json:"docker_volume,omitempty"`
	HostPath     *Volume_Source_HostPath     `protobuf:"bytes,5,opt,name=host_path,json=hostPath" json:"host_path,omitempty"`
	SandboxPath  *Volume_Source_SandboxPath  `protobuf:"bytes,3,opt,name=sandbox_path,json=sandboxPath" json:"sandbox_path,omitempty"`
	// The volume/secret isolator uses the secret-fetcher module (third-party or
	// internal) downloads the secret and makes it available at container_path.
	Secret *Secret `protobuf:"bytes,4,opt,name=secret" json:"secret,omitempty"`
}

func (m *Volume_Source) Reset()                    { *m = Volume_Source{} }
func (*Volume_Source) ProtoMessage()               {}
func (*Volume_Source) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{63, 0} }

func (m *Volume_Source) GetType() Volume_Source_Type {
	if m != nil {
		return m.Type
	}
	return Volume_Source_UNKNOWN
}

func (m *Volume_Source) GetDockerVolume() *Volume_Source_DockerVolume {
	if m != nil {
		return m.DockerVolume
	}
	return nil
}

func (m *Volume_Source) GetHostPath() *Volume_Source_HostPath {
	if m != nil {
		return m.HostPath
	}
	return nil
}

func (m *Volume_Source) GetSandboxPath() *Volume_Source_SandboxPath {
	if m != nil {
		return m.SandboxPath
	}
	return nil
}

func (m *Volume_Source) GetSecret() *Secret {
	if m != nil {
		return m.Secret
	}
	return nil
}

type Volume_Source_DockerVolume struct {
	// Driver of the volume, it can be flocker, convoy, raxrey etc.
	Driver *string `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	// Name of the volume.
	Name string `protobuf:"bytes,2,req,name=name" json:"name"`
	// Volume driver specific options.
	DriverOptions *Parameters `protobuf:"bytes,3,opt,name=driver_options,json=driverOptions" json:"driver_options,omitempty"`
}

func (m *Volume_Source_DockerVolume) Reset()      { *m = Volume_Source_DockerVolume{} }
func (*Volume_Source_DockerVolume) ProtoMessage() {}
func (*Volume_Source_DockerVolume) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{63, 0, 0}
}

func (m *Volume_Source_DockerVolume) GetDriver() string {
	if m != nil && m.Driver != nil {
		return *m.Driver
	}
	return ""
}

func (m *Volume_Source_DockerVolume) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Volume_Source_DockerVolume) GetDriverOptions() *Parameters {
	if m != nil {
		return m.DriverOptions
	}
	return nil
}

// Absolute path pointing to a directory or file on the host.
type Volume_Source_HostPath struct {
	Path             string            `protobuf:"bytes,1,req,name=path" json:"path"`
	MountPropagation *MountPropagation `protobuf:"bytes,2,opt,name=mount_propagation,json=mountPropagation" json:"mount_propagation,omitempty"`
}

func (m *Volume_Source_HostPath) Reset()      { *m = Volume_Source_HostPath{} }
func (*Volume_Source_HostPath) ProtoMessage() {}
func (*Volume_Source_HostPath) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{63, 0, 1}
}

func (m *Volume_Source_HostPath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Volume_Source_HostPath) GetMountPropagation() *MountPropagation {
	if m != nil {
		return m.MountPropagation
	}
	return nil
}

// Describe a path from a container's sandbox. The container can
// be the current container (SELF), or its parent container
// (PARENT). PARENT allows all child containers to share a volume
// from their parent container's sandbox. It'll be an error if
// the current container is a top level container.
type Volume_Source_SandboxPath struct {
	Type Volume_Source_SandboxPath_Type `protobuf:"varint,1,opt,name=type,enum=mesos.Volume_Source_SandboxPath_Type" json:"type"`
	// A path relative to the corresponding container's sandbox.
	// Note that upwards traversal (i.e. ../../abc) is not allowed.
	Path string `protobuf:"bytes,2,req,name=path" json:"path"`
}

func (m *Volume_Source_SandboxPath) Reset()      { *m = Volume_Source_SandboxPath{} }
func (*Volume_Source_SandboxPath) ProtoMessage() {}
func (*Volume_Source_SandboxPath) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{63, 0, 2}
}

func (m *Volume_Source_SandboxPath) GetType() Volume_Source_SandboxPath_Type {
	if m != nil {
		return m.Type
	}
	return Volume_Source_SandboxPath_UNKNOWN
}

func (m *Volume_Source_SandboxPath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// *
// Describes a network request from a framework as well as network resolution
// provided by Mesos.
//
// A framework may request the network isolator on the Agent to isolate the
// container in a network namespace and create a virtual network interface.
// The `NetworkInfo` message describes the properties of that virtual
// interface, including the IP addresses and network isolation policy
// (network group membership).
//
// The NetworkInfo message is not interpreted by the Master or Agent and is
// intended to be used by Agent and Master modules implementing network
// isolation. If the modules are missing, the message is simply ignored. In
// future, the task launch will fail if there is no module providing the
// network isolation capabilities (MESOS-3390).
//
// An executor, Agent, or an Agent module may append NetworkInfos inside
// TaskStatus::container_status to provide information such as the container IP
// address and isolation groups.
type NetworkInfo struct {
	// When included in a ContainerInfo, each of these represent a
	// request for an IP address. Each request can specify an explicit address
	// or the IP protocol to use.
	//
	// When included in a TaskStatus message, these inform the framework
	// scheduler about the IP addresses that are bound to the container
	// interface. When there are no custom network isolator modules installed,
	// this field is filled in automatically with the Agent IP address.
	IPAddresses []NetworkInfo_IPAddress `protobuf:"bytes,5,rep,name=ip_addresses,json=ipAddresses" json:"ip_addresses"`
	// Name of the network which will be used by network isolator to determine
	// the network that the container joins. It's up to the network isolator
	// to decide how to interpret this field.
	Name *string `protobuf:"bytes,6,opt,name=name" json:"name,omitempty"`
	// A group is the name given to a set of logically-related interfaces that
	// are allowed to communicate among themselves. Network traffic is allowed
	// between two container interfaces that share at least one network group.
	// For example, one might want to create separate groups for isolating dev,
	// testing, qa and prod deployment environments.
	Groups []string `protobuf:"bytes,3,rep,name=groups" json:"groups,omitempty"`
	// To tag certain metadata to be used by Isolator/IPAM, e.g., rack, etc.
	Labels       *Labels                   `protobuf:"bytes,4,opt,name=labels" json:"labels,omitempty"`
	PortMappings []NetworkInfo_PortMapping `protobuf:"bytes,7,rep,name=port_mappings,json=portMappings" json:"port_mappings"`
}

func (m *NetworkInfo) Reset()                    { *m = NetworkInfo{} }
func (*NetworkInfo) ProtoMessage()               {}
func (*NetworkInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{64} }

func (m *NetworkInfo) GetIPAddresses() []NetworkInfo_IPAddress {
	if m != nil {
		return m.IPAddresses
	}
	return nil
}

func (m *NetworkInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *NetworkInfo) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *NetworkInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NetworkInfo) GetPortMappings() []NetworkInfo_PortMapping {
	if m != nil {
		return m.PortMappings
	}
	return nil
}

// Specifies a request for an IP address, or reports the assigned container
// IP address.
//
// Users can request an automatically assigned IP (for example, via an
// IPAM service) or a specific IP by adding a NetworkInfo to the
// ContainerInfo for a task.  On a request, specifying neither `protocol`
// nor `ip_address` means that any available address may be assigned.
type NetworkInfo_IPAddress struct {
	// Specify IP address requirement. Set protocol to the desired value to
	// request the network isolator on the Agent to assign an IP address to the
	// container being launched. If a specific IP address is specified in
	// ip_address, this field should not be set.
	Protocol *NetworkInfo_Protocol `protobuf:"varint,1,opt,name=protocol,enum=mesos.NetworkInfo_Protocol,def=1" json:"protocol,omitempty"`
	// Statically assigned IP provided by the Framework. This IP will be
	// assigned to the container by the network isolator module on the Agent.
	// This field should not be used with the protocol field above.
	//
	// If an explicit address is requested but is unavailable, the network
	// isolator should fail the task.
	IPAddress *string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress" json:"ip_address,omitempty"`
}

func (m *NetworkInfo_IPAddress) Reset()                    { *m = NetworkInfo_IPAddress{} }
func (*NetworkInfo_IPAddress) ProtoMessage()               {}
func (*NetworkInfo_IPAddress) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{64, 0} }

const Default_NetworkInfo_IPAddress_Protocol NetworkInfo_Protocol = IPv4

func (m *NetworkInfo_IPAddress) GetProtocol() NetworkInfo_Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return Default_NetworkInfo_IPAddress_Protocol
}

func (m *NetworkInfo_IPAddress) GetIPAddress() string {
	if m != nil && m.IPAddress != nil {
		return *m.IPAddress
	}
	return ""
}

// Specifies a port mapping request for the task on this network.
type NetworkInfo_PortMapping struct {
	HostPort      uint32 `protobuf:"varint,1,req,name=host_port,json=hostPort" json:"host_port"`
	ContainerPort uint32 `protobuf:"varint,2,req,name=container_port,json=containerPort" json:"container_port"`
	// Protocol to expose as (ie: tcp, udp).
	Protocol *string `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
}

func (m *NetworkInfo_PortMapping) Reset()                    { *m = NetworkInfo_PortMapping{} }
func (*NetworkInfo_PortMapping) ProtoMessage()               {}
func (*NetworkInfo_PortMapping) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{64, 1} }

func (m *NetworkInfo_PortMapping) GetHostPort() uint32 {
	if m != nil {
		return m.HostPort
	}
	return 0
}

func (m *NetworkInfo_PortMapping) GetContainerPort() uint32 {
	if m != nil {
		return m.ContainerPort
	}
	return 0
}

func (m *NetworkInfo_PortMapping) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

// *
// Encapsulation of `Capabilities` supported by Linux.
// Reference: http://linux.die.net/man/7/capabilities.
type CapabilityInfo struct {
	Capabilities []CapabilityInfo_Capability `protobuf:"varint,1,rep,name=capabilities,enum=mesos.CapabilityInfo_Capability" json:"capabilities,omitempty"`
}

func (m *CapabilityInfo) Reset()                    { *m = CapabilityInfo{} }
func (*CapabilityInfo) ProtoMessage()               {}
func (*CapabilityInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{65} }

func (m *CapabilityInfo) GetCapabilities() []CapabilityInfo_Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// *
// Encapsulation for Linux specific configuration.
// E.g, capabilities, limits etc.
type LinuxInfo struct {
	// Since 1.4.0, deprecated in favor of `effective_capabilities`.
	CapabilityInfo *CapabilityInfo `protobuf:"bytes,1,opt,name=capability_info,json=capabilityInfo" json:"capability_info,omitempty"`
	// The set of capabilities that are allowed but not initially
	// granted to tasks.
	BoundingCapabilities *CapabilityInfo `protobuf:"bytes,2,opt,name=bounding_capabilities,json=boundingCapabilities" json:"bounding_capabilities,omitempty"`
	// Represents the set of capabilities that the task will
	// be executed with.
	EffectiveCapabilities *CapabilityInfo `protobuf:"bytes,3,opt,name=effective_capabilities,json=effectiveCapabilities" json:"effective_capabilities,omitempty"`
	// If set as 'true', the container shares the pid namespace with
	// its parent. If the container is a top level container, it will
	// share the pid namespace with the agent. If the container is a
	// nested container, it will share the pid namespace with its
	// parent container. This field will be ignored if 'namespaces/pid'
	// isolator is not enabled.
	SharePIDNamespace *bool `protobuf:"varint,4,opt,name=share_pid_namespace,json=sharePidNamespace" json:"share_pid_namespace,omitempty"`
}

func (m *LinuxInfo) Reset()                    { *m = LinuxInfo{} }
func (*LinuxInfo) ProtoMessage()               {}
func (*LinuxInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{66} }

func (m *LinuxInfo) GetCapabilityInfo() *CapabilityInfo {
	if m != nil {
		return m.CapabilityInfo
	}
	return nil
}

func (m *LinuxInfo) GetBoundingCapabilities() *CapabilityInfo {
	if m != nil {
		return m.BoundingCapabilities
	}
	return nil
}

func (m *LinuxInfo) GetEffectiveCapabilities() *CapabilityInfo {
	if m != nil {
		return m.EffectiveCapabilities
	}
	return nil
}

func (m *LinuxInfo) GetSharePIDNamespace() bool {
	if m != nil && m.SharePIDNamespace != nil {
		return *m.SharePIDNamespace
	}
	return false
}

// *
// Encapsulation for POSIX rlimits, see
// http://pubs.opengroup.org/onlinepubs/009695399/functions/getrlimit.html.
// Note that some types might only be defined for Linux.
// We use a custom prefix to avoid conflict with existing system macros
// (e.g., `RLIMIT_CPU` or `NOFILE`).
type RLimitInfo struct {
	Rlimits []RLimitInfo_RLimit `protobuf:"bytes,1,rep,name=rlimits" json:"rlimits"`
}

func (m *RLimitInfo) Reset()                    { *m = RLimitInfo{} }
func (*RLimitInfo) ProtoMessage()               {}
func (*RLimitInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{67} }

func (m *RLimitInfo) GetRlimits() []RLimitInfo_RLimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type RLimitInfo_RLimit struct {
	Type RLimitInfo_RLimit_Type `protobuf:"varint,1,opt,name=type,enum=mesos.RLimitInfo_RLimit_Type" json:"type"`
	// Either both are set or both are not set.
	// If both are not set, it represents unlimited.
	// If both are set, we require `soft` <= `hard`.
	Hard *uint64 `protobuf:"varint,2,opt,name=hard" json:"hard,omitempty"`
	Soft *uint64 `protobuf:"varint,3,opt,name=soft" json:"soft,omitempty"`
}

func (m *RLimitInfo_RLimit) Reset()                    { *m = RLimitInfo_RLimit{} }
func (*RLimitInfo_RLimit) ProtoMessage()               {}
func (*RLimitInfo_RLimit) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{67, 0} }

func (m *RLimitInfo_RLimit) GetType() RLimitInfo_RLimit_Type {
	if m != nil {
		return m.Type
	}
	return RLimitInfo_RLimit_UNKNOWN
}

func (m *RLimitInfo_RLimit) GetHard() uint64 {
	if m != nil && m.Hard != nil {
		return *m.Hard
	}
	return 0
}

func (m *RLimitInfo_RLimit) GetSoft() uint64 {
	if m != nil && m.Soft != nil {
		return *m.Soft
	}
	return 0
}

// *
// Describes the information about (pseudo) TTY that can
// be attached to a process running in a container.
type TTYInfo struct {
	WindowSize *TTYInfo_WindowSize `protobuf:"bytes,1,opt,name=window_size,json=windowSize" json:"window_size,omitempty"`
}

func (m *TTYInfo) Reset()                    { *m = TTYInfo{} }
func (*TTYInfo) ProtoMessage()               {}
func (*TTYInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{68} }

func (m *TTYInfo) GetWindowSize() *TTYInfo_WindowSize {
	if m != nil {
		return m.WindowSize
	}
	return nil
}

type TTYInfo_WindowSize struct {
	Rows    uint32 `protobuf:"varint,1,req,name=rows" json:"rows"`
	Columns uint32 `protobuf:"varint,2,req,name=columns" json:"columns"`
}

func (m *TTYInfo_WindowSize) Reset()                    { *m = TTYInfo_WindowSize{} }
func (*TTYInfo_WindowSize) ProtoMessage()               {}
func (*TTYInfo_WindowSize) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{68, 0} }

func (m *TTYInfo_WindowSize) GetRows() uint32 {
	if m != nil {
		return m.Rows
	}
	return 0
}

func (m *TTYInfo_WindowSize) GetColumns() uint32 {
	if m != nil {
		return m.Columns
	}
	return 0
}

// *
// Describes a container configuration and allows extensible
// configurations for different container implementations.
//
// NOTE: `ContainerInfo` may be specified, e.g., by a task, even if no
// container image is provided. In this case neither `MesosInfo` nor
// `DockerInfo` is set, the required `type` must be `MESOS`. This is to
// address a case when a task without an image, e.g., a shell script
// with URIs, wants to use features originally designed for containers,
// for example custom network isolation via `NetworkInfo`.
type ContainerInfo struct {
	Type     *ContainerInfo_Type `protobuf:"varint,1,req,name=type,enum=mesos.ContainerInfo_Type" json:"type,omitempty"`
	Volumes  []Volume            `protobuf:"bytes,2,rep,name=volumes" json:"volumes"`
	Hostname *string             `protobuf:"bytes,4,opt,name=hostname" json:"hostname,omitempty"`
	// Only one of the following *Info messages should be set to match
	// the type.
	Docker *ContainerInfo_DockerInfo `protobuf:"bytes,3,opt,name=docker" json:"docker,omitempty"`
	Mesos  *ContainerInfo_MesosInfo  `protobuf:"bytes,5,opt,name=mesos" json:"mesos,omitempty"`
	// A list of network requests. A framework can request multiple IP addresses
	// for the container.
	NetworkInfos []NetworkInfo `protobuf:"bytes,7,rep,name=network_infos,json=networkInfos" json:"network_infos"`
	// Linux specific information for the container.
	LinuxInfo *LinuxInfo `protobuf:"bytes,8,opt,name=linux_info,json=linuxInfo" json:"linux_info,omitempty"`
	// (POSIX only) rlimits of the container.
	RlimitInfo *RLimitInfo `protobuf:"bytes,9,opt,name=rlimit_info,json=rlimitInfo" json:"rlimit_info,omitempty"`
	// If specified a tty will be attached to the container entrypoint.
	TTYInfo *TTYInfo `protobuf:"bytes,10,opt,name=tty_info,json=ttyInfo" json:"tty_info,omitempty"`
}

func (m *ContainerInfo) Reset()                    { *m = ContainerInfo{} }
func (*ContainerInfo) ProtoMessage()               {}
func (*ContainerInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{69} }

func (m *ContainerInfo) GetType() ContainerInfo_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ContainerInfo_DOCKER
}

func (m *ContainerInfo) GetVolumes() []Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *ContainerInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *ContainerInfo) GetDocker() *ContainerInfo_DockerInfo {
	if m != nil {
		return m.Docker
	}
	return nil
}

func (m *ContainerInfo) GetMesos() *ContainerInfo_MesosInfo {
	if m != nil {
		return m.Mesos
	}
	return nil
}

func (m *ContainerInfo) GetNetworkInfos() []NetworkInfo {
	if m != nil {
		return m.NetworkInfos
	}
	return nil
}

func (m *ContainerInfo) GetLinuxInfo() *LinuxInfo {
	if m != nil {
		return m.LinuxInfo
	}
	return nil
}

func (m *ContainerInfo) GetRlimitInfo() *RLimitInfo {
	if m != nil {
		return m.RlimitInfo
	}
	return nil
}

func (m *ContainerInfo) GetTTYInfo() *TTYInfo {
	if m != nil {
		return m.TTYInfo
	}
	return nil
}

type ContainerInfo_DockerInfo struct {
	// The docker image that is going to be passed to the registry.
	Image        string                                 `protobuf:"bytes,1,req,name=image" json:"image"`
	Network      *ContainerInfo_DockerInfo_Network      `protobuf:"varint,2,opt,name=network,enum=mesos.ContainerInfo_DockerInfo_Network,def=1" json:"network,omitempty"`
	PortMappings []ContainerInfo_DockerInfo_PortMapping `protobuf:"bytes,3,rep,name=port_mappings,json=portMappings" json:"port_mappings"`
	Privileged   *bool                                  `protobuf:"varint,4,opt,name=privileged,def=0" json:"privileged,omitempty"`
	// Allowing arbitrary parameters to be passed to docker CLI.
	// Note that anything passed to this field is not guaranteed
	// to be supported moving forward, as we might move away from
	// the docker CLI.
	Parameters []Parameter `protobuf:"bytes,5,rep,name=parameters" json:"parameters"`
	// With this flag set to true, the docker containerizer will
	// pull the docker image from the registry even if the image
	// is already downloaded on the agent.
	ForcePullImage *bool `protobuf:"varint,6,opt,name=force_pull_image,json=forcePullImage" json:"force_pull_image,omitempty"`
	// The name of volume driver plugin.
	VolumeDriver *string `protobuf:"bytes,7,opt,name=volume_driver,json=volumeDriver" json:"volume_driver,omitempty"`
}

func (m *ContainerInfo_DockerInfo) Reset()      { *m = ContainerInfo_DockerInfo{} }
func (*ContainerInfo_DockerInfo) ProtoMessage() {}
func (*ContainerInfo_DockerInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{69, 0}
}

const Default_ContainerInfo_DockerInfo_Network ContainerInfo_DockerInfo_Network = ContainerInfo_DockerInfo_HOST
const Default_ContainerInfo_DockerInfo_Privileged bool = false

func (m *ContainerInfo_DockerInfo) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *ContainerInfo_DockerInfo) GetNetwork() ContainerInfo_DockerInfo_Network {
	if m != nil && m.Network != nil {
		return *m.Network
	}
	return Default_ContainerInfo_DockerInfo_Network
}

func (m *ContainerInfo_DockerInfo) GetPortMappings() []ContainerInfo_DockerInfo_PortMapping {
	if m != nil {
		return m.PortMappings
	}
	return nil
}

func (m *ContainerInfo_DockerInfo) GetPrivileged() bool {
	if m != nil && m.Privileged != nil {
		return *m.Privileged
	}
	return Default_ContainerInfo_DockerInfo_Privileged
}

func (m *ContainerInfo_DockerInfo) GetParameters() []Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *ContainerInfo_DockerInfo) GetForcePullImage() bool {
	if m != nil && m.ForcePullImage != nil {
		return *m.ForcePullImage
	}
	return false
}

func (m *ContainerInfo_DockerInfo) GetVolumeDriver() string {
	if m != nil && m.VolumeDriver != nil {
		return *m.VolumeDriver
	}
	return ""
}

type ContainerInfo_DockerInfo_PortMapping struct {
	HostPort      uint32 `protobuf:"varint,1,req,name=host_port,json=hostPort" json:"host_port"`
	ContainerPort uint32 `protobuf:"varint,2,req,name=container_port,json=containerPort" json:"container_port"`
	// Protocol to expose as (ie: tcp, udp).
	Protocol *string `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
}

func (m *ContainerInfo_DockerInfo_PortMapping) Reset()      { *m = ContainerInfo_DockerInfo_PortMapping{} }
func (*ContainerInfo_DockerInfo_PortMapping) ProtoMessage() {}
func (*ContainerInfo_DockerInfo_PortMapping) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{69, 0, 0}
}

func (m *ContainerInfo_DockerInfo_PortMapping) GetHostPort() uint32 {
	if m != nil {
		return m.HostPort
	}
	return 0
}

func (m *ContainerInfo_DockerInfo_PortMapping) GetContainerPort() uint32 {
	if m != nil {
		return m.ContainerPort
	}
	return 0
}

func (m *ContainerInfo_DockerInfo_PortMapping) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

type ContainerInfo_MesosInfo struct {
	Image *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
}

func (m *ContainerInfo_MesosInfo) Reset()                    { *m = ContainerInfo_MesosInfo{} }
func (*ContainerInfo_MesosInfo) ProtoMessage()               {}
func (*ContainerInfo_MesosInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{69, 1} }

func (m *ContainerInfo_MesosInfo) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// *
// Container related information that is resolved during container
// setup. The information is sent back to the framework as part of the
// TaskStatus message.
type ContainerStatus struct {
	ContainerID *ContainerID `protobuf:"bytes,4,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	// This field can be reliably used to identify the container IP address.
	NetworkInfos []NetworkInfo `protobuf:"bytes,1,rep,name=network_infos,json=networkInfos" json:"network_infos"`
	// Information about Linux control group (cgroup).
	CgroupInfo *CgroupInfo `protobuf:"bytes,2,opt,name=cgroup_info,json=cgroupInfo" json:"cgroup_info,omitempty"`
	// Information about Executor PID.
	ExecutorPID *uint32 `protobuf:"varint,3,opt,name=executor_pid,json=executorPid" json:"executor_pid,omitempty"`
}

func (m *ContainerStatus) Reset()                    { *m = ContainerStatus{} }
func (*ContainerStatus) ProtoMessage()               {}
func (*ContainerStatus) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{70} }

func (m *ContainerStatus) GetContainerID() *ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return nil
}

func (m *ContainerStatus) GetNetworkInfos() []NetworkInfo {
	if m != nil {
		return m.NetworkInfos
	}
	return nil
}

func (m *ContainerStatus) GetCgroupInfo() *CgroupInfo {
	if m != nil {
		return m.CgroupInfo
	}
	return nil
}

func (m *ContainerStatus) GetExecutorPID() uint32 {
	if m != nil && m.ExecutorPID != nil {
		return *m.ExecutorPID
	}
	return 0
}

// *
// Linux control group (cgroup) information.
type CgroupInfo struct {
	NetCLS *CgroupInfo_NetCls `protobuf:"bytes,1,opt,name=net_cls,json=netCls" json:"net_cls,omitempty"`
}

func (m *CgroupInfo) Reset()                    { *m = CgroupInfo{} }
func (*CgroupInfo) ProtoMessage()               {}
func (*CgroupInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{71} }

func (m *CgroupInfo) GetNetCLS() *CgroupInfo_NetCls {
	if m != nil {
		return m.NetCLS
	}
	return nil
}

// Configuration of a blkio cgroup subsystem.
type CgroupInfo_Blkio struct {
}

func (m *CgroupInfo_Blkio) Reset()                    { *m = CgroupInfo_Blkio{} }
func (*CgroupInfo_Blkio) ProtoMessage()               {}
func (*CgroupInfo_Blkio) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{71, 0} }

// Describes a stat value without the device descriptor part.
type CgroupInfo_Blkio_Value struct {
	Op    *CgroupInfo_Blkio_Operation `protobuf:"varint,1,opt,name=op,enum=mesos.CgroupInfo_Blkio_Operation" json:"op,omitempty"`
	Value *uint64                     `protobuf:"varint,2,opt,name=value" json:"value,omitempty"`
}

func (m *CgroupInfo_Blkio_Value) Reset()      { *m = CgroupInfo_Blkio_Value{} }
func (*CgroupInfo_Blkio_Value) ProtoMessage() {}
func (*CgroupInfo_Blkio_Value) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{71, 0, 0}
}

func (m *CgroupInfo_Blkio_Value) GetOp() CgroupInfo_Blkio_Operation {
	if m != nil && m.Op != nil {
		return *m.Op
	}
	return CgroupInfo_Blkio_UNKNOWN
}

func (m *CgroupInfo_Blkio_Value) GetValue() uint64 {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return 0
}

type CgroupInfo_Blkio_CFQ struct {
}

func (m *CgroupInfo_Blkio_CFQ) Reset()                    { *m = CgroupInfo_Blkio_CFQ{} }
func (*CgroupInfo_Blkio_CFQ) ProtoMessage()               {}
func (*CgroupInfo_Blkio_CFQ) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{71, 0, 1} }

type CgroupInfo_Blkio_CFQ_Statistics struct {
	// Stats are grouped by block devices. If `device` is not
	// set, it represents `Total`.
	Device *Device_Number `protobuf:"bytes,1,opt,name=device" json:"device,omitempty"`
	// blkio.sectors
	Sectors *uint64 `protobuf:"varint,2,opt,name=sectors" json:"sectors,omitempty"`
	// blkio.time
	Time *uint64 `protobuf:"varint,3,opt,name=time" json:"time,omitempty"`
	// blkio.io_serviced
	IOServiced []CgroupInfo_Blkio_Value `protobuf:"bytes,4,rep,name=io_serviced,json=ioServiced" json:"io_serviced"`
	// blkio.io_service_bytes
	IOServiceBytes []CgroupInfo_Blkio_Value `protobuf:"bytes,5,rep,name=io_service_bytes,json=ioServiceBytes" json:"io_service_bytes"`
	// blkio.io_service_time
	IOServiceTime []CgroupInfo_Blkio_Value `protobuf:"bytes,6,rep,name=io_service_time,json=ioServiceTime" json:"io_service_time"`
	// blkio.io_wait_time
	IOWaitTime []CgroupInfo_Blkio_Value `protobuf:"bytes,7,rep,name=io_wait_time,json=ioWaitTime" json:"io_wait_time"`
	// blkio.io_merged
	IOMerged []CgroupInfo_Blkio_Value `protobuf:"bytes,8,rep,name=io_merged,json=ioMerged" json:"io_merged"`
	// blkio.io_queued
	IOQueued []CgroupInfo_Blkio_Value `protobuf:"bytes,9,rep,name=io_queued,json=ioQueued" json:"io_queued"`
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) Reset()      { *m = CgroupInfo_Blkio_CFQ_Statistics{} }
func (*CgroupInfo_Blkio_CFQ_Statistics) ProtoMessage() {}
func (*CgroupInfo_Blkio_CFQ_Statistics) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{71, 0, 1, 0}
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetDevice() *Device_Number {
	if m != nil {
		return m.Device
	}
	return nil
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetSectors() uint64 {
	if m != nil && m.Sectors != nil {
		return *m.Sectors
	}
	return 0
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetTime() uint64 {
	if m != nil && m.Time != nil {
		return *m.Time
	}
	return 0
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetIOServiced() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOServiced
	}
	return nil
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetIOServiceBytes() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOServiceBytes
	}
	return nil
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetIOServiceTime() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOServiceTime
	}
	return nil
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetIOWaitTime() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOWaitTime
	}
	return nil
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetIOMerged() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOMerged
	}
	return nil
}

func (m *CgroupInfo_Blkio_CFQ_Statistics) GetIOQueued() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOQueued
	}
	return nil
}

type CgroupInfo_Blkio_Throttling struct {
}

func (m *CgroupInfo_Blkio_Throttling) Reset()      { *m = CgroupInfo_Blkio_Throttling{} }
func (*CgroupInfo_Blkio_Throttling) ProtoMessage() {}
func (*CgroupInfo_Blkio_Throttling) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{71, 0, 2}
}

type CgroupInfo_Blkio_Throttling_Statistics struct {
	// Stats are grouped by block devices. If `device` is not
	// set, it represents `Total`.
	Device *Device_Number `protobuf:"bytes,1,opt,name=device" json:"device,omitempty"`
	// blkio.throttle.io_serviced
	IOServiced []CgroupInfo_Blkio_Value `protobuf:"bytes,2,rep,name=io_serviced,json=ioServiced" json:"io_serviced"`
	// blkio.throttle.io_service_bytes
	IOServiceBytes []CgroupInfo_Blkio_Value `protobuf:"bytes,3,rep,name=io_service_bytes,json=ioServiceBytes" json:"io_service_bytes"`
}

func (m *CgroupInfo_Blkio_Throttling_Statistics) Reset() {
	*m = CgroupInfo_Blkio_Throttling_Statistics{}
}
func (*CgroupInfo_Blkio_Throttling_Statistics) ProtoMessage() {}
func (*CgroupInfo_Blkio_Throttling_Statistics) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{71, 0, 2, 0}
}

func (m *CgroupInfo_Blkio_Throttling_Statistics) GetDevice() *Device_Number {
	if m != nil {
		return m.Device
	}
	return nil
}

func (m *CgroupInfo_Blkio_Throttling_Statistics) GetIOServiced() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOServiced
	}
	return nil
}

func (m *CgroupInfo_Blkio_Throttling_Statistics) GetIOServiceBytes() []CgroupInfo_Blkio_Value {
	if m != nil {
		return m.IOServiceBytes
	}
	return nil
}

type CgroupInfo_Blkio_Statistics struct {
	CFQ          []CgroupInfo_Blkio_CFQ_Statistics         `protobuf:"bytes,1,rep,name=cfq" json:"cfq"`
	CFQRecursive []CgroupInfo_Blkio_CFQ_Statistics         `protobuf:"bytes,2,rep,name=cfq_recursive,json=cfqRecursive" json:"cfq_recursive"`
	Throttling   []*CgroupInfo_Blkio_Throttling_Statistics `protobuf:"bytes,3,rep,name=throttling" json:"throttling,omitempty"`
}

func (m *CgroupInfo_Blkio_Statistics) Reset()      { *m = CgroupInfo_Blkio_Statistics{} }
func (*CgroupInfo_Blkio_Statistics) ProtoMessage() {}
func (*CgroupInfo_Blkio_Statistics) Descriptor() ([]byte, []int) {
	return fileDescriptorMesos, []int{71, 0, 3}
}

func (m *CgroupInfo_Blkio_Statistics) GetCFQ() []CgroupInfo_Blkio_CFQ_Statistics {
	if m != nil {
		return m.CFQ
	}
	return nil
}

func (m *CgroupInfo_Blkio_Statistics) GetCFQRecursive() []CgroupInfo_Blkio_CFQ_Statistics {
	if m != nil {
		return m.CFQRecursive
	}
	return nil
}

func (m *CgroupInfo_Blkio_Statistics) GetThrottling() []*CgroupInfo_Blkio_Throttling_Statistics {
	if m != nil {
		return m.Throttling
	}
	return nil
}

// Configuration of a net_cls cgroup subsystem.
type CgroupInfo_NetCls struct {
	// The 32-bit classid consists of two parts, a 16 bit major handle
	// and a 16-bit minor handle. The major and minor handle are
	// represented using the format 0xAAAABBBB, where 0xAAAA is the
	// 16-bit major handle and 0xBBBB is the 16-bit minor handle.
	ClassID *uint32 `protobuf:"varint,1,opt,name=classid" json:"classid,omitempty"`
}

func (m *CgroupInfo_NetCls) Reset()                    { *m = CgroupInfo_NetCls{} }
func (*CgroupInfo_NetCls) ProtoMessage()               {}
func (*CgroupInfo_NetCls) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{71, 1} }

func (m *CgroupInfo_NetCls) GetClassID() uint32 {
	if m != nil && m.ClassID != nil {
		return *m.ClassID
	}
	return 0
}

// *
// Collection of labels. Labels should not contain duplicate key-value
// pairs.
type Labels struct {
	Labels []Label `protobuf:"bytes,1,rep,name=labels" json:"labels"`
}

func (m *Labels) Reset()                    { *m = Labels{} }
func (*Labels) ProtoMessage()               {}
func (*Labels) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{72} }

func (m *Labels) GetLabels() []Label {
	if m != nil {
		return m.Labels
	}
	return nil
}

// *
// Key, value pair used to store free form user-data.
type Label struct {
	Key   string  `protobuf:"bytes,1,req,name=key" json:"key"`
	Value *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Label) Reset()                    { *m = Label{} }
func (*Label) ProtoMessage()               {}
func (*Label) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{73} }

func (m *Label) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Label) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Named port used for service discovery.
type Port struct {
	// Port number on which the framework exposes a service.
	Number uint32 `protobuf:"varint,1,req,name=number" json:"number"`
	// Name of the service hosted on this port.
	Name *string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// Layer 4-7 protocol on which the framework exposes its services.
	Protocol *string `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
	// This field restricts discovery within a framework (FRAMEWORK),
	// within a Mesos cluster (CLUSTER), or places no restrictions (EXTERNAL).
	// The visibility setting for a Port overrides the general visibility setting
	// in the DiscoveryInfo.
	Visibility *DiscoveryInfo_Visibility `protobuf:"varint,4,opt,name=visibility,enum=mesos.DiscoveryInfo_Visibility" json:"visibility,omitempty"`
	// This can be used to decorate the message with metadata to be
	// interpreted by external applications such as firewalls.
	Labels *Labels `protobuf:"bytes,5,opt,name=labels" json:"labels,omitempty"`
}

func (m *Port) Reset()                    { *m = Port{} }
func (*Port) ProtoMessage()               {}
func (*Port) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{74} }

func (m *Port) GetNumber() uint32 {
	if m != nil {
		return m.Number
	}
	return 0
}

func (m *Port) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Port) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

func (m *Port) GetVisibility() DiscoveryInfo_Visibility {
	if m != nil && m.Visibility != nil {
		return *m.Visibility
	}
	return FRAMEWORK
}

func (m *Port) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

// *
// Collection of ports.
type Ports struct {
	Ports []Port `protobuf:"bytes,1,rep,name=ports" json:"ports"`
}

func (m *Ports) Reset()                    { *m = Ports{} }
func (*Ports) ProtoMessage()               {}
func (*Ports) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{75} }

func (m *Ports) GetPorts() []Port {
	if m != nil {
		return m.Ports
	}
	return nil
}

// *
// Service discovery information.
// The visibility field restricts discovery within a framework (FRAMEWORK),
// within a Mesos cluster (CLUSTER), or places no restrictions (EXTERNAL).
// Each port in the ports field also has an optional visibility field.
// If visibility is specified for a port, it overrides the default service-wide
// DiscoveryInfo.visibility for that port.
// The environment, location, and version fields provide first class support for
// common attributes used to differentiate between similar services. The
// environment may receive values such as PROD/QA/DEV, the location field may
// receive values like EAST-US/WEST-US/EUROPE/AMEA, and the version field may
// receive values like v2.0/v0.9. The exact use of these fields is up to each
// service discovery system.
type DiscoveryInfo struct {
	Visibility  DiscoveryInfo_Visibility `protobuf:"varint,1,req,name=visibility,enum=mesos.DiscoveryInfo_Visibility" json:"visibility"`
	Name        *string                  `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	Environment *string                  `protobuf:"bytes,3,opt,name=environment" json:"environment,omitempty"`
	Location    *string                  `protobuf:"bytes,4,opt,name=location" json:"location,omitempty"`
	Version     *string                  `protobuf:"bytes,5,opt,name=version" json:"version,omitempty"`
	Ports       *Ports                   `protobuf:"bytes,6,opt,name=ports" json:"ports,omitempty"`
	Labels      *Labels                  `protobuf:"bytes,7,opt,name=labels" json:"labels,omitempty"`
}

func (m *DiscoveryInfo) Reset()                    { *m = DiscoveryInfo{} }
func (*DiscoveryInfo) ProtoMessage()               {}
func (*DiscoveryInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{76} }

func (m *DiscoveryInfo) GetVisibility() DiscoveryInfo_Visibility {
	if m != nil {
		return m.Visibility
	}
	return FRAMEWORK
}

func (m *DiscoveryInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *DiscoveryInfo) GetEnvironment() string {
	if m != nil && m.Environment != nil {
		return *m.Environment
	}
	return ""
}

func (m *DiscoveryInfo) GetLocation() string {
	if m != nil && m.Location != nil {
		return *m.Location
	}
	return ""
}

func (m *DiscoveryInfo) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *DiscoveryInfo) GetPorts() *Ports {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *DiscoveryInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

// *
// Named WeightInfo to indicate resource allocation
// priority between the different roles.
type WeightInfo struct {
	Weight float64 `protobuf:"fixed64,1,req,name=weight" json:"weight"`
	// Related role name.
	Role *string `protobuf:"bytes,2,opt,name=role" json:"role,omitempty"`
}

func (m *WeightInfo) Reset()                    { *m = WeightInfo{} }
func (*WeightInfo) ProtoMessage()               {}
func (*WeightInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{77} }

func (m *WeightInfo) GetWeight() float64 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *WeightInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

// *
// Version information of a component.
type VersionInfo struct {
	Version   string   `protobuf:"bytes,1,req,name=version" json:"version"`
	BuildDate *string  `protobuf:"bytes,2,opt,name=build_date,json=buildDate" json:"build_date,omitempty"`
	BuildTime *float64 `protobuf:"fixed64,3,opt,name=build_time,json=buildTime" json:"build_time,omitempty"`
	BuildUser *string  `protobuf:"bytes,4,opt,name=build_user,json=buildUser" json:"build_user,omitempty"`
	GitSHA    *string  `protobuf:"bytes,5,opt,name=git_sha,json=gitSha" json:"git_sha,omitempty"`
	GitBranch *string  `protobuf:"bytes,6,opt,name=git_branch,json=gitBranch" json:"git_branch,omitempty"`
	GitTag    *string  `protobuf:"bytes,7,opt,name=git_tag,json=gitTag" json:"git_tag,omitempty"`
}

func (m *VersionInfo) Reset()                    { *m = VersionInfo{} }
func (*VersionInfo) ProtoMessage()               {}
func (*VersionInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{78} }

func (m *VersionInfo) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *VersionInfo) GetBuildDate() string {
	if m != nil && m.BuildDate != nil {
		return *m.BuildDate
	}
	return ""
}

func (m *VersionInfo) GetBuildTime() float64 {
	if m != nil && m.BuildTime != nil {
		return *m.BuildTime
	}
	return 0
}

func (m *VersionInfo) GetBuildUser() string {
	if m != nil && m.BuildUser != nil {
		return *m.BuildUser
	}
	return ""
}

func (m *VersionInfo) GetGitSHA() string {
	if m != nil && m.GitSHA != nil {
		return *m.GitSHA
	}
	return ""
}

func (m *VersionInfo) GetGitBranch() string {
	if m != nil && m.GitBranch != nil {
		return *m.GitBranch
	}
	return ""
}

func (m *VersionInfo) GetGitTag() string {
	if m != nil && m.GitTag != nil {
		return *m.GitTag
	}
	return ""
}

// *
// Flag consists of a name and optionally its value.
type Flag struct {
	Name  string  `protobuf:"bytes,1,req,name=name" json:"name"`
	Value *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Flag) Reset()                    { *m = Flag{} }
func (*Flag) ProtoMessage()               {}
func (*Flag) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{79} }

func (m *Flag) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Flag) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Describes a Role. Roles can be used to specify that certain resources are
// reserved for the use of one or more frameworks.
type Role struct {
	Name       string        `protobuf:"bytes,1,req,name=name" json:"name"`
	Weight     float64       `protobuf:"fixed64,2,req,name=weight" json:"weight"`
	Frameworks []FrameworkID `protobuf:"bytes,3,rep,name=frameworks" json:"frameworks"`
	Resources  []Resource    `protobuf:"bytes,4,rep,name=resources" json:"resources"`
}

func (m *Role) Reset()                    { *m = Role{} }
func (*Role) ProtoMessage()               {}
func (*Role) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{80} }

func (m *Role) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Role) GetWeight() float64 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *Role) GetFrameworks() []FrameworkID {
	if m != nil {
		return m.Frameworks
	}
	return nil
}

func (m *Role) GetResources() []Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Metric consists of a name and optionally its value.
type Metric struct {
	Name  string   `protobuf:"bytes,1,req,name=name" json:"name"`
	Value *float64 `protobuf:"fixed64,2,opt,name=value" json:"value,omitempty"`
}

func (m *Metric) Reset()                    { *m = Metric{} }
func (*Metric) ProtoMessage()               {}
func (*Metric) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{81} }

func (m *Metric) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Metric) GetValue() float64 {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return 0
}

// *
// Describes a File.
type FileInfo struct {
	// Absolute path to the file.
	Path string `protobuf:"bytes,1,req,name=path" json:"path"`
	// Number of hard links.
	Nlink *int32 `protobuf:"varint,2,opt,name=nlink" json:"nlink,omitempty"`
	// Total size in bytes.
	Size *uint64 `protobuf:"varint,3,opt,name=size" json:"size,omitempty"`
	// Last modification time.
	Mtime *TimeInfo `protobuf:"bytes,4,opt,name=mtime" json:"mtime,omitempty"`
	// Represents a file's mode and permission bits. The bits have the same
	// definition on all systems and is portable.
	Mode *uint32 `protobuf:"varint,5,opt,name=mode" json:"mode,omitempty"`
	// User ID of owner.
	UID *string `protobuf:"bytes,6,opt,name=uid" json:"uid,omitempty"`
	// Group ID of owner.
	GID *string `protobuf:"bytes,7,opt,name=gid" json:"gid,omitempty"`
}

func (m *FileInfo) Reset()                    { *m = FileInfo{} }
func (*FileInfo) ProtoMessage()               {}
func (*FileInfo) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{82} }

func (m *FileInfo) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *FileInfo) GetNlink() int32 {
	if m != nil && m.Nlink != nil {
		return *m.Nlink
	}
	return 0
}

func (m *FileInfo) GetSize() uint64 {
	if m != nil && m.Size != nil {
		return *m.Size
	}
	return 0
}

func (m *FileInfo) GetMtime() *TimeInfo {
	if m != nil {
		return m.Mtime
	}
	return nil
}

func (m *FileInfo) GetMode() uint32 {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return 0
}

func (m *FileInfo) GetUID() string {
	if m != nil && m.UID != nil {
		return *m.UID
	}
	return ""
}

func (m *FileInfo) GetGID() string {
	if m != nil && m.GID != nil {
		return *m.GID
	}
	return ""
}

// *
// Describes information abount a device.
type Device struct {
	Path   *string        `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Number *Device_Number `protobuf:"bytes,2,opt,name=number" json:"number,omitempty"`
}

func (m *Device) Reset()                    { *m = Device{} }
func (*Device) ProtoMessage()               {}
func (*Device) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{83} }

func (m *Device) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *Device) GetNumber() *Device_Number {
	if m != nil {
		return m.Number
	}
	return nil
}

type Device_Number struct {
	MajorNumber *uint64 `protobuf:"varint,1,req,name=major_number,json=majorNumber" json:"major_number,omitempty"`
	MinorNumber *uint64 `protobuf:"varint,2,req,name=minor_number,json=minorNumber" json:"minor_number,omitempty"`
}

func (m *Device_Number) Reset()                    { *m = Device_Number{} }
func (*Device_Number) ProtoMessage()               {}
func (*Device_Number) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{83, 0} }

func (m *Device_Number) GetMajorNumber() uint64 {
	if m != nil && m.MajorNumber != nil {
		return *m.MajorNumber
	}
	return 0
}

func (m *Device_Number) GetMinorNumber() uint64 {
	if m != nil && m.MinorNumber != nil {
		return *m.MinorNumber
	}
	return 0
}

// *
// Describes a device whitelist entry that expose from host to container.
type DeviceAccess struct {
	Device Device              `protobuf:"bytes,1,req,name=device" json:"device"`
	Access DeviceAccess_Access `protobuf:"bytes,2,req,name=access" json:"access"`
}

func (m *DeviceAccess) Reset()                    { *m = DeviceAccess{} }
func (*DeviceAccess) ProtoMessage()               {}
func (*DeviceAccess) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{84} }

func (m *DeviceAccess) GetDevice() Device {
	if m != nil {
		return m.Device
	}
	return Device{}
}

func (m *DeviceAccess) GetAccess() DeviceAccess_Access {
	if m != nil {
		return m.Access
	}
	return DeviceAccess_Access{}
}

type DeviceAccess_Access struct {
	Read  *bool `protobuf:"varint,1,opt,name=read" json:"read,omitempty"`
	Write *bool `protobuf:"varint,2,opt,name=write" json:"write,omitempty"`
	Mknod *bool `protobuf:"varint,3,opt,name=mknod" json:"mknod,omitempty"`
}

func (m *DeviceAccess_Access) Reset()                    { *m = DeviceAccess_Access{} }
func (*DeviceAccess_Access) ProtoMessage()               {}
func (*DeviceAccess_Access) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{84, 0} }

func (m *DeviceAccess_Access) GetRead() bool {
	if m != nil && m.Read != nil {
		return *m.Read
	}
	return false
}

func (m *DeviceAccess_Access) GetWrite() bool {
	if m != nil && m.Write != nil {
		return *m.Write
	}
	return false
}

func (m *DeviceAccess_Access) GetMknod() bool {
	if m != nil && m.Mknod != nil {
		return *m.Mknod
	}
	return false
}

type DeviceWhitelist struct {
	AllowedDevices []DeviceAccess `protobuf:"bytes,1,rep,name=allowed_devices,json=allowedDevices" json:"allowed_devices"`
}

func (m *DeviceWhitelist) Reset()                    { *m = DeviceWhitelist{} }
func (*DeviceWhitelist) ProtoMessage()               {}
func (*DeviceWhitelist) Descriptor() ([]byte, []int) { return fileDescriptorMesos, []int{85} }

func (m *DeviceWhitelist) GetAllowedDevices() []DeviceAccess {
	if m != nil {
		return m.AllowedDevices
	}
	return nil
}

func init() {
	proto.RegisterType((*FrameworkID)(nil), "mesos.FrameworkID")
	proto.RegisterType((*OfferID)(nil), "mesos.OfferID")
	proto.RegisterType((*AgentID)(nil), "mesos.AgentID")
	proto.RegisterType((*TaskID)(nil), "mesos.TaskID")
	proto.RegisterType((*ExecutorID)(nil), "mesos.ExecutorID")
	proto.RegisterType((*ContainerID)(nil), "mesos.ContainerID")
	proto.RegisterType((*ResourceProviderID)(nil), "mesos.ResourceProviderID")
	proto.RegisterType((*OperationID)(nil), "mesos.OperationID")
	proto.RegisterType((*TimeInfo)(nil), "mesos.TimeInfo")
	proto.RegisterType((*DurationInfo)(nil), "mesos.DurationInfo")
	proto.RegisterType((*Address)(nil), "mesos.Address")
	proto.RegisterType((*URL)(nil), "mesos.URL")
	proto.RegisterType((*Unavailability)(nil), "mesos.Unavailability")
	proto.RegisterType((*MachineID)(nil), "mesos.MachineID")
	proto.RegisterType((*MachineInfo)(nil), "mesos.MachineInfo")
	proto.RegisterType((*FrameworkInfo)(nil), "mesos.FrameworkInfo")
	proto.RegisterType((*FrameworkInfo_Capability)(nil), "mesos.FrameworkInfo.Capability")
	proto.RegisterType((*CheckInfo)(nil), "mesos.CheckInfo")
	proto.RegisterType((*CheckInfo_Command)(nil), "mesos.CheckInfo.Command")
	proto.RegisterType((*CheckInfo_Http)(nil), "mesos.CheckInfo.Http")
	proto.RegisterType((*CheckInfo_Tcp)(nil), "mesos.CheckInfo.Tcp")
	proto.RegisterType((*HealthCheck)(nil), "mesos.HealthCheck")
	proto.RegisterType((*HealthCheck_HTTPCheckInfo)(nil), "mesos.HealthCheck.HTTPCheckInfo")
	proto.RegisterType((*HealthCheck_TCPCheckInfo)(nil), "mesos.HealthCheck.TCPCheckInfo")
	proto.RegisterType((*KillPolicy)(nil), "mesos.KillPolicy")
	proto.RegisterType((*CommandInfo)(nil), "mesos.CommandInfo")
	proto.RegisterType((*CommandInfo_URI)(nil), "mesos.CommandInfo.URI")
	proto.RegisterType((*ExecutorInfo)(nil), "mesos.ExecutorInfo")
	proto.RegisterType((*DomainInfo)(nil), "mesos.DomainInfo")
	proto.RegisterType((*DomainInfo_FaultDomain)(nil), "mesos.DomainInfo.FaultDomain")
	proto.RegisterType((*DomainInfo_FaultDomain_RegionInfo)(nil), "mesos.DomainInfo.FaultDomain.RegionInfo")
	proto.RegisterType((*DomainInfo_FaultDomain_ZoneInfo)(nil), "mesos.DomainInfo.FaultDomain.ZoneInfo")
	proto.RegisterType((*MasterInfo)(nil), "mesos.MasterInfo")
	proto.RegisterType((*MasterInfo_Capability)(nil), "mesos.MasterInfo.Capability")
	proto.RegisterType((*AgentInfo)(nil), "mesos.AgentInfo")
	proto.RegisterType((*AgentInfo_Capability)(nil), "mesos.AgentInfo.Capability")
	proto.RegisterType((*CSIPluginContainerInfo)(nil), "mesos.CSIPluginContainerInfo")
	proto.RegisterType((*CSIPluginInfo)(nil), "mesos.CSIPluginInfo")
	proto.RegisterType((*ResourceProviderInfo)(nil), "mesos.ResourceProviderInfo")
	proto.RegisterType((*ResourceProviderInfo_Storage)(nil), "mesos.ResourceProviderInfo.Storage")
	proto.RegisterType((*Value)(nil), "mesos.Value")
	proto.RegisterType((*Value_Scalar)(nil), "mesos.Value.Scalar")
	proto.RegisterType((*Value_Range)(nil), "mesos.Value.Range")
	proto.RegisterType((*Value_Ranges)(nil), "mesos.Value.Ranges")
	proto.RegisterType((*Value_Set)(nil), "mesos.Value.Set")
	proto.RegisterType((*Value_Text)(nil), "mesos.Value.Text")
	proto.RegisterType((*Attribute)(nil), "mesos.Attribute")
	proto.RegisterType((*Resource)(nil), "mesos.Resource")
	proto.RegisterType((*Resource_AllocationInfo)(nil), "mesos.Resource.AllocationInfo")
	proto.RegisterType((*Resource_ReservationInfo)(nil), "mesos.Resource.ReservationInfo")
	proto.RegisterType((*Resource_DiskInfo)(nil), "mesos.Resource.DiskInfo")
	proto.RegisterType((*Resource_DiskInfo_Persistence)(nil), "mesos.Resource.DiskInfo.Persistence")
	proto.RegisterType((*Resource_DiskInfo_Source)(nil), "mesos.Resource.DiskInfo.Source")
	proto.RegisterType((*Resource_DiskInfo_Source_Path)(nil), "mesos.Resource.DiskInfo.Source.Path")
	proto.RegisterType((*Resource_DiskInfo_Source_Mount)(nil), "mesos.Resource.DiskInfo.Source.Mount")
	proto.RegisterType((*Resource_RevocableInfo)(nil), "mesos.Resource.RevocableInfo")
	proto.RegisterType((*Resource_SharedInfo)(nil), "mesos.Resource.SharedInfo")
	proto.RegisterType((*TrafficControlStatistics)(nil), "mesos.TrafficControlStatistics")
	proto.RegisterType((*IpStatistics)(nil), "mesos.IpStatistics")
	proto.RegisterType((*IcmpStatistics)(nil), "mesos.IcmpStatistics")
	proto.RegisterType((*TcpStatistics)(nil), "mesos.TcpStatistics")
	proto.RegisterType((*UdpStatistics)(nil), "mesos.UdpStatistics")
	proto.RegisterType((*SNMPStatistics)(nil), "mesos.SNMPStatistics")
	proto.RegisterType((*DiskStatistics)(nil), "mesos.DiskStatistics")
	proto.RegisterType((*ResourceStatistics)(nil), "mesos.ResourceStatistics")
	proto.RegisterType((*ResourceUsage)(nil), "mesos.ResourceUsage")
	proto.RegisterType((*ResourceUsage_Executor)(nil), "mesos.ResourceUsage.Executor")
	proto.RegisterType((*ResourceUsage_Executor_Task)(nil), "mesos.ResourceUsage.Executor.Task")
	proto.RegisterType((*PerfStatistics)(nil), "mesos.PerfStatistics")
	proto.RegisterType((*Request)(nil), "mesos.Request")
	proto.RegisterType((*Offer)(nil), "mesos.Offer")
	proto.RegisterType((*Offer_Operation)(nil), "mesos.Offer.Operation")
	proto.RegisterType((*Offer_Operation_Launch)(nil), "mesos.Offer.Operation.Launch")
	proto.RegisterType((*Offer_Operation_LaunchGroup)(nil), "mesos.Offer.Operation.LaunchGroup")
	proto.RegisterType((*Offer_Operation_Reserve)(nil), "mesos.Offer.Operation.Reserve")
	proto.RegisterType((*Offer_Operation_Unreserve)(nil), "mesos.Offer.Operation.Unreserve")
	proto.RegisterType((*Offer_Operation_Create)(nil), "mesos.Offer.Operation.Create")
	proto.RegisterType((*Offer_Operation_Destroy)(nil), "mesos.Offer.Operation.Destroy")
	proto.RegisterType((*Offer_Operation_CreateVolume)(nil), "mesos.Offer.Operation.CreateVolume")
	proto.RegisterType((*Offer_Operation_DestroyVolume)(nil), "mesos.Offer.Operation.DestroyVolume")
	proto.RegisterType((*Offer_Operation_CreateBlock)(nil), "mesos.Offer.Operation.CreateBlock")
	proto.RegisterType((*Offer_Operation_DestroyBlock)(nil), "mesos.Offer.Operation.DestroyBlock")
	proto.RegisterType((*InverseOffer)(nil), "mesos.InverseOffer")
	proto.RegisterType((*TaskInfo)(nil), "mesos.TaskInfo")
	proto.RegisterType((*TaskGroupInfo)(nil), "mesos.TaskGroupInfo")
	proto.RegisterType((*Task)(nil), "mesos.Task")
	proto.RegisterType((*TaskResourceLimitation)(nil), "mesos.TaskResourceLimitation")
	proto.RegisterType((*UUID)(nil), "mesos.UUID")
	proto.RegisterType((*Operation)(nil), "mesos.Operation")
	proto.RegisterType((*OperationStatus)(nil), "mesos.OperationStatus")
	proto.RegisterType((*CheckStatusInfo)(nil), "mesos.CheckStatusInfo")
	proto.RegisterType((*CheckStatusInfo_Command)(nil), "mesos.CheckStatusInfo.Command")
	proto.RegisterType((*CheckStatusInfo_Http)(nil), "mesos.CheckStatusInfo.Http")
	proto.RegisterType((*CheckStatusInfo_Tcp)(nil), "mesos.CheckStatusInfo.Tcp")
	proto.RegisterType((*TaskStatus)(nil), "mesos.TaskStatus")
	proto.RegisterType((*Filters)(nil), "mesos.Filters")
	proto.RegisterType((*Environment)(nil), "mesos.Environment")
	proto.RegisterType((*Environment_Variable)(nil), "mesos.Environment.Variable")
	proto.RegisterType((*Parameter)(nil), "mesos.Parameter")
	proto.RegisterType((*Parameters)(nil), "mesos.Parameters")
	proto.RegisterType((*Credential)(nil), "mesos.Credential")
	proto.RegisterType((*Credentials)(nil), "mesos.Credentials")
	proto.RegisterType((*Secret)(nil), "mesos.Secret")
	proto.RegisterType((*Secret_Reference)(nil), "mesos.Secret.Reference")
	proto.RegisterType((*Secret_Value)(nil), "mesos.Secret.Value")
	proto.RegisterType((*RateLimit)(nil), "mesos.RateLimit")
	proto.RegisterType((*RateLimits)(nil), "mesos.RateLimits")
	proto.RegisterType((*Image)(nil), "mesos.Image")
	proto.RegisterType((*Image_Appc)(nil), "mesos.Image.Appc")
	proto.RegisterType((*Image_Docker)(nil), "mesos.Image.Docker")
	proto.RegisterType((*MountPropagation)(nil), "mesos.MountPropagation")
	proto.RegisterType((*Volume)(nil), "mesos.Volume")
	proto.RegisterType((*Volume_Source)(nil), "mesos.Volume.Source")
	proto.RegisterType((*Volume_Source_DockerVolume)(nil), "mesos.Volume.Source.DockerVolume")
	proto.RegisterType((*Volume_Source_HostPath)(nil), "mesos.Volume.Source.HostPath")
	proto.RegisterType((*Volume_Source_SandboxPath)(nil), "mesos.Volume.Source.SandboxPath")
	proto.RegisterType((*NetworkInfo)(nil), "mesos.NetworkInfo")
	proto.RegisterType((*NetworkInfo_IPAddress)(nil), "mesos.NetworkInfo.IPAddress")
	proto.RegisterType((*NetworkInfo_PortMapping)(nil), "mesos.NetworkInfo.PortMapping")
	proto.RegisterType((*CapabilityInfo)(nil), "mesos.CapabilityInfo")
	proto.RegisterType((*LinuxInfo)(nil), "mesos.LinuxInfo")
	proto.RegisterType((*RLimitInfo)(nil), "mesos.RLimitInfo")
	proto.RegisterType((*RLimitInfo_RLimit)(nil), "mesos.RLimitInfo.RLimit")
	proto.RegisterType((*TTYInfo)(nil), "mesos.TTYInfo")
	proto.RegisterType((*TTYInfo_WindowSize)(nil), "mesos.TTYInfo.WindowSize")
	proto.RegisterType((*ContainerInfo)(nil), "mesos.ContainerInfo")
	proto.RegisterType((*ContainerInfo_DockerInfo)(nil), "mesos.ContainerInfo.DockerInfo")
	proto.RegisterType((*ContainerInfo_DockerInfo_PortMapping)(nil), "mesos.ContainerInfo.DockerInfo.PortMapping")
	proto.RegisterType((*ContainerInfo_MesosInfo)(nil), "mesos.ContainerInfo.MesosInfo")
	proto.RegisterType((*ContainerStatus)(nil), "mesos.ContainerStatus")
	proto.RegisterType((*CgroupInfo)(nil), "mesos.CgroupInfo")
	proto.RegisterType((*CgroupInfo_Blkio)(nil), "mesos.CgroupInfo.Blkio")
	proto.RegisterType((*CgroupInfo_Blkio_Value)(nil), "mesos.CgroupInfo.Blkio.Value")
	proto.RegisterType((*CgroupInfo_Blkio_CFQ)(nil), "mesos.CgroupInfo.Blkio.CFQ")
	proto.RegisterType((*CgroupInfo_Blkio_CFQ_Statistics)(nil), "mesos.CgroupInfo.Blkio.CFQ.Statistics")
	proto.RegisterType((*CgroupInfo_Blkio_Throttling)(nil), "mesos.CgroupInfo.Blkio.Throttling")
	proto.RegisterType((*CgroupInfo_Blkio_Throttling_Statistics)(nil), "mesos.CgroupInfo.Blkio.Throttling.Statistics")
	proto.RegisterType((*CgroupInfo_Blkio_Statistics)(nil), "mesos.CgroupInfo.Blkio.Statistics")
	proto.RegisterType((*CgroupInfo_NetCls)(nil), "mesos.CgroupInfo.NetCls")
	proto.RegisterType((*Labels)(nil), "mesos.Labels")
	proto.RegisterType((*Label)(nil), "mesos.Label")
	proto.RegisterType((*Port)(nil), "mesos.Port")
	proto.RegisterType((*Ports)(nil), "mesos.Ports")
	proto.RegisterType((*DiscoveryInfo)(nil), "mesos.DiscoveryInfo")
	proto.RegisterType((*WeightInfo)(nil), "mesos.WeightInfo")
	proto.RegisterType((*VersionInfo)(nil), "mesos.VersionInfo")
	proto.RegisterType((*Flag)(nil), "mesos.Flag")
	proto.RegisterType((*Role)(nil), "mesos.Role")
	proto.RegisterType((*Metric)(nil), "mesos.Metric")
	proto.RegisterType((*FileInfo)(nil), "mesos.FileInfo")
	proto.RegisterType((*Device)(nil), "mesos.Device")
	proto.RegisterType((*Device_Number)(nil), "mesos.Device.Number")
	proto.RegisterType((*DeviceAccess)(nil), "mesos.DeviceAccess")
	proto.RegisterType((*DeviceAccess_Access)(nil), "mesos.DeviceAccess.Access")
	proto.RegisterType((*DeviceWhitelist)(nil), "mesos.DeviceWhitelist")
	proto.RegisterEnum("mesos.Status", Status_name, Status_value)
	proto.RegisterEnum("mesos.TaskState", TaskState_name, TaskState_value)
	proto.RegisterEnum("mesos.OperationState", OperationState_name, OperationState_value)
	proto.RegisterEnum("mesos.MachineInfo_Mode", MachineInfo_Mode_name, MachineInfo_Mode_value)
	proto.RegisterEnum("mesos.FrameworkInfo_Capability_Type", FrameworkInfo_Capability_Type_name, FrameworkInfo_Capability_Type_value)
	proto.RegisterEnum("mesos.CheckInfo_Type", CheckInfo_Type_name, CheckInfo_Type_value)
	proto.RegisterEnum("mesos.HealthCheck_Type", HealthCheck_Type_name, HealthCheck_Type_value)
	proto.RegisterEnum("mesos.ExecutorInfo_Type", ExecutorInfo_Type_name, ExecutorInfo_Type_value)
	proto.RegisterEnum("mesos.MasterInfo_Capability_Type", MasterInfo_Capability_Type_name, MasterInfo_Capability_Type_value)
	proto.RegisterEnum("mesos.AgentInfo_Capability_Type", AgentInfo_Capability_Type_name, AgentInfo_Capability_Type_value)
	proto.RegisterEnum("mesos.CSIPluginContainerInfo_Service", CSIPluginContainerInfo_Service_name, CSIPluginContainerInfo_Service_value)
	proto.RegisterEnum("mesos.Value_Type", Value_Type_name, Value_Type_value)
	proto.RegisterEnum("mesos.Resource_ReservationInfo_Type", Resource_ReservationInfo_Type_name, Resource_ReservationInfo_Type_value)
	proto.RegisterEnum("mesos.Resource_DiskInfo_Source_Type", Resource_DiskInfo_Source_Type_name, Resource_DiskInfo_Source_Type_value)
	proto.RegisterEnum("mesos.Offer_Operation_Type", Offer_Operation_Type_name, Offer_Operation_Type_value)
	proto.RegisterEnum("mesos.TaskStatus_Source", TaskStatus_Source_name, TaskStatus_Source_value)
	proto.RegisterEnum("mesos.TaskStatus_Reason", TaskStatus_Reason_name, TaskStatus_Reason_value)
	proto.RegisterEnum("mesos.Environment_Variable_Type", Environment_Variable_Type_name, Environment_Variable_Type_value)
	proto.RegisterEnum("mesos.Secret_Type", Secret_Type_name, Secret_Type_value)
	proto.RegisterEnum("mesos.Image_Type", Image_Type_name, Image_Type_value)
	proto.RegisterEnum("mesos.MountPropagation_Mode", MountPropagation_Mode_name, MountPropagation_Mode_value)
	proto.RegisterEnum("mesos.Volume_Mode", Volume_Mode_name, Volume_Mode_value)
	proto.RegisterEnum("mesos.Volume_Source_Type", Volume_Source_Type_name, Volume_Source_Type_value)
	proto.RegisterEnum("mesos.Volume_Source_SandboxPath_Type", Volume_Source_SandboxPath_Type_name, Volume_Source_SandboxPath_Type_value)
	proto.RegisterEnum("mesos.NetworkInfo_Protocol", NetworkInfo_Protocol_name, NetworkInfo_Protocol_value)
	proto.RegisterEnum("mesos.CapabilityInfo_Capability", CapabilityInfo_Capability_name, CapabilityInfo_Capability_value)
	proto.RegisterEnum("mesos.RLimitInfo_RLimit_Type", RLimitInfo_RLimit_Type_name, RLimitInfo_RLimit_Type_value)
	proto.RegisterEnum("mesos.ContainerInfo_Type", ContainerInfo_Type_name, ContainerInfo_Type_value)
	proto.RegisterEnum("mesos.ContainerInfo_DockerInfo_Network", ContainerInfo_DockerInfo_Network_name, ContainerInfo_DockerInfo_Network_value)
	proto.RegisterEnum("mesos.CgroupInfo_Blkio_Operation", CgroupInfo_Blkio_Operation_name, CgroupInfo_Blkio_Operation_value)
	proto.RegisterEnum("mesos.DiscoveryInfo_Visibility", DiscoveryInfo_Visibility_name, DiscoveryInfo_Visibility_value)
}
func (x Status) String() string {
	s, ok := Status_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x TaskState) String() string {
	s, ok := TaskState_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x OperationState) String() string {
	s, ok := OperationState_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x MachineInfo_Mode) String() string {
	s, ok := MachineInfo_Mode_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x FrameworkInfo_Capability_Type) String() string {
	s, ok := FrameworkInfo_Capability_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x CheckInfo_Type) String() string {
	s, ok := CheckInfo_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x HealthCheck_Type) String() string {
	s, ok := HealthCheck_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ExecutorInfo_Type) String() string {
	s, ok := ExecutorInfo_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x MasterInfo_Capability_Type) String() string {
	s, ok := MasterInfo_Capability_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x AgentInfo_Capability_Type) String() string {
	s, ok := AgentInfo_Capability_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x CSIPluginContainerInfo_Service) String() string {
	s, ok := CSIPluginContainerInfo_Service_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Value_Type) String() string {
	s, ok := Value_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Resource_ReservationInfo_Type) String() string {
	s, ok := Resource_ReservationInfo_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Resource_DiskInfo_Source_Type) String() string {
	s, ok := Resource_DiskInfo_Source_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Offer_Operation_Type) String() string {
	s, ok := Offer_Operation_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x TaskStatus_Source) String() string {
	s, ok := TaskStatus_Source_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x TaskStatus_Reason) String() string {
	s, ok := TaskStatus_Reason_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Environment_Variable_Type) String() string {
	s, ok := Environment_Variable_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Secret_Type) String() string {
	s, ok := Secret_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Image_Type) String() string {
	s, ok := Image_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x MountPropagation_Mode) String() string {
	s, ok := MountPropagation_Mode_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Volume_Mode) String() string {
	s, ok := Volume_Mode_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Volume_Source_Type) String() string {
	s, ok := Volume_Source_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Volume_Source_SandboxPath_Type) String() string {
	s, ok := Volume_Source_SandboxPath_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x NetworkInfo_Protocol) String() string {
	s, ok := NetworkInfo_Protocol_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x CapabilityInfo_Capability) String() string {
	s, ok := CapabilityInfo_Capability_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x RLimitInfo_RLimit_Type) String() string {
	s, ok := RLimitInfo_RLimit_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ContainerInfo_Type) String() string {
	s, ok := ContainerInfo_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ContainerInfo_DockerInfo_Network) String() string {
	s, ok := ContainerInfo_DockerInfo_Network_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x CgroupInfo_Blkio_Operation) String() string {
	s, ok := CgroupInfo_Blkio_Operation_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x DiscoveryInfo_Visibility) String() string {
	s, ok := DiscoveryInfo_Visibility_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *FrameworkID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkID)
	if !ok {
		that2, ok := that.(FrameworkID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *FrameworkID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *FrameworkID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *FrameworkID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *FrameworkID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkID)
	if !ok {
		that2, ok := that.(FrameworkID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *OfferID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*OfferID)
	if !ok {
		that2, ok := that.(OfferID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *OfferID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *OfferID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *OfferID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *OfferID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*OfferID)
	if !ok {
		that2, ok := that.(OfferID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *AgentID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*AgentID)
	if !ok {
		that2, ok := that.(AgentID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *AgentID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *AgentID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *AgentID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *AgentID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*AgentID)
	if !ok {
		that2, ok := that.(AgentID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *TaskID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskID)
	if !ok {
		that2, ok := that.(TaskID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TaskID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *TaskID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskID)
	if !ok {
		that2, ok := that.(TaskID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *ExecutorID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ExecutorID)
	if !ok {
		that2, ok := that.(ExecutorID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ExecutorID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ExecutorID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ExecutorID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *ExecutorID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ExecutorID)
	if !ok {
		that2, ok := that.(ExecutorID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *ContainerID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerID)
	if !ok {
		that2, ok := that.(ContainerID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ContainerID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !this.Parent.Equal(that1.Parent) {
		return fmt.Errorf("Parent this(%v) Not Equal that(%v)", this.Parent, that1.Parent)
	}
	return nil
}
func (this *ContainerID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerID)
	if !ok {
		that2, ok := that.(ContainerID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !this.Parent.Equal(that1.Parent) {
		return false
	}
	return true
}
func (this *ResourceProviderID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceProviderID)
	if !ok {
		that2, ok := that.(ResourceProviderID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ResourceProviderID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceProviderID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceProviderID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *ResourceProviderID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceProviderID)
	if !ok {
		that2, ok := that.(ResourceProviderID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *OperationID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*OperationID)
	if !ok {
		that2, ok := that.(OperationID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *OperationID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *OperationID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *OperationID but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *OperationID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*OperationID)
	if !ok {
		that2, ok := that.(OperationID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *TimeInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TimeInfo)
	if !ok {
		that2, ok := that.(TimeInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TimeInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TimeInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TimeInfo but is not nil && this == nil")
	}
	if this.Nanoseconds != that1.Nanoseconds {
		return fmt.Errorf("Nanoseconds this(%v) Not Equal that(%v)", this.Nanoseconds, that1.Nanoseconds)
	}
	return nil
}
func (this *TimeInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TimeInfo)
	if !ok {
		that2, ok := that.(TimeInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Nanoseconds != that1.Nanoseconds {
		return false
	}
	return true
}
func (this *DurationInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DurationInfo)
	if !ok {
		that2, ok := that.(DurationInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DurationInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DurationInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DurationInfo but is not nil && this == nil")
	}
	if this.Nanoseconds != that1.Nanoseconds {
		return fmt.Errorf("Nanoseconds this(%v) Not Equal that(%v)", this.Nanoseconds, that1.Nanoseconds)
	}
	return nil
}
func (this *DurationInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DurationInfo)
	if !ok {
		that2, ok := that.(DurationInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Nanoseconds != that1.Nanoseconds {
		return false
	}
	return true
}
func (this *Address) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Address)
	if !ok {
		that2, ok := that.(Address)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Address")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Address but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Address but is not nil && this == nil")
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.IP != nil && that1.IP != nil {
		if *this.IP != *that1.IP {
			return fmt.Errorf("IP this(%v) Not Equal that(%v)", *this.IP, *that1.IP)
		}
	} else if this.IP != nil {
		return fmt.Errorf("this.IP == nil && that.IP != nil")
	} else if that1.IP != nil {
		return fmt.Errorf("IP this(%v) Not Equal that(%v)", this.IP, that1.IP)
	}
	if this.Port != that1.Port {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	return nil
}
func (this *Address) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Address)
	if !ok {
		that2, ok := that.(Address)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.IP != nil && that1.IP != nil {
		if *this.IP != *that1.IP {
			return false
		}
	} else if this.IP != nil {
		return false
	} else if that1.IP != nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	return true
}
func (this *URL) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*URL)
	if !ok {
		that2, ok := that.(URL)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *URL")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *URL but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *URL but is not nil && this == nil")
	}
	if this.Scheme != that1.Scheme {
		return fmt.Errorf("Scheme this(%v) Not Equal that(%v)", this.Scheme, that1.Scheme)
	}
	if !this.Address.Equal(&that1.Address) {
		return fmt.Errorf("Address this(%v) Not Equal that(%v)", this.Address, that1.Address)
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return fmt.Errorf("Path this(%v) Not Equal that(%v)", *this.Path, *that1.Path)
		}
	} else if this.Path != nil {
		return fmt.Errorf("this.Path == nil && that.Path != nil")
	} else if that1.Path != nil {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if len(this.Query) != len(that1.Query) {
		return fmt.Errorf("Query this(%v) Not Equal that(%v)", len(this.Query), len(that1.Query))
	}
	for i := range this.Query {
		if !this.Query[i].Equal(&that1.Query[i]) {
			return fmt.Errorf("Query this[%v](%v) Not Equal that[%v](%v)", i, this.Query[i], i, that1.Query[i])
		}
	}
	if this.Fragment != nil && that1.Fragment != nil {
		if *this.Fragment != *that1.Fragment {
			return fmt.Errorf("Fragment this(%v) Not Equal that(%v)", *this.Fragment, *that1.Fragment)
		}
	} else if this.Fragment != nil {
		return fmt.Errorf("this.Fragment == nil && that.Fragment != nil")
	} else if that1.Fragment != nil {
		return fmt.Errorf("Fragment this(%v) Not Equal that(%v)", this.Fragment, that1.Fragment)
	}
	return nil
}
func (this *URL) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*URL)
	if !ok {
		that2, ok := that.(URL)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Scheme != that1.Scheme {
		return false
	}
	if !this.Address.Equal(&that1.Address) {
		return false
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return false
		}
	} else if this.Path != nil {
		return false
	} else if that1.Path != nil {
		return false
	}
	if len(this.Query) != len(that1.Query) {
		return false
	}
	for i := range this.Query {
		if !this.Query[i].Equal(&that1.Query[i]) {
			return false
		}
	}
	if this.Fragment != nil && that1.Fragment != nil {
		if *this.Fragment != *that1.Fragment {
			return false
		}
	} else if this.Fragment != nil {
		return false
	} else if that1.Fragment != nil {
		return false
	}
	return true
}
func (this *Unavailability) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Unavailability)
	if !ok {
		that2, ok := that.(Unavailability)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Unavailability")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Unavailability but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Unavailability but is not nil && this == nil")
	}
	if !this.Start.Equal(&that1.Start) {
		return fmt.Errorf("Start this(%v) Not Equal that(%v)", this.Start, that1.Start)
	}
	if !this.Duration.Equal(that1.Duration) {
		return fmt.Errorf("Duration this(%v) Not Equal that(%v)", this.Duration, that1.Duration)
	}
	return nil
}
func (this *Unavailability) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Unavailability)
	if !ok {
		that2, ok := that.(Unavailability)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Start.Equal(&that1.Start) {
		return false
	}
	if !this.Duration.Equal(that1.Duration) {
		return false
	}
	return true
}
func (this *MachineID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MachineID)
	if !ok {
		that2, ok := that.(MachineID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *MachineID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MachineID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MachineID but is not nil && this == nil")
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.IP != nil && that1.IP != nil {
		if *this.IP != *that1.IP {
			return fmt.Errorf("IP this(%v) Not Equal that(%v)", *this.IP, *that1.IP)
		}
	} else if this.IP != nil {
		return fmt.Errorf("this.IP == nil && that.IP != nil")
	} else if that1.IP != nil {
		return fmt.Errorf("IP this(%v) Not Equal that(%v)", this.IP, that1.IP)
	}
	return nil
}
func (this *MachineID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MachineID)
	if !ok {
		that2, ok := that.(MachineID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.IP != nil && that1.IP != nil {
		if *this.IP != *that1.IP {
			return false
		}
	} else if this.IP != nil {
		return false
	} else if that1.IP != nil {
		return false
	}
	return true
}
func (this *MachineInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MachineInfo)
	if !ok {
		that2, ok := that.(MachineInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *MachineInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MachineInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MachineInfo but is not nil && this == nil")
	}
	if !this.ID.Equal(&that1.ID) {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return fmt.Errorf("Mode this(%v) Not Equal that(%v)", *this.Mode, *that1.Mode)
		}
	} else if this.Mode != nil {
		return fmt.Errorf("this.Mode == nil && that.Mode != nil")
	} else if that1.Mode != nil {
		return fmt.Errorf("Mode this(%v) Not Equal that(%v)", this.Mode, that1.Mode)
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return fmt.Errorf("Unavailability this(%v) Not Equal that(%v)", this.Unavailability, that1.Unavailability)
	}
	return nil
}
func (this *MachineInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MachineInfo)
	if !ok {
		that2, ok := that.(MachineInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ID.Equal(&that1.ID) {
		return false
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return false
		}
	} else if this.Mode != nil {
		return false
	} else if that1.Mode != nil {
		return false
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return false
	}
	return true
}
func (this *FrameworkInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkInfo)
	if !ok {
		that2, ok := that.(FrameworkInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *FrameworkInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *FrameworkInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *FrameworkInfo but is not nil && this == nil")
	}
	if this.User != that1.User {
		return fmt.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.ID.Equal(that1.ID) {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if this.FailoverTimeout != nil && that1.FailoverTimeout != nil {
		if *this.FailoverTimeout != *that1.FailoverTimeout {
			return fmt.Errorf("FailoverTimeout this(%v) Not Equal that(%v)", *this.FailoverTimeout, *that1.FailoverTimeout)
		}
	} else if this.FailoverTimeout != nil {
		return fmt.Errorf("this.FailoverTimeout == nil && that.FailoverTimeout != nil")
	} else if that1.FailoverTimeout != nil {
		return fmt.Errorf("FailoverTimeout this(%v) Not Equal that(%v)", this.FailoverTimeout, that1.FailoverTimeout)
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", *this.Checkpoint, *that1.Checkpoint)
		}
	} else if this.Checkpoint != nil {
		return fmt.Errorf("this.Checkpoint == nil && that.Checkpoint != nil")
	} else if that1.Checkpoint != nil {
		return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", this.Checkpoint, that1.Checkpoint)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if len(this.Roles) != len(that1.Roles) {
		return fmt.Errorf("Roles this(%v) Not Equal that(%v)", len(this.Roles), len(that1.Roles))
	}
	for i := range this.Roles {
		if this.Roles[i] != that1.Roles[i] {
			return fmt.Errorf("Roles this[%v](%v) Not Equal that[%v](%v)", i, this.Roles[i], i, that1.Roles[i])
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.WebUiURL != nil && that1.WebUiURL != nil {
		if *this.WebUiURL != *that1.WebUiURL {
			return fmt.Errorf("WebUiURL this(%v) Not Equal that(%v)", *this.WebUiURL, *that1.WebUiURL)
		}
	} else if this.WebUiURL != nil {
		return fmt.Errorf("this.WebUiURL == nil && that.WebUiURL != nil")
	} else if that1.WebUiURL != nil {
		return fmt.Errorf("WebUiURL this(%v) Not Equal that(%v)", this.WebUiURL, that1.WebUiURL)
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return fmt.Errorf("Capabilities this(%v) Not Equal that(%v)", len(this.Capabilities), len(that1.Capabilities))
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(&that1.Capabilities[i]) {
			return fmt.Errorf("Capabilities this[%v](%v) Not Equal that[%v](%v)", i, this.Capabilities[i], i, that1.Capabilities[i])
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	return nil
}
func (this *FrameworkInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkInfo)
	if !ok {
		that2, ok := that.(FrameworkInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.ID.Equal(that1.ID) {
		return false
	}
	if this.FailoverTimeout != nil && that1.FailoverTimeout != nil {
		if *this.FailoverTimeout != *that1.FailoverTimeout {
			return false
		}
	} else if this.FailoverTimeout != nil {
		return false
	} else if that1.FailoverTimeout != nil {
		return false
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return false
		}
	} else if this.Checkpoint != nil {
		return false
	} else if that1.Checkpoint != nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if len(this.Roles) != len(that1.Roles) {
		return false
	}
	for i := range this.Roles {
		if this.Roles[i] != that1.Roles[i] {
			return false
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if this.WebUiURL != nil && that1.WebUiURL != nil {
		if *this.WebUiURL != *that1.WebUiURL {
			return false
		}
	} else if this.WebUiURL != nil {
		return false
	} else if that1.WebUiURL != nil {
		return false
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return false
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(&that1.Capabilities[i]) {
			return false
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	return true
}
func (this *FrameworkInfo_Capability) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkInfo_Capability)
	if !ok {
		that2, ok := that.(FrameworkInfo_Capability)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *FrameworkInfo_Capability")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *FrameworkInfo_Capability but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *FrameworkInfo_Capability but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	return nil
}
func (this *FrameworkInfo_Capability) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkInfo_Capability)
	if !ok {
		that2, ok := that.(FrameworkInfo_Capability)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	return true
}
func (this *CheckInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckInfo)
	if !ok {
		that2, ok := that.(CheckInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckInfo but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.HTTP.Equal(that1.HTTP) {
		return fmt.Errorf("HTTP this(%v) Not Equal that(%v)", this.HTTP, that1.HTTP)
	}
	if !this.TCP.Equal(that1.TCP) {
		return fmt.Errorf("TCP this(%v) Not Equal that(%v)", this.TCP, that1.TCP)
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return fmt.Errorf("DelaySeconds this(%v) Not Equal that(%v)", *this.DelaySeconds, *that1.DelaySeconds)
		}
	} else if this.DelaySeconds != nil {
		return fmt.Errorf("this.DelaySeconds == nil && that.DelaySeconds != nil")
	} else if that1.DelaySeconds != nil {
		return fmt.Errorf("DelaySeconds this(%v) Not Equal that(%v)", this.DelaySeconds, that1.DelaySeconds)
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return fmt.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", *this.IntervalSeconds, *that1.IntervalSeconds)
		}
	} else if this.IntervalSeconds != nil {
		return fmt.Errorf("this.IntervalSeconds == nil && that.IntervalSeconds != nil")
	} else if that1.IntervalSeconds != nil {
		return fmt.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", this.IntervalSeconds, that1.IntervalSeconds)
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return fmt.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", *this.TimeoutSeconds, *that1.TimeoutSeconds)
		}
	} else if this.TimeoutSeconds != nil {
		return fmt.Errorf("this.TimeoutSeconds == nil && that.TimeoutSeconds != nil")
	} else if that1.TimeoutSeconds != nil {
		return fmt.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", this.TimeoutSeconds, that1.TimeoutSeconds)
	}
	return nil
}
func (this *CheckInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckInfo)
	if !ok {
		that2, ok := that.(CheckInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.HTTP.Equal(that1.HTTP) {
		return false
	}
	if !this.TCP.Equal(that1.TCP) {
		return false
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return false
		}
	} else if this.DelaySeconds != nil {
		return false
	} else if that1.DelaySeconds != nil {
		return false
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return false
		}
	} else if this.IntervalSeconds != nil {
		return false
	} else if that1.IntervalSeconds != nil {
		return false
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return false
		}
	} else if this.TimeoutSeconds != nil {
		return false
	} else if that1.TimeoutSeconds != nil {
		return false
	}
	return true
}
func (this *CheckInfo_Command) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckInfo_Command)
	if !ok {
		that2, ok := that.(CheckInfo_Command)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckInfo_Command")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckInfo_Command but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckInfo_Command but is not nil && this == nil")
	}
	if !this.Command.Equal(&that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	return nil
}
func (this *CheckInfo_Command) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckInfo_Command)
	if !ok {
		that2, ok := that.(CheckInfo_Command)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Command.Equal(&that1.Command) {
		return false
	}
	return true
}
func (this *CheckInfo_Http) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckInfo_Http)
	if !ok {
		that2, ok := that.(CheckInfo_Http)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckInfo_Http")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckInfo_Http but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckInfo_Http but is not nil && this == nil")
	}
	if this.Port != that1.Port {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return fmt.Errorf("Path this(%v) Not Equal that(%v)", *this.Path, *that1.Path)
		}
	} else if this.Path != nil {
		return fmt.Errorf("this.Path == nil && that.Path != nil")
	} else if that1.Path != nil {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	return nil
}
func (this *CheckInfo_Http) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckInfo_Http)
	if !ok {
		that2, ok := that.(CheckInfo_Http)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return false
		}
	} else if this.Path != nil {
		return false
	} else if that1.Path != nil {
		return false
	}
	return true
}
func (this *CheckInfo_Tcp) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckInfo_Tcp)
	if !ok {
		that2, ok := that.(CheckInfo_Tcp)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckInfo_Tcp")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckInfo_Tcp but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckInfo_Tcp but is not nil && this == nil")
	}
	if this.Port != that1.Port {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	return nil
}
func (this *CheckInfo_Tcp) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckInfo_Tcp)
	if !ok {
		that2, ok := that.(CheckInfo_Tcp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	return true
}
func (this *HealthCheck) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*HealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *HealthCheck")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *HealthCheck but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *HealthCheck but is not nil && this == nil")
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return fmt.Errorf("DelaySeconds this(%v) Not Equal that(%v)", *this.DelaySeconds, *that1.DelaySeconds)
		}
	} else if this.DelaySeconds != nil {
		return fmt.Errorf("this.DelaySeconds == nil && that.DelaySeconds != nil")
	} else if that1.DelaySeconds != nil {
		return fmt.Errorf("DelaySeconds this(%v) Not Equal that(%v)", this.DelaySeconds, that1.DelaySeconds)
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return fmt.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", *this.IntervalSeconds, *that1.IntervalSeconds)
		}
	} else if this.IntervalSeconds != nil {
		return fmt.Errorf("this.IntervalSeconds == nil && that.IntervalSeconds != nil")
	} else if that1.IntervalSeconds != nil {
		return fmt.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", this.IntervalSeconds, that1.IntervalSeconds)
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return fmt.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", *this.TimeoutSeconds, *that1.TimeoutSeconds)
		}
	} else if this.TimeoutSeconds != nil {
		return fmt.Errorf("this.TimeoutSeconds == nil && that.TimeoutSeconds != nil")
	} else if that1.TimeoutSeconds != nil {
		return fmt.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", this.TimeoutSeconds, that1.TimeoutSeconds)
	}
	if this.ConsecutiveFailures != nil && that1.ConsecutiveFailures != nil {
		if *this.ConsecutiveFailures != *that1.ConsecutiveFailures {
			return fmt.Errorf("ConsecutiveFailures this(%v) Not Equal that(%v)", *this.ConsecutiveFailures, *that1.ConsecutiveFailures)
		}
	} else if this.ConsecutiveFailures != nil {
		return fmt.Errorf("this.ConsecutiveFailures == nil && that.ConsecutiveFailures != nil")
	} else if that1.ConsecutiveFailures != nil {
		return fmt.Errorf("ConsecutiveFailures this(%v) Not Equal that(%v)", this.ConsecutiveFailures, that1.ConsecutiveFailures)
	}
	if this.GracePeriodSeconds != nil && that1.GracePeriodSeconds != nil {
		if *this.GracePeriodSeconds != *that1.GracePeriodSeconds {
			return fmt.Errorf("GracePeriodSeconds this(%v) Not Equal that(%v)", *this.GracePeriodSeconds, *that1.GracePeriodSeconds)
		}
	} else if this.GracePeriodSeconds != nil {
		return fmt.Errorf("this.GracePeriodSeconds == nil && that.GracePeriodSeconds != nil")
	} else if that1.GracePeriodSeconds != nil {
		return fmt.Errorf("GracePeriodSeconds this(%v) Not Equal that(%v)", this.GracePeriodSeconds, that1.GracePeriodSeconds)
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.HTTP.Equal(that1.HTTP) {
		return fmt.Errorf("HTTP this(%v) Not Equal that(%v)", this.HTTP, that1.HTTP)
	}
	if !this.TCP.Equal(that1.TCP) {
		return fmt.Errorf("TCP this(%v) Not Equal that(%v)", this.TCP, that1.TCP)
	}
	return nil
}
func (this *HealthCheck) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HealthCheck)
	if !ok {
		that2, ok := that.(HealthCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return false
		}
	} else if this.DelaySeconds != nil {
		return false
	} else if that1.DelaySeconds != nil {
		return false
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return false
		}
	} else if this.IntervalSeconds != nil {
		return false
	} else if that1.IntervalSeconds != nil {
		return false
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return false
		}
	} else if this.TimeoutSeconds != nil {
		return false
	} else if that1.TimeoutSeconds != nil {
		return false
	}
	if this.ConsecutiveFailures != nil && that1.ConsecutiveFailures != nil {
		if *this.ConsecutiveFailures != *that1.ConsecutiveFailures {
			return false
		}
	} else if this.ConsecutiveFailures != nil {
		return false
	} else if that1.ConsecutiveFailures != nil {
		return false
	}
	if this.GracePeriodSeconds != nil && that1.GracePeriodSeconds != nil {
		if *this.GracePeriodSeconds != *that1.GracePeriodSeconds {
			return false
		}
	} else if this.GracePeriodSeconds != nil {
		return false
	} else if that1.GracePeriodSeconds != nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.HTTP.Equal(that1.HTTP) {
		return false
	}
	if !this.TCP.Equal(that1.TCP) {
		return false
	}
	return true
}
func (this *HealthCheck_HTTPCheckInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*HealthCheck_HTTPCheckInfo)
	if !ok {
		that2, ok := that.(HealthCheck_HTTPCheckInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *HealthCheck_HTTPCheckInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *HealthCheck_HTTPCheckInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *HealthCheck_HTTPCheckInfo but is not nil && this == nil")
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if this.Scheme != nil && that1.Scheme != nil {
		if *this.Scheme != *that1.Scheme {
			return fmt.Errorf("Scheme this(%v) Not Equal that(%v)", *this.Scheme, *that1.Scheme)
		}
	} else if this.Scheme != nil {
		return fmt.Errorf("this.Scheme == nil && that.Scheme != nil")
	} else if that1.Scheme != nil {
		return fmt.Errorf("Scheme this(%v) Not Equal that(%v)", this.Scheme, that1.Scheme)
	}
	if this.Port != that1.Port {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return fmt.Errorf("Path this(%v) Not Equal that(%v)", *this.Path, *that1.Path)
		}
	} else if this.Path != nil {
		return fmt.Errorf("this.Path == nil && that.Path != nil")
	} else if that1.Path != nil {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return fmt.Errorf("Statuses this(%v) Not Equal that(%v)", len(this.Statuses), len(that1.Statuses))
	}
	for i := range this.Statuses {
		if this.Statuses[i] != that1.Statuses[i] {
			return fmt.Errorf("Statuses this[%v](%v) Not Equal that[%v](%v)", i, this.Statuses[i], i, that1.Statuses[i])
		}
	}
	return nil
}
func (this *HealthCheck_HTTPCheckInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HealthCheck_HTTPCheckInfo)
	if !ok {
		that2, ok := that.(HealthCheck_HTTPCheckInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if this.Scheme != nil && that1.Scheme != nil {
		if *this.Scheme != *that1.Scheme {
			return false
		}
	} else if this.Scheme != nil {
		return false
	} else if that1.Scheme != nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return false
		}
	} else if this.Path != nil {
		return false
	} else if that1.Path != nil {
		return false
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return false
	}
	for i := range this.Statuses {
		if this.Statuses[i] != that1.Statuses[i] {
			return false
		}
	}
	return true
}
func (this *HealthCheck_TCPCheckInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*HealthCheck_TCPCheckInfo)
	if !ok {
		that2, ok := that.(HealthCheck_TCPCheckInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *HealthCheck_TCPCheckInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *HealthCheck_TCPCheckInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *HealthCheck_TCPCheckInfo but is not nil && this == nil")
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if this.Port != that1.Port {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	return nil
}
func (this *HealthCheck_TCPCheckInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HealthCheck_TCPCheckInfo)
	if !ok {
		that2, ok := that.(HealthCheck_TCPCheckInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	return true
}
func (this *KillPolicy) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*KillPolicy)
	if !ok {
		that2, ok := that.(KillPolicy)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *KillPolicy")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *KillPolicy but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *KillPolicy but is not nil && this == nil")
	}
	if !this.GracePeriod.Equal(that1.GracePeriod) {
		return fmt.Errorf("GracePeriod this(%v) Not Equal that(%v)", this.GracePeriod, that1.GracePeriod)
	}
	return nil
}
func (this *KillPolicy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*KillPolicy)
	if !ok {
		that2, ok := that.(KillPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.GracePeriod.Equal(that1.GracePeriod) {
		return false
	}
	return true
}
func (this *CommandInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo)
	if !ok {
		that2, ok := that.(CommandInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CommandInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CommandInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CommandInfo but is not nil && this == nil")
	}
	if len(this.URIs) != len(that1.URIs) {
		return fmt.Errorf("URIs this(%v) Not Equal that(%v)", len(this.URIs), len(that1.URIs))
	}
	for i := range this.URIs {
		if !this.URIs[i].Equal(&that1.URIs[i]) {
			return fmt.Errorf("URIs this[%v](%v) Not Equal that[%v](%v)", i, this.URIs[i], i, that1.URIs[i])
		}
	}
	if !this.Environment.Equal(that1.Environment) {
		return fmt.Errorf("Environment this(%v) Not Equal that(%v)", this.Environment, that1.Environment)
	}
	if this.Shell != nil && that1.Shell != nil {
		if *this.Shell != *that1.Shell {
			return fmt.Errorf("Shell this(%v) Not Equal that(%v)", *this.Shell, *that1.Shell)
		}
	} else if this.Shell != nil {
		return fmt.Errorf("this.Shell == nil && that.Shell != nil")
	} else if that1.Shell != nil {
		return fmt.Errorf("Shell this(%v) Not Equal that(%v)", this.Shell, that1.Shell)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if len(this.Arguments) != len(that1.Arguments) {
		return fmt.Errorf("Arguments this(%v) Not Equal that(%v)", len(this.Arguments), len(that1.Arguments))
	}
	for i := range this.Arguments {
		if this.Arguments[i] != that1.Arguments[i] {
			return fmt.Errorf("Arguments this[%v](%v) Not Equal that[%v](%v)", i, this.Arguments[i], i, that1.Arguments[i])
		}
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return fmt.Errorf("User this(%v) Not Equal that(%v)", *this.User, *that1.User)
		}
	} else if this.User != nil {
		return fmt.Errorf("this.User == nil && that.User != nil")
	} else if that1.User != nil {
		return fmt.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	return nil
}
func (this *CommandInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo)
	if !ok {
		that2, ok := that.(CommandInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.URIs) != len(that1.URIs) {
		return false
	}
	for i := range this.URIs {
		if !this.URIs[i].Equal(&that1.URIs[i]) {
			return false
		}
	}
	if !this.Environment.Equal(that1.Environment) {
		return false
	}
	if this.Shell != nil && that1.Shell != nil {
		if *this.Shell != *that1.Shell {
			return false
		}
	} else if this.Shell != nil {
		return false
	} else if that1.Shell != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if len(this.Arguments) != len(that1.Arguments) {
		return false
	}
	for i := range this.Arguments {
		if this.Arguments[i] != that1.Arguments[i] {
			return false
		}
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return false
		}
	} else if this.User != nil {
		return false
	} else if that1.User != nil {
		return false
	}
	return true
}
func (this *CommandInfo_URI) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo_URI)
	if !ok {
		that2, ok := that.(CommandInfo_URI)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CommandInfo_URI")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CommandInfo_URI but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CommandInfo_URI but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if this.Executable != nil && that1.Executable != nil {
		if *this.Executable != *that1.Executable {
			return fmt.Errorf("Executable this(%v) Not Equal that(%v)", *this.Executable, *that1.Executable)
		}
	} else if this.Executable != nil {
		return fmt.Errorf("this.Executable == nil && that.Executable != nil")
	} else if that1.Executable != nil {
		return fmt.Errorf("Executable this(%v) Not Equal that(%v)", this.Executable, that1.Executable)
	}
	if this.Extract != nil && that1.Extract != nil {
		if *this.Extract != *that1.Extract {
			return fmt.Errorf("Extract this(%v) Not Equal that(%v)", *this.Extract, *that1.Extract)
		}
	} else if this.Extract != nil {
		return fmt.Errorf("this.Extract == nil && that.Extract != nil")
	} else if that1.Extract != nil {
		return fmt.Errorf("Extract this(%v) Not Equal that(%v)", this.Extract, that1.Extract)
	}
	if this.Cache != nil && that1.Cache != nil {
		if *this.Cache != *that1.Cache {
			return fmt.Errorf("Cache this(%v) Not Equal that(%v)", *this.Cache, *that1.Cache)
		}
	} else if this.Cache != nil {
		return fmt.Errorf("this.Cache == nil && that.Cache != nil")
	} else if that1.Cache != nil {
		return fmt.Errorf("Cache this(%v) Not Equal that(%v)", this.Cache, that1.Cache)
	}
	if this.OutputFile != nil && that1.OutputFile != nil {
		if *this.OutputFile != *that1.OutputFile {
			return fmt.Errorf("OutputFile this(%v) Not Equal that(%v)", *this.OutputFile, *that1.OutputFile)
		}
	} else if this.OutputFile != nil {
		return fmt.Errorf("this.OutputFile == nil && that.OutputFile != nil")
	} else if that1.OutputFile != nil {
		return fmt.Errorf("OutputFile this(%v) Not Equal that(%v)", this.OutputFile, that1.OutputFile)
	}
	return nil
}
func (this *CommandInfo_URI) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo_URI)
	if !ok {
		that2, ok := that.(CommandInfo_URI)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if this.Executable != nil && that1.Executable != nil {
		if *this.Executable != *that1.Executable {
			return false
		}
	} else if this.Executable != nil {
		return false
	} else if that1.Executable != nil {
		return false
	}
	if this.Extract != nil && that1.Extract != nil {
		if *this.Extract != *that1.Extract {
			return false
		}
	} else if this.Extract != nil {
		return false
	} else if that1.Extract != nil {
		return false
	}
	if this.Cache != nil && that1.Cache != nil {
		if *this.Cache != *that1.Cache {
			return false
		}
	} else if this.Cache != nil {
		return false
	} else if that1.Cache != nil {
		return false
	}
	if this.OutputFile != nil && that1.OutputFile != nil {
		if *this.OutputFile != *that1.OutputFile {
			return false
		}
	} else if this.OutputFile != nil {
		return false
	} else if that1.OutputFile != nil {
		return false
	}
	return true
}
func (this *ExecutorInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ExecutorInfo)
	if !ok {
		that2, ok := that.(ExecutorInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ExecutorInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ExecutorInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ExecutorInfo but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return fmt.Errorf("Source this(%v) Not Equal that(%v)", *this.Source, *that1.Source)
		}
	} else if this.Source != nil {
		return fmt.Errorf("this.Source == nil && that.Source != nil")
	} else if that1.Source != nil {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return fmt.Errorf("Discovery this(%v) Not Equal that(%v)", this.Discovery, that1.Discovery)
	}
	if !this.ShutdownGracePeriod.Equal(that1.ShutdownGracePeriod) {
		return fmt.Errorf("ShutdownGracePeriod this(%v) Not Equal that(%v)", this.ShutdownGracePeriod, that1.ShutdownGracePeriod)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	return nil
}
func (this *ExecutorInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ExecutorInfo)
	if !ok {
		that2, ok := that.(ExecutorInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return false
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return false
		}
	} else if this.Source != nil {
		return false
	} else if that1.Source != nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return false
	}
	if !this.ShutdownGracePeriod.Equal(that1.ShutdownGracePeriod) {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	return true
}
func (this *DomainInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DomainInfo)
	if !ok {
		that2, ok := that.(DomainInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DomainInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DomainInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DomainInfo but is not nil && this == nil")
	}
	if !this.FaultDomain.Equal(that1.FaultDomain) {
		return fmt.Errorf("FaultDomain this(%v) Not Equal that(%v)", this.FaultDomain, that1.FaultDomain)
	}
	return nil
}
func (this *DomainInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DomainInfo)
	if !ok {
		that2, ok := that.(DomainInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FaultDomain.Equal(that1.FaultDomain) {
		return false
	}
	return true
}
func (this *DomainInfo_FaultDomain) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DomainInfo_FaultDomain)
	if !ok {
		that2, ok := that.(DomainInfo_FaultDomain)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DomainInfo_FaultDomain")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DomainInfo_FaultDomain but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DomainInfo_FaultDomain but is not nil && this == nil")
	}
	if !this.Region.Equal(&that1.Region) {
		return fmt.Errorf("Region this(%v) Not Equal that(%v)", this.Region, that1.Region)
	}
	if !this.Zone.Equal(&that1.Zone) {
		return fmt.Errorf("Zone this(%v) Not Equal that(%v)", this.Zone, that1.Zone)
	}
	return nil
}
func (this *DomainInfo_FaultDomain) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DomainInfo_FaultDomain)
	if !ok {
		that2, ok := that.(DomainInfo_FaultDomain)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Region.Equal(&that1.Region) {
		return false
	}
	if !this.Zone.Equal(&that1.Zone) {
		return false
	}
	return true
}
func (this *DomainInfo_FaultDomain_RegionInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DomainInfo_FaultDomain_RegionInfo)
	if !ok {
		that2, ok := that.(DomainInfo_FaultDomain_RegionInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DomainInfo_FaultDomain_RegionInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DomainInfo_FaultDomain_RegionInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DomainInfo_FaultDomain_RegionInfo but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	return nil
}
func (this *DomainInfo_FaultDomain_RegionInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DomainInfo_FaultDomain_RegionInfo)
	if !ok {
		that2, ok := that.(DomainInfo_FaultDomain_RegionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	return true
}
func (this *DomainInfo_FaultDomain_ZoneInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DomainInfo_FaultDomain_ZoneInfo)
	if !ok {
		that2, ok := that.(DomainInfo_FaultDomain_ZoneInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DomainInfo_FaultDomain_ZoneInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DomainInfo_FaultDomain_ZoneInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DomainInfo_FaultDomain_ZoneInfo but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	return nil
}
func (this *DomainInfo_FaultDomain_ZoneInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DomainInfo_FaultDomain_ZoneInfo)
	if !ok {
		that2, ok := that.(DomainInfo_FaultDomain_ZoneInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	return true
}
func (this *MasterInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MasterInfo)
	if !ok {
		that2, ok := that.(MasterInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *MasterInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MasterInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MasterInfo but is not nil && this == nil")
	}
	if this.ID != that1.ID {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if this.IP != that1.IP {
		return fmt.Errorf("IP this(%v) Not Equal that(%v)", this.IP, that1.IP)
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if this.PID != nil && that1.PID != nil {
		if *this.PID != *that1.PID {
			return fmt.Errorf("PID this(%v) Not Equal that(%v)", *this.PID, *that1.PID)
		}
	} else if this.PID != nil {
		return fmt.Errorf("this.PID == nil && that.PID != nil")
	} else if that1.PID != nil {
		return fmt.Errorf("PID this(%v) Not Equal that(%v)", this.PID, that1.PID)
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return fmt.Errorf("Version this(%v) Not Equal that(%v)", *this.Version, *that1.Version)
		}
	} else if this.Version != nil {
		return fmt.Errorf("this.Version == nil && that.Version != nil")
	} else if that1.Version != nil {
		return fmt.Errorf("Version this(%v) Not Equal that(%v)", this.Version, that1.Version)
	}
	if !this.Address.Equal(that1.Address) {
		return fmt.Errorf("Address this(%v) Not Equal that(%v)", this.Address, that1.Address)
	}
	if !this.Domain.Equal(that1.Domain) {
		return fmt.Errorf("Domain this(%v) Not Equal that(%v)", this.Domain, that1.Domain)
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return fmt.Errorf("Capabilities this(%v) Not Equal that(%v)", len(this.Capabilities), len(that1.Capabilities))
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(&that1.Capabilities[i]) {
			return fmt.Errorf("Capabilities this[%v](%v) Not Equal that[%v](%v)", i, this.Capabilities[i], i, that1.Capabilities[i])
		}
	}
	return nil
}
func (this *MasterInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MasterInfo)
	if !ok {
		that2, ok := that.(MasterInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ID != that1.ID {
		return false
	}
	if this.IP != that1.IP {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if this.PID != nil && that1.PID != nil {
		if *this.PID != *that1.PID {
			return false
		}
	} else if this.PID != nil {
		return false
	} else if that1.PID != nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return false
		}
	} else if this.Version != nil {
		return false
	} else if that1.Version != nil {
		return false
	}
	if !this.Address.Equal(that1.Address) {
		return false
	}
	if !this.Domain.Equal(that1.Domain) {
		return false
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return false
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(&that1.Capabilities[i]) {
			return false
		}
	}
	return true
}
func (this *MasterInfo_Capability) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MasterInfo_Capability)
	if !ok {
		that2, ok := that.(MasterInfo_Capability)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *MasterInfo_Capability")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MasterInfo_Capability but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MasterInfo_Capability but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	return nil
}
func (this *MasterInfo_Capability) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MasterInfo_Capability)
	if !ok {
		that2, ok := that.(MasterInfo_Capability)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	return true
}
func (this *AgentInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*AgentInfo)
	if !ok {
		that2, ok := that.(AgentInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *AgentInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *AgentInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *AgentInfo but is not nil && this == nil")
	}
	if this.Hostname != that1.Hostname {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return fmt.Errorf("Attributes this(%v) Not Equal that(%v)", len(this.Attributes), len(that1.Attributes))
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(&that1.Attributes[i]) {
			return fmt.Errorf("Attributes this[%v](%v) Not Equal that[%v](%v)", i, this.Attributes[i], i, that1.Attributes[i])
		}
	}
	if !this.ID.Equal(that1.ID) {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if !this.Domain.Equal(that1.Domain) {
		return fmt.Errorf("Domain this(%v) Not Equal that(%v)", this.Domain, that1.Domain)
	}
	return nil
}
func (this *AgentInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*AgentInfo)
	if !ok {
		that2, ok := that.(AgentInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Hostname != that1.Hostname {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(&that1.Attributes[i]) {
			return false
		}
	}
	if !this.ID.Equal(that1.ID) {
		return false
	}
	if !this.Domain.Equal(that1.Domain) {
		return false
	}
	return true
}
func (this *AgentInfo_Capability) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*AgentInfo_Capability)
	if !ok {
		that2, ok := that.(AgentInfo_Capability)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *AgentInfo_Capability")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *AgentInfo_Capability but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *AgentInfo_Capability but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	return nil
}
func (this *AgentInfo_Capability) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*AgentInfo_Capability)
	if !ok {
		that2, ok := that.(AgentInfo_Capability)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	return true
}
func (this *CSIPluginContainerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CSIPluginContainerInfo)
	if !ok {
		that2, ok := that.(CSIPluginContainerInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CSIPluginContainerInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CSIPluginContainerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CSIPluginContainerInfo but is not nil && this == nil")
	}
	if len(this.Services) != len(that1.Services) {
		return fmt.Errorf("Services this(%v) Not Equal that(%v)", len(this.Services), len(that1.Services))
	}
	for i := range this.Services {
		if this.Services[i] != that1.Services[i] {
			return fmt.Errorf("Services this[%v](%v) Not Equal that[%v](%v)", i, this.Services[i], i, that1.Services[i])
		}
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	return nil
}
func (this *CSIPluginContainerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CSIPluginContainerInfo)
	if !ok {
		that2, ok := that.(CSIPluginContainerInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Services) != len(that1.Services) {
		return false
	}
	for i := range this.Services {
		if this.Services[i] != that1.Services[i] {
			return false
		}
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	return true
}
func (this *CSIPluginInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CSIPluginInfo)
	if !ok {
		that2, ok := that.(CSIPluginInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CSIPluginInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CSIPluginInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CSIPluginInfo but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if len(this.Containers) != len(that1.Containers) {
		return fmt.Errorf("Containers this(%v) Not Equal that(%v)", len(this.Containers), len(that1.Containers))
	}
	for i := range this.Containers {
		if !this.Containers[i].Equal(&that1.Containers[i]) {
			return fmt.Errorf("Containers this[%v](%v) Not Equal that[%v](%v)", i, this.Containers[i], i, that1.Containers[i])
		}
	}
	return nil
}
func (this *CSIPluginInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CSIPluginInfo)
	if !ok {
		that2, ok := that.(CSIPluginInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Containers) != len(that1.Containers) {
		return false
	}
	for i := range this.Containers {
		if !this.Containers[i].Equal(&that1.Containers[i]) {
			return false
		}
	}
	return true
}
func (this *ResourceProviderInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceProviderInfo)
	if !ok {
		that2, ok := that.(ResourceProviderInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ResourceProviderInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceProviderInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceProviderInfo but is not nil && this == nil")
	}
	if !this.ID.Equal(that1.ID) {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return fmt.Errorf("Attributes this(%v) Not Equal that(%v)", len(this.Attributes), len(that1.Attributes))
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(&that1.Attributes[i]) {
			return fmt.Errorf("Attributes this[%v](%v) Not Equal that[%v](%v)", i, this.Attributes[i], i, that1.Attributes[i])
		}
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if len(this.DefaultReservations) != len(that1.DefaultReservations) {
		return fmt.Errorf("DefaultReservations this(%v) Not Equal that(%v)", len(this.DefaultReservations), len(that1.DefaultReservations))
	}
	for i := range this.DefaultReservations {
		if !this.DefaultReservations[i].Equal(&that1.DefaultReservations[i]) {
			return fmt.Errorf("DefaultReservations this[%v](%v) Not Equal that[%v](%v)", i, this.DefaultReservations[i], i, that1.DefaultReservations[i])
		}
	}
	if !this.Storage.Equal(that1.Storage) {
		return fmt.Errorf("Storage this(%v) Not Equal that(%v)", this.Storage, that1.Storage)
	}
	return nil
}
func (this *ResourceProviderInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceProviderInfo)
	if !ok {
		that2, ok := that.(ResourceProviderInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ID.Equal(that1.ID) {
		return false
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(&that1.Attributes[i]) {
			return false
		}
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.DefaultReservations) != len(that1.DefaultReservations) {
		return false
	}
	for i := range this.DefaultReservations {
		if !this.DefaultReservations[i].Equal(&that1.DefaultReservations[i]) {
			return false
		}
	}
	if !this.Storage.Equal(that1.Storage) {
		return false
	}
	return true
}
func (this *ResourceProviderInfo_Storage) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceProviderInfo_Storage)
	if !ok {
		that2, ok := that.(ResourceProviderInfo_Storage)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ResourceProviderInfo_Storage")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceProviderInfo_Storage but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceProviderInfo_Storage but is not nil && this == nil")
	}
	if !this.Plugin.Equal(&that1.Plugin) {
		return fmt.Errorf("Plugin this(%v) Not Equal that(%v)", this.Plugin, that1.Plugin)
	}
	return nil
}
func (this *ResourceProviderInfo_Storage) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceProviderInfo_Storage)
	if !ok {
		that2, ok := that.(ResourceProviderInfo_Storage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Plugin.Equal(&that1.Plugin) {
		return false
	}
	return true
}
func (this *Value) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value)
	if !ok {
		that2, ok := that.(Value)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Value")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if !this.Text.Equal(that1.Text) {
		return fmt.Errorf("Text this(%v) Not Equal that(%v)", this.Text, that1.Text)
	}
	return nil
}
func (this *Value) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value)
	if !ok {
		that2, ok := that.(Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if !this.Text.Equal(that1.Text) {
		return false
	}
	return true
}
func (this *Value_Scalar) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Scalar)
	if !ok {
		that2, ok := that.(Value_Scalar)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Value_Scalar")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Scalar but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Scalar but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *Value_Scalar) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Scalar)
	if !ok {
		that2, ok := that.(Value_Scalar)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *Value_Range) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Range)
	if !ok {
		that2, ok := that.(Value_Range)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Value_Range")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Range but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Range but is not nil && this == nil")
	}
	if this.Begin != that1.Begin {
		return fmt.Errorf("Begin this(%v) Not Equal that(%v)", this.Begin, that1.Begin)
	}
	if this.End != that1.End {
		return fmt.Errorf("End this(%v) Not Equal that(%v)", this.End, that1.End)
	}
	return nil
}
func (this *Value_Range) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Range)
	if !ok {
		that2, ok := that.(Value_Range)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Begin != that1.Begin {
		return false
	}
	if this.End != that1.End {
		return false
	}
	return true
}
func (this *Value_Ranges) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Ranges)
	if !ok {
		that2, ok := that.(Value_Ranges)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Value_Ranges")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Ranges but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Ranges but is not nil && this == nil")
	}
	if len(this.Range) != len(that1.Range) {
		return fmt.Errorf("Range this(%v) Not Equal that(%v)", len(this.Range), len(that1.Range))
	}
	for i := range this.Range {
		if !this.Range[i].Equal(&that1.Range[i]) {
			return fmt.Errorf("Range this[%v](%v) Not Equal that[%v](%v)", i, this.Range[i], i, that1.Range[i])
		}
	}
	return nil
}
func (this *Value_Ranges) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Ranges)
	if !ok {
		that2, ok := that.(Value_Ranges)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Range) != len(that1.Range) {
		return false
	}
	for i := range this.Range {
		if !this.Range[i].Equal(&that1.Range[i]) {
			return false
		}
	}
	return true
}
func (this *Value_Set) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Set)
	if !ok {
		that2, ok := that.(Value_Set)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Value_Set")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Set but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Set but is not nil && this == nil")
	}
	if len(this.Item) != len(that1.Item) {
		return fmt.Errorf("Item this(%v) Not Equal that(%v)", len(this.Item), len(that1.Item))
	}
	for i := range this.Item {
		if this.Item[i] != that1.Item[i] {
			return fmt.Errorf("Item this[%v](%v) Not Equal that[%v](%v)", i, this.Item[i], i, that1.Item[i])
		}
	}
	return nil
}
func (this *Value_Set) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Set)
	if !ok {
		that2, ok := that.(Value_Set)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Item) != len(that1.Item) {
		return false
	}
	for i := range this.Item {
		if this.Item[i] != that1.Item[i] {
			return false
		}
	}
	return true
}
func (this *Value_Text) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Text)
	if !ok {
		that2, ok := that.(Value_Text)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Value_Text")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Text but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Text but is not nil && this == nil")
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *Value_Text) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Text)
	if !ok {
		that2, ok := that.(Value_Text)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *Attribute) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Attribute)
	if !ok {
		that2, ok := that.(Attribute)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Attribute")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Attribute but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Attribute but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if !this.Text.Equal(that1.Text) {
		return fmt.Errorf("Text this(%v) Not Equal that(%v)", this.Text, that1.Text)
	}
	return nil
}
func (this *Attribute) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Attribute)
	if !ok {
		that2, ok := that.(Attribute)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if !this.Text.Equal(that1.Text) {
		return false
	}
	return true
}
func (this *Resource) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource)
	if !ok {
		that2, ok := that.(Resource)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource but is not nil && this == nil")
	}
	if !this.ProviderID.Equal(that1.ProviderID) {
		return fmt.Errorf("ProviderID this(%v) Not Equal that(%v)", this.ProviderID, that1.ProviderID)
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if !this.AllocationInfo.Equal(that1.AllocationInfo) {
		return fmt.Errorf("AllocationInfo this(%v) Not Equal that(%v)", this.AllocationInfo, that1.AllocationInfo)
	}
	if !this.Reservation.Equal(that1.Reservation) {
		return fmt.Errorf("Reservation this(%v) Not Equal that(%v)", this.Reservation, that1.Reservation)
	}
	if len(this.Reservations) != len(that1.Reservations) {
		return fmt.Errorf("Reservations this(%v) Not Equal that(%v)", len(this.Reservations), len(that1.Reservations))
	}
	for i := range this.Reservations {
		if !this.Reservations[i].Equal(&that1.Reservations[i]) {
			return fmt.Errorf("Reservations this[%v](%v) Not Equal that[%v](%v)", i, this.Reservations[i], i, that1.Reservations[i])
		}
	}
	if !this.Disk.Equal(that1.Disk) {
		return fmt.Errorf("Disk this(%v) Not Equal that(%v)", this.Disk, that1.Disk)
	}
	if !this.Revocable.Equal(that1.Revocable) {
		return fmt.Errorf("Revocable this(%v) Not Equal that(%v)", this.Revocable, that1.Revocable)
	}
	if !this.Shared.Equal(that1.Shared) {
		return fmt.Errorf("Shared this(%v) Not Equal that(%v)", this.Shared, that1.Shared)
	}
	return nil
}
func (this *Resource) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource)
	if !ok {
		that2, ok := that.(Resource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ProviderID.Equal(that1.ProviderID) {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if !this.AllocationInfo.Equal(that1.AllocationInfo) {
		return false
	}
	if !this.Reservation.Equal(that1.Reservation) {
		return false
	}
	if len(this.Reservations) != len(that1.Reservations) {
		return false
	}
	for i := range this.Reservations {
		if !this.Reservations[i].Equal(&that1.Reservations[i]) {
			return false
		}
	}
	if !this.Disk.Equal(that1.Disk) {
		return false
	}
	if !this.Revocable.Equal(that1.Revocable) {
		return false
	}
	if !this.Shared.Equal(that1.Shared) {
		return false
	}
	return true
}
func (this *Resource_AllocationInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_AllocationInfo)
	if !ok {
		that2, ok := that.(Resource_AllocationInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_AllocationInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_AllocationInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_AllocationInfo but is not nil && this == nil")
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	return nil
}
func (this *Resource_AllocationInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_AllocationInfo)
	if !ok {
		that2, ok := that.(Resource_AllocationInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	return true
}
func (this *Resource_ReservationInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_ReservationInfo)
	if !ok {
		that2, ok := that.(Resource_ReservationInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_ReservationInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_ReservationInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_ReservationInfo but is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	return nil
}
func (this *Resource_ReservationInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_ReservationInfo)
	if !ok {
		that2, ok := that.(Resource_ReservationInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	return true
}
func (this *Resource_DiskInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_DiskInfo)
	if !ok {
		that2, ok := that.(Resource_DiskInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_DiskInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_DiskInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_DiskInfo but is not nil && this == nil")
	}
	if !this.Persistence.Equal(that1.Persistence) {
		return fmt.Errorf("Persistence this(%v) Not Equal that(%v)", this.Persistence, that1.Persistence)
	}
	if !this.Volume.Equal(that1.Volume) {
		return fmt.Errorf("Volume this(%v) Not Equal that(%v)", this.Volume, that1.Volume)
	}
	if !this.Source.Equal(that1.Source) {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	return nil
}
func (this *Resource_DiskInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_DiskInfo)
	if !ok {
		that2, ok := that.(Resource_DiskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Persistence.Equal(that1.Persistence) {
		return false
	}
	if !this.Volume.Equal(that1.Volume) {
		return false
	}
	if !this.Source.Equal(that1.Source) {
		return false
	}
	return true
}
func (this *Resource_DiskInfo_Persistence) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_DiskInfo_Persistence)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Persistence)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_DiskInfo_Persistence")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_DiskInfo_Persistence but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_DiskInfo_Persistence but is not nil && this == nil")
	}
	if this.ID != that1.ID {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	return nil
}
func (this *Resource_DiskInfo_Persistence) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_DiskInfo_Persistence)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Persistence)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ID != that1.ID {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	return true
}
func (this *Resource_DiskInfo_Source) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_DiskInfo_Source)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Source)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_DiskInfo_Source")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_DiskInfo_Source but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_DiskInfo_Source but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Path.Equal(that1.Path) {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if !this.Mount.Equal(that1.Mount) {
		return fmt.Errorf("Mount this(%v) Not Equal that(%v)", this.Mount, that1.Mount)
	}
	if this.ID != nil && that1.ID != nil {
		if *this.ID != *that1.ID {
			return fmt.Errorf("ID this(%v) Not Equal that(%v)", *this.ID, *that1.ID)
		}
	} else if this.ID != nil {
		return fmt.Errorf("this.ID == nil && that.ID != nil")
	} else if that1.ID != nil {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return fmt.Errorf("Metadata this(%v) Not Equal that(%v)", this.Metadata, that1.Metadata)
	}
	if this.Profile != nil && that1.Profile != nil {
		if *this.Profile != *that1.Profile {
			return fmt.Errorf("Profile this(%v) Not Equal that(%v)", *this.Profile, *that1.Profile)
		}
	} else if this.Profile != nil {
		return fmt.Errorf("this.Profile == nil && that.Profile != nil")
	} else if that1.Profile != nil {
		return fmt.Errorf("Profile this(%v) Not Equal that(%v)", this.Profile, that1.Profile)
	}
	return nil
}
func (this *Resource_DiskInfo_Source) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_DiskInfo_Source)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Source)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Path.Equal(that1.Path) {
		return false
	}
	if !this.Mount.Equal(that1.Mount) {
		return false
	}
	if this.ID != nil && that1.ID != nil {
		if *this.ID != *that1.ID {
			return false
		}
	} else if this.ID != nil {
		return false
	} else if that1.ID != nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if this.Profile != nil && that1.Profile != nil {
		if *this.Profile != *that1.Profile {
			return false
		}
	} else if this.Profile != nil {
		return false
	} else if that1.Profile != nil {
		return false
	}
	return true
}
func (this *Resource_DiskInfo_Source_Path) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_DiskInfo_Source_Path)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Source_Path)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_DiskInfo_Source_Path")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_DiskInfo_Source_Path but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_DiskInfo_Source_Path but is not nil && this == nil")
	}
	if this.Root != nil && that1.Root != nil {
		if *this.Root != *that1.Root {
			return fmt.Errorf("Root this(%v) Not Equal that(%v)", *this.Root, *that1.Root)
		}
	} else if this.Root != nil {
		return fmt.Errorf("this.Root == nil && that.Root != nil")
	} else if that1.Root != nil {
		return fmt.Errorf("Root this(%v) Not Equal that(%v)", this.Root, that1.Root)
	}
	return nil
}
func (this *Resource_DiskInfo_Source_Path) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_DiskInfo_Source_Path)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Source_Path)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Root != nil && that1.Root != nil {
		if *this.Root != *that1.Root {
			return false
		}
	} else if this.Root != nil {
		return false
	} else if that1.Root != nil {
		return false
	}
	return true
}
func (this *Resource_DiskInfo_Source_Mount) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_DiskInfo_Source_Mount)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Source_Mount)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_DiskInfo_Source_Mount")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_DiskInfo_Source_Mount but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_DiskInfo_Source_Mount but is not nil && this == nil")
	}
	if this.Root != nil && that1.Root != nil {
		if *this.Root != *that1.Root {
			return fmt.Errorf("Root this(%v) Not Equal that(%v)", *this.Root, *that1.Root)
		}
	} else if this.Root != nil {
		return fmt.Errorf("this.Root == nil && that.Root != nil")
	} else if that1.Root != nil {
		return fmt.Errorf("Root this(%v) Not Equal that(%v)", this.Root, that1.Root)
	}
	return nil
}
func (this *Resource_DiskInfo_Source_Mount) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_DiskInfo_Source_Mount)
	if !ok {
		that2, ok := that.(Resource_DiskInfo_Source_Mount)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Root != nil && that1.Root != nil {
		if *this.Root != *that1.Root {
			return false
		}
	} else if this.Root != nil {
		return false
	} else if that1.Root != nil {
		return false
	}
	return true
}
func (this *Resource_RevocableInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_RevocableInfo)
	if !ok {
		that2, ok := that.(Resource_RevocableInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_RevocableInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_RevocableInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_RevocableInfo but is not nil && this == nil")
	}
	return nil
}
func (this *Resource_RevocableInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_RevocableInfo)
	if !ok {
		that2, ok := that.(Resource_RevocableInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *Resource_SharedInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_SharedInfo)
	if !ok {
		that2, ok := that.(Resource_SharedInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Resource_SharedInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_SharedInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_SharedInfo but is not nil && this == nil")
	}
	return nil
}
func (this *Resource_SharedInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_SharedInfo)
	if !ok {
		that2, ok := that.(Resource_SharedInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *TrafficControlStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TrafficControlStatistics)
	if !ok {
		that2, ok := that.(TrafficControlStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TrafficControlStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TrafficControlStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TrafficControlStatistics but is not nil && this == nil")
	}
	if this.ID != that1.ID {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if this.Backlog != nil && that1.Backlog != nil {
		if *this.Backlog != *that1.Backlog {
			return fmt.Errorf("Backlog this(%v) Not Equal that(%v)", *this.Backlog, *that1.Backlog)
		}
	} else if this.Backlog != nil {
		return fmt.Errorf("this.Backlog == nil && that.Backlog != nil")
	} else if that1.Backlog != nil {
		return fmt.Errorf("Backlog this(%v) Not Equal that(%v)", this.Backlog, that1.Backlog)
	}
	if this.Bytes != nil && that1.Bytes != nil {
		if *this.Bytes != *that1.Bytes {
			return fmt.Errorf("Bytes this(%v) Not Equal that(%v)", *this.Bytes, *that1.Bytes)
		}
	} else if this.Bytes != nil {
		return fmt.Errorf("this.Bytes == nil && that.Bytes != nil")
	} else if that1.Bytes != nil {
		return fmt.Errorf("Bytes this(%v) Not Equal that(%v)", this.Bytes, that1.Bytes)
	}
	if this.Drops != nil && that1.Drops != nil {
		if *this.Drops != *that1.Drops {
			return fmt.Errorf("Drops this(%v) Not Equal that(%v)", *this.Drops, *that1.Drops)
		}
	} else if this.Drops != nil {
		return fmt.Errorf("this.Drops == nil && that.Drops != nil")
	} else if that1.Drops != nil {
		return fmt.Errorf("Drops this(%v) Not Equal that(%v)", this.Drops, that1.Drops)
	}
	if this.Overlimits != nil && that1.Overlimits != nil {
		if *this.Overlimits != *that1.Overlimits {
			return fmt.Errorf("Overlimits this(%v) Not Equal that(%v)", *this.Overlimits, *that1.Overlimits)
		}
	} else if this.Overlimits != nil {
		return fmt.Errorf("this.Overlimits == nil && that.Overlimits != nil")
	} else if that1.Overlimits != nil {
		return fmt.Errorf("Overlimits this(%v) Not Equal that(%v)", this.Overlimits, that1.Overlimits)
	}
	if this.Packets != nil && that1.Packets != nil {
		if *this.Packets != *that1.Packets {
			return fmt.Errorf("Packets this(%v) Not Equal that(%v)", *this.Packets, *that1.Packets)
		}
	} else if this.Packets != nil {
		return fmt.Errorf("this.Packets == nil && that.Packets != nil")
	} else if that1.Packets != nil {
		return fmt.Errorf("Packets this(%v) Not Equal that(%v)", this.Packets, that1.Packets)
	}
	if this.Qlen != nil && that1.Qlen != nil {
		if *this.Qlen != *that1.Qlen {
			return fmt.Errorf("Qlen this(%v) Not Equal that(%v)", *this.Qlen, *that1.Qlen)
		}
	} else if this.Qlen != nil {
		return fmt.Errorf("this.Qlen == nil && that.Qlen != nil")
	} else if that1.Qlen != nil {
		return fmt.Errorf("Qlen this(%v) Not Equal that(%v)", this.Qlen, that1.Qlen)
	}
	if this.RateBPS != nil && that1.RateBPS != nil {
		if *this.RateBPS != *that1.RateBPS {
			return fmt.Errorf("RateBPS this(%v) Not Equal that(%v)", *this.RateBPS, *that1.RateBPS)
		}
	} else if this.RateBPS != nil {
		return fmt.Errorf("this.RateBPS == nil && that.RateBPS != nil")
	} else if that1.RateBPS != nil {
		return fmt.Errorf("RateBPS this(%v) Not Equal that(%v)", this.RateBPS, that1.RateBPS)
	}
	if this.RatePPS != nil && that1.RatePPS != nil {
		if *this.RatePPS != *that1.RatePPS {
			return fmt.Errorf("RatePPS this(%v) Not Equal that(%v)", *this.RatePPS, *that1.RatePPS)
		}
	} else if this.RatePPS != nil {
		return fmt.Errorf("this.RatePPS == nil && that.RatePPS != nil")
	} else if that1.RatePPS != nil {
		return fmt.Errorf("RatePPS this(%v) Not Equal that(%v)", this.RatePPS, that1.RatePPS)
	}
	if this.Requeues != nil && that1.Requeues != nil {
		if *this.Requeues != *that1.Requeues {
			return fmt.Errorf("Requeues this(%v) Not Equal that(%v)", *this.Requeues, *that1.Requeues)
		}
	} else if this.Requeues != nil {
		return fmt.Errorf("this.Requeues == nil && that.Requeues != nil")
	} else if that1.Requeues != nil {
		return fmt.Errorf("Requeues this(%v) Not Equal that(%v)", this.Requeues, that1.Requeues)
	}
	return nil
}
func (this *TrafficControlStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TrafficControlStatistics)
	if !ok {
		that2, ok := that.(TrafficControlStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ID != that1.ID {
		return false
	}
	if this.Backlog != nil && that1.Backlog != nil {
		if *this.Backlog != *that1.Backlog {
			return false
		}
	} else if this.Backlog != nil {
		return false
	} else if that1.Backlog != nil {
		return false
	}
	if this.Bytes != nil && that1.Bytes != nil {
		if *this.Bytes != *that1.Bytes {
			return false
		}
	} else if this.Bytes != nil {
		return false
	} else if that1.Bytes != nil {
		return false
	}
	if this.Drops != nil && that1.Drops != nil {
		if *this.Drops != *that1.Drops {
			return false
		}
	} else if this.Drops != nil {
		return false
	} else if that1.Drops != nil {
		return false
	}
	if this.Overlimits != nil && that1.Overlimits != nil {
		if *this.Overlimits != *that1.Overlimits {
			return false
		}
	} else if this.Overlimits != nil {
		return false
	} else if that1.Overlimits != nil {
		return false
	}
	if this.Packets != nil && that1.Packets != nil {
		if *this.Packets != *that1.Packets {
			return false
		}
	} else if this.Packets != nil {
		return false
	} else if that1.Packets != nil {
		return false
	}
	if this.Qlen != nil && that1.Qlen != nil {
		if *this.Qlen != *that1.Qlen {
			return false
		}
	} else if this.Qlen != nil {
		return false
	} else if that1.Qlen != nil {
		return false
	}
	if this.RateBPS != nil && that1.RateBPS != nil {
		if *this.RateBPS != *that1.RateBPS {
			return false
		}
	} else if this.RateBPS != nil {
		return false
	} else if that1.RateBPS != nil {
		return false
	}
	if this.RatePPS != nil && that1.RatePPS != nil {
		if *this.RatePPS != *that1.RatePPS {
			return false
		}
	} else if this.RatePPS != nil {
		return false
	} else if that1.RatePPS != nil {
		return false
	}
	if this.Requeues != nil && that1.Requeues != nil {
		if *this.Requeues != *that1.Requeues {
			return false
		}
	} else if this.Requeues != nil {
		return false
	} else if that1.Requeues != nil {
		return false
	}
	return true
}
func (this *IpStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*IpStatistics)
	if !ok {
		that2, ok := that.(IpStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *IpStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *IpStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *IpStatistics but is not nil && this == nil")
	}
	if this.Forwarding != nil && that1.Forwarding != nil {
		if *this.Forwarding != *that1.Forwarding {
			return fmt.Errorf("Forwarding this(%v) Not Equal that(%v)", *this.Forwarding, *that1.Forwarding)
		}
	} else if this.Forwarding != nil {
		return fmt.Errorf("this.Forwarding == nil && that.Forwarding != nil")
	} else if that1.Forwarding != nil {
		return fmt.Errorf("Forwarding this(%v) Not Equal that(%v)", this.Forwarding, that1.Forwarding)
	}
	if this.DefaultTTL != nil && that1.DefaultTTL != nil {
		if *this.DefaultTTL != *that1.DefaultTTL {
			return fmt.Errorf("DefaultTTL this(%v) Not Equal that(%v)", *this.DefaultTTL, *that1.DefaultTTL)
		}
	} else if this.DefaultTTL != nil {
		return fmt.Errorf("this.DefaultTTL == nil && that.DefaultTTL != nil")
	} else if that1.DefaultTTL != nil {
		return fmt.Errorf("DefaultTTL this(%v) Not Equal that(%v)", this.DefaultTTL, that1.DefaultTTL)
	}
	if this.InReceives != nil && that1.InReceives != nil {
		if *this.InReceives != *that1.InReceives {
			return fmt.Errorf("InReceives this(%v) Not Equal that(%v)", *this.InReceives, *that1.InReceives)
		}
	} else if this.InReceives != nil {
		return fmt.Errorf("this.InReceives == nil && that.InReceives != nil")
	} else if that1.InReceives != nil {
		return fmt.Errorf("InReceives this(%v) Not Equal that(%v)", this.InReceives, that1.InReceives)
	}
	if this.InHdrErrors != nil && that1.InHdrErrors != nil {
		if *this.InHdrErrors != *that1.InHdrErrors {
			return fmt.Errorf("InHdrErrors this(%v) Not Equal that(%v)", *this.InHdrErrors, *that1.InHdrErrors)
		}
	} else if this.InHdrErrors != nil {
		return fmt.Errorf("this.InHdrErrors == nil && that.InHdrErrors != nil")
	} else if that1.InHdrErrors != nil {
		return fmt.Errorf("InHdrErrors this(%v) Not Equal that(%v)", this.InHdrErrors, that1.InHdrErrors)
	}
	if this.InAddrErrors != nil && that1.InAddrErrors != nil {
		if *this.InAddrErrors != *that1.InAddrErrors {
			return fmt.Errorf("InAddrErrors this(%v) Not Equal that(%v)", *this.InAddrErrors, *that1.InAddrErrors)
		}
	} else if this.InAddrErrors != nil {
		return fmt.Errorf("this.InAddrErrors == nil && that.InAddrErrors != nil")
	} else if that1.InAddrErrors != nil {
		return fmt.Errorf("InAddrErrors this(%v) Not Equal that(%v)", this.InAddrErrors, that1.InAddrErrors)
	}
	if this.ForwDatagrams != nil && that1.ForwDatagrams != nil {
		if *this.ForwDatagrams != *that1.ForwDatagrams {
			return fmt.Errorf("ForwDatagrams this(%v) Not Equal that(%v)", *this.ForwDatagrams, *that1.ForwDatagrams)
		}
	} else if this.ForwDatagrams != nil {
		return fmt.Errorf("this.ForwDatagrams == nil && that.ForwDatagrams != nil")
	} else if that1.ForwDatagrams != nil {
		return fmt.Errorf("ForwDatagrams this(%v) Not Equal that(%v)", this.ForwDatagrams, that1.ForwDatagrams)
	}
	if this.InUnknownProtos != nil && that1.InUnknownProtos != nil {
		if *this.InUnknownProtos != *that1.InUnknownProtos {
			return fmt.Errorf("InUnknownProtos this(%v) Not Equal that(%v)", *this.InUnknownProtos, *that1.InUnknownProtos)
		}
	} else if this.InUnknownProtos != nil {
		return fmt.Errorf("this.InUnknownProtos == nil && that.InUnknownProtos != nil")
	} else if that1.InUnknownProtos != nil {
		return fmt.Errorf("InUnknownProtos this(%v) Not Equal that(%v)", this.InUnknownProtos, that1.InUnknownProtos)
	}
	if this.InDiscards != nil && that1.InDiscards != nil {
		if *this.InDiscards != *that1.InDiscards {
			return fmt.Errorf("InDiscards this(%v) Not Equal that(%v)", *this.InDiscards, *that1.InDiscards)
		}
	} else if this.InDiscards != nil {
		return fmt.Errorf("this.InDiscards == nil && that.InDiscards != nil")
	} else if that1.InDiscards != nil {
		return fmt.Errorf("InDiscards this(%v) Not Equal that(%v)", this.InDiscards, that1.InDiscards)
	}
	if this.InDelivers != nil && that1.InDelivers != nil {
		if *this.InDelivers != *that1.InDelivers {
			return fmt.Errorf("InDelivers this(%v) Not Equal that(%v)", *this.InDelivers, *that1.InDelivers)
		}
	} else if this.InDelivers != nil {
		return fmt.Errorf("this.InDelivers == nil && that.InDelivers != nil")
	} else if that1.InDelivers != nil {
		return fmt.Errorf("InDelivers this(%v) Not Equal that(%v)", this.InDelivers, that1.InDelivers)
	}
	if this.OutRequests != nil && that1.OutRequests != nil {
		if *this.OutRequests != *that1.OutRequests {
			return fmt.Errorf("OutRequests this(%v) Not Equal that(%v)", *this.OutRequests, *that1.OutRequests)
		}
	} else if this.OutRequests != nil {
		return fmt.Errorf("this.OutRequests == nil && that.OutRequests != nil")
	} else if that1.OutRequests != nil {
		return fmt.Errorf("OutRequests this(%v) Not Equal that(%v)", this.OutRequests, that1.OutRequests)
	}
	if this.OutDiscards != nil && that1.OutDiscards != nil {
		if *this.OutDiscards != *that1.OutDiscards {
			return fmt.Errorf("OutDiscards this(%v) Not Equal that(%v)", *this.OutDiscards, *that1.OutDiscards)
		}
	} else if this.OutDiscards != nil {
		return fmt.Errorf("this.OutDiscards == nil && that.OutDiscards != nil")
	} else if that1.OutDiscards != nil {
		return fmt.Errorf("OutDiscards this(%v) Not Equal that(%v)", this.OutDiscards, that1.OutDiscards)
	}
	if this.OutNoRoutes != nil && that1.OutNoRoutes != nil {
		if *this.OutNoRoutes != *that1.OutNoRoutes {
			return fmt.Errorf("OutNoRoutes this(%v) Not Equal that(%v)", *this.OutNoRoutes, *that1.OutNoRoutes)
		}
	} else if this.OutNoRoutes != nil {
		return fmt.Errorf("this.OutNoRoutes == nil && that.OutNoRoutes != nil")
	} else if that1.OutNoRoutes != nil {
		return fmt.Errorf("OutNoRoutes this(%v) Not Equal that(%v)", this.OutNoRoutes, that1.OutNoRoutes)
	}
	if this.ReasmTimeout != nil && that1.ReasmTimeout != nil {
		if *this.ReasmTimeout != *that1.ReasmTimeout {
			return fmt.Errorf("ReasmTimeout this(%v) Not Equal that(%v)", *this.ReasmTimeout, *that1.ReasmTimeout)
		}
	} else if this.ReasmTimeout != nil {
		return fmt.Errorf("this.ReasmTimeout == nil && that.ReasmTimeout != nil")
	} else if that1.ReasmTimeout != nil {
		return fmt.Errorf("ReasmTimeout this(%v) Not Equal that(%v)", this.ReasmTimeout, that1.ReasmTimeout)
	}
	if this.ReasmReqds != nil && that1.ReasmReqds != nil {
		if *this.ReasmReqds != *that1.ReasmReqds {
			return fmt.Errorf("ReasmReqds this(%v) Not Equal that(%v)", *this.ReasmReqds, *that1.ReasmReqds)
		}
	} else if this.ReasmReqds != nil {
		return fmt.Errorf("this.ReasmReqds == nil && that.ReasmReqds != nil")
	} else if that1.ReasmReqds != nil {
		return fmt.Errorf("ReasmReqds this(%v) Not Equal that(%v)", this.ReasmReqds, that1.ReasmReqds)
	}
	if this.ReasmOKs != nil && that1.ReasmOKs != nil {
		if *this.ReasmOKs != *that1.ReasmOKs {
			return fmt.Errorf("ReasmOKs this(%v) Not Equal that(%v)", *this.ReasmOKs, *that1.ReasmOKs)
		}
	} else if this.ReasmOKs != nil {
		return fmt.Errorf("this.ReasmOKs == nil && that.ReasmOKs != nil")
	} else if that1.ReasmOKs != nil {
		return fmt.Errorf("ReasmOKs this(%v) Not Equal that(%v)", this.ReasmOKs, that1.ReasmOKs)
	}
	if this.ReasmFails != nil && that1.ReasmFails != nil {
		if *this.ReasmFails != *that1.ReasmFails {
			return fmt.Errorf("ReasmFails this(%v) Not Equal that(%v)", *this.ReasmFails, *that1.ReasmFails)
		}
	} else if this.ReasmFails != nil {
		return fmt.Errorf("this.ReasmFails == nil && that.ReasmFails != nil")
	} else if that1.ReasmFails != nil {
		return fmt.Errorf("ReasmFails this(%v) Not Equal that(%v)", this.ReasmFails, that1.ReasmFails)
	}
	if this.FragOKs != nil && that1.FragOKs != nil {
		if *this.FragOKs != *that1.FragOKs {
			return fmt.Errorf("FragOKs this(%v) Not Equal that(%v)", *this.FragOKs, *that1.FragOKs)
		}
	} else if this.FragOKs != nil {
		return fmt.Errorf("this.FragOKs == nil && that.FragOKs != nil")
	} else if that1.FragOKs != nil {
		return fmt.Errorf("FragOKs this(%v) Not Equal that(%v)", this.FragOKs, that1.FragOKs)
	}
	if this.FragFails != nil && that1.FragFails != nil {
		if *this.FragFails != *that1.FragFails {
			return fmt.Errorf("FragFails this(%v) Not Equal that(%v)", *this.FragFails, *that1.FragFails)
		}
	} else if this.FragFails != nil {
		return fmt.Errorf("this.FragFails == nil && that.FragFails != nil")
	} else if that1.FragFails != nil {
		return fmt.Errorf("FragFails this(%v) Not Equal that(%v)", this.FragFails, that1.FragFails)
	}
	if this.FragCreates != nil && that1.FragCreates != nil {
		if *this.FragCreates != *that1.FragCreates {
			return fmt.Errorf("FragCreates this(%v) Not Equal that(%v)", *this.FragCreates, *that1.FragCreates)
		}
	} else if this.FragCreates != nil {
		return fmt.Errorf("this.FragCreates == nil && that.FragCreates != nil")
	} else if that1.FragCreates != nil {
		return fmt.Errorf("FragCreates this(%v) Not Equal that(%v)", this.FragCreates, that1.FragCreates)
	}
	return nil
}
func (this *IpStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*IpStatistics)
	if !ok {
		that2, ok := that.(IpStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Forwarding != nil && that1.Forwarding != nil {
		if *this.Forwarding != *that1.Forwarding {
			return false
		}
	} else if this.Forwarding != nil {
		return false
	} else if that1.Forwarding != nil {
		return false
	}
	if this.DefaultTTL != nil && that1.DefaultTTL != nil {
		if *this.DefaultTTL != *that1.DefaultTTL {
			return false
		}
	} else if this.DefaultTTL != nil {
		return false
	} else if that1.DefaultTTL != nil {
		return false
	}
	if this.InReceives != nil && that1.InReceives != nil {
		if *this.InReceives != *that1.InReceives {
			return false
		}
	} else if this.InReceives != nil {
		return false
	} else if that1.InReceives != nil {
		return false
	}
	if this.InHdrErrors != nil && that1.InHdrErrors != nil {
		if *this.InHdrErrors != *that1.InHdrErrors {
			return false
		}
	} else if this.InHdrErrors != nil {
		return false
	} else if that1.InHdrErrors != nil {
		return false
	}
	if this.InAddrErrors != nil && that1.InAddrErrors != nil {
		if *this.InAddrErrors != *that1.InAddrErrors {
			return false
		}
	} else if this.InAddrErrors != nil {
		return false
	} else if that1.InAddrErrors != nil {
		return false
	}
	if this.ForwDatagrams != nil && that1.ForwDatagrams != nil {
		if *this.ForwDatagrams != *that1.ForwDatagrams {
			return false
		}
	} else if this.ForwDatagrams != nil {
		return false
	} else if that1.ForwDatagrams != nil {
		return false
	}
	if this.InUnknownProtos != nil && that1.InUnknownProtos != nil {
		if *this.InUnknownProtos != *that1.InUnknownProtos {
			return false
		}
	} else if this.InUnknownProtos != nil {
		return false
	} else if that1.InUnknownProtos != nil {
		return false
	}
	if this.InDiscards != nil && that1.InDiscards != nil {
		if *this.InDiscards != *that1.InDiscards {
			return false
		}
	} else if this.InDiscards != nil {
		return false
	} else if that1.InDiscards != nil {
		return false
	}
	if this.InDelivers != nil && that1.InDelivers != nil {
		if *this.InDelivers != *that1.InDelivers {
			return false
		}
	} else if this.InDelivers != nil {
		return false
	} else if that1.InDelivers != nil {
		return false
	}
	if this.OutRequests != nil && that1.OutRequests != nil {
		if *this.OutRequests != *that1.OutRequests {
			return false
		}
	} else if this.OutRequests != nil {
		return false
	} else if that1.OutRequests != nil {
		return false
	}
	if this.OutDiscards != nil && that1.OutDiscards != nil {
		if *this.OutDiscards != *that1.OutDiscards {
			return false
		}
	} else if this.OutDiscards != nil {
		return false
	} else if that1.OutDiscards != nil {
		return false
	}
	if this.OutNoRoutes != nil && that1.OutNoRoutes != nil {
		if *this.OutNoRoutes != *that1.OutNoRoutes {
			return false
		}
	} else if this.OutNoRoutes != nil {
		return false
	} else if that1.OutNoRoutes != nil {
		return false
	}
	if this.ReasmTimeout != nil && that1.ReasmTimeout != nil {
		if *this.ReasmTimeout != *that1.ReasmTimeout {
			return false
		}
	} else if this.ReasmTimeout != nil {
		return false
	} else if that1.ReasmTimeout != nil {
		return false
	}
	if this.ReasmReqds != nil && that1.ReasmReqds != nil {
		if *this.ReasmReqds != *that1.ReasmReqds {
			return false
		}
	} else if this.ReasmReqds != nil {
		return false
	} else if that1.ReasmReqds != nil {
		return false
	}
	if this.ReasmOKs != nil && that1.ReasmOKs != nil {
		if *this.ReasmOKs != *that1.ReasmOKs {
			return false
		}
	} else if this.ReasmOKs != nil {
		return false
	} else if that1.ReasmOKs != nil {
		return false
	}
	if this.ReasmFails != nil && that1.ReasmFails != nil {
		if *this.ReasmFails != *that1.ReasmFails {
			return false
		}
	} else if this.ReasmFails != nil {
		return false
	} else if that1.ReasmFails != nil {
		return false
	}
	if this.FragOKs != nil && that1.FragOKs != nil {
		if *this.FragOKs != *that1.FragOKs {
			return false
		}
	} else if this.FragOKs != nil {
		return false
	} else if that1.FragOKs != nil {
		return false
	}
	if this.FragFails != nil && that1.FragFails != nil {
		if *this.FragFails != *that1.FragFails {
			return false
		}
	} else if this.FragFails != nil {
		return false
	} else if that1.FragFails != nil {
		return false
	}
	if this.FragCreates != nil && that1.FragCreates != nil {
		if *this.FragCreates != *that1.FragCreates {
			return false
		}
	} else if this.FragCreates != nil {
		return false
	} else if that1.FragCreates != nil {
		return false
	}
	return true
}
func (this *IcmpStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*IcmpStatistics)
	if !ok {
		that2, ok := that.(IcmpStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *IcmpStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *IcmpStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *IcmpStatistics but is not nil && this == nil")
	}
	if this.InMsgs != nil && that1.InMsgs != nil {
		if *this.InMsgs != *that1.InMsgs {
			return fmt.Errorf("InMsgs this(%v) Not Equal that(%v)", *this.InMsgs, *that1.InMsgs)
		}
	} else if this.InMsgs != nil {
		return fmt.Errorf("this.InMsgs == nil && that.InMsgs != nil")
	} else if that1.InMsgs != nil {
		return fmt.Errorf("InMsgs this(%v) Not Equal that(%v)", this.InMsgs, that1.InMsgs)
	}
	if this.InErrors != nil && that1.InErrors != nil {
		if *this.InErrors != *that1.InErrors {
			return fmt.Errorf("InErrors this(%v) Not Equal that(%v)", *this.InErrors, *that1.InErrors)
		}
	} else if this.InErrors != nil {
		return fmt.Errorf("this.InErrors == nil && that.InErrors != nil")
	} else if that1.InErrors != nil {
		return fmt.Errorf("InErrors this(%v) Not Equal that(%v)", this.InErrors, that1.InErrors)
	}
	if this.InCsumErrors != nil && that1.InCsumErrors != nil {
		if *this.InCsumErrors != *that1.InCsumErrors {
			return fmt.Errorf("InCsumErrors this(%v) Not Equal that(%v)", *this.InCsumErrors, *that1.InCsumErrors)
		}
	} else if this.InCsumErrors != nil {
		return fmt.Errorf("this.InCsumErrors == nil && that.InCsumErrors != nil")
	} else if that1.InCsumErrors != nil {
		return fmt.Errorf("InCsumErrors this(%v) Not Equal that(%v)", this.InCsumErrors, that1.InCsumErrors)
	}
	if this.InDestUnreachs != nil && that1.InDestUnreachs != nil {
		if *this.InDestUnreachs != *that1.InDestUnreachs {
			return fmt.Errorf("InDestUnreachs this(%v) Not Equal that(%v)", *this.InDestUnreachs, *that1.InDestUnreachs)
		}
	} else if this.InDestUnreachs != nil {
		return fmt.Errorf("this.InDestUnreachs == nil && that.InDestUnreachs != nil")
	} else if that1.InDestUnreachs != nil {
		return fmt.Errorf("InDestUnreachs this(%v) Not Equal that(%v)", this.InDestUnreachs, that1.InDestUnreachs)
	}
	if this.InTimeExcds != nil && that1.InTimeExcds != nil {
		if *this.InTimeExcds != *that1.InTimeExcds {
			return fmt.Errorf("InTimeExcds this(%v) Not Equal that(%v)", *this.InTimeExcds, *that1.InTimeExcds)
		}
	} else if this.InTimeExcds != nil {
		return fmt.Errorf("this.InTimeExcds == nil && that.InTimeExcds != nil")
	} else if that1.InTimeExcds != nil {
		return fmt.Errorf("InTimeExcds this(%v) Not Equal that(%v)", this.InTimeExcds, that1.InTimeExcds)
	}
	if this.InParmProbs != nil && that1.InParmProbs != nil {
		if *this.InParmProbs != *that1.InParmProbs {
			return fmt.Errorf("InParmProbs this(%v) Not Equal that(%v)", *this.InParmProbs, *that1.InParmProbs)
		}
	} else if this.InParmProbs != nil {
		return fmt.Errorf("this.InParmProbs == nil && that.InParmProbs != nil")
	} else if that1.InParmProbs != nil {
		return fmt.Errorf("InParmProbs this(%v) Not Equal that(%v)", this.InParmProbs, that1.InParmProbs)
	}
	if this.InSrcQuenchs != nil && that1.InSrcQuenchs != nil {
		if *this.InSrcQuenchs != *that1.InSrcQuenchs {
			return fmt.Errorf("InSrcQuenchs this(%v) Not Equal that(%v)", *this.InSrcQuenchs, *that1.InSrcQuenchs)
		}
	} else if this.InSrcQuenchs != nil {
		return fmt.Errorf("this.InSrcQuenchs == nil && that.InSrcQuenchs != nil")
	} else if that1.InSrcQuenchs != nil {
		return fmt.Errorf("InSrcQuenchs this(%v) Not Equal that(%v)", this.InSrcQuenchs, that1.InSrcQuenchs)
	}
	if this.InRedirects != nil && that1.InRedirects != nil {
		if *this.InRedirects != *that1.InRedirects {
			return fmt.Errorf("InRedirects this(%v) Not Equal that(%v)", *this.InRedirects, *that1.InRedirects)
		}
	} else if this.InRedirects != nil {
		return fmt.Errorf("this.InRedirects == nil && that.InRedirects != nil")
	} else if that1.InRedirects != nil {
		return fmt.Errorf("InRedirects this(%v) Not Equal that(%v)", this.InRedirects, that1.InRedirects)
	}
	if this.InEchos != nil && that1.InEchos != nil {
		if *this.InEchos != *that1.InEchos {
			return fmt.Errorf("InEchos this(%v) Not Equal that(%v)", *this.InEchos, *that1.InEchos)
		}
	} else if this.InEchos != nil {
		return fmt.Errorf("this.InEchos == nil && that.InEchos != nil")
	} else if that1.InEchos != nil {
		return fmt.Errorf("InEchos this(%v) Not Equal that(%v)", this.InEchos, that1.InEchos)
	}
	if this.InEchoReps != nil && that1.InEchoReps != nil {
		if *this.InEchoReps != *that1.InEchoReps {
			return fmt.Errorf("InEchoReps this(%v) Not Equal that(%v)", *this.InEchoReps, *that1.InEchoReps)
		}
	} else if this.InEchoReps != nil {
		return fmt.Errorf("this.InEchoReps == nil && that.InEchoReps != nil")
	} else if that1.InEchoReps != nil {
		return fmt.Errorf("InEchoReps this(%v) Not Equal that(%v)", this.InEchoReps, that1.InEchoReps)
	}
	if this.InTimestamps != nil && that1.InTimestamps != nil {
		if *this.InTimestamps != *that1.InTimestamps {
			return fmt.Errorf("InTimestamps this(%v) Not Equal that(%v)", *this.InTimestamps, *that1.InTimestamps)
		}
	} else if this.InTimestamps != nil {
		return fmt.Errorf("this.InTimestamps == nil && that.InTimestamps != nil")
	} else if that1.InTimestamps != nil {
		return fmt.Errorf("InTimestamps this(%v) Not Equal that(%v)", this.InTimestamps, that1.InTimestamps)
	}
	if this.InTimestampReps != nil && that1.InTimestampReps != nil {
		if *this.InTimestampReps != *that1.InTimestampReps {
			return fmt.Errorf("InTimestampReps this(%v) Not Equal that(%v)", *this.InTimestampReps, *that1.InTimestampReps)
		}
	} else if this.InTimestampReps != nil {
		return fmt.Errorf("this.InTimestampReps == nil && that.InTimestampReps != nil")
	} else if that1.InTimestampReps != nil {
		return fmt.Errorf("InTimestampReps this(%v) Not Equal that(%v)", this.InTimestampReps, that1.InTimestampReps)
	}
	if this.InAddrMasks != nil && that1.InAddrMasks != nil {
		if *this.InAddrMasks != *that1.InAddrMasks {
			return fmt.Errorf("InAddrMasks this(%v) Not Equal that(%v)", *this.InAddrMasks, *that1.InAddrMasks)
		}
	} else if this.InAddrMasks != nil {
		return fmt.Errorf("this.InAddrMasks == nil && that.InAddrMasks != nil")
	} else if that1.InAddrMasks != nil {
		return fmt.Errorf("InAddrMasks this(%v) Not Equal that(%v)", this.InAddrMasks, that1.InAddrMasks)
	}
	if this.InAddrMaskReps != nil && that1.InAddrMaskReps != nil {
		if *this.InAddrMaskReps != *that1.InAddrMaskReps {
			return fmt.Errorf("InAddrMaskReps this(%v) Not Equal that(%v)", *this.InAddrMaskReps, *that1.InAddrMaskReps)
		}
	} else if this.InAddrMaskReps != nil {
		return fmt.Errorf("this.InAddrMaskReps == nil && that.InAddrMaskReps != nil")
	} else if that1.InAddrMaskReps != nil {
		return fmt.Errorf("InAddrMaskReps this(%v) Not Equal that(%v)", this.InAddrMaskReps, that1.InAddrMaskReps)
	}
	if this.OutMsgs != nil && that1.OutMsgs != nil {
		if *this.OutMsgs != *that1.OutMsgs {
			return fmt.Errorf("OutMsgs this(%v) Not Equal that(%v)", *this.OutMsgs, *that1.OutMsgs)
		}
	} else if this.OutMsgs != nil {
		return fmt.Errorf("this.OutMsgs == nil && that.OutMsgs != nil")
	} else if that1.OutMsgs != nil {
		return fmt.Errorf("OutMsgs this(%v) Not Equal that(%v)", this.OutMsgs, that1.OutMsgs)
	}
	if this.OutErrors != nil && that1.OutErrors != nil {
		if *this.OutErrors != *that1.OutErrors {
			return fmt.Errorf("OutErrors this(%v) Not Equal that(%v)", *this.OutErrors, *that1.OutErrors)
		}
	} else if this.OutErrors != nil {
		return fmt.Errorf("this.OutErrors == nil && that.OutErrors != nil")
	} else if that1.OutErrors != nil {
		return fmt.Errorf("OutErrors this(%v) Not Equal that(%v)", this.OutErrors, that1.OutErrors)
	}
	if this.OutDestUnreachs != nil && that1.OutDestUnreachs != nil {
		if *this.OutDestUnreachs != *that1.OutDestUnreachs {
			return fmt.Errorf("OutDestUnreachs this(%v) Not Equal that(%v)", *this.OutDestUnreachs, *that1.OutDestUnreachs)
		}
	} else if this.OutDestUnreachs != nil {
		return fmt.Errorf("this.OutDestUnreachs == nil && that.OutDestUnreachs != nil")
	} else if that1.OutDestUnreachs != nil {
		return fmt.Errorf("OutDestUnreachs this(%v) Not Equal that(%v)", this.OutDestUnreachs, that1.OutDestUnreachs)
	}
	if this.OutTimeExcds != nil && that1.OutTimeExcds != nil {
		if *this.OutTimeExcds != *that1.OutTimeExcds {
			return fmt.Errorf("OutTimeExcds this(%v) Not Equal that(%v)", *this.OutTimeExcds, *that1.OutTimeExcds)
		}
	} else if this.OutTimeExcds != nil {
		return fmt.Errorf("this.OutTimeExcds == nil && that.OutTimeExcds != nil")
	} else if that1.OutTimeExcds != nil {
		return fmt.Errorf("OutTimeExcds this(%v) Not Equal that(%v)", this.OutTimeExcds, that1.OutTimeExcds)
	}
	if this.OutParmProbs != nil && that1.OutParmProbs != nil {
		if *this.OutParmProbs != *that1.OutParmProbs {
			return fmt.Errorf("OutParmProbs this(%v) Not Equal that(%v)", *this.OutParmProbs, *that1.OutParmProbs)
		}
	} else if this.OutParmProbs != nil {
		return fmt.Errorf("this.OutParmProbs == nil && that.OutParmProbs != nil")
	} else if that1.OutParmProbs != nil {
		return fmt.Errorf("OutParmProbs this(%v) Not Equal that(%v)", this.OutParmProbs, that1.OutParmProbs)
	}
	if this.OutSrcQuenchs != nil && that1.OutSrcQuenchs != nil {
		if *this.OutSrcQuenchs != *that1.OutSrcQuenchs {
			return fmt.Errorf("OutSrcQuenchs this(%v) Not Equal that(%v)", *this.OutSrcQuenchs, *that1.OutSrcQuenchs)
		}
	} else if this.OutSrcQuenchs != nil {
		return fmt.Errorf("this.OutSrcQuenchs == nil && that.OutSrcQuenchs != nil")
	} else if that1.OutSrcQuenchs != nil {
		return fmt.Errorf("OutSrcQuenchs this(%v) Not Equal that(%v)", this.OutSrcQuenchs, that1.OutSrcQuenchs)
	}
	if this.OutRedirects != nil && that1.OutRedirects != nil {
		if *this.OutRedirects != *that1.OutRedirects {
			return fmt.Errorf("OutRedirects this(%v) Not Equal that(%v)", *this.OutRedirects, *that1.OutRedirects)
		}
	} else if this.OutRedirects != nil {
		return fmt.Errorf("this.OutRedirects == nil && that.OutRedirects != nil")
	} else if that1.OutRedirects != nil {
		return fmt.Errorf("OutRedirects this(%v) Not Equal that(%v)", this.OutRedirects, that1.OutRedirects)
	}
	if this.OutEchos != nil && that1.OutEchos != nil {
		if *this.OutEchos != *that1.OutEchos {
			return fmt.Errorf("OutEchos this(%v) Not Equal that(%v)", *this.OutEchos, *that1.OutEchos)
		}
	} else if this.OutEchos != nil {
		return fmt.Errorf("this.OutEchos == nil && that.OutEchos != nil")
	} else if that1.OutEchos != nil {
		return fmt.Errorf("OutEchos this(%v) Not Equal that(%v)", this.OutEchos, that1.OutEchos)
	}
	if this.OutEchoReps != nil && that1.OutEchoReps != nil {
		if *this.OutEchoReps != *that1.OutEchoReps {
			return fmt.Errorf("OutEchoReps this(%v) Not Equal that(%v)", *this.OutEchoReps, *that1.OutEchoReps)
		}
	} else if this.OutEchoReps != nil {
		return fmt.Errorf("this.OutEchoReps == nil && that.OutEchoReps != nil")
	} else if that1.OutEchoReps != nil {
		return fmt.Errorf("OutEchoReps this(%v) Not Equal that(%v)", this.OutEchoReps, that1.OutEchoReps)
	}
	if this.OutTimestamps != nil && that1.OutTimestamps != nil {
		if *this.OutTimestamps != *that1.OutTimestamps {
			return fmt.Errorf("OutTimestamps this(%v) Not Equal that(%v)", *this.OutTimestamps, *that1.OutTimestamps)
		}
	} else if this.OutTimestamps != nil {
		return fmt.Errorf("this.OutTimestamps == nil && that.OutTimestamps != nil")
	} else if that1.OutTimestamps != nil {
		return fmt.Errorf("OutTimestamps this(%v) Not Equal that(%v)", this.OutTimestamps, that1.OutTimestamps)
	}
	if this.OutTimestampReps != nil && that1.OutTimestampReps != nil {
		if *this.OutTimestampReps != *that1.OutTimestampReps {
			return fmt.Errorf("OutTimestampReps this(%v) Not Equal that(%v)", *this.OutTimestampReps, *that1.OutTimestampReps)
		}
	} else if this.OutTimestampReps != nil {
		return fmt.Errorf("this.OutTimestampReps == nil && that.OutTimestampReps != nil")
	} else if that1.OutTimestampReps != nil {
		return fmt.Errorf("OutTimestampReps this(%v) Not Equal that(%v)", this.OutTimestampReps, that1.OutTimestampReps)
	}
	if this.OutAddrMasks != nil && that1.OutAddrMasks != nil {
		if *this.OutAddrMasks != *that1.OutAddrMasks {
			return fmt.Errorf("OutAddrMasks this(%v) Not Equal that(%v)", *this.OutAddrMasks, *that1.OutAddrMasks)
		}
	} else if this.OutAddrMasks != nil {
		return fmt.Errorf("this.OutAddrMasks == nil && that.OutAddrMasks != nil")
	} else if that1.OutAddrMasks != nil {
		return fmt.Errorf("OutAddrMasks this(%v) Not Equal that(%v)", this.OutAddrMasks, that1.OutAddrMasks)
	}
	if this.OutAddrMaskReps != nil && that1.OutAddrMaskReps != nil {
		if *this.OutAddrMaskReps != *that1.OutAddrMaskReps {
			return fmt.Errorf("OutAddrMaskReps this(%v) Not Equal that(%v)", *this.OutAddrMaskReps, *that1.OutAddrMaskReps)
		}
	} else if this.OutAddrMaskReps != nil {
		return fmt.Errorf("this.OutAddrMaskReps == nil && that.OutAddrMaskReps != nil")
	} else if that1.OutAddrMaskReps != nil {
		return fmt.Errorf("OutAddrMaskReps this(%v) Not Equal that(%v)", this.OutAddrMaskReps, that1.OutAddrMaskReps)
	}
	return nil
}
func (this *IcmpStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*IcmpStatistics)
	if !ok {
		that2, ok := that.(IcmpStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.InMsgs != nil && that1.InMsgs != nil {
		if *this.InMsgs != *that1.InMsgs {
			return false
		}
	} else if this.InMsgs != nil {
		return false
	} else if that1.InMsgs != nil {
		return false
	}
	if this.InErrors != nil && that1.InErrors != nil {
		if *this.InErrors != *that1.InErrors {
			return false
		}
	} else if this.InErrors != nil {
		return false
	} else if that1.InErrors != nil {
		return false
	}
	if this.InCsumErrors != nil && that1.InCsumErrors != nil {
		if *this.InCsumErrors != *that1.InCsumErrors {
			return false
		}
	} else if this.InCsumErrors != nil {
		return false
	} else if that1.InCsumErrors != nil {
		return false
	}
	if this.InDestUnreachs != nil && that1.InDestUnreachs != nil {
		if *this.InDestUnreachs != *that1.InDestUnreachs {
			return false
		}
	} else if this.InDestUnreachs != nil {
		return false
	} else if that1.InDestUnreachs != nil {
		return false
	}
	if this.InTimeExcds != nil && that1.InTimeExcds != nil {
		if *this.InTimeExcds != *that1.InTimeExcds {
			return false
		}
	} else if this.InTimeExcds != nil {
		return false
	} else if that1.InTimeExcds != nil {
		return false
	}
	if this.InParmProbs != nil && that1.InParmProbs != nil {
		if *this.InParmProbs != *that1.InParmProbs {
			return false
		}
	} else if this.InParmProbs != nil {
		return false
	} else if that1.InParmProbs != nil {
		return false
	}
	if this.InSrcQuenchs != nil && that1.InSrcQuenchs != nil {
		if *this.InSrcQuenchs != *that1.InSrcQuenchs {
			return false
		}
	} else if this.InSrcQuenchs != nil {
		return false
	} else if that1.InSrcQuenchs != nil {
		return false
	}
	if this.InRedirects != nil && that1.InRedirects != nil {
		if *this.InRedirects != *that1.InRedirects {
			return false
		}
	} else if this.InRedirects != nil {
		return false
	} else if that1.InRedirects != nil {
		return false
	}
	if this.InEchos != nil && that1.InEchos != nil {
		if *this.InEchos != *that1.InEchos {
			return false
		}
	} else if this.InEchos != nil {
		return false
	} else if that1.InEchos != nil {
		return false
	}
	if this.InEchoReps != nil && that1.InEchoReps != nil {
		if *this.InEchoReps != *that1.InEchoReps {
			return false
		}
	} else if this.InEchoReps != nil {
		return false
	} else if that1.InEchoReps != nil {
		return false
	}
	if this.InTimestamps != nil && that1.InTimestamps != nil {
		if *this.InTimestamps != *that1.InTimestamps {
			return false
		}
	} else if this.InTimestamps != nil {
		return false
	} else if that1.InTimestamps != nil {
		return false
	}
	if this.InTimestampReps != nil && that1.InTimestampReps != nil {
		if *this.InTimestampReps != *that1.InTimestampReps {
			return false
		}
	} else if this.InTimestampReps != nil {
		return false
	} else if that1.InTimestampReps != nil {
		return false
	}
	if this.InAddrMasks != nil && that1.InAddrMasks != nil {
		if *this.InAddrMasks != *that1.InAddrMasks {
			return false
		}
	} else if this.InAddrMasks != nil {
		return false
	} else if that1.InAddrMasks != nil {
		return false
	}
	if this.InAddrMaskReps != nil && that1.InAddrMaskReps != nil {
		if *this.InAddrMaskReps != *that1.InAddrMaskReps {
			return false
		}
	} else if this.InAddrMaskReps != nil {
		return false
	} else if that1.InAddrMaskReps != nil {
		return false
	}
	if this.OutMsgs != nil && that1.OutMsgs != nil {
		if *this.OutMsgs != *that1.OutMsgs {
			return false
		}
	} else if this.OutMsgs != nil {
		return false
	} else if that1.OutMsgs != nil {
		return false
	}
	if this.OutErrors != nil && that1.OutErrors != nil {
		if *this.OutErrors != *that1.OutErrors {
			return false
		}
	} else if this.OutErrors != nil {
		return false
	} else if that1.OutErrors != nil {
		return false
	}
	if this.OutDestUnreachs != nil && that1.OutDestUnreachs != nil {
		if *this.OutDestUnreachs != *that1.OutDestUnreachs {
			return false
		}
	} else if this.OutDestUnreachs != nil {
		return false
	} else if that1.OutDestUnreachs != nil {
		return false
	}
	if this.OutTimeExcds != nil && that1.OutTimeExcds != nil {
		if *this.OutTimeExcds != *that1.OutTimeExcds {
			return false
		}
	} else if this.OutTimeExcds != nil {
		return false
	} else if that1.OutTimeExcds != nil {
		return false
	}
	if this.OutParmProbs != nil && that1.OutParmProbs != nil {
		if *this.OutParmProbs != *that1.OutParmProbs {
			return false
		}
	} else if this.OutParmProbs != nil {
		return false
	} else if that1.OutParmProbs != nil {
		return false
	}
	if this.OutSrcQuenchs != nil && that1.OutSrcQuenchs != nil {
		if *this.OutSrcQuenchs != *that1.OutSrcQuenchs {
			return false
		}
	} else if this.OutSrcQuenchs != nil {
		return false
	} else if that1.OutSrcQuenchs != nil {
		return false
	}
	if this.OutRedirects != nil && that1.OutRedirects != nil {
		if *this.OutRedirects != *that1.OutRedirects {
			return false
		}
	} else if this.OutRedirects != nil {
		return false
	} else if that1.OutRedirects != nil {
		return false
	}
	if this.OutEchos != nil && that1.OutEchos != nil {
		if *this.OutEchos != *that1.OutEchos {
			return false
		}
	} else if this.OutEchos != nil {
		return false
	} else if that1.OutEchos != nil {
		return false
	}
	if this.OutEchoReps != nil && that1.OutEchoReps != nil {
		if *this.OutEchoReps != *that1.OutEchoReps {
			return false
		}
	} else if this.OutEchoReps != nil {
		return false
	} else if that1.OutEchoReps != nil {
		return false
	}
	if this.OutTimestamps != nil && that1.OutTimestamps != nil {
		if *this.OutTimestamps != *that1.OutTimestamps {
			return false
		}
	} else if this.OutTimestamps != nil {
		return false
	} else if that1.OutTimestamps != nil {
		return false
	}
	if this.OutTimestampReps != nil && that1.OutTimestampReps != nil {
		if *this.OutTimestampReps != *that1.OutTimestampReps {
			return false
		}
	} else if this.OutTimestampReps != nil {
		return false
	} else if that1.OutTimestampReps != nil {
		return false
	}
	if this.OutAddrMasks != nil && that1.OutAddrMasks != nil {
		if *this.OutAddrMasks != *that1.OutAddrMasks {
			return false
		}
	} else if this.OutAddrMasks != nil {
		return false
	} else if that1.OutAddrMasks != nil {
		return false
	}
	if this.OutAddrMaskReps != nil && that1.OutAddrMaskReps != nil {
		if *this.OutAddrMaskReps != *that1.OutAddrMaskReps {
			return false
		}
	} else if this.OutAddrMaskReps != nil {
		return false
	} else if that1.OutAddrMaskReps != nil {
		return false
	}
	return true
}
func (this *TcpStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TcpStatistics)
	if !ok {
		that2, ok := that.(TcpStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TcpStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TcpStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TcpStatistics but is not nil && this == nil")
	}
	if this.RtoAlgorithm != nil && that1.RtoAlgorithm != nil {
		if *this.RtoAlgorithm != *that1.RtoAlgorithm {
			return fmt.Errorf("RtoAlgorithm this(%v) Not Equal that(%v)", *this.RtoAlgorithm, *that1.RtoAlgorithm)
		}
	} else if this.RtoAlgorithm != nil {
		return fmt.Errorf("this.RtoAlgorithm == nil && that.RtoAlgorithm != nil")
	} else if that1.RtoAlgorithm != nil {
		return fmt.Errorf("RtoAlgorithm this(%v) Not Equal that(%v)", this.RtoAlgorithm, that1.RtoAlgorithm)
	}
	if this.RtoMin != nil && that1.RtoMin != nil {
		if *this.RtoMin != *that1.RtoMin {
			return fmt.Errorf("RtoMin this(%v) Not Equal that(%v)", *this.RtoMin, *that1.RtoMin)
		}
	} else if this.RtoMin != nil {
		return fmt.Errorf("this.RtoMin == nil && that.RtoMin != nil")
	} else if that1.RtoMin != nil {
		return fmt.Errorf("RtoMin this(%v) Not Equal that(%v)", this.RtoMin, that1.RtoMin)
	}
	if this.RtoMax != nil && that1.RtoMax != nil {
		if *this.RtoMax != *that1.RtoMax {
			return fmt.Errorf("RtoMax this(%v) Not Equal that(%v)", *this.RtoMax, *that1.RtoMax)
		}
	} else if this.RtoMax != nil {
		return fmt.Errorf("this.RtoMax == nil && that.RtoMax != nil")
	} else if that1.RtoMax != nil {
		return fmt.Errorf("RtoMax this(%v) Not Equal that(%v)", this.RtoMax, that1.RtoMax)
	}
	if this.MaxConn != nil && that1.MaxConn != nil {
		if *this.MaxConn != *that1.MaxConn {
			return fmt.Errorf("MaxConn this(%v) Not Equal that(%v)", *this.MaxConn, *that1.MaxConn)
		}
	} else if this.MaxConn != nil {
		return fmt.Errorf("this.MaxConn == nil && that.MaxConn != nil")
	} else if that1.MaxConn != nil {
		return fmt.Errorf("MaxConn this(%v) Not Equal that(%v)", this.MaxConn, that1.MaxConn)
	}
	if this.ActiveOpens != nil && that1.ActiveOpens != nil {
		if *this.ActiveOpens != *that1.ActiveOpens {
			return fmt.Errorf("ActiveOpens this(%v) Not Equal that(%v)", *this.ActiveOpens, *that1.ActiveOpens)
		}
	} else if this.ActiveOpens != nil {
		return fmt.Errorf("this.ActiveOpens == nil && that.ActiveOpens != nil")
	} else if that1.ActiveOpens != nil {
		return fmt.Errorf("ActiveOpens this(%v) Not Equal that(%v)", this.ActiveOpens, that1.ActiveOpens)
	}
	if this.PassiveOpens != nil && that1.PassiveOpens != nil {
		if *this.PassiveOpens != *that1.PassiveOpens {
			return fmt.Errorf("PassiveOpens this(%v) Not Equal that(%v)", *this.PassiveOpens, *that1.PassiveOpens)
		}
	} else if this.PassiveOpens != nil {
		return fmt.Errorf("this.PassiveOpens == nil && that.PassiveOpens != nil")
	} else if that1.PassiveOpens != nil {
		return fmt.Errorf("PassiveOpens this(%v) Not Equal that(%v)", this.PassiveOpens, that1.PassiveOpens)
	}
	if this.AttemptFails != nil && that1.AttemptFails != nil {
		if *this.AttemptFails != *that1.AttemptFails {
			return fmt.Errorf("AttemptFails this(%v) Not Equal that(%v)", *this.AttemptFails, *that1.AttemptFails)
		}
	} else if this.AttemptFails != nil {
		return fmt.Errorf("this.AttemptFails == nil && that.AttemptFails != nil")
	} else if that1.AttemptFails != nil {
		return fmt.Errorf("AttemptFails this(%v) Not Equal that(%v)", this.AttemptFails, that1.AttemptFails)
	}
	if this.EstabResets != nil && that1.EstabResets != nil {
		if *this.EstabResets != *that1.EstabResets {
			return fmt.Errorf("EstabResets this(%v) Not Equal that(%v)", *this.EstabResets, *that1.EstabResets)
		}
	} else if this.EstabResets != nil {
		return fmt.Errorf("this.EstabResets == nil && that.EstabResets != nil")
	} else if that1.EstabResets != nil {
		return fmt.Errorf("EstabResets this(%v) Not Equal that(%v)", this.EstabResets, that1.EstabResets)
	}
	if this.CurrEstab != nil && that1.CurrEstab != nil {
		if *this.CurrEstab != *that1.CurrEstab {
			return fmt.Errorf("CurrEstab this(%v) Not Equal that(%v)", *this.CurrEstab, *that1.CurrEstab)
		}
	} else if this.CurrEstab != nil {
		return fmt.Errorf("this.CurrEstab == nil && that.CurrEstab != nil")
	} else if that1.CurrEstab != nil {
		return fmt.Errorf("CurrEstab this(%v) Not Equal that(%v)", this.CurrEstab, that1.CurrEstab)
	}
	if this.InSegs != nil && that1.InSegs != nil {
		if *this.InSegs != *that1.InSegs {
			return fmt.Errorf("InSegs this(%v) Not Equal that(%v)", *this.InSegs, *that1.InSegs)
		}
	} else if this.InSegs != nil {
		return fmt.Errorf("this.InSegs == nil && that.InSegs != nil")
	} else if that1.InSegs != nil {
		return fmt.Errorf("InSegs this(%v) Not Equal that(%v)", this.InSegs, that1.InSegs)
	}
	if this.OutSegs != nil && that1.OutSegs != nil {
		if *this.OutSegs != *that1.OutSegs {
			return fmt.Errorf("OutSegs this(%v) Not Equal that(%v)", *this.OutSegs, *that1.OutSegs)
		}
	} else if this.OutSegs != nil {
		return fmt.Errorf("this.OutSegs == nil && that.OutSegs != nil")
	} else if that1.OutSegs != nil {
		return fmt.Errorf("OutSegs this(%v) Not Equal that(%v)", this.OutSegs, that1.OutSegs)
	}
	if this.RetransSegs != nil && that1.RetransSegs != nil {
		if *this.RetransSegs != *that1.RetransSegs {
			return fmt.Errorf("RetransSegs this(%v) Not Equal that(%v)", *this.RetransSegs, *that1.RetransSegs)
		}
	} else if this.RetransSegs != nil {
		return fmt.Errorf("this.RetransSegs == nil && that.RetransSegs != nil")
	} else if that1.RetransSegs != nil {
		return fmt.Errorf("RetransSegs this(%v) Not Equal that(%v)", this.RetransSegs, that1.RetransSegs)
	}
	if this.InErrs != nil && that1.InErrs != nil {
		if *this.InErrs != *that1.InErrs {
			return fmt.Errorf("InErrs this(%v) Not Equal that(%v)", *this.InErrs, *that1.InErrs)
		}
	} else if this.InErrs != nil {
		return fmt.Errorf("this.InErrs == nil && that.InErrs != nil")
	} else if that1.InErrs != nil {
		return fmt.Errorf("InErrs this(%v) Not Equal that(%v)", this.InErrs, that1.InErrs)
	}
	if this.OutRsts != nil && that1.OutRsts != nil {
		if *this.OutRsts != *that1.OutRsts {
			return fmt.Errorf("OutRsts this(%v) Not Equal that(%v)", *this.OutRsts, *that1.OutRsts)
		}
	} else if this.OutRsts != nil {
		return fmt.Errorf("this.OutRsts == nil && that.OutRsts != nil")
	} else if that1.OutRsts != nil {
		return fmt.Errorf("OutRsts this(%v) Not Equal that(%v)", this.OutRsts, that1.OutRsts)
	}
	if this.InCsumErrors != nil && that1.InCsumErrors != nil {
		if *this.InCsumErrors != *that1.InCsumErrors {
			return fmt.Errorf("InCsumErrors this(%v) Not Equal that(%v)", *this.InCsumErrors, *that1.InCsumErrors)
		}
	} else if this.InCsumErrors != nil {
		return fmt.Errorf("this.InCsumErrors == nil && that.InCsumErrors != nil")
	} else if that1.InCsumErrors != nil {
		return fmt.Errorf("InCsumErrors this(%v) Not Equal that(%v)", this.InCsumErrors, that1.InCsumErrors)
	}
	return nil
}
func (this *TcpStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TcpStatistics)
	if !ok {
		that2, ok := that.(TcpStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.RtoAlgorithm != nil && that1.RtoAlgorithm != nil {
		if *this.RtoAlgorithm != *that1.RtoAlgorithm {
			return false
		}
	} else if this.RtoAlgorithm != nil {
		return false
	} else if that1.RtoAlgorithm != nil {
		return false
	}
	if this.RtoMin != nil && that1.RtoMin != nil {
		if *this.RtoMin != *that1.RtoMin {
			return false
		}
	} else if this.RtoMin != nil {
		return false
	} else if that1.RtoMin != nil {
		return false
	}
	if this.RtoMax != nil && that1.RtoMax != nil {
		if *this.RtoMax != *that1.RtoMax {
			return false
		}
	} else if this.RtoMax != nil {
		return false
	} else if that1.RtoMax != nil {
		return false
	}
	if this.MaxConn != nil && that1.MaxConn != nil {
		if *this.MaxConn != *that1.MaxConn {
			return false
		}
	} else if this.MaxConn != nil {
		return false
	} else if that1.MaxConn != nil {
		return false
	}
	if this.ActiveOpens != nil && that1.ActiveOpens != nil {
		if *this.ActiveOpens != *that1.ActiveOpens {
			return false
		}
	} else if this.ActiveOpens != nil {
		return false
	} else if that1.ActiveOpens != nil {
		return false
	}
	if this.PassiveOpens != nil && that1.PassiveOpens != nil {
		if *this.PassiveOpens != *that1.PassiveOpens {
			return false
		}
	} else if this.PassiveOpens != nil {
		return false
	} else if that1.PassiveOpens != nil {
		return false
	}
	if this.AttemptFails != nil && that1.AttemptFails != nil {
		if *this.AttemptFails != *that1.AttemptFails {
			return false
		}
	} else if this.AttemptFails != nil {
		return false
	} else if that1.AttemptFails != nil {
		return false
	}
	if this.EstabResets != nil && that1.EstabResets != nil {
		if *this.EstabResets != *that1.EstabResets {
			return false
		}
	} else if this.EstabResets != nil {
		return false
	} else if that1.EstabResets != nil {
		return false
	}
	if this.CurrEstab != nil && that1.CurrEstab != nil {
		if *this.CurrEstab != *that1.CurrEstab {
			return false
		}
	} else if this.CurrEstab != nil {
		return false
	} else if that1.CurrEstab != nil {
		return false
	}
	if this.InSegs != nil && that1.InSegs != nil {
		if *this.InSegs != *that1.InSegs {
			return false
		}
	} else if this.InSegs != nil {
		return false
	} else if that1.InSegs != nil {
		return false
	}
	if this.OutSegs != nil && that1.OutSegs != nil {
		if *this.OutSegs != *that1.OutSegs {
			return false
		}
	} else if this.OutSegs != nil {
		return false
	} else if that1.OutSegs != nil {
		return false
	}
	if this.RetransSegs != nil && that1.RetransSegs != nil {
		if *this.RetransSegs != *that1.RetransSegs {
			return false
		}
	} else if this.RetransSegs != nil {
		return false
	} else if that1.RetransSegs != nil {
		return false
	}
	if this.InErrs != nil && that1.InErrs != nil {
		if *this.InErrs != *that1.InErrs {
			return false
		}
	} else if this.InErrs != nil {
		return false
	} else if that1.InErrs != nil {
		return false
	}
	if this.OutRsts != nil && that1.OutRsts != nil {
		if *this.OutRsts != *that1.OutRsts {
			return false
		}
	} else if this.OutRsts != nil {
		return false
	} else if that1.OutRsts != nil {
		return false
	}
	if this.InCsumErrors != nil && that1.InCsumErrors != nil {
		if *this.InCsumErrors != *that1.InCsumErrors {
			return false
		}
	} else if this.InCsumErrors != nil {
		return false
	} else if that1.InCsumErrors != nil {
		return false
	}
	return true
}
func (this *UdpStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*UdpStatistics)
	if !ok {
		that2, ok := that.(UdpStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *UdpStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *UdpStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *UdpStatistics but is not nil && this == nil")
	}
	if this.InDatagrams != nil && that1.InDatagrams != nil {
		if *this.InDatagrams != *that1.InDatagrams {
			return fmt.Errorf("InDatagrams this(%v) Not Equal that(%v)", *this.InDatagrams, *that1.InDatagrams)
		}
	} else if this.InDatagrams != nil {
		return fmt.Errorf("this.InDatagrams == nil && that.InDatagrams != nil")
	} else if that1.InDatagrams != nil {
		return fmt.Errorf("InDatagrams this(%v) Not Equal that(%v)", this.InDatagrams, that1.InDatagrams)
	}
	if this.NoPorts != nil && that1.NoPorts != nil {
		if *this.NoPorts != *that1.NoPorts {
			return fmt.Errorf("NoPorts this(%v) Not Equal that(%v)", *this.NoPorts, *that1.NoPorts)
		}
	} else if this.NoPorts != nil {
		return fmt.Errorf("this.NoPorts == nil && that.NoPorts != nil")
	} else if that1.NoPorts != nil {
		return fmt.Errorf("NoPorts this(%v) Not Equal that(%v)", this.NoPorts, that1.NoPorts)
	}
	if this.InErrors != nil && that1.InErrors != nil {
		if *this.InErrors != *that1.InErrors {
			return fmt.Errorf("InErrors this(%v) Not Equal that(%v)", *this.InErrors, *that1.InErrors)
		}
	} else if this.InErrors != nil {
		return fmt.Errorf("this.InErrors == nil && that.InErrors != nil")
	} else if that1.InErrors != nil {
		return fmt.Errorf("InErrors this(%v) Not Equal that(%v)", this.InErrors, that1.InErrors)
	}
	if this.OutDatagrams != nil && that1.OutDatagrams != nil {
		if *this.OutDatagrams != *that1.OutDatagrams {
			return fmt.Errorf("OutDatagrams this(%v) Not Equal that(%v)", *this.OutDatagrams, *that1.OutDatagrams)
		}
	} else if this.OutDatagrams != nil {
		return fmt.Errorf("this.OutDatagrams == nil && that.OutDatagrams != nil")
	} else if that1.OutDatagrams != nil {
		return fmt.Errorf("OutDatagrams this(%v) Not Equal that(%v)", this.OutDatagrams, that1.OutDatagrams)
	}
	if this.RcvbufErrors != nil && that1.RcvbufErrors != nil {
		if *this.RcvbufErrors != *that1.RcvbufErrors {
			return fmt.Errorf("RcvbufErrors this(%v) Not Equal that(%v)", *this.RcvbufErrors, *that1.RcvbufErrors)
		}
	} else if this.RcvbufErrors != nil {
		return fmt.Errorf("this.RcvbufErrors == nil && that.RcvbufErrors != nil")
	} else if that1.RcvbufErrors != nil {
		return fmt.Errorf("RcvbufErrors this(%v) Not Equal that(%v)", this.RcvbufErrors, that1.RcvbufErrors)
	}
	if this.SndbufErrors != nil && that1.SndbufErrors != nil {
		if *this.SndbufErrors != *that1.SndbufErrors {
			return fmt.Errorf("SndbufErrors this(%v) Not Equal that(%v)", *this.SndbufErrors, *that1.SndbufErrors)
		}
	} else if this.SndbufErrors != nil {
		return fmt.Errorf("this.SndbufErrors == nil && that.SndbufErrors != nil")
	} else if that1.SndbufErrors != nil {
		return fmt.Errorf("SndbufErrors this(%v) Not Equal that(%v)", this.SndbufErrors, that1.SndbufErrors)
	}
	if this.InCsumErrors != nil && that1.InCsumErrors != nil {
		if *this.InCsumErrors != *that1.InCsumErrors {
			return fmt.Errorf("InCsumErrors this(%v) Not Equal that(%v)", *this.InCsumErrors, *that1.InCsumErrors)
		}
	} else if this.InCsumErrors != nil {
		return fmt.Errorf("this.InCsumErrors == nil && that.InCsumErrors != nil")
	} else if that1.InCsumErrors != nil {
		return fmt.Errorf("InCsumErrors this(%v) Not Equal that(%v)", this.InCsumErrors, that1.InCsumErrors)
	}
	if this.IgnoredMulti != nil && that1.IgnoredMulti != nil {
		if *this.IgnoredMulti != *that1.IgnoredMulti {
			return fmt.Errorf("IgnoredMulti this(%v) Not Equal that(%v)", *this.IgnoredMulti, *that1.IgnoredMulti)
		}
	} else if this.IgnoredMulti != nil {
		return fmt.Errorf("this.IgnoredMulti == nil && that.IgnoredMulti != nil")
	} else if that1.IgnoredMulti != nil {
		return fmt.Errorf("IgnoredMulti this(%v) Not Equal that(%v)", this.IgnoredMulti, that1.IgnoredMulti)
	}
	return nil
}
func (this *UdpStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*UdpStatistics)
	if !ok {
		that2, ok := that.(UdpStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.InDatagrams != nil && that1.InDatagrams != nil {
		if *this.InDatagrams != *that1.InDatagrams {
			return false
		}
	} else if this.InDatagrams != nil {
		return false
	} else if that1.InDatagrams != nil {
		return false
	}
	if this.NoPorts != nil && that1.NoPorts != nil {
		if *this.NoPorts != *that1.NoPorts {
			return false
		}
	} else if this.NoPorts != nil {
		return false
	} else if that1.NoPorts != nil {
		return false
	}
	if this.InErrors != nil && that1.InErrors != nil {
		if *this.InErrors != *that1.InErrors {
			return false
		}
	} else if this.InErrors != nil {
		return false
	} else if that1.InErrors != nil {
		return false
	}
	if this.OutDatagrams != nil && that1.OutDatagrams != nil {
		if *this.OutDatagrams != *that1.OutDatagrams {
			return false
		}
	} else if this.OutDatagrams != nil {
		return false
	} else if that1.OutDatagrams != nil {
		return false
	}
	if this.RcvbufErrors != nil && that1.RcvbufErrors != nil {
		if *this.RcvbufErrors != *that1.RcvbufErrors {
			return false
		}
	} else if this.RcvbufErrors != nil {
		return false
	} else if that1.RcvbufErrors != nil {
		return false
	}
	if this.SndbufErrors != nil && that1.SndbufErrors != nil {
		if *this.SndbufErrors != *that1.SndbufErrors {
			return false
		}
	} else if this.SndbufErrors != nil {
		return false
	} else if that1.SndbufErrors != nil {
		return false
	}
	if this.InCsumErrors != nil && that1.InCsumErrors != nil {
		if *this.InCsumErrors != *that1.InCsumErrors {
			return false
		}
	} else if this.InCsumErrors != nil {
		return false
	} else if that1.InCsumErrors != nil {
		return false
	}
	if this.IgnoredMulti != nil && that1.IgnoredMulti != nil {
		if *this.IgnoredMulti != *that1.IgnoredMulti {
			return false
		}
	} else if this.IgnoredMulti != nil {
		return false
	} else if that1.IgnoredMulti != nil {
		return false
	}
	return true
}
func (this *SNMPStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*SNMPStatistics)
	if !ok {
		that2, ok := that.(SNMPStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *SNMPStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *SNMPStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *SNMPStatistics but is not nil && this == nil")
	}
	if !this.IPStats.Equal(that1.IPStats) {
		return fmt.Errorf("IPStats this(%v) Not Equal that(%v)", this.IPStats, that1.IPStats)
	}
	if !this.ICMPStats.Equal(that1.ICMPStats) {
		return fmt.Errorf("ICMPStats this(%v) Not Equal that(%v)", this.ICMPStats, that1.ICMPStats)
	}
	if !this.TCPStats.Equal(that1.TCPStats) {
		return fmt.Errorf("TCPStats this(%v) Not Equal that(%v)", this.TCPStats, that1.TCPStats)
	}
	if !this.UDPStats.Equal(that1.UDPStats) {
		return fmt.Errorf("UDPStats this(%v) Not Equal that(%v)", this.UDPStats, that1.UDPStats)
	}
	return nil
}
func (this *SNMPStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SNMPStatistics)
	if !ok {
		that2, ok := that.(SNMPStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.IPStats.Equal(that1.IPStats) {
		return false
	}
	if !this.ICMPStats.Equal(that1.ICMPStats) {
		return false
	}
	if !this.TCPStats.Equal(that1.TCPStats) {
		return false
	}
	if !this.UDPStats.Equal(that1.UDPStats) {
		return false
	}
	return true
}
func (this *DiskStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DiskStatistics)
	if !ok {
		that2, ok := that.(DiskStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DiskStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DiskStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DiskStatistics but is not nil && this == nil")
	}
	if !this.Source.Equal(that1.Source) {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if !this.Persistence.Equal(that1.Persistence) {
		return fmt.Errorf("Persistence this(%v) Not Equal that(%v)", this.Persistence, that1.Persistence)
	}
	if this.LimitBytes != nil && that1.LimitBytes != nil {
		if *this.LimitBytes != *that1.LimitBytes {
			return fmt.Errorf("LimitBytes this(%v) Not Equal that(%v)", *this.LimitBytes, *that1.LimitBytes)
		}
	} else if this.LimitBytes != nil {
		return fmt.Errorf("this.LimitBytes == nil && that.LimitBytes != nil")
	} else if that1.LimitBytes != nil {
		return fmt.Errorf("LimitBytes this(%v) Not Equal that(%v)", this.LimitBytes, that1.LimitBytes)
	}
	if this.UsedBytes != nil && that1.UsedBytes != nil {
		if *this.UsedBytes != *that1.UsedBytes {
			return fmt.Errorf("UsedBytes this(%v) Not Equal that(%v)", *this.UsedBytes, *that1.UsedBytes)
		}
	} else if this.UsedBytes != nil {
		return fmt.Errorf("this.UsedBytes == nil && that.UsedBytes != nil")
	} else if that1.UsedBytes != nil {
		return fmt.Errorf("UsedBytes this(%v) Not Equal that(%v)", this.UsedBytes, that1.UsedBytes)
	}
	return nil
}
func (this *DiskStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DiskStatistics)
	if !ok {
		that2, ok := that.(DiskStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Source.Equal(that1.Source) {
		return false
	}
	if !this.Persistence.Equal(that1.Persistence) {
		return false
	}
	if this.LimitBytes != nil && that1.LimitBytes != nil {
		if *this.LimitBytes != *that1.LimitBytes {
			return false
		}
	} else if this.LimitBytes != nil {
		return false
	} else if that1.LimitBytes != nil {
		return false
	}
	if this.UsedBytes != nil && that1.UsedBytes != nil {
		if *this.UsedBytes != *that1.UsedBytes {
			return false
		}
	} else if this.UsedBytes != nil {
		return false
	} else if that1.UsedBytes != nil {
		return false
	}
	return true
}
func (this *ResourceStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceStatistics)
	if !ok {
		that2, ok := that.(ResourceStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ResourceStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceStatistics but is not nil && this == nil")
	}
	if this.Timestamp != that1.Timestamp {
		return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if this.Processes != nil && that1.Processes != nil {
		if *this.Processes != *that1.Processes {
			return fmt.Errorf("Processes this(%v) Not Equal that(%v)", *this.Processes, *that1.Processes)
		}
	} else if this.Processes != nil {
		return fmt.Errorf("this.Processes == nil && that.Processes != nil")
	} else if that1.Processes != nil {
		return fmt.Errorf("Processes this(%v) Not Equal that(%v)", this.Processes, that1.Processes)
	}
	if this.Threads != nil && that1.Threads != nil {
		if *this.Threads != *that1.Threads {
			return fmt.Errorf("Threads this(%v) Not Equal that(%v)", *this.Threads, *that1.Threads)
		}
	} else if this.Threads != nil {
		return fmt.Errorf("this.Threads == nil && that.Threads != nil")
	} else if that1.Threads != nil {
		return fmt.Errorf("Threads this(%v) Not Equal that(%v)", this.Threads, that1.Threads)
	}
	if this.CPUsUserTimeSecs != nil && that1.CPUsUserTimeSecs != nil {
		if *this.CPUsUserTimeSecs != *that1.CPUsUserTimeSecs {
			return fmt.Errorf("CPUsUserTimeSecs this(%v) Not Equal that(%v)", *this.CPUsUserTimeSecs, *that1.CPUsUserTimeSecs)
		}
	} else if this.CPUsUserTimeSecs != nil {
		return fmt.Errorf("this.CPUsUserTimeSecs == nil && that.CPUsUserTimeSecs != nil")
	} else if that1.CPUsUserTimeSecs != nil {
		return fmt.Errorf("CPUsUserTimeSecs this(%v) Not Equal that(%v)", this.CPUsUserTimeSecs, that1.CPUsUserTimeSecs)
	}
	if this.CPUsSystemTimeSecs != nil && that1.CPUsSystemTimeSecs != nil {
		if *this.CPUsSystemTimeSecs != *that1.CPUsSystemTimeSecs {
			return fmt.Errorf("CPUsSystemTimeSecs this(%v) Not Equal that(%v)", *this.CPUsSystemTimeSecs, *that1.CPUsSystemTimeSecs)
		}
	} else if this.CPUsSystemTimeSecs != nil {
		return fmt.Errorf("this.CPUsSystemTimeSecs == nil && that.CPUsSystemTimeSecs != nil")
	} else if that1.CPUsSystemTimeSecs != nil {
		return fmt.Errorf("CPUsSystemTimeSecs this(%v) Not Equal that(%v)", this.CPUsSystemTimeSecs, that1.CPUsSystemTimeSecs)
	}
	if this.CPUsLimit != nil && that1.CPUsLimit != nil {
		if *this.CPUsLimit != *that1.CPUsLimit {
			return fmt.Errorf("CPUsLimit this(%v) Not Equal that(%v)", *this.CPUsLimit, *that1.CPUsLimit)
		}
	} else if this.CPUsLimit != nil {
		return fmt.Errorf("this.CPUsLimit == nil && that.CPUsLimit != nil")
	} else if that1.CPUsLimit != nil {
		return fmt.Errorf("CPUsLimit this(%v) Not Equal that(%v)", this.CPUsLimit, that1.CPUsLimit)
	}
	if this.CPUsNrPeriods != nil && that1.CPUsNrPeriods != nil {
		if *this.CPUsNrPeriods != *that1.CPUsNrPeriods {
			return fmt.Errorf("CPUsNrPeriods this(%v) Not Equal that(%v)", *this.CPUsNrPeriods, *that1.CPUsNrPeriods)
		}
	} else if this.CPUsNrPeriods != nil {
		return fmt.Errorf("this.CPUsNrPeriods == nil && that.CPUsNrPeriods != nil")
	} else if that1.CPUsNrPeriods != nil {
		return fmt.Errorf("CPUsNrPeriods this(%v) Not Equal that(%v)", this.CPUsNrPeriods, that1.CPUsNrPeriods)
	}
	if this.CPUsNrThrottled != nil && that1.CPUsNrThrottled != nil {
		if *this.CPUsNrThrottled != *that1.CPUsNrThrottled {
			return fmt.Errorf("CPUsNrThrottled this(%v) Not Equal that(%v)", *this.CPUsNrThrottled, *that1.CPUsNrThrottled)
		}
	} else if this.CPUsNrThrottled != nil {
		return fmt.Errorf("this.CPUsNrThrottled == nil && that.CPUsNrThrottled != nil")
	} else if that1.CPUsNrThrottled != nil {
		return fmt.Errorf("CPUsNrThrottled this(%v) Not Equal that(%v)", this.CPUsNrThrottled, that1.CPUsNrThrottled)
	}
	if this.CPUsThrottledTimeSecs != nil && that1.CPUsThrottledTimeSecs != nil {
		if *this.CPUsThrottledTimeSecs != *that1.CPUsThrottledTimeSecs {
			return fmt.Errorf("CPUsThrottledTimeSecs this(%v) Not Equal that(%v)", *this.CPUsThrottledTimeSecs, *that1.CPUsThrottledTimeSecs)
		}
	} else if this.CPUsThrottledTimeSecs != nil {
		return fmt.Errorf("this.CPUsThrottledTimeSecs == nil && that.CPUsThrottledTimeSecs != nil")
	} else if that1.CPUsThrottledTimeSecs != nil {
		return fmt.Errorf("CPUsThrottledTimeSecs this(%v) Not Equal that(%v)", this.CPUsThrottledTimeSecs, that1.CPUsThrottledTimeSecs)
	}
	if this.MemTotalBytes != nil && that1.MemTotalBytes != nil {
		if *this.MemTotalBytes != *that1.MemTotalBytes {
			return fmt.Errorf("MemTotalBytes this(%v) Not Equal that(%v)", *this.MemTotalBytes, *that1.MemTotalBytes)
		}
	} else if this.MemTotalBytes != nil {
		return fmt.Errorf("this.MemTotalBytes == nil && that.MemTotalBytes != nil")
	} else if that1.MemTotalBytes != nil {
		return fmt.Errorf("MemTotalBytes this(%v) Not Equal that(%v)", this.MemTotalBytes, that1.MemTotalBytes)
	}
	if this.MemTotalMemswBytes != nil && that1.MemTotalMemswBytes != nil {
		if *this.MemTotalMemswBytes != *that1.MemTotalMemswBytes {
			return fmt.Errorf("MemTotalMemswBytes this(%v) Not Equal that(%v)", *this.MemTotalMemswBytes, *that1.MemTotalMemswBytes)
		}
	} else if this.MemTotalMemswBytes != nil {
		return fmt.Errorf("this.MemTotalMemswBytes == nil && that.MemTotalMemswBytes != nil")
	} else if that1.MemTotalMemswBytes != nil {
		return fmt.Errorf("MemTotalMemswBytes this(%v) Not Equal that(%v)", this.MemTotalMemswBytes, that1.MemTotalMemswBytes)
	}
	if this.MemLimitBytes != nil && that1.MemLimitBytes != nil {
		if *this.MemLimitBytes != *that1.MemLimitBytes {
			return fmt.Errorf("MemLimitBytes this(%v) Not Equal that(%v)", *this.MemLimitBytes, *that1.MemLimitBytes)
		}
	} else if this.MemLimitBytes != nil {
		return fmt.Errorf("this.MemLimitBytes == nil && that.MemLimitBytes != nil")
	} else if that1.MemLimitBytes != nil {
		return fmt.Errorf("MemLimitBytes this(%v) Not Equal that(%v)", this.MemLimitBytes, that1.MemLimitBytes)
	}
	if this.MemSoftLimitBytes != nil && that1.MemSoftLimitBytes != nil {
		if *this.MemSoftLimitBytes != *that1.MemSoftLimitBytes {
			return fmt.Errorf("MemSoftLimitBytes this(%v) Not Equal that(%v)", *this.MemSoftLimitBytes, *that1.MemSoftLimitBytes)
		}
	} else if this.MemSoftLimitBytes != nil {
		return fmt.Errorf("this.MemSoftLimitBytes == nil && that.MemSoftLimitBytes != nil")
	} else if that1.MemSoftLimitBytes != nil {
		return fmt.Errorf("MemSoftLimitBytes this(%v) Not Equal that(%v)", this.MemSoftLimitBytes, that1.MemSoftLimitBytes)
	}
	if this.MemFileBytes != nil && that1.MemFileBytes != nil {
		if *this.MemFileBytes != *that1.MemFileBytes {
			return fmt.Errorf("MemFileBytes this(%v) Not Equal that(%v)", *this.MemFileBytes, *that1.MemFileBytes)
		}
	} else if this.MemFileBytes != nil {
		return fmt.Errorf("this.MemFileBytes == nil && that.MemFileBytes != nil")
	} else if that1.MemFileBytes != nil {
		return fmt.Errorf("MemFileBytes this(%v) Not Equal that(%v)", this.MemFileBytes, that1.MemFileBytes)
	}
	if this.MemAnonBytes != nil && that1.MemAnonBytes != nil {
		if *this.MemAnonBytes != *that1.MemAnonBytes {
			return fmt.Errorf("MemAnonBytes this(%v) Not Equal that(%v)", *this.MemAnonBytes, *that1.MemAnonBytes)
		}
	} else if this.MemAnonBytes != nil {
		return fmt.Errorf("this.MemAnonBytes == nil && that.MemAnonBytes != nil")
	} else if that1.MemAnonBytes != nil {
		return fmt.Errorf("MemAnonBytes this(%v) Not Equal that(%v)", this.MemAnonBytes, that1.MemAnonBytes)
	}
	if this.MemCacheBytes != nil && that1.MemCacheBytes != nil {
		if *this.MemCacheBytes != *that1.MemCacheBytes {
			return fmt.Errorf("MemCacheBytes this(%v) Not Equal that(%v)", *this.MemCacheBytes, *that1.MemCacheBytes)
		}
	} else if this.MemCacheBytes != nil {
		return fmt.Errorf("this.MemCacheBytes == nil && that.MemCacheBytes != nil")
	} else if that1.MemCacheBytes != nil {
		return fmt.Errorf("MemCacheBytes this(%v) Not Equal that(%v)", this.MemCacheBytes, that1.MemCacheBytes)
	}
	if this.MemRSSBytes != nil && that1.MemRSSBytes != nil {
		if *this.MemRSSBytes != *that1.MemRSSBytes {
			return fmt.Errorf("MemRSSBytes this(%v) Not Equal that(%v)", *this.MemRSSBytes, *that1.MemRSSBytes)
		}
	} else if this.MemRSSBytes != nil {
		return fmt.Errorf("this.MemRSSBytes == nil && that.MemRSSBytes != nil")
	} else if that1.MemRSSBytes != nil {
		return fmt.Errorf("MemRSSBytes this(%v) Not Equal that(%v)", this.MemRSSBytes, that1.MemRSSBytes)
	}
	if this.MemMappedFileBytes != nil && that1.MemMappedFileBytes != nil {
		if *this.MemMappedFileBytes != *that1.MemMappedFileBytes {
			return fmt.Errorf("MemMappedFileBytes this(%v) Not Equal that(%v)", *this.MemMappedFileBytes, *that1.MemMappedFileBytes)
		}
	} else if this.MemMappedFileBytes != nil {
		return fmt.Errorf("this.MemMappedFileBytes == nil && that.MemMappedFileBytes != nil")
	} else if that1.MemMappedFileBytes != nil {
		return fmt.Errorf("MemMappedFileBytes this(%v) Not Equal that(%v)", this.MemMappedFileBytes, that1.MemMappedFileBytes)
	}
	if this.MemSwapBytes != nil && that1.MemSwapBytes != nil {
		if *this.MemSwapBytes != *that1.MemSwapBytes {
			return fmt.Errorf("MemSwapBytes this(%v) Not Equal that(%v)", *this.MemSwapBytes, *that1.MemSwapBytes)
		}
	} else if this.MemSwapBytes != nil {
		return fmt.Errorf("this.MemSwapBytes == nil && that.MemSwapBytes != nil")
	} else if that1.MemSwapBytes != nil {
		return fmt.Errorf("MemSwapBytes this(%v) Not Equal that(%v)", this.MemSwapBytes, that1.MemSwapBytes)
	}
	if this.MemUnevictableBytes != nil && that1.MemUnevictableBytes != nil {
		if *this.MemUnevictableBytes != *that1.MemUnevictableBytes {
			return fmt.Errorf("MemUnevictableBytes this(%v) Not Equal that(%v)", *this.MemUnevictableBytes, *that1.MemUnevictableBytes)
		}
	} else if this.MemUnevictableBytes != nil {
		return fmt.Errorf("this.MemUnevictableBytes == nil && that.MemUnevictableBytes != nil")
	} else if that1.MemUnevictableBytes != nil {
		return fmt.Errorf("MemUnevictableBytes this(%v) Not Equal that(%v)", this.MemUnevictableBytes, that1.MemUnevictableBytes)
	}
	if this.MemLowPressureCounter != nil && that1.MemLowPressureCounter != nil {
		if *this.MemLowPressureCounter != *that1.MemLowPressureCounter {
			return fmt.Errorf("MemLowPressureCounter this(%v) Not Equal that(%v)", *this.MemLowPressureCounter, *that1.MemLowPressureCounter)
		}
	} else if this.MemLowPressureCounter != nil {
		return fmt.Errorf("this.MemLowPressureCounter == nil && that.MemLowPressureCounter != nil")
	} else if that1.MemLowPressureCounter != nil {
		return fmt.Errorf("MemLowPressureCounter this(%v) Not Equal that(%v)", this.MemLowPressureCounter, that1.MemLowPressureCounter)
	}
	if this.MemMediumPressureCounter != nil && that1.MemMediumPressureCounter != nil {
		if *this.MemMediumPressureCounter != *that1.MemMediumPressureCounter {
			return fmt.Errorf("MemMediumPressureCounter this(%v) Not Equal that(%v)", *this.MemMediumPressureCounter, *that1.MemMediumPressureCounter)
		}
	} else if this.MemMediumPressureCounter != nil {
		return fmt.Errorf("this.MemMediumPressureCounter == nil && that.MemMediumPressureCounter != nil")
	} else if that1.MemMediumPressureCounter != nil {
		return fmt.Errorf("MemMediumPressureCounter this(%v) Not Equal that(%v)", this.MemMediumPressureCounter, that1.MemMediumPressureCounter)
	}
	if this.MemCriticalPressureCounter != nil && that1.MemCriticalPressureCounter != nil {
		if *this.MemCriticalPressureCounter != *that1.MemCriticalPressureCounter {
			return fmt.Errorf("MemCriticalPressureCounter this(%v) Not Equal that(%v)", *this.MemCriticalPressureCounter, *that1.MemCriticalPressureCounter)
		}
	} else if this.MemCriticalPressureCounter != nil {
		return fmt.Errorf("this.MemCriticalPressureCounter == nil && that.MemCriticalPressureCounter != nil")
	} else if that1.MemCriticalPressureCounter != nil {
		return fmt.Errorf("MemCriticalPressureCounter this(%v) Not Equal that(%v)", this.MemCriticalPressureCounter, that1.MemCriticalPressureCounter)
	}
	if this.DiskLimitBytes != nil && that1.DiskLimitBytes != nil {
		if *this.DiskLimitBytes != *that1.DiskLimitBytes {
			return fmt.Errorf("DiskLimitBytes this(%v) Not Equal that(%v)", *this.DiskLimitBytes, *that1.DiskLimitBytes)
		}
	} else if this.DiskLimitBytes != nil {
		return fmt.Errorf("this.DiskLimitBytes == nil && that.DiskLimitBytes != nil")
	} else if that1.DiskLimitBytes != nil {
		return fmt.Errorf("DiskLimitBytes this(%v) Not Equal that(%v)", this.DiskLimitBytes, that1.DiskLimitBytes)
	}
	if this.DiskUsedBytes != nil && that1.DiskUsedBytes != nil {
		if *this.DiskUsedBytes != *that1.DiskUsedBytes {
			return fmt.Errorf("DiskUsedBytes this(%v) Not Equal that(%v)", *this.DiskUsedBytes, *that1.DiskUsedBytes)
		}
	} else if this.DiskUsedBytes != nil {
		return fmt.Errorf("this.DiskUsedBytes == nil && that.DiskUsedBytes != nil")
	} else if that1.DiskUsedBytes != nil {
		return fmt.Errorf("DiskUsedBytes this(%v) Not Equal that(%v)", this.DiskUsedBytes, that1.DiskUsedBytes)
	}
	if len(this.DiskStatistics) != len(that1.DiskStatistics) {
		return fmt.Errorf("DiskStatistics this(%v) Not Equal that(%v)", len(this.DiskStatistics), len(that1.DiskStatistics))
	}
	for i := range this.DiskStatistics {
		if !this.DiskStatistics[i].Equal(&that1.DiskStatistics[i]) {
			return fmt.Errorf("DiskStatistics this[%v](%v) Not Equal that[%v](%v)", i, this.DiskStatistics[i], i, that1.DiskStatistics[i])
		}
	}
	if !this.BlkioStatistics.Equal(that1.BlkioStatistics) {
		return fmt.Errorf("BlkioStatistics this(%v) Not Equal that(%v)", this.BlkioStatistics, that1.BlkioStatistics)
	}
	if !this.Perf.Equal(that1.Perf) {
		return fmt.Errorf("Perf this(%v) Not Equal that(%v)", this.Perf, that1.Perf)
	}
	if this.NetRxPackets != nil && that1.NetRxPackets != nil {
		if *this.NetRxPackets != *that1.NetRxPackets {
			return fmt.Errorf("NetRxPackets this(%v) Not Equal that(%v)", *this.NetRxPackets, *that1.NetRxPackets)
		}
	} else if this.NetRxPackets != nil {
		return fmt.Errorf("this.NetRxPackets == nil && that.NetRxPackets != nil")
	} else if that1.NetRxPackets != nil {
		return fmt.Errorf("NetRxPackets this(%v) Not Equal that(%v)", this.NetRxPackets, that1.NetRxPackets)
	}
	if this.NetRxBytes != nil && that1.NetRxBytes != nil {
		if *this.NetRxBytes != *that1.NetRxBytes {
			return fmt.Errorf("NetRxBytes this(%v) Not Equal that(%v)", *this.NetRxBytes, *that1.NetRxBytes)
		}
	} else if this.NetRxBytes != nil {
		return fmt.Errorf("this.NetRxBytes == nil && that.NetRxBytes != nil")
	} else if that1.NetRxBytes != nil {
		return fmt.Errorf("NetRxBytes this(%v) Not Equal that(%v)", this.NetRxBytes, that1.NetRxBytes)
	}
	if this.NetRxErrors != nil && that1.NetRxErrors != nil {
		if *this.NetRxErrors != *that1.NetRxErrors {
			return fmt.Errorf("NetRxErrors this(%v) Not Equal that(%v)", *this.NetRxErrors, *that1.NetRxErrors)
		}
	} else if this.NetRxErrors != nil {
		return fmt.Errorf("this.NetRxErrors == nil && that.NetRxErrors != nil")
	} else if that1.NetRxErrors != nil {
		return fmt.Errorf("NetRxErrors this(%v) Not Equal that(%v)", this.NetRxErrors, that1.NetRxErrors)
	}
	if this.NetRxDropped != nil && that1.NetRxDropped != nil {
		if *this.NetRxDropped != *that1.NetRxDropped {
			return fmt.Errorf("NetRxDropped this(%v) Not Equal that(%v)", *this.NetRxDropped, *that1.NetRxDropped)
		}
	} else if this.NetRxDropped != nil {
		return fmt.Errorf("this.NetRxDropped == nil && that.NetRxDropped != nil")
	} else if that1.NetRxDropped != nil {
		return fmt.Errorf("NetRxDropped this(%v) Not Equal that(%v)", this.NetRxDropped, that1.NetRxDropped)
	}
	if this.NetTxPackets != nil && that1.NetTxPackets != nil {
		if *this.NetTxPackets != *that1.NetTxPackets {
			return fmt.Errorf("NetTxPackets this(%v) Not Equal that(%v)", *this.NetTxPackets, *that1.NetTxPackets)
		}
	} else if this.NetTxPackets != nil {
		return fmt.Errorf("this.NetTxPackets == nil && that.NetTxPackets != nil")
	} else if that1.NetTxPackets != nil {
		return fmt.Errorf("NetTxPackets this(%v) Not Equal that(%v)", this.NetTxPackets, that1.NetTxPackets)
	}
	if this.NetTxBytes != nil && that1.NetTxBytes != nil {
		if *this.NetTxBytes != *that1.NetTxBytes {
			return fmt.Errorf("NetTxBytes this(%v) Not Equal that(%v)", *this.NetTxBytes, *that1.NetTxBytes)
		}
	} else if this.NetTxBytes != nil {
		return fmt.Errorf("this.NetTxBytes == nil && that.NetTxBytes != nil")
	} else if that1.NetTxBytes != nil {
		return fmt.Errorf("NetTxBytes this(%v) Not Equal that(%v)", this.NetTxBytes, that1.NetTxBytes)
	}
	if this.NetTxErrors != nil && that1.NetTxErrors != nil {
		if *this.NetTxErrors != *that1.NetTxErrors {
			return fmt.Errorf("NetTxErrors this(%v) Not Equal that(%v)", *this.NetTxErrors, *that1.NetTxErrors)
		}
	} else if this.NetTxErrors != nil {
		return fmt.Errorf("this.NetTxErrors == nil && that.NetTxErrors != nil")
	} else if that1.NetTxErrors != nil {
		return fmt.Errorf("NetTxErrors this(%v) Not Equal that(%v)", this.NetTxErrors, that1.NetTxErrors)
	}
	if this.NetTxDropped != nil && that1.NetTxDropped != nil {
		if *this.NetTxDropped != *that1.NetTxDropped {
			return fmt.Errorf("NetTxDropped this(%v) Not Equal that(%v)", *this.NetTxDropped, *that1.NetTxDropped)
		}
	} else if this.NetTxDropped != nil {
		return fmt.Errorf("this.NetTxDropped == nil && that.NetTxDropped != nil")
	} else if that1.NetTxDropped != nil {
		return fmt.Errorf("NetTxDropped this(%v) Not Equal that(%v)", this.NetTxDropped, that1.NetTxDropped)
	}
	if this.NetTCPRttMicrosecsP50 != nil && that1.NetTCPRttMicrosecsP50 != nil {
		if *this.NetTCPRttMicrosecsP50 != *that1.NetTCPRttMicrosecsP50 {
			return fmt.Errorf("NetTCPRttMicrosecsP50 this(%v) Not Equal that(%v)", *this.NetTCPRttMicrosecsP50, *that1.NetTCPRttMicrosecsP50)
		}
	} else if this.NetTCPRttMicrosecsP50 != nil {
		return fmt.Errorf("this.NetTCPRttMicrosecsP50 == nil && that.NetTCPRttMicrosecsP50 != nil")
	} else if that1.NetTCPRttMicrosecsP50 != nil {
		return fmt.Errorf("NetTCPRttMicrosecsP50 this(%v) Not Equal that(%v)", this.NetTCPRttMicrosecsP50, that1.NetTCPRttMicrosecsP50)
	}
	if this.NetTCPRttMicrosecsP90 != nil && that1.NetTCPRttMicrosecsP90 != nil {
		if *this.NetTCPRttMicrosecsP90 != *that1.NetTCPRttMicrosecsP90 {
			return fmt.Errorf("NetTCPRttMicrosecsP90 this(%v) Not Equal that(%v)", *this.NetTCPRttMicrosecsP90, *that1.NetTCPRttMicrosecsP90)
		}
	} else if this.NetTCPRttMicrosecsP90 != nil {
		return fmt.Errorf("this.NetTCPRttMicrosecsP90 == nil && that.NetTCPRttMicrosecsP90 != nil")
	} else if that1.NetTCPRttMicrosecsP90 != nil {
		return fmt.Errorf("NetTCPRttMicrosecsP90 this(%v) Not Equal that(%v)", this.NetTCPRttMicrosecsP90, that1.NetTCPRttMicrosecsP90)
	}
	if this.NetTCPRttMicrosecsP95 != nil && that1.NetTCPRttMicrosecsP95 != nil {
		if *this.NetTCPRttMicrosecsP95 != *that1.NetTCPRttMicrosecsP95 {
			return fmt.Errorf("NetTCPRttMicrosecsP95 this(%v) Not Equal that(%v)", *this.NetTCPRttMicrosecsP95, *that1.NetTCPRttMicrosecsP95)
		}
	} else if this.NetTCPRttMicrosecsP95 != nil {
		return fmt.Errorf("this.NetTCPRttMicrosecsP95 == nil && that.NetTCPRttMicrosecsP95 != nil")
	} else if that1.NetTCPRttMicrosecsP95 != nil {
		return fmt.Errorf("NetTCPRttMicrosecsP95 this(%v) Not Equal that(%v)", this.NetTCPRttMicrosecsP95, that1.NetTCPRttMicrosecsP95)
	}
	if this.NetTCPRttMicrosecsP99 != nil && that1.NetTCPRttMicrosecsP99 != nil {
		if *this.NetTCPRttMicrosecsP99 != *that1.NetTCPRttMicrosecsP99 {
			return fmt.Errorf("NetTCPRttMicrosecsP99 this(%v) Not Equal that(%v)", *this.NetTCPRttMicrosecsP99, *that1.NetTCPRttMicrosecsP99)
		}
	} else if this.NetTCPRttMicrosecsP99 != nil {
		return fmt.Errorf("this.NetTCPRttMicrosecsP99 == nil && that.NetTCPRttMicrosecsP99 != nil")
	} else if that1.NetTCPRttMicrosecsP99 != nil {
		return fmt.Errorf("NetTCPRttMicrosecsP99 this(%v) Not Equal that(%v)", this.NetTCPRttMicrosecsP99, that1.NetTCPRttMicrosecsP99)
	}
	if this.NetTCPActiveConnections != nil && that1.NetTCPActiveConnections != nil {
		if *this.NetTCPActiveConnections != *that1.NetTCPActiveConnections {
			return fmt.Errorf("NetTCPActiveConnections this(%v) Not Equal that(%v)", *this.NetTCPActiveConnections, *that1.NetTCPActiveConnections)
		}
	} else if this.NetTCPActiveConnections != nil {
		return fmt.Errorf("this.NetTCPActiveConnections == nil && that.NetTCPActiveConnections != nil")
	} else if that1.NetTCPActiveConnections != nil {
		return fmt.Errorf("NetTCPActiveConnections this(%v) Not Equal that(%v)", this.NetTCPActiveConnections, that1.NetTCPActiveConnections)
	}
	if this.NetTCPTimeWaitConnections != nil && that1.NetTCPTimeWaitConnections != nil {
		if *this.NetTCPTimeWaitConnections != *that1.NetTCPTimeWaitConnections {
			return fmt.Errorf("NetTCPTimeWaitConnections this(%v) Not Equal that(%v)", *this.NetTCPTimeWaitConnections, *that1.NetTCPTimeWaitConnections)
		}
	} else if this.NetTCPTimeWaitConnections != nil {
		return fmt.Errorf("this.NetTCPTimeWaitConnections == nil && that.NetTCPTimeWaitConnections != nil")
	} else if that1.NetTCPTimeWaitConnections != nil {
		return fmt.Errorf("NetTCPTimeWaitConnections this(%v) Not Equal that(%v)", this.NetTCPTimeWaitConnections, that1.NetTCPTimeWaitConnections)
	}
	if len(this.NetTrafficControlStatistics) != len(that1.NetTrafficControlStatistics) {
		return fmt.Errorf("NetTrafficControlStatistics this(%v) Not Equal that(%v)", len(this.NetTrafficControlStatistics), len(that1.NetTrafficControlStatistics))
	}
	for i := range this.NetTrafficControlStatistics {
		if !this.NetTrafficControlStatistics[i].Equal(&that1.NetTrafficControlStatistics[i]) {
			return fmt.Errorf("NetTrafficControlStatistics this[%v](%v) Not Equal that[%v](%v)", i, this.NetTrafficControlStatistics[i], i, that1.NetTrafficControlStatistics[i])
		}
	}
	if !this.NetSNMPStatistics.Equal(that1.NetSNMPStatistics) {
		return fmt.Errorf("NetSNMPStatistics this(%v) Not Equal that(%v)", this.NetSNMPStatistics, that1.NetSNMPStatistics)
	}
	return nil
}
func (this *ResourceStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceStatistics)
	if !ok {
		that2, ok := that.(ResourceStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Timestamp != that1.Timestamp {
		return false
	}
	if this.Processes != nil && that1.Processes != nil {
		if *this.Processes != *that1.Processes {
			return false
		}
	} else if this.Processes != nil {
		return false
	} else if that1.Processes != nil {
		return false
	}
	if this.Threads != nil && that1.Threads != nil {
		if *this.Threads != *that1.Threads {
			return false
		}
	} else if this.Threads != nil {
		return false
	} else if that1.Threads != nil {
		return false
	}
	if this.CPUsUserTimeSecs != nil && that1.CPUsUserTimeSecs != nil {
		if *this.CPUsUserTimeSecs != *that1.CPUsUserTimeSecs {
			return false
		}
	} else if this.CPUsUserTimeSecs != nil {
		return false
	} else if that1.CPUsUserTimeSecs != nil {
		return false
	}
	if this.CPUsSystemTimeSecs != nil && that1.CPUsSystemTimeSecs != nil {
		if *this.CPUsSystemTimeSecs != *that1.CPUsSystemTimeSecs {
			return false
		}
	} else if this.CPUsSystemTimeSecs != nil {
		return false
	} else if that1.CPUsSystemTimeSecs != nil {
		return false
	}
	if this.CPUsLimit != nil && that1.CPUsLimit != nil {
		if *this.CPUsLimit != *that1.CPUsLimit {
			return false
		}
	} else if this.CPUsLimit != nil {
		return false
	} else if that1.CPUsLimit != nil {
		return false
	}
	if this.CPUsNrPeriods != nil && that1.CPUsNrPeriods != nil {
		if *this.CPUsNrPeriods != *that1.CPUsNrPeriods {
			return false
		}
	} else if this.CPUsNrPeriods != nil {
		return false
	} else if that1.CPUsNrPeriods != nil {
		return false
	}
	if this.CPUsNrThrottled != nil && that1.CPUsNrThrottled != nil {
		if *this.CPUsNrThrottled != *that1.CPUsNrThrottled {
			return false
		}
	} else if this.CPUsNrThrottled != nil {
		return false
	} else if that1.CPUsNrThrottled != nil {
		return false
	}
	if this.CPUsThrottledTimeSecs != nil && that1.CPUsThrottledTimeSecs != nil {
		if *this.CPUsThrottledTimeSecs != *that1.CPUsThrottledTimeSecs {
			return false
		}
	} else if this.CPUsThrottledTimeSecs != nil {
		return false
	} else if that1.CPUsThrottledTimeSecs != nil {
		return false
	}
	if this.MemTotalBytes != nil && that1.MemTotalBytes != nil {
		if *this.MemTotalBytes != *that1.MemTotalBytes {
			return false
		}
	} else if this.MemTotalBytes != nil {
		return false
	} else if that1.MemTotalBytes != nil {
		return false
	}
	if this.MemTotalMemswBytes != nil && that1.MemTotalMemswBytes != nil {
		if *this.MemTotalMemswBytes != *that1.MemTotalMemswBytes {
			return false
		}
	} else if this.MemTotalMemswBytes != nil {
		return false
	} else if that1.MemTotalMemswBytes != nil {
		return false
	}
	if this.MemLimitBytes != nil && that1.MemLimitBytes != nil {
		if *this.MemLimitBytes != *that1.MemLimitBytes {
			return false
		}
	} else if this.MemLimitBytes != nil {
		return false
	} else if that1.MemLimitBytes != nil {
		return false
	}
	if this.MemSoftLimitBytes != nil && that1.MemSoftLimitBytes != nil {
		if *this.MemSoftLimitBytes != *that1.MemSoftLimitBytes {
			return false
		}
	} else if this.MemSoftLimitBytes != nil {
		return false
	} else if that1.MemSoftLimitBytes != nil {
		return false
	}
	if this.MemFileBytes != nil && that1.MemFileBytes != nil {
		if *this.MemFileBytes != *that1.MemFileBytes {
			return false
		}
	} else if this.MemFileBytes != nil {
		return false
	} else if that1.MemFileBytes != nil {
		return false
	}
	if this.MemAnonBytes != nil && that1.MemAnonBytes != nil {
		if *this.MemAnonBytes != *that1.MemAnonBytes {
			return false
		}
	} else if this.MemAnonBytes != nil {
		return false
	} else if that1.MemAnonBytes != nil {
		return false
	}
	if this.MemCacheBytes != nil && that1.MemCacheBytes != nil {
		if *this.MemCacheBytes != *that1.MemCacheBytes {
			return false
		}
	} else if this.MemCacheBytes != nil {
		return false
	} else if that1.MemCacheBytes != nil {
		return false
	}
	if this.MemRSSBytes != nil && that1.MemRSSBytes != nil {
		if *this.MemRSSBytes != *that1.MemRSSBytes {
			return false
		}
	} else if this.MemRSSBytes != nil {
		return false
	} else if that1.MemRSSBytes != nil {
		return false
	}
	if this.MemMappedFileBytes != nil && that1.MemMappedFileBytes != nil {
		if *this.MemMappedFileBytes != *that1.MemMappedFileBytes {
			return false
		}
	} else if this.MemMappedFileBytes != nil {
		return false
	} else if that1.MemMappedFileBytes != nil {
		return false
	}
	if this.MemSwapBytes != nil && that1.MemSwapBytes != nil {
		if *this.MemSwapBytes != *that1.MemSwapBytes {
			return false
		}
	} else if this.MemSwapBytes != nil {
		return false
	} else if that1.MemSwapBytes != nil {
		return false
	}
	if this.MemUnevictableBytes != nil && that1.MemUnevictableBytes != nil {
		if *this.MemUnevictableBytes != *that1.MemUnevictableBytes {
			return false
		}
	} else if this.MemUnevictableBytes != nil {
		return false
	} else if that1.MemUnevictableBytes != nil {
		return false
	}
	if this.MemLowPressureCounter != nil && that1.MemLowPressureCounter != nil {
		if *this.MemLowPressureCounter != *that1.MemLowPressureCounter {
			return false
		}
	} else if this.MemLowPressureCounter != nil {
		return false
	} else if that1.MemLowPressureCounter != nil {
		return false
	}
	if this.MemMediumPressureCounter != nil && that1.MemMediumPressureCounter != nil {
		if *this.MemMediumPressureCounter != *that1.MemMediumPressureCounter {
			return false
		}
	} else if this.MemMediumPressureCounter != nil {
		return false
	} else if that1.MemMediumPressureCounter != nil {
		return false
	}
	if this.MemCriticalPressureCounter != nil && that1.MemCriticalPressureCounter != nil {
		if *this.MemCriticalPressureCounter != *that1.MemCriticalPressureCounter {
			return false
		}
	} else if this.MemCriticalPressureCounter != nil {
		return false
	} else if that1.MemCriticalPressureCounter != nil {
		return false
	}
	if this.DiskLimitBytes != nil && that1.DiskLimitBytes != nil {
		if *this.DiskLimitBytes != *that1.DiskLimitBytes {
			return false
		}
	} else if this.DiskLimitBytes != nil {
		return false
	} else if that1.DiskLimitBytes != nil {
		return false
	}
	if this.DiskUsedBytes != nil && that1.DiskUsedBytes != nil {
		if *this.DiskUsedBytes != *that1.DiskUsedBytes {
			return false
		}
	} else if this.DiskUsedBytes != nil {
		return false
	} else if that1.DiskUsedBytes != nil {
		return false
	}
	if len(this.DiskStatistics) != len(that1.DiskStatistics) {
		return false
	}
	for i := range this.DiskStatistics {
		if !this.DiskStatistics[i].Equal(&that1.DiskStatistics[i]) {
			return false
		}
	}
	if !this.BlkioStatistics.Equal(that1.BlkioStatistics) {
		return false
	}
	if !this.Perf.Equal(that1.Perf) {
		return false
	}
	if this.NetRxPackets != nil && that1.NetRxPackets != nil {
		if *this.NetRxPackets != *that1.NetRxPackets {
			return false
		}
	} else if this.NetRxPackets != nil {
		return false
	} else if that1.NetRxPackets != nil {
		return false
	}
	if this.NetRxBytes != nil && that1.NetRxBytes != nil {
		if *this.NetRxBytes != *that1.NetRxBytes {
			return false
		}
	} else if this.NetRxBytes != nil {
		return false
	} else if that1.NetRxBytes != nil {
		return false
	}
	if this.NetRxErrors != nil && that1.NetRxErrors != nil {
		if *this.NetRxErrors != *that1.NetRxErrors {
			return false
		}
	} else if this.NetRxErrors != nil {
		return false
	} else if that1.NetRxErrors != nil {
		return false
	}
	if this.NetRxDropped != nil && that1.NetRxDropped != nil {
		if *this.NetRxDropped != *that1.NetRxDropped {
			return false
		}
	} else if this.NetRxDropped != nil {
		return false
	} else if that1.NetRxDropped != nil {
		return false
	}
	if this.NetTxPackets != nil && that1.NetTxPackets != nil {
		if *this.NetTxPackets != *that1.NetTxPackets {
			return false
		}
	} else if this.NetTxPackets != nil {
		return false
	} else if that1.NetTxPackets != nil {
		return false
	}
	if this.NetTxBytes != nil && that1.NetTxBytes != nil {
		if *this.NetTxBytes != *that1.NetTxBytes {
			return false
		}
	} else if this.NetTxBytes != nil {
		return false
	} else if that1.NetTxBytes != nil {
		return false
	}
	if this.NetTxErrors != nil && that1.NetTxErrors != nil {
		if *this.NetTxErrors != *that1.NetTxErrors {
			return false
		}
	} else if this.NetTxErrors != nil {
		return false
	} else if that1.NetTxErrors != nil {
		return false
	}
	if this.NetTxDropped != nil && that1.NetTxDropped != nil {
		if *this.NetTxDropped != *that1.NetTxDropped {
			return false
		}
	} else if this.NetTxDropped != nil {
		return false
	} else if that1.NetTxDropped != nil {
		return false
	}
	if this.NetTCPRttMicrosecsP50 != nil && that1.NetTCPRttMicrosecsP50 != nil {
		if *this.NetTCPRttMicrosecsP50 != *that1.NetTCPRttMicrosecsP50 {
			return false
		}
	} else if this.NetTCPRttMicrosecsP50 != nil {
		return false
	} else if that1.NetTCPRttMicrosecsP50 != nil {
		return false
	}
	if this.NetTCPRttMicrosecsP90 != nil && that1.NetTCPRttMicrosecsP90 != nil {
		if *this.NetTCPRttMicrosecsP90 != *that1.NetTCPRttMicrosecsP90 {
			return false
		}
	} else if this.NetTCPRttMicrosecsP90 != nil {
		return false
	} else if that1.NetTCPRttMicrosecsP90 != nil {
		return false
	}
	if this.NetTCPRttMicrosecsP95 != nil && that1.NetTCPRttMicrosecsP95 != nil {
		if *this.NetTCPRttMicrosecsP95 != *that1.NetTCPRttMicrosecsP95 {
			return false
		}
	} else if this.NetTCPRttMicrosecsP95 != nil {
		return false
	} else if that1.NetTCPRttMicrosecsP95 != nil {
		return false
	}
	if this.NetTCPRttMicrosecsP99 != nil && that1.NetTCPRttMicrosecsP99 != nil {
		if *this.NetTCPRttMicrosecsP99 != *that1.NetTCPRttMicrosecsP99 {
			return false
		}
	} else if this.NetTCPRttMicrosecsP99 != nil {
		return false
	} else if that1.NetTCPRttMicrosecsP99 != nil {
		return false
	}
	if this.NetTCPActiveConnections != nil && that1.NetTCPActiveConnections != nil {
		if *this.NetTCPActiveConnections != *that1.NetTCPActiveConnections {
			return false
		}
	} else if this.NetTCPActiveConnections != nil {
		return false
	} else if that1.NetTCPActiveConnections != nil {
		return false
	}
	if this.NetTCPTimeWaitConnections != nil && that1.NetTCPTimeWaitConnections != nil {
		if *this.NetTCPTimeWaitConnections != *that1.NetTCPTimeWaitConnections {
			return false
		}
	} else if this.NetTCPTimeWaitConnections != nil {
		return false
	} else if that1.NetTCPTimeWaitConnections != nil {
		return false
	}
	if len(this.NetTrafficControlStatistics) != len(that1.NetTrafficControlStatistics) {
		return false
	}
	for i := range this.NetTrafficControlStatistics {
		if !this.NetTrafficControlStatistics[i].Equal(&that1.NetTrafficControlStatistics[i]) {
			return false
		}
	}
	if !this.NetSNMPStatistics.Equal(that1.NetSNMPStatistics) {
		return false
	}
	return true
}
func (this *ResourceUsage) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceUsage)
	if !ok {
		that2, ok := that.(ResourceUsage)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ResourceUsage")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceUsage but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceUsage but is not nil && this == nil")
	}
	if len(this.Executors) != len(that1.Executors) {
		return fmt.Errorf("Executors this(%v) Not Equal that(%v)", len(this.Executors), len(that1.Executors))
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(&that1.Executors[i]) {
			return fmt.Errorf("Executors this[%v](%v) Not Equal that[%v](%v)", i, this.Executors[i], i, that1.Executors[i])
		}
	}
	if len(this.Total) != len(that1.Total) {
		return fmt.Errorf("Total this(%v) Not Equal that(%v)", len(this.Total), len(that1.Total))
	}
	for i := range this.Total {
		if !this.Total[i].Equal(&that1.Total[i]) {
			return fmt.Errorf("Total this[%v](%v) Not Equal that[%v](%v)", i, this.Total[i], i, that1.Total[i])
		}
	}
	return nil
}
func (this *ResourceUsage) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceUsage)
	if !ok {
		that2, ok := that.(ResourceUsage)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Executors) != len(that1.Executors) {
		return false
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(&that1.Executors[i]) {
			return false
		}
	}
	if len(this.Total) != len(that1.Total) {
		return false
	}
	for i := range this.Total {
		if !this.Total[i].Equal(&that1.Total[i]) {
			return false
		}
	}
	return true
}
func (this *ResourceUsage_Executor) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceUsage_Executor)
	if !ok {
		that2, ok := that.(ResourceUsage_Executor)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ResourceUsage_Executor")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceUsage_Executor but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceUsage_Executor but is not nil && this == nil")
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return fmt.Errorf("ExecutorInfo this(%v) Not Equal that(%v)", this.ExecutorInfo, that1.ExecutorInfo)
	}
	if len(this.Allocated) != len(that1.Allocated) {
		return fmt.Errorf("Allocated this(%v) Not Equal that(%v)", len(this.Allocated), len(that1.Allocated))
	}
	for i := range this.Allocated {
		if !this.Allocated[i].Equal(&that1.Allocated[i]) {
			return fmt.Errorf("Allocated this[%v](%v) Not Equal that[%v](%v)", i, this.Allocated[i], i, that1.Allocated[i])
		}
	}
	if !this.Statistics.Equal(that1.Statistics) {
		return fmt.Errorf("Statistics this(%v) Not Equal that(%v)", this.Statistics, that1.Statistics)
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return fmt.Errorf("Tasks this(%v) Not Equal that(%v)", len(this.Tasks), len(that1.Tasks))
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return fmt.Errorf("Tasks this[%v](%v) Not Equal that[%v](%v)", i, this.Tasks[i], i, that1.Tasks[i])
		}
	}
	return nil
}
func (this *ResourceUsage_Executor) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceUsage_Executor)
	if !ok {
		that2, ok := that.(ResourceUsage_Executor)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return false
	}
	if len(this.Allocated) != len(that1.Allocated) {
		return false
	}
	for i := range this.Allocated {
		if !this.Allocated[i].Equal(&that1.Allocated[i]) {
			return false
		}
	}
	if !this.Statistics.Equal(that1.Statistics) {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return false
		}
	}
	return true
}
func (this *ResourceUsage_Executor_Task) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceUsage_Executor_Task)
	if !ok {
		that2, ok := that.(ResourceUsage_Executor_Task)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ResourceUsage_Executor_Task")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceUsage_Executor_Task but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceUsage_Executor_Task but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.ID.Equal(&that1.ID) {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	return nil
}
func (this *ResourceUsage_Executor_Task) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceUsage_Executor_Task)
	if !ok {
		that2, ok := that.(ResourceUsage_Executor_Task)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.ID.Equal(&that1.ID) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	return true
}
func (this *PerfStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*PerfStatistics)
	if !ok {
		that2, ok := that.(PerfStatistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *PerfStatistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *PerfStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *PerfStatistics but is not nil && this == nil")
	}
	if this.Timestamp != that1.Timestamp {
		return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if this.Duration != that1.Duration {
		return fmt.Errorf("Duration this(%v) Not Equal that(%v)", this.Duration, that1.Duration)
	}
	if this.Cycles != nil && that1.Cycles != nil {
		if *this.Cycles != *that1.Cycles {
			return fmt.Errorf("Cycles this(%v) Not Equal that(%v)", *this.Cycles, *that1.Cycles)
		}
	} else if this.Cycles != nil {
		return fmt.Errorf("this.Cycles == nil && that.Cycles != nil")
	} else if that1.Cycles != nil {
		return fmt.Errorf("Cycles this(%v) Not Equal that(%v)", this.Cycles, that1.Cycles)
	}
	if this.StalledCyclesFrontend != nil && that1.StalledCyclesFrontend != nil {
		if *this.StalledCyclesFrontend != *that1.StalledCyclesFrontend {
			return fmt.Errorf("StalledCyclesFrontend this(%v) Not Equal that(%v)", *this.StalledCyclesFrontend, *that1.StalledCyclesFrontend)
		}
	} else if this.StalledCyclesFrontend != nil {
		return fmt.Errorf("this.StalledCyclesFrontend == nil && that.StalledCyclesFrontend != nil")
	} else if that1.StalledCyclesFrontend != nil {
		return fmt.Errorf("StalledCyclesFrontend this(%v) Not Equal that(%v)", this.StalledCyclesFrontend, that1.StalledCyclesFrontend)
	}
	if this.StalledCyclesBackend != nil && that1.StalledCyclesBackend != nil {
		if *this.StalledCyclesBackend != *that1.StalledCyclesBackend {
			return fmt.Errorf("StalledCyclesBackend this(%v) Not Equal that(%v)", *this.StalledCyclesBackend, *that1.StalledCyclesBackend)
		}
	} else if this.StalledCyclesBackend != nil {
		return fmt.Errorf("this.StalledCyclesBackend == nil && that.StalledCyclesBackend != nil")
	} else if that1.StalledCyclesBackend != nil {
		return fmt.Errorf("StalledCyclesBackend this(%v) Not Equal that(%v)", this.StalledCyclesBackend, that1.StalledCyclesBackend)
	}
	if this.Instructions != nil && that1.Instructions != nil {
		if *this.Instructions != *that1.Instructions {
			return fmt.Errorf("Instructions this(%v) Not Equal that(%v)", *this.Instructions, *that1.Instructions)
		}
	} else if this.Instructions != nil {
		return fmt.Errorf("this.Instructions == nil && that.Instructions != nil")
	} else if that1.Instructions != nil {
		return fmt.Errorf("Instructions this(%v) Not Equal that(%v)", this.Instructions, that1.Instructions)
	}
	if this.CacheReferences != nil && that1.CacheReferences != nil {
		if *this.CacheReferences != *that1.CacheReferences {
			return fmt.Errorf("CacheReferences this(%v) Not Equal that(%v)", *this.CacheReferences, *that1.CacheReferences)
		}
	} else if this.CacheReferences != nil {
		return fmt.Errorf("this.CacheReferences == nil && that.CacheReferences != nil")
	} else if that1.CacheReferences != nil {
		return fmt.Errorf("CacheReferences this(%v) Not Equal that(%v)", this.CacheReferences, that1.CacheReferences)
	}
	if this.CacheMisses != nil && that1.CacheMisses != nil {
		if *this.CacheMisses != *that1.CacheMisses {
			return fmt.Errorf("CacheMisses this(%v) Not Equal that(%v)", *this.CacheMisses, *that1.CacheMisses)
		}
	} else if this.CacheMisses != nil {
		return fmt.Errorf("this.CacheMisses == nil && that.CacheMisses != nil")
	} else if that1.CacheMisses != nil {
		return fmt.Errorf("CacheMisses this(%v) Not Equal that(%v)", this.CacheMisses, that1.CacheMisses)
	}
	if this.Branches != nil && that1.Branches != nil {
		if *this.Branches != *that1.Branches {
			return fmt.Errorf("Branches this(%v) Not Equal that(%v)", *this.Branches, *that1.Branches)
		}
	} else if this.Branches != nil {
		return fmt.Errorf("this.Branches == nil && that.Branches != nil")
	} else if that1.Branches != nil {
		return fmt.Errorf("Branches this(%v) Not Equal that(%v)", this.Branches, that1.Branches)
	}
	if this.BranchMisses != nil && that1.BranchMisses != nil {
		if *this.BranchMisses != *that1.BranchMisses {
			return fmt.Errorf("BranchMisses this(%v) Not Equal that(%v)", *this.BranchMisses, *that1.BranchMisses)
		}
	} else if this.BranchMisses != nil {
		return fmt.Errorf("this.BranchMisses == nil && that.BranchMisses != nil")
	} else if that1.BranchMisses != nil {
		return fmt.Errorf("BranchMisses this(%v) Not Equal that(%v)", this.BranchMisses, that1.BranchMisses)
	}
	if this.BusCycles != nil && that1.BusCycles != nil {
		if *this.BusCycles != *that1.BusCycles {
			return fmt.Errorf("BusCycles this(%v) Not Equal that(%v)", *this.BusCycles, *that1.BusCycles)
		}
	} else if this.BusCycles != nil {
		return fmt.Errorf("this.BusCycles == nil && that.BusCycles != nil")
	} else if that1.BusCycles != nil {
		return fmt.Errorf("BusCycles this(%v) Not Equal that(%v)", this.BusCycles, that1.BusCycles)
	}
	if this.RefCycles != nil && that1.RefCycles != nil {
		if *this.RefCycles != *that1.RefCycles {
			return fmt.Errorf("RefCycles this(%v) Not Equal that(%v)", *this.RefCycles, *that1.RefCycles)
		}
	} else if this.RefCycles != nil {
		return fmt.Errorf("this.RefCycles == nil && that.RefCycles != nil")
	} else if that1.RefCycles != nil {
		return fmt.Errorf("RefCycles this(%v) Not Equal that(%v)", this.RefCycles, that1.RefCycles)
	}
	if this.CPUClock != nil && that1.CPUClock != nil {
		if *this.CPUClock != *that1.CPUClock {
			return fmt.Errorf("CPUClock this(%v) Not Equal that(%v)", *this.CPUClock, *that1.CPUClock)
		}
	} else if this.CPUClock != nil {
		return fmt.Errorf("this.CPUClock == nil && that.CPUClock != nil")
	} else if that1.CPUClock != nil {
		return fmt.Errorf("CPUClock this(%v) Not Equal that(%v)", this.CPUClock, that1.CPUClock)
	}
	if this.TaskClock != nil && that1.TaskClock != nil {
		if *this.TaskClock != *that1.TaskClock {
			return fmt.Errorf("TaskClock this(%v) Not Equal that(%v)", *this.TaskClock, *that1.TaskClock)
		}
	} else if this.TaskClock != nil {
		return fmt.Errorf("this.TaskClock == nil && that.TaskClock != nil")
	} else if that1.TaskClock != nil {
		return fmt.Errorf("TaskClock this(%v) Not Equal that(%v)", this.TaskClock, that1.TaskClock)
	}
	if this.PageFaults != nil && that1.PageFaults != nil {
		if *this.PageFaults != *that1.PageFaults {
			return fmt.Errorf("PageFaults this(%v) Not Equal that(%v)", *this.PageFaults, *that1.PageFaults)
		}
	} else if this.PageFaults != nil {
		return fmt.Errorf("this.PageFaults == nil && that.PageFaults != nil")
	} else if that1.PageFaults != nil {
		return fmt.Errorf("PageFaults this(%v) Not Equal that(%v)", this.PageFaults, that1.PageFaults)
	}
	if this.MinorFaults != nil && that1.MinorFaults != nil {
		if *this.MinorFaults != *that1.MinorFaults {
			return fmt.Errorf("MinorFaults this(%v) Not Equal that(%v)", *this.MinorFaults, *that1.MinorFaults)
		}
	} else if this.MinorFaults != nil {
		return fmt.Errorf("this.MinorFaults == nil && that.MinorFaults != nil")
	} else if that1.MinorFaults != nil {
		return fmt.Errorf("MinorFaults this(%v) Not Equal that(%v)", this.MinorFaults, that1.MinorFaults)
	}
	if this.MajorFaults != nil && that1.MajorFaults != nil {
		if *this.MajorFaults != *that1.MajorFaults {
			return fmt.Errorf("MajorFaults this(%v) Not Equal that(%v)", *this.MajorFaults, *that1.MajorFaults)
		}
	} else if this.MajorFaults != nil {
		return fmt.Errorf("this.MajorFaults == nil && that.MajorFaults != nil")
	} else if that1.MajorFaults != nil {
		return fmt.Errorf("MajorFaults this(%v) Not Equal that(%v)", this.MajorFaults, that1.MajorFaults)
	}
	if this.ContextSwitches != nil && that1.ContextSwitches != nil {
		if *this.ContextSwitches != *that1.ContextSwitches {
			return fmt.Errorf("ContextSwitches this(%v) Not Equal that(%v)", *this.ContextSwitches, *that1.ContextSwitches)
		}
	} else if this.ContextSwitches != nil {
		return fmt.Errorf("this.ContextSwitches == nil && that.ContextSwitches != nil")
	} else if that1.ContextSwitches != nil {
		return fmt.Errorf("ContextSwitches this(%v) Not Equal that(%v)", this.ContextSwitches, that1.ContextSwitches)
	}
	if this.CPUMigrations != nil && that1.CPUMigrations != nil {
		if *this.CPUMigrations != *that1.CPUMigrations {
			return fmt.Errorf("CPUMigrations this(%v) Not Equal that(%v)", *this.CPUMigrations, *that1.CPUMigrations)
		}
	} else if this.CPUMigrations != nil {
		return fmt.Errorf("this.CPUMigrations == nil && that.CPUMigrations != nil")
	} else if that1.CPUMigrations != nil {
		return fmt.Errorf("CPUMigrations this(%v) Not Equal that(%v)", this.CPUMigrations, that1.CPUMigrations)
	}
	if this.AlignmentFaults != nil && that1.AlignmentFaults != nil {
		if *this.AlignmentFaults != *that1.AlignmentFaults {
			return fmt.Errorf("AlignmentFaults this(%v) Not Equal that(%v)", *this.AlignmentFaults, *that1.AlignmentFaults)
		}
	} else if this.AlignmentFaults != nil {
		return fmt.Errorf("this.AlignmentFaults == nil && that.AlignmentFaults != nil")
	} else if that1.AlignmentFaults != nil {
		return fmt.Errorf("AlignmentFaults this(%v) Not Equal that(%v)", this.AlignmentFaults, that1.AlignmentFaults)
	}
	if this.EmulationFaults != nil && that1.EmulationFaults != nil {
		if *this.EmulationFaults != *that1.EmulationFaults {
			return fmt.Errorf("EmulationFaults this(%v) Not Equal that(%v)", *this.EmulationFaults, *that1.EmulationFaults)
		}
	} else if this.EmulationFaults != nil {
		return fmt.Errorf("this.EmulationFaults == nil && that.EmulationFaults != nil")
	} else if that1.EmulationFaults != nil {
		return fmt.Errorf("EmulationFaults this(%v) Not Equal that(%v)", this.EmulationFaults, that1.EmulationFaults)
	}
	if this.L1DcacheLoads != nil && that1.L1DcacheLoads != nil {
		if *this.L1DcacheLoads != *that1.L1DcacheLoads {
			return fmt.Errorf("L1DcacheLoads this(%v) Not Equal that(%v)", *this.L1DcacheLoads, *that1.L1DcacheLoads)
		}
	} else if this.L1DcacheLoads != nil {
		return fmt.Errorf("this.L1DcacheLoads == nil && that.L1DcacheLoads != nil")
	} else if that1.L1DcacheLoads != nil {
		return fmt.Errorf("L1DcacheLoads this(%v) Not Equal that(%v)", this.L1DcacheLoads, that1.L1DcacheLoads)
	}
	if this.L1DcacheLoadMisses != nil && that1.L1DcacheLoadMisses != nil {
		if *this.L1DcacheLoadMisses != *that1.L1DcacheLoadMisses {
			return fmt.Errorf("L1DcacheLoadMisses this(%v) Not Equal that(%v)", *this.L1DcacheLoadMisses, *that1.L1DcacheLoadMisses)
		}
	} else if this.L1DcacheLoadMisses != nil {
		return fmt.Errorf("this.L1DcacheLoadMisses == nil && that.L1DcacheLoadMisses != nil")
	} else if that1.L1DcacheLoadMisses != nil {
		return fmt.Errorf("L1DcacheLoadMisses this(%v) Not Equal that(%v)", this.L1DcacheLoadMisses, that1.L1DcacheLoadMisses)
	}
	if this.L1DcacheStores != nil && that1.L1DcacheStores != nil {
		if *this.L1DcacheStores != *that1.L1DcacheStores {
			return fmt.Errorf("L1DcacheStores this(%v) Not Equal that(%v)", *this.L1DcacheStores, *that1.L1DcacheStores)
		}
	} else if this.L1DcacheStores != nil {
		return fmt.Errorf("this.L1DcacheStores == nil && that.L1DcacheStores != nil")
	} else if that1.L1DcacheStores != nil {
		return fmt.Errorf("L1DcacheStores this(%v) Not Equal that(%v)", this.L1DcacheStores, that1.L1DcacheStores)
	}
	if this.L1DcacheStoreMisses != nil && that1.L1DcacheStoreMisses != nil {
		if *this.L1DcacheStoreMisses != *that1.L1DcacheStoreMisses {
			return fmt.Errorf("L1DcacheStoreMisses this(%v) Not Equal that(%v)", *this.L1DcacheStoreMisses, *that1.L1DcacheStoreMisses)
		}
	} else if this.L1DcacheStoreMisses != nil {
		return fmt.Errorf("this.L1DcacheStoreMisses == nil && that.L1DcacheStoreMisses != nil")
	} else if that1.L1DcacheStoreMisses != nil {
		return fmt.Errorf("L1DcacheStoreMisses this(%v) Not Equal that(%v)", this.L1DcacheStoreMisses, that1.L1DcacheStoreMisses)
	}
	if this.L1DcachePrefetches != nil && that1.L1DcachePrefetches != nil {
		if *this.L1DcachePrefetches != *that1.L1DcachePrefetches {
			return fmt.Errorf("L1DcachePrefetches this(%v) Not Equal that(%v)", *this.L1DcachePrefetches, *that1.L1DcachePrefetches)
		}
	} else if this.L1DcachePrefetches != nil {
		return fmt.Errorf("this.L1DcachePrefetches == nil && that.L1DcachePrefetches != nil")
	} else if that1.L1DcachePrefetches != nil {
		return fmt.Errorf("L1DcachePrefetches this(%v) Not Equal that(%v)", this.L1DcachePrefetches, that1.L1DcachePrefetches)
	}
	if this.L1DcachePrefetchMisses != nil && that1.L1DcachePrefetchMisses != nil {
		if *this.L1DcachePrefetchMisses != *that1.L1DcachePrefetchMisses {
			return fmt.Errorf("L1DcachePrefetchMisses this(%v) Not Equal that(%v)", *this.L1DcachePrefetchMisses, *that1.L1DcachePrefetchMisses)
		}
	} else if this.L1DcachePrefetchMisses != nil {
		return fmt.Errorf("this.L1DcachePrefetchMisses == nil && that.L1DcachePrefetchMisses != nil")
	} else if that1.L1DcachePrefetchMisses != nil {
		return fmt.Errorf("L1DcachePrefetchMisses this(%v) Not Equal that(%v)", this.L1DcachePrefetchMisses, that1.L1DcachePrefetchMisses)
	}
	if this.L1IcacheLoads != nil && that1.L1IcacheLoads != nil {
		if *this.L1IcacheLoads != *that1.L1IcacheLoads {
			return fmt.Errorf("L1IcacheLoads this(%v) Not Equal that(%v)", *this.L1IcacheLoads, *that1.L1IcacheLoads)
		}
	} else if this.L1IcacheLoads != nil {
		return fmt.Errorf("this.L1IcacheLoads == nil && that.L1IcacheLoads != nil")
	} else if that1.L1IcacheLoads != nil {
		return fmt.Errorf("L1IcacheLoads this(%v) Not Equal that(%v)", this.L1IcacheLoads, that1.L1IcacheLoads)
	}
	if this.L1IcacheLoadMisses != nil && that1.L1IcacheLoadMisses != nil {
		if *this.L1IcacheLoadMisses != *that1.L1IcacheLoadMisses {
			return fmt.Errorf("L1IcacheLoadMisses this(%v) Not Equal that(%v)", *this.L1IcacheLoadMisses, *that1.L1IcacheLoadMisses)
		}
	} else if this.L1IcacheLoadMisses != nil {
		return fmt.Errorf("this.L1IcacheLoadMisses == nil && that.L1IcacheLoadMisses != nil")
	} else if that1.L1IcacheLoadMisses != nil {
		return fmt.Errorf("L1IcacheLoadMisses this(%v) Not Equal that(%v)", this.L1IcacheLoadMisses, that1.L1IcacheLoadMisses)
	}
	if this.L1IcachePrefetches != nil && that1.L1IcachePrefetches != nil {
		if *this.L1IcachePrefetches != *that1.L1IcachePrefetches {
			return fmt.Errorf("L1IcachePrefetches this(%v) Not Equal that(%v)", *this.L1IcachePrefetches, *that1.L1IcachePrefetches)
		}
	} else if this.L1IcachePrefetches != nil {
		return fmt.Errorf("this.L1IcachePrefetches == nil && that.L1IcachePrefetches != nil")
	} else if that1.L1IcachePrefetches != nil {
		return fmt.Errorf("L1IcachePrefetches this(%v) Not Equal that(%v)", this.L1IcachePrefetches, that1.L1IcachePrefetches)
	}
	if this.L1IcachePrefetchMisses != nil && that1.L1IcachePrefetchMisses != nil {
		if *this.L1IcachePrefetchMisses != *that1.L1IcachePrefetchMisses {
			return fmt.Errorf("L1IcachePrefetchMisses this(%v) Not Equal that(%v)", *this.L1IcachePrefetchMisses, *that1.L1IcachePrefetchMisses)
		}
	} else if this.L1IcachePrefetchMisses != nil {
		return fmt.Errorf("this.L1IcachePrefetchMisses == nil && that.L1IcachePrefetchMisses != nil")
	} else if that1.L1IcachePrefetchMisses != nil {
		return fmt.Errorf("L1IcachePrefetchMisses this(%v) Not Equal that(%v)", this.L1IcachePrefetchMisses, that1.L1IcachePrefetchMisses)
	}
	if this.LLCLoads != nil && that1.LLCLoads != nil {
		if *this.LLCLoads != *that1.LLCLoads {
			return fmt.Errorf("LLCLoads this(%v) Not Equal that(%v)", *this.LLCLoads, *that1.LLCLoads)
		}
	} else if this.LLCLoads != nil {
		return fmt.Errorf("this.LLCLoads == nil && that.LLCLoads != nil")
	} else if that1.LLCLoads != nil {
		return fmt.Errorf("LLCLoads this(%v) Not Equal that(%v)", this.LLCLoads, that1.LLCLoads)
	}
	if this.LLCLoadMisses != nil && that1.LLCLoadMisses != nil {
		if *this.LLCLoadMisses != *that1.LLCLoadMisses {
			return fmt.Errorf("LLCLoadMisses this(%v) Not Equal that(%v)", *this.LLCLoadMisses, *that1.LLCLoadMisses)
		}
	} else if this.LLCLoadMisses != nil {
		return fmt.Errorf("this.LLCLoadMisses == nil && that.LLCLoadMisses != nil")
	} else if that1.LLCLoadMisses != nil {
		return fmt.Errorf("LLCLoadMisses this(%v) Not Equal that(%v)", this.LLCLoadMisses, that1.LLCLoadMisses)
	}
	if this.LLCStores != nil && that1.LLCStores != nil {
		if *this.LLCStores != *that1.LLCStores {
			return fmt.Errorf("LLCStores this(%v) Not Equal that(%v)", *this.LLCStores, *that1.LLCStores)
		}
	} else if this.LLCStores != nil {
		return fmt.Errorf("this.LLCStores == nil && that.LLCStores != nil")
	} else if that1.LLCStores != nil {
		return fmt.Errorf("LLCStores this(%v) Not Equal that(%v)", this.LLCStores, that1.LLCStores)
	}
	if this.LLCStoreMisses != nil && that1.LLCStoreMisses != nil {
		if *this.LLCStoreMisses != *that1.LLCStoreMisses {
			return fmt.Errorf("LLCStoreMisses this(%v) Not Equal that(%v)", *this.LLCStoreMisses, *that1.LLCStoreMisses)
		}
	} else if this.LLCStoreMisses != nil {
		return fmt.Errorf("this.LLCStoreMisses == nil && that.LLCStoreMisses != nil")
	} else if that1.LLCStoreMisses != nil {
		return fmt.Errorf("LLCStoreMisses this(%v) Not Equal that(%v)", this.LLCStoreMisses, that1.LLCStoreMisses)
	}
	if this.LLCPrefetches != nil && that1.LLCPrefetches != nil {
		if *this.LLCPrefetches != *that1.LLCPrefetches {
			return fmt.Errorf("LLCPrefetches this(%v) Not Equal that(%v)", *this.LLCPrefetches, *that1.LLCPrefetches)
		}
	} else if this.LLCPrefetches != nil {
		return fmt.Errorf("this.LLCPrefetches == nil && that.LLCPrefetches != nil")
	} else if that1.LLCPrefetches != nil {
		return fmt.Errorf("LLCPrefetches this(%v) Not Equal that(%v)", this.LLCPrefetches, that1.LLCPrefetches)
	}
	if this.LLCPrefetchMisses != nil && that1.LLCPrefetchMisses != nil {
		if *this.LLCPrefetchMisses != *that1.LLCPrefetchMisses {
			return fmt.Errorf("LLCPrefetchMisses this(%v) Not Equal that(%v)", *this.LLCPrefetchMisses, *that1.LLCPrefetchMisses)
		}
	} else if this.LLCPrefetchMisses != nil {
		return fmt.Errorf("this.LLCPrefetchMisses == nil && that.LLCPrefetchMisses != nil")
	} else if that1.LLCPrefetchMisses != nil {
		return fmt.Errorf("LLCPrefetchMisses this(%v) Not Equal that(%v)", this.LLCPrefetchMisses, that1.LLCPrefetchMisses)
	}
	if this.DTLBLoads != nil && that1.DTLBLoads != nil {
		if *this.DTLBLoads != *that1.DTLBLoads {
			return fmt.Errorf("DTLBLoads this(%v) Not Equal that(%v)", *this.DTLBLoads, *that1.DTLBLoads)
		}
	} else if this.DTLBLoads != nil {
		return fmt.Errorf("this.DTLBLoads == nil && that.DTLBLoads != nil")
	} else if that1.DTLBLoads != nil {
		return fmt.Errorf("DTLBLoads this(%v) Not Equal that(%v)", this.DTLBLoads, that1.DTLBLoads)
	}
	if this.DTLBLoadMisses != nil && that1.DTLBLoadMisses != nil {
		if *this.DTLBLoadMisses != *that1.DTLBLoadMisses {
			return fmt.Errorf("DTLBLoadMisses this(%v) Not Equal that(%v)", *this.DTLBLoadMisses, *that1.DTLBLoadMisses)
		}
	} else if this.DTLBLoadMisses != nil {
		return fmt.Errorf("this.DTLBLoadMisses == nil && that.DTLBLoadMisses != nil")
	} else if that1.DTLBLoadMisses != nil {
		return fmt.Errorf("DTLBLoadMisses this(%v) Not Equal that(%v)", this.DTLBLoadMisses, that1.DTLBLoadMisses)
	}
	if this.DTLBStores != nil && that1.DTLBStores != nil {
		if *this.DTLBStores != *that1.DTLBStores {
			return fmt.Errorf("DTLBStores this(%v) Not Equal that(%v)", *this.DTLBStores, *that1.DTLBStores)
		}
	} else if this.DTLBStores != nil {
		return fmt.Errorf("this.DTLBStores == nil && that.DTLBStores != nil")
	} else if that1.DTLBStores != nil {
		return fmt.Errorf("DTLBStores this(%v) Not Equal that(%v)", this.DTLBStores, that1.DTLBStores)
	}
	if this.DTLBStoreMisses != nil && that1.DTLBStoreMisses != nil {
		if *this.DTLBStoreMisses != *that1.DTLBStoreMisses {
			return fmt.Errorf("DTLBStoreMisses this(%v) Not Equal that(%v)", *this.DTLBStoreMisses, *that1.DTLBStoreMisses)
		}
	} else if this.DTLBStoreMisses != nil {
		return fmt.Errorf("this.DTLBStoreMisses == nil && that.DTLBStoreMisses != nil")
	} else if that1.DTLBStoreMisses != nil {
		return fmt.Errorf("DTLBStoreMisses this(%v) Not Equal that(%v)", this.DTLBStoreMisses, that1.DTLBStoreMisses)
	}
	if this.DTLBPrefetches != nil && that1.DTLBPrefetches != nil {
		if *this.DTLBPrefetches != *that1.DTLBPrefetches {
			return fmt.Errorf("DTLBPrefetches this(%v) Not Equal that(%v)", *this.DTLBPrefetches, *that1.DTLBPrefetches)
		}
	} else if this.DTLBPrefetches != nil {
		return fmt.Errorf("this.DTLBPrefetches == nil && that.DTLBPrefetches != nil")
	} else if that1.DTLBPrefetches != nil {
		return fmt.Errorf("DTLBPrefetches this(%v) Not Equal that(%v)", this.DTLBPrefetches, that1.DTLBPrefetches)
	}
	if this.DTLBPrefetchMisses != nil && that1.DTLBPrefetchMisses != nil {
		if *this.DTLBPrefetchMisses != *that1.DTLBPrefetchMisses {
			return fmt.Errorf("DTLBPrefetchMisses this(%v) Not Equal that(%v)", *this.DTLBPrefetchMisses, *that1.DTLBPrefetchMisses)
		}
	} else if this.DTLBPrefetchMisses != nil {
		return fmt.Errorf("this.DTLBPrefetchMisses == nil && that.DTLBPrefetchMisses != nil")
	} else if that1.DTLBPrefetchMisses != nil {
		return fmt.Errorf("DTLBPrefetchMisses this(%v) Not Equal that(%v)", this.DTLBPrefetchMisses, that1.DTLBPrefetchMisses)
	}
	if this.ITLBLoads != nil && that1.ITLBLoads != nil {
		if *this.ITLBLoads != *that1.ITLBLoads {
			return fmt.Errorf("ITLBLoads this(%v) Not Equal that(%v)", *this.ITLBLoads, *that1.ITLBLoads)
		}
	} else if this.ITLBLoads != nil {
		return fmt.Errorf("this.ITLBLoads == nil && that.ITLBLoads != nil")
	} else if that1.ITLBLoads != nil {
		return fmt.Errorf("ITLBLoads this(%v) Not Equal that(%v)", this.ITLBLoads, that1.ITLBLoads)
	}
	if this.ITLBLoadMisses != nil && that1.ITLBLoadMisses != nil {
		if *this.ITLBLoadMisses != *that1.ITLBLoadMisses {
			return fmt.Errorf("ITLBLoadMisses this(%v) Not Equal that(%v)", *this.ITLBLoadMisses, *that1.ITLBLoadMisses)
		}
	} else if this.ITLBLoadMisses != nil {
		return fmt.Errorf("this.ITLBLoadMisses == nil && that.ITLBLoadMisses != nil")
	} else if that1.ITLBLoadMisses != nil {
		return fmt.Errorf("ITLBLoadMisses this(%v) Not Equal that(%v)", this.ITLBLoadMisses, that1.ITLBLoadMisses)
	}
	if this.BranchLoads != nil && that1.BranchLoads != nil {
		if *this.BranchLoads != *that1.BranchLoads {
			return fmt.Errorf("BranchLoads this(%v) Not Equal that(%v)", *this.BranchLoads, *that1.BranchLoads)
		}
	} else if this.BranchLoads != nil {
		return fmt.Errorf("this.BranchLoads == nil && that.BranchLoads != nil")
	} else if that1.BranchLoads != nil {
		return fmt.Errorf("BranchLoads this(%v) Not Equal that(%v)", this.BranchLoads, that1.BranchLoads)
	}
	if this.BranchLoadMisses != nil && that1.BranchLoadMisses != nil {
		if *this.BranchLoadMisses != *that1.BranchLoadMisses {
			return fmt.Errorf("BranchLoadMisses this(%v) Not Equal that(%v)", *this.BranchLoadMisses, *that1.BranchLoadMisses)
		}
	} else if this.BranchLoadMisses != nil {
		return fmt.Errorf("this.BranchLoadMisses == nil && that.BranchLoadMisses != nil")
	} else if that1.BranchLoadMisses != nil {
		return fmt.Errorf("BranchLoadMisses this(%v) Not Equal that(%v)", this.BranchLoadMisses, that1.BranchLoadMisses)
	}
	if this.NodeLoads != nil && that1.NodeLoads != nil {
		if *this.NodeLoads != *that1.NodeLoads {
			return fmt.Errorf("NodeLoads this(%v) Not Equal that(%v)", *this.NodeLoads, *that1.NodeLoads)
		}
	} else if this.NodeLoads != nil {
		return fmt.Errorf("this.NodeLoads == nil && that.NodeLoads != nil")
	} else if that1.NodeLoads != nil {
		return fmt.Errorf("NodeLoads this(%v) Not Equal that(%v)", this.NodeLoads, that1.NodeLoads)
	}
	if this.NodeLoadMisses != nil && that1.NodeLoadMisses != nil {
		if *this.NodeLoadMisses != *that1.NodeLoadMisses {
			return fmt.Errorf("NodeLoadMisses this(%v) Not Equal that(%v)", *this.NodeLoadMisses, *that1.NodeLoadMisses)
		}
	} else if this.NodeLoadMisses != nil {
		return fmt.Errorf("this.NodeLoadMisses == nil && that.NodeLoadMisses != nil")
	} else if that1.NodeLoadMisses != nil {
		return fmt.Errorf("NodeLoadMisses this(%v) Not Equal that(%v)", this.NodeLoadMisses, that1.NodeLoadMisses)
	}
	if this.NodeStores != nil && that1.NodeStores != nil {
		if *this.NodeStores != *that1.NodeStores {
			return fmt.Errorf("NodeStores this(%v) Not Equal that(%v)", *this.NodeStores, *that1.NodeStores)
		}
	} else if this.NodeStores != nil {
		return fmt.Errorf("this.NodeStores == nil && that.NodeStores != nil")
	} else if that1.NodeStores != nil {
		return fmt.Errorf("NodeStores this(%v) Not Equal that(%v)", this.NodeStores, that1.NodeStores)
	}
	if this.NodeStoreMisses != nil && that1.NodeStoreMisses != nil {
		if *this.NodeStoreMisses != *that1.NodeStoreMisses {
			return fmt.Errorf("NodeStoreMisses this(%v) Not Equal that(%v)", *this.NodeStoreMisses, *that1.NodeStoreMisses)
		}
	} else if this.NodeStoreMisses != nil {
		return fmt.Errorf("this.NodeStoreMisses == nil && that.NodeStoreMisses != nil")
	} else if that1.NodeStoreMisses != nil {
		return fmt.Errorf("NodeStoreMisses this(%v) Not Equal that(%v)", this.NodeStoreMisses, that1.NodeStoreMisses)
	}
	if this.NodePrefetches != nil && that1.NodePrefetches != nil {
		if *this.NodePrefetches != *that1.NodePrefetches {
			return fmt.Errorf("NodePrefetches this(%v) Not Equal that(%v)", *this.NodePrefetches, *that1.NodePrefetches)
		}
	} else if this.NodePrefetches != nil {
		return fmt.Errorf("this.NodePrefetches == nil && that.NodePrefetches != nil")
	} else if that1.NodePrefetches != nil {
		return fmt.Errorf("NodePrefetches this(%v) Not Equal that(%v)", this.NodePrefetches, that1.NodePrefetches)
	}
	if this.NodePrefetchMisses != nil && that1.NodePrefetchMisses != nil {
		if *this.NodePrefetchMisses != *that1.NodePrefetchMisses {
			return fmt.Errorf("NodePrefetchMisses this(%v) Not Equal that(%v)", *this.NodePrefetchMisses, *that1.NodePrefetchMisses)
		}
	} else if this.NodePrefetchMisses != nil {
		return fmt.Errorf("this.NodePrefetchMisses == nil && that.NodePrefetchMisses != nil")
	} else if that1.NodePrefetchMisses != nil {
		return fmt.Errorf("NodePrefetchMisses this(%v) Not Equal that(%v)", this.NodePrefetchMisses, that1.NodePrefetchMisses)
	}
	return nil
}
func (this *PerfStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*PerfStatistics)
	if !ok {
		that2, ok := that.(PerfStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Timestamp != that1.Timestamp {
		return false
	}
	if this.Duration != that1.Duration {
		return false
	}
	if this.Cycles != nil && that1.Cycles != nil {
		if *this.Cycles != *that1.Cycles {
			return false
		}
	} else if this.Cycles != nil {
		return false
	} else if that1.Cycles != nil {
		return false
	}
	if this.StalledCyclesFrontend != nil && that1.StalledCyclesFrontend != nil {
		if *this.StalledCyclesFrontend != *that1.StalledCyclesFrontend {
			return false
		}
	} else if this.StalledCyclesFrontend != nil {
		return false
	} else if that1.StalledCyclesFrontend != nil {
		return false
	}
	if this.StalledCyclesBackend != nil && that1.StalledCyclesBackend != nil {
		if *this.StalledCyclesBackend != *that1.StalledCyclesBackend {
			return false
		}
	} else if this.StalledCyclesBackend != nil {
		return false
	} else if that1.StalledCyclesBackend != nil {
		return false
	}
	if this.Instructions != nil && that1.Instructions != nil {
		if *this.Instructions != *that1.Instructions {
			return false
		}
	} else if this.Instructions != nil {
		return false
	} else if that1.Instructions != nil {
		return false
	}
	if this.CacheReferences != nil && that1.CacheReferences != nil {
		if *this.CacheReferences != *that1.CacheReferences {
			return false
		}
	} else if this.CacheReferences != nil {
		return false
	} else if that1.CacheReferences != nil {
		return false
	}
	if this.CacheMisses != nil && that1.CacheMisses != nil {
		if *this.CacheMisses != *that1.CacheMisses {
			return false
		}
	} else if this.CacheMisses != nil {
		return false
	} else if that1.CacheMisses != nil {
		return false
	}
	if this.Branches != nil && that1.Branches != nil {
		if *this.Branches != *that1.Branches {
			return false
		}
	} else if this.Branches != nil {
		return false
	} else if that1.Branches != nil {
		return false
	}
	if this.BranchMisses != nil && that1.BranchMisses != nil {
		if *this.BranchMisses != *that1.BranchMisses {
			return false
		}
	} else if this.BranchMisses != nil {
		return false
	} else if that1.BranchMisses != nil {
		return false
	}
	if this.BusCycles != nil && that1.BusCycles != nil {
		if *this.BusCycles != *that1.BusCycles {
			return false
		}
	} else if this.BusCycles != nil {
		return false
	} else if that1.BusCycles != nil {
		return false
	}
	if this.RefCycles != nil && that1.RefCycles != nil {
		if *this.RefCycles != *that1.RefCycles {
			return false
		}
	} else if this.RefCycles != nil {
		return false
	} else if that1.RefCycles != nil {
		return false
	}
	if this.CPUClock != nil && that1.CPUClock != nil {
		if *this.CPUClock != *that1.CPUClock {
			return false
		}
	} else if this.CPUClock != nil {
		return false
	} else if that1.CPUClock != nil {
		return false
	}
	if this.TaskClock != nil && that1.TaskClock != nil {
		if *this.TaskClock != *that1.TaskClock {
			return false
		}
	} else if this.TaskClock != nil {
		return false
	} else if that1.TaskClock != nil {
		return false
	}
	if this.PageFaults != nil && that1.PageFaults != nil {
		if *this.PageFaults != *that1.PageFaults {
			return false
		}
	} else if this.PageFaults != nil {
		return false
	} else if that1.PageFaults != nil {
		return false
	}
	if this.MinorFaults != nil && that1.MinorFaults != nil {
		if *this.MinorFaults != *that1.MinorFaults {
			return false
		}
	} else if this.MinorFaults != nil {
		return false
	} else if that1.MinorFaults != nil {
		return false
	}
	if this.MajorFaults != nil && that1.MajorFaults != nil {
		if *this.MajorFaults != *that1.MajorFaults {
			return false
		}
	} else if this.MajorFaults != nil {
		return false
	} else if that1.MajorFaults != nil {
		return false
	}
	if this.ContextSwitches != nil && that1.ContextSwitches != nil {
		if *this.ContextSwitches != *that1.ContextSwitches {
			return false
		}
	} else if this.ContextSwitches != nil {
		return false
	} else if that1.ContextSwitches != nil {
		return false
	}
	if this.CPUMigrations != nil && that1.CPUMigrations != nil {
		if *this.CPUMigrations != *that1.CPUMigrations {
			return false
		}
	} else if this.CPUMigrations != nil {
		return false
	} else if that1.CPUMigrations != nil {
		return false
	}
	if this.AlignmentFaults != nil && that1.AlignmentFaults != nil {
		if *this.AlignmentFaults != *that1.AlignmentFaults {
			return false
		}
	} else if this.AlignmentFaults != nil {
		return false
	} else if that1.AlignmentFaults != nil {
		return false
	}
	if this.EmulationFaults != nil && that1.EmulationFaults != nil {
		if *this.EmulationFaults != *that1.EmulationFaults {
			return false
		}
	} else if this.EmulationFaults != nil {
		return false
	} else if that1.EmulationFaults != nil {
		return false
	}
	if this.L1DcacheLoads != nil && that1.L1DcacheLoads != nil {
		if *this.L1DcacheLoads != *that1.L1DcacheLoads {
			return false
		}
	} else if this.L1DcacheLoads != nil {
		return false
	} else if that1.L1DcacheLoads != nil {
		return false
	}
	if this.L1DcacheLoadMisses != nil && that1.L1DcacheLoadMisses != nil {
		if *this.L1DcacheLoadMisses != *that1.L1DcacheLoadMisses {
			return false
		}
	} else if this.L1DcacheLoadMisses != nil {
		return false
	} else if that1.L1DcacheLoadMisses != nil {
		return false
	}
	if this.L1DcacheStores != nil && that1.L1DcacheStores != nil {
		if *this.L1DcacheStores != *that1.L1DcacheStores {
			return false
		}
	} else if this.L1DcacheStores != nil {
		return false
	} else if that1.L1DcacheStores != nil {
		return false
	}
	if this.L1DcacheStoreMisses != nil && that1.L1DcacheStoreMisses != nil {
		if *this.L1DcacheStoreMisses != *that1.L1DcacheStoreMisses {
			return false
		}
	} else if this.L1DcacheStoreMisses != nil {
		return false
	} else if that1.L1DcacheStoreMisses != nil {
		return false
	}
	if this.L1DcachePrefetches != nil && that1.L1DcachePrefetches != nil {
		if *this.L1DcachePrefetches != *that1.L1DcachePrefetches {
			return false
		}
	} else if this.L1DcachePrefetches != nil {
		return false
	} else if that1.L1DcachePrefetches != nil {
		return false
	}
	if this.L1DcachePrefetchMisses != nil && that1.L1DcachePrefetchMisses != nil {
		if *this.L1DcachePrefetchMisses != *that1.L1DcachePrefetchMisses {
			return false
		}
	} else if this.L1DcachePrefetchMisses != nil {
		return false
	} else if that1.L1DcachePrefetchMisses != nil {
		return false
	}
	if this.L1IcacheLoads != nil && that1.L1IcacheLoads != nil {
		if *this.L1IcacheLoads != *that1.L1IcacheLoads {
			return false
		}
	} else if this.L1IcacheLoads != nil {
		return false
	} else if that1.L1IcacheLoads != nil {
		return false
	}
	if this.L1IcacheLoadMisses != nil && that1.L1IcacheLoadMisses != nil {
		if *this.L1IcacheLoadMisses != *that1.L1IcacheLoadMisses {
			return false
		}
	} else if this.L1IcacheLoadMisses != nil {
		return false
	} else if that1.L1IcacheLoadMisses != nil {
		return false
	}
	if this.L1IcachePrefetches != nil && that1.L1IcachePrefetches != nil {
		if *this.L1IcachePrefetches != *that1.L1IcachePrefetches {
			return false
		}
	} else if this.L1IcachePrefetches != nil {
		return false
	} else if that1.L1IcachePrefetches != nil {
		return false
	}
	if this.L1IcachePrefetchMisses != nil && that1.L1IcachePrefetchMisses != nil {
		if *this.L1IcachePrefetchMisses != *that1.L1IcachePrefetchMisses {
			return false
		}
	} else if this.L1IcachePrefetchMisses != nil {
		return false
	} else if that1.L1IcachePrefetchMisses != nil {
		return false
	}
	if this.LLCLoads != nil && that1.LLCLoads != nil {
		if *this.LLCLoads != *that1.LLCLoads {
			return false
		}
	} else if this.LLCLoads != nil {
		return false
	} else if that1.LLCLoads != nil {
		return false
	}
	if this.LLCLoadMisses != nil && that1.LLCLoadMisses != nil {
		if *this.LLCLoadMisses != *that1.LLCLoadMisses {
			return false
		}
	} else if this.LLCLoadMisses != nil {
		return false
	} else if that1.LLCLoadMisses != nil {
		return false
	}
	if this.LLCStores != nil && that1.LLCStores != nil {
		if *this.LLCStores != *that1.LLCStores {
			return false
		}
	} else if this.LLCStores != nil {
		return false
	} else if that1.LLCStores != nil {
		return false
	}
	if this.LLCStoreMisses != nil && that1.LLCStoreMisses != nil {
		if *this.LLCStoreMisses != *that1.LLCStoreMisses {
			return false
		}
	} else if this.LLCStoreMisses != nil {
		return false
	} else if that1.LLCStoreMisses != nil {
		return false
	}
	if this.LLCPrefetches != nil && that1.LLCPrefetches != nil {
		if *this.LLCPrefetches != *that1.LLCPrefetches {
			return false
		}
	} else if this.LLCPrefetches != nil {
		return false
	} else if that1.LLCPrefetches != nil {
		return false
	}
	if this.LLCPrefetchMisses != nil && that1.LLCPrefetchMisses != nil {
		if *this.LLCPrefetchMisses != *that1.LLCPrefetchMisses {
			return false
		}
	} else if this.LLCPrefetchMisses != nil {
		return false
	} else if that1.LLCPrefetchMisses != nil {
		return false
	}
	if this.DTLBLoads != nil && that1.DTLBLoads != nil {
		if *this.DTLBLoads != *that1.DTLBLoads {
			return false
		}
	} else if this.DTLBLoads != nil {
		return false
	} else if that1.DTLBLoads != nil {
		return false
	}
	if this.DTLBLoadMisses != nil && that1.DTLBLoadMisses != nil {
		if *this.DTLBLoadMisses != *that1.DTLBLoadMisses {
			return false
		}
	} else if this.DTLBLoadMisses != nil {
		return false
	} else if that1.DTLBLoadMisses != nil {
		return false
	}
	if this.DTLBStores != nil && that1.DTLBStores != nil {
		if *this.DTLBStores != *that1.DTLBStores {
			return false
		}
	} else if this.DTLBStores != nil {
		return false
	} else if that1.DTLBStores != nil {
		return false
	}
	if this.DTLBStoreMisses != nil && that1.DTLBStoreMisses != nil {
		if *this.DTLBStoreMisses != *that1.DTLBStoreMisses {
			return false
		}
	} else if this.DTLBStoreMisses != nil {
		return false
	} else if that1.DTLBStoreMisses != nil {
		return false
	}
	if this.DTLBPrefetches != nil && that1.DTLBPrefetches != nil {
		if *this.DTLBPrefetches != *that1.DTLBPrefetches {
			return false
		}
	} else if this.DTLBPrefetches != nil {
		return false
	} else if that1.DTLBPrefetches != nil {
		return false
	}
	if this.DTLBPrefetchMisses != nil && that1.DTLBPrefetchMisses != nil {
		if *this.DTLBPrefetchMisses != *that1.DTLBPrefetchMisses {
			return false
		}
	} else if this.DTLBPrefetchMisses != nil {
		return false
	} else if that1.DTLBPrefetchMisses != nil {
		return false
	}
	if this.ITLBLoads != nil && that1.ITLBLoads != nil {
		if *this.ITLBLoads != *that1.ITLBLoads {
			return false
		}
	} else if this.ITLBLoads != nil {
		return false
	} else if that1.ITLBLoads != nil {
		return false
	}
	if this.ITLBLoadMisses != nil && that1.ITLBLoadMisses != nil {
		if *this.ITLBLoadMisses != *that1.ITLBLoadMisses {
			return false
		}
	} else if this.ITLBLoadMisses != nil {
		return false
	} else if that1.ITLBLoadMisses != nil {
		return false
	}
	if this.BranchLoads != nil && that1.BranchLoads != nil {
		if *this.BranchLoads != *that1.BranchLoads {
			return false
		}
	} else if this.BranchLoads != nil {
		return false
	} else if that1.BranchLoads != nil {
		return false
	}
	if this.BranchLoadMisses != nil && that1.BranchLoadMisses != nil {
		if *this.BranchLoadMisses != *that1.BranchLoadMisses {
			return false
		}
	} else if this.BranchLoadMisses != nil {
		return false
	} else if that1.BranchLoadMisses != nil {
		return false
	}
	if this.NodeLoads != nil && that1.NodeLoads != nil {
		if *this.NodeLoads != *that1.NodeLoads {
			return false
		}
	} else if this.NodeLoads != nil {
		return false
	} else if that1.NodeLoads != nil {
		return false
	}
	if this.NodeLoadMisses != nil && that1.NodeLoadMisses != nil {
		if *this.NodeLoadMisses != *that1.NodeLoadMisses {
			return false
		}
	} else if this.NodeLoadMisses != nil {
		return false
	} else if that1.NodeLoadMisses != nil {
		return false
	}
	if this.NodeStores != nil && that1.NodeStores != nil {
		if *this.NodeStores != *that1.NodeStores {
			return false
		}
	} else if this.NodeStores != nil {
		return false
	} else if that1.NodeStores != nil {
		return false
	}
	if this.NodeStoreMisses != nil && that1.NodeStoreMisses != nil {
		if *this.NodeStoreMisses != *that1.NodeStoreMisses {
			return false
		}
	} else if this.NodeStoreMisses != nil {
		return false
	} else if that1.NodeStoreMisses != nil {
		return false
	}
	if this.NodePrefetches != nil && that1.NodePrefetches != nil {
		if *this.NodePrefetches != *that1.NodePrefetches {
			return false
		}
	} else if this.NodePrefetches != nil {
		return false
	} else if that1.NodePrefetches != nil {
		return false
	}
	if this.NodePrefetchMisses != nil && that1.NodePrefetchMisses != nil {
		if *this.NodePrefetchMisses != *that1.NodePrefetchMisses {
			return false
		}
	} else if this.NodePrefetchMisses != nil {
		return false
	} else if that1.NodePrefetchMisses != nil {
		return false
	}
	return true
}
func (this *Request) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Request)
	if !ok {
		that2, ok := that.(Request)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Request")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Request but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Request but is not nil && this == nil")
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *Request) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Request)
	if !ok {
		that2, ok := that.(Request)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *Offer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer)
	if !ok {
		that2, ok := that.(Offer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer but is not nil && this == nil")
	}
	if !this.ID.Equal(&that1.ID) {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if this.Hostname != that1.Hostname {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if !this.URL.Equal(that1.URL) {
		return fmt.Errorf("URL this(%v) Not Equal that(%v)", this.URL, that1.URL)
	}
	if !this.Domain.Equal(that1.Domain) {
		return fmt.Errorf("Domain this(%v) Not Equal that(%v)", this.Domain, that1.Domain)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return fmt.Errorf("Attributes this(%v) Not Equal that(%v)", len(this.Attributes), len(that1.Attributes))
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(&that1.Attributes[i]) {
			return fmt.Errorf("Attributes this[%v](%v) Not Equal that[%v](%v)", i, this.Attributes[i], i, that1.Attributes[i])
		}
	}
	if len(this.ExecutorIDs) != len(that1.ExecutorIDs) {
		return fmt.Errorf("ExecutorIDs this(%v) Not Equal that(%v)", len(this.ExecutorIDs), len(that1.ExecutorIDs))
	}
	for i := range this.ExecutorIDs {
		if !this.ExecutorIDs[i].Equal(&that1.ExecutorIDs[i]) {
			return fmt.Errorf("ExecutorIDs this[%v](%v) Not Equal that[%v](%v)", i, this.ExecutorIDs[i], i, that1.ExecutorIDs[i])
		}
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return fmt.Errorf("Unavailability this(%v) Not Equal that(%v)", this.Unavailability, that1.Unavailability)
	}
	if !this.AllocationInfo.Equal(that1.AllocationInfo) {
		return fmt.Errorf("AllocationInfo this(%v) Not Equal that(%v)", this.AllocationInfo, that1.AllocationInfo)
	}
	return nil
}
func (this *Offer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer)
	if !ok {
		that2, ok := that.(Offer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ID.Equal(&that1.ID) {
		return false
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if this.Hostname != that1.Hostname {
		return false
	}
	if !this.URL.Equal(that1.URL) {
		return false
	}
	if !this.Domain.Equal(that1.Domain) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(&that1.Attributes[i]) {
			return false
		}
	}
	if len(this.ExecutorIDs) != len(that1.ExecutorIDs) {
		return false
	}
	for i := range this.ExecutorIDs {
		if !this.ExecutorIDs[i].Equal(&that1.ExecutorIDs[i]) {
			return false
		}
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return false
	}
	if !this.AllocationInfo.Equal(that1.AllocationInfo) {
		return false
	}
	return true
}
func (this *Offer_Operation) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation)
	if !ok {
		that2, ok := that.(Offer_Operation)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.ID.Equal(that1.ID) {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if !this.Launch.Equal(that1.Launch) {
		return fmt.Errorf("Launch this(%v) Not Equal that(%v)", this.Launch, that1.Launch)
	}
	if !this.LaunchGroup.Equal(that1.LaunchGroup) {
		return fmt.Errorf("LaunchGroup this(%v) Not Equal that(%v)", this.LaunchGroup, that1.LaunchGroup)
	}
	if !this.Reserve.Equal(that1.Reserve) {
		return fmt.Errorf("Reserve this(%v) Not Equal that(%v)", this.Reserve, that1.Reserve)
	}
	if !this.Unreserve.Equal(that1.Unreserve) {
		return fmt.Errorf("Unreserve this(%v) Not Equal that(%v)", this.Unreserve, that1.Unreserve)
	}
	if !this.Create.Equal(that1.Create) {
		return fmt.Errorf("Create this(%v) Not Equal that(%v)", this.Create, that1.Create)
	}
	if !this.Destroy.Equal(that1.Destroy) {
		return fmt.Errorf("Destroy this(%v) Not Equal that(%v)", this.Destroy, that1.Destroy)
	}
	if !this.CreateVolume.Equal(that1.CreateVolume) {
		return fmt.Errorf("CreateVolume this(%v) Not Equal that(%v)", this.CreateVolume, that1.CreateVolume)
	}
	if !this.DestroyVolume.Equal(that1.DestroyVolume) {
		return fmt.Errorf("DestroyVolume this(%v) Not Equal that(%v)", this.DestroyVolume, that1.DestroyVolume)
	}
	if !this.CreateBlock.Equal(that1.CreateBlock) {
		return fmt.Errorf("CreateBlock this(%v) Not Equal that(%v)", this.CreateBlock, that1.CreateBlock)
	}
	if !this.DestroyBlock.Equal(that1.DestroyBlock) {
		return fmt.Errorf("DestroyBlock this(%v) Not Equal that(%v)", this.DestroyBlock, that1.DestroyBlock)
	}
	return nil
}
func (this *Offer_Operation) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation)
	if !ok {
		that2, ok := that.(Offer_Operation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.ID.Equal(that1.ID) {
		return false
	}
	if !this.Launch.Equal(that1.Launch) {
		return false
	}
	if !this.LaunchGroup.Equal(that1.LaunchGroup) {
		return false
	}
	if !this.Reserve.Equal(that1.Reserve) {
		return false
	}
	if !this.Unreserve.Equal(that1.Unreserve) {
		return false
	}
	if !this.Create.Equal(that1.Create) {
		return false
	}
	if !this.Destroy.Equal(that1.Destroy) {
		return false
	}
	if !this.CreateVolume.Equal(that1.CreateVolume) {
		return false
	}
	if !this.DestroyVolume.Equal(that1.DestroyVolume) {
		return false
	}
	if !this.CreateBlock.Equal(that1.CreateBlock) {
		return false
	}
	if !this.DestroyBlock.Equal(that1.DestroyBlock) {
		return false
	}
	return true
}
func (this *Offer_Operation_Launch) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Launch)
	if !ok {
		that2, ok := that.(Offer_Operation_Launch)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_Launch")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Launch but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Launch but is not nil && this == nil")
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return fmt.Errorf("TaskInfos this(%v) Not Equal that(%v)", len(this.TaskInfos), len(that1.TaskInfos))
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(&that1.TaskInfos[i]) {
			return fmt.Errorf("TaskInfos this[%v](%v) Not Equal that[%v](%v)", i, this.TaskInfos[i], i, that1.TaskInfos[i])
		}
	}
	return nil
}
func (this *Offer_Operation_Launch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Launch)
	if !ok {
		that2, ok := that.(Offer_Operation_Launch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return false
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(&that1.TaskInfos[i]) {
			return false
		}
	}
	return true
}
func (this *Offer_Operation_LaunchGroup) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_LaunchGroup)
	if !ok {
		that2, ok := that.(Offer_Operation_LaunchGroup)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_LaunchGroup")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_LaunchGroup but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_LaunchGroup but is not nil && this == nil")
	}
	if !this.Executor.Equal(&that1.Executor) {
		return fmt.Errorf("Executor this(%v) Not Equal that(%v)", this.Executor, that1.Executor)
	}
	if !this.TaskGroup.Equal(&that1.TaskGroup) {
		return fmt.Errorf("TaskGroup this(%v) Not Equal that(%v)", this.TaskGroup, that1.TaskGroup)
	}
	return nil
}
func (this *Offer_Operation_LaunchGroup) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_LaunchGroup)
	if !ok {
		that2, ok := that.(Offer_Operation_LaunchGroup)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Executor.Equal(&that1.Executor) {
		return false
	}
	if !this.TaskGroup.Equal(&that1.TaskGroup) {
		return false
	}
	return true
}
func (this *Offer_Operation_Reserve) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Reserve)
	if !ok {
		that2, ok := that.(Offer_Operation_Reserve)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_Reserve")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Reserve but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Reserve but is not nil && this == nil")
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *Offer_Operation_Reserve) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Reserve)
	if !ok {
		that2, ok := that.(Offer_Operation_Reserve)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *Offer_Operation_Unreserve) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Unreserve)
	if !ok {
		that2, ok := that.(Offer_Operation_Unreserve)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_Unreserve")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Unreserve but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Unreserve but is not nil && this == nil")
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *Offer_Operation_Unreserve) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Unreserve)
	if !ok {
		that2, ok := that.(Offer_Operation_Unreserve)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *Offer_Operation_Create) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Create)
	if !ok {
		that2, ok := that.(Offer_Operation_Create)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_Create")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Create but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Create but is not nil && this == nil")
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	return nil
}
func (this *Offer_Operation_Create) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Create)
	if !ok {
		that2, ok := that.(Offer_Operation_Create)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return false
		}
	}
	return true
}
func (this *Offer_Operation_Destroy) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Destroy)
	if !ok {
		that2, ok := that.(Offer_Operation_Destroy)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_Destroy")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Destroy but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Destroy but is not nil && this == nil")
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	return nil
}
func (this *Offer_Operation_Destroy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Destroy)
	if !ok {
		that2, ok := that.(Offer_Operation_Destroy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return false
		}
	}
	return true
}
func (this *Offer_Operation_CreateVolume) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_CreateVolume)
	if !ok {
		that2, ok := that.(Offer_Operation_CreateVolume)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_CreateVolume")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_CreateVolume but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_CreateVolume but is not nil && this == nil")
	}
	if !this.Source.Equal(&that1.Source) {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if this.TargetType != that1.TargetType {
		return fmt.Errorf("TargetType this(%v) Not Equal that(%v)", this.TargetType, that1.TargetType)
	}
	return nil
}
func (this *Offer_Operation_CreateVolume) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_CreateVolume)
	if !ok {
		that2, ok := that.(Offer_Operation_CreateVolume)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Source.Equal(&that1.Source) {
		return false
	}
	if this.TargetType != that1.TargetType {
		return false
	}
	return true
}
func (this *Offer_Operation_DestroyVolume) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_DestroyVolume)
	if !ok {
		that2, ok := that.(Offer_Operation_DestroyVolume)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_DestroyVolume")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_DestroyVolume but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_DestroyVolume but is not nil && this == nil")
	}
	if !this.Volume.Equal(&that1.Volume) {
		return fmt.Errorf("Volume this(%v) Not Equal that(%v)", this.Volume, that1.Volume)
	}
	return nil
}
func (this *Offer_Operation_DestroyVolume) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_DestroyVolume)
	if !ok {
		that2, ok := that.(Offer_Operation_DestroyVolume)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Volume.Equal(&that1.Volume) {
		return false
	}
	return true
}
func (this *Offer_Operation_CreateBlock) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_CreateBlock)
	if !ok {
		that2, ok := that.(Offer_Operation_CreateBlock)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_CreateBlock")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_CreateBlock but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_CreateBlock but is not nil && this == nil")
	}
	if !this.Source.Equal(&that1.Source) {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	return nil
}
func (this *Offer_Operation_CreateBlock) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_CreateBlock)
	if !ok {
		that2, ok := that.(Offer_Operation_CreateBlock)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Source.Equal(&that1.Source) {
		return false
	}
	return true
}
func (this *Offer_Operation_DestroyBlock) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_DestroyBlock)
	if !ok {
		that2, ok := that.(Offer_Operation_DestroyBlock)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Offer_Operation_DestroyBlock")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_DestroyBlock but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_DestroyBlock but is not nil && this == nil")
	}
	if !this.Block.Equal(&that1.Block) {
		return fmt.Errorf("Block this(%v) Not Equal that(%v)", this.Block, that1.Block)
	}
	return nil
}
func (this *Offer_Operation_DestroyBlock) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_DestroyBlock)
	if !ok {
		that2, ok := that.(Offer_Operation_DestroyBlock)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Block.Equal(&that1.Block) {
		return false
	}
	return true
}
func (this *InverseOffer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*InverseOffer)
	if !ok {
		that2, ok := that.(InverseOffer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *InverseOffer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *InverseOffer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *InverseOffer but is not nil && this == nil")
	}
	if !this.OfferID.Equal(&that1.OfferID) {
		return fmt.Errorf("OfferID this(%v) Not Equal that(%v)", this.OfferID, that1.OfferID)
	}
	if !this.URL.Equal(that1.URL) {
		return fmt.Errorf("URL this(%v) Not Equal that(%v)", this.URL, that1.URL)
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.Unavailability.Equal(&that1.Unavailability) {
		return fmt.Errorf("Unavailability this(%v) Not Equal that(%v)", this.Unavailability, that1.Unavailability)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *InverseOffer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*InverseOffer)
	if !ok {
		that2, ok := that.(InverseOffer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.OfferID.Equal(&that1.OfferID) {
		return false
	}
	if !this.URL.Equal(that1.URL) {
		return false
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if !this.Unavailability.Equal(&that1.Unavailability) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *TaskInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskInfo)
	if !ok {
		that2, ok := that.(TaskInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TaskInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskInfo but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !this.Executor.Equal(that1.Executor) {
		return fmt.Errorf("Executor this(%v) Not Equal that(%v)", this.Executor, that1.Executor)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if !this.HealthCheck.Equal(that1.HealthCheck) {
		return fmt.Errorf("HealthCheck this(%v) Not Equal that(%v)", this.HealthCheck, that1.HealthCheck)
	}
	if !this.Check.Equal(that1.Check) {
		return fmt.Errorf("Check this(%v) Not Equal that(%v)", this.Check, that1.Check)
	}
	if !this.KillPolicy.Equal(that1.KillPolicy) {
		return fmt.Errorf("KillPolicy this(%v) Not Equal that(%v)", this.KillPolicy, that1.KillPolicy)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return fmt.Errorf("Discovery this(%v) Not Equal that(%v)", this.Discovery, that1.Discovery)
	}
	return nil
}
func (this *TaskInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskInfo)
	if !ok {
		that2, ok := that.(TaskInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if !this.Executor.Equal(that1.Executor) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if !this.HealthCheck.Equal(that1.HealthCheck) {
		return false
	}
	if !this.Check.Equal(that1.Check) {
		return false
	}
	if !this.KillPolicy.Equal(that1.KillPolicy) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return false
	}
	return true
}
func (this *TaskGroupInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskGroupInfo)
	if !ok {
		that2, ok := that.(TaskGroupInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TaskGroupInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskGroupInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskGroupInfo but is not nil && this == nil")
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return fmt.Errorf("Tasks this(%v) Not Equal that(%v)", len(this.Tasks), len(that1.Tasks))
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return fmt.Errorf("Tasks this[%v](%v) Not Equal that[%v](%v)", i, this.Tasks[i], i, that1.Tasks[i])
		}
	}
	return nil
}
func (this *TaskGroupInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskGroupInfo)
	if !ok {
		that2, ok := that.(TaskGroupInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Tasks) != len(that1.Tasks) {
		return false
	}
	for i := range this.Tasks {
		if !this.Tasks[i].Equal(&that1.Tasks[i]) {
			return false
		}
	}
	return true
}
func (this *Task) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Task)
	if !ok {
		that2, ok := that.(Task)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Task")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Task but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Task but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if !this.ExecutorID.Equal(that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return fmt.Errorf("State this(%v) Not Equal that(%v)", *this.State, *that1.State)
		}
	} else if this.State != nil {
		return fmt.Errorf("this.State == nil && that.State != nil")
	} else if that1.State != nil {
		return fmt.Errorf("State this(%v) Not Equal that(%v)", this.State, that1.State)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return fmt.Errorf("Statuses this(%v) Not Equal that(%v)", len(this.Statuses), len(that1.Statuses))
	}
	for i := range this.Statuses {
		if !this.Statuses[i].Equal(&that1.Statuses[i]) {
			return fmt.Errorf("Statuses this[%v](%v) Not Equal that[%v](%v)", i, this.Statuses[i], i, that1.Statuses[i])
		}
	}
	if this.StatusUpdateState != nil && that1.StatusUpdateState != nil {
		if *this.StatusUpdateState != *that1.StatusUpdateState {
			return fmt.Errorf("StatusUpdateState this(%v) Not Equal that(%v)", *this.StatusUpdateState, *that1.StatusUpdateState)
		}
	} else if this.StatusUpdateState != nil {
		return fmt.Errorf("this.StatusUpdateState == nil && that.StatusUpdateState != nil")
	} else if that1.StatusUpdateState != nil {
		return fmt.Errorf("StatusUpdateState this(%v) Not Equal that(%v)", this.StatusUpdateState, that1.StatusUpdateState)
	}
	if !bytes.Equal(this.StatusUpdateUUID, that1.StatusUpdateUUID) {
		return fmt.Errorf("StatusUpdateUUID this(%v) Not Equal that(%v)", this.StatusUpdateUUID, that1.StatusUpdateUUID)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return fmt.Errorf("Discovery this(%v) Not Equal that(%v)", this.Discovery, that1.Discovery)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return fmt.Errorf("User this(%v) Not Equal that(%v)", *this.User, *that1.User)
		}
	} else if this.User != nil {
		return fmt.Errorf("this.User == nil && that.User != nil")
	} else if that1.User != nil {
		return fmt.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	return nil
}
func (this *Task) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Task)
	if !ok {
		that2, ok := that.(Task)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return false
	}
	if !this.ExecutorID.Equal(that1.ExecutorID) {
		return false
	}
	if !this.AgentID.Equal(&that1.AgentID) {
		return false
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return false
		}
	} else if this.State != nil {
		return false
	} else if that1.State != nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return false
	}
	for i := range this.Statuses {
		if !this.Statuses[i].Equal(&that1.Statuses[i]) {
			return false
		}
	}
	if this.StatusUpdateState != nil && that1.StatusUpdateState != nil {
		if *this.StatusUpdateState != *that1.StatusUpdateState {
			return false
		}
	} else if this.StatusUpdateState != nil {
		return false
	} else if that1.StatusUpdateState != nil {
		return false
	}
	if !bytes.Equal(this.StatusUpdateUUID, that1.StatusUpdateUUID) {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return false
		}
	} else if this.User != nil {
		return false
	} else if that1.User != nil {
		return false
	}
	return true
}
func (this *TaskResourceLimitation) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskResourceLimitation)
	if !ok {
		that2, ok := that.(TaskResourceLimitation)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TaskResourceLimitation")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskResourceLimitation but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskResourceLimitation but is not nil && this == nil")
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *TaskResourceLimitation) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskResourceLimitation)
	if !ok {
		that2, ok := that.(TaskResourceLimitation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *UUID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*UUID)
	if !ok {
		that2, ok := that.(UUID)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *UUID")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *UUID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *UUID but is not nil && this == nil")
	}
	if !bytes.Equal(this.Value, that1.Value) {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *UUID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*UUID)
	if !ok {
		that2, ok := that.(UUID)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Value, that1.Value) {
		return false
	}
	return true
}
func (this *Operation) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Operation)
	if !ok {
		that2, ok := that.(Operation)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Operation")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Operation but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Operation but is not nil && this == nil")
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.Info.Equal(&that1.Info) {
		return fmt.Errorf("Info this(%v) Not Equal that(%v)", this.Info, that1.Info)
	}
	if !this.LatestStatus.Equal(&that1.LatestStatus) {
		return fmt.Errorf("LatestStatus this(%v) Not Equal that(%v)", this.LatestStatus, that1.LatestStatus)
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return fmt.Errorf("Statuses this(%v) Not Equal that(%v)", len(this.Statuses), len(that1.Statuses))
	}
	for i := range this.Statuses {
		if !this.Statuses[i].Equal(&that1.Statuses[i]) {
			return fmt.Errorf("Statuses this[%v](%v) Not Equal that[%v](%v)", i, this.Statuses[i], i, that1.Statuses[i])
		}
	}
	if !this.UUID.Equal(&that1.UUID) {
		return fmt.Errorf("UUID this(%v) Not Equal that(%v)", this.UUID, that1.UUID)
	}
	return nil
}
func (this *Operation) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Operation)
	if !ok {
		that2, ok := that.(Operation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkID.Equal(that1.FrameworkID) {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if !this.Info.Equal(&that1.Info) {
		return false
	}
	if !this.LatestStatus.Equal(&that1.LatestStatus) {
		return false
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return false
	}
	for i := range this.Statuses {
		if !this.Statuses[i].Equal(&that1.Statuses[i]) {
			return false
		}
	}
	if !this.UUID.Equal(&that1.UUID) {
		return false
	}
	return true
}
func (this *OperationStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*OperationStatus)
	if !ok {
		that2, ok := that.(OperationStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *OperationStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *OperationStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *OperationStatus but is not nil && this == nil")
	}
	if !this.OperationID.Equal(that1.OperationID) {
		return fmt.Errorf("OperationID this(%v) Not Equal that(%v)", this.OperationID, that1.OperationID)
	}
	if this.State != that1.State {
		return fmt.Errorf("State this(%v) Not Equal that(%v)", this.State, that1.State)
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return fmt.Errorf("Message this(%v) Not Equal that(%v)", *this.Message, *that1.Message)
		}
	} else if this.Message != nil {
		return fmt.Errorf("this.Message == nil && that.Message != nil")
	} else if that1.Message != nil {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if len(this.ConvertedResources) != len(that1.ConvertedResources) {
		return fmt.Errorf("ConvertedResources this(%v) Not Equal that(%v)", len(this.ConvertedResources), len(that1.ConvertedResources))
	}
	for i := range this.ConvertedResources {
		if !this.ConvertedResources[i].Equal(&that1.ConvertedResources[i]) {
			return fmt.Errorf("ConvertedResources this[%v](%v) Not Equal that[%v](%v)", i, this.ConvertedResources[i], i, that1.ConvertedResources[i])
		}
	}
	if !this.UUID.Equal(that1.UUID) {
		return fmt.Errorf("UUID this(%v) Not Equal that(%v)", this.UUID, that1.UUID)
	}
	return nil
}
func (this *OperationStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*OperationStatus)
	if !ok {
		that2, ok := that.(OperationStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.OperationID.Equal(that1.OperationID) {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return false
		}
	} else if this.Message != nil {
		return false
	} else if that1.Message != nil {
		return false
	}
	if len(this.ConvertedResources) != len(that1.ConvertedResources) {
		return false
	}
	for i := range this.ConvertedResources {
		if !this.ConvertedResources[i].Equal(&that1.ConvertedResources[i]) {
			return false
		}
	}
	if !this.UUID.Equal(that1.UUID) {
		return false
	}
	return true
}
func (this *CheckStatusInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckStatusInfo)
	if !ok {
		that2, ok := that.(CheckStatusInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckStatusInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckStatusInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckStatusInfo but is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.HTTP.Equal(that1.HTTP) {
		return fmt.Errorf("HTTP this(%v) Not Equal that(%v)", this.HTTP, that1.HTTP)
	}
	if !this.TCP.Equal(that1.TCP) {
		return fmt.Errorf("TCP this(%v) Not Equal that(%v)", this.TCP, that1.TCP)
	}
	return nil
}
func (this *CheckStatusInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckStatusInfo)
	if !ok {
		that2, ok := that.(CheckStatusInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.HTTP.Equal(that1.HTTP) {
		return false
	}
	if !this.TCP.Equal(that1.TCP) {
		return false
	}
	return true
}
func (this *CheckStatusInfo_Command) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckStatusInfo_Command)
	if !ok {
		that2, ok := that.(CheckStatusInfo_Command)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckStatusInfo_Command")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckStatusInfo_Command but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckStatusInfo_Command but is not nil && this == nil")
	}
	if this.ExitCode != nil && that1.ExitCode != nil {
		if *this.ExitCode != *that1.ExitCode {
			return fmt.Errorf("ExitCode this(%v) Not Equal that(%v)", *this.ExitCode, *that1.ExitCode)
		}
	} else if this.ExitCode != nil {
		return fmt.Errorf("this.ExitCode == nil && that.ExitCode != nil")
	} else if that1.ExitCode != nil {
		return fmt.Errorf("ExitCode this(%v) Not Equal that(%v)", this.ExitCode, that1.ExitCode)
	}
	return nil
}
func (this *CheckStatusInfo_Command) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckStatusInfo_Command)
	if !ok {
		that2, ok := that.(CheckStatusInfo_Command)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ExitCode != nil && that1.ExitCode != nil {
		if *this.ExitCode != *that1.ExitCode {
			return false
		}
	} else if this.ExitCode != nil {
		return false
	} else if that1.ExitCode != nil {
		return false
	}
	return true
}
func (this *CheckStatusInfo_Http) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckStatusInfo_Http)
	if !ok {
		that2, ok := that.(CheckStatusInfo_Http)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckStatusInfo_Http")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckStatusInfo_Http but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckStatusInfo_Http but is not nil && this == nil")
	}
	if this.StatusCode != nil && that1.StatusCode != nil {
		if *this.StatusCode != *that1.StatusCode {
			return fmt.Errorf("StatusCode this(%v) Not Equal that(%v)", *this.StatusCode, *that1.StatusCode)
		}
	} else if this.StatusCode != nil {
		return fmt.Errorf("this.StatusCode == nil && that.StatusCode != nil")
	} else if that1.StatusCode != nil {
		return fmt.Errorf("StatusCode this(%v) Not Equal that(%v)", this.StatusCode, that1.StatusCode)
	}
	return nil
}
func (this *CheckStatusInfo_Http) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckStatusInfo_Http)
	if !ok {
		that2, ok := that.(CheckStatusInfo_Http)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.StatusCode != nil && that1.StatusCode != nil {
		if *this.StatusCode != *that1.StatusCode {
			return false
		}
	} else if this.StatusCode != nil {
		return false
	} else if that1.StatusCode != nil {
		return false
	}
	return true
}
func (this *CheckStatusInfo_Tcp) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CheckStatusInfo_Tcp)
	if !ok {
		that2, ok := that.(CheckStatusInfo_Tcp)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CheckStatusInfo_Tcp")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CheckStatusInfo_Tcp but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CheckStatusInfo_Tcp but is not nil && this == nil")
	}
	if this.Succeeded != nil && that1.Succeeded != nil {
		if *this.Succeeded != *that1.Succeeded {
			return fmt.Errorf("Succeeded this(%v) Not Equal that(%v)", *this.Succeeded, *that1.Succeeded)
		}
	} else if this.Succeeded != nil {
		return fmt.Errorf("this.Succeeded == nil && that.Succeeded != nil")
	} else if that1.Succeeded != nil {
		return fmt.Errorf("Succeeded this(%v) Not Equal that(%v)", this.Succeeded, that1.Succeeded)
	}
	return nil
}
func (this *CheckStatusInfo_Tcp) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CheckStatusInfo_Tcp)
	if !ok {
		that2, ok := that.(CheckStatusInfo_Tcp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Succeeded != nil && that1.Succeeded != nil {
		if *this.Succeeded != *that1.Succeeded {
			return false
		}
	} else if this.Succeeded != nil {
		return false
	} else if that1.Succeeded != nil {
		return false
	}
	return true
}
func (this *TaskStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskStatus)
	if !ok {
		that2, ok := that.(TaskStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TaskStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskStatus but is not nil && this == nil")
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return fmt.Errorf("State this(%v) Not Equal that(%v)", *this.State, *that1.State)
		}
	} else if this.State != nil {
		return fmt.Errorf("this.State == nil && that.State != nil")
	} else if that1.State != nil {
		return fmt.Errorf("State this(%v) Not Equal that(%v)", this.State, that1.State)
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return fmt.Errorf("Message this(%v) Not Equal that(%v)", *this.Message, *that1.Message)
		}
	} else if this.Message != nil {
		return fmt.Errorf("this.Message == nil && that.Message != nil")
	} else if that1.Message != nil {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return fmt.Errorf("Source this(%v) Not Equal that(%v)", *this.Source, *that1.Source)
		}
	} else if this.Source != nil {
		return fmt.Errorf("this.Source == nil && that.Source != nil")
	} else if that1.Source != nil {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if this.Reason != nil && that1.Reason != nil {
		if *this.Reason != *that1.Reason {
			return fmt.Errorf("Reason this(%v) Not Equal that(%v)", *this.Reason, *that1.Reason)
		}
	} else if this.Reason != nil {
		return fmt.Errorf("this.Reason == nil && that.Reason != nil")
	} else if that1.Reason != nil {
		return fmt.Errorf("Reason this(%v) Not Equal that(%v)", this.Reason, that1.Reason)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return fmt.Errorf("AgentID this(%v) Not Equal that(%v)", this.AgentID, that1.AgentID)
	}
	if !this.ExecutorID.Equal(that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", *this.Timestamp, *that1.Timestamp)
		}
	} else if this.Timestamp != nil {
		return fmt.Errorf("this.Timestamp == nil && that.Timestamp != nil")
	} else if that1.Timestamp != nil {
		return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return fmt.Errorf("UUID this(%v) Not Equal that(%v)", this.UUID, that1.UUID)
	}
	if this.Healthy != nil && that1.Healthy != nil {
		if *this.Healthy != *that1.Healthy {
			return fmt.Errorf("Healthy this(%v) Not Equal that(%v)", *this.Healthy, *that1.Healthy)
		}
	} else if this.Healthy != nil {
		return fmt.Errorf("this.Healthy == nil && that.Healthy != nil")
	} else if that1.Healthy != nil {
		return fmt.Errorf("Healthy this(%v) Not Equal that(%v)", this.Healthy, that1.Healthy)
	}
	if !this.CheckStatus.Equal(that1.CheckStatus) {
		return fmt.Errorf("CheckStatus this(%v) Not Equal that(%v)", this.CheckStatus, that1.CheckStatus)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !this.ContainerStatus.Equal(that1.ContainerStatus) {
		return fmt.Errorf("ContainerStatus this(%v) Not Equal that(%v)", this.ContainerStatus, that1.ContainerStatus)
	}
	if !this.UnreachableTime.Equal(that1.UnreachableTime) {
		return fmt.Errorf("UnreachableTime this(%v) Not Equal that(%v)", this.UnreachableTime, that1.UnreachableTime)
	}
	if !this.Limitation.Equal(that1.Limitation) {
		return fmt.Errorf("Limitation this(%v) Not Equal that(%v)", this.Limitation, that1.Limitation)
	}
	return nil
}
func (this *TaskStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskStatus)
	if !ok {
		that2, ok := that.(TaskStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return false
		}
	} else if this.State != nil {
		return false
	} else if that1.State != nil {
		return false
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return false
		}
	} else if this.Message != nil {
		return false
	} else if that1.Message != nil {
		return false
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return false
		}
	} else if this.Source != nil {
		return false
	} else if that1.Source != nil {
		return false
	}
	if this.Reason != nil && that1.Reason != nil {
		if *this.Reason != *that1.Reason {
			return false
		}
	} else if this.Reason != nil {
		return false
	} else if that1.Reason != nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.AgentID.Equal(that1.AgentID) {
		return false
	}
	if !this.ExecutorID.Equal(that1.ExecutorID) {
		return false
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return false
		}
	} else if this.Timestamp != nil {
		return false
	} else if that1.Timestamp != nil {
		return false
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return false
	}
	if this.Healthy != nil && that1.Healthy != nil {
		if *this.Healthy != *that1.Healthy {
			return false
		}
	} else if this.Healthy != nil {
		return false
	} else if that1.Healthy != nil {
		return false
	}
	if !this.CheckStatus.Equal(that1.CheckStatus) {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !this.ContainerStatus.Equal(that1.ContainerStatus) {
		return false
	}
	if !this.UnreachableTime.Equal(that1.UnreachableTime) {
		return false
	}
	if !this.Limitation.Equal(that1.Limitation) {
		return false
	}
	return true
}
func (this *Filters) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Filters)
	if !ok {
		that2, ok := that.(Filters)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Filters")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Filters but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Filters but is not nil && this == nil")
	}
	if this.RefuseSeconds != nil && that1.RefuseSeconds != nil {
		if *this.RefuseSeconds != *that1.RefuseSeconds {
			return fmt.Errorf("RefuseSeconds this(%v) Not Equal that(%v)", *this.RefuseSeconds, *that1.RefuseSeconds)
		}
	} else if this.RefuseSeconds != nil {
		return fmt.Errorf("this.RefuseSeconds == nil && that.RefuseSeconds != nil")
	} else if that1.RefuseSeconds != nil {
		return fmt.Errorf("RefuseSeconds this(%v) Not Equal that(%v)", this.RefuseSeconds, that1.RefuseSeconds)
	}
	return nil
}
func (this *Filters) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Filters)
	if !ok {
		that2, ok := that.(Filters)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.RefuseSeconds != nil && that1.RefuseSeconds != nil {
		if *this.RefuseSeconds != *that1.RefuseSeconds {
			return false
		}
	} else if this.RefuseSeconds != nil {
		return false
	} else if that1.RefuseSeconds != nil {
		return false
	}
	return true
}
func (this *Environment) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Environment)
	if !ok {
		that2, ok := that.(Environment)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Environment")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Environment but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Environment but is not nil && this == nil")
	}
	if len(this.Variables) != len(that1.Variables) {
		return fmt.Errorf("Variables this(%v) Not Equal that(%v)", len(this.Variables), len(that1.Variables))
	}
	for i := range this.Variables {
		if !this.Variables[i].Equal(&that1.Variables[i]) {
			return fmt.Errorf("Variables this[%v](%v) Not Equal that[%v](%v)", i, this.Variables[i], i, that1.Variables[i])
		}
	}
	return nil
}
func (this *Environment) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Environment)
	if !ok {
		that2, ok := that.(Environment)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Variables) != len(that1.Variables) {
		return false
	}
	for i := range this.Variables {
		if !this.Variables[i].Equal(&that1.Variables[i]) {
			return false
		}
	}
	return true
}
func (this *Environment_Variable) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Environment_Variable)
	if !ok {
		that2, ok := that.(Environment_Variable)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Environment_Variable")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Environment_Variable but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Environment_Variable but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !this.Secret.Equal(that1.Secret) {
		return fmt.Errorf("Secret this(%v) Not Equal that(%v)", this.Secret, that1.Secret)
	}
	return nil
}
func (this *Environment_Variable) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Environment_Variable)
	if !ok {
		that2, ok := that.(Environment_Variable)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !this.Secret.Equal(that1.Secret) {
		return false
	}
	return true
}
func (this *Parameter) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Parameter)
	if !ok {
		that2, ok := that.(Parameter)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Parameter")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Parameter but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Parameter but is not nil && this == nil")
	}
	if this.Key != that1.Key {
		return fmt.Errorf("Key this(%v) Not Equal that(%v)", this.Key, that1.Key)
	}
	if this.Value != that1.Value {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *Parameter) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Parameter)
	if !ok {
		that2, ok := that.(Parameter)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *Parameters) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Parameters)
	if !ok {
		that2, ok := that.(Parameters)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Parameters")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Parameters but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Parameters but is not nil && this == nil")
	}
	if len(this.Parameter) != len(that1.Parameter) {
		return fmt.Errorf("Parameter this(%v) Not Equal that(%v)", len(this.Parameter), len(that1.Parameter))
	}
	for i := range this.Parameter {
		if !this.Parameter[i].Equal(&that1.Parameter[i]) {
			return fmt.Errorf("Parameter this[%v](%v) Not Equal that[%v](%v)", i, this.Parameter[i], i, that1.Parameter[i])
		}
	}
	return nil
}
func (this *Parameters) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Parameters)
	if !ok {
		that2, ok := that.(Parameters)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Parameter) != len(that1.Parameter) {
		return false
	}
	for i := range this.Parameter {
		if !this.Parameter[i].Equal(&that1.Parameter[i]) {
			return false
		}
	}
	return true
}
func (this *Credential) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Credential)
	if !ok {
		that2, ok := that.(Credential)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Credential")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Credential but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Credential but is not nil && this == nil")
	}
	if this.Principal != that1.Principal {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.Secret != nil && that1.Secret != nil {
		if *this.Secret != *that1.Secret {
			return fmt.Errorf("Secret this(%v) Not Equal that(%v)", *this.Secret, *that1.Secret)
		}
	} else if this.Secret != nil {
		return fmt.Errorf("this.Secret == nil && that.Secret != nil")
	} else if that1.Secret != nil {
		return fmt.Errorf("Secret this(%v) Not Equal that(%v)", this.Secret, that1.Secret)
	}
	return nil
}
func (this *Credential) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Credential)
	if !ok {
		that2, ok := that.(Credential)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Principal != that1.Principal {
		return false
	}
	if this.Secret != nil && that1.Secret != nil {
		if *this.Secret != *that1.Secret {
			return false
		}
	} else if this.Secret != nil {
		return false
	} else if that1.Secret != nil {
		return false
	}
	return true
}
func (this *Credentials) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Credentials)
	if !ok {
		that2, ok := that.(Credentials)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Credentials")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Credentials but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Credentials but is not nil && this == nil")
	}
	if len(this.Credentials) != len(that1.Credentials) {
		return fmt.Errorf("Credentials this(%v) Not Equal that(%v)", len(this.Credentials), len(that1.Credentials))
	}
	for i := range this.Credentials {
		if !this.Credentials[i].Equal(&that1.Credentials[i]) {
			return fmt.Errorf("Credentials this[%v](%v) Not Equal that[%v](%v)", i, this.Credentials[i], i, that1.Credentials[i])
		}
	}
	return nil
}
func (this *Credentials) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Credentials)
	if !ok {
		that2, ok := that.(Credentials)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Credentials) != len(that1.Credentials) {
		return false
	}
	for i := range this.Credentials {
		if !this.Credentials[i].Equal(&that1.Credentials[i]) {
			return false
		}
	}
	return true
}
func (this *Secret) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Secret)
	if !ok {
		that2, ok := that.(Secret)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Secret")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Secret but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Secret but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Reference.Equal(that1.Reference) {
		return fmt.Errorf("Reference this(%v) Not Equal that(%v)", this.Reference, that1.Reference)
	}
	if !this.Value.Equal(that1.Value) {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *Secret) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Secret)
	if !ok {
		that2, ok := that.(Secret)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Reference.Equal(that1.Reference) {
		return false
	}
	if !this.Value.Equal(that1.Value) {
		return false
	}
	return true
}
func (this *Secret_Reference) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Secret_Reference)
	if !ok {
		that2, ok := that.(Secret_Reference)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Secret_Reference")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Secret_Reference but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Secret_Reference but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return fmt.Errorf("Key this(%v) Not Equal that(%v)", *this.Key, *that1.Key)
		}
	} else if this.Key != nil {
		return fmt.Errorf("this.Key == nil && that.Key != nil")
	} else if that1.Key != nil {
		return fmt.Errorf("Key this(%v) Not Equal that(%v)", this.Key, that1.Key)
	}
	return nil
}
func (this *Secret_Reference) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Secret_Reference)
	if !ok {
		that2, ok := that.(Secret_Reference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return false
		}
	} else if this.Key != nil {
		return false
	} else if that1.Key != nil {
		return false
	}
	return true
}
func (this *Secret_Value) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Secret_Value)
	if !ok {
		that2, ok := that.(Secret_Value)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Secret_Value")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Secret_Value but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Secret_Value but is not nil && this == nil")
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *Secret_Value) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Secret_Value)
	if !ok {
		that2, ok := that.(Secret_Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *RateLimit) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		that2, ok := that.(RateLimit)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *RateLimit")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RateLimit but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RateLimit but is not nil && this == nil")
	}
	if this.QPS != nil && that1.QPS != nil {
		if *this.QPS != *that1.QPS {
			return fmt.Errorf("QPS this(%v) Not Equal that(%v)", *this.QPS, *that1.QPS)
		}
	} else if this.QPS != nil {
		return fmt.Errorf("this.QPS == nil && that.QPS != nil")
	} else if that1.QPS != nil {
		return fmt.Errorf("QPS this(%v) Not Equal that(%v)", this.QPS, that1.QPS)
	}
	if this.Principal != that1.Principal {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.Capacity != nil && that1.Capacity != nil {
		if *this.Capacity != *that1.Capacity {
			return fmt.Errorf("Capacity this(%v) Not Equal that(%v)", *this.Capacity, *that1.Capacity)
		}
	} else if this.Capacity != nil {
		return fmt.Errorf("this.Capacity == nil && that.Capacity != nil")
	} else if that1.Capacity != nil {
		return fmt.Errorf("Capacity this(%v) Not Equal that(%v)", this.Capacity, that1.Capacity)
	}
	return nil
}
func (this *RateLimit) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		that2, ok := that.(RateLimit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.QPS != nil && that1.QPS != nil {
		if *this.QPS != *that1.QPS {
			return false
		}
	} else if this.QPS != nil {
		return false
	} else if that1.QPS != nil {
		return false
	}
	if this.Principal != that1.Principal {
		return false
	}
	if this.Capacity != nil && that1.Capacity != nil {
		if *this.Capacity != *that1.Capacity {
			return false
		}
	} else if this.Capacity != nil {
		return false
	} else if that1.Capacity != nil {
		return false
	}
	return true
}
func (this *RateLimits) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RateLimits)
	if !ok {
		that2, ok := that.(RateLimits)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *RateLimits")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RateLimits but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RateLimits but is not nil && this == nil")
	}
	if len(this.Limits) != len(that1.Limits) {
		return fmt.Errorf("Limits this(%v) Not Equal that(%v)", len(this.Limits), len(that1.Limits))
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(&that1.Limits[i]) {
			return fmt.Errorf("Limits this[%v](%v) Not Equal that[%v](%v)", i, this.Limits[i], i, that1.Limits[i])
		}
	}
	if this.AggregateDefaultQPS != nil && that1.AggregateDefaultQPS != nil {
		if *this.AggregateDefaultQPS != *that1.AggregateDefaultQPS {
			return fmt.Errorf("AggregateDefaultQPS this(%v) Not Equal that(%v)", *this.AggregateDefaultQPS, *that1.AggregateDefaultQPS)
		}
	} else if this.AggregateDefaultQPS != nil {
		return fmt.Errorf("this.AggregateDefaultQPS == nil && that.AggregateDefaultQPS != nil")
	} else if that1.AggregateDefaultQPS != nil {
		return fmt.Errorf("AggregateDefaultQPS this(%v) Not Equal that(%v)", this.AggregateDefaultQPS, that1.AggregateDefaultQPS)
	}
	if this.AggregateDefaultCapacity != nil && that1.AggregateDefaultCapacity != nil {
		if *this.AggregateDefaultCapacity != *that1.AggregateDefaultCapacity {
			return fmt.Errorf("AggregateDefaultCapacity this(%v) Not Equal that(%v)", *this.AggregateDefaultCapacity, *that1.AggregateDefaultCapacity)
		}
	} else if this.AggregateDefaultCapacity != nil {
		return fmt.Errorf("this.AggregateDefaultCapacity == nil && that.AggregateDefaultCapacity != nil")
	} else if that1.AggregateDefaultCapacity != nil {
		return fmt.Errorf("AggregateDefaultCapacity this(%v) Not Equal that(%v)", this.AggregateDefaultCapacity, that1.AggregateDefaultCapacity)
	}
	return nil
}
func (this *RateLimits) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimits)
	if !ok {
		that2, ok := that.(RateLimits)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Limits) != len(that1.Limits) {
		return false
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(&that1.Limits[i]) {
			return false
		}
	}
	if this.AggregateDefaultQPS != nil && that1.AggregateDefaultQPS != nil {
		if *this.AggregateDefaultQPS != *that1.AggregateDefaultQPS {
			return false
		}
	} else if this.AggregateDefaultQPS != nil {
		return false
	} else if that1.AggregateDefaultQPS != nil {
		return false
	}
	if this.AggregateDefaultCapacity != nil && that1.AggregateDefaultCapacity != nil {
		if *this.AggregateDefaultCapacity != *that1.AggregateDefaultCapacity {
			return false
		}
	} else if this.AggregateDefaultCapacity != nil {
		return false
	} else if that1.AggregateDefaultCapacity != nil {
		return false
	}
	return true
}
func (this *Image) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Image)
	if !ok {
		that2, ok := that.(Image)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Image")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Image but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Image but is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Appc.Equal(that1.Appc) {
		return fmt.Errorf("Appc this(%v) Not Equal that(%v)", this.Appc, that1.Appc)
	}
	if !this.Docker.Equal(that1.Docker) {
		return fmt.Errorf("Docker this(%v) Not Equal that(%v)", this.Docker, that1.Docker)
	}
	if this.Cached != nil && that1.Cached != nil {
		if *this.Cached != *that1.Cached {
			return fmt.Errorf("Cached this(%v) Not Equal that(%v)", *this.Cached, *that1.Cached)
		}
	} else if this.Cached != nil {
		return fmt.Errorf("this.Cached == nil && that.Cached != nil")
	} else if that1.Cached != nil {
		return fmt.Errorf("Cached this(%v) Not Equal that(%v)", this.Cached, that1.Cached)
	}
	return nil
}
func (this *Image) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Image)
	if !ok {
		that2, ok := that.(Image)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Appc.Equal(that1.Appc) {
		return false
	}
	if !this.Docker.Equal(that1.Docker) {
		return false
	}
	if this.Cached != nil && that1.Cached != nil {
		if *this.Cached != *that1.Cached {
			return false
		}
	} else if this.Cached != nil {
		return false
	} else if that1.Cached != nil {
		return false
	}
	return true
}
func (this *Image_Appc) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Image_Appc)
	if !ok {
		that2, ok := that.(Image_Appc)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Image_Appc")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Image_Appc but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Image_Appc but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.ID != nil && that1.ID != nil {
		if *this.ID != *that1.ID {
			return fmt.Errorf("ID this(%v) Not Equal that(%v)", *this.ID, *that1.ID)
		}
	} else if this.ID != nil {
		return fmt.Errorf("this.ID == nil && that.ID != nil")
	} else if that1.ID != nil {
		return fmt.Errorf("ID this(%v) Not Equal that(%v)", this.ID, that1.ID)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	return nil
}
func (this *Image_Appc) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Image_Appc)
	if !ok {
		that2, ok := that.(Image_Appc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.ID != nil && that1.ID != nil {
		if *this.ID != *that1.ID {
			return false
		}
	} else if this.ID != nil {
		return false
	} else if that1.ID != nil {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	return true
}
func (this *Image_Docker) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Image_Docker)
	if !ok {
		that2, ok := that.(Image_Docker)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Image_Docker")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Image_Docker but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Image_Docker but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.Credential.Equal(that1.Credential) {
		return fmt.Errorf("Credential this(%v) Not Equal that(%v)", this.Credential, that1.Credential)
	}
	if !this.Config.Equal(that1.Config) {
		return fmt.Errorf("Config this(%v) Not Equal that(%v)", this.Config, that1.Config)
	}
	return nil
}
func (this *Image_Docker) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Image_Docker)
	if !ok {
		that2, ok := that.(Image_Docker)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Credential.Equal(that1.Credential) {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *MountPropagation) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MountPropagation)
	if !ok {
		that2, ok := that.(MountPropagation)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *MountPropagation")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MountPropagation but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MountPropagation but is not nil && this == nil")
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return fmt.Errorf("Mode this(%v) Not Equal that(%v)", *this.Mode, *that1.Mode)
		}
	} else if this.Mode != nil {
		return fmt.Errorf("this.Mode == nil && that.Mode != nil")
	} else if that1.Mode != nil {
		return fmt.Errorf("Mode this(%v) Not Equal that(%v)", this.Mode, that1.Mode)
	}
	return nil
}
func (this *MountPropagation) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MountPropagation)
	if !ok {
		that2, ok := that.(MountPropagation)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return false
		}
	} else if this.Mode != nil {
		return false
	} else if that1.Mode != nil {
		return false
	}
	return true
}
func (this *Volume) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Volume)
	if !ok {
		that2, ok := that.(Volume)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Volume")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Volume but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Volume but is not nil && this == nil")
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return fmt.Errorf("Mode this(%v) Not Equal that(%v)", *this.Mode, *that1.Mode)
		}
	} else if this.Mode != nil {
		return fmt.Errorf("this.Mode == nil && that.Mode != nil")
	} else if that1.Mode != nil {
		return fmt.Errorf("Mode this(%v) Not Equal that(%v)", this.Mode, that1.Mode)
	}
	if this.ContainerPath != that1.ContainerPath {
		return fmt.Errorf("ContainerPath this(%v) Not Equal that(%v)", this.ContainerPath, that1.ContainerPath)
	}
	if this.HostPath != nil && that1.HostPath != nil {
		if *this.HostPath != *that1.HostPath {
			return fmt.Errorf("HostPath this(%v) Not Equal that(%v)", *this.HostPath, *that1.HostPath)
		}
	} else if this.HostPath != nil {
		return fmt.Errorf("this.HostPath == nil && that.HostPath != nil")
	} else if that1.HostPath != nil {
		return fmt.Errorf("HostPath this(%v) Not Equal that(%v)", this.HostPath, that1.HostPath)
	}
	if !this.Image.Equal(that1.Image) {
		return fmt.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if !this.Source.Equal(that1.Source) {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	return nil
}
func (this *Volume) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Volume)
	if !ok {
		that2, ok := that.(Volume)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return false
		}
	} else if this.Mode != nil {
		return false
	} else if that1.Mode != nil {
		return false
	}
	if this.ContainerPath != that1.ContainerPath {
		return false
	}
	if this.HostPath != nil && that1.HostPath != nil {
		if *this.HostPath != *that1.HostPath {
			return false
		}
	} else if this.HostPath != nil {
		return false
	} else if that1.HostPath != nil {
		return false
	}
	if !this.Image.Equal(that1.Image) {
		return false
	}
	if !this.Source.Equal(that1.Source) {
		return false
	}
	return true
}
func (this *Volume_Source) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Volume_Source)
	if !ok {
		that2, ok := that.(Volume_Source)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Volume_Source")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Volume_Source but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Volume_Source but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.DockerVolume.Equal(that1.DockerVolume) {
		return fmt.Errorf("DockerVolume this(%v) Not Equal that(%v)", this.DockerVolume, that1.DockerVolume)
	}
	if !this.HostPath.Equal(that1.HostPath) {
		return fmt.Errorf("HostPath this(%v) Not Equal that(%v)", this.HostPath, that1.HostPath)
	}
	if !this.SandboxPath.Equal(that1.SandboxPath) {
		return fmt.Errorf("SandboxPath this(%v) Not Equal that(%v)", this.SandboxPath, that1.SandboxPath)
	}
	if !this.Secret.Equal(that1.Secret) {
		return fmt.Errorf("Secret this(%v) Not Equal that(%v)", this.Secret, that1.Secret)
	}
	return nil
}
func (this *Volume_Source) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Volume_Source)
	if !ok {
		that2, ok := that.(Volume_Source)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.DockerVolume.Equal(that1.DockerVolume) {
		return false
	}
	if !this.HostPath.Equal(that1.HostPath) {
		return false
	}
	if !this.SandboxPath.Equal(that1.SandboxPath) {
		return false
	}
	if !this.Secret.Equal(that1.Secret) {
		return false
	}
	return true
}
func (this *Volume_Source_DockerVolume) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Volume_Source_DockerVolume)
	if !ok {
		that2, ok := that.(Volume_Source_DockerVolume)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Volume_Source_DockerVolume")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Volume_Source_DockerVolume but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Volume_Source_DockerVolume but is not nil && this == nil")
	}
	if this.Driver != nil && that1.Driver != nil {
		if *this.Driver != *that1.Driver {
			return fmt.Errorf("Driver this(%v) Not Equal that(%v)", *this.Driver, *that1.Driver)
		}
	} else if this.Driver != nil {
		return fmt.Errorf("this.Driver == nil && that.Driver != nil")
	} else if that1.Driver != nil {
		return fmt.Errorf("Driver this(%v) Not Equal that(%v)", this.Driver, that1.Driver)
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.DriverOptions.Equal(that1.DriverOptions) {
		return fmt.Errorf("DriverOptions this(%v) Not Equal that(%v)", this.DriverOptions, that1.DriverOptions)
	}
	return nil
}
func (this *Volume_Source_DockerVolume) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Volume_Source_DockerVolume)
	if !ok {
		that2, ok := that.(Volume_Source_DockerVolume)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Driver != nil && that1.Driver != nil {
		if *this.Driver != *that1.Driver {
			return false
		}
	} else if this.Driver != nil {
		return false
	} else if that1.Driver != nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.DriverOptions.Equal(that1.DriverOptions) {
		return false
	}
	return true
}
func (this *Volume_Source_HostPath) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Volume_Source_HostPath)
	if !ok {
		that2, ok := that.(Volume_Source_HostPath)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Volume_Source_HostPath")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Volume_Source_HostPath but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Volume_Source_HostPath but is not nil && this == nil")
	}
	if this.Path != that1.Path {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if !this.MountPropagation.Equal(that1.MountPropagation) {
		return fmt.Errorf("MountPropagation this(%v) Not Equal that(%v)", this.MountPropagation, that1.MountPropagation)
	}
	return nil
}
func (this *Volume_Source_HostPath) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Volume_Source_HostPath)
	if !ok {
		that2, ok := that.(Volume_Source_HostPath)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !this.MountPropagation.Equal(that1.MountPropagation) {
		return false
	}
	return true
}
func (this *Volume_Source_SandboxPath) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Volume_Source_SandboxPath)
	if !ok {
		that2, ok := that.(Volume_Source_SandboxPath)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Volume_Source_SandboxPath")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Volume_Source_SandboxPath but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Volume_Source_SandboxPath but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if this.Path != that1.Path {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	return nil
}
func (this *Volume_Source_SandboxPath) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Volume_Source_SandboxPath)
	if !ok {
		that2, ok := that.(Volume_Source_SandboxPath)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *NetworkInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*NetworkInfo)
	if !ok {
		that2, ok := that.(NetworkInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *NetworkInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *NetworkInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *NetworkInfo but is not nil && this == nil")
	}
	if len(this.IPAddresses) != len(that1.IPAddresses) {
		return fmt.Errorf("IPAddresses this(%v) Not Equal that(%v)", len(this.IPAddresses), len(that1.IPAddresses))
	}
	for i := range this.IPAddresses {
		if !this.IPAddresses[i].Equal(&that1.IPAddresses[i]) {
			return fmt.Errorf("IPAddresses this[%v](%v) Not Equal that[%v](%v)", i, this.IPAddresses[i], i, that1.IPAddresses[i])
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if len(this.Groups) != len(that1.Groups) {
		return fmt.Errorf("Groups this(%v) Not Equal that(%v)", len(this.Groups), len(that1.Groups))
	}
	for i := range this.Groups {
		if this.Groups[i] != that1.Groups[i] {
			return fmt.Errorf("Groups this[%v](%v) Not Equal that[%v](%v)", i, this.Groups[i], i, that1.Groups[i])
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return fmt.Errorf("PortMappings this(%v) Not Equal that(%v)", len(this.PortMappings), len(that1.PortMappings))
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(&that1.PortMappings[i]) {
			return fmt.Errorf("PortMappings this[%v](%v) Not Equal that[%v](%v)", i, this.PortMappings[i], i, that1.PortMappings[i])
		}
	}
	return nil
}
func (this *NetworkInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*NetworkInfo)
	if !ok {
		that2, ok := that.(NetworkInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.IPAddresses) != len(that1.IPAddresses) {
		return false
	}
	for i := range this.IPAddresses {
		if !this.IPAddresses[i].Equal(&that1.IPAddresses[i]) {
			return false
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if len(this.Groups) != len(that1.Groups) {
		return false
	}
	for i := range this.Groups {
		if this.Groups[i] != that1.Groups[i] {
			return false
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return false
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(&that1.PortMappings[i]) {
			return false
		}
	}
	return true
}
func (this *NetworkInfo_IPAddress) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*NetworkInfo_IPAddress)
	if !ok {
		that2, ok := that.(NetworkInfo_IPAddress)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *NetworkInfo_IPAddress")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *NetworkInfo_IPAddress but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *NetworkInfo_IPAddress but is not nil && this == nil")
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if this.IPAddress != nil && that1.IPAddress != nil {
		if *this.IPAddress != *that1.IPAddress {
			return fmt.Errorf("IPAddress this(%v) Not Equal that(%v)", *this.IPAddress, *that1.IPAddress)
		}
	} else if this.IPAddress != nil {
		return fmt.Errorf("this.IPAddress == nil && that.IPAddress != nil")
	} else if that1.IPAddress != nil {
		return fmt.Errorf("IPAddress this(%v) Not Equal that(%v)", this.IPAddress, that1.IPAddress)
	}
	return nil
}
func (this *NetworkInfo_IPAddress) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*NetworkInfo_IPAddress)
	if !ok {
		that2, ok := that.(NetworkInfo_IPAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if this.IPAddress != nil && that1.IPAddress != nil {
		if *this.IPAddress != *that1.IPAddress {
			return false
		}
	} else if this.IPAddress != nil {
		return false
	} else if that1.IPAddress != nil {
		return false
	}
	return true
}
func (this *NetworkInfo_PortMapping) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*NetworkInfo_PortMapping)
	if !ok {
		that2, ok := that.(NetworkInfo_PortMapping)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *NetworkInfo_PortMapping")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *NetworkInfo_PortMapping but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *NetworkInfo_PortMapping but is not nil && this == nil")
	}
	if this.HostPort != that1.HostPort {
		return fmt.Errorf("HostPort this(%v) Not Equal that(%v)", this.HostPort, that1.HostPort)
	}
	if this.ContainerPort != that1.ContainerPort {
		return fmt.Errorf("ContainerPort this(%v) Not Equal that(%v)", this.ContainerPort, that1.ContainerPort)
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	return nil
}
func (this *NetworkInfo_PortMapping) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*NetworkInfo_PortMapping)
	if !ok {
		that2, ok := that.(NetworkInfo_PortMapping)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HostPort != that1.HostPort {
		return false
	}
	if this.ContainerPort != that1.ContainerPort {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	return true
}
func (this *CapabilityInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CapabilityInfo)
	if !ok {
		that2, ok := that.(CapabilityInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CapabilityInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CapabilityInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CapabilityInfo but is not nil && this == nil")
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return fmt.Errorf("Capabilities this(%v) Not Equal that(%v)", len(this.Capabilities), len(that1.Capabilities))
	}
	for i := range this.Capabilities {
		if this.Capabilities[i] != that1.Capabilities[i] {
			return fmt.Errorf("Capabilities this[%v](%v) Not Equal that[%v](%v)", i, this.Capabilities[i], i, that1.Capabilities[i])
		}
	}
	return nil
}
func (this *CapabilityInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CapabilityInfo)
	if !ok {
		that2, ok := that.(CapabilityInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return false
	}
	for i := range this.Capabilities {
		if this.Capabilities[i] != that1.Capabilities[i] {
			return false
		}
	}
	return true
}
func (this *LinuxInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*LinuxInfo)
	if !ok {
		that2, ok := that.(LinuxInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *LinuxInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *LinuxInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *LinuxInfo but is not nil && this == nil")
	}
	if !this.CapabilityInfo.Equal(that1.CapabilityInfo) {
		return fmt.Errorf("CapabilityInfo this(%v) Not Equal that(%v)", this.CapabilityInfo, that1.CapabilityInfo)
	}
	if !this.BoundingCapabilities.Equal(that1.BoundingCapabilities) {
		return fmt.Errorf("BoundingCapabilities this(%v) Not Equal that(%v)", this.BoundingCapabilities, that1.BoundingCapabilities)
	}
	if !this.EffectiveCapabilities.Equal(that1.EffectiveCapabilities) {
		return fmt.Errorf("EffectiveCapabilities this(%v) Not Equal that(%v)", this.EffectiveCapabilities, that1.EffectiveCapabilities)
	}
	if this.SharePIDNamespace != nil && that1.SharePIDNamespace != nil {
		if *this.SharePIDNamespace != *that1.SharePIDNamespace {
			return fmt.Errorf("SharePIDNamespace this(%v) Not Equal that(%v)", *this.SharePIDNamespace, *that1.SharePIDNamespace)
		}
	} else if this.SharePIDNamespace != nil {
		return fmt.Errorf("this.SharePIDNamespace == nil && that.SharePIDNamespace != nil")
	} else if that1.SharePIDNamespace != nil {
		return fmt.Errorf("SharePIDNamespace this(%v) Not Equal that(%v)", this.SharePIDNamespace, that1.SharePIDNamespace)
	}
	return nil
}
func (this *LinuxInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*LinuxInfo)
	if !ok {
		that2, ok := that.(LinuxInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.CapabilityInfo.Equal(that1.CapabilityInfo) {
		return false
	}
	if !this.BoundingCapabilities.Equal(that1.BoundingCapabilities) {
		return false
	}
	if !this.EffectiveCapabilities.Equal(that1.EffectiveCapabilities) {
		return false
	}
	if this.SharePIDNamespace != nil && that1.SharePIDNamespace != nil {
		if *this.SharePIDNamespace != *that1.SharePIDNamespace {
			return false
		}
	} else if this.SharePIDNamespace != nil {
		return false
	} else if that1.SharePIDNamespace != nil {
		return false
	}
	return true
}
func (this *RLimitInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RLimitInfo)
	if !ok {
		that2, ok := that.(RLimitInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *RLimitInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RLimitInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RLimitInfo but is not nil && this == nil")
	}
	if len(this.Rlimits) != len(that1.Rlimits) {
		return fmt.Errorf("Rlimits this(%v) Not Equal that(%v)", len(this.Rlimits), len(that1.Rlimits))
	}
	for i := range this.Rlimits {
		if !this.Rlimits[i].Equal(&that1.Rlimits[i]) {
			return fmt.Errorf("Rlimits this[%v](%v) Not Equal that[%v](%v)", i, this.Rlimits[i], i, that1.Rlimits[i])
		}
	}
	return nil
}
func (this *RLimitInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RLimitInfo)
	if !ok {
		that2, ok := that.(RLimitInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Rlimits) != len(that1.Rlimits) {
		return false
	}
	for i := range this.Rlimits {
		if !this.Rlimits[i].Equal(&that1.Rlimits[i]) {
			return false
		}
	}
	return true
}
func (this *RLimitInfo_RLimit) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RLimitInfo_RLimit)
	if !ok {
		that2, ok := that.(RLimitInfo_RLimit)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *RLimitInfo_RLimit")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RLimitInfo_RLimit but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RLimitInfo_RLimit but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if this.Hard != nil && that1.Hard != nil {
		if *this.Hard != *that1.Hard {
			return fmt.Errorf("Hard this(%v) Not Equal that(%v)", *this.Hard, *that1.Hard)
		}
	} else if this.Hard != nil {
		return fmt.Errorf("this.Hard == nil && that.Hard != nil")
	} else if that1.Hard != nil {
		return fmt.Errorf("Hard this(%v) Not Equal that(%v)", this.Hard, that1.Hard)
	}
	if this.Soft != nil && that1.Soft != nil {
		if *this.Soft != *that1.Soft {
			return fmt.Errorf("Soft this(%v) Not Equal that(%v)", *this.Soft, *that1.Soft)
		}
	} else if this.Soft != nil {
		return fmt.Errorf("this.Soft == nil && that.Soft != nil")
	} else if that1.Soft != nil {
		return fmt.Errorf("Soft this(%v) Not Equal that(%v)", this.Soft, that1.Soft)
	}
	return nil
}
func (this *RLimitInfo_RLimit) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RLimitInfo_RLimit)
	if !ok {
		that2, ok := that.(RLimitInfo_RLimit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Hard != nil && that1.Hard != nil {
		if *this.Hard != *that1.Hard {
			return false
		}
	} else if this.Hard != nil {
		return false
	} else if that1.Hard != nil {
		return false
	}
	if this.Soft != nil && that1.Soft != nil {
		if *this.Soft != *that1.Soft {
			return false
		}
	} else if this.Soft != nil {
		return false
	} else if that1.Soft != nil {
		return false
	}
	return true
}
func (this *TTYInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TTYInfo)
	if !ok {
		that2, ok := that.(TTYInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TTYInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TTYInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TTYInfo but is not nil && this == nil")
	}
	if !this.WindowSize.Equal(that1.WindowSize) {
		return fmt.Errorf("WindowSize this(%v) Not Equal that(%v)", this.WindowSize, that1.WindowSize)
	}
	return nil
}
func (this *TTYInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TTYInfo)
	if !ok {
		that2, ok := that.(TTYInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.WindowSize.Equal(that1.WindowSize) {
		return false
	}
	return true
}
func (this *TTYInfo_WindowSize) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TTYInfo_WindowSize)
	if !ok {
		that2, ok := that.(TTYInfo_WindowSize)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *TTYInfo_WindowSize")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TTYInfo_WindowSize but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TTYInfo_WindowSize but is not nil && this == nil")
	}
	if this.Rows != that1.Rows {
		return fmt.Errorf("Rows this(%v) Not Equal that(%v)", this.Rows, that1.Rows)
	}
	if this.Columns != that1.Columns {
		return fmt.Errorf("Columns this(%v) Not Equal that(%v)", this.Columns, that1.Columns)
	}
	return nil
}
func (this *TTYInfo_WindowSize) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TTYInfo_WindowSize)
	if !ok {
		that2, ok := that.(TTYInfo_WindowSize)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Rows != that1.Rows {
		return false
	}
	if this.Columns != that1.Columns {
		return false
	}
	return true
}
func (this *ContainerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo)
	if !ok {
		that2, ok := that.(ContainerInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ContainerInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfo but is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if !this.Docker.Equal(that1.Docker) {
		return fmt.Errorf("Docker this(%v) Not Equal that(%v)", this.Docker, that1.Docker)
	}
	if !this.Mesos.Equal(that1.Mesos) {
		return fmt.Errorf("Mesos this(%v) Not Equal that(%v)", this.Mesos, that1.Mesos)
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return fmt.Errorf("NetworkInfos this(%v) Not Equal that(%v)", len(this.NetworkInfos), len(that1.NetworkInfos))
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(&that1.NetworkInfos[i]) {
			return fmt.Errorf("NetworkInfos this[%v](%v) Not Equal that[%v](%v)", i, this.NetworkInfos[i], i, that1.NetworkInfos[i])
		}
	}
	if !this.LinuxInfo.Equal(that1.LinuxInfo) {
		return fmt.Errorf("LinuxInfo this(%v) Not Equal that(%v)", this.LinuxInfo, that1.LinuxInfo)
	}
	if !this.RlimitInfo.Equal(that1.RlimitInfo) {
		return fmt.Errorf("RlimitInfo this(%v) Not Equal that(%v)", this.RlimitInfo, that1.RlimitInfo)
	}
	if !this.TTYInfo.Equal(that1.TTYInfo) {
		return fmt.Errorf("TTYInfo this(%v) Not Equal that(%v)", this.TTYInfo, that1.TTYInfo)
	}
	return nil
}
func (this *ContainerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo)
	if !ok {
		that2, ok := that.(ContainerInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(&that1.Volumes[i]) {
			return false
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if !this.Docker.Equal(that1.Docker) {
		return false
	}
	if !this.Mesos.Equal(that1.Mesos) {
		return false
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return false
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(&that1.NetworkInfos[i]) {
			return false
		}
	}
	if !this.LinuxInfo.Equal(that1.LinuxInfo) {
		return false
	}
	if !this.RlimitInfo.Equal(that1.RlimitInfo) {
		return false
	}
	if !this.TTYInfo.Equal(that1.TTYInfo) {
		return false
	}
	return true
}
func (this *ContainerInfo_DockerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_DockerInfo)
	if !ok {
		that2, ok := that.(ContainerInfo_DockerInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ContainerInfo_DockerInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo_DockerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfo_DockerInfo but is not nil && this == nil")
	}
	if this.Image != that1.Image {
		return fmt.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if this.Network != nil && that1.Network != nil {
		if *this.Network != *that1.Network {
			return fmt.Errorf("Network this(%v) Not Equal that(%v)", *this.Network, *that1.Network)
		}
	} else if this.Network != nil {
		return fmt.Errorf("this.Network == nil && that.Network != nil")
	} else if that1.Network != nil {
		return fmt.Errorf("Network this(%v) Not Equal that(%v)", this.Network, that1.Network)
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return fmt.Errorf("PortMappings this(%v) Not Equal that(%v)", len(this.PortMappings), len(that1.PortMappings))
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(&that1.PortMappings[i]) {
			return fmt.Errorf("PortMappings this[%v](%v) Not Equal that[%v](%v)", i, this.PortMappings[i], i, that1.PortMappings[i])
		}
	}
	if this.Privileged != nil && that1.Privileged != nil {
		if *this.Privileged != *that1.Privileged {
			return fmt.Errorf("Privileged this(%v) Not Equal that(%v)", *this.Privileged, *that1.Privileged)
		}
	} else if this.Privileged != nil {
		return fmt.Errorf("this.Privileged == nil && that.Privileged != nil")
	} else if that1.Privileged != nil {
		return fmt.Errorf("Privileged this(%v) Not Equal that(%v)", this.Privileged, that1.Privileged)
	}
	if len(this.Parameters) != len(that1.Parameters) {
		return fmt.Errorf("Parameters this(%v) Not Equal that(%v)", len(this.Parameters), len(that1.Parameters))
	}
	for i := range this.Parameters {
		if !this.Parameters[i].Equal(&that1.Parameters[i]) {
			return fmt.Errorf("Parameters this[%v](%v) Not Equal that[%v](%v)", i, this.Parameters[i], i, that1.Parameters[i])
		}
	}
	if this.ForcePullImage != nil && that1.ForcePullImage != nil {
		if *this.ForcePullImage != *that1.ForcePullImage {
			return fmt.Errorf("ForcePullImage this(%v) Not Equal that(%v)", *this.ForcePullImage, *that1.ForcePullImage)
		}
	} else if this.ForcePullImage != nil {
		return fmt.Errorf("this.ForcePullImage == nil && that.ForcePullImage != nil")
	} else if that1.ForcePullImage != nil {
		return fmt.Errorf("ForcePullImage this(%v) Not Equal that(%v)", this.ForcePullImage, that1.ForcePullImage)
	}
	if this.VolumeDriver != nil && that1.VolumeDriver != nil {
		if *this.VolumeDriver != *that1.VolumeDriver {
			return fmt.Errorf("VolumeDriver this(%v) Not Equal that(%v)", *this.VolumeDriver, *that1.VolumeDriver)
		}
	} else if this.VolumeDriver != nil {
		return fmt.Errorf("this.VolumeDriver == nil && that.VolumeDriver != nil")
	} else if that1.VolumeDriver != nil {
		return fmt.Errorf("VolumeDriver this(%v) Not Equal that(%v)", this.VolumeDriver, that1.VolumeDriver)
	}
	return nil
}
func (this *ContainerInfo_DockerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_DockerInfo)
	if !ok {
		that2, ok := that.(ContainerInfo_DockerInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Image != that1.Image {
		return false
	}
	if this.Network != nil && that1.Network != nil {
		if *this.Network != *that1.Network {
			return false
		}
	} else if this.Network != nil {
		return false
	} else if that1.Network != nil {
		return false
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return false
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(&that1.PortMappings[i]) {
			return false
		}
	}
	if this.Privileged != nil && that1.Privileged != nil {
		if *this.Privileged != *that1.Privileged {
			return false
		}
	} else if this.Privileged != nil {
		return false
	} else if that1.Privileged != nil {
		return false
	}
	if len(this.Parameters) != len(that1.Parameters) {
		return false
	}
	for i := range this.Parameters {
		if !this.Parameters[i].Equal(&that1.Parameters[i]) {
			return false
		}
	}
	if this.ForcePullImage != nil && that1.ForcePullImage != nil {
		if *this.ForcePullImage != *that1.ForcePullImage {
			return false
		}
	} else if this.ForcePullImage != nil {
		return false
	} else if that1.ForcePullImage != nil {
		return false
	}
	if this.VolumeDriver != nil && that1.VolumeDriver != nil {
		if *this.VolumeDriver != *that1.VolumeDriver {
			return false
		}
	} else if this.VolumeDriver != nil {
		return false
	} else if that1.VolumeDriver != nil {
		return false
	}
	return true
}
func (this *ContainerInfo_DockerInfo_PortMapping) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_DockerInfo_PortMapping)
	if !ok {
		that2, ok := that.(ContainerInfo_DockerInfo_PortMapping)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ContainerInfo_DockerInfo_PortMapping")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo_DockerInfo_PortMapping but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfo_DockerInfo_PortMapping but is not nil && this == nil")
	}
	if this.HostPort != that1.HostPort {
		return fmt.Errorf("HostPort this(%v) Not Equal that(%v)", this.HostPort, that1.HostPort)
	}
	if this.ContainerPort != that1.ContainerPort {
		return fmt.Errorf("ContainerPort this(%v) Not Equal that(%v)", this.ContainerPort, that1.ContainerPort)
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	return nil
}
func (this *ContainerInfo_DockerInfo_PortMapping) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_DockerInfo_PortMapping)
	if !ok {
		that2, ok := that.(ContainerInfo_DockerInfo_PortMapping)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HostPort != that1.HostPort {
		return false
	}
	if this.ContainerPort != that1.ContainerPort {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	return true
}
func (this *ContainerInfo_MesosInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_MesosInfo)
	if !ok {
		that2, ok := that.(ContainerInfo_MesosInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ContainerInfo_MesosInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo_MesosInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfo_MesosInfo but is not nil && this == nil")
	}
	if !this.Image.Equal(that1.Image) {
		return fmt.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	return nil
}
func (this *ContainerInfo_MesosInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_MesosInfo)
	if !ok {
		that2, ok := that.(ContainerInfo_MesosInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Image.Equal(that1.Image) {
		return false
	}
	return true
}
func (this *ContainerStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerStatus)
	if !ok {
		that2, ok := that.(ContainerStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ContainerStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerStatus but is not nil && this == nil")
	}
	if !this.ContainerID.Equal(that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return fmt.Errorf("NetworkInfos this(%v) Not Equal that(%v)", len(this.NetworkInfos), len(that1.NetworkInfos))
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(&that1.NetworkInfos[i]) {
			return fmt.Errorf("NetworkInfos this[%v](%v) Not Equal that[%v](%v)", i, this.NetworkInfos[i], i, that1.NetworkInfos[i])
		}
	}
	if !this.CgroupInfo.Equal(that1.CgroupInfo) {
		return fmt.Errorf("CgroupInfo this(%v) Not Equal that(%v)", this.CgroupInfo, that1.CgroupInfo)
	}
	if this.ExecutorPID != nil && that1.ExecutorPID != nil {
		if *this.ExecutorPID != *that1.ExecutorPID {
			return fmt.Errorf("ExecutorPID this(%v) Not Equal that(%v)", *this.ExecutorPID, *that1.ExecutorPID)
		}
	} else if this.ExecutorPID != nil {
		return fmt.Errorf("this.ExecutorPID == nil && that.ExecutorPID != nil")
	} else if that1.ExecutorPID != nil {
		return fmt.Errorf("ExecutorPID this(%v) Not Equal that(%v)", this.ExecutorPID, that1.ExecutorPID)
	}
	return nil
}
func (this *ContainerStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerStatus)
	if !ok {
		that2, ok := that.(ContainerStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerID.Equal(that1.ContainerID) {
		return false
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return false
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(&that1.NetworkInfos[i]) {
			return false
		}
	}
	if !this.CgroupInfo.Equal(that1.CgroupInfo) {
		return false
	}
	if this.ExecutorPID != nil && that1.ExecutorPID != nil {
		if *this.ExecutorPID != *that1.ExecutorPID {
			return false
		}
	} else if this.ExecutorPID != nil {
		return false
	} else if that1.ExecutorPID != nil {
		return false
	}
	return true
}
func (this *CgroupInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo)
	if !ok {
		that2, ok := that.(CgroupInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo but is not nil && this == nil")
	}
	if !this.NetCLS.Equal(that1.NetCLS) {
		return fmt.Errorf("NetCLS this(%v) Not Equal that(%v)", this.NetCLS, that1.NetCLS)
	}
	return nil
}
func (this *CgroupInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo)
	if !ok {
		that2, ok := that.(CgroupInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.NetCLS.Equal(that1.NetCLS) {
		return false
	}
	return true
}
func (this *CgroupInfo_Blkio) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_Blkio)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_Blkio")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_Blkio but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_Blkio but is not nil && this == nil")
	}
	return nil
}
func (this *CgroupInfo_Blkio) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_Blkio)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *CgroupInfo_Blkio_Value) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_Blkio_Value)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Value)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_Blkio_Value")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Value but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Value but is not nil && this == nil")
	}
	if this.Op != nil && that1.Op != nil {
		if *this.Op != *that1.Op {
			return fmt.Errorf("Op this(%v) Not Equal that(%v)", *this.Op, *that1.Op)
		}
	} else if this.Op != nil {
		return fmt.Errorf("this.Op == nil && that.Op != nil")
	} else if that1.Op != nil {
		return fmt.Errorf("Op this(%v) Not Equal that(%v)", this.Op, that1.Op)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *CgroupInfo_Blkio_Value) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_Blkio_Value)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Op != nil && that1.Op != nil {
		if *this.Op != *that1.Op {
			return false
		}
	} else if this.Op != nil {
		return false
	} else if that1.Op != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	return true
}
func (this *CgroupInfo_Blkio_CFQ) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_Blkio_CFQ)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_CFQ)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_Blkio_CFQ")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_Blkio_CFQ but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_Blkio_CFQ but is not nil && this == nil")
	}
	return nil
}
func (this *CgroupInfo_Blkio_CFQ) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_Blkio_CFQ)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_CFQ)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *CgroupInfo_Blkio_CFQ_Statistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_Blkio_CFQ_Statistics)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_CFQ_Statistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_Blkio_CFQ_Statistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_Blkio_CFQ_Statistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_Blkio_CFQ_Statistics but is not nil && this == nil")
	}
	if !this.Device.Equal(that1.Device) {
		return fmt.Errorf("Device this(%v) Not Equal that(%v)", this.Device, that1.Device)
	}
	if this.Sectors != nil && that1.Sectors != nil {
		if *this.Sectors != *that1.Sectors {
			return fmt.Errorf("Sectors this(%v) Not Equal that(%v)", *this.Sectors, *that1.Sectors)
		}
	} else if this.Sectors != nil {
		return fmt.Errorf("this.Sectors == nil && that.Sectors != nil")
	} else if that1.Sectors != nil {
		return fmt.Errorf("Sectors this(%v) Not Equal that(%v)", this.Sectors, that1.Sectors)
	}
	if this.Time != nil && that1.Time != nil {
		if *this.Time != *that1.Time {
			return fmt.Errorf("Time this(%v) Not Equal that(%v)", *this.Time, *that1.Time)
		}
	} else if this.Time != nil {
		return fmt.Errorf("this.Time == nil && that.Time != nil")
	} else if that1.Time != nil {
		return fmt.Errorf("Time this(%v) Not Equal that(%v)", this.Time, that1.Time)
	}
	if len(this.IOServiced) != len(that1.IOServiced) {
		return fmt.Errorf("IOServiced this(%v) Not Equal that(%v)", len(this.IOServiced), len(that1.IOServiced))
	}
	for i := range this.IOServiced {
		if !this.IOServiced[i].Equal(&that1.IOServiced[i]) {
			return fmt.Errorf("IOServiced this[%v](%v) Not Equal that[%v](%v)", i, this.IOServiced[i], i, that1.IOServiced[i])
		}
	}
	if len(this.IOServiceBytes) != len(that1.IOServiceBytes) {
		return fmt.Errorf("IOServiceBytes this(%v) Not Equal that(%v)", len(this.IOServiceBytes), len(that1.IOServiceBytes))
	}
	for i := range this.IOServiceBytes {
		if !this.IOServiceBytes[i].Equal(&that1.IOServiceBytes[i]) {
			return fmt.Errorf("IOServiceBytes this[%v](%v) Not Equal that[%v](%v)", i, this.IOServiceBytes[i], i, that1.IOServiceBytes[i])
		}
	}
	if len(this.IOServiceTime) != len(that1.IOServiceTime) {
		return fmt.Errorf("IOServiceTime this(%v) Not Equal that(%v)", len(this.IOServiceTime), len(that1.IOServiceTime))
	}
	for i := range this.IOServiceTime {
		if !this.IOServiceTime[i].Equal(&that1.IOServiceTime[i]) {
			return fmt.Errorf("IOServiceTime this[%v](%v) Not Equal that[%v](%v)", i, this.IOServiceTime[i], i, that1.IOServiceTime[i])
		}
	}
	if len(this.IOWaitTime) != len(that1.IOWaitTime) {
		return fmt.Errorf("IOWaitTime this(%v) Not Equal that(%v)", len(this.IOWaitTime), len(that1.IOWaitTime))
	}
	for i := range this.IOWaitTime {
		if !this.IOWaitTime[i].Equal(&that1.IOWaitTime[i]) {
			return fmt.Errorf("IOWaitTime this[%v](%v) Not Equal that[%v](%v)", i, this.IOWaitTime[i], i, that1.IOWaitTime[i])
		}
	}
	if len(this.IOMerged) != len(that1.IOMerged) {
		return fmt.Errorf("IOMerged this(%v) Not Equal that(%v)", len(this.IOMerged), len(that1.IOMerged))
	}
	for i := range this.IOMerged {
		if !this.IOMerged[i].Equal(&that1.IOMerged[i]) {
			return fmt.Errorf("IOMerged this[%v](%v) Not Equal that[%v](%v)", i, this.IOMerged[i], i, that1.IOMerged[i])
		}
	}
	if len(this.IOQueued) != len(that1.IOQueued) {
		return fmt.Errorf("IOQueued this(%v) Not Equal that(%v)", len(this.IOQueued), len(that1.IOQueued))
	}
	for i := range this.IOQueued {
		if !this.IOQueued[i].Equal(&that1.IOQueued[i]) {
			return fmt.Errorf("IOQueued this[%v](%v) Not Equal that[%v](%v)", i, this.IOQueued[i], i, that1.IOQueued[i])
		}
	}
	return nil
}
func (this *CgroupInfo_Blkio_CFQ_Statistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_Blkio_CFQ_Statistics)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_CFQ_Statistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Device.Equal(that1.Device) {
		return false
	}
	if this.Sectors != nil && that1.Sectors != nil {
		if *this.Sectors != *that1.Sectors {
			return false
		}
	} else if this.Sectors != nil {
		return false
	} else if that1.Sectors != nil {
		return false
	}
	if this.Time != nil && that1.Time != nil {
		if *this.Time != *that1.Time {
			return false
		}
	} else if this.Time != nil {
		return false
	} else if that1.Time != nil {
		return false
	}
	if len(this.IOServiced) != len(that1.IOServiced) {
		return false
	}
	for i := range this.IOServiced {
		if !this.IOServiced[i].Equal(&that1.IOServiced[i]) {
			return false
		}
	}
	if len(this.IOServiceBytes) != len(that1.IOServiceBytes) {
		return false
	}
	for i := range this.IOServiceBytes {
		if !this.IOServiceBytes[i].Equal(&that1.IOServiceBytes[i]) {
			return false
		}
	}
	if len(this.IOServiceTime) != len(that1.IOServiceTime) {
		return false
	}
	for i := range this.IOServiceTime {
		if !this.IOServiceTime[i].Equal(&that1.IOServiceTime[i]) {
			return false
		}
	}
	if len(this.IOWaitTime) != len(that1.IOWaitTime) {
		return false
	}
	for i := range this.IOWaitTime {
		if !this.IOWaitTime[i].Equal(&that1.IOWaitTime[i]) {
			return false
		}
	}
	if len(this.IOMerged) != len(that1.IOMerged) {
		return false
	}
	for i := range this.IOMerged {
		if !this.IOMerged[i].Equal(&that1.IOMerged[i]) {
			return false
		}
	}
	if len(this.IOQueued) != len(that1.IOQueued) {
		return false
	}
	for i := range this.IOQueued {
		if !this.IOQueued[i].Equal(&that1.IOQueued[i]) {
			return false
		}
	}
	return true
}
func (this *CgroupInfo_Blkio_Throttling) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_Blkio_Throttling)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Throttling)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_Blkio_Throttling")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Throttling but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Throttling but is not nil && this == nil")
	}
	return nil
}
func (this *CgroupInfo_Blkio_Throttling) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_Blkio_Throttling)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Throttling)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *CgroupInfo_Blkio_Throttling_Statistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_Blkio_Throttling_Statistics)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Throttling_Statistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_Blkio_Throttling_Statistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Throttling_Statistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Throttling_Statistics but is not nil && this == nil")
	}
	if !this.Device.Equal(that1.Device) {
		return fmt.Errorf("Device this(%v) Not Equal that(%v)", this.Device, that1.Device)
	}
	if len(this.IOServiced) != len(that1.IOServiced) {
		return fmt.Errorf("IOServiced this(%v) Not Equal that(%v)", len(this.IOServiced), len(that1.IOServiced))
	}
	for i := range this.IOServiced {
		if !this.IOServiced[i].Equal(&that1.IOServiced[i]) {
			return fmt.Errorf("IOServiced this[%v](%v) Not Equal that[%v](%v)", i, this.IOServiced[i], i, that1.IOServiced[i])
		}
	}
	if len(this.IOServiceBytes) != len(that1.IOServiceBytes) {
		return fmt.Errorf("IOServiceBytes this(%v) Not Equal that(%v)", len(this.IOServiceBytes), len(that1.IOServiceBytes))
	}
	for i := range this.IOServiceBytes {
		if !this.IOServiceBytes[i].Equal(&that1.IOServiceBytes[i]) {
			return fmt.Errorf("IOServiceBytes this[%v](%v) Not Equal that[%v](%v)", i, this.IOServiceBytes[i], i, that1.IOServiceBytes[i])
		}
	}
	return nil
}
func (this *CgroupInfo_Blkio_Throttling_Statistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_Blkio_Throttling_Statistics)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Throttling_Statistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Device.Equal(that1.Device) {
		return false
	}
	if len(this.IOServiced) != len(that1.IOServiced) {
		return false
	}
	for i := range this.IOServiced {
		if !this.IOServiced[i].Equal(&that1.IOServiced[i]) {
			return false
		}
	}
	if len(this.IOServiceBytes) != len(that1.IOServiceBytes) {
		return false
	}
	for i := range this.IOServiceBytes {
		if !this.IOServiceBytes[i].Equal(&that1.IOServiceBytes[i]) {
			return false
		}
	}
	return true
}
func (this *CgroupInfo_Blkio_Statistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_Blkio_Statistics)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Statistics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_Blkio_Statistics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Statistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_Blkio_Statistics but is not nil && this == nil")
	}
	if len(this.CFQ) != len(that1.CFQ) {
		return fmt.Errorf("CFQ this(%v) Not Equal that(%v)", len(this.CFQ), len(that1.CFQ))
	}
	for i := range this.CFQ {
		if !this.CFQ[i].Equal(&that1.CFQ[i]) {
			return fmt.Errorf("CFQ this[%v](%v) Not Equal that[%v](%v)", i, this.CFQ[i], i, that1.CFQ[i])
		}
	}
	if len(this.CFQRecursive) != len(that1.CFQRecursive) {
		return fmt.Errorf("CFQRecursive this(%v) Not Equal that(%v)", len(this.CFQRecursive), len(that1.CFQRecursive))
	}
	for i := range this.CFQRecursive {
		if !this.CFQRecursive[i].Equal(&that1.CFQRecursive[i]) {
			return fmt.Errorf("CFQRecursive this[%v](%v) Not Equal that[%v](%v)", i, this.CFQRecursive[i], i, that1.CFQRecursive[i])
		}
	}
	if len(this.Throttling) != len(that1.Throttling) {
		return fmt.Errorf("Throttling this(%v) Not Equal that(%v)", len(this.Throttling), len(that1.Throttling))
	}
	for i := range this.Throttling {
		if !this.Throttling[i].Equal(that1.Throttling[i]) {
			return fmt.Errorf("Throttling this[%v](%v) Not Equal that[%v](%v)", i, this.Throttling[i], i, that1.Throttling[i])
		}
	}
	return nil
}
func (this *CgroupInfo_Blkio_Statistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_Blkio_Statistics)
	if !ok {
		that2, ok := that.(CgroupInfo_Blkio_Statistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.CFQ) != len(that1.CFQ) {
		return false
	}
	for i := range this.CFQ {
		if !this.CFQ[i].Equal(&that1.CFQ[i]) {
			return false
		}
	}
	if len(this.CFQRecursive) != len(that1.CFQRecursive) {
		return false
	}
	for i := range this.CFQRecursive {
		if !this.CFQRecursive[i].Equal(&that1.CFQRecursive[i]) {
			return false
		}
	}
	if len(this.Throttling) != len(that1.Throttling) {
		return false
	}
	for i := range this.Throttling {
		if !this.Throttling[i].Equal(that1.Throttling[i]) {
			return false
		}
	}
	return true
}
func (this *CgroupInfo_NetCls) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CgroupInfo_NetCls)
	if !ok {
		that2, ok := that.(CgroupInfo_NetCls)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *CgroupInfo_NetCls")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CgroupInfo_NetCls but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CgroupInfo_NetCls but is not nil && this == nil")
	}
	if this.ClassID != nil && that1.ClassID != nil {
		if *this.ClassID != *that1.ClassID {
			return fmt.Errorf("ClassID this(%v) Not Equal that(%v)", *this.ClassID, *that1.ClassID)
		}
	} else if this.ClassID != nil {
		return fmt.Errorf("this.ClassID == nil && that.ClassID != nil")
	} else if that1.ClassID != nil {
		return fmt.Errorf("ClassID this(%v) Not Equal that(%v)", this.ClassID, that1.ClassID)
	}
	return nil
}
func (this *CgroupInfo_NetCls) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CgroupInfo_NetCls)
	if !ok {
		that2, ok := that.(CgroupInfo_NetCls)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ClassID != nil && that1.ClassID != nil {
		if *this.ClassID != *that1.ClassID {
			return false
		}
	} else if this.ClassID != nil {
		return false
	} else if that1.ClassID != nil {
		return false
	}
	return true
}
func (this *Labels) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Labels)
	if !ok {
		that2, ok := that.(Labels)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Labels")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Labels but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Labels but is not nil && this == nil")
	}
	if len(this.Labels) != len(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", len(this.Labels), len(that1.Labels))
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(&that1.Labels[i]) {
			return fmt.Errorf("Labels this[%v](%v) Not Equal that[%v](%v)", i, this.Labels[i], i, that1.Labels[i])
		}
	}
	return nil
}
func (this *Labels) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Labels)
	if !ok {
		that2, ok := that.(Labels)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(&that1.Labels[i]) {
			return false
		}
	}
	return true
}
func (this *Label) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Label)
	if !ok {
		that2, ok := that.(Label)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Label")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Label but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Label but is not nil && this == nil")
	}
	if this.Key != that1.Key {
		return fmt.Errorf("Key this(%v) Not Equal that(%v)", this.Key, that1.Key)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *Label) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Label)
	if !ok {
		that2, ok := that.(Label)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	return true
}
func (this *Port) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Port)
	if !ok {
		that2, ok := that.(Port)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Port")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Port but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Port but is not nil && this == nil")
	}
	if this.Number != that1.Number {
		return fmt.Errorf("Number this(%v) Not Equal that(%v)", this.Number, that1.Number)
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if this.Visibility != nil && that1.Visibility != nil {
		if *this.Visibility != *that1.Visibility {
			return fmt.Errorf("Visibility this(%v) Not Equal that(%v)", *this.Visibility, *that1.Visibility)
		}
	} else if this.Visibility != nil {
		return fmt.Errorf("this.Visibility == nil && that.Visibility != nil")
	} else if that1.Visibility != nil {
		return fmt.Errorf("Visibility this(%v) Not Equal that(%v)", this.Visibility, that1.Visibility)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	return nil
}
func (this *Port) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Port)
	if !ok {
		that2, ok := that.(Port)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Number != that1.Number {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if this.Visibility != nil && that1.Visibility != nil {
		if *this.Visibility != *that1.Visibility {
			return false
		}
	} else if this.Visibility != nil {
		return false
	} else if that1.Visibility != nil {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	return true
}
func (this *Ports) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Ports)
	if !ok {
		that2, ok := that.(Ports)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Ports")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Ports but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Ports but is not nil && this == nil")
	}
	if len(this.Ports) != len(that1.Ports) {
		return fmt.Errorf("Ports this(%v) Not Equal that(%v)", len(this.Ports), len(that1.Ports))
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(&that1.Ports[i]) {
			return fmt.Errorf("Ports this[%v](%v) Not Equal that[%v](%v)", i, this.Ports[i], i, that1.Ports[i])
		}
	}
	return nil
}
func (this *Ports) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Ports)
	if !ok {
		that2, ok := that.(Ports)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(&that1.Ports[i]) {
			return false
		}
	}
	return true
}
func (this *DiscoveryInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DiscoveryInfo)
	if !ok {
		that2, ok := that.(DiscoveryInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DiscoveryInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DiscoveryInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DiscoveryInfo but is not nil && this == nil")
	}
	if this.Visibility != that1.Visibility {
		return fmt.Errorf("Visibility this(%v) Not Equal that(%v)", this.Visibility, that1.Visibility)
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Environment != nil && that1.Environment != nil {
		if *this.Environment != *that1.Environment {
			return fmt.Errorf("Environment this(%v) Not Equal that(%v)", *this.Environment, *that1.Environment)
		}
	} else if this.Environment != nil {
		return fmt.Errorf("this.Environment == nil && that.Environment != nil")
	} else if that1.Environment != nil {
		return fmt.Errorf("Environment this(%v) Not Equal that(%v)", this.Environment, that1.Environment)
	}
	if this.Location != nil && that1.Location != nil {
		if *this.Location != *that1.Location {
			return fmt.Errorf("Location this(%v) Not Equal that(%v)", *this.Location, *that1.Location)
		}
	} else if this.Location != nil {
		return fmt.Errorf("this.Location == nil && that.Location != nil")
	} else if that1.Location != nil {
		return fmt.Errorf("Location this(%v) Not Equal that(%v)", this.Location, that1.Location)
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return fmt.Errorf("Version this(%v) Not Equal that(%v)", *this.Version, *that1.Version)
		}
	} else if this.Version != nil {
		return fmt.Errorf("this.Version == nil && that.Version != nil")
	} else if that1.Version != nil {
		return fmt.Errorf("Version this(%v) Not Equal that(%v)", this.Version, that1.Version)
	}
	if !this.Ports.Equal(that1.Ports) {
		return fmt.Errorf("Ports this(%v) Not Equal that(%v)", this.Ports, that1.Ports)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	return nil
}
func (this *DiscoveryInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DiscoveryInfo)
	if !ok {
		that2, ok := that.(DiscoveryInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Visibility != that1.Visibility {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Environment != nil && that1.Environment != nil {
		if *this.Environment != *that1.Environment {
			return false
		}
	} else if this.Environment != nil {
		return false
	} else if that1.Environment != nil {
		return false
	}
	if this.Location != nil && that1.Location != nil {
		if *this.Location != *that1.Location {
			return false
		}
	} else if this.Location != nil {
		return false
	} else if that1.Location != nil {
		return false
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return false
		}
	} else if this.Version != nil {
		return false
	} else if that1.Version != nil {
		return false
	}
	if !this.Ports.Equal(that1.Ports) {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	return true
}
func (this *WeightInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*WeightInfo)
	if !ok {
		that2, ok := that.(WeightInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *WeightInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *WeightInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *WeightInfo but is not nil && this == nil")
	}
	if this.Weight != that1.Weight {
		return fmt.Errorf("Weight this(%v) Not Equal that(%v)", this.Weight, that1.Weight)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	return nil
}
func (this *WeightInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*WeightInfo)
	if !ok {
		that2, ok := that.(WeightInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Weight != that1.Weight {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	return true
}
func (this *VersionInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*VersionInfo)
	if !ok {
		that2, ok := that.(VersionInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *VersionInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *VersionInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *VersionInfo but is not nil && this == nil")
	}
	if this.Version != that1.Version {
		return fmt.Errorf("Version this(%v) Not Equal that(%v)", this.Version, that1.Version)
	}
	if this.BuildDate != nil && that1.BuildDate != nil {
		if *this.BuildDate != *that1.BuildDate {
			return fmt.Errorf("BuildDate this(%v) Not Equal that(%v)", *this.BuildDate, *that1.BuildDate)
		}
	} else if this.BuildDate != nil {
		return fmt.Errorf("this.BuildDate == nil && that.BuildDate != nil")
	} else if that1.BuildDate != nil {
		return fmt.Errorf("BuildDate this(%v) Not Equal that(%v)", this.BuildDate, that1.BuildDate)
	}
	if this.BuildTime != nil && that1.BuildTime != nil {
		if *this.BuildTime != *that1.BuildTime {
			return fmt.Errorf("BuildTime this(%v) Not Equal that(%v)", *this.BuildTime, *that1.BuildTime)
		}
	} else if this.BuildTime != nil {
		return fmt.Errorf("this.BuildTime == nil && that.BuildTime != nil")
	} else if that1.BuildTime != nil {
		return fmt.Errorf("BuildTime this(%v) Not Equal that(%v)", this.BuildTime, that1.BuildTime)
	}
	if this.BuildUser != nil && that1.BuildUser != nil {
		if *this.BuildUser != *that1.BuildUser {
			return fmt.Errorf("BuildUser this(%v) Not Equal that(%v)", *this.BuildUser, *that1.BuildUser)
		}
	} else if this.BuildUser != nil {
		return fmt.Errorf("this.BuildUser == nil && that.BuildUser != nil")
	} else if that1.BuildUser != nil {
		return fmt.Errorf("BuildUser this(%v) Not Equal that(%v)", this.BuildUser, that1.BuildUser)
	}
	if this.GitSHA != nil && that1.GitSHA != nil {
		if *this.GitSHA != *that1.GitSHA {
			return fmt.Errorf("GitSHA this(%v) Not Equal that(%v)", *this.GitSHA, *that1.GitSHA)
		}
	} else if this.GitSHA != nil {
		return fmt.Errorf("this.GitSHA == nil && that.GitSHA != nil")
	} else if that1.GitSHA != nil {
		return fmt.Errorf("GitSHA this(%v) Not Equal that(%v)", this.GitSHA, that1.GitSHA)
	}
	if this.GitBranch != nil && that1.GitBranch != nil {
		if *this.GitBranch != *that1.GitBranch {
			return fmt.Errorf("GitBranch this(%v) Not Equal that(%v)", *this.GitBranch, *that1.GitBranch)
		}
	} else if this.GitBranch != nil {
		return fmt.Errorf("this.GitBranch == nil && that.GitBranch != nil")
	} else if that1.GitBranch != nil {
		return fmt.Errorf("GitBranch this(%v) Not Equal that(%v)", this.GitBranch, that1.GitBranch)
	}
	if this.GitTag != nil && that1.GitTag != nil {
		if *this.GitTag != *that1.GitTag {
			return fmt.Errorf("GitTag this(%v) Not Equal that(%v)", *this.GitTag, *that1.GitTag)
		}
	} else if this.GitTag != nil {
		return fmt.Errorf("this.GitTag == nil && that.GitTag != nil")
	} else if that1.GitTag != nil {
		return fmt.Errorf("GitTag this(%v) Not Equal that(%v)", this.GitTag, that1.GitTag)
	}
	return nil
}
func (this *VersionInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*VersionInfo)
	if !ok {
		that2, ok := that.(VersionInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.BuildDate != nil && that1.BuildDate != nil {
		if *this.BuildDate != *that1.BuildDate {
			return false
		}
	} else if this.BuildDate != nil {
		return false
	} else if that1.BuildDate != nil {
		return false
	}
	if this.BuildTime != nil && that1.BuildTime != nil {
		if *this.BuildTime != *that1.BuildTime {
			return false
		}
	} else if this.BuildTime != nil {
		return false
	} else if that1.BuildTime != nil {
		return false
	}
	if this.BuildUser != nil && that1.BuildUser != nil {
		if *this.BuildUser != *that1.BuildUser {
			return false
		}
	} else if this.BuildUser != nil {
		return false
	} else if that1.BuildUser != nil {
		return false
	}
	if this.GitSHA != nil && that1.GitSHA != nil {
		if *this.GitSHA != *that1.GitSHA {
			return false
		}
	} else if this.GitSHA != nil {
		return false
	} else if that1.GitSHA != nil {
		return false
	}
	if this.GitBranch != nil && that1.GitBranch != nil {
		if *this.GitBranch != *that1.GitBranch {
			return false
		}
	} else if this.GitBranch != nil {
		return false
	} else if that1.GitBranch != nil {
		return false
	}
	if this.GitTag != nil && that1.GitTag != nil {
		if *this.GitTag != *that1.GitTag {
			return false
		}
	} else if this.GitTag != nil {
		return false
	} else if that1.GitTag != nil {
		return false
	}
	return true
}
func (this *Flag) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Flag)
	if !ok {
		that2, ok := that.(Flag)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Flag")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Flag but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Flag but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *Flag) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Flag)
	if !ok {
		that2, ok := that.(Flag)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	return true
}
func (this *Role) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Role)
	if !ok {
		that2, ok := that.(Role)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Role")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Role but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Role but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Weight != that1.Weight {
		return fmt.Errorf("Weight this(%v) Not Equal that(%v)", this.Weight, that1.Weight)
	}
	if len(this.Frameworks) != len(that1.Frameworks) {
		return fmt.Errorf("Frameworks this(%v) Not Equal that(%v)", len(this.Frameworks), len(that1.Frameworks))
	}
	for i := range this.Frameworks {
		if !this.Frameworks[i].Equal(&that1.Frameworks[i]) {
			return fmt.Errorf("Frameworks this[%v](%v) Not Equal that[%v](%v)", i, this.Frameworks[i], i, that1.Frameworks[i])
		}
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	return nil
}
func (this *Role) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Role)
	if !ok {
		that2, ok := that.(Role)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Weight != that1.Weight {
		return false
	}
	if len(this.Frameworks) != len(that1.Frameworks) {
		return false
	}
	for i := range this.Frameworks {
		if !this.Frameworks[i].Equal(&that1.Frameworks[i]) {
			return false
		}
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(&that1.Resources[i]) {
			return false
		}
	}
	return true
}
func (this *Metric) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Metric)
	if !ok {
		that2, ok := that.(Metric)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Metric")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Metric but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Metric but is not nil && this == nil")
	}
	if this.Name != that1.Name {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	return nil
}
func (this *Metric) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Metric)
	if !ok {
		that2, ok := that.(Metric)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	return true
}
func (this *FileInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FileInfo)
	if !ok {
		that2, ok := that.(FileInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *FileInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *FileInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *FileInfo but is not nil && this == nil")
	}
	if this.Path != that1.Path {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if this.Nlink != nil && that1.Nlink != nil {
		if *this.Nlink != *that1.Nlink {
			return fmt.Errorf("Nlink this(%v) Not Equal that(%v)", *this.Nlink, *that1.Nlink)
		}
	} else if this.Nlink != nil {
		return fmt.Errorf("this.Nlink == nil && that.Nlink != nil")
	} else if that1.Nlink != nil {
		return fmt.Errorf("Nlink this(%v) Not Equal that(%v)", this.Nlink, that1.Nlink)
	}
	if this.Size != nil && that1.Size != nil {
		if *this.Size != *that1.Size {
			return fmt.Errorf("Size this(%v) Not Equal that(%v)", *this.Size, *that1.Size)
		}
	} else if this.Size != nil {
		return fmt.Errorf("this.Size == nil && that.Size != nil")
	} else if that1.Size != nil {
		return fmt.Errorf("Size this(%v) Not Equal that(%v)", this.Size, that1.Size)
	}
	if !this.Mtime.Equal(that1.Mtime) {
		return fmt.Errorf("Mtime this(%v) Not Equal that(%v)", this.Mtime, that1.Mtime)
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return fmt.Errorf("Mode this(%v) Not Equal that(%v)", *this.Mode, *that1.Mode)
		}
	} else if this.Mode != nil {
		return fmt.Errorf("this.Mode == nil && that.Mode != nil")
	} else if that1.Mode != nil {
		return fmt.Errorf("Mode this(%v) Not Equal that(%v)", this.Mode, that1.Mode)
	}
	if this.UID != nil && that1.UID != nil {
		if *this.UID != *that1.UID {
			return fmt.Errorf("UID this(%v) Not Equal that(%v)", *this.UID, *that1.UID)
		}
	} else if this.UID != nil {
		return fmt.Errorf("this.UID == nil && that.UID != nil")
	} else if that1.UID != nil {
		return fmt.Errorf("UID this(%v) Not Equal that(%v)", this.UID, that1.UID)
	}
	if this.GID != nil && that1.GID != nil {
		if *this.GID != *that1.GID {
			return fmt.Errorf("GID this(%v) Not Equal that(%v)", *this.GID, *that1.GID)
		}
	} else if this.GID != nil {
		return fmt.Errorf("this.GID == nil && that.GID != nil")
	} else if that1.GID != nil {
		return fmt.Errorf("GID this(%v) Not Equal that(%v)", this.GID, that1.GID)
	}
	return nil
}
func (this *FileInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FileInfo)
	if !ok {
		that2, ok := that.(FileInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Nlink != nil && that1.Nlink != nil {
		if *this.Nlink != *that1.Nlink {
			return false
		}
	} else if this.Nlink != nil {
		return false
	} else if that1.Nlink != nil {
		return false
	}
	if this.Size != nil && that1.Size != nil {
		if *this.Size != *that1.Size {
			return false
		}
	} else if this.Size != nil {
		return false
	} else if that1.Size != nil {
		return false
	}
	if !this.Mtime.Equal(that1.Mtime) {
		return false
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return false
		}
	} else if this.Mode != nil {
		return false
	} else if that1.Mode != nil {
		return false
	}
	if this.UID != nil && that1.UID != nil {
		if *this.UID != *that1.UID {
			return false
		}
	} else if this.UID != nil {
		return false
	} else if that1.UID != nil {
		return false
	}
	if this.GID != nil && that1.GID != nil {
		if *this.GID != *that1.GID {
			return false
		}
	} else if this.GID != nil {
		return false
	} else if that1.GID != nil {
		return false
	}
	return true
}
func (this *Device) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Device)
	if !ok {
		that2, ok := that.(Device)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Device")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Device but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Device but is not nil && this == nil")
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return fmt.Errorf("Path this(%v) Not Equal that(%v)", *this.Path, *that1.Path)
		}
	} else if this.Path != nil {
		return fmt.Errorf("this.Path == nil && that.Path != nil")
	} else if that1.Path != nil {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if !this.Number.Equal(that1.Number) {
		return fmt.Errorf("Number this(%v) Not Equal that(%v)", this.Number, that1.Number)
	}
	return nil
}
func (this *Device) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Device)
	if !ok {
		that2, ok := that.(Device)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return false
		}
	} else if this.Path != nil {
		return false
	} else if that1.Path != nil {
		return false
	}
	if !this.Number.Equal(that1.Number) {
		return false
	}
	return true
}
func (this *Device_Number) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Device_Number)
	if !ok {
		that2, ok := that.(Device_Number)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Device_Number")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Device_Number but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Device_Number but is not nil && this == nil")
	}
	if this.MajorNumber != nil && that1.MajorNumber != nil {
		if *this.MajorNumber != *that1.MajorNumber {
			return fmt.Errorf("MajorNumber this(%v) Not Equal that(%v)", *this.MajorNumber, *that1.MajorNumber)
		}
	} else if this.MajorNumber != nil {
		return fmt.Errorf("this.MajorNumber == nil && that.MajorNumber != nil")
	} else if that1.MajorNumber != nil {
		return fmt.Errorf("MajorNumber this(%v) Not Equal that(%v)", this.MajorNumber, that1.MajorNumber)
	}
	if this.MinorNumber != nil && that1.MinorNumber != nil {
		if *this.MinorNumber != *that1.MinorNumber {
			return fmt.Errorf("MinorNumber this(%v) Not Equal that(%v)", *this.MinorNumber, *that1.MinorNumber)
		}
	} else if this.MinorNumber != nil {
		return fmt.Errorf("this.MinorNumber == nil && that.MinorNumber != nil")
	} else if that1.MinorNumber != nil {
		return fmt.Errorf("MinorNumber this(%v) Not Equal that(%v)", this.MinorNumber, that1.MinorNumber)
	}
	return nil
}
func (this *Device_Number) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Device_Number)
	if !ok {
		that2, ok := that.(Device_Number)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.MajorNumber != nil && that1.MajorNumber != nil {
		if *this.MajorNumber != *that1.MajorNumber {
			return false
		}
	} else if this.MajorNumber != nil {
		return false
	} else if that1.MajorNumber != nil {
		return false
	}
	if this.MinorNumber != nil && that1.MinorNumber != nil {
		if *this.MinorNumber != *that1.MinorNumber {
			return false
		}
	} else if this.MinorNumber != nil {
		return false
	} else if that1.MinorNumber != nil {
		return false
	}
	return true
}
func (this *DeviceAccess) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DeviceAccess)
	if !ok {
		that2, ok := that.(DeviceAccess)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DeviceAccess")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DeviceAccess but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DeviceAccess but is not nil && this == nil")
	}
	if !this.Device.Equal(&that1.Device) {
		return fmt.Errorf("Device this(%v) Not Equal that(%v)", this.Device, that1.Device)
	}
	if !this.Access.Equal(&that1.Access) {
		return fmt.Errorf("Access this(%v) Not Equal that(%v)", this.Access, that1.Access)
	}
	return nil
}
func (this *DeviceAccess) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DeviceAccess)
	if !ok {
		that2, ok := that.(DeviceAccess)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Device.Equal(&that1.Device) {
		return false
	}
	if !this.Access.Equal(&that1.Access) {
		return false
	}
	return true
}
func (this *DeviceAccess_Access) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DeviceAccess_Access)
	if !ok {
		that2, ok := that.(DeviceAccess_Access)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DeviceAccess_Access")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DeviceAccess_Access but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DeviceAccess_Access but is not nil && this == nil")
	}
	if this.Read != nil && that1.Read != nil {
		if *this.Read != *that1.Read {
			return fmt.Errorf("Read this(%v) Not Equal that(%v)", *this.Read, *that1.Read)
		}
	} else if this.Read != nil {
		return fmt.Errorf("this.Read == nil && that.Read != nil")
	} else if that1.Read != nil {
		return fmt.Errorf("Read this(%v) Not Equal that(%v)", this.Read, that1.Read)
	}
	if this.Write != nil && that1.Write != nil {
		if *this.Write != *that1.Write {
			return fmt.Errorf("Write this(%v) Not Equal that(%v)", *this.Write, *that1.Write)
		}
	} else if this.Write != nil {
		return fmt.Errorf("this.Write == nil && that.Write != nil")
	} else if that1.Write != nil {
		return fmt.Errorf("Write this(%v) Not Equal that(%v)", this.Write, that1.Write)
	}
	if this.Mknod != nil && that1.Mknod != nil {
		if *this.Mknod != *that1.Mknod {
			return fmt.Errorf("Mknod this(%v) Not Equal that(%v)", *this.Mknod, *that1.Mknod)
		}
	} else if this.Mknod != nil {
		return fmt.Errorf("this.Mknod == nil && that.Mknod != nil")
	} else if that1.Mknod != nil {
		return fmt.Errorf("Mknod this(%v) Not Equal that(%v)", this.Mknod, that1.Mknod)
	}
	return nil
}
func (this *DeviceAccess_Access) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DeviceAccess_Access)
	if !ok {
		that2, ok := that.(DeviceAccess_Access)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Read != nil && that1.Read != nil {
		if *this.Read != *that1.Read {
			return false
		}
	} else if this.Read != nil {
		return false
	} else if that1.Read != nil {
		return false
	}
	if this.Write != nil && that1.Write != nil {
		if *this.Write != *that1.Write {
			return false
		}
	} else if this.Write != nil {
		return false
	} else if that1.Write != nil {
		return false
	}
	if this.Mknod != nil && that1.Mknod != nil {
		if *this.Mknod != *that1.Mknod {
			return false
		}
	} else if this.Mknod != nil {
		return false
	} else if that1.Mknod != nil {
		return false
	}
	return true
}
func (this *DeviceWhitelist) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DeviceWhitelist)
	if !ok {
		that2, ok := that.(DeviceWhitelist)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *DeviceWhitelist")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DeviceWhitelist but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DeviceWhitelist but is not nil && this == nil")
	}
	if len(this.AllowedDevices) != len(that1.AllowedDevices) {
		return fmt.Errorf("AllowedDevices this(%v) Not Equal that(%v)", len(this.AllowedDevices), len(that1.AllowedDevices))
	}
	for i := range this.AllowedDevices {
		if !this.AllowedDevices[i].Equal(&that1.AllowedDevices[i]) {
			return fmt.Errorf("AllowedDevices this[%v](%v) Not Equal that[%v](%v)", i, this.AllowedDevices[i], i, that1.AllowedDevices[i])
		}
	}
	return nil
}
func (this *DeviceWhitelist) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DeviceWhitelist)
	if !ok {
		that2, ok := that.(DeviceWhitelist)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.AllowedDevices) != len(that1.AllowedDevices) {
		return false
	}
	for i := range this.AllowedDevices {
		if !this.AllowedDevices[i].Equal(&that1.AllowedDevices[i]) {
			return false
		}
	}
	return true
}
func (this *FrameworkID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.FrameworkID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OfferID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.OfferID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AgentID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.AgentID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.TaskID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ExecutorID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.ExecutorID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.ContainerID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	if this.Parent != nil {
		s = append(s, "Parent: "+fmt.Sprintf("%#v", this.Parent)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceProviderID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.ResourceProviderID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OperationID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.OperationID{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TimeInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.TimeInfo{")
	s = append(s, "Nanoseconds: "+fmt.Sprintf("%#v", this.Nanoseconds)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DurationInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.DurationInfo{")
	s = append(s, "Nanoseconds: "+fmt.Sprintf("%#v", this.Nanoseconds)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Address) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.Address{")
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.IP != nil {
		s = append(s, "IP: "+valueToGoStringMesos(this.IP, "string")+",\n")
	}
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *URL) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.URL{")
	s = append(s, "Scheme: "+fmt.Sprintf("%#v", this.Scheme)+",\n")
	s = append(s, "Address: "+strings.Replace(this.Address.GoString(), `&`, ``, 1)+",\n")
	if this.Path != nil {
		s = append(s, "Path: "+valueToGoStringMesos(this.Path, "string")+",\n")
	}
	if this.Query != nil {
		s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	}
	if this.Fragment != nil {
		s = append(s, "Fragment: "+valueToGoStringMesos(this.Fragment, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Unavailability) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Unavailability{")
	s = append(s, "Start: "+strings.Replace(this.Start.GoString(), `&`, ``, 1)+",\n")
	if this.Duration != nil {
		s = append(s, "Duration: "+fmt.Sprintf("%#v", this.Duration)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MachineID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.MachineID{")
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.IP != nil {
		s = append(s, "IP: "+valueToGoStringMesos(this.IP, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MachineInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.MachineInfo{")
	s = append(s, "ID: "+strings.Replace(this.ID.GoString(), `&`, ``, 1)+",\n")
	if this.Mode != nil {
		s = append(s, "Mode: "+valueToGoStringMesos(this.Mode, "MachineInfo_Mode")+",\n")
	}
	if this.Unavailability != nil {
		s = append(s, "Unavailability: "+fmt.Sprintf("%#v", this.Unavailability)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FrameworkInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&mesos.FrameworkInfo{")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.ID != nil {
		s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	}
	if this.FailoverTimeout != nil {
		s = append(s, "FailoverTimeout: "+valueToGoStringMesos(this.FailoverTimeout, "float64")+",\n")
	}
	if this.Checkpoint != nil {
		s = append(s, "Checkpoint: "+valueToGoStringMesos(this.Checkpoint, "bool")+",\n")
	}
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringMesos(this.Role, "string")+",\n")
	}
	if this.Roles != nil {
		s = append(s, "Roles: "+fmt.Sprintf("%#v", this.Roles)+",\n")
	}
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringMesos(this.Principal, "string")+",\n")
	}
	if this.WebUiURL != nil {
		s = append(s, "WebUiURL: "+valueToGoStringMesos(this.WebUiURL, "string")+",\n")
	}
	if this.Capabilities != nil {
		s = append(s, "Capabilities: "+fmt.Sprintf("%#v", this.Capabilities)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FrameworkInfo_Capability) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.FrameworkInfo_Capability{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesos.CheckInfo{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.HTTP != nil {
		s = append(s, "HTTP: "+fmt.Sprintf("%#v", this.HTTP)+",\n")
	}
	if this.TCP != nil {
		s = append(s, "TCP: "+fmt.Sprintf("%#v", this.TCP)+",\n")
	}
	if this.DelaySeconds != nil {
		s = append(s, "DelaySeconds: "+valueToGoStringMesos(this.DelaySeconds, "float64")+",\n")
	}
	if this.IntervalSeconds != nil {
		s = append(s, "IntervalSeconds: "+valueToGoStringMesos(this.IntervalSeconds, "float64")+",\n")
	}
	if this.TimeoutSeconds != nil {
		s = append(s, "TimeoutSeconds: "+valueToGoStringMesos(this.TimeoutSeconds, "float64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckInfo_Command) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CheckInfo_Command{")
	s = append(s, "Command: "+strings.Replace(this.Command.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckInfo_Http) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.CheckInfo_Http{")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	if this.Path != nil {
		s = append(s, "Path: "+valueToGoStringMesos(this.Path, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckInfo_Tcp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CheckInfo_Tcp{")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HealthCheck) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&mesos.HealthCheck{")
	if this.DelaySeconds != nil {
		s = append(s, "DelaySeconds: "+valueToGoStringMesos(this.DelaySeconds, "float64")+",\n")
	}
	if this.IntervalSeconds != nil {
		s = append(s, "IntervalSeconds: "+valueToGoStringMesos(this.IntervalSeconds, "float64")+",\n")
	}
	if this.TimeoutSeconds != nil {
		s = append(s, "TimeoutSeconds: "+valueToGoStringMesos(this.TimeoutSeconds, "float64")+",\n")
	}
	if this.ConsecutiveFailures != nil {
		s = append(s, "ConsecutiveFailures: "+valueToGoStringMesos(this.ConsecutiveFailures, "uint32")+",\n")
	}
	if this.GracePeriodSeconds != nil {
		s = append(s, "GracePeriodSeconds: "+valueToGoStringMesos(this.GracePeriodSeconds, "float64")+",\n")
	}
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.HTTP != nil {
		s = append(s, "HTTP: "+fmt.Sprintf("%#v", this.HTTP)+",\n")
	}
	if this.TCP != nil {
		s = append(s, "TCP: "+fmt.Sprintf("%#v", this.TCP)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HealthCheck_HTTPCheckInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.HealthCheck_HTTPCheckInfo{")
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "NetworkInfo_Protocol")+",\n")
	}
	if this.Scheme != nil {
		s = append(s, "Scheme: "+valueToGoStringMesos(this.Scheme, "string")+",\n")
	}
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	if this.Path != nil {
		s = append(s, "Path: "+valueToGoStringMesos(this.Path, "string")+",\n")
	}
	if this.Statuses != nil {
		s = append(s, "Statuses: "+fmt.Sprintf("%#v", this.Statuses)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HealthCheck_TCPCheckInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.HealthCheck_TCPCheckInfo{")
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "NetworkInfo_Protocol")+",\n")
	}
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *KillPolicy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.KillPolicy{")
	if this.GracePeriod != nil {
		s = append(s, "GracePeriod: "+fmt.Sprintf("%#v", this.GracePeriod)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CommandInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesos.CommandInfo{")
	if this.URIs != nil {
		s = append(s, "URIs: "+fmt.Sprintf("%#v", this.URIs)+",\n")
	}
	if this.Environment != nil {
		s = append(s, "Environment: "+fmt.Sprintf("%#v", this.Environment)+",\n")
	}
	if this.Shell != nil {
		s = append(s, "Shell: "+valueToGoStringMesos(this.Shell, "bool")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.Arguments != nil {
		s = append(s, "Arguments: "+fmt.Sprintf("%#v", this.Arguments)+",\n")
	}
	if this.User != nil {
		s = append(s, "User: "+valueToGoStringMesos(this.User, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CommandInfo_URI) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.CommandInfo_URI{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	if this.Executable != nil {
		s = append(s, "Executable: "+valueToGoStringMesos(this.Executable, "bool")+",\n")
	}
	if this.Extract != nil {
		s = append(s, "Extract: "+valueToGoStringMesos(this.Extract, "bool")+",\n")
	}
	if this.Cache != nil {
		s = append(s, "Cache: "+valueToGoStringMesos(this.Cache, "bool")+",\n")
	}
	if this.OutputFile != nil {
		s = append(s, "OutputFile: "+valueToGoStringMesos(this.OutputFile, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ExecutorInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&mesos.ExecutorInfo{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "ExecutorID: "+strings.Replace(this.ExecutorID.GoString(), `&`, ``, 1)+",\n")
	if this.FrameworkID != nil {
		s = append(s, "FrameworkID: "+fmt.Sprintf("%#v", this.FrameworkID)+",\n")
	}
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Source != nil {
		s = append(s, "Source: "+valueToGoStringMesos(this.Source, "string")+",\n")
	}
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMesos(this.Data, "byte")+",\n")
	}
	if this.Discovery != nil {
		s = append(s, "Discovery: "+fmt.Sprintf("%#v", this.Discovery)+",\n")
	}
	if this.ShutdownGracePeriod != nil {
		s = append(s, "ShutdownGracePeriod: "+fmt.Sprintf("%#v", this.ShutdownGracePeriod)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DomainInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.DomainInfo{")
	if this.FaultDomain != nil {
		s = append(s, "FaultDomain: "+fmt.Sprintf("%#v", this.FaultDomain)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DomainInfo_FaultDomain) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.DomainInfo_FaultDomain{")
	s = append(s, "Region: "+strings.Replace(this.Region.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Zone: "+strings.Replace(this.Zone.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DomainInfo_FaultDomain_RegionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.DomainInfo_FaultDomain_RegionInfo{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DomainInfo_FaultDomain_ZoneInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.DomainInfo_FaultDomain_ZoneInfo{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MasterInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&mesos.MasterInfo{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	s = append(s, "IP: "+fmt.Sprintf("%#v", this.IP)+",\n")
	if this.Port != nil {
		s = append(s, "Port: "+valueToGoStringMesos(this.Port, "uint32")+",\n")
	}
	if this.PID != nil {
		s = append(s, "PID: "+valueToGoStringMesos(this.PID, "string")+",\n")
	}
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Version != nil {
		s = append(s, "Version: "+valueToGoStringMesos(this.Version, "string")+",\n")
	}
	if this.Address != nil {
		s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	}
	if this.Domain != nil {
		s = append(s, "Domain: "+fmt.Sprintf("%#v", this.Domain)+",\n")
	}
	if this.Capabilities != nil {
		s = append(s, "Capabilities: "+fmt.Sprintf("%#v", this.Capabilities)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MasterInfo_Capability) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.MasterInfo_Capability{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AgentInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesos.AgentInfo{")
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	if this.Port != nil {
		s = append(s, "Port: "+valueToGoStringMesos(this.Port, "int32")+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	if this.ID != nil {
		s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	}
	if this.Domain != nil {
		s = append(s, "Domain: "+fmt.Sprintf("%#v", this.Domain)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AgentInfo_Capability) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.AgentInfo_Capability{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CSIPluginContainerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.CSIPluginContainerInfo{")
	if this.Services != nil {
		s = append(s, "Services: "+fmt.Sprintf("%#v", this.Services)+",\n")
	}
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CSIPluginInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.CSIPluginInfo{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Containers != nil {
		s = append(s, "Containers: "+fmt.Sprintf("%#v", this.Containers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceProviderInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesos.ResourceProviderInfo{")
	if this.ID != nil {
		s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	}
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.DefaultReservations != nil {
		s = append(s, "DefaultReservations: "+fmt.Sprintf("%#v", this.DefaultReservations)+",\n")
	}
	if this.Storage != nil {
		s = append(s, "Storage: "+fmt.Sprintf("%#v", this.Storage)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceProviderInfo_Storage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.ResourceProviderInfo_Storage{")
	s = append(s, "Plugin: "+strings.Replace(this.Plugin.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.Value{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Scalar != nil {
		s = append(s, "Scalar: "+fmt.Sprintf("%#v", this.Scalar)+",\n")
	}
	if this.Ranges != nil {
		s = append(s, "Ranges: "+fmt.Sprintf("%#v", this.Ranges)+",\n")
	}
	if this.Set != nil {
		s = append(s, "Set: "+fmt.Sprintf("%#v", this.Set)+",\n")
	}
	if this.Text != nil {
		s = append(s, "Text: "+fmt.Sprintf("%#v", this.Text)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Scalar) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Value_Scalar{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Range) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Value_Range{")
	s = append(s, "Begin: "+fmt.Sprintf("%#v", this.Begin)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Ranges) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Value_Ranges{")
	if this.Range != nil {
		s = append(s, "Range: "+fmt.Sprintf("%#v", this.Range)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Set) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Value_Set{")
	if this.Item != nil {
		s = append(s, "Item: "+fmt.Sprintf("%#v", this.Item)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Text) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Value_Text{")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Attribute) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesos.Attribute{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Scalar != nil {
		s = append(s, "Scalar: "+fmt.Sprintf("%#v", this.Scalar)+",\n")
	}
	if this.Ranges != nil {
		s = append(s, "Ranges: "+fmt.Sprintf("%#v", this.Ranges)+",\n")
	}
	if this.Set != nil {
		s = append(s, "Set: "+fmt.Sprintf("%#v", this.Set)+",\n")
	}
	if this.Text != nil {
		s = append(s, "Text: "+fmt.Sprintf("%#v", this.Text)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&mesos.Resource{")
	if this.ProviderID != nil {
		s = append(s, "ProviderID: "+fmt.Sprintf("%#v", this.ProviderID)+",\n")
	}
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "Value_Type")+",\n")
	}
	if this.Scalar != nil {
		s = append(s, "Scalar: "+fmt.Sprintf("%#v", this.Scalar)+",\n")
	}
	if this.Ranges != nil {
		s = append(s, "Ranges: "+fmt.Sprintf("%#v", this.Ranges)+",\n")
	}
	if this.Set != nil {
		s = append(s, "Set: "+fmt.Sprintf("%#v", this.Set)+",\n")
	}
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringMesos(this.Role, "string")+",\n")
	}
	if this.AllocationInfo != nil {
		s = append(s, "AllocationInfo: "+fmt.Sprintf("%#v", this.AllocationInfo)+",\n")
	}
	if this.Reservation != nil {
		s = append(s, "Reservation: "+fmt.Sprintf("%#v", this.Reservation)+",\n")
	}
	if this.Reservations != nil {
		s = append(s, "Reservations: "+fmt.Sprintf("%#v", this.Reservations)+",\n")
	}
	if this.Disk != nil {
		s = append(s, "Disk: "+fmt.Sprintf("%#v", this.Disk)+",\n")
	}
	if this.Revocable != nil {
		s = append(s, "Revocable: "+fmt.Sprintf("%#v", this.Revocable)+",\n")
	}
	if this.Shared != nil {
		s = append(s, "Shared: "+fmt.Sprintf("%#v", this.Shared)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_AllocationInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Resource_AllocationInfo{")
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringMesos(this.Role, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_ReservationInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.Resource_ReservationInfo{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "Resource_ReservationInfo_Type")+",\n")
	}
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringMesos(this.Role, "string")+",\n")
	}
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringMesos(this.Principal, "string")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_DiskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.Resource_DiskInfo{")
	if this.Persistence != nil {
		s = append(s, "Persistence: "+fmt.Sprintf("%#v", this.Persistence)+",\n")
	}
	if this.Volume != nil {
		s = append(s, "Volume: "+fmt.Sprintf("%#v", this.Volume)+",\n")
	}
	if this.Source != nil {
		s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_DiskInfo_Persistence) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Resource_DiskInfo_Persistence{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringMesos(this.Principal, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_DiskInfo_Source) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesos.Resource_DiskInfo_Source{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Path != nil {
		s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	}
	if this.Mount != nil {
		s = append(s, "Mount: "+fmt.Sprintf("%#v", this.Mount)+",\n")
	}
	if this.ID != nil {
		s = append(s, "ID: "+valueToGoStringMesos(this.ID, "string")+",\n")
	}
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.Profile != nil {
		s = append(s, "Profile: "+valueToGoStringMesos(this.Profile, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_DiskInfo_Source_Path) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Resource_DiskInfo_Source_Path{")
	if this.Root != nil {
		s = append(s, "Root: "+valueToGoStringMesos(this.Root, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_DiskInfo_Source_Mount) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Resource_DiskInfo_Source_Mount{")
	if this.Root != nil {
		s = append(s, "Root: "+valueToGoStringMesos(this.Root, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_RevocableInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesos.Resource_RevocableInfo{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_SharedInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesos.Resource_SharedInfo{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TrafficControlStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&mesos.TrafficControlStatistics{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	if this.Backlog != nil {
		s = append(s, "Backlog: "+valueToGoStringMesos(this.Backlog, "uint64")+",\n")
	}
	if this.Bytes != nil {
		s = append(s, "Bytes: "+valueToGoStringMesos(this.Bytes, "uint64")+",\n")
	}
	if this.Drops != nil {
		s = append(s, "Drops: "+valueToGoStringMesos(this.Drops, "uint64")+",\n")
	}
	if this.Overlimits != nil {
		s = append(s, "Overlimits: "+valueToGoStringMesos(this.Overlimits, "uint64")+",\n")
	}
	if this.Packets != nil {
		s = append(s, "Packets: "+valueToGoStringMesos(this.Packets, "uint64")+",\n")
	}
	if this.Qlen != nil {
		s = append(s, "Qlen: "+valueToGoStringMesos(this.Qlen, "uint64")+",\n")
	}
	if this.RateBPS != nil {
		s = append(s, "RateBPS: "+valueToGoStringMesos(this.RateBPS, "uint64")+",\n")
	}
	if this.RatePPS != nil {
		s = append(s, "RatePPS: "+valueToGoStringMesos(this.RatePPS, "uint64")+",\n")
	}
	if this.Requeues != nil {
		s = append(s, "Requeues: "+valueToGoStringMesos(this.Requeues, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IpStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 23)
	s = append(s, "&mesos.IpStatistics{")
	if this.Forwarding != nil {
		s = append(s, "Forwarding: "+valueToGoStringMesos(this.Forwarding, "int64")+",\n")
	}
	if this.DefaultTTL != nil {
		s = append(s, "DefaultTTL: "+valueToGoStringMesos(this.DefaultTTL, "int64")+",\n")
	}
	if this.InReceives != nil {
		s = append(s, "InReceives: "+valueToGoStringMesos(this.InReceives, "int64")+",\n")
	}
	if this.InHdrErrors != nil {
		s = append(s, "InHdrErrors: "+valueToGoStringMesos(this.InHdrErrors, "int64")+",\n")
	}
	if this.InAddrErrors != nil {
		s = append(s, "InAddrErrors: "+valueToGoStringMesos(this.InAddrErrors, "int64")+",\n")
	}
	if this.ForwDatagrams != nil {
		s = append(s, "ForwDatagrams: "+valueToGoStringMesos(this.ForwDatagrams, "int64")+",\n")
	}
	if this.InUnknownProtos != nil {
		s = append(s, "InUnknownProtos: "+valueToGoStringMesos(this.InUnknownProtos, "int64")+",\n")
	}
	if this.InDiscards != nil {
		s = append(s, "InDiscards: "+valueToGoStringMesos(this.InDiscards, "int64")+",\n")
	}
	if this.InDelivers != nil {
		s = append(s, "InDelivers: "+valueToGoStringMesos(this.InDelivers, "int64")+",\n")
	}
	if this.OutRequests != nil {
		s = append(s, "OutRequests: "+valueToGoStringMesos(this.OutRequests, "int64")+",\n")
	}
	if this.OutDiscards != nil {
		s = append(s, "OutDiscards: "+valueToGoStringMesos(this.OutDiscards, "int64")+",\n")
	}
	if this.OutNoRoutes != nil {
		s = append(s, "OutNoRoutes: "+valueToGoStringMesos(this.OutNoRoutes, "int64")+",\n")
	}
	if this.ReasmTimeout != nil {
		s = append(s, "ReasmTimeout: "+valueToGoStringMesos(this.ReasmTimeout, "int64")+",\n")
	}
	if this.ReasmReqds != nil {
		s = append(s, "ReasmReqds: "+valueToGoStringMesos(this.ReasmReqds, "int64")+",\n")
	}
	if this.ReasmOKs != nil {
		s = append(s, "ReasmOKs: "+valueToGoStringMesos(this.ReasmOKs, "int64")+",\n")
	}
	if this.ReasmFails != nil {
		s = append(s, "ReasmFails: "+valueToGoStringMesos(this.ReasmFails, "int64")+",\n")
	}
	if this.FragOKs != nil {
		s = append(s, "FragOKs: "+valueToGoStringMesos(this.FragOKs, "int64")+",\n")
	}
	if this.FragFails != nil {
		s = append(s, "FragFails: "+valueToGoStringMesos(this.FragFails, "int64")+",\n")
	}
	if this.FragCreates != nil {
		s = append(s, "FragCreates: "+valueToGoStringMesos(this.FragCreates, "int64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IcmpStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 31)
	s = append(s, "&mesos.IcmpStatistics{")
	if this.InMsgs != nil {
		s = append(s, "InMsgs: "+valueToGoStringMesos(this.InMsgs, "int64")+",\n")
	}
	if this.InErrors != nil {
		s = append(s, "InErrors: "+valueToGoStringMesos(this.InErrors, "int64")+",\n")
	}
	if this.InCsumErrors != nil {
		s = append(s, "InCsumErrors: "+valueToGoStringMesos(this.InCsumErrors, "int64")+",\n")
	}
	if this.InDestUnreachs != nil {
		s = append(s, "InDestUnreachs: "+valueToGoStringMesos(this.InDestUnreachs, "int64")+",\n")
	}
	if this.InTimeExcds != nil {
		s = append(s, "InTimeExcds: "+valueToGoStringMesos(this.InTimeExcds, "int64")+",\n")
	}
	if this.InParmProbs != nil {
		s = append(s, "InParmProbs: "+valueToGoStringMesos(this.InParmProbs, "int64")+",\n")
	}
	if this.InSrcQuenchs != nil {
		s = append(s, "InSrcQuenchs: "+valueToGoStringMesos(this.InSrcQuenchs, "int64")+",\n")
	}
	if this.InRedirects != nil {
		s = append(s, "InRedirects: "+valueToGoStringMesos(this.InRedirects, "int64")+",\n")
	}
	if this.InEchos != nil {
		s = append(s, "InEchos: "+valueToGoStringMesos(this.InEchos, "int64")+",\n")
	}
	if this.InEchoReps != nil {
		s = append(s, "InEchoReps: "+valueToGoStringMesos(this.InEchoReps, "int64")+",\n")
	}
	if this.InTimestamps != nil {
		s = append(s, "InTimestamps: "+valueToGoStringMesos(this.InTimestamps, "int64")+",\n")
	}
	if this.InTimestampReps != nil {
		s = append(s, "InTimestampReps: "+valueToGoStringMesos(this.InTimestampReps, "int64")+",\n")
	}
	if this.InAddrMasks != nil {
		s = append(s, "InAddrMasks: "+valueToGoStringMesos(this.InAddrMasks, "int64")+",\n")
	}
	if this.InAddrMaskReps != nil {
		s = append(s, "InAddrMaskReps: "+valueToGoStringMesos(this.InAddrMaskReps, "int64")+",\n")
	}
	if this.OutMsgs != nil {
		s = append(s, "OutMsgs: "+valueToGoStringMesos(this.OutMsgs, "int64")+",\n")
	}
	if this.OutErrors != nil {
		s = append(s, "OutErrors: "+valueToGoStringMesos(this.OutErrors, "int64")+",\n")
	}
	if this.OutDestUnreachs != nil {
		s = append(s, "OutDestUnreachs: "+valueToGoStringMesos(this.OutDestUnreachs, "int64")+",\n")
	}
	if this.OutTimeExcds != nil {
		s = append(s, "OutTimeExcds: "+valueToGoStringMesos(this.OutTimeExcds, "int64")+",\n")
	}
	if this.OutParmProbs != nil {
		s = append(s, "OutParmProbs: "+valueToGoStringMesos(this.OutParmProbs, "int64")+",\n")
	}
	if this.OutSrcQuenchs != nil {
		s = append(s, "OutSrcQuenchs: "+valueToGoStringMesos(this.OutSrcQuenchs, "int64")+",\n")
	}
	if this.OutRedirects != nil {
		s = append(s, "OutRedirects: "+valueToGoStringMesos(this.OutRedirects, "int64")+",\n")
	}
	if this.OutEchos != nil {
		s = append(s, "OutEchos: "+valueToGoStringMesos(this.OutEchos, "int64")+",\n")
	}
	if this.OutEchoReps != nil {
		s = append(s, "OutEchoReps: "+valueToGoStringMesos(this.OutEchoReps, "int64")+",\n")
	}
	if this.OutTimestamps != nil {
		s = append(s, "OutTimestamps: "+valueToGoStringMesos(this.OutTimestamps, "int64")+",\n")
	}
	if this.OutTimestampReps != nil {
		s = append(s, "OutTimestampReps: "+valueToGoStringMesos(this.OutTimestampReps, "int64")+",\n")
	}
	if this.OutAddrMasks != nil {
		s = append(s, "OutAddrMasks: "+valueToGoStringMesos(this.OutAddrMasks, "int64")+",\n")
	}
	if this.OutAddrMaskReps != nil {
		s = append(s, "OutAddrMaskReps: "+valueToGoStringMesos(this.OutAddrMaskReps, "int64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TcpStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 19)
	s = append(s, "&mesos.TcpStatistics{")
	if this.RtoAlgorithm != nil {
		s = append(s, "RtoAlgorithm: "+valueToGoStringMesos(this.RtoAlgorithm, "int64")+",\n")
	}
	if this.RtoMin != nil {
		s = append(s, "RtoMin: "+valueToGoStringMesos(this.RtoMin, "int64")+",\n")
	}
	if this.RtoMax != nil {
		s = append(s, "RtoMax: "+valueToGoStringMesos(this.RtoMax, "int64")+",\n")
	}
	if this.MaxConn != nil {
		s = append(s, "MaxConn: "+valueToGoStringMesos(this.MaxConn, "int64")+",\n")
	}
	if this.ActiveOpens != nil {
		s = append(s, "ActiveOpens: "+valueToGoStringMesos(this.ActiveOpens, "int64")+",\n")
	}
	if this.PassiveOpens != nil {
		s = append(s, "PassiveOpens: "+valueToGoStringMesos(this.PassiveOpens, "int64")+",\n")
	}
	if this.AttemptFails != nil {
		s = append(s, "AttemptFails: "+valueToGoStringMesos(this.AttemptFails, "int64")+",\n")
	}
	if this.EstabResets != nil {
		s = append(s, "EstabResets: "+valueToGoStringMesos(this.EstabResets, "int64")+",\n")
	}
	if this.CurrEstab != nil {
		s = append(s, "CurrEstab: "+valueToGoStringMesos(this.CurrEstab, "int64")+",\n")
	}
	if this.InSegs != nil {
		s = append(s, "InSegs: "+valueToGoStringMesos(this.InSegs, "int64")+",\n")
	}
	if this.OutSegs != nil {
		s = append(s, "OutSegs: "+valueToGoStringMesos(this.OutSegs, "int64")+",\n")
	}
	if this.RetransSegs != nil {
		s = append(s, "RetransSegs: "+valueToGoStringMesos(this.RetransSegs, "int64")+",\n")
	}
	if this.InErrs != nil {
		s = append(s, "InErrs: "+valueToGoStringMesos(this.InErrs, "int64")+",\n")
	}
	if this.OutRsts != nil {
		s = append(s, "OutRsts: "+valueToGoStringMesos(this.OutRsts, "int64")+",\n")
	}
	if this.InCsumErrors != nil {
		s = append(s, "InCsumErrors: "+valueToGoStringMesos(this.InCsumErrors, "int64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UdpStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&mesos.UdpStatistics{")
	if this.InDatagrams != nil {
		s = append(s, "InDatagrams: "+valueToGoStringMesos(this.InDatagrams, "int64")+",\n")
	}
	if this.NoPorts != nil {
		s = append(s, "NoPorts: "+valueToGoStringMesos(this.NoPorts, "int64")+",\n")
	}
	if this.InErrors != nil {
		s = append(s, "InErrors: "+valueToGoStringMesos(this.InErrors, "int64")+",\n")
	}
	if this.OutDatagrams != nil {
		s = append(s, "OutDatagrams: "+valueToGoStringMesos(this.OutDatagrams, "int64")+",\n")
	}
	if this.RcvbufErrors != nil {
		s = append(s, "RcvbufErrors: "+valueToGoStringMesos(this.RcvbufErrors, "int64")+",\n")
	}
	if this.SndbufErrors != nil {
		s = append(s, "SndbufErrors: "+valueToGoStringMesos(this.SndbufErrors, "int64")+",\n")
	}
	if this.InCsumErrors != nil {
		s = append(s, "InCsumErrors: "+valueToGoStringMesos(this.InCsumErrors, "int64")+",\n")
	}
	if this.IgnoredMulti != nil {
		s = append(s, "IgnoredMulti: "+valueToGoStringMesos(this.IgnoredMulti, "int64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SNMPStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.SNMPStatistics{")
	if this.IPStats != nil {
		s = append(s, "IPStats: "+fmt.Sprintf("%#v", this.IPStats)+",\n")
	}
	if this.ICMPStats != nil {
		s = append(s, "ICMPStats: "+fmt.Sprintf("%#v", this.ICMPStats)+",\n")
	}
	if this.TCPStats != nil {
		s = append(s, "TCPStats: "+fmt.Sprintf("%#v", this.TCPStats)+",\n")
	}
	if this.UDPStats != nil {
		s = append(s, "UDPStats: "+fmt.Sprintf("%#v", this.UDPStats)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DiskStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.DiskStatistics{")
	if this.Source != nil {
		s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	}
	if this.Persistence != nil {
		s = append(s, "Persistence: "+fmt.Sprintf("%#v", this.Persistence)+",\n")
	}
	if this.LimitBytes != nil {
		s = append(s, "LimitBytes: "+valueToGoStringMesos(this.LimitBytes, "uint64")+",\n")
	}
	if this.UsedBytes != nil {
		s = append(s, "UsedBytes: "+valueToGoStringMesos(this.UsedBytes, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 48)
	s = append(s, "&mesos.ResourceStatistics{")
	s = append(s, "Timestamp: "+fmt.Sprintf("%#v", this.Timestamp)+",\n")
	if this.Processes != nil {
		s = append(s, "Processes: "+valueToGoStringMesos(this.Processes, "uint32")+",\n")
	}
	if this.Threads != nil {
		s = append(s, "Threads: "+valueToGoStringMesos(this.Threads, "uint32")+",\n")
	}
	if this.CPUsUserTimeSecs != nil {
		s = append(s, "CPUsUserTimeSecs: "+valueToGoStringMesos(this.CPUsUserTimeSecs, "float64")+",\n")
	}
	if this.CPUsSystemTimeSecs != nil {
		s = append(s, "CPUsSystemTimeSecs: "+valueToGoStringMesos(this.CPUsSystemTimeSecs, "float64")+",\n")
	}
	if this.CPUsLimit != nil {
		s = append(s, "CPUsLimit: "+valueToGoStringMesos(this.CPUsLimit, "float64")+",\n")
	}
	if this.CPUsNrPeriods != nil {
		s = append(s, "CPUsNrPeriods: "+valueToGoStringMesos(this.CPUsNrPeriods, "uint32")+",\n")
	}
	if this.CPUsNrThrottled != nil {
		s = append(s, "CPUsNrThrottled: "+valueToGoStringMesos(this.CPUsNrThrottled, "uint32")+",\n")
	}
	if this.CPUsThrottledTimeSecs != nil {
		s = append(s, "CPUsThrottledTimeSecs: "+valueToGoStringMesos(this.CPUsThrottledTimeSecs, "float64")+",\n")
	}
	if this.MemTotalBytes != nil {
		s = append(s, "MemTotalBytes: "+valueToGoStringMesos(this.MemTotalBytes, "uint64")+",\n")
	}
	if this.MemTotalMemswBytes != nil {
		s = append(s, "MemTotalMemswBytes: "+valueToGoStringMesos(this.MemTotalMemswBytes, "uint64")+",\n")
	}
	if this.MemLimitBytes != nil {
		s = append(s, "MemLimitBytes: "+valueToGoStringMesos(this.MemLimitBytes, "uint64")+",\n")
	}
	if this.MemSoftLimitBytes != nil {
		s = append(s, "MemSoftLimitBytes: "+valueToGoStringMesos(this.MemSoftLimitBytes, "uint64")+",\n")
	}
	if this.MemFileBytes != nil {
		s = append(s, "MemFileBytes: "+valueToGoStringMesos(this.MemFileBytes, "uint64")+",\n")
	}
	if this.MemAnonBytes != nil {
		s = append(s, "MemAnonBytes: "+valueToGoStringMesos(this.MemAnonBytes, "uint64")+",\n")
	}
	if this.MemCacheBytes != nil {
		s = append(s, "MemCacheBytes: "+valueToGoStringMesos(this.MemCacheBytes, "uint64")+",\n")
	}
	if this.MemRSSBytes != nil {
		s = append(s, "MemRSSBytes: "+valueToGoStringMesos(this.MemRSSBytes, "uint64")+",\n")
	}
	if this.MemMappedFileBytes != nil {
		s = append(s, "MemMappedFileBytes: "+valueToGoStringMesos(this.MemMappedFileBytes, "uint64")+",\n")
	}
	if this.MemSwapBytes != nil {
		s = append(s, "MemSwapBytes: "+valueToGoStringMesos(this.MemSwapBytes, "uint64")+",\n")
	}
	if this.MemUnevictableBytes != nil {
		s = append(s, "MemUnevictableBytes: "+valueToGoStringMesos(this.MemUnevictableBytes, "uint64")+",\n")
	}
	if this.MemLowPressureCounter != nil {
		s = append(s, "MemLowPressureCounter: "+valueToGoStringMesos(this.MemLowPressureCounter, "uint64")+",\n")
	}
	if this.MemMediumPressureCounter != nil {
		s = append(s, "MemMediumPressureCounter: "+valueToGoStringMesos(this.MemMediumPressureCounter, "uint64")+",\n")
	}
	if this.MemCriticalPressureCounter != nil {
		s = append(s, "MemCriticalPressureCounter: "+valueToGoStringMesos(this.MemCriticalPressureCounter, "uint64")+",\n")
	}
	if this.DiskLimitBytes != nil {
		s = append(s, "DiskLimitBytes: "+valueToGoStringMesos(this.DiskLimitBytes, "uint64")+",\n")
	}
	if this.DiskUsedBytes != nil {
		s = append(s, "DiskUsedBytes: "+valueToGoStringMesos(this.DiskUsedBytes, "uint64")+",\n")
	}
	if this.DiskStatistics != nil {
		s = append(s, "DiskStatistics: "+fmt.Sprintf("%#v", this.DiskStatistics)+",\n")
	}
	if this.BlkioStatistics != nil {
		s = append(s, "BlkioStatistics: "+fmt.Sprintf("%#v", this.BlkioStatistics)+",\n")
	}
	if this.Perf != nil {
		s = append(s, "Perf: "+fmt.Sprintf("%#v", this.Perf)+",\n")
	}
	if this.NetRxPackets != nil {
		s = append(s, "NetRxPackets: "+valueToGoStringMesos(this.NetRxPackets, "uint64")+",\n")
	}
	if this.NetRxBytes != nil {
		s = append(s, "NetRxBytes: "+valueToGoStringMesos(this.NetRxBytes, "uint64")+",\n")
	}
	if this.NetRxErrors != nil {
		s = append(s, "NetRxErrors: "+valueToGoStringMesos(this.NetRxErrors, "uint64")+",\n")
	}
	if this.NetRxDropped != nil {
		s = append(s, "NetRxDropped: "+valueToGoStringMesos(this.NetRxDropped, "uint64")+",\n")
	}
	if this.NetTxPackets != nil {
		s = append(s, "NetTxPackets: "+valueToGoStringMesos(this.NetTxPackets, "uint64")+",\n")
	}
	if this.NetTxBytes != nil {
		s = append(s, "NetTxBytes: "+valueToGoStringMesos(this.NetTxBytes, "uint64")+",\n")
	}
	if this.NetTxErrors != nil {
		s = append(s, "NetTxErrors: "+valueToGoStringMesos(this.NetTxErrors, "uint64")+",\n")
	}
	if this.NetTxDropped != nil {
		s = append(s, "NetTxDropped: "+valueToGoStringMesos(this.NetTxDropped, "uint64")+",\n")
	}
	if this.NetTCPRttMicrosecsP50 != nil {
		s = append(s, "NetTCPRttMicrosecsP50: "+valueToGoStringMesos(this.NetTCPRttMicrosecsP50, "float64")+",\n")
	}
	if this.NetTCPRttMicrosecsP90 != nil {
		s = append(s, "NetTCPRttMicrosecsP90: "+valueToGoStringMesos(this.NetTCPRttMicrosecsP90, "float64")+",\n")
	}
	if this.NetTCPRttMicrosecsP95 != nil {
		s = append(s, "NetTCPRttMicrosecsP95: "+valueToGoStringMesos(this.NetTCPRttMicrosecsP95, "float64")+",\n")
	}
	if this.NetTCPRttMicrosecsP99 != nil {
		s = append(s, "NetTCPRttMicrosecsP99: "+valueToGoStringMesos(this.NetTCPRttMicrosecsP99, "float64")+",\n")
	}
	if this.NetTCPActiveConnections != nil {
		s = append(s, "NetTCPActiveConnections: "+valueToGoStringMesos(this.NetTCPActiveConnections, "float64")+",\n")
	}
	if this.NetTCPTimeWaitConnections != nil {
		s = append(s, "NetTCPTimeWaitConnections: "+valueToGoStringMesos(this.NetTCPTimeWaitConnections, "float64")+",\n")
	}
	if this.NetTrafficControlStatistics != nil {
		s = append(s, "NetTrafficControlStatistics: "+fmt.Sprintf("%#v", this.NetTrafficControlStatistics)+",\n")
	}
	if this.NetSNMPStatistics != nil {
		s = append(s, "NetSNMPStatistics: "+fmt.Sprintf("%#v", this.NetSNMPStatistics)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceUsage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.ResourceUsage{")
	if this.Executors != nil {
		s = append(s, "Executors: "+fmt.Sprintf("%#v", this.Executors)+",\n")
	}
	if this.Total != nil {
		s = append(s, "Total: "+fmt.Sprintf("%#v", this.Total)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceUsage_Executor) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.ResourceUsage_Executor{")
	s = append(s, "ExecutorInfo: "+strings.Replace(this.ExecutorInfo.GoString(), `&`, ``, 1)+",\n")
	if this.Allocated != nil {
		s = append(s, "Allocated: "+fmt.Sprintf("%#v", this.Allocated)+",\n")
	}
	if this.Statistics != nil {
		s = append(s, "Statistics: "+fmt.Sprintf("%#v", this.Statistics)+",\n")
	}
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceUsage_Executor_Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.ResourceUsage_Executor_Task{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "ID: "+strings.Replace(this.ID.GoString(), `&`, ``, 1)+",\n")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PerfStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 57)
	s = append(s, "&mesos.PerfStatistics{")
	s = append(s, "Timestamp: "+fmt.Sprintf("%#v", this.Timestamp)+",\n")
	s = append(s, "Duration: "+fmt.Sprintf("%#v", this.Duration)+",\n")
	if this.Cycles != nil {
		s = append(s, "Cycles: "+valueToGoStringMesos(this.Cycles, "uint64")+",\n")
	}
	if this.StalledCyclesFrontend != nil {
		s = append(s, "StalledCyclesFrontend: "+valueToGoStringMesos(this.StalledCyclesFrontend, "uint64")+",\n")
	}
	if this.StalledCyclesBackend != nil {
		s = append(s, "StalledCyclesBackend: "+valueToGoStringMesos(this.StalledCyclesBackend, "uint64")+",\n")
	}
	if this.Instructions != nil {
		s = append(s, "Instructions: "+valueToGoStringMesos(this.Instructions, "uint64")+",\n")
	}
	if this.CacheReferences != nil {
		s = append(s, "CacheReferences: "+valueToGoStringMesos(this.CacheReferences, "uint64")+",\n")
	}
	if this.CacheMisses != nil {
		s = append(s, "CacheMisses: "+valueToGoStringMesos(this.CacheMisses, "uint64")+",\n")
	}
	if this.Branches != nil {
		s = append(s, "Branches: "+valueToGoStringMesos(this.Branches, "uint64")+",\n")
	}
	if this.BranchMisses != nil {
		s = append(s, "BranchMisses: "+valueToGoStringMesos(this.BranchMisses, "uint64")+",\n")
	}
	if this.BusCycles != nil {
		s = append(s, "BusCycles: "+valueToGoStringMesos(this.BusCycles, "uint64")+",\n")
	}
	if this.RefCycles != nil {
		s = append(s, "RefCycles: "+valueToGoStringMesos(this.RefCycles, "uint64")+",\n")
	}
	if this.CPUClock != nil {
		s = append(s, "CPUClock: "+valueToGoStringMesos(this.CPUClock, "float64")+",\n")
	}
	if this.TaskClock != nil {
		s = append(s, "TaskClock: "+valueToGoStringMesos(this.TaskClock, "float64")+",\n")
	}
	if this.PageFaults != nil {
		s = append(s, "PageFaults: "+valueToGoStringMesos(this.PageFaults, "uint64")+",\n")
	}
	if this.MinorFaults != nil {
		s = append(s, "MinorFaults: "+valueToGoStringMesos(this.MinorFaults, "uint64")+",\n")
	}
	if this.MajorFaults != nil {
		s = append(s, "MajorFaults: "+valueToGoStringMesos(this.MajorFaults, "uint64")+",\n")
	}
	if this.ContextSwitches != nil {
		s = append(s, "ContextSwitches: "+valueToGoStringMesos(this.ContextSwitches, "uint64")+",\n")
	}
	if this.CPUMigrations != nil {
		s = append(s, "CPUMigrations: "+valueToGoStringMesos(this.CPUMigrations, "uint64")+",\n")
	}
	if this.AlignmentFaults != nil {
		s = append(s, "AlignmentFaults: "+valueToGoStringMesos(this.AlignmentFaults, "uint64")+",\n")
	}
	if this.EmulationFaults != nil {
		s = append(s, "EmulationFaults: "+valueToGoStringMesos(this.EmulationFaults, "uint64")+",\n")
	}
	if this.L1DcacheLoads != nil {
		s = append(s, "L1DcacheLoads: "+valueToGoStringMesos(this.L1DcacheLoads, "uint64")+",\n")
	}
	if this.L1DcacheLoadMisses != nil {
		s = append(s, "L1DcacheLoadMisses: "+valueToGoStringMesos(this.L1DcacheLoadMisses, "uint64")+",\n")
	}
	if this.L1DcacheStores != nil {
		s = append(s, "L1DcacheStores: "+valueToGoStringMesos(this.L1DcacheStores, "uint64")+",\n")
	}
	if this.L1DcacheStoreMisses != nil {
		s = append(s, "L1DcacheStoreMisses: "+valueToGoStringMesos(this.L1DcacheStoreMisses, "uint64")+",\n")
	}
	if this.L1DcachePrefetches != nil {
		s = append(s, "L1DcachePrefetches: "+valueToGoStringMesos(this.L1DcachePrefetches, "uint64")+",\n")
	}
	if this.L1DcachePrefetchMisses != nil {
		s = append(s, "L1DcachePrefetchMisses: "+valueToGoStringMesos(this.L1DcachePrefetchMisses, "uint64")+",\n")
	}
	if this.L1IcacheLoads != nil {
		s = append(s, "L1IcacheLoads: "+valueToGoStringMesos(this.L1IcacheLoads, "uint64")+",\n")
	}
	if this.L1IcacheLoadMisses != nil {
		s = append(s, "L1IcacheLoadMisses: "+valueToGoStringMesos(this.L1IcacheLoadMisses, "uint64")+",\n")
	}
	if this.L1IcachePrefetches != nil {
		s = append(s, "L1IcachePrefetches: "+valueToGoStringMesos(this.L1IcachePrefetches, "uint64")+",\n")
	}
	if this.L1IcachePrefetchMisses != nil {
		s = append(s, "L1IcachePrefetchMisses: "+valueToGoStringMesos(this.L1IcachePrefetchMisses, "uint64")+",\n")
	}
	if this.LLCLoads != nil {
		s = append(s, "LLCLoads: "+valueToGoStringMesos(this.LLCLoads, "uint64")+",\n")
	}
	if this.LLCLoadMisses != nil {
		s = append(s, "LLCLoadMisses: "+valueToGoStringMesos(this.LLCLoadMisses, "uint64")+",\n")
	}
	if this.LLCStores != nil {
		s = append(s, "LLCStores: "+valueToGoStringMesos(this.LLCStores, "uint64")+",\n")
	}
	if this.LLCStoreMisses != nil {
		s = append(s, "LLCStoreMisses: "+valueToGoStringMesos(this.LLCStoreMisses, "uint64")+",\n")
	}
	if this.LLCPrefetches != nil {
		s = append(s, "LLCPrefetches: "+valueToGoStringMesos(this.LLCPrefetches, "uint64")+",\n")
	}
	if this.LLCPrefetchMisses != nil {
		s = append(s, "LLCPrefetchMisses: "+valueToGoStringMesos(this.LLCPrefetchMisses, "uint64")+",\n")
	}
	if this.DTLBLoads != nil {
		s = append(s, "DTLBLoads: "+valueToGoStringMesos(this.DTLBLoads, "uint64")+",\n")
	}
	if this.DTLBLoadMisses != nil {
		s = append(s, "DTLBLoadMisses: "+valueToGoStringMesos(this.DTLBLoadMisses, "uint64")+",\n")
	}
	if this.DTLBStores != nil {
		s = append(s, "DTLBStores: "+valueToGoStringMesos(this.DTLBStores, "uint64")+",\n")
	}
	if this.DTLBStoreMisses != nil {
		s = append(s, "DTLBStoreMisses: "+valueToGoStringMesos(this.DTLBStoreMisses, "uint64")+",\n")
	}
	if this.DTLBPrefetches != nil {
		s = append(s, "DTLBPrefetches: "+valueToGoStringMesos(this.DTLBPrefetches, "uint64")+",\n")
	}
	if this.DTLBPrefetchMisses != nil {
		s = append(s, "DTLBPrefetchMisses: "+valueToGoStringMesos(this.DTLBPrefetchMisses, "uint64")+",\n")
	}
	if this.ITLBLoads != nil {
		s = append(s, "ITLBLoads: "+valueToGoStringMesos(this.ITLBLoads, "uint64")+",\n")
	}
	if this.ITLBLoadMisses != nil {
		s = append(s, "ITLBLoadMisses: "+valueToGoStringMesos(this.ITLBLoadMisses, "uint64")+",\n")
	}
	if this.BranchLoads != nil {
		s = append(s, "BranchLoads: "+valueToGoStringMesos(this.BranchLoads, "uint64")+",\n")
	}
	if this.BranchLoadMisses != nil {
		s = append(s, "BranchLoadMisses: "+valueToGoStringMesos(this.BranchLoadMisses, "uint64")+",\n")
	}
	if this.NodeLoads != nil {
		s = append(s, "NodeLoads: "+valueToGoStringMesos(this.NodeLoads, "uint64")+",\n")
	}
	if this.NodeLoadMisses != nil {
		s = append(s, "NodeLoadMisses: "+valueToGoStringMesos(this.NodeLoadMisses, "uint64")+",\n")
	}
	if this.NodeStores != nil {
		s = append(s, "NodeStores: "+valueToGoStringMesos(this.NodeStores, "uint64")+",\n")
	}
	if this.NodeStoreMisses != nil {
		s = append(s, "NodeStoreMisses: "+valueToGoStringMesos(this.NodeStoreMisses, "uint64")+",\n")
	}
	if this.NodePrefetches != nil {
		s = append(s, "NodePrefetches: "+valueToGoStringMesos(this.NodePrefetches, "uint64")+",\n")
	}
	if this.NodePrefetchMisses != nil {
		s = append(s, "NodePrefetchMisses: "+valueToGoStringMesos(this.NodePrefetchMisses, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Request{")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&mesos.Offer{")
	s = append(s, "ID: "+strings.Replace(this.ID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "FrameworkID: "+strings.Replace(this.FrameworkID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Hostname: "+fmt.Sprintf("%#v", this.Hostname)+",\n")
	if this.URL != nil {
		s = append(s, "URL: "+fmt.Sprintf("%#v", this.URL)+",\n")
	}
	if this.Domain != nil {
		s = append(s, "Domain: "+fmt.Sprintf("%#v", this.Domain)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	if this.ExecutorIDs != nil {
		s = append(s, "ExecutorIDs: "+fmt.Sprintf("%#v", this.ExecutorIDs)+",\n")
	}
	if this.Unavailability != nil {
		s = append(s, "Unavailability: "+fmt.Sprintf("%#v", this.Unavailability)+",\n")
	}
	if this.AllocationInfo != nil {
		s = append(s, "AllocationInfo: "+fmt.Sprintf("%#v", this.AllocationInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&mesos.Offer_Operation{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ID != nil {
		s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	}
	if this.Launch != nil {
		s = append(s, "Launch: "+fmt.Sprintf("%#v", this.Launch)+",\n")
	}
	if this.LaunchGroup != nil {
		s = append(s, "LaunchGroup: "+fmt.Sprintf("%#v", this.LaunchGroup)+",\n")
	}
	if this.Reserve != nil {
		s = append(s, "Reserve: "+fmt.Sprintf("%#v", this.Reserve)+",\n")
	}
	if this.Unreserve != nil {
		s = append(s, "Unreserve: "+fmt.Sprintf("%#v", this.Unreserve)+",\n")
	}
	if this.Create != nil {
		s = append(s, "Create: "+fmt.Sprintf("%#v", this.Create)+",\n")
	}
	if this.Destroy != nil {
		s = append(s, "Destroy: "+fmt.Sprintf("%#v", this.Destroy)+",\n")
	}
	if this.CreateVolume != nil {
		s = append(s, "CreateVolume: "+fmt.Sprintf("%#v", this.CreateVolume)+",\n")
	}
	if this.DestroyVolume != nil {
		s = append(s, "DestroyVolume: "+fmt.Sprintf("%#v", this.DestroyVolume)+",\n")
	}
	if this.CreateBlock != nil {
		s = append(s, "CreateBlock: "+fmt.Sprintf("%#v", this.CreateBlock)+",\n")
	}
	if this.DestroyBlock != nil {
		s = append(s, "DestroyBlock: "+fmt.Sprintf("%#v", this.DestroyBlock)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Launch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_Launch{")
	if this.TaskInfos != nil {
		s = append(s, "TaskInfos: "+fmt.Sprintf("%#v", this.TaskInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_LaunchGroup) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Offer_Operation_LaunchGroup{")
	s = append(s, "Executor: "+strings.Replace(this.Executor.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "TaskGroup: "+strings.Replace(this.TaskGroup.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Reserve) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_Reserve{")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Unreserve) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_Unreserve{")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Create) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_Create{")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Destroy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_Destroy{")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_CreateVolume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Offer_Operation_CreateVolume{")
	s = append(s, "Source: "+strings.Replace(this.Source.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "TargetType: "+fmt.Sprintf("%#v", this.TargetType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_DestroyVolume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_DestroyVolume{")
	s = append(s, "Volume: "+strings.Replace(this.Volume.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_CreateBlock) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_CreateBlock{")
	s = append(s, "Source: "+strings.Replace(this.Source.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_DestroyBlock) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Offer_Operation_DestroyBlock{")
	s = append(s, "Block: "+strings.Replace(this.Block.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *InverseOffer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesos.InverseOffer{")
	s = append(s, "OfferID: "+strings.Replace(this.OfferID.GoString(), `&`, ``, 1)+",\n")
	if this.URL != nil {
		s = append(s, "URL: "+fmt.Sprintf("%#v", this.URL)+",\n")
	}
	s = append(s, "FrameworkID: "+strings.Replace(this.FrameworkID.GoString(), `&`, ``, 1)+",\n")
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	s = append(s, "Unavailability: "+strings.Replace(this.Unavailability.GoString(), `&`, ``, 1)+",\n")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&mesos.TaskInfo{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Executor != nil {
		s = append(s, "Executor: "+fmt.Sprintf("%#v", this.Executor)+",\n")
	}
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	if this.HealthCheck != nil {
		s = append(s, "HealthCheck: "+fmt.Sprintf("%#v", this.HealthCheck)+",\n")
	}
	if this.Check != nil {
		s = append(s, "Check: "+fmt.Sprintf("%#v", this.Check)+",\n")
	}
	if this.KillPolicy != nil {
		s = append(s, "KillPolicy: "+fmt.Sprintf("%#v", this.KillPolicy)+",\n")
	}
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMesos(this.Data, "byte")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.Discovery != nil {
		s = append(s, "Discovery: "+fmt.Sprintf("%#v", this.Discovery)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskGroupInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.TaskGroupInfo{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 18)
	s = append(s, "&mesos.Task{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "FrameworkID: "+strings.Replace(this.FrameworkID.GoString(), `&`, ``, 1)+",\n")
	if this.ExecutorID != nil {
		s = append(s, "ExecutorID: "+fmt.Sprintf("%#v", this.ExecutorID)+",\n")
	}
	s = append(s, "AgentID: "+strings.Replace(this.AgentID.GoString(), `&`, ``, 1)+",\n")
	if this.State != nil {
		s = append(s, "State: "+valueToGoStringMesos(this.State, "TaskState")+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Statuses != nil {
		s = append(s, "Statuses: "+fmt.Sprintf("%#v", this.Statuses)+",\n")
	}
	if this.StatusUpdateState != nil {
		s = append(s, "StatusUpdateState: "+valueToGoStringMesos(this.StatusUpdateState, "TaskState")+",\n")
	}
	if this.StatusUpdateUUID != nil {
		s = append(s, "StatusUpdateUUID: "+valueToGoStringMesos(this.StatusUpdateUUID, "byte")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.Discovery != nil {
		s = append(s, "Discovery: "+fmt.Sprintf("%#v", this.Discovery)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	if this.User != nil {
		s = append(s, "User: "+valueToGoStringMesos(this.User, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskResourceLimitation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.TaskResourceLimitation{")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UUID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.UUID{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Operation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesos.Operation{")
	if this.FrameworkID != nil {
		s = append(s, "FrameworkID: "+fmt.Sprintf("%#v", this.FrameworkID)+",\n")
	}
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	s = append(s, "Info: "+strings.Replace(this.Info.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "LatestStatus: "+strings.Replace(this.LatestStatus.GoString(), `&`, ``, 1)+",\n")
	if this.Statuses != nil {
		s = append(s, "Statuses: "+fmt.Sprintf("%#v", this.Statuses)+",\n")
	}
	s = append(s, "UUID: "+strings.Replace(this.UUID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OperationStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.OperationStatus{")
	if this.OperationID != nil {
		s = append(s, "OperationID: "+fmt.Sprintf("%#v", this.OperationID)+",\n")
	}
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	if this.Message != nil {
		s = append(s, "Message: "+valueToGoStringMesos(this.Message, "string")+",\n")
	}
	if this.ConvertedResources != nil {
		s = append(s, "ConvertedResources: "+fmt.Sprintf("%#v", this.ConvertedResources)+",\n")
	}
	if this.UUID != nil {
		s = append(s, "UUID: "+fmt.Sprintf("%#v", this.UUID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckStatusInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.CheckStatusInfo{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "CheckInfo_Type")+",\n")
	}
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.HTTP != nil {
		s = append(s, "HTTP: "+fmt.Sprintf("%#v", this.HTTP)+",\n")
	}
	if this.TCP != nil {
		s = append(s, "TCP: "+fmt.Sprintf("%#v", this.TCP)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckStatusInfo_Command) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CheckStatusInfo_Command{")
	if this.ExitCode != nil {
		s = append(s, "ExitCode: "+valueToGoStringMesos(this.ExitCode, "int32")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckStatusInfo_Http) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CheckStatusInfo_Http{")
	if this.StatusCode != nil {
		s = append(s, "StatusCode: "+valueToGoStringMesos(this.StatusCode, "uint32")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CheckStatusInfo_Tcp) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CheckStatusInfo_Tcp{")
	if this.Succeeded != nil {
		s = append(s, "Succeeded: "+valueToGoStringMesos(this.Succeeded, "bool")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 20)
	s = append(s, "&mesos.TaskStatus{")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	if this.State != nil {
		s = append(s, "State: "+valueToGoStringMesos(this.State, "TaskState")+",\n")
	}
	if this.Message != nil {
		s = append(s, "Message: "+valueToGoStringMesos(this.Message, "string")+",\n")
	}
	if this.Source != nil {
		s = append(s, "Source: "+valueToGoStringMesos(this.Source, "TaskStatus_Source")+",\n")
	}
	if this.Reason != nil {
		s = append(s, "Reason: "+valueToGoStringMesos(this.Reason, "TaskStatus_Reason")+",\n")
	}
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMesos(this.Data, "byte")+",\n")
	}
	if this.AgentID != nil {
		s = append(s, "AgentID: "+fmt.Sprintf("%#v", this.AgentID)+",\n")
	}
	if this.ExecutorID != nil {
		s = append(s, "ExecutorID: "+fmt.Sprintf("%#v", this.ExecutorID)+",\n")
	}
	if this.Timestamp != nil {
		s = append(s, "Timestamp: "+valueToGoStringMesos(this.Timestamp, "float64")+",\n")
	}
	if this.UUID != nil {
		s = append(s, "UUID: "+valueToGoStringMesos(this.UUID, "byte")+",\n")
	}
	if this.Healthy != nil {
		s = append(s, "Healthy: "+valueToGoStringMesos(this.Healthy, "bool")+",\n")
	}
	if this.CheckStatus != nil {
		s = append(s, "CheckStatus: "+fmt.Sprintf("%#v", this.CheckStatus)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.ContainerStatus != nil {
		s = append(s, "ContainerStatus: "+fmt.Sprintf("%#v", this.ContainerStatus)+",\n")
	}
	if this.UnreachableTime != nil {
		s = append(s, "UnreachableTime: "+fmt.Sprintf("%#v", this.UnreachableTime)+",\n")
	}
	if this.Limitation != nil {
		s = append(s, "Limitation: "+fmt.Sprintf("%#v", this.Limitation)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Filters) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Filters{")
	if this.RefuseSeconds != nil {
		s = append(s, "RefuseSeconds: "+valueToGoStringMesos(this.RefuseSeconds, "float64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Environment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Environment{")
	if this.Variables != nil {
		s = append(s, "Variables: "+fmt.Sprintf("%#v", this.Variables)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Environment_Variable) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.Environment_Variable{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "Environment_Variable_Type")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.Secret != nil {
		s = append(s, "Secret: "+fmt.Sprintf("%#v", this.Secret)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Parameter) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Parameter{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Parameters) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Parameters{")
	if this.Parameter != nil {
		s = append(s, "Parameter: "+fmt.Sprintf("%#v", this.Parameter)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Credential) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Credential{")
	s = append(s, "Principal: "+fmt.Sprintf("%#v", this.Principal)+",\n")
	if this.Secret != nil {
		s = append(s, "Secret: "+valueToGoStringMesos(this.Secret, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Credentials) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Credentials{")
	if this.Credentials != nil {
		s = append(s, "Credentials: "+fmt.Sprintf("%#v", this.Credentials)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Secret) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.Secret{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Reference != nil {
		s = append(s, "Reference: "+fmt.Sprintf("%#v", this.Reference)+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Secret_Reference) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Secret_Reference{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Key != nil {
		s = append(s, "Key: "+valueToGoStringMesos(this.Key, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Secret_Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Secret_Value{")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMesos(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RateLimit) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.RateLimit{")
	if this.QPS != nil {
		s = append(s, "QPS: "+valueToGoStringMesos(this.QPS, "float64")+",\n")
	}
	s = append(s, "Principal: "+fmt.Sprintf("%#v", this.Principal)+",\n")
	if this.Capacity != nil {
		s = append(s, "Capacity: "+valueToGoStringMesos(this.Capacity, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RateLimits) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.RateLimits{")
	if this.Limits != nil {
		s = append(s, "Limits: "+fmt.Sprintf("%#v", this.Limits)+",\n")
	}
	if this.AggregateDefaultQPS != nil {
		s = append(s, "AggregateDefaultQPS: "+valueToGoStringMesos(this.AggregateDefaultQPS, "float64")+",\n")
	}
	if this.AggregateDefaultCapacity != nil {
		s = append(s, "AggregateDefaultCapacity: "+valueToGoStringMesos(this.AggregateDefaultCapacity, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.Image{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "Image_Type")+",\n")
	}
	if this.Appc != nil {
		s = append(s, "Appc: "+fmt.Sprintf("%#v", this.Appc)+",\n")
	}
	if this.Docker != nil {
		s = append(s, "Docker: "+fmt.Sprintf("%#v", this.Docker)+",\n")
	}
	if this.Cached != nil {
		s = append(s, "Cached: "+valueToGoStringMesos(this.Cached, "bool")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image_Appc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.Image_Appc{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.ID != nil {
		s = append(s, "ID: "+valueToGoStringMesos(this.ID, "string")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image_Docker) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.Image_Docker{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Credential != nil {
		s = append(s, "Credential: "+fmt.Sprintf("%#v", this.Credential)+",\n")
	}
	if this.Config != nil {
		s = append(s, "Config: "+fmt.Sprintf("%#v", this.Config)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MountPropagation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.MountPropagation{")
	if this.Mode != nil {
		s = append(s, "Mode: "+valueToGoStringMesos(this.Mode, "MountPropagation_Mode")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.Volume{")
	if this.Mode != nil {
		s = append(s, "Mode: "+valueToGoStringMesos(this.Mode, "Volume_Mode")+",\n")
	}
	s = append(s, "ContainerPath: "+fmt.Sprintf("%#v", this.ContainerPath)+",\n")
	if this.HostPath != nil {
		s = append(s, "HostPath: "+valueToGoStringMesos(this.HostPath, "string")+",\n")
	}
	if this.Image != nil {
		s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	}
	if this.Source != nil {
		s = append(s, "Source: "+fmt.Sprintf("%#v", this.Source)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume_Source) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.Volume_Source{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.DockerVolume != nil {
		s = append(s, "DockerVolume: "+fmt.Sprintf("%#v", this.DockerVolume)+",\n")
	}
	if this.HostPath != nil {
		s = append(s, "HostPath: "+fmt.Sprintf("%#v", this.HostPath)+",\n")
	}
	if this.SandboxPath != nil {
		s = append(s, "SandboxPath: "+fmt.Sprintf("%#v", this.SandboxPath)+",\n")
	}
	if this.Secret != nil {
		s = append(s, "Secret: "+fmt.Sprintf("%#v", this.Secret)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume_Source_DockerVolume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.Volume_Source_DockerVolume{")
	if this.Driver != nil {
		s = append(s, "Driver: "+valueToGoStringMesos(this.Driver, "string")+",\n")
	}
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.DriverOptions != nil {
		s = append(s, "DriverOptions: "+fmt.Sprintf("%#v", this.DriverOptions)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume_Source_HostPath) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Volume_Source_HostPath{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	if this.MountPropagation != nil {
		s = append(s, "MountPropagation: "+fmt.Sprintf("%#v", this.MountPropagation)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume_Source_SandboxPath) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Volume_Source_SandboxPath{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.NetworkInfo{")
	if this.IPAddresses != nil {
		s = append(s, "IPAddresses: "+fmt.Sprintf("%#v", this.IPAddresses)+",\n")
	}
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Groups != nil {
		s = append(s, "Groups: "+fmt.Sprintf("%#v", this.Groups)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.PortMappings != nil {
		s = append(s, "PortMappings: "+fmt.Sprintf("%#v", this.PortMappings)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkInfo_IPAddress) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.NetworkInfo_IPAddress{")
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "NetworkInfo_Protocol")+",\n")
	}
	if this.IPAddress != nil {
		s = append(s, "IPAddress: "+valueToGoStringMesos(this.IPAddress, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkInfo_PortMapping) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.NetworkInfo_PortMapping{")
	s = append(s, "HostPort: "+fmt.Sprintf("%#v", this.HostPort)+",\n")
	s = append(s, "ContainerPort: "+fmt.Sprintf("%#v", this.ContainerPort)+",\n")
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CapabilityInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CapabilityInfo{")
	if this.Capabilities != nil {
		s = append(s, "Capabilities: "+fmt.Sprintf("%#v", this.Capabilities)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LinuxInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.LinuxInfo{")
	if this.CapabilityInfo != nil {
		s = append(s, "CapabilityInfo: "+fmt.Sprintf("%#v", this.CapabilityInfo)+",\n")
	}
	if this.BoundingCapabilities != nil {
		s = append(s, "BoundingCapabilities: "+fmt.Sprintf("%#v", this.BoundingCapabilities)+",\n")
	}
	if this.EffectiveCapabilities != nil {
		s = append(s, "EffectiveCapabilities: "+fmt.Sprintf("%#v", this.EffectiveCapabilities)+",\n")
	}
	if this.SharePIDNamespace != nil {
		s = append(s, "SharePIDNamespace: "+valueToGoStringMesos(this.SharePIDNamespace, "bool")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RLimitInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.RLimitInfo{")
	if this.Rlimits != nil {
		s = append(s, "Rlimits: "+fmt.Sprintf("%#v", this.Rlimits)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RLimitInfo_RLimit) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.RLimitInfo_RLimit{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Hard != nil {
		s = append(s, "Hard: "+valueToGoStringMesos(this.Hard, "uint64")+",\n")
	}
	if this.Soft != nil {
		s = append(s, "Soft: "+valueToGoStringMesos(this.Soft, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TTYInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.TTYInfo{")
	if this.WindowSize != nil {
		s = append(s, "WindowSize: "+fmt.Sprintf("%#v", this.WindowSize)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TTYInfo_WindowSize) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.TTYInfo_WindowSize{")
	s = append(s, "Rows: "+fmt.Sprintf("%#v", this.Rows)+",\n")
	s = append(s, "Columns: "+fmt.Sprintf("%#v", this.Columns)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&mesos.ContainerInfo{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "ContainerInfo_Type")+",\n")
	}
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Docker != nil {
		s = append(s, "Docker: "+fmt.Sprintf("%#v", this.Docker)+",\n")
	}
	if this.Mesos != nil {
		s = append(s, "Mesos: "+fmt.Sprintf("%#v", this.Mesos)+",\n")
	}
	if this.NetworkInfos != nil {
		s = append(s, "NetworkInfos: "+fmt.Sprintf("%#v", this.NetworkInfos)+",\n")
	}
	if this.LinuxInfo != nil {
		s = append(s, "LinuxInfo: "+fmt.Sprintf("%#v", this.LinuxInfo)+",\n")
	}
	if this.RlimitInfo != nil {
		s = append(s, "RlimitInfo: "+fmt.Sprintf("%#v", this.RlimitInfo)+",\n")
	}
	if this.TTYInfo != nil {
		s = append(s, "TTYInfo: "+fmt.Sprintf("%#v", this.TTYInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo_DockerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesos.ContainerInfo_DockerInfo{")
	s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	if this.Network != nil {
		s = append(s, "Network: "+valueToGoStringMesos(this.Network, "ContainerInfo_DockerInfo_Network")+",\n")
	}
	if this.PortMappings != nil {
		s = append(s, "PortMappings: "+fmt.Sprintf("%#v", this.PortMappings)+",\n")
	}
	if this.Privileged != nil {
		s = append(s, "Privileged: "+valueToGoStringMesos(this.Privileged, "bool")+",\n")
	}
	if this.Parameters != nil {
		s = append(s, "Parameters: "+fmt.Sprintf("%#v", this.Parameters)+",\n")
	}
	if this.ForcePullImage != nil {
		s = append(s, "ForcePullImage: "+valueToGoStringMesos(this.ForcePullImage, "bool")+",\n")
	}
	if this.VolumeDriver != nil {
		s = append(s, "VolumeDriver: "+valueToGoStringMesos(this.VolumeDriver, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo_DockerInfo_PortMapping) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.ContainerInfo_DockerInfo_PortMapping{")
	s = append(s, "HostPort: "+fmt.Sprintf("%#v", this.HostPort)+",\n")
	s = append(s, "ContainerPort: "+fmt.Sprintf("%#v", this.ContainerPort)+",\n")
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo_MesosInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.ContainerInfo_MesosInfo{")
	if this.Image != nil {
		s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.ContainerStatus{")
	if this.ContainerID != nil {
		s = append(s, "ContainerID: "+fmt.Sprintf("%#v", this.ContainerID)+",\n")
	}
	if this.NetworkInfos != nil {
		s = append(s, "NetworkInfos: "+fmt.Sprintf("%#v", this.NetworkInfos)+",\n")
	}
	if this.CgroupInfo != nil {
		s = append(s, "CgroupInfo: "+fmt.Sprintf("%#v", this.CgroupInfo)+",\n")
	}
	if this.ExecutorPID != nil {
		s = append(s, "ExecutorPID: "+valueToGoStringMesos(this.ExecutorPID, "uint32")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CgroupInfo{")
	if this.NetCLS != nil {
		s = append(s, "NetCLS: "+fmt.Sprintf("%#v", this.NetCLS)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_Blkio) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesos.CgroupInfo_Blkio{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_Blkio_Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.CgroupInfo_Blkio_Value{")
	if this.Op != nil {
		s = append(s, "Op: "+valueToGoStringMesos(this.Op, "CgroupInfo_Blkio_Operation")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_Blkio_CFQ) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesos.CgroupInfo_Blkio_CFQ{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_Blkio_CFQ_Statistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&mesos.CgroupInfo_Blkio_CFQ_Statistics{")
	if this.Device != nil {
		s = append(s, "Device: "+fmt.Sprintf("%#v", this.Device)+",\n")
	}
	if this.Sectors != nil {
		s = append(s, "Sectors: "+valueToGoStringMesos(this.Sectors, "uint64")+",\n")
	}
	if this.Time != nil {
		s = append(s, "Time: "+valueToGoStringMesos(this.Time, "uint64")+",\n")
	}
	if this.IOServiced != nil {
		s = append(s, "IOServiced: "+fmt.Sprintf("%#v", this.IOServiced)+",\n")
	}
	if this.IOServiceBytes != nil {
		s = append(s, "IOServiceBytes: "+fmt.Sprintf("%#v", this.IOServiceBytes)+",\n")
	}
	if this.IOServiceTime != nil {
		s = append(s, "IOServiceTime: "+fmt.Sprintf("%#v", this.IOServiceTime)+",\n")
	}
	if this.IOWaitTime != nil {
		s = append(s, "IOWaitTime: "+fmt.Sprintf("%#v", this.IOWaitTime)+",\n")
	}
	if this.IOMerged != nil {
		s = append(s, "IOMerged: "+fmt.Sprintf("%#v", this.IOMerged)+",\n")
	}
	if this.IOQueued != nil {
		s = append(s, "IOQueued: "+fmt.Sprintf("%#v", this.IOQueued)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_Blkio_Throttling) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesos.CgroupInfo_Blkio_Throttling{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_Blkio_Throttling_Statistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.CgroupInfo_Blkio_Throttling_Statistics{")
	if this.Device != nil {
		s = append(s, "Device: "+fmt.Sprintf("%#v", this.Device)+",\n")
	}
	if this.IOServiced != nil {
		s = append(s, "IOServiced: "+fmt.Sprintf("%#v", this.IOServiced)+",\n")
	}
	if this.IOServiceBytes != nil {
		s = append(s, "IOServiceBytes: "+fmt.Sprintf("%#v", this.IOServiceBytes)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_Blkio_Statistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.CgroupInfo_Blkio_Statistics{")
	if this.CFQ != nil {
		s = append(s, "CFQ: "+fmt.Sprintf("%#v", this.CFQ)+",\n")
	}
	if this.CFQRecursive != nil {
		s = append(s, "CFQRecursive: "+fmt.Sprintf("%#v", this.CFQRecursive)+",\n")
	}
	if this.Throttling != nil {
		s = append(s, "Throttling: "+fmt.Sprintf("%#v", this.Throttling)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CgroupInfo_NetCls) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.CgroupInfo_NetCls{")
	if this.ClassID != nil {
		s = append(s, "ClassID: "+valueToGoStringMesos(this.ClassID, "uint32")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Labels) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Labels{")
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Label) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Label{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Port) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesos.Port{")
	s = append(s, "Number: "+fmt.Sprintf("%#v", this.Number)+",\n")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "string")+",\n")
	}
	if this.Visibility != nil {
		s = append(s, "Visibility: "+valueToGoStringMesos(this.Visibility, "DiscoveryInfo_Visibility")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Ports) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.Ports{")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DiscoveryInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesos.DiscoveryInfo{")
	s = append(s, "Visibility: "+fmt.Sprintf("%#v", this.Visibility)+",\n")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Environment != nil {
		s = append(s, "Environment: "+valueToGoStringMesos(this.Environment, "string")+",\n")
	}
	if this.Location != nil {
		s = append(s, "Location: "+valueToGoStringMesos(this.Location, "string")+",\n")
	}
	if this.Version != nil {
		s = append(s, "Version: "+valueToGoStringMesos(this.Version, "string")+",\n")
	}
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WeightInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.WeightInfo{")
	s = append(s, "Weight: "+fmt.Sprintf("%#v", this.Weight)+",\n")
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringMesos(this.Role, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *VersionInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesos.VersionInfo{")
	s = append(s, "Version: "+fmt.Sprintf("%#v", this.Version)+",\n")
	if this.BuildDate != nil {
		s = append(s, "BuildDate: "+valueToGoStringMesos(this.BuildDate, "string")+",\n")
	}
	if this.BuildTime != nil {
		s = append(s, "BuildTime: "+valueToGoStringMesos(this.BuildTime, "float64")+",\n")
	}
	if this.BuildUser != nil {
		s = append(s, "BuildUser: "+valueToGoStringMesos(this.BuildUser, "string")+",\n")
	}
	if this.GitSHA != nil {
		s = append(s, "GitSHA: "+valueToGoStringMesos(this.GitSHA, "string")+",\n")
	}
	if this.GitBranch != nil {
		s = append(s, "GitBranch: "+valueToGoStringMesos(this.GitBranch, "string")+",\n")
	}
	if this.GitTag != nil {
		s = append(s, "GitTag: "+valueToGoStringMesos(this.GitTag, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Flag) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Flag{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Role) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesos.Role{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Weight: "+fmt.Sprintf("%#v", this.Weight)+",\n")
	if this.Frameworks != nil {
		s = append(s, "Frameworks: "+fmt.Sprintf("%#v", this.Frameworks)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Metric) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Metric{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "float64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FileInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesos.FileInfo{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	if this.Nlink != nil {
		s = append(s, "Nlink: "+valueToGoStringMesos(this.Nlink, "int32")+",\n")
	}
	if this.Size != nil {
		s = append(s, "Size: "+valueToGoStringMesos(this.Size, "uint64")+",\n")
	}
	if this.Mtime != nil {
		s = append(s, "Mtime: "+fmt.Sprintf("%#v", this.Mtime)+",\n")
	}
	if this.Mode != nil {
		s = append(s, "Mode: "+valueToGoStringMesos(this.Mode, "uint32")+",\n")
	}
	if this.UID != nil {
		s = append(s, "UID: "+valueToGoStringMesos(this.UID, "string")+",\n")
	}
	if this.GID != nil {
		s = append(s, "GID: "+valueToGoStringMesos(this.GID, "string")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Device) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Device{")
	if this.Path != nil {
		s = append(s, "Path: "+valueToGoStringMesos(this.Path, "string")+",\n")
	}
	if this.Number != nil {
		s = append(s, "Number: "+fmt.Sprintf("%#v", this.Number)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Device_Number) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.Device_Number{")
	if this.MajorNumber != nil {
		s = append(s, "MajorNumber: "+valueToGoStringMesos(this.MajorNumber, "uint64")+",\n")
	}
	if this.MinorNumber != nil {
		s = append(s, "MinorNumber: "+valueToGoStringMesos(this.MinorNumber, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DeviceAccess) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesos.DeviceAccess{")
	s = append(s, "Device: "+strings.Replace(this.Device.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Access: "+strings.Replace(this.Access.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DeviceAccess_Access) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesos.DeviceAccess_Access{")
	if this.Read != nil {
		s = append(s, "Read: "+valueToGoStringMesos(this.Read, "bool")+",\n")
	}
	if this.Write != nil {
		s = append(s, "Write: "+valueToGoStringMesos(this.Write, "bool")+",\n")
	}
	if this.Mknod != nil {
		s = append(s, "Mknod: "+valueToGoStringMesos(this.Mknod, "bool")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DeviceWhitelist) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesos.DeviceWhitelist{")
	if this.AllowedDevices != nil {
		s = append(s, "AllowedDevices: "+fmt.Sprintf("%#v", this.AllowedDevices)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMesos(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *FrameworkID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FrameworkID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *OfferID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OfferID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *AgentID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *TaskID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *ExecutorID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecutorID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *ContainerID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ContainerID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	if m.Parent != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Parent.ProtoSize()))
		n1, err := m.Parent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	return i, nil
}

func (m *ResourceProviderID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceProviderID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *OperationID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperationID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *TimeInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Nanoseconds))
	return i, nil
}

func (m *DurationInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DurationInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Nanoseconds))
	return i, nil
}

func (m *Address) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Address) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hostname != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Hostname)))
		i += copy(dAtA[i:], *m.Hostname)
	}
	if m.IP != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.IP)))
		i += copy(dAtA[i:], *m.IP)
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Port))
	return i, nil
}

func (m *URL) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *URL) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Scheme)))
	i += copy(dAtA[i:], m.Scheme)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Address.ProtoSize()))
	n2, err := m.Address.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.Path != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if len(m.Query) > 0 {
		for _, msg := range m.Query {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Fragment != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Fragment)))
		i += copy(dAtA[i:], *m.Fragment)
	}
	return i, nil
}

func (m *Unavailability) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Unavailability) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Start.ProtoSize()))
	n3, err := m.Start.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.Duration != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Duration.ProtoSize()))
		n4, err := m.Duration.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *MachineID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MachineID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hostname != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Hostname)))
		i += copy(dAtA[i:], *m.Hostname)
	}
	if m.IP != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.IP)))
		i += copy(dAtA[i:], *m.IP)
	}
	return i, nil
}

func (m *MachineInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MachineInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.ID.ProtoSize()))
	n5, err := m.ID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.Mode != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Mode))
	}
	if m.Unavailability != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Unavailability.ProtoSize()))
		n6, err := m.Unavailability.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *FrameworkInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FrameworkInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.User)))
	i += copy(dAtA[i:], m.User)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.ID != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ID.ProtoSize()))
		n7, err := m.ID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.FailoverTimeout != nil {
		dAtA[i] = 0x21
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.FailoverTimeout))))
	}
	if m.Checkpoint != nil {
		dAtA[i] = 0x28
		i++
		if *m.Checkpoint {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Role != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if m.Hostname != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Hostname)))
		i += copy(dAtA[i:], *m.Hostname)
	}
	if m.Principal != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Principal)))
		i += copy(dAtA[i:], *m.Principal)
	}
	if m.WebUiURL != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.WebUiURL)))
		i += copy(dAtA[i:], *m.WebUiURL)
	}
	if len(m.Capabilities) > 0 {
		for _, msg := range m.Capabilities {
			dAtA[i] = 0x52
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Labels != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n8, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			dAtA[i] = 0x62
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *FrameworkInfo_Capability) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FrameworkInfo_Capability) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *CheckInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.Command != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Command.ProtoSize()))
		n9, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.HTTP != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.HTTP.ProtoSize()))
		n10, err := m.HTTP.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.DelaySeconds != nil {
		dAtA[i] = 0x21
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.DelaySeconds))))
	}
	if m.IntervalSeconds != nil {
		dAtA[i] = 0x29
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.IntervalSeconds))))
	}
	if m.TimeoutSeconds != nil {
		dAtA[i] = 0x31
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.TimeoutSeconds))))
	}
	if m.TCP != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.TCP.ProtoSize()))
		n11, err := m.TCP.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *CheckInfo_Command) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckInfo_Command) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Command.ProtoSize()))
	n12, err := m.Command.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	return i, nil
}

func (m *CheckInfo_Http) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckInfo_Http) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Port))
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	return i, nil
}

func (m *CheckInfo_Tcp) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckInfo_Tcp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Port))
	return i, nil
}

func (m *HealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HTTP != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.HTTP.ProtoSize()))
		n13, err := m.HTTP.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.DelaySeconds != nil {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.DelaySeconds))))
	}
	if m.IntervalSeconds != nil {
		dAtA[i] = 0x19
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.IntervalSeconds))))
	}
	if m.TimeoutSeconds != nil {
		dAtA[i] = 0x21
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.TimeoutSeconds))))
	}
	if m.ConsecutiveFailures != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ConsecutiveFailures))
	}
	if m.GracePeriodSeconds != nil {
		dAtA[i] = 0x31
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.GracePeriodSeconds))))
	}
	if m.Command != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Command.ProtoSize()))
		n14, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	dAtA[i] = 0x40
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.TCP != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.TCP.ProtoSize()))
		n15, err := m.TCP.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *HealthCheck_HTTPCheckInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_HTTPCheckInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Port))
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Path)))
		i += copy(dAtA[i:], *m.Path)
	}
	if m.Scheme != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Scheme)))
		i += copy(dAtA[i:], *m.Scheme)
	}
	if len(m.Statuses) > 0 {
		for _, num := range m.Statuses {
			dAtA[i] = 0x20
			i++
			i = encodeVarintMesos(dAtA, i, uint64(num))
		}
	}
	if m.Protocol != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Protocol))
	}
	return i, nil
}

func (m *HealthCheck_TCPCheckInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheck_TCPCheckInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Port))
	if m.Protocol != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Protocol))
	}
	return i, nil
}

func (m *KillPolicy) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KillPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GracePeriod != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.GracePeriod.ProtoSize()))
		n16, err := m.GracePeriod.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *CommandInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.URIs) > 0 {
		for _, msg := range m.URIs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Environment != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Environment.ProtoSize()))
		n17, err := m.Environment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.Value != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.User != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	if m.Shell != nil {
		dAtA[i] = 0x30
		i++
		if *m.Shell {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Arguments) > 0 {
		for _, s := range m.Arguments {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *CommandInfo_URI) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandInfo_URI) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	if m.Executable != nil {
		dAtA[i] = 0x10
		i++
		if *m.Executable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Extract != nil {
		dAtA[i] = 0x18
		i++
		if *m.Extract {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Cache != nil {
		dAtA[i] = 0x20
		i++
		if *m.Cache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.OutputFile != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.OutputFile)))
		i += copy(dAtA[i:], *m.OutputFile)
	}
	return i, nil
}

func (m *ExecutorInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecutorInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.ExecutorID.ProtoSize()))
	n18, err := m.ExecutorID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if m.Data != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Command != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Command.ProtoSize()))
		n19, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.FrameworkID != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
		n20, err := m.FrameworkID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.Name != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if m.Source != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Source)))
		i += copy(dAtA[i:], *m.Source)
	}
	if m.Container != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Container.ProtoSize()))
		n21, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Discovery != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Discovery.ProtoSize()))
		n22, err := m.Discovery.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.ShutdownGracePeriod != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ShutdownGracePeriod.ProtoSize()))
		n23, err := m.ShutdownGracePeriod.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.Labels != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n24, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	dAtA[i] = 0x78
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *DomainInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DomainInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FaultDomain != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.FaultDomain.ProtoSize()))
		n25, err := m.FaultDomain.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}

func (m *DomainInfo_FaultDomain) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DomainInfo_FaultDomain) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Region.ProtoSize()))
	n26, err := m.Region.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Zone.ProtoSize()))
	n27, err := m.Zone.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	return i, nil
}

func (m *DomainInfo_FaultDomain_RegionInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DomainInfo_FaultDomain_RegionInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	return i, nil
}

func (m *DomainInfo_FaultDomain_ZoneInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DomainInfo_FaultDomain_ZoneInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	return i, nil
}

func (m *MasterInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.ID)))
	i += copy(dAtA[i:], m.ID)
	dAtA[i] = 0x10
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.IP))
	if m.Port == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("port")
	} else {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Port))
	}
	if m.PID != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.PID)))
		i += copy(dAtA[i:], *m.PID)
	}
	if m.Hostname != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Hostname)))
		i += copy(dAtA[i:], *m.Hostname)
	}
	if m.Version != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Version)))
		i += copy(dAtA[i:], *m.Version)
	}
	if m.Address != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Address.ProtoSize()))
		n28, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.Domain != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Domain.ProtoSize()))
		n29, err := m.Domain.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if len(m.Capabilities) > 0 {
		for _, msg := range m.Capabilities {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *MasterInfo_Capability) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterInfo_Capability) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *AgentInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Hostname)))
	i += copy(dAtA[i:], m.Hostname)
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ID != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ID.ProtoSize()))
		n30, err := m.ID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.Port != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Port))
	}
	if m.Domain != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Domain.ProtoSize()))
		n31, err := m.Domain.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	return i, nil
}

func (m *AgentInfo_Capability) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentInfo_Capability) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *CSIPluginContainerInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CSIPluginContainerInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, num := range m.Services {
			dAtA[i] = 0x8
			i++
			i = encodeVarintMesos(dAtA, i, uint64(num))
		}
	}
	if m.Command != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Command.ProtoSize()))
		n32, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Container != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Container.ProtoSize()))
		n33, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	return i, nil
}

func (m *CSIPluginInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CSIPluginInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Type)))
	i += copy(dAtA[i:], m.Type)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if len(m.Containers) > 0 {
		for _, msg := range m.Containers {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ResourceProviderInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceProviderInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ID.ProtoSize()))
		n34, err := m.ID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Type)))
	i += copy(dAtA[i:], m.Type)
	dAtA[i] = 0x22
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if len(m.DefaultReservations) > 0 {
		for _, msg := range m.DefaultReservations {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Storage != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Storage.ProtoSize()))
		n35, err := m.Storage.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	return i, nil
}

func (m *ResourceProviderInfo_Storage) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceProviderInfo_Storage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Plugin.ProtoSize()))
	n36, err := m.Plugin.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n36
	return i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.Scalar != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Scalar.ProtoSize()))
		n37, err := m.Scalar.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.Ranges != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Ranges.ProtoSize()))
		n38, err := m.Ranges.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if m.Set != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Set.ProtoSize()))
		n39, err := m.Set.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if m.Text != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Text.ProtoSize()))
		n40, err := m.Text.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	return i, nil
}

func (m *Value_Scalar) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_Scalar) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(m.Value))))
	return i, nil
}

func (m *Value_Range) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_Range) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Begin))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.End))
	return i, nil
}

func (m *Value_Ranges) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_Ranges) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Range) > 0 {
		for _, msg := range m.Range {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Value_Set) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_Set) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Item) > 0 {
		for _, s := range m.Item {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *Value_Text) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value_Text) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *Attribute) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attribute) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x10
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.Scalar != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Scalar.ProtoSize()))
		n41, err := m.Scalar.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	if m.Ranges != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Ranges.ProtoSize()))
		n42, err := m.Ranges.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.Text != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Text.ProtoSize()))
		n43, err := m.Text.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	if m.Set != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Set.ProtoSize()))
		n44, err := m.Set.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	return i, nil
}

func (m *Resource) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Type))
	}
	if m.Scalar != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Scalar.ProtoSize()))
		n45, err := m.Scalar.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	if m.Ranges != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Ranges.ProtoSize()))
		n46, err := m.Ranges.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	if m.Set != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Set.ProtoSize()))
		n47, err := m.Set.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	if m.Role != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if m.Disk != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Disk.ProtoSize()))
		n48, err := m.Disk.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	if m.Reservation != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Reservation.ProtoSize()))
		n49, err := m.Reservation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	if m.Revocable != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Revocable.ProtoSize()))
		n50, err := m.Revocable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n50
	}
	if m.Shared != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Shared.ProtoSize()))
		n51, err := m.Shared.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	if m.AllocationInfo != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.AllocationInfo.ProtoSize()))
		n52, err := m.AllocationInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	if m.ProviderID != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ProviderID.ProtoSize()))
		n53, err := m.ProviderID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n53
	}
	if len(m.Reservations) > 0 {
		for _, msg := range m.Reservations {
			dAtA[i] = 0x6a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Resource_AllocationInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_AllocationInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	return i, nil
}

func (m *Resource_ReservationInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_ReservationInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principal != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Principal)))
		i += copy(dAtA[i:], *m.Principal)
	}
	if m.Labels != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n54, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n54
	}
	if m.Role != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if m.Type != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Type))
	}
	return i, nil
}

func (m *Resource_DiskInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_DiskInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Persistence != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Persistence.ProtoSize()))
		n55, err := m.Persistence.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	if m.Volume != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Volume.ProtoSize()))
		n56, err := m.Volume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n56
	}
	if m.Source != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Source.ProtoSize()))
		n57, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n57
	}
	return i, nil
}

func (m *Resource_DiskInfo_Persistence) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_DiskInfo_Persistence) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.ID)))
	i += copy(dAtA[i:], m.ID)
	if m.Principal != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Principal)))
		i += copy(dAtA[i:], *m.Principal)
	}
	return i, nil
}

func (m *Resource_DiskInfo_Source) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_DiskInfo_Source) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.Path != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Path.ProtoSize()))
		n58, err := m.Path.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n58
	}
	if m.Mount != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Mount.ProtoSize()))
		n59, err := m.Mount.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n59
	}
	if m.ID != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.ID)))
		i += copy(dAtA[i:], *m.ID)
	}
	if m.Metadata != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Metadata.ProtoSize()))
		n60, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n60
	}
	if m.Profile != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Profile)))
		i += copy(dAtA[i:], *m.Profile)
	}
	return i, nil
}

func (m *Resource_DiskInfo_Source_Path) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_DiskInfo_Source_Path) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Root != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Root)))
		i += copy(dAtA[i:], *m.Root)
	}
	return i, nil
}

func (m *Resource_DiskInfo_Source_Mount) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_DiskInfo_Source_Mount) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Root != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Root)))
		i += copy(dAtA[i:], *m.Root)
	}
	return i, nil
}

func (m *Resource_RevocableInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_RevocableInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *Resource_SharedInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resource_SharedInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TrafficControlStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TrafficControlStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.ID)))
	i += copy(dAtA[i:], m.ID)
	if m.Backlog != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Backlog))
	}
	if m.Bytes != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Bytes))
	}
	if m.Drops != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Drops))
	}
	if m.Overlimits != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Overlimits))
	}
	if m.Packets != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Packets))
	}
	if m.Qlen != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Qlen))
	}
	if m.RateBPS != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RateBPS))
	}
	if m.RatePPS != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RatePPS))
	}
	if m.Requeues != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Requeues))
	}
	return i, nil
}

func (m *IpStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IpStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Forwarding != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Forwarding))
	}
	if m.DefaultTTL != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DefaultTTL))
	}
	if m.InReceives != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InReceives))
	}
	if m.InHdrErrors != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InHdrErrors))
	}
	if m.InAddrErrors != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InAddrErrors))
	}
	if m.ForwDatagrams != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ForwDatagrams))
	}
	if m.InUnknownProtos != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InUnknownProtos))
	}
	if m.InDiscards != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InDiscards))
	}
	if m.InDelivers != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InDelivers))
	}
	if m.OutRequests != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutRequests))
	}
	if m.OutDiscards != nil {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutDiscards))
	}
	if m.OutNoRoutes != nil {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutNoRoutes))
	}
	if m.ReasmTimeout != nil {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ReasmTimeout))
	}
	if m.ReasmReqds != nil {
		dAtA[i] = 0x70
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ReasmReqds))
	}
	if m.ReasmOKs != nil {
		dAtA[i] = 0x78
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ReasmOKs))
	}
	if m.ReasmFails != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ReasmFails))
	}
	if m.FragOKs != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.FragOKs))
	}
	if m.FragFails != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.FragFails))
	}
	if m.FragCreates != nil {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.FragCreates))
	}
	return i, nil
}

func (m *IcmpStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IcmpStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.InMsgs != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InMsgs))
	}
	if m.InErrors != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InErrors))
	}
	if m.InCsumErrors != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InCsumErrors))
	}
	if m.InDestUnreachs != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InDestUnreachs))
	}
	if m.InTimeExcds != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InTimeExcds))
	}
	if m.InParmProbs != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InParmProbs))
	}
	if m.InSrcQuenchs != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InSrcQuenchs))
	}
	if m.InRedirects != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InRedirects))
	}
	if m.InEchos != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InEchos))
	}
	if m.InEchoReps != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InEchoReps))
	}
	if m.InTimestamps != nil {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InTimestamps))
	}
	if m.InTimestampReps != nil {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InTimestampReps))
	}
	if m.InAddrMasks != nil {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InAddrMasks))
	}
	if m.InAddrMaskReps != nil {
		dAtA[i] = 0x70
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InAddrMaskReps))
	}
	if m.OutMsgs != nil {
		dAtA[i] = 0x78
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutMsgs))
	}
	if m.OutErrors != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutErrors))
	}
	if m.OutDestUnreachs != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutDestUnreachs))
	}
	if m.OutTimeExcds != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutTimeExcds))
	}
	if m.OutParmProbs != nil {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutParmProbs))
	}
	if m.OutSrcQuenchs != nil {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutSrcQuenchs))
	}
	if m.OutRedirects != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutRedirects))
	}
	if m.OutEchos != nil {
		dAtA[i] = 0xb0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutEchos))
	}
	if m.OutEchoReps != nil {
		dAtA[i] = 0xb8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutEchoReps))
	}
	if m.OutTimestamps != nil {
		dAtA[i] = 0xc0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutTimestamps))
	}
	if m.OutTimestampReps != nil {
		dAtA[i] = 0xc8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutTimestampReps))
	}
	if m.OutAddrMasks != nil {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutAddrMasks))
	}
	if m.OutAddrMaskReps != nil {
		dAtA[i] = 0xd8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutAddrMaskReps))
	}
	return i, nil
}

func (m *TcpStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TcpStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RtoAlgorithm != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RtoAlgorithm))
	}
	if m.RtoMin != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RtoMin))
	}
	if m.RtoMax != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RtoMax))
	}
	if m.MaxConn != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MaxConn))
	}
	if m.ActiveOpens != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ActiveOpens))
	}
	if m.PassiveOpens != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.PassiveOpens))
	}
	if m.AttemptFails != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.AttemptFails))
	}
	if m.EstabResets != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.EstabResets))
	}
	if m.CurrEstab != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.CurrEstab))
	}
	if m.InSegs != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InSegs))
	}
	if m.OutSegs != nil {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutSegs))
	}
	if m.RetransSegs != nil {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RetransSegs))
	}
	if m.InErrs != nil {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InErrs))
	}
	if m.OutRsts != nil {
		dAtA[i] = 0x70
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutRsts))
	}
	if m.InCsumErrors != nil {
		dAtA[i] = 0x78
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InCsumErrors))
	}
	return i, nil
}

func (m *UdpStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UdpStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.InDatagrams != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InDatagrams))
	}
	if m.NoPorts != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NoPorts))
	}
	if m.InErrors != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InErrors))
	}
	if m.OutDatagrams != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.OutDatagrams))
	}
	if m.RcvbufErrors != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RcvbufErrors))
	}
	if m.SndbufErrors != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.SndbufErrors))
	}
	if m.InCsumErrors != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.InCsumErrors))
	}
	if m.IgnoredMulti != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.IgnoredMulti))
	}
	return i, nil
}

func (m *SNMPStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SNMPStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.IPStats != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.IPStats.ProtoSize()))
		n61, err := m.IPStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n61
	}
	if m.ICMPStats != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ICMPStats.ProtoSize()))
		n62, err := m.ICMPStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n62
	}
	if m.TCPStats != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.TCPStats.ProtoSize()))
		n63, err := m.TCPStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n63
	}
	if m.UDPStats != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.UDPStats.ProtoSize()))
		n64, err := m.UDPStats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n64
	}
	return i, nil
}

func (m *DiskStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DiskStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Source != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Source.ProtoSize()))
		n65, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n65
	}
	if m.Persistence != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Persistence.ProtoSize()))
		n66, err := m.Persistence.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n66
	}
	if m.LimitBytes != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.LimitBytes))
	}
	if m.UsedBytes != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.UsedBytes))
	}
	return i, nil
}

func (m *ResourceStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(m.Timestamp))))
	if m.CPUsUserTimeSecs != nil {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.CPUsUserTimeSecs))))
	}
	if m.CPUsSystemTimeSecs != nil {
		dAtA[i] = 0x19
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.CPUsSystemTimeSecs))))
	}
	if m.CPUsLimit != nil {
		dAtA[i] = 0x21
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.CPUsLimit))))
	}
	if m.MemRSSBytes != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemRSSBytes))
	}
	if m.MemLimitBytes != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemLimitBytes))
	}
	if m.CPUsNrPeriods != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.CPUsNrPeriods))
	}
	if m.CPUsNrThrottled != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.CPUsNrThrottled))
	}
	if m.CPUsThrottledTimeSecs != nil {
		dAtA[i] = 0x49
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.CPUsThrottledTimeSecs))))
	}
	if m.MemFileBytes != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemFileBytes))
	}
	if m.MemAnonBytes != nil {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemAnonBytes))
	}
	if m.MemMappedFileBytes != nil {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemMappedFileBytes))
	}
	if m.Perf != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Perf.ProtoSize()))
		n67, err := m.Perf.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n67
	}
	if m.NetRxPackets != nil {
		dAtA[i] = 0x70
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetRxPackets))
	}
	if m.NetRxBytes != nil {
		dAtA[i] = 0x78
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetRxBytes))
	}
	if m.NetRxErrors != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetRxErrors))
	}
	if m.NetRxDropped != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetRxDropped))
	}
	if m.NetTxPackets != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetTxPackets))
	}
	if m.NetTxBytes != nil {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetTxBytes))
	}
	if m.NetTxErrors != nil {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetTxErrors))
	}
	if m.NetTxDropped != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NetTxDropped))
	}
	if m.NetTCPRttMicrosecsP50 != nil {
		dAtA[i] = 0xb1
		i++
		dAtA[i] = 0x1
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.NetTCPRttMicrosecsP50))))
	}
	if m.NetTCPRttMicrosecsP90 != nil {
		dAtA[i] = 0xb9
		i++
		dAtA[i] = 0x1
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.NetTCPRttMicrosecsP90))))
	}
	if m.NetTCPRttMicrosecsP95 != nil {
		dAtA[i] = 0xc1
		i++
		dAtA[i] = 0x1
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.NetTCPRttMicrosecsP95))))
	}
	if m.NetTCPRttMicrosecsP99 != nil {
		dAtA[i] = 0xc9
		i++
		dAtA[i] = 0x1
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.NetTCPRttMicrosecsP99))))
	}
	if m.DiskLimitBytes != nil {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DiskLimitBytes))
	}
	if m.DiskUsedBytes != nil {
		dAtA[i] = 0xd8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DiskUsedBytes))
	}
	if m.NetTCPActiveConnections != nil {
		dAtA[i] = 0xe1
		i++
		dAtA[i] = 0x1
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.NetTCPActiveConnections))))
	}
	if m.NetTCPTimeWaitConnections != nil {
		dAtA[i] = 0xe9
		i++
		dAtA[i] = 0x1
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.NetTCPTimeWaitConnections))))
	}
	if m.Processes != nil {
		dAtA[i] = 0xf0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Processes))
	}
	if m.Threads != nil {
		dAtA[i] = 0xf8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Threads))
	}
	if m.MemLowPressureCounter != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemLowPressureCounter))
	}
	if m.MemMediumPressureCounter != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemMediumPressureCounter))
	}
	if m.MemCriticalPressureCounter != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemCriticalPressureCounter))
	}
	if len(m.NetTrafficControlStatistics) > 0 {
		for _, msg := range m.NetTrafficControlStatistics {
			dAtA[i] = 0x9a
			i++
			dAtA[i] = 0x2
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MemTotalBytes != nil {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemTotalBytes))
	}
	if m.MemTotalMemswBytes != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemTotalMemswBytes))
	}
	if m.MemSoftLimitBytes != nil {
		dAtA[i] = 0xb0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemSoftLimitBytes))
	}
	if m.MemCacheBytes != nil {
		dAtA[i] = 0xb8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemCacheBytes))
	}
	if m.MemSwapBytes != nil {
		dAtA[i] = 0xc0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemSwapBytes))
	}
	if m.MemUnevictableBytes != nil {
		dAtA[i] = 0xc8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MemUnevictableBytes))
	}
	if m.NetSNMPStatistics != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.NetSNMPStatistics.ProtoSize()))
		n68, err := m.NetSNMPStatistics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n68
	}
	if len(m.DiskStatistics) > 0 {
		for _, msg := range m.DiskStatistics {
			dAtA[i] = 0xda
			i++
			dAtA[i] = 0x2
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.BlkioStatistics != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.BlkioStatistics.ProtoSize()))
		n69, err := m.BlkioStatistics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n69
	}
	return i, nil
}

func (m *ResourceUsage) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceUsage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Executors) > 0 {
		for _, msg := range m.Executors {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Total) > 0 {
		for _, msg := range m.Total {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ResourceUsage_Executor) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceUsage_Executor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.ExecutorInfo.ProtoSize()))
	n70, err := m.ExecutorInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n70
	if len(m.Allocated) > 0 {
		for _, msg := range m.Allocated {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Statistics != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Statistics.ProtoSize()))
		n71, err := m.Statistics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n71
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n72, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n72
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ResourceUsage_Executor_Task) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceUsage_Executor_Task) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.ID.ProtoSize()))
	n73, err := m.ID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n73
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Labels != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n74, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n74
	}
	return i, nil
}

func (m *PerfStatistics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PerfStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(m.Timestamp))))
	dAtA[i] = 0x11
	i++
	i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(m.Duration))))
	if m.Cycles != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Cycles))
	}
	if m.StalledCyclesFrontend != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.StalledCyclesFrontend))
	}
	if m.StalledCyclesBackend != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.StalledCyclesBackend))
	}
	if m.Instructions != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Instructions))
	}
	if m.CacheReferences != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.CacheReferences))
	}
	if m.CacheMisses != nil {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.CacheMisses))
	}
	if m.Branches != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Branches))
	}
	if m.BranchMisses != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.BranchMisses))
	}
	if m.BusCycles != nil {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.BusCycles))
	}
	if m.RefCycles != nil {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.RefCycles))
	}
	if m.CPUClock != nil {
		dAtA[i] = 0x69
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.CPUClock))))
	}
	if m.TaskClock != nil {
		dAtA[i] = 0x71
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.TaskClock))))
	}
	if m.PageFaults != nil {
		dAtA[i] = 0x78
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.PageFaults))
	}
	if m.MinorFaults != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MinorFaults))
	}
	if m.MajorFaults != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.MajorFaults))
	}
	if m.ContextSwitches != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ContextSwitches))
	}
	if m.CPUMigrations != nil {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.CPUMigrations))
	}
	if m.AlignmentFaults != nil {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.AlignmentFaults))
	}
	if m.EmulationFaults != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.EmulationFaults))
	}
	if m.L1DcacheLoads != nil {
		dAtA[i] = 0xb0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1DcacheLoads))
	}
	if m.L1DcacheLoadMisses != nil {
		dAtA[i] = 0xb8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1DcacheLoadMisses))
	}
	if m.L1DcacheStores != nil {
		dAtA[i] = 0xc0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1DcacheStores))
	}
	if m.L1DcacheStoreMisses != nil {
		dAtA[i] = 0xc8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1DcacheStoreMisses))
	}
	if m.L1DcachePrefetches != nil {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1DcachePrefetches))
	}
	if m.L1DcachePrefetchMisses != nil {
		dAtA[i] = 0xd8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1DcachePrefetchMisses))
	}
	if m.L1IcacheLoads != nil {
		dAtA[i] = 0xe0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1IcacheLoads))
	}
	if m.L1IcacheLoadMisses != nil {
		dAtA[i] = 0xe8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1IcacheLoadMisses))
	}
	if m.L1IcachePrefetches != nil {
		dAtA[i] = 0xf0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1IcachePrefetches))
	}
	if m.L1IcachePrefetchMisses != nil {
		dAtA[i] = 0xf8
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.L1IcachePrefetchMisses))
	}
	if m.LLCLoads != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.LLCLoads))
	}
	if m.LLCLoadMisses != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.LLCLoadMisses))
	}
	if m.LLCStores != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.LLCStores))
	}
	if m.LLCStoreMisses != nil {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.LLCStoreMisses))
	}
	if m.LLCPrefetches != nil {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.LLCPrefetches))
	}
	if m.LLCPrefetchMisses != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.LLCPrefetchMisses))
	}
	if m.DTLBLoads != nil {
		dAtA[i] = 0xb0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DTLBLoads))
	}
	if m.DTLBLoadMisses != nil {
		dAtA[i] = 0xb8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DTLBLoadMisses))
	}
	if m.DTLBStores != nil {
		dAtA[i] = 0xc0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DTLBStores))
	}
	if m.DTLBStoreMisses != nil {
		dAtA[i] = 0xc8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DTLBStoreMisses))
	}
	if m.DTLBPrefetches != nil {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DTLBPrefetches))
	}
	if m.DTLBPrefetchMisses != nil {
		dAtA[i] = 0xd8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.DTLBPrefetchMisses))
	}
	if m.ITLBLoads != nil {
		dAtA[i] = 0xe0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ITLBLoads))
	}
	if m.ITLBLoadMisses != nil {
		dAtA[i] = 0xe8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ITLBLoadMisses))
	}
	if m.BranchLoads != nil {
		dAtA[i] = 0xf0
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.BranchLoads))
	}
	if m.BranchLoadMisses != nil {
		dAtA[i] = 0xf8
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.BranchLoadMisses))
	}
	if m.NodeLoads != nil {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x3
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NodeLoads))
	}
	if m.NodeLoadMisses != nil {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x3
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NodeLoadMisses))
	}
	if m.NodeStores != nil {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x3
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NodeStores))
	}
	if m.NodeStoreMisses != nil {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x3
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NodeStoreMisses))
	}
	if m.NodePrefetches != nil {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x3
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NodePrefetches))
	}
	if m.NodePrefetchMisses != nil {
		dAtA[i] = 0xa8
		i++
		dAtA[i] = 0x3
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.NodePrefetchMisses))
	}
	return i, nil
}

func (m *Request) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Request) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AgentID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.AgentID.ProtoSize()))
		n75, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n75
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Offer) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.ID.ProtoSize()))
	n76, err := m.ID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n76
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
	n77, err := m.FrameworkID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n77
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n78, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n78
	dAtA[i] = 0x22
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Hostname)))
	i += copy(dAtA[i:], m.Hostname)
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ExecutorIDs) > 0 {
		for _, msg := range m.ExecutorIDs {
			dAtA[i] = 0x32
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.URL != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.URL.ProtoSize()))
		n79, err := m.URL.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n79
	}
	if m.Unavailability != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Unavailability.ProtoSize()))
		n80, err := m.Unavailability.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n80
	}
	if m.AllocationInfo != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.AllocationInfo.ProtoSize()))
		n81, err := m.AllocationInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n81
	}
	if m.Domain != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Domain.ProtoSize()))
		n82, err := m.Domain.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n82
	}
	return i, nil
}

func (m *Offer_Operation) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.Launch != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Launch.ProtoSize()))
		n83, err := m.Launch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n83
	}
	if m.Reserve != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Reserve.ProtoSize()))
		n84, err := m.Reserve.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n84
	}
	if m.Unreserve != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Unreserve.ProtoSize()))
		n85, err := m.Unreserve.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n85
	}
	if m.Create != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Create.ProtoSize()))
		n86, err := m.Create.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n86
	}
	if m.Destroy != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Destroy.ProtoSize()))
		n87, err := m.Destroy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n87
	}
	if m.LaunchGroup != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.LaunchGroup.ProtoSize()))
		n88, err := m.LaunchGroup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n88
	}
	if m.CreateVolume != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.CreateVolume.ProtoSize()))
		n89, err := m.CreateVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n89
	}
	if m.DestroyVolume != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.DestroyVolume.ProtoSize()))
		n90, err := m.DestroyVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n90
	}
	if m.CreateBlock != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.CreateBlock.ProtoSize()))
		n91, err := m.CreateBlock.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n91
	}
	if m.DestroyBlock != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.DestroyBlock.ProtoSize()))
		n92, err := m.DestroyBlock.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n92
	}
	if m.ID != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ID.ProtoSize()))
		n93, err := m.ID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n93
	}
	return i, nil
}

func (m *Offer_Operation_Launch) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_Launch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for _, msg := range m.TaskInfos {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Offer_Operation_LaunchGroup) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_LaunchGroup) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Executor.ProtoSize()))
	n94, err := m.Executor.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n94
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.TaskGroup.ProtoSize()))
	n95, err := m.TaskGroup.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n95
	return i, nil
}

func (m *Offer_Operation_Reserve) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_Reserve) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Offer_Operation_Unreserve) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_Unreserve) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Offer_Operation_Create) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_Create) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Offer_Operation_Destroy) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_Destroy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Offer_Operation_CreateVolume) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_CreateVolume) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Source.ProtoSize()))
	n96, err := m.Source.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n96
	dAtA[i] = 0x10
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.TargetType))
	return i, nil
}

func (m *Offer_Operation_DestroyVolume) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_DestroyVolume) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Volume.ProtoSize()))
	n97, err := m.Volume.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n97
	return i, nil
}

func (m *Offer_Operation_CreateBlock) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_CreateBlock) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Source.ProtoSize()))
	n98, err := m.Source.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n98
	return i, nil
}

func (m *Offer_Operation_DestroyBlock) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Offer_Operation_DestroyBlock) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Block.ProtoSize()))
	n99, err := m.Block.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n99
	return i, nil
}

func (m *InverseOffer) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InverseOffer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.OfferID.ProtoSize()))
	n100, err := m.OfferID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n100
	if m.URL != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.URL.ProtoSize()))
		n101, err := m.URL.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n101
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
	n102, err := m.FrameworkID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n102
	if m.AgentID != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.AgentID.ProtoSize()))
		n103, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n103
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Unavailability.ProtoSize()))
	n104, err := m.Unavailability.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n104
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x32
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TaskInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.TaskID.ProtoSize()))
	n105, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n105
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n106, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n106
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Executor != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Executor.ProtoSize()))
		n107, err := m.Executor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n107
	}
	if m.Data != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.Command != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Command.ProtoSize()))
		n108, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n108
	}
	if m.HealthCheck != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.HealthCheck.ProtoSize()))
		n109, err := m.HealthCheck.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n109
	}
	if m.Container != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Container.ProtoSize()))
		n110, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n110
	}
	if m.Labels != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n111, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n111
	}
	if m.Discovery != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Discovery.ProtoSize()))
		n112, err := m.Discovery.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n112
	}
	if m.KillPolicy != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.KillPolicy.ProtoSize()))
		n113, err := m.KillPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n113
	}
	if m.Check != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Check.ProtoSize()))
		n114, err := m.Check.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n114
	}
	return i, nil
}

func (m *TaskGroupInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskGroupInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Task) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Task) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.TaskID.ProtoSize()))
	n115, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n115
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
	n116, err := m.FrameworkID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n116
	if m.ExecutorID != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ExecutorID.ProtoSize()))
		n117, err := m.ExecutorID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n117
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.AgentID.ProtoSize()))
	n118, err := m.AgentID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n118
	if m.State == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("state")
	} else {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.State))
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Statuses) > 0 {
		for _, msg := range m.Statuses {
			dAtA[i] = 0x42
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StatusUpdateState != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.StatusUpdateState))
	}
	if m.StatusUpdateUUID != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(m.StatusUpdateUUID)))
		i += copy(dAtA[i:], m.StatusUpdateUUID)
	}
	if m.Labels != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n119, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n119
	}
	if m.Discovery != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Discovery.ProtoSize()))
		n120, err := m.Discovery.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n120
	}
	if m.Container != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Container.ProtoSize()))
		n121, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n121
	}
	if m.User != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.User)))
		i += copy(dAtA[i:], *m.User)
	}
	return i, nil
}

func (m *TaskResourceLimitation) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskResourceLimitation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *UUID) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UUID) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *Operation) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Operation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FrameworkID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
		n122, err := m.FrameworkID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n122
	}
	if m.AgentID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.AgentID.ProtoSize()))
		n123, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n123
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Info.ProtoSize()))
	n124, err := m.Info.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n124
	dAtA[i] = 0x22
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.LatestStatus.ProtoSize()))
	n125, err := m.LatestStatus.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n125
	if len(m.Statuses) > 0 {
		for _, msg := range m.Statuses {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.UUID.ProtoSize()))
	n126, err := m.UUID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n126
	return i, nil
}

func (m *OperationStatus) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperationStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.OperationID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.OperationID.ProtoSize()))
		n127, err := m.OperationID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n127
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.State))
	if m.Message != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if len(m.ConvertedResources) > 0 {
		for _, msg := range m.ConvertedResources {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UUID != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.UUID.ProtoSize()))
		n128, err := m.UUID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n128
	}
	return i, nil
}

func (m *CheckStatusInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckStatusInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Type))
	}
	if m.Command != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Command.ProtoSize()))
		n129, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n129
	}
	if m.HTTP != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.HTTP.ProtoSize()))
		n130, err := m.HTTP.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n130
	}
	if m.TCP != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.TCP.ProtoSize()))
		n131, err := m.TCP.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n131
	}
	return i, nil
}

func (m *CheckStatusInfo_Command) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckStatusInfo_Command) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ExitCode != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.ExitCode))
	}
	return i, nil
}

func (m *CheckStatusInfo_Http) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckStatusInfo_Http) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StatusCode != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.StatusCode))
	}
	return i, nil
}

func (m *CheckStatusInfo_Tcp) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckStatusInfo_Tcp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Succeeded != nil {
		dAtA[i] = 0x8
		i++
		if *m.Succeeded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *TaskStatus) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TaskStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.TaskID.ProtoSize()))
	n132, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n132
	if m.State == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("state")
	} else {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.State))
	}
	if m.Data != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.Message != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Message)))
		i += copy(dAtA[i:], *m.Message)
	}
	if m.AgentID != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.AgentID.ProtoSize()))
		n133, err := m.AgentID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n133
	}
	if m.Timestamp != nil {
		dAtA[i] = 0x31
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.Timestamp))))
	}
	if m.ExecutorID != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ExecutorID.ProtoSize()))
		n134, err := m.ExecutorID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n134
	}
	if m.Healthy != nil {
		dAtA[i] = 0x40
		i++
		if *m.Healthy {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Source != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Source))
	}
	if m.Reason != nil {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Reason))
	}
	if m.UUID != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(m.UUID)))
		i += copy(dAtA[i:], m.UUID)
	}
	if m.Labels != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n135, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n135
	}
	if m.ContainerStatus != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.ContainerStatus.ProtoSize()))
		n136, err := m.ContainerStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n136
	}
	if m.UnreachableTime != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.UnreachableTime.ProtoSize()))
		n137, err := m.UnreachableTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n137
	}
	if m.CheckStatus != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.CheckStatus.ProtoSize()))
		n138, err := m.CheckStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n138
	}
	if m.Limitation != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Limitation.ProtoSize()))
		n139, err := m.Limitation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n139
	}
	return i, nil
}

func (m *Filters) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Filters) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RefuseSeconds != nil {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.RefuseSeconds))))
	}
	return i, nil
}

func (m *Environment) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Environment) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for _, msg := range m.Variables {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Environment_Variable) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Environment_Variable) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Value)))
		i += copy(dAtA[i:], *m.Value)
	}
	if m.Type != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Type))
	}
	if m.Secret != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Secret.ProtoSize()))
		n140, err := m.Secret.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n140
	}
	return i, nil
}

func (m *Parameter) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Parameter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Key)))
	i += copy(dAtA[i:], m.Key)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *Parameters) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Parameters) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Parameter) > 0 {
		for _, msg := range m.Parameter {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Credential) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Credential) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Principal)))
	i += copy(dAtA[i:], m.Principal)
	if m.Secret != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Secret)))
		i += copy(dAtA[i:], *m.Secret)
	}
	return i, nil
}

func (m *Credentials) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Credentials) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Credentials) > 0 {
		for _, msg := range m.Credentials {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Secret) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Secret) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.Reference != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Reference.ProtoSize()))
		n141, err := m.Reference.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n141
	}
	if m.Value != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Value.ProtoSize()))
		n142, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n142
	}
	return i, nil
}

func (m *Secret_Reference) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Secret_Reference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.Key != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Key)))
		i += copy(dAtA[i:], *m.Key)
	}
	return i, nil
}

func (m *Secret_Value) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Secret_Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Data == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *RateLimit) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.QPS != nil {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.QPS))))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Principal)))
	i += copy(dAtA[i:], m.Principal)
	if m.Capacity != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Capacity))
	}
	return i, nil
}

func (m *RateLimits) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimits) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for _, msg := range m.Limits {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AggregateDefaultQPS != nil {
		dAtA[i] = 0x11
		i++
		i = encodeFixed64Mesos(dAtA, i, uint64(math.Float64bits(float64(*m.AggregateDefaultQPS))))
	}
	if m.AggregateDefaultCapacity != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.AggregateDefaultCapacity))
	}
	return i, nil
}

func (m *Image) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Image) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Type))
	}
	if m.Appc != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Appc.ProtoSize()))
		n143, err := m.Appc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n143
	}
	if m.Docker != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Docker.ProtoSize()))
		n144, err := m.Docker.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n144
	}
	if m.Cached != nil {
		dAtA[i] = 0x20
		i++
		if *m.Cached {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Image_Appc) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Image_Appc) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.ID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.ID)))
		i += copy(dAtA[i:], *m.ID)
	}
	if m.Labels != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n145, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n145
	}
	return i, nil
}

func (m *Image_Docker) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Image_Docker) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.Credential != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Credential.ProtoSize()))
		n146, err := m.Credential.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n146
	}
	if m.Config != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Config.ProtoSize()))
		n147, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n147
	}
	return i, nil
}

func (m *MountPropagation) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MountPropagation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Mode != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Mode))
	}
	return i, nil
}

func (m *Volume) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Volume) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.ContainerPath)))
	i += copy(dAtA[i:], m.ContainerPath)
	if m.HostPath != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.HostPath)))
		i += copy(dAtA[i:], *m.HostPath)
	}
	if m.Mode == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("mode")
	} else {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Mode))
	}
	if m.Image != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Image.ProtoSize()))
		n148, err := m.Image.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n148
	}
	if m.Source != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Source.ProtoSize()))
		n149, err := m.Source.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n149
	}
	return i, nil
}

func (m *Volume_Source) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Volume_Source) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	if m.DockerVolume != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.DockerVolume.ProtoSize()))
		n150, err := m.DockerVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n150
	}
	if m.SandboxPath != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.SandboxPath.ProtoSize()))
		n151, err := m.SandboxPath.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n151
	}
	if m.Secret != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Secret.ProtoSize()))
		n152, err := m.Secret.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n152
	}
	if m.HostPath != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.HostPath.ProtoSize()))
		n153, err := m.HostPath.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n153
	}
	return i, nil
}

func (m *Volume_Source_DockerVolume) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Volume_Source_DockerVolume) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Driver != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Driver)))
		i += copy(dAtA[i:], *m.Driver)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if m.DriverOptions != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.DriverOptions.ProtoSize()))
		n154, err := m.DriverOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n154
	}
	return i, nil
}

func (m *Volume_Source_HostPath) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Volume_Source_HostPath) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	if m.MountPropagation != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.MountPropagation.ProtoSize()))
		n155, err := m.MountPropagation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n155
	}
	return i, nil
}

func (m *Volume_Source_SandboxPath) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Volume_Source_SandboxPath) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMesos(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	return i, nil
}

func (m *NetworkInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Groups) > 0 {
		for _, s := range m.Groups {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Labels != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.Labels.ProtoSize()))
		n156, err := m.Labels.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n156
	}
	if len(m.IPAddresses) > 0 {
		for _, msg := range m.IPAddresses {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Name != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Name)))
		i += copy(dAtA[i:], *m.Name)
	}
	if len(m.PortMappings) > 0 {
		for _, msg := range m.PortMappings {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintMesos(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NetworkInfo_IPAddress) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkInfo_IPAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Protocol != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMesos(dAtA, i, uint64(*m.Protocol))
	}
	if m.IPAddress != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.IPAddress)))
		i += copy(dAtA[i:], *m.IPAddress)
	}
	return i, nil
}

func (m *NetworkInfo_PortMapping) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkInfo_PortMapping) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.HostPort))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMesos(dAtA, i, uint64(m.ContainerPort))
	if m.Protocol != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(len(*m.Protocol)))
		i += copy(dAtA[i:], *m.Protocol)
	}
	return i, nil
}

func (m *CapabilityInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CapabilityInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Capabilities) > 0 {
		for _, num := range m.Capabilities {
			dAtA[i] = 0x8
			i++
			i = encodeVarintMesos(dAtA, i, uint64(num))
		}
	}
	return i, nil
}

func (m *LinuxInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinuxInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CapabilityInfo != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.CapabilityInfo.ProtoSize()))
		n157, err := m.CapabilityInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n157
	}
	if m.BoundingCapabilities != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.BoundingCapabilities.ProtoSize()))
		n158, err := m.BoundingCapabilities.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n158
	}
	if m.EffectiveCapabilities != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMesos(dAtA, i, uint64(m.EffectiveCapabilities.ProtoSize()))
		n159, err := m.EffectiveCapabilities.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n159
	}
	if m.SharePIDNamespace != nil {
		dAtA[i] = 0x20
		i++
		if *m.SharePIDNamespace {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RLimitInfo) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RLimitInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rlimits) > 0 {
		for _, msg := range m.Rlimits {
			dAtA[i] = 0xa
			i++
			i = encodeVa